/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc;

import de.undercouch.citeproc.ItemDataProvider;
import de.undercouch.citeproc.csl.CSLItemData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class CompoundItemDataProvider
implements ItemDataProvider {
    private final List<ItemDataProvider> providers;

    public CompoundItemDataProvider(List<ItemDataProvider> providers) {
        this.providers = providers;
    }

    @Override
    public CSLItemData retrieveItem(String id) {
        return this.providers.stream().map(p -> p.retrieveItem(id)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public Collection<String> getIds() {
        ArrayList<String> result = new ArrayList<String>();
        for (ItemDataProvider p : this.providers) {
            result.addAll(p.getIds());
        }
        return result;
    }
}

