/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBus;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerSet
implements Set<String>,
DBusSigHandler<DBus.NameOwnerChanged> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Set<String> addresses = new TreeSet<String>();

    public PeerSet(DBusConnection _connection) {
        try {
            _connection.addSigHandler(new DBusMatchRule(DBus.NameOwnerChanged.class, null, null), this);
        }
        catch (DBusException dbe) {
            this.logger.debug("", (Throwable)dbe);
        }
    }

    @Override
    public void handle(DBus.NameOwnerChanged _noc) {
        this.logger.debug("Received NameOwnerChanged({}, {}, {})", new Object[]{_noc.name, _noc.oldOwner, _noc.newOwner});
        if ("".equals(_noc.newOwner) && this.addresses.contains(_noc.name)) {
            this.remove(_noc.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(String _address) {
        this.logger.debug("Adding {}", (Object)_address);
        Set<String> set = this.addresses;
        synchronized (set) {
            return this.addresses.add(_address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends String> _addresses) {
        Set<String> set = this.addresses;
        synchronized (set) {
            return this.addresses.addAll(_addresses);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Set<String> set = this.addresses;
        synchronized (set) {
            this.addresses.clear();
        }
    }

    @Override
    public boolean contains(Object _o) {
        return this.addresses.contains(_o);
    }

    @Override
    public boolean containsAll(Collection<?> _os) {
        return this.addresses.containsAll(_os);
    }

    @Override
    public boolean equals(Object _o) {
        if (_o instanceof PeerSet) {
            return ((PeerSet)_o).addresses.equals(this.addresses);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.addresses.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.addresses.isEmpty();
    }

    @Override
    public Iterator<String> iterator() {
        return this.addresses.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object _o) {
        this.logger.debug("Removing {}", _o);
        Set<String> set = this.addresses;
        synchronized (set) {
            return this.addresses.remove(_o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> _os) {
        Set<String> set = this.addresses;
        synchronized (set) {
            return this.addresses.removeAll(_os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> _os) {
        Set<String> set = this.addresses;
        synchronized (set) {
            return this.addresses.retainAll(_os);
        }
    }

    @Override
    public int size() {
        return this.addresses.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Set<String> set = this.addresses;
        synchronized (set) {
            return this.addresses.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] _a) {
        Set<String> set = this.addresses;
        synchronized (set) {
            return this.addresses.toArray(_a);
        }
    }
}

