/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.token;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Collections;
import java.util.List;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.elements.AbstractJEuclidElement;
import net.sourceforge.jeuclid.elements.support.text.StringUtil;
import net.sourceforge.jeuclid.layout.LayoutInfo;
import net.sourceforge.jeuclid.layout.LayoutStage;
import net.sourceforge.jeuclid.layout.LayoutView;
import net.sourceforge.jeuclid.layout.LayoutableNode;
import net.sourceforge.jeuclid.layout.TextObject;
import org.apache.batik.dom.AbstractDocument;
import org.w3c.dom.mathml.MathMLPresentationToken;

public abstract class AbstractTokenWithTextLayout
extends AbstractJEuclidElement
implements MathMLPresentationToken {
    private static final long serialVersionUID = 1L;

    public AbstractTokenWithTextLayout(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
    }

    @Override
    public void layoutStageInvariant(LayoutView layoutView, LayoutInfo layoutInfo, LayoutStage layoutStage, LayoutContext layoutContext) {
        Graphics2D graphics2D = layoutView.getGraphics();
        TextLayout textLayout = this.produceTextLayout(graphics2D, layoutContext);
        if (textLayout != null) {
            StringUtil.TextLayoutInfo textLayoutInfo = StringUtil.getTextLayoutInfo(textLayout, false);
            layoutInfo.setAscentHeight(textLayoutInfo.getAscent(), layoutStage);
            layoutInfo.setDescentHeight(textLayoutInfo.getDescent(), layoutStage);
            float f = textLayoutInfo.getWidth();
            layoutInfo.setHorizontalCenterOffset(f / 2.0f, layoutStage);
            layoutInfo.setWidth(f, layoutStage);
            layoutInfo.setGraphicsObject(new TextObject(textLayout, textLayoutInfo.getOffset(), (Color)this.applyLocalAttributesToContext(layoutContext).getParameter(Parameter.MATHCOLOR)));
        }
    }

    private TextLayout produceTextLayout(Graphics2D graphics2D, LayoutContext layoutContext) {
        LayoutContext layoutContext2 = this.applyLocalAttributesToContext(layoutContext);
        AttributedCharacterIterator attributedCharacterIterator = StringUtil.textContentAsAttributedCharacterIterator(layoutContext2, this, this, 1.0f);
        if (attributedCharacterIterator.getBeginIndex() == attributedCharacterIterator.getEndIndex()) {
            return null;
        }
        TextLayout textLayout = StringUtil.createTextLayoutFromAttributedString(graphics2D, new AttributedString(attributedCharacterIterator), layoutContext2);
        return textLayout;
    }

    @Override
    public List<LayoutableNode> getChildrenToLayout() {
        return Collections.emptyList();
    }

    @Override
    public List<LayoutableNode> getChildrenToDraw() {
        return Collections.emptyList();
    }
}

