/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.HelpFormatter;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.gradle.internal.classpath.Instrumented;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.profile.InternalProfiler;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.profile.ProfilerOptionFormatter;
import org.openjdk.jmh.profile.ProfilerUtils;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.TextResult;
import org.openjdk.jmh.runner.IterationType;
import org.openjdk.jmh.util.JDKVersion;
import org.openjdk.jmh.util.Utils;

public final class JavaFlightRecorderProfiler
implements ExternalProfiler,
InternalProfiler {
    private final boolean verbose;
    private final File outDir;
    private final boolean debugNonSafePoints;
    private final String configName;
    private final Collection<String> flightRecorderOptions;
    private PostProcessor postProcessor;
    private boolean measurementStarted;
    private int measurementIterationCount;
    private String profileName;
    private final List<File> generated;

    public JavaFlightRecorderProfiler(String initLine) throws ProfilerException {
        block5: {
            this.flightRecorderOptions = new ArrayList<String>();
            this.postProcessor = null;
            this.measurementStarted = false;
            this.generated = new ArrayList<File>();
            OptionParser parser = new OptionParser();
            parser.formatHelpWith((HelpFormatter)new ProfilerOptionFormatter("jfr"));
            ArgumentAcceptingOptionSpec optDir = parser.accepts("dir", "Output directory.").withRequiredArg().ofType(String.class).describedAs("dir");
            ArgumentAcceptingOptionSpec optConfig = parser.accepts("configName", "Name of a predefined Flight Recorder configuration, e.g. profile or default").withRequiredArg().ofType(String.class).describedAs("name").defaultsTo((Object)"profile", (Object[])new String[0]);
            ArgumentAcceptingOptionSpec optDebugNonSafePoints = parser.accepts("debugNonSafePoints", "Gather cpu samples asynchronously, rather than at the subsequent safepoint.").withRequiredArg().ofType(Boolean.class).describedAs("bool").defaultsTo((Object)true, (Object[])new Boolean[0]);
            ArgumentAcceptingOptionSpec optStackDepth = parser.accepts("stackDepth", "Maximum number of stack frames collected for each event.").withRequiredArg().ofType(Integer.class).describedAs("frames");
            ArgumentAcceptingOptionSpec optPostProcessor = parser.accepts("postProcessor", "The fully qualified name of a class that implements " + PostProcessor.class + ". This must have a public, no-argument constructor.").withRequiredArg().ofType(String.class).describedAs("fqcn");
            ArgumentAcceptingOptionSpec optVerbose = parser.accepts("verbose", "Output the sequence of commands").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)false, (Object[])new Boolean[0]).describedAs("bool");
            OptionSet set = ProfilerUtils.parseInitLine(initLine, parser);
            try {
                this.debugNonSafePoints = (Boolean)optDebugNonSafePoints.value(set);
                this.configName = (String)optConfig.value(set);
                if (set.has((OptionSpec)optStackDepth)) {
                    this.flightRecorderOptions.add("stackdepth=" + optStackDepth.value(set));
                }
                this.verbose = (Boolean)optVerbose.value(set);
                this.outDir = !set.has((OptionSpec)optDir) ? new File(Instrumented.systemProperty((String)"user.dir", (String)"org.openjdk.jmh.profile.JavaFlightRecorderProfiler")) : new File((String)set.valueOf((OptionSpec)optDir));
                if (!set.has((OptionSpec)optPostProcessor)) break block5;
                try {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    Class<?> postProcessorClass = loader.loadClass((String)optPostProcessor.value(set));
                    this.postProcessor = (PostProcessor)postProcessorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw new ProfilerException(e);
                }
            }
            catch (OptionException e) {
                throw new ProfilerException(e.getMessage());
            }
        }
    }

    @Override
    public void beforeIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        if (iterationParams.getType() == IterationType.MEASUREMENT && !this.measurementStarted) {
            this.profileName = benchmarkParams.id();
            this.execute(benchmarkParams.getJvm(), "JFR.start", Collections.singletonList("settings=" + this.configName));
            this.measurementStarted = true;
        }
    }

    @Override
    public Collection<? extends Result> afterIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams, IterationResult iterationResult) {
        if (iterationParams.getType() == IterationType.MEASUREMENT) {
            ++this.measurementIterationCount;
            if (this.measurementIterationCount == iterationParams.getCount()) {
                File trialOutDir = this.createTrialOutDir(benchmarkParams);
                File jfrFile = new File(trialOutDir, "profile.jfr");
                String filenameOption = "filename=" + jfrFile.getAbsolutePath();
                this.execute(benchmarkParams.getJvm(), "JFR.stop", Collections.singletonList(filenameOption));
                this.generated.add(jfrFile);
                if (this.postProcessor != null) {
                    this.generated.addAll(this.postProcessor.postProcess(benchmarkParams, jfrFile));
                }
                return Collections.singletonList(this.result());
            }
        }
        return Collections.emptyList();
    }

    private TextResult result() {
        StringWriter output = new StringWriter();
        PrintWriter pw = new PrintWriter(output);
        pw.println("JFR profiler results:");
        for (File file : this.generated) {
            pw.print("  ");
            pw.println(file.getPath());
        }
        pw.flush();
        pw.close();
        return new TextResult(output.toString(), "jfr");
    }

    private File createTrialOutDir(BenchmarkParams benchmarkParams) {
        String fileName = benchmarkParams.id();
        File trialOutDir = new File(this.outDir, fileName);
        trialOutDir.mkdirs();
        return trialOutDir;
    }

    private void execute(String jvm, String cmd, Collection<String> options) {
        Collection<String> errorOutput;
        long pid = Utils.getPid();
        ArrayList<String> fullCommand = new ArrayList<String>();
        fullCommand.add(this.findJcmd(jvm).getAbsolutePath());
        fullCommand.add(String.valueOf(pid));
        fullCommand.add(cmd);
        fullCommand.add("name=" + this.profileName);
        fullCommand.addAll(options);
        if (this.verbose) {
            System.out.println("[jfr] " + fullCommand);
        }
        if (!(errorOutput = Utils.tryWith(fullCommand.toArray(new String[0]))).isEmpty()) {
            throw new RuntimeException("Error executing: " + fullCommand + System.lineSeparator() + Utils.join(errorOutput, System.lineSeparator()));
        }
    }

    private File findJcmd(String jvm) {
        File bin = new File(jvm).getParentFile();
        File jcmd = new File(bin, "jcmd" + (Utils.isWindows() ? ".exe" : ""));
        if (FileInterceptorsDeclaration.intercept_exists((File)jcmd, (String)"org.openjdk.jmh.profile.JavaFlightRecorderProfiler")) {
            return jcmd;
        }
        String s = File.separator;
        File jcmd2 = new File(bin, ".." + s + ".." + s + "bin" + s + "jcmd" + (Utils.isWindows() ? ".exe" : ""));
        if (FileInterceptorsDeclaration.intercept_exists((File)jcmd2, (String)"org.openjdk.jmh.profile.JavaFlightRecorderProfiler")) {
            return jcmd2;
        }
        throw new IllegalStateException("Cannot find jcmd anywhere");
    }

    @Override
    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        return Collections.emptyList();
    }

    @Override
    public Collection<String> addJVMOptions(BenchmarkParams params) {
        ArrayList<String> args = new ArrayList<String>();
        if (this.debugNonSafePoints) {
            args.add("-XX:+UnlockDiagnosticVMOptions");
            args.add("-XX:+DebugNonSafepoints");
        }
        if (!this.flightRecorderOptions.isEmpty()) {
            args.add("-XX:FlightRecorderOptions=" + Utils.join(this.flightRecorderOptions, ","));
        }
        if (JDKVersion.parseMajor(params.getJdkVersion()) < 13) {
            args.add("-XX:+FlightRecorder");
        }
        return args;
    }

    @Override
    public void beforeTrial(BenchmarkParams benchmarkParams) {
    }

    @Override
    public Collection<? extends Result> afterTrial(BenchmarkResult br, long pid, File stdOut, File stdErr) {
        return Collections.emptyList();
    }

    @Override
    public boolean allowPrintOut() {
        return true;
    }

    @Override
    public boolean allowPrintErr() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Java Flight Recorder profiler";
    }

    public static interface PostProcessor {
        public List<File> postProcess(BenchmarkParams var1, File var2);
    }
}

