/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations;

import java.util.Optional;
import org.javamodularity.moduleplugin.shadow.javaparser.ParserConfiguration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.NodeList;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.VariableDeclarationExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt.ForEachStmt;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.type.PrimitiveType;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.type.Type;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.ReservedKeywordValidator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.SingleNodeTypeValidator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.TreeVisitorValidator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.Validator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java1_4Validator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.UpgradeJavaMessage;

public class Java5Validator
extends Java1_4Validator {
    final Validator genericsWithoutDiamondOperator = new TreeVisitorValidator((node, reporter) -> {
        Optional<NodeList<Type>> typeArguments;
        if (node instanceof NodeWithTypeArguments && (typeArguments = ((NodeWithTypeArguments)((Object)node)).getTypeArguments()).isPresent() && typeArguments.get().isEmpty()) {
            reporter.report(node, new UpgradeJavaMessage("The diamond operator is not supported.", ParserConfiguration.LanguageLevel.JAVA_7), new Object[0]);
        }
    });
    protected final Validator noPrimitiveGenericArguments = new TreeVisitorValidator((node, reporter) -> {
        if (node instanceof NodeWithTypeArguments) {
            Optional<NodeList<Type>> typeArguments = ((NodeWithTypeArguments)((Object)node)).getTypeArguments();
            typeArguments.ifPresent(types -> types.forEach(ty -> {
                if (ty instanceof PrimitiveType) {
                    reporter.report(node, "Type arguments may not be primitive.", new Object[0]);
                }
            }));
        }
    });
    final Validator forEachStmt = new SingleNodeTypeValidator<ForEachStmt>(ForEachStmt.class, (node, reporter) -> {
        VariableDeclarationExpr declaration = node.getVariable();
        if (declaration.getVariables().size() != 1) {
            reporter.report(node, "A foreach statement's variable declaration must have exactly one variable declarator. Given: " + declaration.getVariables().size() + ".", new Object[0]);
        }
    });
    final Validator enumNotAllowed = new ReservedKeywordValidator("enum");

    public Java5Validator() {
        this.replace(this.noGenerics, this.genericsWithoutDiamondOperator);
        this.add(this.noPrimitiveGenericArguments);
        this.add(this.enumNotAllowed);
        this.add(this.forEachStmt);
        this.remove(this.noAnnotations);
        this.remove(this.noEnums);
        this.remove(this.noVarargs);
        this.remove(this.noForEach);
        this.remove(this.noStaticImports);
    }
}

