/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.incubator.templatepane;

import com.dlsc.gemsfx.incubator.templatepane.TemplatePane;
import com.dlsc.gemsfx.incubator.templatepane.VisibilityPolicy;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.shape.Rectangle;

public class Tile {
    private final InvalidationListener resizeListener = it -> this.resizeNode();
    private final TemplatePane.Position position;
    private final Rectangle clip;
    private TemplatePane templatePane;
    private VisibilityPolicy visibility;
    private TileTransition transition = TileTransition.SHRINK;
    private final DoubleProperty xOffset = new SimpleDoubleProperty((Object)this, "xOffset", 0.0);
    private final DoubleProperty yOffset = new SimpleDoubleProperty((Object)this, "yOffset", 0.0);
    private boolean resizingTile;
    private final ObjectProperty<Node> node = new SimpleObjectProperty((Object)this, "node");
    private final BooleanProperty visible = new SimpleBooleanProperty((Object)this, "visible", true);
    private final DoubleProperty layoutX = new SimpleDoubleProperty((Object)this, "layoutX", 0.0);
    private final DoubleProperty layoutY = new SimpleDoubleProperty((Object)this, "layoutY", 0.0);
    private final DoubleProperty width = new SimpleDoubleProperty((Object)this, "width", 0.0);
    private final DoubleProperty height = new SimpleDoubleProperty((Object)this, "height", 0.0);

    public Tile(TemplatePane templatePane, TemplatePane.Position position) {
        this.templatePane = Objects.requireNonNull(templatePane);
        this.position = Objects.requireNonNull(position);
        this.layoutX.addListener(this.resizeListener);
        this.layoutY.addListener(this.resizeListener);
        this.width.addListener(this.resizeListener);
        this.height.addListener(this.resizeListener);
        this.clip = new Rectangle();
        this.clip.widthProperty().bind((ObservableValue)this.width);
        this.clip.heightProperty().bind((ObservableValue)this.height);
        this.nodeProperty().addListener(it -> {
            Node node = this.getNode();
            if (node != null) {
                for (TemplatePane.Position p : TemplatePane.Position.values()) {
                    node.getStyleClass().removeAll((Object[])new String[]{"tile-node", this.createStyleName(p)});
                }
                node.getStyleClass().addAll((Object[])new String[]{"tile-node", this.createStyleName(this.getPosition())});
                node.setClip((Node)this.clip);
            }
        });
    }

    public final DoubleProperty xOffsetProperty() {
        return this.xOffset;
    }

    public final double getXOffset() {
        return this.xOffsetProperty().get();
    }

    public final void setXOffset(double xOffset) {
        this.xOffsetProperty().set(xOffset);
    }

    public final DoubleProperty yOffsetProperty() {
        return this.yOffset;
    }

    public final double getYOffset() {
        return this.yOffsetProperty().get();
    }

    public final void setYOffset(double yOffset) {
        this.yOffsetProperty().set(yOffset);
    }

    public final TemplatePane getTemplatePane() {
        return this.templatePane;
    }

    public final void setTransition(TileTransition tileTransition) {
        this.transition = tileTransition;
    }

    public final TileTransition getTransition() {
        return this.transition;
    }

    public final void setVisibility(VisibilityPolicy visibilityPolicy) {
        this.visibility = visibilityPolicy;
    }

    public final VisibilityPolicy getVisibility() {
        return this.visibility;
    }

    private String createStyleName(TemplatePane.Position p) {
        return p.name().toLowerCase().replace('_', '-');
    }

    public final TemplatePane.Position getPosition() {
        return this.position;
    }

    private void resizeNode() {
        Node node;
        if (!this.resizingTile && (node = this.getNode()) != null) {
            node.resizeRelocate(this.getLayoutX(), this.getLayoutY(), this.getWidth(), this.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(double x, double y, double w, double h) {
        this.resizingTile = true;
        try {
            this.setLayoutX(x);
            this.setLayoutY(y);
            this.setWidth(w);
            this.setHeight(h);
        }
        finally {
            this.resizingTile = false;
            this.resizeNode();
        }
    }

    public double prefHeight(double width) {
        Node node;
        if (this.isVisible() && this.isTileVisible() && (node = this.getNode()) != null) {
            return node.prefHeight(width);
        }
        return 0.0;
    }

    public double prefWidth(double height) {
        Node node;
        if (this.isVisible() && this.isTileVisible() && (node = this.getNode()) != null) {
            return node.prefWidth(height);
        }
        return 0.0;
    }

    private boolean isTileVisible() {
        if (this.visibility != null) {
            return this.visibility.isTileVisible(this);
        }
        return true;
    }

    public final ObjectProperty<Node> nodeProperty() {
        return this.node;
    }

    public final Node getNode() {
        return (Node)this.node.get();
    }

    public final void setNode(Node node) {
        this.node.set((Object)node);
    }

    public final BooleanProperty visibleProperty() {
        return this.visible;
    }

    public final boolean isVisible() {
        return this.visibleProperty().get();
    }

    public final void setVisible(boolean visible) {
        this.visibleProperty().set(visible);
    }

    public final DoubleProperty layoutXProperty() {
        return this.layoutX;
    }

    public final double getLayoutX() {
        return this.layoutXProperty().get();
    }

    public final void setLayoutX(double layoutX) {
        this.layoutXProperty().set(layoutX);
    }

    public final DoubleProperty layoutYProperty() {
        return this.layoutY;
    }

    public final double getLayoutY() {
        return this.layoutYProperty().get();
    }

    public final void setLayoutY(double layoutY) {
        this.layoutYProperty().set(layoutY);
    }

    public final DoubleProperty widthProperty() {
        return this.width;
    }

    public final double getWidth() {
        return this.widthProperty().get();
    }

    public final void setWidth(double width) {
        this.widthProperty().set(width);
    }

    public final DoubleProperty heightProperty() {
        return this.height;
    }

    public final double getHeight() {
        return this.heightProperty().get();
    }

    public final void setHeight(double height) {
        this.heightProperty().set(height);
    }

    public static enum TileTransition {
        APPEAR,
        SHRINK,
        SLIDE;

    }
}

