/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.CustomPopupControl;
import com.dlsc.gemsfx.RemovableListCell;
import com.dlsc.gemsfx.util.HistoryManager;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;

public class HistoryButton<T>
extends Button {
    private static final String DEFAULT_STYLE_CLASS = "history-button";
    private static final PseudoClass DISABLED_POPUP_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"disabled-popup");
    private static final PseudoClass POPUP_SHOWING_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"popup-showing");
    private HistoryPopup popup;
    private final ObjectProperty<Node> placeholder = new SimpleObjectProperty((Object)this, "placeholder");
    private ObjectProperty<Consumer<T>> onItemSelected;
    private final ReadOnlyBooleanWrapper popupShowing = new ReadOnlyBooleanWrapper((Object)this, "popupShowing"){

        protected void invalidated() {
            HistoryButton.this.pseudoClassStateChanged(POPUP_SHOWING_PSEUDO_CLASS, this.get());
        }
    };
    private ObjectProperty<HistoryManager<T>> historyManager;
    private ObjectProperty<Node> owner;
    private final ObjectProperty<Node> listDecorationLeft = new SimpleObjectProperty((Object)this, "listDecorationLeft");
    private final ObjectProperty<Node> listDecorationRight = new SimpleObjectProperty((Object)this, "listDecorationRight");
    private final ObjectProperty<Node> listDecorationTop = new SimpleObjectProperty((Object)this, "listDecorationTop");
    private final ObjectProperty<Node> listDecorationBottom = new SimpleObjectProperty((Object)this, "listDecorationBottom");
    private ObjectProperty<Callback<ListView<T>, ListCell<T>>> cellFactory;

    public HistoryButton() {
        this.getStyleClass().addAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        this.setGraphic((Node)new FontIcon((Ikon)MaterialDesign.MDI_HISTORY));
        this.setOnAction(evt -> this.showPopup());
        this.setCellFactory(view -> new RemovableListCell<Object>((listView, item) -> {
            HistoryManager<Object> historyManager = this.getHistoryManager();
            if (historyManager != null) {
                historyManager.remove(item);
            }
        }));
    }

    public HistoryButton(Node owner) {
        this();
        this.setOwner(owner);
    }

    public void showPopup() {
        Node owner = this.getOwner();
        if (owner != null && owner != this && !owner.isFocused()) {
            owner.requestFocus();
        }
        if (this.getHistoryManager() == null) {
            return;
        }
        if (this.popup == null) {
            this.popup = new HistoryPopup();
            this.popupShowing.bind((ObservableValue)this.popup.showingProperty());
        }
        if (this.popup.isShowing()) {
            this.hidePopup();
        } else {
            this.popup.show((Node)this);
        }
    }

    public void hidePopup() {
        if (this.popup != null) {
            this.popup.hide();
        }
    }

    public final ObjectProperty<Node> placeholderProperty() {
        return this.placeholder;
    }

    public final Node getPlaceholder() {
        return this.placeholder == null ? null : (Node)this.placeholder.get();
    }

    public final void setPlaceholder(Node placeholder) {
        this.placeholderProperty().set((Object)placeholder);
    }

    public final Consumer<T> getOnItemSelected() {
        return this.onItemSelected == null ? null : (Consumer)this.onItemSelected.get();
    }

    public final ObjectProperty<Consumer<T>> onItemSelectedProperty() {
        if (this.onItemSelected == null) {
            this.onItemSelected = new SimpleObjectProperty((Object)this, "onItemSelectedProperty");
        }
        return this.onItemSelected;
    }

    public final void setOnItemSelected(Consumer<T> onItemSelected) {
        this.onItemSelectedProperty().set(onItemSelected);
    }

    public final boolean isPopupShowing() {
        return this.popupShowing.get();
    }

    public final ObjectProperty<HistoryManager<T>> historyManagerProperty() {
        if (this.historyManager == null) {
            this.historyManager = new SimpleObjectProperty<HistoryManager<T>>((Object)this, "historyManager"){

                protected void invalidated() {
                    HistoryButton.this.pseudoClassStateChanged(DISABLED_POPUP_PSEUDO_CLASS, this.get() == null);
                }
            };
        }
        return this.historyManager;
    }

    public final void setHistoryManager(HistoryManager<T> historyManager) {
        this.historyManagerProperty().set(historyManager);
    }

    public final HistoryManager<T> getHistoryManager() {
        return this.historyManager == null ? null : (HistoryManager)this.historyManager.get();
    }

    public final ObjectProperty<Node> ownerProperty() {
        if (this.owner == null) {
            this.owner = new SimpleObjectProperty((Object)this, "owner");
        }
        return this.owner;
    }

    public final Node getOwner() {
        return this.owner == null ? null : (Node)this.owner.get();
    }

    public final void setOwner(Node owner) {
        this.ownerProperty().set((Object)owner);
    }

    public final Node getListDecorationLeft() {
        return (Node)this.listDecorationLeft.get();
    }

    public final ObjectProperty<Node> listDecorationLeftProperty() {
        return this.listDecorationLeft;
    }

    public final void setListDecorationLeft(Node listDecorationLeft) {
        this.listDecorationLeft.set((Object)listDecorationLeft);
    }

    public final Node getListDecorationRight() {
        return (Node)this.listDecorationRight.get();
    }

    public final ObjectProperty<Node> listDecorationRightProperty() {
        return this.listDecorationRight;
    }

    public final void setListDecorationRight(Node listDecorationRight) {
        this.listDecorationRight.set((Object)listDecorationRight);
    }

    public final Node getListDecorationTop() {
        return (Node)this.listDecorationTop.get();
    }

    public final ObjectProperty<Node> listDecorationTopProperty() {
        return this.listDecorationTop;
    }

    public final void setListDecorationTop(Node listDecorationTop) {
        this.listDecorationTop.set((Object)listDecorationTop);
    }

    public final Node getListDecorationBottom() {
        return (Node)this.listDecorationBottom.get();
    }

    public final ObjectProperty<Node> listDecorationBottomProperty() {
        return this.listDecorationBottom;
    }

    public final void setListDecorationBottom(Node listDecorationBottom) {
        this.listDecorationBottom.set((Object)listDecorationBottom);
    }

    public final Callback<ListView<T>, ListCell<T>> getCellFactory() {
        return this.cellFactory == null ? null : (Callback)this.cellFactory.get();
    }

    public final ObjectProperty<Callback<ListView<T>, ListCell<T>>> cellFactoryProperty() {
        if (this.cellFactory == null) {
            this.cellFactory = new SimpleObjectProperty((Object)this, "cellFactory");
        }
        return this.cellFactory;
    }

    public final void setCellFactory(Callback<ListView<T>, ListCell<T>> cellFactory) {
        this.cellFactoryProperty().set(cellFactory);
    }

    public final ReadOnlyBooleanProperty popupShowingProperty() {
        return this.popupShowing.getReadOnlyProperty();
    }

    public class HistoryPopup
    extends CustomPopupControl {
        public static final String DEFAULT_STYLE_CLASS = "history-popup";

        public HistoryPopup() {
            this.getStyleClass().addAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
            this.setAutoFix(true);
            this.setAutoHide(true);
            this.setHideOnEscape(true);
        }

        protected Skin<?> createDefaultSkin() {
            return new HistoryPopupSkin(this);
        }
    }

    public class HistoryPopupSkin
    implements Skin<HistoryPopup> {
        private final HistoryPopup popup;
        private final BorderPane root;

        public HistoryPopupSkin(HistoryPopup popup) {
            this.popup = popup;
            this.root = new BorderPane(){

                public String getUserAgentStylesheet() {
                    return Objects.requireNonNull(HistoryButton.class.getResource("history-button.css")).toExternalForm();
                }
            };
            this.root.getStyleClass().add((Object)"content-pane");
            this.root.setCenter(this.createListView());
            this.root.leftProperty().bind(HistoryButton.this.listDecorationLeftProperty());
            this.root.rightProperty().bind(HistoryButton.this.listDecorationRightProperty());
            this.root.topProperty().bind(HistoryButton.this.listDecorationTopProperty());
            this.root.bottomProperty().bind(HistoryButton.this.listDecorationBottomProperty());
        }

        private ListView<T> createListView() {
            ListView listView = new ListView();
            listView.getStyleClass().add((Object)"history-list-view");
            HistoryManager historyManager = HistoryButton.this.getHistoryManager();
            if (historyManager != null) {
                Bindings.bindContent((List)listView.getItems(), historyManager.getAllUnmodifiable());
            }
            HistoryButton.this.historyManagerProperty().addListener((observable, oldManager, newManager) -> {
                if (oldManager != null) {
                    Bindings.unbindContent((Object)listView.getItems(), oldManager.getAllUnmodifiable());
                }
                if (newManager != null) {
                    Bindings.bindContent((List)listView.getItems(), newManager.getAllUnmodifiable());
                }
            });
            listView.cellFactoryProperty().bind(HistoryButton.this.cellFactoryProperty());
            listView.placeholderProperty().bind(HistoryButton.this.placeholderProperty());
            listView.addEventHandler(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
                if (mouseEvent.getButton() == MouseButton.PRIMARY && mouseEvent.getClickCount() == 1 && !mouseEvent.isConsumed()) {
                    this.handleItemSelection(listView);
                    mouseEvent.consume();
                }
            });
            listView.addEventFilter(KeyEvent.KEY_RELEASED, keyEvent -> {
                if (keyEvent.getCode() == KeyCode.ENTER) {
                    this.handleItemSelection(listView);
                    keyEvent.consume();
                }
            });
            return listView;
        }

        private void handleItemSelection(ListView<T> listView) {
            Object historyItem = listView.getSelectionModel().getSelectedItem();
            Optional.ofNullable(HistoryButton.this.getOnItemSelected()).ifPresent(onItemSelected -> onItemSelected.accept(historyItem));
        }

        public Node getNode() {
            return this.root;
        }

        public HistoryPopup getSkinnable() {
            return this.popup;
        }

        public void dispose() {
        }
    }
}

