/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;

public class EnhancedLabel
extends Label {
    private static final PseudoClass SELECTED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"selected");
    private ObjectProperty<EventHandler<ActionEvent>> onCopyAction;
    private final BooleanProperty selected = new SimpleBooleanProperty((Object)this, "selected");
    private final StringProperty copyMenuItemText = new SimpleStringProperty((Object)this, "copyMenuItemText", "Copy text");
    private final ObjectProperty<Supplier<String>> copyContentSupplier = new SimpleObjectProperty((Object)this, "copyContentProvider", () -> ((EnhancedLabel)this).getText());

    public EnhancedLabel() {
        this.init();
    }

    public EnhancedLabel(String text) {
        super(text);
        this.init();
    }

    public EnhancedLabel(String text, Node node) {
        super(text, node);
        this.init();
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(EnhancedLabel.class.getResource("enhanced-label.css")).toExternalForm();
    }

    private void init() {
        this.getStyleClass().add((Object)"enhanced-label");
        this.setFocusTraversable(true);
        KeyCodeCombination copy = new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
        this.setOnKeyPressed(arg_0 -> this.lambda$init$0((KeyCombination)copy, arg_0));
        this.setOnMouseClicked(evt -> {
            if (evt.getButton().equals((Object)MouseButton.PRIMARY) && evt.getClickCount() == 2) {
                this.setSelected(true);
            }
        });
        this.selectedProperty().addListener(it -> {
            this.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, this.isSelected());
            if (this.isSelected() && !this.isFocused()) {
                this.requestFocus();
            }
        });
        this.focusedProperty().addListener(it -> {
            if (!this.isFocused()) {
                this.setSelected(this.isFocused());
            }
        });
        MenuItem copyItem = new MenuItem();
        copyItem.textProperty().bind((ObservableValue)this.copyMenuItemTextProperty());
        copyItem.setOnAction(event -> {
            EventHandler<ActionEvent> handler = this.getOnCopyAction();
            if (handler != null) {
                handler.handle(event);
            }
        });
        ContextMenu contextMenu = new ContextMenu();
        contextMenu.getItems().add((Object)copyItem);
        this.setContextMenu(contextMenu);
        this.setOnContextMenuRequested(evt -> this.setSelected(true));
    }

    private void copyText() {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        content.putString(this.getCopyContentSupplier().get());
        clipboard.setContent((Map)content);
    }

    private void copyText(ActionEvent actionEvent) {
        this.copyText();
        actionEvent.consume();
    }

    public final void setOnCopyAction(EventHandler<ActionEvent> value) {
        this.onCopyActionProperty().set(value);
    }

    public final EventHandler<ActionEvent> getOnCopyAction() {
        return this.onCopyAction == null ? this::copyText : (EventHandler)this.onCopyAction.get();
    }

    public final ObjectProperty<EventHandler<ActionEvent>> onCopyActionProperty() {
        if (this.onCopyAction == null) {
            this.onCopyAction = new SimpleObjectProperty((Object)this, "onCopyAction", this::copyText);
        }
        return this.onCopyAction;
    }

    public final boolean isSelected() {
        return this.selected.get();
    }

    public final BooleanProperty selectedProperty() {
        return this.selected;
    }

    public final void setSelected(boolean selected) {
        this.selected.set(selected);
    }

    public final String getCopyMenuItemText() {
        return (String)this.copyMenuItemText.get();
    }

    public final StringProperty copyMenuItemTextProperty() {
        return this.copyMenuItemText;
    }

    public final void setCopyMenuItemText(String copyMenuItemText) {
        this.copyMenuItemText.set((Object)copyMenuItemText);
    }

    public final Supplier<String> getCopyContentSupplier() {
        return (Supplier)this.copyContentSupplier.get();
    }

    public final ObjectProperty<Supplier<String>> copyContentSupplierProperty() {
        return this.copyContentSupplier;
    }

    public final void setCopyContentSupplier(Supplier<String> copyContentSupplier) {
        this.copyContentSupplier.set(copyContentSupplier);
    }

    private /* synthetic */ void lambda$init$0(KeyCombination copy, KeyEvent evt) {
        if (copy.match(evt)) {
            this.copyText();
        }
    }
}

