/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex;

import java.io.IOException;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.ac.ed.ph.snuggletex.DOMOutputOptions;
import uk.ac.ed.ph.snuggletex.InputError;
import uk.ac.ed.ph.snuggletex.SnuggleInput;
import uk.ac.ed.ph.snuggletex.SnuggleLogicException;
import uk.ac.ed.ph.snuggletex.SnuggleSession;
import uk.ac.ed.ph.snuggletex.XMLStringOutputOptions;
import uk.ac.ed.ph.snuggletex.internal.util.ConstraintUtilities;
import uk.ac.ed.ph.snuggletex.utilities.MathMLUtilities;

public final class SnuggleSimpleMathRunner {
    private final SnuggleSession session;

    SnuggleSimpleMathRunner(SnuggleSession session) {
        this.session = session;
    }

    public Element doMathInput(String mathModeInput) {
        return this.doMathInput(mathModeInput, this.session.defaultDOMOutputOptions);
    }

    public Element doMathInput(String mathModeInput, DOMOutputOptions domOutputOptions) {
        ConstraintUtilities.ensureNotNull(mathModeInput, "Math Mode Input");
        String latexInput = "\\[" + mathModeInput + "\\]";
        this.session.reset();
        try {
            this.session.parseInput(new SnuggleInput(latexInput, "Math Mode Input"));
        }
        catch (IOException e) {
            throw new SnuggleLogicException("Unexpected IOException");
        }
        NodeList nodeList = this.session.buildDOMSubtree(domOutputOptions);
        if (!this.session.getErrors().isEmpty()) {
            return null;
        }
        Element result = null;
        if (nodeList.getLength() == 1) {
            result = (Element)nodeList.item(0);
            if (!MathMLUtilities.isMathMLElement(result, "math")) {
                throw new IllegalArgumentException("Input did not yield exactly 1 <math> element");
            }
        } else {
            throw new IllegalArgumentException("Input did not yield exactly 1 result element");
        }
        return result;
    }

    public String doMathInput(String mathModeInput, XMLStringOutputOptions xmlStringOutputOptions) {
        Element mathmlElement = this.doMathInput(mathModeInput, (DOMOutputOptions)xmlStringOutputOptions);
        return mathmlElement != null ? MathMLUtilities.serializeElement(mathmlElement, xmlStringOutputOptions) : null;
    }

    public List<InputError> getLastErrors() {
        return this.session.getErrors();
    }
}

