// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// TCPResponseRule TCP Response Rule
//
// HAProxy TCP Response Rule configuration (corresponds to tcp-response)
// Example: {"cond":"if","cond_test":"{ src 192.168.0.0/16 }","index":0,"type":"content"}
//
// swagger:model tcp_response_rule
type TCPResponseRule struct {
	// action
	// Enum: ["accept","close","lua","reject","sc-add-gpc","sc-inc-gpc","sc-inc-gpc0","sc-inc-gpc1","sc-set-gpt","sc-set-gpt0","send-spoe-group","set-bandwidth-limit","set-fc-mark","set-fc-tos","set-log-level","set-mark","set-nice","set-tos","set-var","set-var-fmt","silent-drop","unset-var"]
	// +kubebuilder:validation:Enum="accept","close","lua","reject","sc-add-gpc","sc-inc-gpc","sc-inc-gpc0","sc-inc-gpc1","sc-set-gpt","sc-set-gpt0","send-spoe-group","set-bandwidth-limit","set-fc-mark","set-fc-tos","set-log-level","set-mark","set-nice","set-tos","set-var","set-var-fmt","silent-drop","unset-var";
	Action string `json:"action,omitempty"`

	// bandwidth limit limit
	BandwidthLimitLimit string `json:"bandwidth_limit_limit,omitempty"`

	// bandwidth limit name
	BandwidthLimitName string `json:"bandwidth_limit_name,omitempty"`

	// bandwidth limit period
	BandwidthLimitPeriod string `json:"bandwidth_limit_period,omitempty"`

	// cond
	// Enum: ["if","unless"]
	// +kubebuilder:validation:Enum="if","unless";
	Cond string `json:"cond,omitempty"`

	// cond test
	CondTest string `json:"cond_test,omitempty"`

	// expr
	Expr string `json:"expr,omitempty"`

	// log level
	// Enum: ["emerg","alert","crit","err","warning","notice","info","debug","silent"]
	// +kubebuilder:validation:Enum="emerg","alert","crit","err","warning","notice","info","debug","silent";
	LogLevel string `json:"log_level,omitempty"`

	// lua action
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	LuaAction string `json:"lua_action,omitempty"`

	// lua params
	LuaParams string `json:"lua_params,omitempty"`

	// mark value
	// Pattern: ^(0x[0-9A-Fa-f]+|[0-9]+)$
	// +kubebuilder:validation:Pattern=`^(0x[0-9A-Fa-f]+|[0-9]+)$`
	MarkValue string `json:"mark_value,omitempty"`

	// nice value
	// Maximum: 1024
	// Minimum: -1024
	// +kubebuilder:validation:Maximum=1024
	// +kubebuilder:validation:Minimum=-1024
	NiceValue int64 `json:"nice_value,omitempty"`

	// rst ttl
	RstTTL int64 `json:"rst_ttl,omitempty"`

	// sc expr
	ScExpr string `json:"sc_expr,omitempty"`

	// sc id
	ScID int64 `json:"sc_id,omitempty"`

	// sc idx
	ScIdx int64 `json:"sc_idx,omitempty"`

	// sc int
	ScInt *int64 `json:"sc_int,omitempty"`

	// spoe engine
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	SpoeEngine string `json:"spoe_engine,omitempty"`

	// spoe group
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	SpoeGroup string `json:"spoe_group,omitempty"`

	// timeout
	Timeout *int64 `json:"timeout,omitempty"`

	// tos value
	// Pattern: ^(0x[0-9A-Fa-f]+|[0-9]+)$
	// +kubebuilder:validation:Pattern=`^(0x[0-9A-Fa-f]+|[0-9]+)$`
	TosValue string `json:"tos_value,omitempty"`

	// type
	// Required: true
	// Enum: ["content","inspect-delay"]
	// +kubebuilder:validation:Enum="content","inspect-delay";
	Type string `json:"type"`

	// var format
	VarFormat string `json:"var_format,omitempty"`

	// var name
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	VarName string `json:"var_name,omitempty"`

	// var scope
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	VarScope string `json:"var_scope,omitempty"`
}

// Validate validates this tcp response rule
func (m *TCPResponseRule) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCond(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLogLevel(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLuaAction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMarkValue(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNiceValue(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpoeEngine(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpoeGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTosValue(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVarName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVarScope(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var tcpResponseRuleTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["accept","close","lua","reject","sc-add-gpc","sc-inc-gpc","sc-inc-gpc0","sc-inc-gpc1","sc-set-gpt","sc-set-gpt0","send-spoe-group","set-bandwidth-limit","set-fc-mark","set-fc-tos","set-log-level","set-mark","set-nice","set-tos","set-var","set-var-fmt","silent-drop","unset-var"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tcpResponseRuleTypeActionPropEnum = append(tcpResponseRuleTypeActionPropEnum, v)
	}
}

const (

	// TCPResponseRuleActionAccept captures enum value "accept"
	TCPResponseRuleActionAccept string = "accept"

	// TCPResponseRuleActionClose captures enum value "close"
	TCPResponseRuleActionClose string = "close"

	// TCPResponseRuleActionLua captures enum value "lua"
	TCPResponseRuleActionLua string = "lua"

	// TCPResponseRuleActionReject captures enum value "reject"
	TCPResponseRuleActionReject string = "reject"

	// TCPResponseRuleActionScDashAddDashGpc captures enum value "sc-add-gpc"
	TCPResponseRuleActionScDashAddDashGpc string = "sc-add-gpc"

	// TCPResponseRuleActionScDashIncDashGpc captures enum value "sc-inc-gpc"
	TCPResponseRuleActionScDashIncDashGpc string = "sc-inc-gpc"

	// TCPResponseRuleActionScDashIncDashGpc0 captures enum value "sc-inc-gpc0"
	TCPResponseRuleActionScDashIncDashGpc0 string = "sc-inc-gpc0"

	// TCPResponseRuleActionScDashIncDashGpc1 captures enum value "sc-inc-gpc1"
	TCPResponseRuleActionScDashIncDashGpc1 string = "sc-inc-gpc1"

	// TCPResponseRuleActionScDashSetDashGpt captures enum value "sc-set-gpt"
	TCPResponseRuleActionScDashSetDashGpt string = "sc-set-gpt"

	// TCPResponseRuleActionScDashSetDashGpt0 captures enum value "sc-set-gpt0"
	TCPResponseRuleActionScDashSetDashGpt0 string = "sc-set-gpt0"

	// TCPResponseRuleActionSendDashSpoeDashGroup captures enum value "send-spoe-group"
	TCPResponseRuleActionSendDashSpoeDashGroup string = "send-spoe-group"

	// TCPResponseRuleActionSetDashBandwidthDashLimit captures enum value "set-bandwidth-limit"
	TCPResponseRuleActionSetDashBandwidthDashLimit string = "set-bandwidth-limit"

	// TCPResponseRuleActionSetDashFcDashMark captures enum value "set-fc-mark"
	TCPResponseRuleActionSetDashFcDashMark string = "set-fc-mark"

	// TCPResponseRuleActionSetDashFcDashTos captures enum value "set-fc-tos"
	TCPResponseRuleActionSetDashFcDashTos string = "set-fc-tos"

	// TCPResponseRuleActionSetDashLogDashLevel captures enum value "set-log-level"
	TCPResponseRuleActionSetDashLogDashLevel string = "set-log-level"

	// TCPResponseRuleActionSetDashMark captures enum value "set-mark"
	TCPResponseRuleActionSetDashMark string = "set-mark"

	// TCPResponseRuleActionSetDashNice captures enum value "set-nice"
	TCPResponseRuleActionSetDashNice string = "set-nice"

	// TCPResponseRuleActionSetDashTos captures enum value "set-tos"
	TCPResponseRuleActionSetDashTos string = "set-tos"

	// TCPResponseRuleActionSetDashVar captures enum value "set-var"
	TCPResponseRuleActionSetDashVar string = "set-var"

	// TCPResponseRuleActionSetDashVarDashFmt captures enum value "set-var-fmt"
	TCPResponseRuleActionSetDashVarDashFmt string = "set-var-fmt"

	// TCPResponseRuleActionSilentDashDrop captures enum value "silent-drop"
	TCPResponseRuleActionSilentDashDrop string = "silent-drop"

	// TCPResponseRuleActionUnsetDashVar captures enum value "unset-var"
	TCPResponseRuleActionUnsetDashVar string = "unset-var"
)

// prop value enum
func (m *TCPResponseRule) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tcpResponseRuleTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *TCPResponseRule) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(m.Action) { // not required
		return nil
	}

	// value enum
	if err := m.validateActionEnum("action", "body", m.Action); err != nil {
		return err
	}

	return nil
}

var tcpResponseRuleTypeCondPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["if","unless"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tcpResponseRuleTypeCondPropEnum = append(tcpResponseRuleTypeCondPropEnum, v)
	}
}

const (

	// TCPResponseRuleCondIf captures enum value "if"
	TCPResponseRuleCondIf string = "if"

	// TCPResponseRuleCondUnless captures enum value "unless"
	TCPResponseRuleCondUnless string = "unless"
)

// prop value enum
func (m *TCPResponseRule) validateCondEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tcpResponseRuleTypeCondPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *TCPResponseRule) validateCond(formats strfmt.Registry) error {
	if swag.IsZero(m.Cond) { // not required
		return nil
	}

	// value enum
	if err := m.validateCondEnum("cond", "body", m.Cond); err != nil {
		return err
	}

	return nil
}

var tcpResponseRuleTypeLogLevelPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["emerg","alert","crit","err","warning","notice","info","debug","silent"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tcpResponseRuleTypeLogLevelPropEnum = append(tcpResponseRuleTypeLogLevelPropEnum, v)
	}
}

const (

	// TCPResponseRuleLogLevelEmerg captures enum value "emerg"
	TCPResponseRuleLogLevelEmerg string = "emerg"

	// TCPResponseRuleLogLevelAlert captures enum value "alert"
	TCPResponseRuleLogLevelAlert string = "alert"

	// TCPResponseRuleLogLevelCrit captures enum value "crit"
	TCPResponseRuleLogLevelCrit string = "crit"

	// TCPResponseRuleLogLevelErr captures enum value "err"
	TCPResponseRuleLogLevelErr string = "err"

	// TCPResponseRuleLogLevelWarning captures enum value "warning"
	TCPResponseRuleLogLevelWarning string = "warning"

	// TCPResponseRuleLogLevelNotice captures enum value "notice"
	TCPResponseRuleLogLevelNotice string = "notice"

	// TCPResponseRuleLogLevelInfo captures enum value "info"
	TCPResponseRuleLogLevelInfo string = "info"

	// TCPResponseRuleLogLevelDebug captures enum value "debug"
	TCPResponseRuleLogLevelDebug string = "debug"

	// TCPResponseRuleLogLevelSilent captures enum value "silent"
	TCPResponseRuleLogLevelSilent string = "silent"
)

// prop value enum
func (m *TCPResponseRule) validateLogLevelEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tcpResponseRuleTypeLogLevelPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *TCPResponseRule) validateLogLevel(formats strfmt.Registry) error {
	if swag.IsZero(m.LogLevel) { // not required
		return nil
	}

	// value enum
	if err := m.validateLogLevelEnum("log_level", "body", m.LogLevel); err != nil {
		return err
	}

	return nil
}

func (m *TCPResponseRule) validateLuaAction(formats strfmt.Registry) error {
	if swag.IsZero(m.LuaAction) { // not required
		return nil
	}

	if err := validate.Pattern("lua_action", "body", m.LuaAction, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *TCPResponseRule) validateMarkValue(formats strfmt.Registry) error {
	if swag.IsZero(m.MarkValue) { // not required
		return nil
	}

	if err := validate.Pattern("mark_value", "body", m.MarkValue, `^(0x[0-9A-Fa-f]+|[0-9]+)$`); err != nil {
		return err
	}

	return nil
}

func (m *TCPResponseRule) validateNiceValue(formats strfmt.Registry) error {
	if swag.IsZero(m.NiceValue) { // not required
		return nil
	}

	if err := validate.MinimumInt("nice_value", "body", m.NiceValue, -1024, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("nice_value", "body", m.NiceValue, 1024, false); err != nil {
		return err
	}

	return nil
}

func (m *TCPResponseRule) validateSpoeEngine(formats strfmt.Registry) error {
	if swag.IsZero(m.SpoeEngine) { // not required
		return nil
	}

	if err := validate.Pattern("spoe_engine", "body", m.SpoeEngine, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *TCPResponseRule) validateSpoeGroup(formats strfmt.Registry) error {
	if swag.IsZero(m.SpoeGroup) { // not required
		return nil
	}

	if err := validate.Pattern("spoe_group", "body", m.SpoeGroup, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *TCPResponseRule) validateTosValue(formats strfmt.Registry) error {
	if swag.IsZero(m.TosValue) { // not required
		return nil
	}

	if err := validate.Pattern("tos_value", "body", m.TosValue, `^(0x[0-9A-Fa-f]+|[0-9]+)$`); err != nil {
		return err
	}

	return nil
}

var tcpResponseRuleTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["content","inspect-delay"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tcpResponseRuleTypeTypePropEnum = append(tcpResponseRuleTypeTypePropEnum, v)
	}
}

const (

	// TCPResponseRuleTypeContent captures enum value "content"
	TCPResponseRuleTypeContent string = "content"

	// TCPResponseRuleTypeInspectDashDelay captures enum value "inspect-delay"
	TCPResponseRuleTypeInspectDashDelay string = "inspect-delay"
)

// prop value enum
func (m *TCPResponseRule) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tcpResponseRuleTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *TCPResponseRule) validateType(formats strfmt.Registry) error {

	if err := validate.RequiredString("type", "body", m.Type); err != nil {
		return err
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *TCPResponseRule) validateVarName(formats strfmt.Registry) error {
	if swag.IsZero(m.VarName) { // not required
		return nil
	}

	if err := validate.Pattern("var_name", "body", m.VarName, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *TCPResponseRule) validateVarScope(formats strfmt.Registry) error {
	if swag.IsZero(m.VarScope) { // not required
		return nil
	}

	if err := validate.Pattern("var_scope", "body", m.VarScope, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this tcp response rule based on context it is used
func (m *TCPResponseRule) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *TCPResponseRule) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TCPResponseRule) UnmarshalBinary(b []byte) error {
	var res TCPResponseRule
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
