/* SPDX-FileCopyrightText: 2020-2022 Blender Authors
 *
 * SPDX-License-Identifier: GPL-2.0-or-later */

#include "infos/gpencil_info.hh"

VERTEX_SHADER_CREATE_INFO(gpencil_depth_merge)

void main()
{
  int v = gl_VertexID % 3;
  float x = -1.0 + float((v & 1) << 2);
  float y = -1.0 + float((v & 2) << 1);
  gl_Position = drw_view.winmat * (drw_view.viewmat * (gpModelMatrix * vec4(x, y, 0.0, 1.0)));
}
