/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.concurrent;

import io.vavr.Value;
import io.vavr.collection.Iterator;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;

public interface Future<T>
extends Value<T> {
    @Deprecated
    public static final ExecutorService DEFAULT_EXECUTOR_SERVICE = ForkJoinPool.commonPool();
    public static final Executor DEFAULT_EXECUTOR = DEFAULT_EXECUTOR_SERVICE;

    public Future<T> await();

    public Option<Try<T>> getValue();

    public Future<T> onComplete(Consumer<? super Try<T>> var1);

    @Override
    default public void forEach(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action is null");
        this.onComplete(result2 -> result2.forEach(action));
    }

    @Override
    default public T get() {
        return this.await().getValue().get().get();
    }

    @Override
    default public boolean isAsync() {
        return true;
    }

    @Override
    default public boolean isEmpty() {
        return this.await().getValue().get().isEmpty();
    }

    @Override
    default public boolean isLazy() {
        return false;
    }

    @Override
    default public boolean isSingleValued() {
        return true;
    }

    @Override
    default public Iterator<T> iterator() {
        return this.isEmpty() ? Iterator.empty() : Iterator.of(this.get());
    }

    @Override
    default public String stringPrefix() {
        return "Future";
    }
}

