package v1alpha1

// This file contains a collection of methods that can be used from go-restful to
// generate Swagger API documentation for its models. Please read this PR for more
// information on the implementation: https://github.com/emicklei/go-restful/pull/215
//
// TODOs are ignored from the parser (e.g. TODO(andronat):... || TODO:...) if and only if
// they are on one line! For multiple line or blocks that you want to ignore use ---.
// Any context after a --- is ignored.
//
// Those methods can be generated by using hack/update-swagger-docs.sh

// AUTO-GENERATED FUNCTIONS START HERE
var map_ConsolePlugin = map[string]string{
	"":         "ConsolePlugin is an extension for customizing OpenShift web console by dynamically loading code from another service running on the cluster.\n\nCompatibility level 4: No compatibility is provided, the API can change at any point for any reason. These capabilities should not be used by applications needing long term support.",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
}

func (ConsolePlugin) SwaggerDoc() map[string]string {
	return map_ConsolePlugin
}

var map_ConsolePluginList = map[string]string{
	"":         "Compatibility level 4: No compatibility is provided, the API can change at any point for any reason. These capabilities should not be used by applications needing long term support.",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
}

func (ConsolePluginList) SwaggerDoc() map[string]string {
	return map_ConsolePluginList
}

var map_ConsolePluginProxy = map[string]string{
	"":              "ConsolePluginProxy holds information on various service types to which console's backend will proxy the plugin's requests.",
	"type":          "type is the type of the console plugin's proxy. Currently only \"Service\" is supported.",
	"alias":         "alias is a proxy name that identifies the plugin's proxy. An alias name should be unique per plugin. The console backend exposes following proxy endpoint:\n\n/api/proxy/plugin/<plugin-name>/<proxy-alias>/<request-path>?<optional-query-parameters>\n\nRequest example path:\n\n/api/proxy/plugin/acm/search/pods?namespace=openshift-apiserver",
	"service":       "service is an in-cluster Service that the plugin will connect to. The Service must use HTTPS. The console backend exposes an endpoint in order to proxy communication between the plugin and the Service. Note: service field is required for now, since currently only \"Service\" type is supported.",
	"caCertificate": "caCertificate provides the cert authority certificate contents, in case the proxied Service is using custom service CA. By default, the service CA bundle provided by the service-ca operator is used. ",
	"authorize":     "authorize indicates if the proxied request should contain the logged-in user's OpenShift access token in the \"Authorization\" request header. For example:\n\nAuthorization: Bearer sha256~kV46hPnEYhCWFnB85r5NrprAxggzgb6GOeLbgcKNsH0\n\nBy default the access token is not part of the proxied request.",
}

func (ConsolePluginProxy) SwaggerDoc() map[string]string {
	return map_ConsolePluginProxy
}

var map_ConsolePluginProxyServiceConfig = map[string]string{
	"":          "ProxyTypeServiceConfig holds information on Service to which console's backend will proxy the plugin's requests.",
	"name":      "name of Service that the plugin needs to connect to.",
	"namespace": "namespace of Service that the plugin needs to connect to",
	"port":      "port on which the Service that the plugin needs to connect to is listening on.",
}

func (ConsolePluginProxyServiceConfig) SwaggerDoc() map[string]string {
	return map_ConsolePluginProxyServiceConfig
}

var map_ConsolePluginService = map[string]string{
	"":          "ConsolePluginService holds information on Service that is serving console dynamic plugin assets.",
	"name":      "name of Service that is serving the plugin assets.",
	"namespace": "namespace of Service that is serving the plugin assets.",
	"port":      "port on which the Service that is serving the plugin is listening to.",
	"basePath":  "basePath is the path to the plugin's assets. The primary asset it the manifest file called `plugin-manifest.json`, which is a JSON document that contains metadata about the plugin and the extensions.",
}

func (ConsolePluginService) SwaggerDoc() map[string]string {
	return map_ConsolePluginService
}

var map_ConsolePluginSpec = map[string]string{
	"":            "ConsolePluginSpec is the desired plugin configuration.",
	"displayName": "displayName is the display name of the plugin.",
	"service":     "service is a Kubernetes Service that exposes the plugin using a deployment with an HTTP server. The Service must use HTTPS and Service serving certificate. The console backend will proxy the plugins assets from the Service using the service CA bundle.",
	"proxy":       "proxy is a list of proxies that describe various service type to which the plugin needs to connect to.",
}

func (ConsolePluginSpec) SwaggerDoc() map[string]string {
	return map_ConsolePluginSpec
}

// AUTO-GENERATED FUNCTIONS END HERE
