/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.framebody;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.datatype.NumberHashMap;
import org.jaudiotagger.tag.datatype.Pair;
import org.jaudiotagger.tag.datatype.PairedTextEncodedStringNullTerminated;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIPL;
import org.jaudiotagger.tag.id3.framebody.ID3v23FrameBody;

public class FrameBodyIPLS
extends AbstractID3v2FrameBody
implements ID3v23FrameBody {
    public FrameBodyIPLS() {
        this.setObjectValue("TextEncoding", (byte)0);
    }

    public FrameBodyIPLS(ByteBuffer byteBuffer, int frameSize) throws InvalidTagException {
        super(byteBuffer, frameSize);
    }

    public String getIdentifier() {
        return "IPLS";
    }

    public FrameBodyIPLS(FrameBodyIPLS body) {
        super(body);
    }

    public FrameBodyIPLS(byte textEncoding, String text) {
        this.setObjectValue("TextEncoding", textEncoding);
        this.setText(text);
    }

    public FrameBodyIPLS(FrameBodyTIPL body) {
        this.setObjectValue("TextEncoding", body.getTextEncoding());
        this.setText(body.getText());
    }

    public void setText(String text) {
        PairedTextEncodedStringNullTerminated.ValuePairs value = new PairedTextEncodedStringNullTerminated.ValuePairs();
        StringTokenizer stz = new StringTokenizer(text, "\u0000");
        while (stz.hasMoreTokens()) {
            String key = stz.nextToken();
            if (!stz.hasMoreTokens()) continue;
            value.add(key, stz.nextToken());
        }
        this.setObjectValue("Text", value);
    }

    public void addPair(String text) {
        PairedTextEncodedStringNullTerminated.ValuePairs value = ((PairedTextEncodedStringNullTerminated)this.getObject("Text")).getValue();
        StringTokenizer stz = new StringTokenizer(text, "\u0000");
        if (stz.hasMoreTokens()) {
            value.add(stz.nextToken(), stz.nextToken());
        }
    }

    public void write(ByteArrayOutputStream tagBuffer) {
        if (!((PairedTextEncodedStringNullTerminated)this.getObject("Text")).canBeEncoded()) {
            this.setTextEncoding((byte)1);
        }
        super.write(tagBuffer);
    }

    protected void setupObjectList() {
        this.objectList.add(new NumberHashMap("TextEncoding", (AbstractTagFrameBody)this, 1));
        this.objectList.add(new PairedTextEncodedStringNullTerminated("Text", this));
    }

    public PairedTextEncodedStringNullTerminated.ValuePairs getPairing() {
        return (PairedTextEncodedStringNullTerminated.ValuePairs)this.getObject("Text").getValue();
    }

    public String getKeyAtIndex(int index) {
        PairedTextEncodedStringNullTerminated text = (PairedTextEncodedStringNullTerminated)this.getObject("Text");
        return text.getValue().getMapping().get(index).getKey();
    }

    public String getValueAtIndex(int index) {
        PairedTextEncodedStringNullTerminated text = (PairedTextEncodedStringNullTerminated)this.getObject("Text");
        return text.getValue().getMapping().get(index).getValue();
    }

    public int getNumberOfPairs() {
        PairedTextEncodedStringNullTerminated text = (PairedTextEncodedStringNullTerminated)this.getObject("Text");
        return text.getValue().getNumberOfPairs();
    }

    public String getText() {
        PairedTextEncodedStringNullTerminated text = (PairedTextEncodedStringNullTerminated)this.getObject("Text");
        StringBuilder sb = new StringBuilder();
        int count = 1;
        for (Pair entry : text.getValue().getMapping()) {
            sb.append(entry.getKey() + '\u0000' + entry.getValue());
            if (count != this.getNumberOfPairs()) {
                sb.append('\u0000');
            }
            ++count;
        }
        return sb.toString();
    }

    public String getUserFriendlyValue() {
        return this.getText();
    }
}

