/*
 * Decompiled with CFR 0.152.
 */
package net.pms.newgui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sun.jna.Platform;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.Build;
import net.pms.configuration.PmsConfiguration;
import net.pms.configuration.RendererConfiguration;
import net.pms.external.ExternalFactory;
import net.pms.external.ExternalListener;
import net.pms.network.NetworkConfiguration;
import net.pms.newgui.LooksFrame;
import net.pms.util.FormLayoutUtil;
import net.pms.util.KeyedComboBoxModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralTab {
    private static final Logger logger = LoggerFactory.getLogger(GeneralTab.class);
    private static final String COL_SPEC = "left:pref, 2dlu, p, 2dlu , p, 2dlu, p, 2dlu, pref:grow";
    private static final String ROW_SPEC = "p, 0dlu, p, 0dlu, p, 3dlu, p, 3dlu, p, 3dlu,p, 3dlu, p, 15dlu, p, 3dlu,p, 3dlu, p,  3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p,3dlu, p, 3dlu, p, 15dlu, p,3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 15dlu, p, 3dlu, p";
    private JCheckBox smcheckBox;
    private JCheckBox autoUpdateCheckBox;
    private JCheckBox newHTTPEngine;
    private JCheckBox preventSleep;
    private JTextField host;
    private JTextField port;
    private JComboBox langs;
    private JComboBox networkinterfacesCBX;
    private JTextField ip_filter;
    private JTextField maxbitrate;
    private JComboBox renderers;
    private JPanel pPlugins;
    private final PmsConfiguration configuration;

    GeneralTab(PmsConfiguration configuration) {
        this.configuration = configuration;
    }

    public JComponent build() {
        Locale locale = new Locale(this.configuration.getLanguage());
        ComponentOrientation orientation = ComponentOrientation.getOrientation(locale);
        String colSpec = FormLayoutUtil.getColSpec(COL_SPEC, orientation);
        FormLayout layout = new FormLayout(colSpec, ROW_SPEC);
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setBorder(Borders.DLU4_BORDER);
        builder.setOpaque(true);
        CellConstraints cc = new CellConstraints();
        this.smcheckBox = new JCheckBox(Messages.getString("NetworkTab.3"));
        this.smcheckBox.setContentAreaFilled(false);
        this.smcheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GeneralTab.this.configuration.setMinimized(e.getStateChange() == 1);
            }
        });
        if (this.configuration.isMinimized()) {
            this.smcheckBox.setSelected(true);
        }
        JComponent cmp = builder.addSeparator(Messages.getString("NetworkTab.5"), FormLayoutUtil.flip(cc.xyw(1, 1, 9), colSpec, orientation));
        cmp = (JComponent)cmp.getComponent(0);
        cmp.setFont(cmp.getFont().deriveFont(1));
        builder.addLabel(Messages.getString("NetworkTab.0"), FormLayoutUtil.flip(cc.xy(1, 7), colSpec, orientation));
        final KeyedComboBoxModel kcbm = new KeyedComboBoxModel(new Object[]{"ar", "bg", "ca", "zhs", "zht", "cz", "da", "nl", "en", "fi", "fr", "de", "el", "iw", "is", "it", "ja", "ko", "no", "pl", "pt", "br", "ro", "ru", "sl", "es", "sv", "tr"}, new Object[]{"Arabic", "Bulgarian", "Catalan", "Chinese (Simplified)", "Chinese (Traditional)", "Czech", "Danish", "Dutch", "English", "Finnish", "French", "German", "Greek", "Hebrew", "Icelandic", "Italian", "Japanese", "Korean", "Norwegian", "Polish", "Portuguese", "Portuguese (Brazilian)", "Romanian", "Russian", "Slovenian", "Spanish", "Swedish", "Turkish"});
        this.langs = new JComboBox(kcbm);
        this.langs.setEditable(false);
        String defaultLang = null;
        defaultLang = this.configuration.getLanguage() != null && this.configuration.getLanguage().length() > 0 ? this.configuration.getLanguage() : Locale.getDefault().getLanguage();
        if (defaultLang == null) {
            defaultLang = "en";
        }
        kcbm.setSelectedKey(defaultLang);
        if (this.langs.getSelectedIndex() == -1) {
            this.langs.setSelectedIndex(0);
        }
        this.langs.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GeneralTab.this.configuration.setLanguage((String)kcbm.getSelectedKey());
                }
            }
        });
        builder.add((Component)this.langs, FormLayoutUtil.flip(cc.xyw(3, 7, 7), colSpec, orientation));
        builder.add((Component)this.smcheckBox, FormLayoutUtil.flip(cc.xyw(1, 9, 9), colSpec, orientation));
        JButton service = new JButton(Messages.getString("NetworkTab.4"));
        service.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PMS.get().installWin32Service()) {
                    JOptionPane.showMessageDialog((JFrame)SwingUtilities.getWindowAncestor((Component)((Object)PMS.get().getFrame())), Messages.getString("NetworkTab.11") + Messages.getString("NetworkTab.12"), Messages.getString("Dialog.Information"), 1);
                } else {
                    JOptionPane.showMessageDialog((JFrame)SwingUtilities.getWindowAncestor((Component)((Object)PMS.get().getFrame())), Messages.getString("NetworkTab.14"), Messages.getString("Dialog.Error"), 0);
                }
            }
        });
        builder.add((Component)service, FormLayoutUtil.flip(cc.xy(1, 11), colSpec, orientation));
        if (System.getProperty("start.service") != null || !Platform.isWindows()) {
            service.setEnabled(false);
        }
        JButton checkForUpdates = new JButton(Messages.getString("NetworkTab.8"));
        checkForUpdates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LooksFrame frame = (LooksFrame)PMS.get().getFrame();
                frame.checkForUpdates();
            }
        });
        builder.add((Component)checkForUpdates, FormLayoutUtil.flip(cc.xy(1, 13), colSpec, orientation));
        this.autoUpdateCheckBox = new JCheckBox(Messages.getString("NetworkTab.9"));
        this.autoUpdateCheckBox.setContentAreaFilled(false);
        this.autoUpdateCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GeneralTab.this.configuration.setAutoUpdate(e.getStateChange() == 1);
            }
        });
        if (this.configuration.isAutoUpdate()) {
            this.autoUpdateCheckBox.setSelected(true);
        }
        builder.add((Component)this.autoUpdateCheckBox, FormLayoutUtil.flip(cc.xyw(7, 13, 3), colSpec, orientation));
        if (!Build.isUpdatable()) {
            checkForUpdates.setEnabled(false);
            this.autoUpdateCheckBox.setEnabled(false);
        }
        this.host = new JTextField(this.configuration.getServerHostname());
        this.host.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                GeneralTab.this.configuration.setHostname(GeneralTab.this.host.getText());
            }
        });
        this.port = new JTextField(this.configuration.getServerPort() != 5001 ? "" + this.configuration.getServerPort() : "");
        this.port.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    String p = GeneralTab.this.port.getText();
                    if (StringUtils.isEmpty(p)) {
                        p = "5001";
                    }
                    int ab = Integer.parseInt(p);
                    GeneralTab.this.configuration.setServerPort(ab);
                }
                catch (NumberFormatException nfe) {
                    logger.debug("Could not parse port from \"" + GeneralTab.this.port.getText() + "\"");
                }
            }
        });
        cmp = builder.addSeparator(Messages.getString("NetworkTab.22"), FormLayoutUtil.flip(cc.xyw(1, 21, 9), colSpec, orientation));
        cmp = (JComponent)cmp.getComponent(0);
        cmp.setFont(cmp.getFont().deriveFont(1));
        final KeyedComboBoxModel networkInterfaces = this.createNetworkInterfacesModel();
        this.networkinterfacesCBX = new JComboBox(networkInterfaces);
        networkInterfaces.setSelectedKey(this.configuration.getNetworkInterface());
        this.networkinterfacesCBX.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GeneralTab.this.configuration.setNetworkInterface((String)networkInterfaces.getSelectedKey());
                }
            }
        });
        this.ip_filter = new JTextField(this.configuration.getIpFilter());
        this.ip_filter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                GeneralTab.this.configuration.setIpFilter(GeneralTab.this.ip_filter.getText());
            }
        });
        this.maxbitrate = new JTextField(this.configuration.getMaximumBitrate());
        this.maxbitrate.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                PMS.getConfiguration().setMaximumBitrate(GeneralTab.this.maxbitrate.getText());
            }
        });
        builder.addLabel(Messages.getString("NetworkTab.20"), FormLayoutUtil.flip(cc.xy(1, 23), colSpec, orientation));
        builder.add((Component)this.networkinterfacesCBX, FormLayoutUtil.flip(cc.xyw(3, 23, 7), colSpec, orientation));
        builder.addLabel(Messages.getString("NetworkTab.23"), FormLayoutUtil.flip(cc.xy(1, 25), colSpec, orientation));
        builder.add((Component)this.host, FormLayoutUtil.flip(cc.xyw(3, 25, 7), colSpec, orientation));
        builder.addLabel(Messages.getString("NetworkTab.24"), FormLayoutUtil.flip(cc.xy(1, 27), colSpec, orientation));
        builder.add((Component)this.port, FormLayoutUtil.flip(cc.xyw(3, 27, 7), colSpec, orientation));
        builder.addLabel(Messages.getString("NetworkTab.30"), FormLayoutUtil.flip(cc.xy(1, 29), colSpec, orientation));
        builder.add((Component)this.ip_filter, FormLayoutUtil.flip(cc.xyw(3, 29, 7), colSpec, orientation));
        builder.addLabel(Messages.getString("NetworkTab.35"), FormLayoutUtil.flip(cc.xy(1, 31), colSpec, orientation));
        builder.add((Component)this.maxbitrate, FormLayoutUtil.flip(cc.xyw(3, 31, 7), colSpec, orientation));
        cmp = builder.addSeparator(Messages.getString("NetworkTab.31"), FormLayoutUtil.flip(cc.xyw(1, 33, 9), colSpec, orientation));
        cmp = (JComponent)cmp.getComponent(0);
        cmp.setFont(cmp.getFont().deriveFont(1));
        this.newHTTPEngine = new JCheckBox(Messages.getString("NetworkTab.32"));
        this.newHTTPEngine.setSelected(this.configuration.isHTTPEngineV2());
        this.newHTTPEngine.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GeneralTab.this.configuration.setHTTPEngineV2(e.getStateChange() == 1);
            }
        });
        builder.add((Component)this.newHTTPEngine, FormLayoutUtil.flip(cc.xyw(1, 35, 9), colSpec, orientation));
        this.preventSleep = new JCheckBox(Messages.getString("NetworkTab.33"));
        this.preventSleep.setSelected(this.configuration.isPreventsSleep());
        this.preventSleep.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GeneralTab.this.configuration.setPreventsSleep(e.getStateChange() == 1);
            }
        });
        builder.add((Component)this.preventSleep, FormLayoutUtil.flip(cc.xyw(1, 37, 9), colSpec, orientation));
        JCheckBox fdCheckBox = new JCheckBox(Messages.getString("NetworkTab.38"));
        fdCheckBox.setContentAreaFilled(false);
        fdCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GeneralTab.this.configuration.setRendererForceDefault(e.getStateChange() == 1);
            }
        });
        if (this.configuration.isRendererForceDefault()) {
            fdCheckBox.setSelected(true);
        }
        builder.addLabel(Messages.getString("NetworkTab.36"), FormLayoutUtil.flip(cc.xy(1, 39), colSpec, orientation));
        ArrayList<RendererConfiguration> allConfs = RendererConfiguration.getAllRendererConfigurations();
        ArrayList<String> keyValues = new ArrayList<String>();
        ArrayList<String> nameValues = new ArrayList<String>();
        keyValues.add("");
        nameValues.add(Messages.getString("NetworkTab.37"));
        if (allConfs != null) {
            for (RendererConfiguration renderer : allConfs) {
                if (renderer == null) continue;
                keyValues.add(renderer.getRendererName());
                nameValues.add(renderer.getRendererName());
            }
        }
        KeyedComboBoxModel renderersKcbm = new KeyedComboBoxModel(keyValues.toArray(new Object[keyValues.size()]), nameValues.toArray(new Object[nameValues.size()]));
        this.renderers = new JComboBox(renderersKcbm);
        this.renderers.setEditable(false);
        String defaultRenderer = this.configuration.getRendererDefault();
        renderersKcbm.setSelectedKey(defaultRenderer);
        if (this.renderers.getSelectedIndex() == -1) {
            this.renderers.setSelectedIndex(0);
        }
        builder.add((Component)this.renderers, FormLayoutUtil.flip(cc.xyw(3, 39, 7), colSpec, orientation));
        builder.add((Component)fdCheckBox, FormLayoutUtil.flip(cc.xyw(1, 41, 9), colSpec, orientation));
        cmp = builder.addSeparator(Messages.getString("NetworkTab.34"), FormLayoutUtil.flip(cc.xyw(1, 43, 9), colSpec, orientation));
        cmp = (JComponent)cmp.getComponent(0);
        cmp.setFont(cmp.getFont().deriveFont(1));
        this.pPlugins = new JPanel(new GridLayout());
        builder.add((Component)this.pPlugins, FormLayoutUtil.flip(cc.xyw(1, 45, 9), colSpec, orientation));
        JPanel panel = builder.getPanel();
        panel.applyComponentOrientation(orientation);
        JScrollPane scrollPane = new JScrollPane(panel, 20, 30);
        return scrollPane;
    }

    private KeyedComboBoxModel createNetworkInterfacesModel() {
        List<String> keys = NetworkConfiguration.getInstance().getKeys();
        List<String> names = NetworkConfiguration.getInstance().getDisplayNames();
        keys.add(0, "");
        names.add(0, "");
        KeyedComboBoxModel networkInterfaces = new KeyedComboBoxModel(keys.toArray(), names.toArray());
        return networkInterfaces;
    }

    public void addRenderers() {
        ArrayList<RendererConfiguration> allConfs = RendererConfiguration.getAllRendererConfigurations();
        ArrayList<String> keyValues = new ArrayList<String>();
        ArrayList<String> nameValues = new ArrayList<String>();
        keyValues.add("");
        nameValues.add(Messages.getString("NetworkTab.37"));
        if (allConfs != null) {
            for (RendererConfiguration renderer : allConfs) {
                if (renderer == null) continue;
                keyValues.add(renderer.getRendererName());
                nameValues.add(renderer.getRendererName());
            }
        }
        final KeyedComboBoxModel renderersKcbm = new KeyedComboBoxModel(keyValues.toArray(new Object[keyValues.size()]), nameValues.toArray(new Object[nameValues.size()]));
        this.renderers.setModel(renderersKcbm);
        this.renderers.setEditable(false);
        String defaultRenderer = this.configuration.getRendererDefault();
        renderersKcbm.setSelectedKey(defaultRenderer);
        if (this.renderers.getSelectedIndex() == -1) {
            this.renderers.setSelectedIndex(0);
        }
        this.renderers.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    logger.info("Setting renderer default: \"" + renderersKcbm.getSelectedKey() + "\"");
                    GeneralTab.this.configuration.setRendererDefault((String)renderersKcbm.getSelectedKey());
                }
            }
        });
    }

    public void addPlugins() {
        FormLayout layout = new FormLayout("fill:10:grow", "p, p, p, p, p, p, p, p, p, p, p, p, p, p, p, p, p, p, p, p, p, p, p, p, p, p, p, p, p, p");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        int i = 1;
        for (final ExternalListener listener : ExternalFactory.getExternalListeners()) {
            if (i > 30) {
                logger.warn("Plugin limit of 30 has been reached");
                break;
            }
            JButton bPlugin = new JButton(listener.name());
            bPlugin.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showOptionDialog((JFrame)SwingUtilities.getWindowAncestor((Component)((Object)PMS.get().getFrame())), listener.config(), Messages.getString("Dialog.Options"), -1, -1, null, null, null);
                }
            });
            builder.add((Component)bPlugin, cc.xy(1, i++));
        }
        this.pPlugins.add(builder.getPanel());
    }
}

