/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.Executors;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.network.HttpServerPipelineFactory;
import net.pms.network.NetworkConfiguration;
import net.pms.network.RequestHandler;
import org.apache.commons.lang3.StringUtils;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPServer
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(HTTPServer.class);
    private static final PmsConfiguration configuration = PMS.getConfiguration();
    private final int port;
    private String hostname;
    private ServerSocketChannel serverSocketChannel;
    private ServerSocket serverSocket;
    private boolean stop;
    private Thread runnable;
    private InetAddress iafinal;
    private ChannelFactory factory;
    private Channel channel;
    private NetworkInterface networkInterface;
    private ChannelGroup group;

    @Deprecated
    public InetAddress getIafinal() {
        return this.iafinal;
    }

    public NetworkInterface getNetworkInterface() {
        return this.networkInterface;
    }

    @Deprecated
    public NetworkInterface getNi() {
        return this.getNetworkInterface();
    }

    public HTTPServer(int port) {
        this.port = port;
    }

    public String getURL() {
        return "http://" + this.hostname + ":" + this.port;
    }

    public String getHost() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean start() throws IOException {
        InetSocketAddress address;
        this.hostname = configuration.getServerHostname();
        if (StringUtils.isNotBlank(this.hostname)) {
            logger.info("Using forced address " + this.hostname);
            InetAddress tempIA = InetAddress.getByName(this.hostname);
            address = tempIA != null && this.networkInterface != null && this.networkInterface.equals(NetworkInterface.getByInetAddress(tempIA)) ? new InetSocketAddress(tempIA, this.port) : new InetSocketAddress(this.hostname, this.port);
        } else if (this.isAddressFromInterfaceFound(configuration.getNetworkInterface())) {
            logger.info("Using address {} found on network interface: {}", (Object)this.iafinal, (Object)this.networkInterface.toString().trim().replace('\n', ' '));
            address = new InetSocketAddress(this.iafinal, this.port);
        } else {
            logger.info("Using localhost address");
            address = new InetSocketAddress(this.port);
        }
        logger.info("Created socket: " + address);
        if (configuration.isHTTPEngineV2()) {
            this.group = new DefaultChannelGroup("myServer");
            this.factory = new NioServerSocketChannelFactory(Executors.newCachedThreadPool(), Executors.newCachedThreadPool());
            ServerBootstrap bootstrap = new ServerBootstrap(this.factory);
            HttpServerPipelineFactory pipeline = new HttpServerPipelineFactory(this.group);
            bootstrap.setPipelineFactory(pipeline);
            bootstrap.setOption("child.tcpNoDelay", true);
            bootstrap.setOption("child.keepAlive", true);
            bootstrap.setOption("reuseAddress", true);
            bootstrap.setOption("child.reuseAddress", true);
            bootstrap.setOption("child.sendBufferSize", 65536);
            bootstrap.setOption("child.receiveBufferSize", 65536);
            this.channel = bootstrap.bind(address);
            this.group.add(this.channel);
            if (this.hostname == null && this.iafinal != null) {
                this.hostname = this.iafinal.getHostAddress();
            } else if (this.hostname == null) {
                this.hostname = InetAddress.getLocalHost().getHostAddress();
            }
        } else {
            this.serverSocketChannel = ServerSocketChannel.open();
            this.serverSocket = this.serverSocketChannel.socket();
            this.serverSocket.setReuseAddress(true);
            this.serverSocket.bind(address);
            if (this.hostname == null && this.iafinal != null) {
                this.hostname = this.iafinal.getHostAddress();
            } else if (this.hostname == null) {
                this.hostname = InetAddress.getLocalHost().getHostAddress();
            }
            this.runnable = new Thread((Runnable)this, "HTTP Server");
            this.runnable.setDaemon(false);
            this.runnable.start();
        }
        return true;
    }

    private boolean isAddressFromInterfaceFound(String networkInterfaceName) {
        NetworkConfiguration.InterfaceAssociation ia;
        NetworkConfiguration.InterfaceAssociation interfaceAssociation = ia = StringUtils.isNotEmpty(networkInterfaceName) ? NetworkConfiguration.getInstance().getAddressForNetworkInterfaceName(networkInterfaceName) : null;
        if (ia == null) {
            ia = NetworkConfiguration.getInstance().getDefaultNetworkInterfaceAddress();
        }
        if (ia != null) {
            this.iafinal = ia.getAddr();
            this.networkInterface = ia.getIface();
        }
        return ia != null;
    }

    public void stop() {
        logger.info("Stopping server on host {} and port {}...", (Object)this.hostname, (Object)this.port);
        if (this.runnable != null) {
            this.runnable.interrupt();
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
                this.serverSocketChannel.close();
            }
            catch (IOException e) {
                logger.debug("Caught exception", e);
            }
        }
        if (this.channel != null) {
            if (this.group != null) {
                this.group.close().awaitUninterruptibly();
            }
            if (this.factory != null) {
                this.factory.releaseExternalResources();
            }
        }
        NetworkConfiguration.forgetConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info("Starting DLNA Server on host {} and port {}...", (Object)this.hostname, (Object)this.port);
        while (!this.stop) {
            try {
                Socket socket = this.serverSocket.accept();
                InetAddress inetAddress = socket.getInetAddress();
                String ip = inetAddress.getHostAddress();
                boolean ignore = false;
                if (configuration.getIpFiltering().allowed(inetAddress)) {
                    logger.trace("Receiving a request from: " + ip);
                } else {
                    ignore = true;
                    socket.close();
                    logger.trace("Ignoring request from: " + ip);
                }
                if (ignore) continue;
                RequestHandler request = new RequestHandler(socket);
                Thread thread = new Thread((Runnable)request, "Request Handler");
                thread.start();
            }
            catch (ClosedByInterruptException e) {
                this.stop = true;
            }
            catch (IOException e) {
                logger.debug("Caught exception", e);
            }
            finally {
                try {
                    if (this.stop && this.serverSocket != null) {
                        this.serverSocket.close();
                    }
                    if (!this.stop || this.serverSocketChannel == null) continue;
                    this.serverSocketChannel.close();
                }
                catch (IOException e) {
                    logger.debug("Caught exception", e);
                }
            }
        }
    }
}

