/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.pms.Messages;
import net.pms.configuration.PmsConfiguration;
import net.pms.configuration.RendererConfiguration;
import net.pms.dlna.DLNAMediaAudio;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.DLNAResource;
import net.pms.dlna.InputFile;
import net.pms.encoders.Player;
import net.pms.encoders.PlayerPurpose;
import net.pms.encoders.TsMuxeRAudio;
import net.pms.formats.Format;
import net.pms.formats.v2.AudioUtils;
import net.pms.io.OutputParams;
import net.pms.io.PipeIPCProcess;
import net.pms.io.PipeProcess;
import net.pms.io.ProcessWrapper;
import net.pms.io.ProcessWrapperImpl;
import net.pms.io.StreamModifier;
import net.pms.util.CodecUtil;
import net.pms.util.FormLayoutUtil;
import net.pms.util.PlayerUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsMuxeRVideo
extends Player {
    private static final Logger logger = LoggerFactory.getLogger(TsMuxeRVideo.class);
    private static final String COL_SPEC = "left:pref, 0:grow";
    private static final String ROW_SPEC = "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, 0:grow";
    public static final String ID = "tsmuxer";
    private PmsConfiguration configuration;
    private JCheckBox tsmuxerforcefps;
    private JCheckBox muxallaudiotracks;

    public TsMuxeRVideo(PmsConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public boolean excludeFormat(Format format) {
        String extension = format.getMatchedExtension();
        return extension != null && !extension.equals("mp4") && !extension.equals("mkv") && !extension.equals("ts") && !extension.equals("tp") && !extension.equals("m2ts") && !extension.equals("m2t") && !extension.equals("mpg") && !extension.equals("evo") && !extension.equals("mpeg") && !extension.equals("vob") && !extension.equals("m2v") && !extension.equals("mts") && !extension.equals("mov");
    }

    @Override
    public PlayerPurpose getPurpose() {
        return PlayerPurpose.VIDEO_FILE_PLAYER;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public boolean isTimeSeekable() {
        return true;
    }

    @Override
    public String[] args() {
        return null;
    }

    @Override
    public String executable() {
        return this.configuration.getTsmuxerPath();
    }

    @Override
    public ProcessWrapper launchTranscode(DLNAResource dlna, DLNAMediaInfo media, OutputParams params) throws IOException {
        boolean mp4_with_non_h264;
        ProcessWrapperImpl ffVideo;
        String[] ffmpegLPCMextract;
        PipeIPCProcess ffVideoPipe;
        String filename = dlna.getSystemName();
        this.setAudioAndSubs(filename, media, params, this.configuration);
        PipeIPCProcess[] ffAudioPipe = null;
        ProcessWrapperImpl[] ffAudio = null;
        String fps = media.getValidFps(false);
        int width = media.getWidth();
        int height = media.getHeight();
        if (width < 320 || height < 240) {
            width = -1;
            height = -1;
        }
        String videoType = "V_MPEG4/ISO/AVC";
        if (StringUtils.startsWith(media.getCodecV(), "mpeg2")) {
            videoType = "V_MPEG-2";
        }
        if (this instanceof TsMuxeRAudio && media.getFirstAudioTrack() != null) {
            String fakeFileName = this.writeResourceToFile("/resources/images/fake.jpg");
            ffVideoPipe = new PipeIPCProcess(System.currentTimeMillis() + "fakevideo", System.currentTimeMillis() + "videoout", false, true);
            String timeEndValue1 = "-t";
            String timeEndValue2 = "" + params.timeend;
            if (params.timeend < 1.0) {
                timeEndValue1 = "-y";
                timeEndValue2 = "-y";
            }
            ffmpegLPCMextract = new String[]{this.configuration.getFfmpegPath(), timeEndValue1, timeEndValue2, "-loop", "1", "-i", fakeFileName, "-qcomp", "0.6", "-qmin", "10", "-qmax", "51", "-qdiff", "4", "-me_range", "4", "-f", "h264", "-vcodec", "libx264", "-an", "-y", ffVideoPipe.getInputPipe()};
            videoType = "V_MPEG4/ISO/AVC";
            OutputParams ffparams = new OutputParams(this.configuration);
            ffparams.maxBufferSize = 1.0;
            ffVideo = new ProcessWrapperImpl(ffmpegLPCMextract, ffparams);
            if (filename.toLowerCase().endsWith(".flac") && media.getFirstAudioTrack().getBitsperSample() >= 24 && media.getFirstAudioTrack().getSampleRate() % 48000 == 0) {
                ffAudioPipe = new PipeIPCProcess[]{new PipeIPCProcess(System.currentTimeMillis() + "flacaudio", System.currentTimeMillis() + "audioout", false, true)};
                String[] flacCmd = new String[]{this.configuration.getFlacPath(), "--output-name=" + ffAudioPipe[0].getInputPipe(), "-d", "-f", "-F", filename};
                ffparams = new OutputParams(this.configuration);
                ffparams.maxBufferSize = 1.0;
                ffAudio = new ProcessWrapperImpl[]{new ProcessWrapperImpl(flacCmd, ffparams)};
            } else {
                ffAudioPipe = new PipeIPCProcess[]{new PipeIPCProcess(System.currentTimeMillis() + "mlpaudio", System.currentTimeMillis() + "audioout", false, true)};
                String depth = "pcm_s16le";
                String rate = "48000";
                if (media.getFirstAudioTrack().getBitsperSample() >= 24) {
                    depth = "pcm_s24le";
                }
                if (media.getFirstAudioTrack().getSampleRate() > 48000) {
                    rate = "" + media.getFirstAudioTrack().getSampleRate();
                }
                String[] flacCmd = new String[]{this.configuration.getFfmpegPath(), "-i", filename, "-ar", rate, "-f", "wav", "-acodec", depth, "-y", ffAudioPipe[0].getInputPipe()};
                ffparams = new OutputParams(this.configuration);
                ffparams.maxBufferSize = 1.0;
                ffAudio = new ProcessWrapperImpl[]{new ProcessWrapperImpl(flacCmd, ffparams)};
            }
        } else {
            boolean singleMediaAudio;
            params.waitbeforestart = 5000;
            params.manageFastStart();
            String mencoderPath = this.configuration.getMencoderPath();
            ffVideoPipe = new PipeIPCProcess(System.currentTimeMillis() + "ffmpegvideo", System.currentTimeMillis() + "videoout", false, true);
            String evoValue1 = "-quiet";
            String evoValue2 = "-quiet";
            if (filename.toLowerCase().endsWith(".evo")) {
                evoValue1 = "-psprobe";
                evoValue2 = "1000000";
            }
            ffmpegLPCMextract = new String[]{mencoderPath, "-ss", params.timeseek > 0.0 ? "" + params.timeseek : "0", params.stdin != null ? "-" : filename, evoValue1, evoValue2, "-really-quiet", "-msglevel", "statusline=2", "-ovc", "copy", "-nosound", "-mc", "0", "-noskip", "-of", "rawvideo", "-o", ffVideoPipe.getInputPipe()};
            InputFile newInput = new InputFile();
            newInput.setFilename(filename);
            newInput.setPush(params.stdin);
            if (media != null) {
                boolean compat;
                boolean bl = compat = media.isMediaparsed() && (newInput != null && media.isVideoWithinH264LevelLimits(newInput, params.mediaRenderer) || !params.mediaRenderer.isH264Level41Limited());
                if (!compat && params.mediaRenderer.isPS3()) {
                    logger.info("The video will not play or will show a black screen on the PS3...");
                }
                if (media.getH264AnnexB() != null && media.getH264AnnexB().length > 0) {
                    StreamModifier sm = new StreamModifier();
                    sm.setHeader(media.getH264AnnexB());
                    sm.setH264AnnexB(true);
                    ffVideoPipe.setModifier(sm);
                }
            }
            OutputParams ffparams = new OutputParams(this.configuration);
            ffparams.maxBufferSize = 1.0;
            ffparams.stdin = params.stdin;
            ffVideo = new ProcessWrapperImpl(ffmpegLPCMextract, ffparams);
            int numAudioTracks = 1;
            if (media.getAudioTracksList() != null && media.getAudioTracksList().size() > 1 && this.configuration.isMuxAllAudioTracks()) {
                numAudioTracks = media.getAudioTracksList().size();
            }
            boolean bl = singleMediaAudio = media.getAudioTracksList().size() <= 1;
            if (params.aid != null) {
                boolean pcm;
                boolean dtsRemux;
                boolean ac3Remux;
                boolean mp4_with_non_h2642;
                boolean bl2 = mp4_with_non_h2642 = media.getContainer().equals("mp4") && !media.getCodecV().equals("h264");
                if (numAudioTracks <= 1) {
                    ffAudioPipe = new PipeIPCProcess[numAudioTracks];
                    ffAudioPipe[0] = new PipeIPCProcess(System.currentTimeMillis() + "ffmpegaudio01", System.currentTimeMillis() + "audioout", false, true);
                    boolean ps3_and_stereo_and_384_kbits = false;
                    ac3Remux = params.aid.isAC3() && this.configuration.isAudioRemuxAC3();
                    dtsRemux = this.configuration.isAudioEmbedDtsInPcm() && params.aid.isDTS() && params.mediaRenderer.isDTSPlayable();
                    boolean bl3 = pcm = this.configuration.isAudioUsePCM() && !mp4_with_non_h2642 && (params.aid.isLossless() || params.aid.isDTS() && params.aid.getAudioProperties().getNumberOfChannels() <= 6 || params.aid.isTrueHD() || !this.configuration.isMencoderUsePcmForHQAudioOnly() && (params.aid.isAC3() || params.aid.isMP3() || params.aid.isAAC() || params.aid.isVorbis() || params.aid.isMpegAudio())) && params.mediaRenderer.isLPCMPlayable();
                    int channels = ac3Remux ? params.aid.getAudioProperties().getNumberOfChannels() : (dtsRemux ? 2 : (pcm ? params.aid.getAudioProperties().getNumberOfChannels() : this.configuration.getAudioChannelCount()));
                    if (!ac3Remux && (dtsRemux || pcm)) {
                        StreamModifier sm = new StreamModifier();
                        sm.setPcm(pcm);
                        sm.setDtsEmbed(dtsRemux);
                        sm.setNbChannels(channels);
                        sm.setSampleFrequency(params.aid.getSampleRate() < 48000 ? 48000 : params.aid.getSampleRate());
                        sm.setBitsPerSample(16);
                        String mixer = null;
                        if (pcm && !dtsRemux) {
                            mixer = AudioUtils.getLPCMChannelMappingForMencoder(params.aid);
                        }
                        ffmpegLPCMextract = new String[]{mencoderPath, "-ss", params.timeseek > 0.0 ? "" + params.timeseek : "0", params.stdin != null ? "-" : filename, evoValue1, evoValue2, "-really-quiet", "-msglevel", "statusline=2", "-channels", "" + sm.getNbChannels(), "-ovc", "copy", "-of", "rawaudio", "-mc", sm.isDtsEmbed() ? "0.1" : "0", "-noskip", "-oac", sm.isDtsEmbed() ? "copy" : "pcm", StringUtils.isNotBlank(mixer) ? "-af" : "-quiet", StringUtils.isNotBlank(mixer) ? mixer : "-quiet", singleMediaAudio ? "-quiet" : "-aid", singleMediaAudio ? "-quiet" : "" + params.aid.getId(), "-srate", "48000", "-o", ffAudioPipe[0].getInputPipe()};
                        if (!params.mediaRenderer.isMuxDTSToMpeg()) {
                            ffAudioPipe[0].setModifier(sm);
                        }
                    } else {
                        ffmpegLPCMextract = new String[]{mencoderPath, "-ss", params.timeseek > 0.0 ? "" + params.timeseek : "0", params.stdin != null ? "-" : filename, evoValue1, evoValue2, "-really-quiet", "-msglevel", "statusline=2", "-channels", "" + channels, "-ovc", "copy", "-of", "rawaudio", "-mc", "0", "-noskip", "-oac", ac3Remux ? "copy" : "lavc", params.aid.isAC3() ? "-fafmttag" : "-quiet", params.aid.isAC3() ? "0x2000" : "-quiet", "-lavcopts", "acodec=" + (this.configuration.isMencoderAc3Fixed() ? "ac3_fixed" : "ac3") + ":abitrate=" + CodecUtil.getAC3Bitrate(this.configuration, params.aid), "-af", "lavcresample=48000", "-srate", "48000", singleMediaAudio ? "-quiet" : "-aid", singleMediaAudio ? "-quiet" : "" + params.aid.getId(), "-o", ffAudioPipe[0].getInputPipe()};
                    }
                    ffparams = new OutputParams(this.configuration);
                    ffparams.maxBufferSize = 1.0;
                    ffparams.stdin = params.stdin;
                    ffAudio = new ProcessWrapperImpl[numAudioTracks];
                    ffAudio[0] = new ProcessWrapperImpl(ffmpegLPCMextract, ffparams);
                } else {
                    ffAudioPipe = new PipeIPCProcess[numAudioTracks];
                    ffAudio = new ProcessWrapperImpl[numAudioTracks];
                    for (int i = 0; i < media.getAudioTracksList().size(); ++i) {
                        DLNAMediaAudio audio = media.getAudioTracksList().get(i);
                        ffAudioPipe[i] = new PipeIPCProcess(System.currentTimeMillis() + "ffmpeg" + i, System.currentTimeMillis() + "audioout" + i, false, true);
                        boolean ps3_and_stereo_and_384_kbits = false;
                        ac3Remux = audio.isAC3() && this.configuration.isAudioRemuxAC3();
                        dtsRemux = this.configuration.isAudioEmbedDtsInPcm() && audio.isDTS() && params.mediaRenderer.isDTSPlayable();
                        boolean bl4 = pcm = this.configuration.isAudioUsePCM() && !mp4_with_non_h2642 && (audio.isLossless() || audio.isDTS() && audio.getAudioProperties().getNumberOfChannels() <= 6 || audio.isTrueHD() || !this.configuration.isMencoderUsePcmForHQAudioOnly() && (audio.isAC3() || audio.isMP3() || audio.isAAC() || audio.isVorbis() || audio.isMpegAudio())) && params.mediaRenderer.isLPCMPlayable();
                        int channels = ac3Remux ? audio.getAudioProperties().getNumberOfChannels() : (dtsRemux ? 2 : (pcm ? audio.getAudioProperties().getNumberOfChannels() : this.configuration.getAudioChannelCount()));
                        if (!ac3Remux && (dtsRemux || pcm)) {
                            StreamModifier sm = new StreamModifier();
                            sm.setPcm(pcm);
                            sm.setDtsEmbed(dtsRemux);
                            sm.setNbChannels(channels);
                            sm.setSampleFrequency(audio.getSampleRate() < 48000 ? 48000 : audio.getSampleRate());
                            sm.setBitsPerSample(16);
                            if (!params.mediaRenderer.isMuxDTSToMpeg()) {
                                ffAudioPipe[i].setModifier(sm);
                            }
                            String mixer = null;
                            if (pcm && !dtsRemux) {
                                mixer = AudioUtils.getLPCMChannelMappingForMencoder(audio);
                            }
                            ffmpegLPCMextract = new String[]{mencoderPath, "-ss", params.timeseek > 0.0 ? "" + params.timeseek : "0", params.stdin != null ? "-" : filename, evoValue1, evoValue2, "-really-quiet", "-msglevel", "statusline=2", "-channels", "" + sm.getNbChannels(), "-ovc", "copy", "-of", "rawaudio", "-mc", sm.isDtsEmbed() ? "0.1" : "0", "-noskip", "-oac", sm.isDtsEmbed() ? "copy" : "pcm", StringUtils.isNotBlank(mixer) ? "-af" : "-quiet", StringUtils.isNotBlank(mixer) ? mixer : "-quiet", singleMediaAudio ? "-quiet" : "-aid", singleMediaAudio ? "-quiet" : "" + audio.getId(), "-srate", "48000", "-o", ffAudioPipe[i].getInputPipe()};
                        } else {
                            ffmpegLPCMextract = new String[]{mencoderPath, "-ss", params.timeseek > 0.0 ? "" + params.timeseek : "0", params.stdin != null ? "-" : filename, evoValue1, evoValue2, "-really-quiet", "-msglevel", "statusline=2", "-channels", "" + channels, "-ovc", "copy", "-of", "rawaudio", "-mc", "0", "-noskip", "-oac", ac3Remux ? "copy" : "lavc", audio.isAC3() ? "-fafmttag" : "-quiet", audio.isAC3() ? "0x2000" : "-quiet", "-lavcopts", "acodec=" + (this.configuration.isMencoderAc3Fixed() ? "ac3_fixed" : "ac3") + ":abitrate=" + CodecUtil.getAC3Bitrate(this.configuration, audio), "-af", "lavcresample=48000", "-srate", "48000", singleMediaAudio ? "-quiet" : "-aid", singleMediaAudio ? "-quiet" : "" + audio.getId(), "-o", ffAudioPipe[i].getInputPipe()};
                        }
                        ffparams = new OutputParams(this.configuration);
                        ffparams.maxBufferSize = 1.0;
                        ffparams.stdin = params.stdin;
                        ffAudio[i] = new ProcessWrapperImpl(ffmpegLPCMextract, ffparams);
                    }
                }
            }
        }
        File f = new File(this.configuration.getTempFolder(), "pms-tsmuxer.meta");
        params.log = false;
        PrintWriter pw = new PrintWriter(f);
        pw.print("MUXOPT --no-pcr-on-video-pid");
        pw.print(" --new-audio-pes");
        pw.print(" --no-asyncio");
        pw.print(" --vbr");
        pw.println(" --vbv-len=500");
        String videoparams = "level=4.1, insertSEI, contSPS, track=1";
        if (this instanceof TsMuxeRAudio) {
            videoparams = "track=224";
        }
        if (this.configuration.isFix25FPSAvMismatch()) {
            fps = "25";
        }
        pw.println(videoType + ", \"" + ffVideoPipe.getOutputPipe() + "\", " + (fps != null ? "fps=" + fps + ", " : "") + (width != -1 ? "video-width=" + width + ", " : "") + (height != -1 ? "video-height=" + height + ", " : "") + videoparams);
        boolean bl = mp4_with_non_h264 = media.getContainer().equals("mp4") && !media.getCodecV().equals("h264");
        if (ffAudioPipe != null && ffAudioPipe.length == 1) {
            String timeshift = "";
            boolean ps3_and_stereo_and_384_kbits = false;
            boolean ac3Remux = params.aid.isAC3() && this.configuration.isAudioRemuxAC3();
            boolean dtsRemux = this.configuration.isAudioEmbedDtsInPcm() && params.aid.isDTS() && params.mediaRenderer.isDTSPlayable();
            boolean pcm = this.configuration.isAudioUsePCM() && !mp4_with_non_h264 && (params.aid.isLossless() || params.aid.isDTS() && params.aid.getAudioProperties().getNumberOfChannels() <= 6 || params.aid.isTrueHD() || !this.configuration.isMencoderUsePcmForHQAudioOnly() && (params.aid.isAC3() || params.aid.isMP3() || params.aid.isAAC() || params.aid.isVorbis() || params.aid.isMpegAudio())) && params.mediaRenderer.isLPCMPlayable();
            String type = "A_AC3";
            if (ac3Remux) {
                type = "A_AC3";
            } else {
                if (pcm || this instanceof TsMuxeRAudio) {
                    type = "A_LPCM";
                }
                if (dtsRemux || this instanceof TsMuxeRAudio) {
                    type = "A_LPCM";
                    if (params.mediaRenderer.isMuxDTSToMpeg()) {
                        type = "A_DTS";
                    }
                }
            }
            if (params.aid != null && params.aid.getAudioProperties().getAudioDelay() != 0 && params.timeseek == 0.0) {
                timeshift = "timeshift=" + params.aid.getAudioProperties().getAudioDelay() + "ms, ";
            }
            pw.println(type + ", \"" + ffAudioPipe[0].getOutputPipe() + "\", " + timeshift + "track=2");
        } else if (ffAudioPipe != null) {
            for (int i = 0; i < media.getAudioTracksList().size(); ++i) {
                DLNAMediaAudio lang = media.getAudioTracksList().get(i);
                String timeshift = "";
                boolean ps3_and_stereo_and_384_kbits = false;
                boolean ac3Remux = lang.isAC3() && this.configuration.isAudioRemuxAC3();
                boolean dtsRemux = this.configuration.isAudioEmbedDtsInPcm() && lang.isDTS() && params.mediaRenderer.isDTSPlayable();
                boolean pcm = this.configuration.isAudioUsePCM() && !mp4_with_non_h264 && (lang.isLossless() || lang.isDTS() && lang.getAudioProperties().getNumberOfChannels() <= 6 || lang.isTrueHD() || !this.configuration.isMencoderUsePcmForHQAudioOnly() && (params.aid.isAC3() || params.aid.isMP3() || params.aid.isAAC() || params.aid.isVorbis() || params.aid.isMpegAudio())) && params.mediaRenderer.isLPCMPlayable();
                String type = "A_AC3";
                if (ac3Remux) {
                    type = "A_AC3";
                } else {
                    if (pcm) {
                        type = "A_LPCM";
                    }
                    if (dtsRemux) {
                        type = "A_LPCM";
                        if (params.mediaRenderer.isMuxDTSToMpeg()) {
                            type = "A_DTS";
                        }
                    }
                }
                if (lang.getAudioProperties().getAudioDelay() != 0 && params.timeseek == 0.0) {
                    timeshift = "timeshift=" + lang.getAudioProperties().getAudioDelay() + "ms, ";
                }
                pw.println(type + ", \"" + ffAudioPipe[i].getOutputPipe() + "\", " + timeshift + "track=" + (2 + i));
            }
        }
        pw.close();
        PipeProcess tsPipe = new PipeProcess(System.currentTimeMillis() + "tsmuxerout.ts", new String[0]);
        String[] cmdArray = new String[]{this.executable(), f.getAbsolutePath(), tsPipe.getInputPipe()};
        cmdArray = this.finalizeTranscoderArgs(filename, dlna, media, params, cmdArray);
        ProcessWrapperImpl p = new ProcessWrapperImpl(cmdArray, params);
        params.maxBufferSize = 100.0;
        params.input_pipes[0] = tsPipe;
        params.stdin = null;
        ProcessWrapper pipe_process = tsPipe.getPipeProcess();
        p.attachProcess(pipe_process);
        pipe_process.runInNewThread();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        tsPipe.deleteLater();
        ProcessWrapper ff_pipe_process = ffVideoPipe.getPipeProcess();
        p.attachProcess(ff_pipe_process);
        ff_pipe_process.runInNewThread();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ffVideoPipe.deleteLater();
        p.attachProcess(ffVideo);
        ffVideo.runInNewThread();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (ffAudioPipe != null && params.aid != null) {
            for (int i = 0; i < ffAudioPipe.length; ++i) {
                ff_pipe_process = ffAudioPipe[i].getPipeProcess();
                p.attachProcess(ff_pipe_process);
                ff_pipe_process.runInNewThread();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                ffAudioPipe[i].deleteLater();
                p.attachProcess(ffAudio[i]);
                ffAudio[i].runInNewThread();
            }
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        p.runInNewThread();
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeResourceToFile(String resourceName) {
        String outputFileName = resourceName.substring(resourceName.lastIndexOf("/") + 1);
        try {
            outputFileName = this.configuration.getTempFolder() + "/" + outputFileName;
        }
        catch (IOException e) {
            logger.warn("Failure to determine temporary folder.", e);
        }
        File outputFile = new File(outputFileName);
        if (!outputFile.exists()) {
            URL resourceUrl = this.getClass().getClassLoader().getResource(resourceName);
            byte[] buffer = new byte[1024];
            InputStream inputStream = null;
            FileOutputStream outputStream = null;
            try {
                int byteCount;
                inputStream = resourceUrl.openStream();
                outputStream = new FileOutputStream(outputFileName);
                while ((byteCount = inputStream.read(buffer)) >= 0) {
                    ((OutputStream)outputStream).write(buffer, 0, byteCount);
                }
            }
            catch (IOException e) {
                logger.error("Failure on saving the embedded resource " + resourceName + " to the file " + outputFile.getAbsolutePath(), e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        logger.warn("Problem closing an input stream while reading data from the embedded resource " + resourceName, e);
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                        ((OutputStream)outputStream).close();
                    }
                    catch (IOException e) {
                        logger.warn("Problem closing the output stream while writing the file " + outputFile.getAbsolutePath(), e);
                    }
                }
            }
        }
        return outputFileName;
    }

    @Override
    public String mimeType() {
        return "video/mpeg";
    }

    @Override
    public String name() {
        return "tsMuxeR";
    }

    @Override
    public int type() {
        return 4;
    }

    @Override
    public JComponent config() {
        Locale locale = new Locale(this.configuration.getLanguage());
        ComponentOrientation orientation = ComponentOrientation.getOrientation(locale);
        String colSpec = FormLayoutUtil.getColSpec(COL_SPEC, orientation);
        FormLayout layout = new FormLayout(colSpec, ROW_SPEC);
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setBorder(Borders.EMPTY_BORDER);
        builder.setOpaque(false);
        CellConstraints cc = new CellConstraints();
        JComponent cmp = builder.addSeparator(Messages.getString("TSMuxerVideo.3"), FormLayoutUtil.flip(cc.xyw(2, 1, 1), colSpec, orientation));
        cmp = (JComponent)cmp.getComponent(0);
        cmp.setFont(cmp.getFont().deriveFont(1));
        this.tsmuxerforcefps = new JCheckBox(Messages.getString("TSMuxerVideo.2"));
        this.tsmuxerforcefps.setContentAreaFilled(false);
        if (this.configuration.isTsmuxerForceFps()) {
            this.tsmuxerforcefps.setSelected(true);
        }
        this.tsmuxerforcefps.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TsMuxeRVideo.this.configuration.setTsmuxerForceFps(e.getStateChange() == 1);
            }
        });
        builder.add((Component)this.tsmuxerforcefps, FormLayoutUtil.flip(cc.xy(2, 3), colSpec, orientation));
        this.muxallaudiotracks = new JCheckBox(Messages.getString("TSMuxerVideo.19"));
        this.muxallaudiotracks.setContentAreaFilled(false);
        if (this.configuration.isMuxAllAudioTracks()) {
            this.muxallaudiotracks.setSelected(true);
        }
        this.muxallaudiotracks.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TsMuxeRVideo.this.configuration.setMuxAllAudioTracks(e.getStateChange() == 1);
            }
        });
        builder.add((Component)this.muxallaudiotracks, FormLayoutUtil.flip(cc.xy(2, 5), colSpec, orientation));
        JPanel panel = builder.getPanel();
        panel.applyComponentOrientation(orientation);
        return panel;
    }

    @Override
    public boolean isInternalSubtitlesSupported() {
        return false;
    }

    @Override
    public boolean isExternalSubtitlesSupported() {
        return false;
    }

    @Override
    public boolean isPlayerCompatible(RendererConfiguration mediaRenderer) {
        return mediaRenderer != null && mediaRenderer.isMuxH264MpegTS();
    }

    @Override
    public boolean isCompatible(DLNAResource dlna) {
        if (!PlayerUtil.isVideo(dlna, Format.Identifier.MKV) && !PlayerUtil.isVideo(dlna, Format.Identifier.MPG)) {
            return false;
        }
        if (dlna.isNoName()) {
            DLNAMediaAudio dlnaMediaAudio = dlna.getMediaAudio();
            if (dlnaMediaAudio != null && !dlnaMediaAudio.toString().equals(dlna.getMedia().getFirstAudioTrack().toString())) {
                return false;
            }
            if (dlna.getMediaSubtitle() != null && dlna.getMediaSubtitle().getLang() != null) {
                return false;
            }
        }
        return true;
    }
}

