/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import com.sun.syndication.feed.synd.SyndCategory;
import com.sun.syndication.feed.synd.SyndEnclosure;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.pms.dlna.DLNAResource;
import net.pms.dlna.FeedItem;
import org.apache.commons.lang3.StringUtils;
import org.jdom.Content;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Feed
extends DLNAResource {
    private static final Logger logger = LoggerFactory.getLogger(Feed.class);
    private static final int REFRESH_INTERVAL = 3600000;
    @Deprecated
    protected String name;
    @Deprecated
    protected String url;
    @Deprecated
    protected String tempItemTitle;
    @Deprecated
    protected String tempItemLink;
    @Deprecated
    protected String tempFeedLink;
    @Deprecated
    protected String tempCategory;
    @Deprecated
    protected String tempItemThumbURL;

    @Override
    protected void resolveOnce() {
        try {
            this.parse();
        }
        catch (Exception e) {
            logger.error("Error in parsing stream: " + this.url, e);
        }
    }

    public Feed(String name, String url, int type) {
        super(type);
        this.setUrl(url);
        this.setName(name);
    }

    public void parse() throws Exception {
        SyndFeedInput input = new SyndFeedInput();
        byte[] b = Feed.downloadAndSendBinary(this.url);
        if (b != null) {
            SyndFeed feed = input.build(new XmlReader(new ByteArrayInputStream(b)));
            this.setName(feed.getTitle());
            if (feed.getCategories() != null && feed.getCategories().size() > 0) {
                SyndCategory category = (SyndCategory)feed.getCategories().get(0);
                this.setTempCategory(category.getName());
            }
            List entries = feed.getEntries();
            for (SyndEntry entry : entries) {
                this.setTempItemTitle(entry.getTitle());
                this.setTempItemLink(entry.getLink());
                this.setTempFeedLink(entry.getUri());
                this.setTempItemThumbURL(null);
                ArrayList elements = (ArrayList)entry.getForeignMarkup();
                for (Element elt : elements) {
                    if ("group".equals(elt.getName()) && "media".equals(elt.getNamespacePrefix())) {
                        List subElts = elt.getContent();
                        for (Content subelt : subElts) {
                            if (!(subelt instanceof Element)) continue;
                            this.parseElement((Element)subelt, false);
                        }
                    }
                    this.parseElement(elt, true);
                }
                List enclosures = entry.getEnclosures();
                for (SyndEnclosure enc : enclosures) {
                    if (!StringUtils.isNotBlank(enc.getUrl())) continue;
                    this.setTempItemLink(enc.getUrl());
                }
                this.manageItem();
            }
        }
        this.setLastModified(System.currentTimeMillis());
    }

    private void parseElement(Element elt, boolean parseLink) {
        if ("content".equals(elt.getName()) && "media".equals(elt.getNamespacePrefix())) {
            if (parseLink) {
                this.setTempItemLink(elt.getAttribute("url").getValue());
            }
            List subElts = elt.getContent();
            for (Content subelt : subElts) {
                if (!(subelt instanceof Element)) continue;
                this.parseElement((Element)subelt, false);
            }
        }
        if ("thumbnail".equals(elt.getName()) && "media".equals(elt.getNamespacePrefix()) && this.getTempItemThumbURL() == null) {
            this.setTempItemThumbURL(elt.getAttribute("url").getValue());
        }
        if ("image".equals(elt.getName()) && "exInfo".equals(elt.getNamespacePrefix()) && this.getTempItemThumbURL() == null) {
            this.setTempItemThumbURL(elt.getValue());
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public long length() {
        return 0L;
    }

    @Deprecated
    public long lastModified() {
        return 0L;
    }

    @Override
    public String getSystemName() {
        return this.url;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    protected void manageItem() {
        FeedItem fi = new FeedItem(this.getTempItemTitle(), this.getTempItemLink(), this.getTempItemThumbURL(), null, this.getSpecificType());
        this.addChild(fi);
    }

    @Override
    public boolean isRefreshNeeded() {
        return System.currentTimeMillis() - this.getLastModified() > 3600000L;
    }

    @Override
    public void doRefreshChildren() {
        try {
            this.getChildren().clear();
            this.parse();
        }
        catch (Exception e) {
            logger.error("Error in parsing stream: " + this.url, e);
        }
    }

    protected String getUrl() {
        return this.url;
    }

    protected void setUrl(String url) {
        this.url = url;
    }

    protected String getTempItemTitle() {
        return this.tempItemTitle;
    }

    protected void setTempItemTitle(String tempItemTitle) {
        this.tempItemTitle = tempItemTitle;
    }

    protected String getTempItemLink() {
        return this.tempItemLink;
    }

    protected void setTempItemLink(String tempItemLink) {
        this.tempItemLink = tempItemLink;
    }

    protected String getTempFeedLink() {
        return this.tempFeedLink;
    }

    protected void setTempFeedLink(String tempFeedLink) {
        this.tempFeedLink = tempFeedLink;
    }

    protected String getTempCategory() {
        return this.tempCategory;
    }

    protected void setTempCategory(String tempCategory) {
        this.tempCategory = tempCategory;
    }

    protected String getTempItemThumbURL() {
        return this.tempItemThumbURL;
    }

    protected void setTempItemThumbURL(String tempItemThumbURL) {
        this.tempItemThumbURL = tempItemThumbURL;
    }

    protected void setName(String name) {
        this.name = name;
    }
}

