/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration;

import java.io.File;
import net.pms.configuration.ProgramPaths;
import net.pms.util.PropertiesUtil;
import org.apache.commons.lang3.StringUtils;

class LinuxDefaultPaths
implements ProgramPaths {
    private final String BINARIES_SEARCH_PATH = this.getBinariesSearchPath();

    LinuxDefaultPaths() {
    }

    @Override
    public String getFfmpegPath() {
        return this.getBinaryPath("ffmpeg");
    }

    @Override
    public String getFlacPath() {
        return this.getBinaryPath("flac");
    }

    @Override
    public String getMencoderPath() {
        return this.getBinaryPath("mencoder");
    }

    @Override
    public String getMplayerPath() {
        return this.getBinaryPath("mplayer");
    }

    @Override
    public String getTsmuxerPath() {
        return this.getBinaryPath("tsMuxeR");
    }

    @Override
    public String getVlcPath() {
        return this.getBinaryPath("vlc");
    }

    @Override
    public String getDCRaw() {
        return this.getBinaryPath("dcraw");
    }

    private String getBinariesSearchPath() {
        String path = PropertiesUtil.getProjectProperties().get("project.binaries.dir");
        if (StringUtils.isNotBlank(path)) {
            if (path.endsWith("/")) {
                return path;
            }
            return path + "/";
        }
        return "";
    }

    private String getBinaryPath(String tool) {
        File f = new File(this.BINARIES_SEARCH_PATH + tool);
        if (f.canExecute()) {
            return this.BINARIES_SEARCH_PATH + tool;
        }
        return tool;
    }
}

