/*
 * Decompiled with CFR 0.152.
 */
package jwbroek.cuelib.tools.trackcutter;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Scanner;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.sound.sampled.AudioFileFormat;
import jwbroek.cuelib.Position;
import jwbroek.cuelib.tools.trackcutter.TrackCutter;
import jwbroek.cuelib.tools.trackcutter.TrackCutterConfiguration;
import jwbroek.io.FileSelector;
import jwbroek.util.LogUtil;
import jwbroek.util.SimpleOptionsParser;

public class TrackCutterCommand {
    private TrackCutterConfiguration configuration = new TrackCutterConfiguration();
    private boolean doProcessing = true;
    private long recursionDepth = 1L;
    private Pattern pathSelectionPattern = null;
    private Pattern fileNameSelectionPattern = null;
    private File selectionBaseDirectory = new File(System.getProperty("user.dir"));
    private boolean readCueSheetFromStdIn = false;
    private static final Logger logger = Logger.getLogger(TrackCutterCommand.class.getCanonicalName());

    private TrackCutterCommand() {
        logger.entering(TrackCutterCommand.class.getCanonicalName(), "TrackCutterCommand()");
        logger.exiting(TrackCutterCommand.class.getCanonicalName(), "TrackCutterCommand()");
    }

    private static void printHelp() {
        logger.entering(TrackCutterCommand.class.getCanonicalName(), "printHelp()");
        System.out.println("Syntax: [options] [cuefiles]");
        System.out.println("cuefiles need not be specified if the -fp, -pp, or -i option is used.");
        System.out.println("Options:");
        System.out.println(" -pf regex           Process files such that their names match the specified regular");
        System.out.println("                     expression. This is in addition to files specified as parameter.");
        System.out.println("                     The regex is evaluated case-insensitively.");
        System.out.println(" -pp regex           Process files such that their canonical paths match the specified");
        System.out.println("                     regular expression. This is in addition to files specified as parameter.");
        System.out.println("                     The regex is evaluated case-insensitively.");
        System.out.println(" -pb directory       Base directory for file selection based on pattern.");
        System.out.println(" -r                  Process directories recursively. Only applies when the -pf or -pp");
        System.out.println("                     options are specified. Should not be used in combination with -rd.");
        System.out.println(" -rd depth           Process directories recursively up to the specified depth. Files in the");
        System.out.println("                     base directory are at depth 1. Only applies when the -pf or -pp options");
        System.out.println("                     are used. Should not be used in combination with -r.");
        System.out.println(" -b directory        Base directory for relative file references in cue sheet, and for relative");
        System.out.println("                     output location. If not specified, the directory of the cue sheet will be");
        System.out.println("                     used.");
        System.out.println(" -i                  Read cue sheet from standard input.");
        System.out.println(" -f file             Template for file name. Implies no redirect to post-processing.");
        System.out.println(" -t type             Audio type to convert to. Valid types are AIFC, AIFF, AU, SND, WAVE.");
        System.out.println("                     Not all conversions may be supported.");
        System.out.println(" -p file command     Template for post-processing file name and command.");
        System.out.println(" -g type [templates] Pregap handling. Choose from \"prepend\", \"discard\", \"separate\"");
        System.out.println("                     If \"separate\" is chosen, you must also specify templates for file");
        System.out.println("                     name, command, and name for intermediate file. The latter options will");
        System.out.println("                     not be used if redirect is enabled for post-processing. It must still be");
        System.out.println("                     specified.");
        System.out.println(" -pt length          Threshold for pregap processing. Pregaps with length shorter than this");
        System.out.println("                     will not be processed. Length as per the position field in cue sheets.");
        System.out.println(" -s                  Redirect audio to post-processing step.");
        System.out.println(" -ro                 Redirect output of post-processing step to log file.");
        System.out.println(" -re                 Redirect error output of post-processing step to log file.");
        System.out.println(" -l level            Override jdk 1.4 logging settings. The following levels are supported:");
        System.out.println("                     \"none\" (no cuelib logging), \"specific\" (only TrackCutter logging),");
        System.out.println("                     \"all\" (all cuelib logging). When logging is enabled, TrackCutter will");
        System.out.println("                     also try to ensure that logging is directed to the console. This setting");
        System.out.println("                     does not influence logging outside of cuelib. For this, use the standard");
        System.out.println("                     jdk 1.4 logging settings.");
        System.out.println(" -? | --help         Displays this help message and exits.");
        System.out.println("Templates:");
        System.out.println(" <title>             Title of the track.");
        System.out.println(" <artist>            Artist of the track, or artist of the album, if unknown.");
        System.out.println(" <album>             Title of the album");
        System.out.println(" <year>              Year of the track, or year of the album, if unknown.");
        System.out.println(" <comment>           Comment of the album.");
        System.out.println(" <track>             Track number");
        System.out.println(" <genre>             Genre of the album.");
        System.out.println(" <cutFile>           Name of the file after cutting. Can only be used in the post-");
        System.out.println("                     processing command template.");
        System.out.println(" <postProcessFile>   Name of the file after post-processing. Can only be used in");
        System.out.println("                     the post-processing command template.");
        System.out.println("Examples:");
        System.out.println(" Cut the tracks in a cue sheet:");
        System.out.println("  \"c:\\tmp\\Skunk Anansie - Stoosh.cue\"");
        System.out.println(" Cut the tracks in a cue sheet and prepend the pregaps:");
        System.out.println("  -p prepend \"c:\\tmp\\Skunk Anansie - Stoosh.cue\"");
        System.out.println(" Cut the tracks in a cue sheet and prepend pregaps longer than 3 seconds:");
        System.out.println("  -p prepend -pt 00:02:00 \"c:\\tmp\\Skunk Anansie - Stoosh.cue\"");
        System.out.println(" Cut the tracks in a cue sheet and give them names based on the data in the sheet:");
        System.out.println("  -f \"<artist>\\<album>\\<track>_<title>.wav\" \"c:\\tmp\\Skunk Anansie - Stoosh.cue\"");
        System.out.println(" Cut the tracks with separate pregaps, convert to WAV format, and redirect to lame while");
        System.out.println(" setting the appropriate ID3 tags, and creating log files:");
        System.out.println("  -f \"waves\\<artist>\\<album>\\<track>_<title>.wav\"");
        System.out.println("  -p \"mp3\\<artist>\\<album>\\<track>_<title>.mp3\"");
        System.out.println("  \"C:\\lame\\lame.exe --vbr-new -V 0 -t --tt \\\"<title>\\\" --ta \\\"<artist>\\\" --tl \\\"<album>\\\"");
        System.out.println("  --ty \\\"<year>\\\" --tc \\\"<comment>\\\" --tn \\\"<track>\\\" --tg \\\"<genre>\\\" - ");
        System.out.println("  \\\"<postProcessFile>\\\"\"");
        System.out.println("  -g separate \"mp3\\<artist>\\<album>\\<track>_0_<title>.mp3\"");
        System.out.println("  \"C:\\lame\\lame.exe --vbr-new -V 0 -t --tt \\\"00 Pregap of <title>\\\" --ta \\\"<artist>\\\"");
        System.out.println("  --tl \\\"<album>\\\" --ty \\\"<year>\\\" --tc \\\"Pregap of <title>\\\" --tn \\\"<track>\\\" --tg");
        System.out.println("  \\\"<genre>\\\" - \\\"<postProcessFile>\\\"\"");
        System.out.println("  -s -ro -re -t WAVE \"c:\\tmp\\Skunk Anansie - Stoosh.cue\"");
        System.out.println("Notes:");
        System.out.println("No guarantees are made as to the order in which files are processed. Some effort is made");
        System.out.println("to provent files from being processed more than once per run.");
        System.out.println("Conflicting options may result in unpredictable behaviour.");
        logger.exiting(TrackCutterCommand.class.getCanonicalName(), "printHelp()");
    }

    private SimpleOptionsParser getArgumentsParser() {
        logger.entering(TrackCutterCommand.class.getCanonicalName(), "getArgumentsParser()");
        SimpleOptionsParser simpleOptionsParser = new SimpleOptionsParser();
        simpleOptionsParser.registerOption(new SimpleOptionsParser.OptionHandler(){

            public int handleOption(String[] stringArray, int n) {
                TrackCutterCommand.this.setFileNameSelectionPattern(Pattern.compile(stringArray[n + 1], 2));
                return n + 2;
            }
        }, "-pf");
        simpleOptionsParser.registerOption(new SimpleOptionsParser.OptionHandler(){

            public int handleOption(String[] stringArray, int n) {
                TrackCutterCommand.this.setPathSelectionPattern(Pattern.compile(stringArray[n + 1], 2));
                return n + 2;
            }
        }, "-pp");
        simpleOptionsParser.registerOption(new SimpleOptionsParser.OptionHandler(){

            public int handleOption(String[] stringArray, int n) {
                TrackCutterCommand.this.setSelectionBaseDirectory(new File(stringArray[n + 1]));
                return n + 2;
            }
        }, "-pb");
        simpleOptionsParser.registerOption(new SimpleOptionsParser.OptionHandler(){

            public int handleOption(String[] stringArray, int n) {
                TrackCutterCommand.this.setRecursionDepth(Long.MAX_VALUE);
                return n + 1;
            }
        }, "-r");
        simpleOptionsParser.registerOption(new SimpleOptionsParser.OptionHandler(){

            public int handleOption(String[] stringArray, int n) {
                TrackCutterCommand.this.setRecursionDepth(Long.parseLong(stringArray[n + 1]));
                return n + 2;
            }
        }, "-rd");
        simpleOptionsParser.registerOption(new SimpleOptionsParser.OptionHandler(){

            public int handleOption(String[] stringArray, int n) {
                TrackCutterCommand.this.getConfiguration().setParentDirectory(new File(stringArray[n + 1]));
                return n + 2;
            }
        }, "-b");
        simpleOptionsParser.registerOption(new SimpleOptionsParser.OptionHandler(){

            public int handleOption(String[] stringArray, int n) {
                TrackCutterCommand.this.setReadCueSheetFromStdIn(true);
                return n + 1;
            }
        }, "-i");
        simpleOptionsParser.registerOption(new SimpleOptionsParser.OptionHandler(){

            public int handleOption(String[] stringArray, int n) {
                TrackCutterCommand.this.getConfiguration().setRedirectToPostprocessing(false);
                TrackCutterCommand.this.getConfiguration().setCutFileNameTemplate(stringArray[n + 1]);
                return n + 2;
            }
        }, "-f");
        simpleOptionsParser.registerOption(new SimpleOptionsParser.OptionHandler(){

            public int handleOption(String[] stringArray, int n) {
                String string = stringArray[n + 1];
                AudioFileFormat.Type type = null;
                if ("AIFC".equalsIgnoreCase(string)) {
                    type = AudioFileFormat.Type.AIFC;
                } else if ("AIFF".equalsIgnoreCase(string)) {
                    type = AudioFileFormat.Type.AIFF;
                } else if ("AU".equalsIgnoreCase(string)) {
                    type = AudioFileFormat.Type.AU;
                } else if ("SND".equalsIgnoreCase(string)) {
                    type = AudioFileFormat.Type.SND;
                } else if ("WAVE".equalsIgnoreCase(string)) {
                    type = AudioFileFormat.Type.WAVE;
                } else {
                    throw new IllegalArgumentException("Unsupported audio type: " + string);
                }
                TrackCutterCommand.this.getConfiguration().setTargetType(type);
                return n + 2;
            }
        }, "-t");
        simpleOptionsParser.registerOption(new SimpleOptionsParser.OptionHandler(){

            public int handleOption(String[] stringArray, int n) {
                TrackCutterCommand.this.getConfiguration().setDoPostProcessing(true);
                TrackCutterCommand.this.getConfiguration().setPostProcessFileNameTemplate(stringArray[n + 1]);
                TrackCutterCommand.this.getConfiguration().setPostProcessCommandTemplate(stringArray[n + 2]);
                return n + 3;
            }
        }, "-p");
        simpleOptionsParser.registerOption(new SimpleOptionsParser.OptionHandler(){

            public int handleOption(String[] stringArray, int n) {
                if ("prepend".equalsIgnoreCase(stringArray[n + 1])) {
                    TrackCutterCommand.this.getConfiguration().setPregapHandling(TrackCutterConfiguration.PregapHandling.PREPEND);
                    return n + 2;
                }
                if ("discard".equalsIgnoreCase(stringArray[n + 1])) {
                    TrackCutterCommand.this.getConfiguration().setPregapHandling(TrackCutterConfiguration.PregapHandling.DISCARD);
                    return n + 2;
                }
                if ("separate".equalsIgnoreCase(stringArray[n + 1])) {
                    TrackCutterCommand.this.getConfiguration().setPregapHandling(TrackCutterConfiguration.PregapHandling.SEPARATE);
                    TrackCutterCommand.this.getConfiguration().setPregapPostProcessFileNameTemplate(stringArray[n + 2]);
                    TrackCutterCommand.this.getConfiguration().setPregapPostProcessCommandTemplate(stringArray[n + 3]);
                    TrackCutterCommand.this.getConfiguration().setPregapCutFileNameTemplate(stringArray[n + 4]);
                    return n + 5;
                }
                throw new IllegalArgumentException("Invalid type for pregap handling: " + stringArray[1]);
            }
        }, "-g");
        simpleOptionsParser.registerOption(new SimpleOptionsParser.OptionHandler(){

            public int handleOption(String[] stringArray, int n) {
                TrackCutterCommand.this.getConfiguration().setRedirectToPostprocessing(true);
                return n + 1;
            }
        }, "-s");
        simpleOptionsParser.registerOption(new SimpleOptionsParser.OptionHandler(){

            public int handleOption(String[] stringArray, int n) {
                Scanner scanner = new Scanner(stringArray[n + 1]).useDelimiter(":");
                Position position = new Position(scanner.nextInt(), scanner.nextInt(), scanner.nextInt());
                scanner.close();
                TrackCutterCommand.this.getConfiguration().setPregapFrameLengthThreshold(position.getTotalFrames());
                return n + 2;
            }
        }, "-pt");
        simpleOptionsParser.registerOption(new SimpleOptionsParser.OptionHandler(){

            public int handleOption(String[] stringArray, int n) {
                TrackCutterCommand.this.getConfiguration().setRedirectStdOut(true);
                return n + 1;
            }
        }, "-ro");
        simpleOptionsParser.registerOption(new SimpleOptionsParser.OptionHandler(){

            public int handleOption(String[] stringArray, int n) {
                TrackCutterCommand.this.getConfiguration().setRedirectErr(true);
                return n + 1;
            }
        }, "-re");
        simpleOptionsParser.registerOption(new SimpleOptionsParser.OptionHandler(){

            public int handleOption(String[] stringArray, int n) {
                String string = stringArray[n + 1];
                if ("none".equals(string)) {
                    Logger.getLogger("jwbroek.cuelib").setLevel(Level.OFF);
                } else if ("specific".equals(string)) {
                    Logger.getLogger("jwbroek.cuelib").setLevel(Level.OFF);
                    Logger logger = Logger.getLogger(TrackCutter.class.getCanonicalName());
                    if (!logger.isLoggable(Level.INFO)) {
                        logger.setLevel(Level.INFO);
                    }
                    if (!LogUtil.hasHandlerActive(logger, Level.INFO, ConsoleHandler.class)) {
                        logger.addHandler(new ConsoleHandler());
                    }
                } else if ("all".equals(string)) {
                    Logger logger;
                    Logger logger2 = Logger.getLogger("jwbroek.cuelib");
                    if (!logger2.isLoggable(Level.INFO)) {
                        logger2.setLevel(Level.INFO);
                    }
                    if (!(logger = Logger.getLogger(TrackCutter.class.getCanonicalName())).isLoggable(Level.INFO)) {
                        logger.setLevel(Level.INFO);
                    }
                    if (!LogUtil.hasHandlerActive(Logger.getLogger("jwbroek.cuelib"), Level.INFO, ConsoleHandler.class)) {
                        Logger.getLogger("jwbroek.cuelib").addHandler(new ConsoleHandler());
                    }
                    if (!LogUtil.hasHandlerActive(logger, Level.INFO, ConsoleHandler.class)) {
                        logger.addHandler(new ConsoleHandler());
                    }
                } else {
                    throw new IllegalArgumentException("Invalid level setting for -l option: '" + string + "'");
                }
                return n + 2;
            }
        }, "-l");
        simpleOptionsParser.registerOption(new SimpleOptionsParser.OptionHandler(){

            public int handleOption(String[] stringArray, int n) {
                TrackCutterCommand.printHelp();
                TrackCutterCommand.this.setDoProcessing(false);
                return n + 1;
            }
        }, "-?", "--help");
        logger.exiting(TrackCutterCommand.class.getCanonicalName(), "getArgumentsParser()", simpleOptionsParser);
        return simpleOptionsParser;
    }

    public void performProcessing(String[] stringArray) {
        logger.entering(TrackCutterCommand.class.getCanonicalName(), "performProcessing(String[])", stringArray);
        TrackCutter trackCutter = new TrackCutter(this.getConfiguration());
        SimpleOptionsParser simpleOptionsParser = this.getArgumentsParser();
        int n = simpleOptionsParser.parseOptions(stringArray);
        if (n == -1 || n == stringArray.length && this.getFileNameSelectionPattern() == null && this.getPathSelectionPattern() == null && !this.getReadCueSheetFromStdIn()) {
            System.err.println("A problem occurred when parsing the command line arguments. Please check for syntax.");
            TrackCutterCommand.printHelp();
            return;
        }
        if (this.getDoProcessing()) {
            HashSet<File> hashSet = new HashSet<File>();
            for (int i = n; i < stringArray.length; ++i) {
                hashSet.add(new File(stringArray[i]));
            }
            ArrayList<FileFilter> arrayList = new ArrayList<FileFilter>();
            arrayList.add(FileSelector.getFilesFilter());
            if (this.getPathSelectionPattern() != null) {
                arrayList.add(FileSelector.getPathPatternFilter(this.getPathSelectionPattern()));
            }
            if (this.getFileNameSelectionPattern() != null) {
                arrayList.add(FileSelector.getFileNamePatternFilter(this.getFileNameSelectionPattern()));
            }
            if (arrayList.size() > 1) {
                ArrayList arrayList2 = new ArrayList();
                FileSelector.selectFiles(this.getSelectionBaseDirectory(), FileSelector.getCombinedFileFilter(arrayList), arrayList2, this.getRecursionDepth(), false, true);
                hashSet.addAll(arrayList2);
            }
            for (File file : hashSet) {
                try {
                    trackCutter.cutTracksInCueSheet(file);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (this.readCueSheetFromStdIn) {
                try {
                    trackCutter.cutTracksInCueSheet(System.in);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        this.setDoProcessing(true);
        logger.exiting(TrackCutterCommand.class.getCanonicalName(), "performProcessing(String[])");
    }

    public static void main(String[] stringArray) {
        logger.entering(TrackCutterCommand.class.getCanonicalName(), "main(String[])", stringArray);
        new TrackCutterCommand().performProcessing(stringArray);
        logger.exiting(TrackCutterCommand.class.getCanonicalName(), "main(String[])");
    }

    private TrackCutterConfiguration getConfiguration() {
        logger.entering(TrackCutterCommand.class.getCanonicalName(), "getConfiguration()");
        logger.exiting(TrackCutterCommand.class.getCanonicalName(), "getConfiguration()", this.configuration);
        return this.configuration;
    }

    private boolean getDoProcessing() {
        logger.entering(TrackCutterCommand.class.getCanonicalName(), "getDoProcessing()");
        logger.exiting(TrackCutterCommand.class.getCanonicalName(), "getDoProcessing()", this.doProcessing);
        return this.doProcessing;
    }

    private void setDoProcessing(boolean bl) {
        logger.entering(TrackCutterCommand.class.getCanonicalName(), "setDoProcessing(boolean)", bl);
        this.doProcessing = bl;
        logger.exiting(TrackCutterCommand.class.getCanonicalName(), "setDoProcessing(boolean)", this.doProcessing);
    }

    private Pattern getFileNameSelectionPattern() {
        logger.entering(TrackCutterCommand.class.getCanonicalName(), "getFileNameSelectionPattern()");
        logger.exiting(TrackCutterCommand.class.getCanonicalName(), "getFileNameSelectionPattern()", this.fileNameSelectionPattern);
        return this.fileNameSelectionPattern;
    }

    private void setFileNameSelectionPattern(Pattern pattern) {
        logger.entering(TrackCutterCommand.class.getCanonicalName(), "setFileNameSelectionPattern(Pattern)", pattern);
        this.fileNameSelectionPattern = pattern;
        logger.exiting(TrackCutterCommand.class.getCanonicalName(), "setFileNameSelectionPattern(Pattern)");
    }

    private Pattern getPathSelectionPattern() {
        logger.entering(TrackCutterCommand.class.getCanonicalName(), "getPathSelectionPattern()");
        logger.exiting(TrackCutterCommand.class.getCanonicalName(), "getPathSelectionPattern()", this.pathSelectionPattern);
        return this.pathSelectionPattern;
    }

    private void setPathSelectionPattern(Pattern pattern) {
        logger.entering(TrackCutterCommand.class.getCanonicalName(), "getPathSelectionPattern(Pattern)", pattern);
        this.pathSelectionPattern = pattern;
        logger.exiting(TrackCutterCommand.class.getCanonicalName(), "getPathSelectionPattern(Pattern)");
    }

    private long getRecursionDepth() {
        logger.entering(TrackCutterCommand.class.getCanonicalName(), "getRecursionDepth()");
        logger.exiting(TrackCutterCommand.class.getCanonicalName(), "getRecursionDepth()", this.recursionDepth);
        return this.recursionDepth;
    }

    private void setRecursionDepth(long l) {
        logger.entering(TrackCutterCommand.class.getCanonicalName(), "setRecursionDepth(long)", l);
        this.recursionDepth = l;
        logger.exiting(TrackCutterCommand.class.getCanonicalName(), "setRecursionDepth(long)");
    }

    private File getSelectionBaseDirectory() {
        logger.entering(TrackCutterCommand.class.getCanonicalName(), "getSelectionBaseDirectory()");
        logger.exiting(TrackCutterCommand.class.getCanonicalName(), "getSelectionBaseDirectory()", this.selectionBaseDirectory);
        return this.selectionBaseDirectory;
    }

    private void setSelectionBaseDirectory(File file) {
        logger.entering(TrackCutterCommand.class.getCanonicalName(), "setSelectionBaseDirectory(File)", file);
        this.selectionBaseDirectory = file;
        logger.exiting(TrackCutterCommand.class.getCanonicalName(), "setSelectionBaseDirectory(File)");
    }

    private boolean getReadCueSheetFromStdIn() {
        logger.entering(TrackCutterCommand.class.getCanonicalName(), "getReadCueSheetFromStdIn()");
        logger.exiting(TrackCutterCommand.class.getCanonicalName(), "getReadCueSheetFromStdIn()", this.readCueSheetFromStdIn);
        return this.readCueSheetFromStdIn;
    }

    private void setReadCueSheetFromStdIn(boolean bl) {
        logger.entering(TrackCutterCommand.class.getCanonicalName(), "setReadCueSheetFromStdIn(boolean)");
        this.readCueSheetFromStdIn = bl;
        logger.exiting(TrackCutterCommand.class.getCanonicalName(), "setReadCueSheetFromStdIn(boolean)", this.readCueSheetFromStdIn);
    }
}

