#! /usr/bin/perl
use strict;
use HTMLObject::Normal;
use Apache::Session::Postgres;
use HTMLObject::GetCookie;
use HTMLObject::CGILib;
#use cgi_lib;

HTMLObject::GetCookie::GetCookies();

my $doc = HTMLObject::Normal->new();
use vars '%input';

#cgi_lib::ReadParse(*input);
HTMLObject::CGILib::ReadParse(*input);

my $sessionId = $HTMLObject::GetCookie::Cookies{'sessionId'};
my $command = $input{'command'};
my %s = {};

if ($command ne "logout" || ($command eq "logout" && length $sessionId > 0))
{
eval {
tie %s, 'Apache::Session::Postgres', $sessionId, {
    DataSource => 'dbi:Pg:dbname=sessions', 
    UserName => 'postgres', 
    Password => '',
    Commit   => 1
};
};
}

if ($@)
{
  $doc->setTitle("Apache::Session Error!");
  $doc->setFocus("body");
  $doc->setCookie(name => "sessionId", expires => "Mon, 01-Jan-1999 00:00:00 GMT");
  $doc->print("sessionId = '$sessionId' does not exist anymore!<br>Error='$@'.");
  $doc->display();
  exit(1);
}

if ($command eq "logout")
{
  if (length $sessionId > 0)
  {
    eval {
      tied(%s)->delete;
    };
    if ($@)
    {
      $doc->setTitle("Apache::Session Error!");
      $doc->setFocus("body");
      $doc->setCookie(name => "sessionId", expires => "Mon, 01-Jan-1999 00:00:00 GMT");
      $doc->print("Deleting Session info for id = '$sessionId' failed!<br>Error = '$@'.");
      $doc->display();
      exit(1);
    }
    $doc->setTitle("Apache::Session LogOut");
    $doc->setFocus("body");
    $doc->setCookie(name => "sessionId", expires => "Mon, 01-Jan-1999 00:00:00 GMT");
    $doc->print("You are logged out.  Go <a href=\"/cgi-bin/session.cgi\">here</a> to work some more.");
    $doc->display();
    exit(0);
  }
  else
  {
    $doc->setTitle("Apache::Session Error!");
    $doc->setFocus("body");
    $doc->print("You are already logged out and don't have a session going!<br>");
    $doc->print("Go <a href=\"/cgi-bin/session.cgi\">here</a> to work some more.");
    $doc->display();
    exit(0);
  }
}

my $id = $s{_session_id};  # this is an internal variable from the Apache::Session module.

$doc->setTitle("Apache::Session test page");
$doc->setCookie(name => "sessionId", value => "$id");

$doc->setFocus("body");
$doc->print("foo = '".$s{foo}."'<br>\n");
$doc->print("baz = '".$s{baz}."'<br>\n");
$s{foo} = 'bar';
$s{baz} = ['tom', 'dick', 'harry'];

untie %s;

# present the link to delete this session.
$doc->print("<br><br><br><a href=\"/cgi-bin/session.cgi?command=logout\">Log Out</a>\n");

$doc->display();
