/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;

public class MultipleAsgnNode
extends AssignableNode {
    private final ListNode pre;
    private final Node rest;
    private final ListNode post;

    public MultipleAsgnNode(int line, ListNode pre, Node rest, ListNode post) {
        super(line);
        this.pre = pre;
        this.rest = rest;
        this.post = post;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.MULTIPLEASGNNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitMultipleAsgnNode(this);
    }

    public Node getRest() {
        return this.rest;
    }

    public ListNode getPre() {
        return this.pre;
    }

    public int getPreCount() {
        return this.pre == null ? 0 : this.pre.size();
    }

    public int getPostCount() {
        return this.post == null ? 0 : this.post.size();
    }

    public ListNode getPost() {
        return this.post;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList((Node)this.pre, this.rest, this.getValueNode());
    }
}

