/*
 * Automatically Tuned Linear Algebra Software v3.11.41
 * Copyright (C) 2018 R. Clint Whaley
 */
#include "atlas_asm.h"
#define pB0 r0
#define NNU r2
#define NMU r3
#define NN0 r4
#define KK  r5
#define pA  r6
#define pB  r7
#define pC  r8
#define pfA r9
#define pfB r10
#define incA r11
/* #define Kb0 r14 */
#define i16 r12
   #define i16_1 i16
#define i32 r15
   #define i16_2 i32
#define i48 r16
   #define i16_3 i48
#define i64 r17
   #define i16_4 i64
#define i80 r18
   #define i16_5 i80
#define i96 r19
   #define i16_6 i96
#define i112 r20
   #define i16_7 i112
#define i128 r22
   #define i16_8 i128
#define i144 r23
   #define i16_9 i144
#define i160 r24
   #define i16_10 i160
#define i176 r25
   #define i16_11 i176
#define i192 r26
   #define i16_12 i192
#define i208 r27
   #define i16_13 i208
#define i224 r28
   #define i16_14 i224
#define i240 r29
   #define i16_15 i240

#define rC00 v0
#define rC10 v1
#define rC20 v2
#define rC30 v3
#define rC40 v4
#define rC50 v5
#define rC01 v6
#define rC11 v7
#define rC21 v8
#define rC31 v9
#define rC41 v10
#define rC51 v11
#define rC02 v12
#define rC12 v13
#define rC22 v14
#define rC32 v15
#define rC42 v16
#define rC52 v17
#define rC03 v18
#define rC13 v19
#define rC23 v20
#define rC33 v21
#define rC43 v22
#define rC53 v23
#define rC04 v24
#define rC14 v25
#define rC24 v26
#define rC34 v27
#define rC44 v28
#define rC54 v29
#define rC05 v30
#define rC15 v31
#define rC25 v32
#define rC35 v33
#define rC45 v34
#define rC55 v35
#define rA0 v36
#define rA1 v37
#define rA2 v38
#define rA3 v39
#define rA4 v40
#define rA5 v41
#define ra0 v42
#define ra1 v43
#define ra2 v44
#define ra3 v45
#define ra4 v46
#define ra5 v47
#define rB0 v48
#define rB1 v49
#define rB2 v50
#define rB3 v51
#define rB4 v52
#define rB5 v53
#define rb0 v54
#define rb1 v55
#define rb2 v56
#define rb3 v57
#define rb4 v58
#define rb5 v59
/*
 * NOTE: 1st param at 96(r1), because caller must reserve space for 8 reg-passed
 * params in param passing space on stack.  ABI says parm passing space at
 * 32(r1) -> 32+64 -> 96(r1).
 * param save space can be written to by callee.
 */
/*
                     r3       r4     r5         r6         r7        r8
void ATL_USERMM(SZT nmu, SZT nnu, SZT K, CTYPE *pA, CTYPE *pB, TYPE *pC,
                       r9          r10     96(r1)
                CTYPE *pAn, CTYPE *pBn, CTYPE *pCn);
 */
.local MLOOP
.local NLOOP
.local KLOOP
.globl ATL_USERMM
ATL_USERMM:
/*
 * Must save & restore:
 *    r1&r2 -> in sframe tail
 *    r14-r31 -> 18*8 = 144 bytes (if used)
 *    f14-f31 -> vsr14-vsr31 -> 18*8 = 144 bytes
 *    v20-v31 -> vsr52-vsr63 -> 12*16 = 192 bytes
 */
#define ISZ 0
#define FSZ 144
#define VSZ 192
#define LSZ 0
#define MSZ 32      /* mandatory 32 bytes for stack frame tail */
#define VOFF (MSZ+LSZ)
#define FOFF (VOFF+VSZ)
#define IOFF (FOFF+FSZ)
#define FSIZE (MSZ+LSZ+VSZ+FSZ+ISZ)
/*
 * Allocate local stack frame in order to save & restore
 */
   stdu r1, -FSIZE(r1)   /* allocate stack & store old stack ptr */
/*
 * Save iregs, UNUSED: r14
 */
   std r2, 24(r1)        /* TOC reg always at 24(sp) */
/*
 * Save f14-f31
 */
   stfd f14, FOFF(r1)
   stfd f15, 8+FOFF(r1)
   stfd f16, 16+FOFF(r1)
   stfd f17, 24+FOFF(r1)
   stfd f18, 32+FOFF(r1)
   stfd f19, 40+FOFF(r1)
   stfd f20, 48+FOFF(r1)
   stfd f21, 56+FOFF(r1)
   stfd f22, 64+FOFF(r1)
   stfd f23, 72+FOFF(r1)
   stfd f24, 80+FOFF(r1)
   stfd f25, 88+FOFF(r1)
   stfd f26, 96+FOFF(r1)
   stfd f27, 104+FOFF(r1)
   stfd f28, 112+FOFF(r1)
   stfd f29, 120+FOFF(r1)
   stfd f30, 128+FOFF(r1)
   stfd f31, 136+FOFF(r1)
/*
 * Save vec regs, use VSX so we don't rely on Altivec
 */
   mr pB0, pB
   addi pB, r1, VOFF
   stxv v52, 0(pB)
   stxv v53, 16*1(pB)
   stxv v54, 16*2(pB)
   stxv v55, 16*3(pB)
   stxv v56, 16*4(pB)
   stxv v57, 16*5(pB)
   stxv v58, 16*6(pB)
   stxv v59, 16*7(pB)
   #if 0
   stxv v60, 16*8(pB)
   stxv v61, 16*9(pB)
   stxv v62, 16*10(pB)
   stxv v63, 16*11(pB)
   #endif

   ALIGN16
   MLOOP:
      mr pB, pB0
      mr NNU, NN0
      NLOOP:
/*
 *       Need to peel to handle beta=0,-1, but I'm too lazy to do it yet
 */
         #ifdef BETA0
            xxlxor rC00, rC00, rC00
            xxlxor rC10, rC10, rC10
            xxlxor rC20, rC20, rC20
            xxlxor rC30, rC30, rC30
            xxlxor rC40, rC40, rC40
            xxlxor rC50, rC50, rC50
            xxlxor rC01, rC01, rC01
            xxlxor rC11, rC11, rC11
            xxlxor rC21, rC21, rC21
            xxlxor rC31, rC31, rC31
            xxlxor rC41, rC41, rC41
            xxlxor rC51, rC51, rC51
            xxlxor rC02, rC02, rC02
            xxlxor rC12, rC12, rC12
            xxlxor rC22, rC22, rC22
            xxlxor rC32, rC32, rC32
            xxlxor rC42, rC42, rC42
            xxlxor rC52, rC52, rC52
            xxlxor rC03, rC03, rC03
            xxlxor rC13, rC13, rC13
            xxlxor rC23, rC23, rC23
            xxlxor rC33, rC33, rC33
            xxlxor rC43, rC43, rC43
            xxlxor rC53, rC53, rC53
            xxlxor rC04, rC04, rC04
            xxlxor rC14, rC14, rC14
            xxlxor rC24, rC24, rC24
            xxlxor rC34, rC34, rC34
            xxlxor rC44, rC44, rC44
            xxlxor rC54, rC54, rC54
            xxlxor rC05, rC05, rC05
            xxlxor rC15, rC15, rC15
            xxlxor rC25, rC25, rC25
            xxlxor rC35, rC35, rC35
            xxlxor rC45, rC45, rC45
            xxlxor rC55, rC55, rC55
         #else
/*            lxvd2x rC00, 0, pC */
            lxv rC00, 0(pC)
            lxv rC10, 16(pC)
            lxv rC20, 16*2(pC)
            lxv rC30, 16*3(pC)
            lxv rC40, 16*4(pC)
            lxv rC50, 16*5(pC)
            lxv rC01, 16*6(pC)
            lxv rC11, 16*7(pC)
            lxv rC21, 16*8(pC)
            lxv rC31, 16*9(pC)
            lxv rC41, 16*10(pC)
            lxv rC51, 16*11(pC)
            lxv rC02, 16*12(pC)
            lxv rC12, 16*13(pC)
            lxv rC22, 16*14(pC)
            lxv rC32, 16*15(pC)
            lxv rC42, 16*16(pC)
            lxv rC52, 16*17(pC)
            lxv rC03, 16*18(pC)
            lxv rC13, 16*19(pC)
            lxv rC23, 16*20(pC)
            lxv rC33, 16*21(pC)
            lxv rC43, 16*22(pC)
            lxv rC53, 16*23(pC)
            lxv rC04, 16*24(pC)
            lxv rC14, 16*25(pC)
            lxv rC24, 16*26(pC)
            lxv rC34, 16*27(pC)
            lxv rC44, 16*28(pC)
            lxv rC54, 16*29(pC)
            lxv rC05, 16*30(pC)
            lxv rC15, 16*31(pC)
            lxv rC25, 16*32(pC)
            lxv rC35, 16*33(pC)
            lxv rC45, 16*34(pC)
            lxv rC55, 16*35(pC)

            #ifndef BETA1
               xvnegdp rC00, rC00
               xvnegdp rC10, rC10
               xvnegdp rC20, rC20
               xvnegdp rC30, rC30
               xvnegdp rC40, rC40
               xvnegdp rC50, rC50
               xvnegdp rC01, rC01
               xvnegdp rC11, rC11
               xvnegdp rC21, rC21
               xvnegdp rC31, rC31
               xvnegdp rC41, rC41
               xvnegdp rC51, rC51
               xvnegdp rC02, rC02
               xvnegdp rC12, rC12
               xvnegdp rC22, rC22
               xvnegdp rC32, rC32
               xvnegdp rC42, rC42
               xvnegdp rC52, rC52
               xvnegdp rC03, rC03
               xvnegdp rC13, rC13
               xvnegdp rC23, rC23
               xvnegdp rC33, rC33
               xvnegdp rC43, rC43
               xvnegdp rC53, rC53
               xvnegdp rC04, rC04
               xvnegdp rC14, rC14
               xvnegdp rC24, rC24
               xvnegdp rC34, rC34
               xvnegdp rC44, rC44
               xvnegdp rC54, rC54
               xvnegdp rC05, rC05
               xvnegdp rC15, rC15
               xvnegdp rC25, rC25
               xvnegdp rC35, rC35
               xvnegdp rC45, rC45
               xvnegdp rC55, rC55
            #endif
         #endif
         lxv rA0, 0(pA)
         lxv rA1, 16(pA)
         lxv rA2, 16*2(pA)
         lxv rA3, 16*3(pA)
         lxv rA4, 16*4(pA)
         lxv rA5, 16*5(pA)

         lxv ra0, 16*6(pA)
         lxv ra1, 16*7(pA)
         lxv ra2, 16*8(pA)
         lxv ra3, 16*9(pA)
         lxv ra4, 16*10(pA)
         lxv ra5, 16*11(pA)
         lxv rb0, 0(pB)
            xxspltd rB0, rb0, 1
            xxspltd rB1, rb0, 0
         lxv rb1, 16(pB)
            xxspltd rB2, rb1, 1
            xxspltd rB3, rb1, 0
         lxv rb2, 32(pB)
            xxspltd rB4, rb2, 1
            xxspltd rB5, rb2, 0
         lxv rb3, 16*3(pB)
         lxv rb4, 16*4(pB)
         lxv rb5, 16*5(pB)
         lxv rb0, 16*6(pB)
         lxv rb1, 16*7(pB)
         lxv rb2, 16*8(pB)

         #if KB >= 1
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 1
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 1
               xxspltd rB1, rb3, 0
               lxv rb3, 144(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 1
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 1
               xxspltd rB3, rb4, 0
               lxv rb4, 160(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 1
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 1
               lxv rA0, 192(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 1
               lxv rA1, 208(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 1
               lxv rA2, 224(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 1
               lxv rA3, 240(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 1
                lxv rA4, 256(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 2
               lxv rA5, 272(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 176(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 2
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 2
               xxspltd rB1, rb0, 0
               lxv rb0, 192(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 2
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 2
               xxspltd rB3, rb1, 0
               lxv rb1, 208(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 2
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 2
               lxv ra0, 288(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 2
               lxv ra1, 304(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 2
               lxv ra2, 320(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 2
               lxv ra3, 336(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 2
               lxv ra4, 352(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 2
               lxv ra5, 368(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 224(pB)
            #endif
         #endif
         #if KB >= 3
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 3
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 3
               xxspltd rB1, rb3, 0
               lxv rb3, 240(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 3
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 3
               xxspltd rB3, rb4, 0
               lxv rb4, 256(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 3
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 3
               lxv rA0, 384(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 3
               lxv rA1, 400(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 3
               lxv rA2, 416(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 3
               lxv rA3, 432(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 3
                lxv rA4, 448(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 4
               lxv rA5, 464(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 272(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 4
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 4
               xxspltd rB1, rb0, 0
               lxv rb0, 288(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 4
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 4
               xxspltd rB3, rb1, 0
               lxv rb1, 304(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 4
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 4
               lxv ra0, 480(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 4
               lxv ra1, 496(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 4
               lxv ra2, 512(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 4
               lxv ra3, 528(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 4
               lxv ra4, 544(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 4
               lxv ra5, 560(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 320(pB)
            #endif
         #endif
         #if KB >= 5
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 5
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 5
               xxspltd rB1, rb3, 0
               lxv rb3, 336(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 5
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 5
               xxspltd rB3, rb4, 0
               lxv rb4, 352(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 5
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 5
               lxv rA0, 576(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 5
               lxv rA1, 592(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 5
               lxv rA2, 608(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 5
               lxv rA3, 624(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 5
                lxv rA4, 640(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 6
               lxv rA5, 656(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 368(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 6
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 6
               xxspltd rB1, rb0, 0
               lxv rb0, 384(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 6
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 6
               xxspltd rB3, rb1, 0
               lxv rb1, 400(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 6
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 6
               lxv ra0, 672(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 6
               lxv ra1, 688(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 6
               lxv ra2, 704(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 6
               lxv ra3, 720(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 6
               lxv ra4, 736(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 6
               lxv ra5, 752(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 416(pB)
            #endif
         #endif
         #if KB >= 7
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 7
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 7
               xxspltd rB1, rb3, 0
               lxv rb3, 432(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 7
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 7
               xxspltd rB3, rb4, 0
               lxv rb4, 448(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 7
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 7
               lxv rA0, 768(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 7
               lxv rA1, 784(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 7
               lxv rA2, 800(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 7
               lxv rA3, 816(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 7
                lxv rA4, 832(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 8
               lxv rA5, 848(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 464(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 8
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 8
               xxspltd rB1, rb0, 0
               lxv rb0, 480(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 8
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 8
               xxspltd rB3, rb1, 0
               lxv rb1, 496(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 8
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 8
               lxv ra0, 864(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 8
               lxv ra1, 880(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 8
               lxv ra2, 896(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 8
               lxv ra3, 912(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 8
               lxv ra4, 928(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 8
               lxv ra5, 944(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 512(pB)
            #endif
         #endif
         #if KB >= 9
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 9
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 9
               xxspltd rB1, rb3, 0
               lxv rb3, 528(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 9
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 9
               xxspltd rB3, rb4, 0
               lxv rb4, 544(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 9
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 9
               lxv rA0, 960(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 9
               lxv rA1, 976(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 9
               lxv rA2, 992(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 9
               lxv rA3, 1008(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 9
                lxv rA4, 1024(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 10
               lxv rA5, 1040(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 560(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 10
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 10
               xxspltd rB1, rb0, 0
               lxv rb0, 576(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 10
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 10
               xxspltd rB3, rb1, 0
               lxv rb1, 592(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 10
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 10
               lxv ra0, 1056(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 10
               lxv ra1, 1072(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 10
               lxv ra2, 1088(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 10
               lxv ra3, 1104(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 10
               lxv ra4, 1120(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 10
               lxv ra5, 1136(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 608(pB)
            #endif
         #endif
         #if KB >= 11
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 11
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 11
               xxspltd rB1, rb3, 0
               lxv rb3, 624(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 11
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 11
               xxspltd rB3, rb4, 0
               lxv rb4, 640(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 11
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 11
               lxv rA0, 1152(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 11
               lxv rA1, 1168(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 11
               lxv rA2, 1184(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 11
               lxv rA3, 1200(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 11
                lxv rA4, 1216(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 12
               lxv rA5, 1232(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 656(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 12
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 12
               xxspltd rB1, rb0, 0
               lxv rb0, 672(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 12
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 12
               xxspltd rB3, rb1, 0
               lxv rb1, 688(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 12
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 12
               lxv ra0, 1248(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 12
               lxv ra1, 1264(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 12
               lxv ra2, 1280(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 12
               lxv ra3, 1296(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 12
               lxv ra4, 1312(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 12
               lxv ra5, 1328(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 704(pB)
            #endif
         #endif
         #if KB >= 13
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 13
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 13
               xxspltd rB1, rb3, 0
               lxv rb3, 720(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 13
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 13
               xxspltd rB3, rb4, 0
               lxv rb4, 736(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 13
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 13
               lxv rA0, 1344(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 13
               lxv rA1, 1360(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 13
               lxv rA2, 1376(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 13
               lxv rA3, 1392(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 13
                lxv rA4, 1408(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 14
               lxv rA5, 1424(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 752(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 14
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 14
               xxspltd rB1, rb0, 0
               lxv rb0, 768(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 14
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 14
               xxspltd rB3, rb1, 0
               lxv rb1, 784(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 14
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 14
               lxv ra0, 1440(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 14
               lxv ra1, 1456(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 14
               lxv ra2, 1472(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 14
               lxv ra3, 1488(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 14
               lxv ra4, 1504(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 14
               lxv ra5, 1520(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 800(pB)
            #endif
         #endif
         #if KB >= 15
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 15
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 15
               xxspltd rB1, rb3, 0
               lxv rb3, 816(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 15
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 15
               xxspltd rB3, rb4, 0
               lxv rb4, 832(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 15
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 15
               lxv rA0, 1536(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 15
               lxv rA1, 1552(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 15
               lxv rA2, 1568(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 15
               lxv rA3, 1584(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 15
                lxv rA4, 1600(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 16
               lxv rA5, 1616(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 848(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 16
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 16
               xxspltd rB1, rb0, 0
               lxv rb0, 864(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 16
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 16
               xxspltd rB3, rb1, 0
               lxv rb1, 880(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 16
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 16
               lxv ra0, 1632(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 16
               lxv ra1, 1648(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 16
               lxv ra2, 1664(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 16
               lxv ra3, 1680(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 16
               lxv ra4, 1696(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 16
               lxv ra5, 1712(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 896(pB)
            #endif
         #endif
         #if KB >= 17
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 17
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 17
               xxspltd rB1, rb3, 0
               lxv rb3, 912(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 17
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 17
               xxspltd rB3, rb4, 0
               lxv rb4, 928(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 17
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 17
               lxv rA0, 1728(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 17
               lxv rA1, 1744(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 17
               lxv rA2, 1760(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 17
               lxv rA3, 1776(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 17
                lxv rA4, 1792(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 18
               lxv rA5, 1808(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 944(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 18
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 18
               xxspltd rB1, rb0, 0
               lxv rb0, 960(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 18
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 18
               xxspltd rB3, rb1, 0
               lxv rb1, 976(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 18
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 18
               lxv ra0, 1824(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 18
               lxv ra1, 1840(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 18
               lxv ra2, 1856(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 18
               lxv ra3, 1872(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 18
               lxv ra4, 1888(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 18
               lxv ra5, 1904(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 992(pB)
            #endif
         #endif
         #if KB >= 19
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 19
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 19
               xxspltd rB1, rb3, 0
               lxv rb3, 1008(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 19
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 19
               xxspltd rB3, rb4, 0
               lxv rb4, 1024(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 19
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 19
               lxv rA0, 1920(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 19
               lxv rA1, 1936(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 19
               lxv rA2, 1952(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 19
               lxv rA3, 1968(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 19
                lxv rA4, 1984(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 20
               lxv rA5, 2000(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 1040(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 20
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 20
               xxspltd rB1, rb0, 0
               lxv rb0, 1056(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 20
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 20
               xxspltd rB3, rb1, 0
               lxv rb1, 1072(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 20
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 20
               lxv ra0, 2016(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 20
               lxv ra1, 2032(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 20
               lxv ra2, 2048(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 20
               lxv ra3, 2064(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 20
               lxv ra4, 2080(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 20
               lxv ra5, 2096(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 1088(pB)
            #endif
         #endif
         #if KB >= 21
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 21
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 21
               xxspltd rB1, rb3, 0
               lxv rb3, 1104(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 21
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 21
               xxspltd rB3, rb4, 0
               lxv rb4, 1120(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 21
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 21
               lxv rA0, 2112(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 21
               lxv rA1, 2128(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 21
               lxv rA2, 2144(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 21
               lxv rA3, 2160(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 21
                lxv rA4, 2176(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 22
               lxv rA5, 2192(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 1136(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 22
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 22
               xxspltd rB1, rb0, 0
               lxv rb0, 1152(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 22
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 22
               xxspltd rB3, rb1, 0
               lxv rb1, 1168(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 22
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 22
               lxv ra0, 2208(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 22
               lxv ra1, 2224(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 22
               lxv ra2, 2240(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 22
               lxv ra3, 2256(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 22
               lxv ra4, 2272(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 22
               lxv ra5, 2288(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 1184(pB)
            #endif
         #endif
         #if KB >= 23
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 23
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 23
               xxspltd rB1, rb3, 0
               lxv rb3, 1200(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 23
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 23
               xxspltd rB3, rb4, 0
               lxv rb4, 1216(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 23
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 23
               lxv rA0, 2304(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 23
               lxv rA1, 2320(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 23
               lxv rA2, 2336(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 23
               lxv rA3, 2352(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 23
                lxv rA4, 2368(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 24
               lxv rA5, 2384(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 1232(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 24
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 24
               xxspltd rB1, rb0, 0
               lxv rb0, 1248(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 24
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 24
               xxspltd rB3, rb1, 0
               lxv rb1, 1264(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 24
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 24
               lxv ra0, 2400(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 24
               lxv ra1, 2416(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 24
               lxv ra2, 2432(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 24
               lxv ra3, 2448(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 24
               lxv ra4, 2464(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 24
               lxv ra5, 2480(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 1280(pB)
            #endif
         #endif
         #if KB >= 25
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 25
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 25
               xxspltd rB1, rb3, 0
               lxv rb3, 1296(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 25
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 25
               xxspltd rB3, rb4, 0
               lxv rb4, 1312(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 25
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 25
               lxv rA0, 2496(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 25
               lxv rA1, 2512(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 25
               lxv rA2, 2528(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 25
               lxv rA3, 2544(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 25
                lxv rA4, 2560(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 26
               lxv rA5, 2576(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 1328(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 26
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 26
               xxspltd rB1, rb0, 0
               lxv rb0, 1344(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 26
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 26
               xxspltd rB3, rb1, 0
               lxv rb1, 1360(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 26
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 26
               lxv ra0, 2592(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 26
               lxv ra1, 2608(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 26
               lxv ra2, 2624(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 26
               lxv ra3, 2640(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 26
               lxv ra4, 2656(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 26
               lxv ra5, 2672(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 1376(pB)
            #endif
         #endif
         #if KB >= 27
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 27
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 27
               xxspltd rB1, rb3, 0
               lxv rb3, 1392(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 27
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 27
               xxspltd rB3, rb4, 0
               lxv rb4, 1408(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 27
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 27
               lxv rA0, 2688(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 27
               lxv rA1, 2704(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 27
               lxv rA2, 2720(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 27
               lxv rA3, 2736(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 27
                lxv rA4, 2752(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 28
               lxv rA5, 2768(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 1424(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 28
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 28
               xxspltd rB1, rb0, 0
               lxv rb0, 1440(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 28
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 28
               xxspltd rB3, rb1, 0
               lxv rb1, 1456(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 28
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 28
               lxv ra0, 2784(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 28
               lxv ra1, 2800(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 28
               lxv ra2, 2816(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 28
               lxv ra3, 2832(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 28
               lxv ra4, 2848(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 28
               lxv ra5, 2864(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 1472(pB)
            #endif
         #endif
         #if KB >= 29
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 29
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 29
               xxspltd rB1, rb3, 0
               lxv rb3, 1488(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 29
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 29
               xxspltd rB3, rb4, 0
               lxv rb4, 1504(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 29
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 29
               lxv rA0, 2880(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 29
               lxv rA1, 2896(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 29
               lxv rA2, 2912(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 29
               lxv rA3, 2928(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 29
                lxv rA4, 2944(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 30
               lxv rA5, 2960(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 1520(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 30
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 30
               xxspltd rB1, rb0, 0
               lxv rb0, 1536(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 30
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 30
               xxspltd rB3, rb1, 0
               lxv rb1, 1552(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 30
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 30
               lxv ra0, 2976(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 30
               lxv ra1, 2992(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 30
               lxv ra2, 3008(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 30
               lxv ra3, 3024(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 30
               lxv ra4, 3040(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 30
               lxv ra5, 3056(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 1568(pB)
            #endif
         #endif
         #if KB >= 31
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 31
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 31
               xxspltd rB1, rb3, 0
               lxv rb3, 1584(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 31
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 31
               xxspltd rB3, rb4, 0
               lxv rb4, 1600(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 31
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 31
               lxv rA0, 3072(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 31
               lxv rA1, 3088(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 31
               lxv rA2, 3104(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 31
               lxv rA3, 3120(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 31
                lxv rA4, 3136(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 32
               lxv rA5, 3152(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 1616(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 32
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 32
               xxspltd rB1, rb0, 0
               lxv rb0, 1632(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 32
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 32
               xxspltd rB3, rb1, 0
               lxv rb1, 1648(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 32
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 32
               lxv ra0, 3168(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 32
               lxv ra1, 3184(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 32
               lxv ra2, 3200(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 32
               lxv ra3, 3216(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 32
               lxv ra4, 3232(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 32
               lxv ra5, 3248(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 1664(pB)
            #endif
         #endif
         #if KB >= 33
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 33
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 33
               xxspltd rB1, rb3, 0
               lxv rb3, 1680(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 33
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 33
               xxspltd rB3, rb4, 0
               lxv rb4, 1696(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 33
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 33
               lxv rA0, 3264(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 33
               lxv rA1, 3280(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 33
               lxv rA2, 3296(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 33
               lxv rA3, 3312(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 33
                lxv rA4, 3328(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 34
               lxv rA5, 3344(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 1712(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 34
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 34
               xxspltd rB1, rb0, 0
               lxv rb0, 1728(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 34
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 34
               xxspltd rB3, rb1, 0
               lxv rb1, 1744(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 34
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 34
               lxv ra0, 3360(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 34
               lxv ra1, 3376(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 34
               lxv ra2, 3392(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 34
               lxv ra3, 3408(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 34
               lxv ra4, 3424(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 34
               lxv ra5, 3440(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 1760(pB)
            #endif
         #endif
         #if KB >= 35
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 35
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 35
               xxspltd rB1, rb3, 0
               lxv rb3, 1776(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 35
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 35
               xxspltd rB3, rb4, 0
               lxv rb4, 1792(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 35
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 35
               lxv rA0, 3456(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 35
               lxv rA1, 3472(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 35
               lxv rA2, 3488(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 35
               lxv rA3, 3504(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 35
                lxv rA4, 3520(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 36
               lxv rA5, 3536(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 1808(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 36
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 36
               xxspltd rB1, rb0, 0
               lxv rb0, 1824(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 36
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 36
               xxspltd rB3, rb1, 0
               lxv rb1, 1840(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 36
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 36
               lxv ra0, 3552(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 36
               lxv ra1, 3568(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 36
               lxv ra2, 3584(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 36
               lxv ra3, 3600(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 36
               lxv ra4, 3616(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 36
               lxv ra5, 3632(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 1856(pB)
            #endif
         #endif
         #if KB >= 37
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 37
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 37
               xxspltd rB1, rb3, 0
               lxv rb3, 1872(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 37
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 37
               xxspltd rB3, rb4, 0
               lxv rb4, 1888(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 37
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 37
               lxv rA0, 3648(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 37
               lxv rA1, 3664(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 37
               lxv rA2, 3680(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 37
               lxv rA3, 3696(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 37
                lxv rA4, 3712(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 38
               lxv rA5, 3728(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 1904(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 38
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 38
               xxspltd rB1, rb0, 0
               lxv rb0, 1920(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 38
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 38
               xxspltd rB3, rb1, 0
               lxv rb1, 1936(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 38
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 38
               lxv ra0, 3744(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 38
               lxv ra1, 3760(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 38
               lxv ra2, 3776(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 38
               lxv ra3, 3792(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 38
               lxv ra4, 3808(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 38
               lxv ra5, 3824(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 1952(pB)
            #endif
         #endif
         #if KB >= 39
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 39
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 39
               xxspltd rB1, rb3, 0
               lxv rb3, 1968(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 39
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 39
               xxspltd rB3, rb4, 0
               lxv rb4, 1984(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 39
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 39
               lxv rA0, 3840(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 39
               lxv rA1, 3856(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 39
               lxv rA2, 3872(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 39
               lxv rA3, 3888(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 39
                lxv rA4, 3904(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 40
               lxv rA5, 3920(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 2000(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 40
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 40
               xxspltd rB1, rb0, 0
               lxv rb0, 2016(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 40
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 40
               xxspltd rB3, rb1, 0
               lxv rb1, 2032(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 40
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 40
               lxv ra0, 3936(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 40
               lxv ra1, 3952(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 40
               lxv ra2, 3968(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 40
               lxv ra3, 3984(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 40
               lxv ra4, 4000(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 40
               lxv ra5, 4016(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 2048(pB)
            #endif
         #endif
         #if KB >= 41
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 41
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 41
               xxspltd rB1, rb3, 0
               lxv rb3, 2064(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 41
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 41
               xxspltd rB3, rb4, 0
               lxv rb4, 2080(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 41
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 41
               lxv rA0, 4032(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 41
               lxv rA1, 4048(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 41
               lxv rA2, 4064(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 41
               lxv rA3, 4080(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 41
                lxv rA4, 4096(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 42
               lxv rA5, 4112(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 2096(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 42
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 42
               xxspltd rB1, rb0, 0
               lxv rb0, 2112(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 42
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 42
               xxspltd rB3, rb1, 0
               lxv rb1, 2128(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 42
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 42
               lxv ra0, 4128(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 42
               lxv ra1, 4144(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 42
               lxv ra2, 4160(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 42
               lxv ra3, 4176(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 42
               lxv ra4, 4192(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 42
               lxv ra5, 4208(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 2144(pB)
            #endif
         #endif
         #if KB >= 43
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 43
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 43
               xxspltd rB1, rb3, 0
               lxv rb3, 2160(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 43
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 43
               xxspltd rB3, rb4, 0
               lxv rb4, 2176(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 43
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 43
               lxv rA0, 4224(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 43
               lxv rA1, 4240(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 43
               lxv rA2, 4256(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 43
               lxv rA3, 4272(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 43
                lxv rA4, 4288(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 44
               lxv rA5, 4304(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 2192(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 44
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 44
               xxspltd rB1, rb0, 0
               lxv rb0, 2208(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 44
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 44
               xxspltd rB3, rb1, 0
               lxv rb1, 2224(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 44
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 44
               lxv ra0, 4320(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 44
               lxv ra1, 4336(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 44
               lxv ra2, 4352(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 44
               lxv ra3, 4368(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 44
               lxv ra4, 4384(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 44
               lxv ra5, 4400(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 2240(pB)
            #endif
         #endif
         #if KB >= 45
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 45
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 45
               xxspltd rB1, rb3, 0
               lxv rb3, 2256(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 45
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 45
               xxspltd rB3, rb4, 0
               lxv rb4, 2272(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 45
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 45
               lxv rA0, 4416(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 45
               lxv rA1, 4432(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 45
               lxv rA2, 4448(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 45
               lxv rA3, 4464(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 45
                lxv rA4, 4480(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 46
               lxv rA5, 4496(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 2288(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 46
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 46
               xxspltd rB1, rb0, 0
               lxv rb0, 2304(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 46
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 46
               xxspltd rB3, rb1, 0
               lxv rb1, 2320(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 46
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 46
               lxv ra0, 4512(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 46
               lxv ra1, 4528(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 46
               lxv ra2, 4544(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 46
               lxv ra3, 4560(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 46
               lxv ra4, 4576(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 46
               lxv ra5, 4592(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 2336(pB)
            #endif
         #endif
         #if KB >= 47
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 47
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 47
               xxspltd rB1, rb3, 0
               lxv rb3, 2352(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 47
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 47
               xxspltd rB3, rb4, 0
               lxv rb4, 2368(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 47
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 47
               lxv rA0, 4608(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 47
               lxv rA1, 4624(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 47
               lxv rA2, 4640(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 47
               lxv rA3, 4656(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 47
                lxv rA4, 4672(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 48
               lxv rA5, 4688(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 2384(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 48
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 48
               xxspltd rB1, rb0, 0
               lxv rb0, 2400(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 48
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 48
               xxspltd rB3, rb1, 0
               lxv rb1, 2416(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 48
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 48
               lxv ra0, 4704(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 48
               lxv ra1, 4720(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 48
               lxv ra2, 4736(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 48
               lxv ra3, 4752(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 48
               lxv ra4, 4768(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 48
               lxv ra5, 4784(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 2432(pB)
            #endif
         #endif
         #if KB >= 49
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 49
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 49
               xxspltd rB1, rb3, 0
               lxv rb3, 2448(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 49
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 49
               xxspltd rB3, rb4, 0
               lxv rb4, 2464(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 49
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 49
               lxv rA0, 4800(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 49
               lxv rA1, 4816(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 49
               lxv rA2, 4832(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 49
               lxv rA3, 4848(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 49
                lxv rA4, 4864(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 50
               lxv rA5, 4880(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 2480(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 50
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 50
               xxspltd rB1, rb0, 0
               lxv rb0, 2496(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 50
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 50
               xxspltd rB3, rb1, 0
               lxv rb1, 2512(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 50
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 50
               lxv ra0, 4896(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 50
               lxv ra1, 4912(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 50
               lxv ra2, 4928(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 50
               lxv ra3, 4944(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 50
               lxv ra4, 4960(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 50
               lxv ra5, 4976(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 2528(pB)
            #endif
         #endif
         #if KB >= 51
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 51
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 51
               xxspltd rB1, rb3, 0
               lxv rb3, 2544(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 51
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 51
               xxspltd rB3, rb4, 0
               lxv rb4, 2560(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 51
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 51
               lxv rA0, 4992(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 51
               lxv rA1, 5008(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 51
               lxv rA2, 5024(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 51
               lxv rA3, 5040(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 51
                lxv rA4, 5056(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 52
               lxv rA5, 5072(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 2576(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 52
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 52
               xxspltd rB1, rb0, 0
               lxv rb0, 2592(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 52
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 52
               xxspltd rB3, rb1, 0
               lxv rb1, 2608(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 52
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 52
               lxv ra0, 5088(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 52
               lxv ra1, 5104(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 52
               lxv ra2, 5120(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 52
               lxv ra3, 5136(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 52
               lxv ra4, 5152(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 52
               lxv ra5, 5168(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 2624(pB)
            #endif
         #endif
         #if KB >= 53
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 53
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 53
               xxspltd rB1, rb3, 0
               lxv rb3, 2640(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 53
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 53
               xxspltd rB3, rb4, 0
               lxv rb4, 2656(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 53
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 53
               lxv rA0, 5184(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 53
               lxv rA1, 5200(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 53
               lxv rA2, 5216(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 53
               lxv rA3, 5232(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 53
                lxv rA4, 5248(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 54
               lxv rA5, 5264(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 2672(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 54
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 54
               xxspltd rB1, rb0, 0
               lxv rb0, 2688(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 54
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 54
               xxspltd rB3, rb1, 0
               lxv rb1, 2704(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 54
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 54
               lxv ra0, 5280(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 54
               lxv ra1, 5296(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 54
               lxv ra2, 5312(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 54
               lxv ra3, 5328(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 54
               lxv ra4, 5344(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 54
               lxv ra5, 5360(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 2720(pB)
            #endif
         #endif
         #if KB >= 55
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 55
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 55
               xxspltd rB1, rb3, 0
               lxv rb3, 2736(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 55
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 55
               xxspltd rB3, rb4, 0
               lxv rb4, 2752(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 55
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 55
               lxv rA0, 5376(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 55
               lxv rA1, 5392(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 55
               lxv rA2, 5408(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 55
               lxv rA3, 5424(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 55
                lxv rA4, 5440(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 56
               lxv rA5, 5456(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 2768(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 56
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 56
               xxspltd rB1, rb0, 0
               lxv rb0, 2784(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 56
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 56
               xxspltd rB3, rb1, 0
               lxv rb1, 2800(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 56
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 56
               lxv ra0, 5472(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 56
               lxv ra1, 5488(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 56
               lxv ra2, 5504(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 56
               lxv ra3, 5520(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 56
               lxv ra4, 5536(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 56
               lxv ra5, 5552(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 2816(pB)
            #endif
         #endif
         #if KB >= 57
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 57
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 57
               xxspltd rB1, rb3, 0
               lxv rb3, 2832(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 57
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 57
               xxspltd rB3, rb4, 0
               lxv rb4, 2848(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 57
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 57
               lxv rA0, 5568(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 57
               lxv rA1, 5584(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 57
               lxv rA2, 5600(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 57
               lxv rA3, 5616(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 57
                lxv rA4, 5632(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 58
               lxv rA5, 5648(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 2864(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 58
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 58
               xxspltd rB1, rb0, 0
               lxv rb0, 2880(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 58
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 58
               xxspltd rB3, rb1, 0
               lxv rb1, 2896(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 58
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 58
               lxv ra0, 5664(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 58
               lxv ra1, 5680(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 58
               lxv ra2, 5696(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 58
               lxv ra3, 5712(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 58
               lxv ra4, 5728(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 58
               lxv ra5, 5744(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 2912(pB)
            #endif
         #endif
         #if KB >= 59
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 59
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 59
               xxspltd rB1, rb3, 0
               lxv rb3, 2928(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 59
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 59
               xxspltd rB3, rb4, 0
               lxv rb4, 2944(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 59
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 59
               lxv rA0, 5760(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 59
               lxv rA1, 5776(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 59
               lxv rA2, 5792(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 59
               lxv rA3, 5808(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 59
                lxv rA4, 5824(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 60
               lxv rA5, 5840(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 2960(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 60
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 60
               xxspltd rB1, rb0, 0
               lxv rb0, 2976(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 60
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 60
               xxspltd rB3, rb1, 0
               lxv rb1, 2992(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 60
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 60
               lxv ra0, 5856(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 60
               lxv ra1, 5872(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 60
               lxv ra2, 5888(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 60
               lxv ra3, 5904(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 60
               lxv ra4, 5920(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 60
               lxv ra5, 5936(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 3008(pB)
            #endif
         #endif
         #if KB >= 61
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 61
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 61
               xxspltd rB1, rb3, 0
               lxv rb3, 3024(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 61
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 61
               xxspltd rB3, rb4, 0
               lxv rb4, 3040(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 61
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 61
               lxv rA0, 5952(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 61
               lxv rA1, 5968(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 61
               lxv rA2, 5984(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 61
               lxv rA3, 6000(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 61
                lxv rA4, 6016(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 62
               lxv rA5, 6032(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 3056(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 62
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 62
               xxspltd rB1, rb0, 0
               lxv rb0, 3072(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 62
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 62
               xxspltd rB3, rb1, 0
               lxv rb1, 3088(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 62
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 62
               lxv ra0, 6048(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 62
               lxv ra1, 6064(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 62
               lxv ra2, 6080(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 62
               lxv ra3, 6096(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 62
               lxv ra4, 6112(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 62
               lxv ra5, 6128(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 3104(pB)
            #endif
         #endif
         #if KB >= 63
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 63
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 63
               xxspltd rB1, rb3, 0
               lxv rb3, 3120(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 63
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 63
               xxspltd rB3, rb4, 0
               lxv rb4, 3136(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 63
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 63
               lxv rA0, 6144(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 63
               lxv rA1, 6160(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 63
               lxv rA2, 6176(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 63
               lxv rA3, 6192(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 63
                lxv rA4, 6208(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 64
               lxv rA5, 6224(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 3152(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 64
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 64
               xxspltd rB1, rb0, 0
               lxv rb0, 3168(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 64
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 64
               xxspltd rB3, rb1, 0
               lxv rb1, 3184(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 64
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 64
               lxv ra0, 6240(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 64
               lxv ra1, 6256(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 64
               lxv ra2, 6272(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 64
               lxv ra3, 6288(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 64
               lxv ra4, 6304(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 64
               lxv ra5, 6320(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 3200(pB)
            #endif
         #endif
         #if KB >= 65
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 65
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 65
               xxspltd rB1, rb3, 0
               lxv rb3, 3216(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 65
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 65
               xxspltd rB3, rb4, 0
               lxv rb4, 3232(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 65
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 65
               lxv rA0, 6336(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 65
               lxv rA1, 6352(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 65
               lxv rA2, 6368(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 65
               lxv rA3, 6384(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 65
                lxv rA4, 6400(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 66
               lxv rA5, 6416(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 3248(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 66
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 66
               xxspltd rB1, rb0, 0
               lxv rb0, 3264(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 66
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 66
               xxspltd rB3, rb1, 0
               lxv rb1, 3280(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 66
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 66
               lxv ra0, 6432(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 66
               lxv ra1, 6448(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 66
               lxv ra2, 6464(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 66
               lxv ra3, 6480(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 66
               lxv ra4, 6496(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 66
               lxv ra5, 6512(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 3296(pB)
            #endif
         #endif
         #if KB >= 67
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 67
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 67
               xxspltd rB1, rb3, 0
               lxv rb3, 3312(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 67
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 67
               xxspltd rB3, rb4, 0
               lxv rb4, 3328(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 67
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 67
               lxv rA0, 6528(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 67
               lxv rA1, 6544(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 67
               lxv rA2, 6560(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 67
               lxv rA3, 6576(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 67
                lxv rA4, 6592(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 68
               lxv rA5, 6608(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 3344(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 68
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 68
               xxspltd rB1, rb0, 0
               lxv rb0, 3360(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 68
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 68
               xxspltd rB3, rb1, 0
               lxv rb1, 3376(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 68
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 68
               lxv ra0, 6624(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 68
               lxv ra1, 6640(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 68
               lxv ra2, 6656(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 68
               lxv ra3, 6672(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 68
               lxv ra4, 6688(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 68
               lxv ra5, 6704(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 3392(pB)
            #endif
         #endif
         #if KB >= 69
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 69
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 69
               xxspltd rB1, rb3, 0
               lxv rb3, 3408(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 69
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 69
               xxspltd rB3, rb4, 0
               lxv rb4, 3424(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 69
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 69
               lxv rA0, 6720(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 69
               lxv rA1, 6736(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 69
               lxv rA2, 6752(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 69
               lxv rA3, 6768(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 69
                lxv rA4, 6784(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 70
               lxv rA5, 6800(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 3440(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 70
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 70
               xxspltd rB1, rb0, 0
               lxv rb0, 3456(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 70
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 70
               xxspltd rB3, rb1, 0
               lxv rb1, 3472(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 70
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 70
               lxv ra0, 6816(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 70
               lxv ra1, 6832(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 70
               lxv ra2, 6848(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 70
               lxv ra3, 6864(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 70
               lxv ra4, 6880(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 70
               lxv ra5, 6896(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 3488(pB)
            #endif
         #endif
         #if KB >= 71
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 71
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 71
               xxspltd rB1, rb3, 0
               lxv rb3, 3504(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 71
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 71
               xxspltd rB3, rb4, 0
               lxv rb4, 3520(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 71
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 71
               lxv rA0, 6912(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 71
               lxv rA1, 6928(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 71
               lxv rA2, 6944(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 71
               lxv rA3, 6960(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 71
                lxv rA4, 6976(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 72
               lxv rA5, 6992(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 3536(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 72
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 72
               xxspltd rB1, rb0, 0
               lxv rb0, 3552(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 72
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 72
               xxspltd rB3, rb1, 0
               lxv rb1, 3568(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 72
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 72
               lxv ra0, 7008(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 72
               lxv ra1, 7024(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 72
               lxv ra2, 7040(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 72
               lxv ra3, 7056(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 72
               lxv ra4, 7072(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 72
               lxv ra5, 7088(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 3584(pB)
            #endif
         #endif
         #if KB >= 73
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 73
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 73
               xxspltd rB1, rb3, 0
               lxv rb3, 3600(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 73
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 73
               xxspltd rB3, rb4, 0
               lxv rb4, 3616(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 73
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 73
               lxv rA0, 7104(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 73
               lxv rA1, 7120(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 73
               lxv rA2, 7136(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 73
               lxv rA3, 7152(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 73
                lxv rA4, 7168(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 74
               lxv rA5, 7184(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 3632(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 74
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 74
               xxspltd rB1, rb0, 0
               lxv rb0, 3648(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 74
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 74
               xxspltd rB3, rb1, 0
               lxv rb1, 3664(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 74
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 74
               lxv ra0, 7200(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 74
               lxv ra1, 7216(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 74
               lxv ra2, 7232(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 74
               lxv ra3, 7248(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 74
               lxv ra4, 7264(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 74
               lxv ra5, 7280(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 3680(pB)
            #endif
         #endif
         #if KB >= 75
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 75
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 75
               xxspltd rB1, rb3, 0
               lxv rb3, 3696(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 75
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 75
               xxspltd rB3, rb4, 0
               lxv rb4, 3712(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 75
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 75
               lxv rA0, 7296(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 75
               lxv rA1, 7312(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 75
               lxv rA2, 7328(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 75
               lxv rA3, 7344(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 75
                lxv rA4, 7360(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 76
               lxv rA5, 7376(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 3728(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 76
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 76
               xxspltd rB1, rb0, 0
               lxv rb0, 3744(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 76
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 76
               xxspltd rB3, rb1, 0
               lxv rb1, 3760(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 76
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 76
               lxv ra0, 7392(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 76
               lxv ra1, 7408(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 76
               lxv ra2, 7424(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 76
               lxv ra3, 7440(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 76
               lxv ra4, 7456(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 76
               lxv ra5, 7472(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 3776(pB)
            #endif
         #endif
         #if KB >= 77
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 77
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 77
               xxspltd rB1, rb3, 0
               lxv rb3, 3792(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 77
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 77
               xxspltd rB3, rb4, 0
               lxv rb4, 3808(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 77
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 77
               lxv rA0, 7488(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 77
               lxv rA1, 7504(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 77
               lxv rA2, 7520(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 77
               lxv rA3, 7536(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 77
                lxv rA4, 7552(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 78
               lxv rA5, 7568(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 3824(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 78
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 78
               xxspltd rB1, rb0, 0
               lxv rb0, 3840(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 78
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 78
               xxspltd rB3, rb1, 0
               lxv rb1, 3856(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 78
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 78
               lxv ra0, 7584(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 78
               lxv ra1, 7600(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 78
               lxv ra2, 7616(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 78
               lxv ra3, 7632(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 78
               lxv ra4, 7648(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 78
               lxv ra5, 7664(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 3872(pB)
            #endif
         #endif
         #if KB >= 79
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 79
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 79
               xxspltd rB1, rb3, 0
               lxv rb3, 3888(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 79
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 79
               xxspltd rB3, rb4, 0
               lxv rb4, 3904(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 79
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 79
               lxv rA0, 7680(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 79
               lxv rA1, 7696(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 79
               lxv rA2, 7712(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 79
               lxv rA3, 7728(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 79
                lxv rA4, 7744(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 80
               lxv rA5, 7760(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 3920(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 80
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 80
               xxspltd rB1, rb0, 0
               lxv rb0, 3936(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 80
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 80
               xxspltd rB3, rb1, 0
               lxv rb1, 3952(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 80
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 80
               lxv ra0, 7776(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 80
               lxv ra1, 7792(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 80
               lxv ra2, 7808(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 80
               lxv ra3, 7824(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 80
               lxv ra4, 7840(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 80
               lxv ra5, 7856(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 3968(pB)
            #endif
         #endif
         #if KB >= 81
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 81
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 81
               xxspltd rB1, rb3, 0
               lxv rb3, 3984(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 81
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 81
               xxspltd rB3, rb4, 0
               lxv rb4, 4000(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 81
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 81
               lxv rA0, 7872(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 81
               lxv rA1, 7888(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 81
               lxv rA2, 7904(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 81
               lxv rA3, 7920(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 81
                lxv rA4, 7936(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 82
               lxv rA5, 7952(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 4016(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 82
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 82
               xxspltd rB1, rb0, 0
               lxv rb0, 4032(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 82
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 82
               xxspltd rB3, rb1, 0
               lxv rb1, 4048(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 82
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 82
               lxv ra0, 7968(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 82
               lxv ra1, 7984(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 82
               lxv ra2, 8000(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 82
               lxv ra3, 8016(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 82
               lxv ra4, 8032(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 82
               lxv ra5, 8048(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 4064(pB)
            #endif
         #endif
         #if KB >= 83
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 83
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 83
               xxspltd rB1, rb3, 0
               lxv rb3, 4080(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 83
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 83
               xxspltd rB3, rb4, 0
               lxv rb4, 4096(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 83
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 83
               lxv rA0, 8064(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 83
               lxv rA1, 8080(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 83
               lxv rA2, 8096(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 83
               lxv rA3, 8112(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 83
                lxv rA4, 8128(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 84
               lxv rA5, 8144(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 4112(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 84
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 84
               xxspltd rB1, rb0, 0
               lxv rb0, 4128(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 84
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 84
               xxspltd rB3, rb1, 0
               lxv rb1, 4144(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 84
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 84
               lxv ra0, 8160(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 84
               lxv ra1, 8176(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 84
               lxv ra2, 8192(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 84
               lxv ra3, 8208(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 84
               lxv ra4, 8224(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 84
               lxv ra5, 8240(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 4160(pB)
            #endif
         #endif
         #if KB >= 85
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 85
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 85
               xxspltd rB1, rb3, 0
               lxv rb3, 4176(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 85
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 85
               xxspltd rB3, rb4, 0
               lxv rb4, 4192(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 85
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 85
               lxv rA0, 8256(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 85
               lxv rA1, 8272(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 85
               lxv rA2, 8288(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 85
               lxv rA3, 8304(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 85
                lxv rA4, 8320(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 86
               lxv rA5, 8336(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 4208(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 86
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 86
               xxspltd rB1, rb0, 0
               lxv rb0, 4224(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 86
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 86
               xxspltd rB3, rb1, 0
               lxv rb1, 4240(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 86
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 86
               lxv ra0, 8352(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 86
               lxv ra1, 8368(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 86
               lxv ra2, 8384(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 86
               lxv ra3, 8400(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 86
               lxv ra4, 8416(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 86
               lxv ra5, 8432(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 4256(pB)
            #endif
         #endif
         #if KB >= 87
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 87
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 87
               xxspltd rB1, rb3, 0
               lxv rb3, 4272(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 87
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 87
               xxspltd rB3, rb4, 0
               lxv rb4, 4288(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 87
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 87
               lxv rA0, 8448(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 87
               lxv rA1, 8464(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 87
               lxv rA2, 8480(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 87
               lxv rA3, 8496(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 87
                lxv rA4, 8512(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 88
               lxv rA5, 8528(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 4304(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 88
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 88
               xxspltd rB1, rb0, 0
               lxv rb0, 4320(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 88
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 88
               xxspltd rB3, rb1, 0
               lxv rb1, 4336(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 88
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 88
               lxv ra0, 8544(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 88
               lxv ra1, 8560(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 88
               lxv ra2, 8576(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 88
               lxv ra3, 8592(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 88
               lxv ra4, 8608(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 88
               lxv ra5, 8624(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 4352(pB)
            #endif
         #endif
         #if KB >= 89
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 89
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 89
               xxspltd rB1, rb3, 0
               lxv rb3, 4368(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 89
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 89
               xxspltd rB3, rb4, 0
               lxv rb4, 4384(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 89
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 89
               lxv rA0, 8640(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 89
               lxv rA1, 8656(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 89
               lxv rA2, 8672(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 89
               lxv rA3, 8688(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 89
                lxv rA4, 8704(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 90
               lxv rA5, 8720(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 4400(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 90
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 90
               xxspltd rB1, rb0, 0
               lxv rb0, 4416(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 90
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 90
               xxspltd rB3, rb1, 0
               lxv rb1, 4432(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 90
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 90
               lxv ra0, 8736(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 90
               lxv ra1, 8752(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 90
               lxv ra2, 8768(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 90
               lxv ra3, 8784(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 90
               lxv ra4, 8800(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 90
               lxv ra5, 8816(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 4448(pB)
            #endif
         #endif
         #if KB >= 91
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 91
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 91
               xxspltd rB1, rb3, 0
               lxv rb3, 4464(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 91
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 91
               xxspltd rB3, rb4, 0
               lxv rb4, 4480(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 91
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 91
               lxv rA0, 8832(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 91
               lxv rA1, 8848(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 91
               lxv rA2, 8864(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 91
               lxv rA3, 8880(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 91
                lxv rA4, 8896(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 92
               lxv rA5, 8912(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 4496(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 92
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 92
               xxspltd rB1, rb0, 0
               lxv rb0, 4512(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 92
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 92
               xxspltd rB3, rb1, 0
               lxv rb1, 4528(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 92
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 92
               lxv ra0, 8928(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 92
               lxv ra1, 8944(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 92
               lxv ra2, 8960(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 92
               lxv ra3, 8976(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 92
               lxv ra4, 8992(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 92
               lxv ra5, 9008(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 4544(pB)
            #endif
         #endif
         #if KB >= 93
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 93
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 93
               xxspltd rB1, rb3, 0
               lxv rb3, 4560(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 93
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 93
               xxspltd rB3, rb4, 0
               lxv rb4, 4576(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 93
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 93
               lxv rA0, 9024(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 93
               lxv rA1, 9040(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 93
               lxv rA2, 9056(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 93
               lxv rA3, 9072(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 93
                lxv rA4, 9088(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 94
               lxv rA5, 9104(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 4592(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 94
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 94
               xxspltd rB1, rb0, 0
               lxv rb0, 4608(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 94
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 94
               xxspltd rB3, rb1, 0
               lxv rb1, 4624(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 94
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 94
               lxv ra0, 9120(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 94
               lxv ra1, 9136(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 94
               lxv ra2, 9152(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 94
               lxv ra3, 9168(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 94
               lxv ra4, 9184(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 94
               lxv ra5, 9200(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 4640(pB)
            #endif
         #endif
         #if KB >= 95
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 95
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 95
               xxspltd rB1, rb3, 0
               lxv rb3, 4656(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 95
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 95
               xxspltd rB3, rb4, 0
               lxv rb4, 4672(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 95
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 95
               lxv rA0, 9216(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 95
               lxv rA1, 9232(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 95
               lxv rA2, 9248(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 95
               lxv rA3, 9264(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 95
                lxv rA4, 9280(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 96
               lxv rA5, 9296(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 4688(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 96
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 96
               xxspltd rB1, rb0, 0
               lxv rb0, 4704(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 96
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 96
               xxspltd rB3, rb1, 0
               lxv rb1, 4720(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 96
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 96
               lxv ra0, 9312(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 96
               lxv ra1, 9328(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 96
               lxv ra2, 9344(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 96
               lxv ra3, 9360(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 96
               lxv ra4, 9376(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 96
               lxv ra5, 9392(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 4736(pB)
            #endif
         #endif
         #if KB >= 97
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 97
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 97
               xxspltd rB1, rb3, 0
               lxv rb3, 4752(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 97
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 97
               xxspltd rB3, rb4, 0
               lxv rb4, 4768(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 97
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 97
               lxv rA0, 9408(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 97
               lxv rA1, 9424(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 97
               lxv rA2, 9440(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 97
               lxv rA3, 9456(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 97
                lxv rA4, 9472(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 98
               lxv rA5, 9488(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 4784(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 98
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 98
               xxspltd rB1, rb0, 0
               lxv rb0, 4800(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 98
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 98
               xxspltd rB3, rb1, 0
               lxv rb1, 4816(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 98
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 98
               lxv ra0, 9504(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 98
               lxv ra1, 9520(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 98
               lxv ra2, 9536(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 98
               lxv ra3, 9552(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 98
               lxv ra4, 9568(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 98
               lxv ra5, 9584(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 4832(pB)
            #endif
         #endif
         #if KB >= 99
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 99
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 99
               xxspltd rB1, rb3, 0
               lxv rb3, 4848(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 99
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 99
               xxspltd rB3, rb4, 0
               lxv rb4, 4864(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 99
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 99
               lxv rA0, 9600(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 99
               lxv rA1, 9616(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 99
               lxv rA2, 9632(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 99
               lxv rA3, 9648(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 99
                lxv rA4, 9664(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 100
               lxv rA5, 9680(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 4880(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 100
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 100
               xxspltd rB1, rb0, 0
               lxv rb0, 4896(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 100
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 100
               xxspltd rB3, rb1, 0
               lxv rb1, 4912(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 100
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 100
               lxv ra0, 9696(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 100
               lxv ra1, 9712(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 100
               lxv ra2, 9728(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 100
               lxv ra3, 9744(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 100
               lxv ra4, 9760(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 100
               lxv ra5, 9776(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 4928(pB)
            #endif
         #endif
         #if KB >= 101
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 101
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 101
               xxspltd rB1, rb3, 0
               lxv rb3, 4944(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 101
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 101
               xxspltd rB3, rb4, 0
               lxv rb4, 4960(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 101
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 101
               lxv rA0, 9792(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 101
               lxv rA1, 9808(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 101
               lxv rA2, 9824(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 101
               lxv rA3, 9840(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 101
                lxv rA4, 9856(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 102
               lxv rA5, 9872(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 4976(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 102
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 102
               xxspltd rB1, rb0, 0
               lxv rb0, 4992(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 102
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 102
               xxspltd rB3, rb1, 0
               lxv rb1, 5008(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 102
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 102
               lxv ra0, 9888(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 102
               lxv ra1, 9904(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 102
               lxv ra2, 9920(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 102
               lxv ra3, 9936(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 102
               lxv ra4, 9952(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 102
               lxv ra5, 9968(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 5024(pB)
            #endif
         #endif
         #if KB >= 103
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 103
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 103
               xxspltd rB1, rb3, 0
               lxv rb3, 5040(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 103
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 103
               xxspltd rB3, rb4, 0
               lxv rb4, 5056(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 103
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 103
               lxv rA0, 9984(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 103
               lxv rA1, 10000(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 103
               lxv rA2, 10016(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 103
               lxv rA3, 10032(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 103
                lxv rA4, 10048(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 104
               lxv rA5, 10064(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 5072(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 104
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 104
               xxspltd rB1, rb0, 0
               lxv rb0, 5088(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 104
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 104
               xxspltd rB3, rb1, 0
               lxv rb1, 5104(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 104
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 104
               lxv ra0, 10080(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 104
               lxv ra1, 10096(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 104
               lxv ra2, 10112(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 104
               lxv ra3, 10128(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 104
               lxv ra4, 10144(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 104
               lxv ra5, 10160(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 5120(pB)
            #endif
         #endif
         #if KB >= 105
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 105
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 105
               xxspltd rB1, rb3, 0
               lxv rb3, 5136(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 105
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 105
               xxspltd rB3, rb4, 0
               lxv rb4, 5152(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 105
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 105
               lxv rA0, 10176(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 105
               lxv rA1, 10192(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 105
               lxv rA2, 10208(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 105
               lxv rA3, 10224(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 105
                lxv rA4, 10240(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 106
               lxv rA5, 10256(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 5168(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 106
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 106
               xxspltd rB1, rb0, 0
               lxv rb0, 5184(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 106
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 106
               xxspltd rB3, rb1, 0
               lxv rb1, 5200(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 106
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 106
               lxv ra0, 10272(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 106
               lxv ra1, 10288(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 106
               lxv ra2, 10304(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 106
               lxv ra3, 10320(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 106
               lxv ra4, 10336(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 106
               lxv ra5, 10352(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 5216(pB)
            #endif
         #endif
         #if KB >= 107
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 107
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 107
               xxspltd rB1, rb3, 0
               lxv rb3, 5232(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 107
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 107
               xxspltd rB3, rb4, 0
               lxv rb4, 5248(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 107
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 107
               lxv rA0, 10368(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 107
               lxv rA1, 10384(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 107
               lxv rA2, 10400(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 107
               lxv rA3, 10416(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 107
                lxv rA4, 10432(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 108
               lxv rA5, 10448(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 5264(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 108
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 108
               xxspltd rB1, rb0, 0
               lxv rb0, 5280(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 108
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 108
               xxspltd rB3, rb1, 0
               lxv rb1, 5296(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 108
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 108
               lxv ra0, 10464(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 108
               lxv ra1, 10480(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 108
               lxv ra2, 10496(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 108
               lxv ra3, 10512(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 108
               lxv ra4, 10528(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 108
               lxv ra5, 10544(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 5312(pB)
            #endif
         #endif
         #if KB >= 109
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 109
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 109
               xxspltd rB1, rb3, 0
               lxv rb3, 5328(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 109
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 109
               xxspltd rB3, rb4, 0
               lxv rb4, 5344(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 109
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 109
               lxv rA0, 10560(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 109
               lxv rA1, 10576(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 109
               lxv rA2, 10592(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 109
               lxv rA3, 10608(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 109
                lxv rA4, 10624(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 110
               lxv rA5, 10640(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 5360(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 110
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 110
               xxspltd rB1, rb0, 0
               lxv rb0, 5376(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 110
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 110
               xxspltd rB3, rb1, 0
               lxv rb1, 5392(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 110
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 110
               lxv ra0, 10656(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 110
               lxv ra1, 10672(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 110
               lxv ra2, 10688(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 110
               lxv ra3, 10704(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 110
               lxv ra4, 10720(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 110
               lxv ra5, 10736(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 5408(pB)
            #endif
         #endif
         #if KB >= 111
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 111
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 111
               xxspltd rB1, rb3, 0
               lxv rb3, 5424(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 111
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 111
               xxspltd rB3, rb4, 0
               lxv rb4, 5440(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 111
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 111
               lxv rA0, 10752(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 111
               lxv rA1, 10768(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 111
               lxv rA2, 10784(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 111
               lxv rA3, 10800(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 111
                lxv rA4, 10816(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 112
               lxv rA5, 10832(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 5456(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 112
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 112
               xxspltd rB1, rb0, 0
               lxv rb0, 5472(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 112
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 112
               xxspltd rB3, rb1, 0
               lxv rb1, 5488(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 112
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 112
               lxv ra0, 10848(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 112
               lxv ra1, 10864(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 112
               lxv ra2, 10880(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 112
               lxv ra3, 10896(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 112
               lxv ra4, 10912(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 112
               lxv ra5, 10928(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 5504(pB)
            #endif
         #endif
         #if KB >= 113
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 113
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 113
               xxspltd rB1, rb3, 0
               lxv rb3, 5520(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 113
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 113
               xxspltd rB3, rb4, 0
               lxv rb4, 5536(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 113
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 113
               lxv rA0, 10944(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 113
               lxv rA1, 10960(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 113
               lxv rA2, 10976(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 113
               lxv rA3, 10992(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 113
                lxv rA4, 11008(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 114
               lxv rA5, 11024(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 5552(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 114
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 114
               xxspltd rB1, rb0, 0
               lxv rb0, 5568(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 114
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 114
               xxspltd rB3, rb1, 0
               lxv rb1, 5584(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 114
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 114
               lxv ra0, 11040(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 114
               lxv ra1, 11056(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 114
               lxv ra2, 11072(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 114
               lxv ra3, 11088(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 114
               lxv ra4, 11104(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 114
               lxv ra5, 11120(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 5600(pB)
            #endif
         #endif
         #if KB >= 115
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 115
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 115
               xxspltd rB1, rb3, 0
               lxv rb3, 5616(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 115
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 115
               xxspltd rB3, rb4, 0
               lxv rb4, 5632(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 115
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 115
               lxv rA0, 11136(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 115
               lxv rA1, 11152(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 115
               lxv rA2, 11168(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 115
               lxv rA3, 11184(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 115
                lxv rA4, 11200(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 116
               lxv rA5, 11216(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 5648(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 116
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 116
               xxspltd rB1, rb0, 0
               lxv rb0, 5664(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 116
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 116
               xxspltd rB3, rb1, 0
               lxv rb1, 5680(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 116
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 116
               lxv ra0, 11232(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 116
               lxv ra1, 11248(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 116
               lxv ra2, 11264(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 116
               lxv ra3, 11280(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 116
               lxv ra4, 11296(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 116
               lxv ra5, 11312(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 5696(pB)
            #endif
         #endif
         #if KB >= 117
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 117
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 117
               xxspltd rB1, rb3, 0
               lxv rb3, 5712(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 117
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 117
               xxspltd rB3, rb4, 0
               lxv rb4, 5728(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 117
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 117
               lxv rA0, 11328(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 117
               lxv rA1, 11344(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 117
               lxv rA2, 11360(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 117
               lxv rA3, 11376(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 117
                lxv rA4, 11392(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 118
               lxv rA5, 11408(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 5744(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 118
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 118
               xxspltd rB1, rb0, 0
               lxv rb0, 5760(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 118
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 118
               xxspltd rB3, rb1, 0
               lxv rb1, 5776(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 118
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 118
               lxv ra0, 11424(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 118
               lxv ra1, 11440(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 118
               lxv ra2, 11456(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 118
               lxv ra3, 11472(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 118
               lxv ra4, 11488(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 118
               lxv ra5, 11504(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 5792(pB)
            #endif
         #endif
         #if KB >= 119
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 119
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 119
               xxspltd rB1, rb3, 0
               lxv rb3, 5808(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 119
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 119
               xxspltd rB3, rb4, 0
               lxv rb4, 5824(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 119
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 119
               lxv rA0, 11520(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 119
               lxv rA1, 11536(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 119
               lxv rA2, 11552(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 119
               lxv rA3, 11568(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 119
                lxv rA4, 11584(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 120
               lxv rA5, 11600(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 5840(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 120
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 120
               xxspltd rB1, rb0, 0
               lxv rb0, 5856(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 120
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 120
               xxspltd rB3, rb1, 0
               lxv rb1, 5872(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 120
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 120
               lxv ra0, 11616(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 120
               lxv ra1, 11632(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 120
               lxv ra2, 11648(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 120
               lxv ra3, 11664(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 120
               lxv ra4, 11680(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 120
               lxv ra5, 11696(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 5888(pB)
            #endif
         #endif
         #if KB >= 121
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 121
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 121
               xxspltd rB1, rb3, 0
               lxv rb3, 5904(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 121
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 121
               xxspltd rB3, rb4, 0
               lxv rb4, 5920(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 121
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 121
               lxv rA0, 11712(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 121
               lxv rA1, 11728(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 121
               lxv rA2, 11744(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 121
               lxv rA3, 11760(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 121
                lxv rA4, 11776(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 122
               lxv rA5, 11792(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 5936(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 122
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 122
               xxspltd rB1, rb0, 0
               lxv rb0, 5952(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 122
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 122
               xxspltd rB3, rb1, 0
               lxv rb1, 5968(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 122
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 122
               lxv ra0, 11808(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 122
               lxv ra1, 11824(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 122
               lxv ra2, 11840(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 122
               lxv ra3, 11856(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 122
               lxv ra4, 11872(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 122
               lxv ra5, 11888(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 5984(pB)
            #endif
         #endif
         #if KB >= 123
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 123
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 123
               xxspltd rB1, rb3, 0
               lxv rb3, 6000(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 123
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 123
               xxspltd rB3, rb4, 0
               lxv rb4, 6016(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 123
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 123
               lxv rA0, 11904(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 123
               lxv rA1, 11920(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 123
               lxv rA2, 11936(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 123
               lxv rA3, 11952(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 123
                lxv rA4, 11968(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 124
               lxv rA5, 11984(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 6032(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 124
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 124
               xxspltd rB1, rb0, 0
               lxv rb0, 6048(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 124
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 124
               xxspltd rB3, rb1, 0
               lxv rb1, 6064(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 124
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 124
               lxv ra0, 12000(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 124
               lxv ra1, 12016(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 124
               lxv ra2, 12032(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 124
               lxv ra3, 12048(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 124
               lxv ra4, 12064(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 124
               lxv ra5, 12080(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 6080(pB)
            #endif
         #endif
         #if KB >= 125
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 125
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 125
               xxspltd rB1, rb3, 0
               lxv rb3, 6096(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 125
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 125
               xxspltd rB3, rb4, 0
               lxv rb4, 6112(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 125
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 125
               lxv rA0, 12096(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 125
               lxv rA1, 12112(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 125
               lxv rA2, 12128(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 125
               lxv rA3, 12144(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 125
                lxv rA4, 12160(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 126
               lxv rA5, 12176(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 6128(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 126
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 126
               xxspltd rB1, rb0, 0
               lxv rb0, 6144(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 126
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 126
               xxspltd rB3, rb1, 0
               lxv rb1, 6160(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 126
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 126
               lxv ra0, 12192(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 126
               lxv ra1, 12208(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 126
               lxv ra2, 12224(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 126
               lxv ra3, 12240(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 126
               lxv ra4, 12256(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 126
               lxv ra5, 12272(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 6176(pB)
            #endif
         #endif
         #if KB >= 127
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 127
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 127
               xxspltd rB1, rb3, 0
               lxv rb3, 6192(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 127
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 127
               xxspltd rB3, rb4, 0
               lxv rb4, 6208(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 127
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 127
               lxv rA0, 12288(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 127
               lxv rA1, 12304(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 127
               lxv rA2, 12320(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 127
               lxv rA3, 12336(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 127
                lxv rA4, 12352(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 128
               lxv rA5, 12368(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 6224(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 128
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 128
               xxspltd rB1, rb0, 0
               lxv rb0, 6240(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 128
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 128
               xxspltd rB3, rb1, 0
               lxv rb1, 6256(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 128
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 128
               lxv ra0, 12384(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 128
               lxv ra1, 12400(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 128
               lxv ra2, 12416(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 128
               lxv ra3, 12432(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 128
               lxv ra4, 12448(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 128
               lxv ra5, 12464(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 6272(pB)
            #endif
         #endif
         #if KB >= 129
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 129
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 129
               xxspltd rB1, rb3, 0
               lxv rb3, 6288(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 129
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 129
               xxspltd rB3, rb4, 0
               lxv rb4, 6304(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 129
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 129
               lxv rA0, 12480(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 129
               lxv rA1, 12496(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 129
               lxv rA2, 12512(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 129
               lxv rA3, 12528(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 129
                lxv rA4, 12544(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 130
               lxv rA5, 12560(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 6320(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 130
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 130
               xxspltd rB1, rb0, 0
               lxv rb0, 6336(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 130
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 130
               xxspltd rB3, rb1, 0
               lxv rb1, 6352(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 130
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 130
               lxv ra0, 12576(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 130
               lxv ra1, 12592(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 130
               lxv ra2, 12608(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 130
               lxv ra3, 12624(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 130
               lxv ra4, 12640(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 130
               lxv ra5, 12656(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 6368(pB)
            #endif
         #endif
         #if KB >= 131
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 131
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 131
               xxspltd rB1, rb3, 0
               lxv rb3, 6384(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 131
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 131
               xxspltd rB3, rb4, 0
               lxv rb4, 6400(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 131
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 131
               lxv rA0, 12672(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 131
               lxv rA1, 12688(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 131
               lxv rA2, 12704(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 131
               lxv rA3, 12720(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 131
                lxv rA4, 12736(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 132
               lxv rA5, 12752(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 6416(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 132
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 132
               xxspltd rB1, rb0, 0
               lxv rb0, 6432(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 132
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 132
               xxspltd rB3, rb1, 0
               lxv rb1, 6448(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 132
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 132
               lxv ra0, 12768(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 132
               lxv ra1, 12784(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 132
               lxv ra2, 12800(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 132
               lxv ra3, 12816(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 132
               lxv ra4, 12832(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 132
               lxv ra5, 12848(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 6464(pB)
            #endif
         #endif
         #if KB >= 133
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 133
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 133
               xxspltd rB1, rb3, 0
               lxv rb3, 6480(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 133
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 133
               xxspltd rB3, rb4, 0
               lxv rb4, 6496(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 133
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 133
               lxv rA0, 12864(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 133
               lxv rA1, 12880(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 133
               lxv rA2, 12896(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 133
               lxv rA3, 12912(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 133
                lxv rA4, 12928(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 134
               lxv rA5, 12944(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 6512(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 134
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 134
               xxspltd rB1, rb0, 0
               lxv rb0, 6528(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 134
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 134
               xxspltd rB3, rb1, 0
               lxv rb1, 6544(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 134
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 134
               lxv ra0, 12960(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 134
               lxv ra1, 12976(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 134
               lxv ra2, 12992(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 134
               lxv ra3, 13008(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 134
               lxv ra4, 13024(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 134
               lxv ra5, 13040(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 6560(pB)
            #endif
         #endif
         #if KB >= 135
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 135
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 135
               xxspltd rB1, rb3, 0
               lxv rb3, 6576(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 135
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 135
               xxspltd rB3, rb4, 0
               lxv rb4, 6592(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 135
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 135
               lxv rA0, 13056(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 135
               lxv rA1, 13072(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 135
               lxv rA2, 13088(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 135
               lxv rA3, 13104(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 135
                lxv rA4, 13120(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 136
               lxv rA5, 13136(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 6608(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 136
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 136
               xxspltd rB1, rb0, 0
               lxv rb0, 6624(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 136
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 136
               xxspltd rB3, rb1, 0
               lxv rb1, 6640(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 136
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 136
               lxv ra0, 13152(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 136
               lxv ra1, 13168(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 136
               lxv ra2, 13184(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 136
               lxv ra3, 13200(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 136
               lxv ra4, 13216(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 136
               lxv ra5, 13232(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 6656(pB)
            #endif
         #endif
         #if KB >= 137
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 137
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 137
               xxspltd rB1, rb3, 0
               lxv rb3, 6672(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 137
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 137
               xxspltd rB3, rb4, 0
               lxv rb4, 6688(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 137
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 137
               lxv rA0, 13248(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 137
               lxv rA1, 13264(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 137
               lxv rA2, 13280(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 137
               lxv rA3, 13296(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 137
                lxv rA4, 13312(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 138
               lxv rA5, 13328(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 6704(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 138
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 138
               xxspltd rB1, rb0, 0
               lxv rb0, 6720(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 138
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 138
               xxspltd rB3, rb1, 0
               lxv rb1, 6736(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 138
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 138
               lxv ra0, 13344(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 138
               lxv ra1, 13360(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 138
               lxv ra2, 13376(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 138
               lxv ra3, 13392(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 138
               lxv ra4, 13408(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 138
               lxv ra5, 13424(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 6752(pB)
            #endif
         #endif
         #if KB >= 139
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 139
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 139
               xxspltd rB1, rb3, 0
               lxv rb3, 6768(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 139
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 139
               xxspltd rB3, rb4, 0
               lxv rb4, 6784(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 139
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 139
               lxv rA0, 13440(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 139
               lxv rA1, 13456(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 139
               lxv rA2, 13472(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 139
               lxv rA3, 13488(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 139
                lxv rA4, 13504(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 140
               lxv rA5, 13520(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 6800(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 140
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 140
               xxspltd rB1, rb0, 0
               lxv rb0, 6816(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 140
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 140
               xxspltd rB3, rb1, 0
               lxv rb1, 6832(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 140
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 140
               lxv ra0, 13536(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 140
               lxv ra1, 13552(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 140
               lxv ra2, 13568(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 140
               lxv ra3, 13584(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 140
               lxv ra4, 13600(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 140
               lxv ra5, 13616(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 6848(pB)
            #endif
         #endif
         #if KB >= 141
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 141
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 141
               xxspltd rB1, rb3, 0
               lxv rb3, 6864(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 141
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 141
               xxspltd rB3, rb4, 0
               lxv rb4, 6880(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 141
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 141
               lxv rA0, 13632(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 141
               lxv rA1, 13648(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 141
               lxv rA2, 13664(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 141
               lxv rA3, 13680(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 141
                lxv rA4, 13696(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 142
               lxv rA5, 13712(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 6896(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 142
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 142
               xxspltd rB1, rb0, 0
               lxv rb0, 6912(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 142
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 142
               xxspltd rB3, rb1, 0
               lxv rb1, 6928(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 142
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 142
               lxv ra0, 13728(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 142
               lxv ra1, 13744(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 142
               lxv ra2, 13760(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 142
               lxv ra3, 13776(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 142
               lxv ra4, 13792(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 142
               lxv ra5, 13808(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 6944(pB)
            #endif
         #endif
         #if KB >= 143
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 143
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 143
               xxspltd rB1, rb3, 0
               lxv rb3, 6960(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 143
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 143
               xxspltd rB3, rb4, 0
               lxv rb4, 6976(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 143
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 143
               lxv rA0, 13824(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 143
               lxv rA1, 13840(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 143
               lxv rA2, 13856(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 143
               lxv rA3, 13872(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 143
                lxv rA4, 13888(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 144
               lxv rA5, 13904(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 6992(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 144
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 144
               xxspltd rB1, rb0, 0
               lxv rb0, 7008(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 144
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 144
               xxspltd rB3, rb1, 0
               lxv rb1, 7024(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 144
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 144
               lxv ra0, 13920(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 144
               lxv ra1, 13936(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 144
               lxv ra2, 13952(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 144
               lxv ra3, 13968(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 144
               lxv ra4, 13984(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 144
               lxv ra5, 14000(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 7040(pB)
            #endif
         #endif
         #if KB >= 145
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 145
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 145
               xxspltd rB1, rb3, 0
               lxv rb3, 7056(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 145
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 145
               xxspltd rB3, rb4, 0
               lxv rb4, 7072(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 145
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 145
               lxv rA0, 14016(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 145
               lxv rA1, 14032(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 145
               lxv rA2, 14048(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 145
               lxv rA3, 14064(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 145
                lxv rA4, 14080(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 146
               lxv rA5, 14096(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 7088(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 146
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 146
               xxspltd rB1, rb0, 0
               lxv rb0, 7104(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 146
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 146
               xxspltd rB3, rb1, 0
               lxv rb1, 7120(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 146
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 146
               lxv ra0, 14112(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 146
               lxv ra1, 14128(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 146
               lxv ra2, 14144(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 146
               lxv ra3, 14160(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 146
               lxv ra4, 14176(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 146
               lxv ra5, 14192(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 7136(pB)
            #endif
         #endif
         #if KB >= 147
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 147
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 147
               xxspltd rB1, rb3, 0
               lxv rb3, 7152(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 147
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 147
               xxspltd rB3, rb4, 0
               lxv rb4, 7168(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 147
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 147
               lxv rA0, 14208(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 147
               lxv rA1, 14224(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 147
               lxv rA2, 14240(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 147
               lxv rA3, 14256(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 147
                lxv rA4, 14272(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 148
               lxv rA5, 14288(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 7184(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 148
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 148
               xxspltd rB1, rb0, 0
               lxv rb0, 7200(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 148
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 148
               xxspltd rB3, rb1, 0
               lxv rb1, 7216(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 148
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 148
               lxv ra0, 14304(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 148
               lxv ra1, 14320(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 148
               lxv ra2, 14336(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 148
               lxv ra3, 14352(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 148
               lxv ra4, 14368(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 148
               lxv ra5, 14384(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 7232(pB)
            #endif
         #endif
         #if KB >= 149
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 149
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 149
               xxspltd rB1, rb3, 0
               lxv rb3, 7248(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 149
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 149
               xxspltd rB3, rb4, 0
               lxv rb4, 7264(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 149
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 149
               lxv rA0, 14400(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 149
               lxv rA1, 14416(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 149
               lxv rA2, 14432(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 149
               lxv rA3, 14448(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 149
                lxv rA4, 14464(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 150
               lxv rA5, 14480(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 7280(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 150
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 150
               xxspltd rB1, rb0, 0
               lxv rb0, 7296(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 150
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 150
               xxspltd rB3, rb1, 0
               lxv rb1, 7312(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 150
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 150
               lxv ra0, 14496(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 150
               lxv ra1, 14512(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 150
               lxv ra2, 14528(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 150
               lxv ra3, 14544(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 150
               lxv ra4, 14560(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 150
               lxv ra5, 14576(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 7328(pB)
            #endif
         #endif
         #if KB >= 151
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 151
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 151
               xxspltd rB1, rb3, 0
               lxv rb3, 7344(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 151
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 151
               xxspltd rB3, rb4, 0
               lxv rb4, 7360(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 151
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 151
               lxv rA0, 14592(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 151
               lxv rA1, 14608(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 151
               lxv rA2, 14624(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 151
               lxv rA3, 14640(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 151
                lxv rA4, 14656(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 152
               lxv rA5, 14672(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 7376(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 152
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 152
               xxspltd rB1, rb0, 0
               lxv rb0, 7392(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 152
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 152
               xxspltd rB3, rb1, 0
               lxv rb1, 7408(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 152
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 152
               lxv ra0, 14688(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 152
               lxv ra1, 14704(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 152
               lxv ra2, 14720(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 152
               lxv ra3, 14736(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 152
               lxv ra4, 14752(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 152
               lxv ra5, 14768(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 7424(pB)
            #endif
         #endif
         #if KB >= 153
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 153
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 153
               xxspltd rB1, rb3, 0
               lxv rb3, 7440(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 153
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 153
               xxspltd rB3, rb4, 0
               lxv rb4, 7456(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 153
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 153
               lxv rA0, 14784(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 153
               lxv rA1, 14800(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 153
               lxv rA2, 14816(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 153
               lxv rA3, 14832(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 153
                lxv rA4, 14848(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 154
               lxv rA5, 14864(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 7472(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 154
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 154
               xxspltd rB1, rb0, 0
               lxv rb0, 7488(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 154
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 154
               xxspltd rB3, rb1, 0
               lxv rb1, 7504(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 154
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 154
               lxv ra0, 14880(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 154
               lxv ra1, 14896(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 154
               lxv ra2, 14912(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 154
               lxv ra3, 14928(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 154
               lxv ra4, 14944(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 154
               lxv ra5, 14960(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 7520(pB)
            #endif
         #endif
         #if KB >= 155
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 155
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 155
               xxspltd rB1, rb3, 0
               lxv rb3, 7536(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 155
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 155
               xxspltd rB3, rb4, 0
               lxv rb4, 7552(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 155
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 155
               lxv rA0, 14976(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 155
               lxv rA1, 14992(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 155
               lxv rA2, 15008(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 155
               lxv rA3, 15024(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 155
                lxv rA4, 15040(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 156
               lxv rA5, 15056(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 7568(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 156
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 156
               xxspltd rB1, rb0, 0
               lxv rb0, 7584(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 156
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 156
               xxspltd rB3, rb1, 0
               lxv rb1, 7600(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 156
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 156
               lxv ra0, 15072(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 156
               lxv ra1, 15088(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 156
               lxv ra2, 15104(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 156
               lxv ra3, 15120(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 156
               lxv ra4, 15136(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 156
               lxv ra5, 15152(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 7616(pB)
            #endif
         #endif
         #if KB >= 157
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 157
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 157
               xxspltd rB1, rb3, 0
               lxv rb3, 7632(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 157
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 157
               xxspltd rB3, rb4, 0
               lxv rb4, 7648(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 157
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 157
               lxv rA0, 15168(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 157
               lxv rA1, 15184(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 157
               lxv rA2, 15200(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 157
               lxv rA3, 15216(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 157
                lxv rA4, 15232(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 158
               lxv rA5, 15248(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 7664(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 158
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 158
               xxspltd rB1, rb0, 0
               lxv rb0, 7680(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 158
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 158
               xxspltd rB3, rb1, 0
               lxv rb1, 7696(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 158
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 158
               lxv ra0, 15264(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 158
               lxv ra1, 15280(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 158
               lxv ra2, 15296(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 158
               lxv ra3, 15312(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 158
               lxv ra4, 15328(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 158
               lxv ra5, 15344(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 7712(pB)
            #endif
         #endif
         #if KB >= 159
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 159
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 159
               xxspltd rB1, rb3, 0
               lxv rb3, 7728(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 159
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 159
               xxspltd rB3, rb4, 0
               lxv rb4, 7744(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 159
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 159
               lxv rA0, 15360(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 159
               lxv rA1, 15376(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 159
               lxv rA2, 15392(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 159
               lxv rA3, 15408(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 159
                lxv rA4, 15424(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 160
               lxv rA5, 15440(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 7760(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 160
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 160
               xxspltd rB1, rb0, 0
               lxv rb0, 7776(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 160
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 160
               xxspltd rB3, rb1, 0
               lxv rb1, 7792(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 160
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 160
               lxv ra0, 15456(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 160
               lxv ra1, 15472(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 160
               lxv ra2, 15488(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 160
               lxv ra3, 15504(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 160
               lxv ra4, 15520(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 160
               lxv ra5, 15536(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 7808(pB)
            #endif
         #endif
         #if KB >= 161
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 161
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 161
               xxspltd rB1, rb3, 0
               lxv rb3, 7824(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 161
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 161
               xxspltd rB3, rb4, 0
               lxv rb4, 7840(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 161
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 161
               lxv rA0, 15552(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 161
               lxv rA1, 15568(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 161
               lxv rA2, 15584(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 161
               lxv rA3, 15600(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 161
                lxv rA4, 15616(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 162
               lxv rA5, 15632(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 7856(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 162
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 162
               xxspltd rB1, rb0, 0
               lxv rb0, 7872(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 162
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 162
               xxspltd rB3, rb1, 0
               lxv rb1, 7888(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 162
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 162
               lxv ra0, 15648(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 162
               lxv ra1, 15664(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 162
               lxv ra2, 15680(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 162
               lxv ra3, 15696(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 162
               lxv ra4, 15712(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 162
               lxv ra5, 15728(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 7904(pB)
            #endif
         #endif
         #if KB >= 163
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 163
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 163
               xxspltd rB1, rb3, 0
               lxv rb3, 7920(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 163
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 163
               xxspltd rB3, rb4, 0
               lxv rb4, 7936(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 163
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 163
               lxv rA0, 15744(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 163
               lxv rA1, 15760(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 163
               lxv rA2, 15776(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 163
               lxv rA3, 15792(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 163
                lxv rA4, 15808(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 164
               lxv rA5, 15824(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 7952(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 164
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 164
               xxspltd rB1, rb0, 0
               lxv rb0, 7968(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 164
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 164
               xxspltd rB3, rb1, 0
               lxv rb1, 7984(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 164
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 164
               lxv ra0, 15840(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 164
               lxv ra1, 15856(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 164
               lxv ra2, 15872(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 164
               lxv ra3, 15888(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 164
               lxv ra4, 15904(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 164
               lxv ra5, 15920(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 8000(pB)
            #endif
         #endif
         #if KB >= 165
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 165
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 165
               xxspltd rB1, rb3, 0
               lxv rb3, 8016(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 165
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 165
               xxspltd rB3, rb4, 0
               lxv rb4, 8032(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 165
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 165
               lxv rA0, 15936(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 165
               lxv rA1, 15952(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 165
               lxv rA2, 15968(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 165
               lxv rA3, 15984(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 165
                lxv rA4, 16000(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 166
               lxv rA5, 16016(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 8048(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 166
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 166
               xxspltd rB1, rb0, 0
               lxv rb0, 8064(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 166
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 166
               xxspltd rB3, rb1, 0
               lxv rb1, 8080(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 166
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 166
               lxv ra0, 16032(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 166
               lxv ra1, 16048(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 166
               lxv ra2, 16064(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 166
               lxv ra3, 16080(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 166
               lxv ra4, 16096(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 166
               lxv ra5, 16112(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 8096(pB)
            #endif
         #endif
         #if KB >= 167
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 167
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 167
               xxspltd rB1, rb3, 0
               lxv rb3, 8112(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 167
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 167
               xxspltd rB3, rb4, 0
               lxv rb4, 8128(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 167
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 167
               lxv rA0, 16128(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 167
               lxv rA1, 16144(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 167
               lxv rA2, 16160(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 167
               lxv rA3, 16176(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 167
                lxv rA4, 16192(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 168
               lxv rA5, 16208(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 8144(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 168
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 168
               xxspltd rB1, rb0, 0
               lxv rb0, 8160(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 168
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 168
               xxspltd rB3, rb1, 0
               lxv rb1, 8176(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 168
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 168
               lxv ra0, 16224(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 168
               lxv ra1, 16240(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 168
               lxv ra2, 16256(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 168
               lxv ra3, 16272(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 168
               lxv ra4, 16288(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 168
               lxv ra5, 16304(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 8192(pB)
            #endif
         #endif
         #if KB >= 169
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 169
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 169
               xxspltd rB1, rb3, 0
               lxv rb3, 8208(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 169
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 169
               xxspltd rB3, rb4, 0
               lxv rb4, 8224(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 169
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 169
               lxv rA0, 16320(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 169
               lxv rA1, 16336(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 169
               lxv rA2, 16352(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 169
               lxv rA3, 16368(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 169
                lxv rA4, 16384(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 170
               lxv rA5, 16400(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 8240(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 170
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 170
               xxspltd rB1, rb0, 0
               lxv rb0, 8256(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 170
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 170
               xxspltd rB3, rb1, 0
               lxv rb1, 8272(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 170
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 170
               lxv ra0, 16416(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 170
               lxv ra1, 16432(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 170
               lxv ra2, 16448(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 170
               lxv ra3, 16464(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 170
               lxv ra4, 16480(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 170
               lxv ra5, 16496(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 8288(pB)
            #endif
         #endif
         #if KB >= 171
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 171
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 171
               xxspltd rB1, rb3, 0
               lxv rb3, 8304(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 171
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 171
               xxspltd rB3, rb4, 0
               lxv rb4, 8320(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 171
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 171
               lxv rA0, 16512(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 171
               lxv rA1, 16528(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 171
               lxv rA2, 16544(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 171
               lxv rA3, 16560(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 171
                lxv rA4, 16576(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 172
               lxv rA5, 16592(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 8336(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 172
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 172
               xxspltd rB1, rb0, 0
               lxv rb0, 8352(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 172
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 172
               xxspltd rB3, rb1, 0
               lxv rb1, 8368(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 172
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 172
               lxv ra0, 16608(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 172
               lxv ra1, 16624(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 172
               lxv ra2, 16640(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 172
               lxv ra3, 16656(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 172
               lxv ra4, 16672(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 172
               lxv ra5, 16688(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 8384(pB)
            #endif
         #endif
         #if KB >= 173
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 173
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 173
               xxspltd rB1, rb3, 0
               lxv rb3, 8400(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 173
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 173
               xxspltd rB3, rb4, 0
               lxv rb4, 8416(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 173
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 173
               lxv rA0, 16704(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 173
               lxv rA1, 16720(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 173
               lxv rA2, 16736(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 173
               lxv rA3, 16752(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 173
                lxv rA4, 16768(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 174
               lxv rA5, 16784(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 8432(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 174
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 174
               xxspltd rB1, rb0, 0
               lxv rb0, 8448(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 174
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 174
               xxspltd rB3, rb1, 0
               lxv rb1, 8464(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 174
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 174
               lxv ra0, 16800(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 174
               lxv ra1, 16816(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 174
               lxv ra2, 16832(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 174
               lxv ra3, 16848(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 174
               lxv ra4, 16864(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 174
               lxv ra5, 16880(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 8480(pB)
            #endif
         #endif
         #if KB >= 175
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 175
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 175
               xxspltd rB1, rb3, 0
               lxv rb3, 8496(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 175
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 175
               xxspltd rB3, rb4, 0
               lxv rb4, 8512(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 175
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 175
               lxv rA0, 16896(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 175
               lxv rA1, 16912(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 175
               lxv rA2, 16928(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 175
               lxv rA3, 16944(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 175
                lxv rA4, 16960(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 176
               lxv rA5, 16976(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 8528(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 176
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 176
               xxspltd rB1, rb0, 0
               lxv rb0, 8544(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 176
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 176
               xxspltd rB3, rb1, 0
               lxv rb1, 8560(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 176
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 176
               lxv ra0, 16992(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 176
               lxv ra1, 17008(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 176
               lxv ra2, 17024(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 176
               lxv ra3, 17040(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 176
               lxv ra4, 17056(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 176
               lxv ra5, 17072(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 8576(pB)
            #endif
         #endif
         #if KB >= 177
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 177
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 177
               xxspltd rB1, rb3, 0
               lxv rb3, 8592(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 177
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 177
               xxspltd rB3, rb4, 0
               lxv rb4, 8608(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 177
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 177
               lxv rA0, 17088(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 177
               lxv rA1, 17104(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 177
               lxv rA2, 17120(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 177
               lxv rA3, 17136(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 177
                lxv rA4, 17152(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 178
               lxv rA5, 17168(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 8624(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 178
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 178
               xxspltd rB1, rb0, 0
               lxv rb0, 8640(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 178
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 178
               xxspltd rB3, rb1, 0
               lxv rb1, 8656(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 178
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 178
               lxv ra0, 17184(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 178
               lxv ra1, 17200(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 178
               lxv ra2, 17216(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 178
               lxv ra3, 17232(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 178
               lxv ra4, 17248(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 178
               lxv ra5, 17264(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 8672(pB)
            #endif
         #endif
         #if KB >= 179
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 179
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 179
               xxspltd rB1, rb3, 0
               lxv rb3, 8688(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 179
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 179
               xxspltd rB3, rb4, 0
               lxv rb4, 8704(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 179
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 179
               lxv rA0, 17280(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 179
               lxv rA1, 17296(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 179
               lxv rA2, 17312(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 179
               lxv rA3, 17328(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 179
                lxv rA4, 17344(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 180
               lxv rA5, 17360(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 8720(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 180
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 180
               xxspltd rB1, rb0, 0
               lxv rb0, 8736(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 180
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 180
               xxspltd rB3, rb1, 0
               lxv rb1, 8752(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 180
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 180
               lxv ra0, 17376(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 180
               lxv ra1, 17392(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 180
               lxv ra2, 17408(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 180
               lxv ra3, 17424(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 180
               lxv ra4, 17440(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 180
               lxv ra5, 17456(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 8768(pB)
            #endif
         #endif
         #if KB >= 181
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 181
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 181
               xxspltd rB1, rb3, 0
               lxv rb3, 8784(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 181
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 181
               xxspltd rB3, rb4, 0
               lxv rb4, 8800(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 181
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 181
               lxv rA0, 17472(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 181
               lxv rA1, 17488(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 181
               lxv rA2, 17504(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 181
               lxv rA3, 17520(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 181
                lxv rA4, 17536(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 182
               lxv rA5, 17552(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 8816(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 182
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 182
               xxspltd rB1, rb0, 0
               lxv rb0, 8832(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 182
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 182
               xxspltd rB3, rb1, 0
               lxv rb1, 8848(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 182
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 182
               lxv ra0, 17568(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 182
               lxv ra1, 17584(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 182
               lxv ra2, 17600(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 182
               lxv ra3, 17616(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 182
               lxv ra4, 17632(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 182
               lxv ra5, 17648(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 8864(pB)
            #endif
         #endif
         #if KB >= 183
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 183
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 183
               xxspltd rB1, rb3, 0
               lxv rb3, 8880(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 183
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 183
               xxspltd rB3, rb4, 0
               lxv rb4, 8896(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 183
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 183
               lxv rA0, 17664(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 183
               lxv rA1, 17680(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 183
               lxv rA2, 17696(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 183
               lxv rA3, 17712(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 183
                lxv rA4, 17728(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 184
               lxv rA5, 17744(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 8912(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 184
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 184
               xxspltd rB1, rb0, 0
               lxv rb0, 8928(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 184
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 184
               xxspltd rB3, rb1, 0
               lxv rb1, 8944(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 184
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 184
               lxv ra0, 17760(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 184
               lxv ra1, 17776(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 184
               lxv ra2, 17792(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 184
               lxv ra3, 17808(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 184
               lxv ra4, 17824(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 184
               lxv ra5, 17840(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 8960(pB)
            #endif
         #endif
         #if KB >= 185
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 185
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 185
               xxspltd rB1, rb3, 0
               lxv rb3, 8976(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 185
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 185
               xxspltd rB3, rb4, 0
               lxv rb4, 8992(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 185
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 185
               lxv rA0, 17856(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 185
               lxv rA1, 17872(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 185
               lxv rA2, 17888(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 185
               lxv rA3, 17904(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 185
                lxv rA4, 17920(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 186
               lxv rA5, 17936(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 9008(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 186
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 186
               xxspltd rB1, rb0, 0
               lxv rb0, 9024(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 186
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 186
               xxspltd rB3, rb1, 0
               lxv rb1, 9040(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 186
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 186
               lxv ra0, 17952(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 186
               lxv ra1, 17968(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 186
               lxv ra2, 17984(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 186
               lxv ra3, 18000(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 186
               lxv ra4, 18016(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 186
               lxv ra5, 18032(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 9056(pB)
            #endif
         #endif
         #if KB >= 187
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 187
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 187
               xxspltd rB1, rb3, 0
               lxv rb3, 9072(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 187
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 187
               xxspltd rB3, rb4, 0
               lxv rb4, 9088(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 187
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 187
               lxv rA0, 18048(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 187
               lxv rA1, 18064(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 187
               lxv rA2, 18080(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 187
               lxv rA3, 18096(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 187
                lxv rA4, 18112(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 188
               lxv rA5, 18128(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 9104(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 188
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 188
               xxspltd rB1, rb0, 0
               lxv rb0, 9120(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 188
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 188
               xxspltd rB3, rb1, 0
               lxv rb1, 9136(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 188
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 188
               lxv ra0, 18144(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 188
               lxv ra1, 18160(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 188
               lxv ra2, 18176(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 188
               lxv ra3, 18192(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 188
               lxv ra4, 18208(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 188
               lxv ra5, 18224(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 9152(pB)
            #endif
         #endif
         #if KB >= 189
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 189
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 189
               xxspltd rB1, rb3, 0
               lxv rb3, 9168(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 189
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 189
               xxspltd rB3, rb4, 0
               lxv rb4, 9184(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 189
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 189
               lxv rA0, 18240(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 189
               lxv rA1, 18256(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 189
               lxv rA2, 18272(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 189
               lxv rA3, 18288(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 189
                lxv rA4, 18304(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 190
               lxv rA5, 18320(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 9200(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 190
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 190
               xxspltd rB1, rb0, 0
               lxv rb0, 9216(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 190
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 190
               xxspltd rB3, rb1, 0
               lxv rb1, 9232(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 190
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 190
               lxv ra0, 18336(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 190
               lxv ra1, 18352(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 190
               lxv ra2, 18368(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 190
               lxv ra3, 18384(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 190
               lxv ra4, 18400(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 190
               lxv ra5, 18416(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 9248(pB)
            #endif
         #endif
         #if KB >= 191
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 191
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 191
               xxspltd rB1, rb3, 0
               lxv rb3, 9264(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 191
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 191
               xxspltd rB3, rb4, 0
               lxv rb4, 9280(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 191
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 191
               lxv rA0, 18432(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 191
               lxv rA1, 18448(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 191
               lxv rA2, 18464(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 191
               lxv rA3, 18480(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 191
                lxv rA4, 18496(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 192
               lxv rA5, 18512(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 9296(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 192
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 192
               xxspltd rB1, rb0, 0
               lxv rb0, 9312(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 192
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 192
               xxspltd rB3, rb1, 0
               lxv rb1, 9328(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 192
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 192
               lxv ra0, 18528(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 192
               lxv ra1, 18544(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 192
               lxv ra2, 18560(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 192
               lxv ra3, 18576(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 192
               lxv ra4, 18592(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 192
               lxv ra5, 18608(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 9344(pB)
            #endif
         #endif
         #if KB >= 193
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 193
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 193
               xxspltd rB1, rb3, 0
               lxv rb3, 9360(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 193
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 193
               xxspltd rB3, rb4, 0
               lxv rb4, 9376(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 193
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 193
               lxv rA0, 18624(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 193
               lxv rA1, 18640(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 193
               lxv rA2, 18656(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 193
               lxv rA3, 18672(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 193
                lxv rA4, 18688(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 194
               lxv rA5, 18704(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 9392(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 194
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 194
               xxspltd rB1, rb0, 0
               lxv rb0, 9408(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 194
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 194
               xxspltd rB3, rb1, 0
               lxv rb1, 9424(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 194
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 194
               lxv ra0, 18720(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 194
               lxv ra1, 18736(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 194
               lxv ra2, 18752(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 194
               lxv ra3, 18768(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 194
               lxv ra4, 18784(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 194
               lxv ra5, 18800(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 9440(pB)
            #endif
         #endif
         #if KB >= 195
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 195
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 195
               xxspltd rB1, rb3, 0
               lxv rb3, 9456(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 195
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 195
               xxspltd rB3, rb4, 0
               lxv rb4, 9472(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 195
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 195
               lxv rA0, 18816(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 195
               lxv rA1, 18832(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 195
               lxv rA2, 18848(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 195
               lxv rA3, 18864(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 195
                lxv rA4, 18880(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 196
               lxv rA5, 18896(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 9488(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 196
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 196
               xxspltd rB1, rb0, 0
               lxv rb0, 9504(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 196
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 196
               xxspltd rB3, rb1, 0
               lxv rb1, 9520(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 196
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 196
               lxv ra0, 18912(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 196
               lxv ra1, 18928(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 196
               lxv ra2, 18944(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 196
               lxv ra3, 18960(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 196
               lxv ra4, 18976(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 196
               lxv ra5, 18992(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 9536(pB)
            #endif
         #endif
         #if KB >= 197
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 197
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 197
               xxspltd rB1, rb3, 0
               lxv rb3, 9552(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 197
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 197
               xxspltd rB3, rb4, 0
               lxv rb4, 9568(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 197
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 197
               lxv rA0, 19008(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 197
               lxv rA1, 19024(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 197
               lxv rA2, 19040(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 197
               lxv rA3, 19056(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 197
                lxv rA4, 19072(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 198
               lxv rA5, 19088(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 9584(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 198
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 198
               xxspltd rB1, rb0, 0
               lxv rb0, 9600(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 198
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 198
               xxspltd rB3, rb1, 0
               lxv rb1, 9616(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 198
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 198
               lxv ra0, 19104(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 198
               lxv ra1, 19120(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 198
               lxv ra2, 19136(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 198
               lxv ra3, 19152(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 198
               lxv ra4, 19168(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 198
               lxv ra5, 19184(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 9632(pB)
            #endif
         #endif
         #if KB >= 199
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 199
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 199
               xxspltd rB1, rb3, 0
               lxv rb3, 9648(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 199
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 199
               xxspltd rB3, rb4, 0
               lxv rb4, 9664(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 199
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 199
               lxv rA0, 19200(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 199
               lxv rA1, 19216(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 199
               lxv rA2, 19232(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 199
               lxv rA3, 19248(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 199
                lxv rA4, 19264(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 200
               lxv rA5, 19280(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 9680(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 200
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 200
               xxspltd rB1, rb0, 0
               lxv rb0, 9696(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 200
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 200
               xxspltd rB3, rb1, 0
               lxv rb1, 9712(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 200
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 200
               lxv ra0, 19296(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 200
               lxv ra1, 19312(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 200
               lxv ra2, 19328(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 200
               lxv ra3, 19344(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 200
               lxv ra4, 19360(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 200
               lxv ra5, 19376(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 9728(pB)
            #endif
         #endif
         #if KB >= 201
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 201
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 201
               xxspltd rB1, rb3, 0
               lxv rb3, 9744(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 201
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 201
               xxspltd rB3, rb4, 0
               lxv rb4, 9760(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 201
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 201
               lxv rA0, 19392(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 201
               lxv rA1, 19408(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 201
               lxv rA2, 19424(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 201
               lxv rA3, 19440(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 201
                lxv rA4, 19456(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 202
               lxv rA5, 19472(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 9776(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 202
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 202
               xxspltd rB1, rb0, 0
               lxv rb0, 9792(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 202
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 202
               xxspltd rB3, rb1, 0
               lxv rb1, 9808(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 202
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 202
               lxv ra0, 19488(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 202
               lxv ra1, 19504(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 202
               lxv ra2, 19520(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 202
               lxv ra3, 19536(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 202
               lxv ra4, 19552(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 202
               lxv ra5, 19568(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 9824(pB)
            #endif
         #endif
         #if KB >= 203
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 203
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 203
               xxspltd rB1, rb3, 0
               lxv rb3, 9840(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 203
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 203
               xxspltd rB3, rb4, 0
               lxv rb4, 9856(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 203
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 203
               lxv rA0, 19584(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 203
               lxv rA1, 19600(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 203
               lxv rA2, 19616(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 203
               lxv rA3, 19632(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 203
                lxv rA4, 19648(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 204
               lxv rA5, 19664(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 9872(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 204
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 204
               xxspltd rB1, rb0, 0
               lxv rb0, 9888(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 204
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 204
               xxspltd rB3, rb1, 0
               lxv rb1, 9904(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 204
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 204
               lxv ra0, 19680(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 204
               lxv ra1, 19696(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 204
               lxv ra2, 19712(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 204
               lxv ra3, 19728(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 204
               lxv ra4, 19744(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 204
               lxv ra5, 19760(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 9920(pB)
            #endif
         #endif
         #if KB >= 205
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 205
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 205
               xxspltd rB1, rb3, 0
               lxv rb3, 9936(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 205
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 205
               xxspltd rB3, rb4, 0
               lxv rb4, 9952(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 205
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 205
               lxv rA0, 19776(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 205
               lxv rA1, 19792(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 205
               lxv rA2, 19808(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 205
               lxv rA3, 19824(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 205
                lxv rA4, 19840(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 206
               lxv rA5, 19856(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 9968(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 206
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 206
               xxspltd rB1, rb0, 0
               lxv rb0, 9984(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 206
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 206
               xxspltd rB3, rb1, 0
               lxv rb1, 10000(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 206
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 206
               lxv ra0, 19872(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 206
               lxv ra1, 19888(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 206
               lxv ra2, 19904(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 206
               lxv ra3, 19920(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 206
               lxv ra4, 19936(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 206
               lxv ra5, 19952(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 10016(pB)
            #endif
         #endif
         #if KB >= 207
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 207
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 207
               xxspltd rB1, rb3, 0
               lxv rb3, 10032(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 207
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 207
               xxspltd rB3, rb4, 0
               lxv rb4, 10048(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 207
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 207
               lxv rA0, 19968(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 207
               lxv rA1, 19984(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 207
               lxv rA2, 20000(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 207
               lxv rA3, 20016(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 207
                lxv rA4, 20032(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 208
               lxv rA5, 20048(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 10064(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 208
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 208
               xxspltd rB1, rb0, 0
               lxv rb0, 10080(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 208
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 208
               xxspltd rB3, rb1, 0
               lxv rb1, 10096(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 208
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 208
               lxv ra0, 20064(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 208
               lxv ra1, 20080(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 208
               lxv ra2, 20096(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 208
               lxv ra3, 20112(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 208
               lxv ra4, 20128(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 208
               lxv ra5, 20144(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 10112(pB)
            #endif
         #endif
         #if KB >= 209
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 209
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 209
               xxspltd rB1, rb3, 0
               lxv rb3, 10128(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 209
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 209
               xxspltd rB3, rb4, 0
               lxv rb4, 10144(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 209
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 209
               lxv rA0, 20160(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 209
               lxv rA1, 20176(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 209
               lxv rA2, 20192(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 209
               lxv rA3, 20208(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 209
                lxv rA4, 20224(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 210
               lxv rA5, 20240(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 10160(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 210
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 210
               xxspltd rB1, rb0, 0
               lxv rb0, 10176(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 210
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 210
               xxspltd rB3, rb1, 0
               lxv rb1, 10192(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 210
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 210
               lxv ra0, 20256(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 210
               lxv ra1, 20272(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 210
               lxv ra2, 20288(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 210
               lxv ra3, 20304(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 210
               lxv ra4, 20320(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 210
               lxv ra5, 20336(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 10208(pB)
            #endif
         #endif
         #if KB >= 211
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 211
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 211
               xxspltd rB1, rb3, 0
               lxv rb3, 10224(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 211
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 211
               xxspltd rB3, rb4, 0
               lxv rb4, 10240(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 211
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 211
               lxv rA0, 20352(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 211
               lxv rA1, 20368(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 211
               lxv rA2, 20384(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 211
               lxv rA3, 20400(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 211
                lxv rA4, 20416(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 212
               lxv rA5, 20432(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 10256(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 212
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 212
               xxspltd rB1, rb0, 0
               lxv rb0, 10272(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 212
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 212
               xxspltd rB3, rb1, 0
               lxv rb1, 10288(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 212
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 212
               lxv ra0, 20448(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 212
               lxv ra1, 20464(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 212
               lxv ra2, 20480(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 212
               lxv ra3, 20496(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 212
               lxv ra4, 20512(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 212
               lxv ra5, 20528(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 10304(pB)
            #endif
         #endif
         #if KB >= 213
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 213
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 213
               xxspltd rB1, rb3, 0
               lxv rb3, 10320(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 213
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 213
               xxspltd rB3, rb4, 0
               lxv rb4, 10336(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 213
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 213
               lxv rA0, 20544(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 213
               lxv rA1, 20560(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 213
               lxv rA2, 20576(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 213
               lxv rA3, 20592(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 213
                lxv rA4, 20608(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 214
               lxv rA5, 20624(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 10352(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 214
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 214
               xxspltd rB1, rb0, 0
               lxv rb0, 10368(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 214
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 214
               xxspltd rB3, rb1, 0
               lxv rb1, 10384(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 214
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 214
               lxv ra0, 20640(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 214
               lxv ra1, 20656(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 214
               lxv ra2, 20672(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 214
               lxv ra3, 20688(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 214
               lxv ra4, 20704(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 214
               lxv ra5, 20720(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 10400(pB)
            #endif
         #endif
         #if KB >= 215
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 215
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 215
               xxspltd rB1, rb3, 0
               lxv rb3, 10416(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 215
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 215
               xxspltd rB3, rb4, 0
               lxv rb4, 10432(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 215
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 215
               lxv rA0, 20736(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 215
               lxv rA1, 20752(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 215
               lxv rA2, 20768(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 215
               lxv rA3, 20784(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 215
                lxv rA4, 20800(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 216
               lxv rA5, 20816(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 10448(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 216
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 216
               xxspltd rB1, rb0, 0
               lxv rb0, 10464(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 216
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 216
               xxspltd rB3, rb1, 0
               lxv rb1, 10480(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 216
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 216
               lxv ra0, 20832(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 216
               lxv ra1, 20848(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 216
               lxv ra2, 20864(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 216
               lxv ra3, 20880(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 216
               lxv ra4, 20896(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 216
               lxv ra5, 20912(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 10496(pB)
            #endif
         #endif
         #if KB >= 217
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 217
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 217
               xxspltd rB1, rb3, 0
               lxv rb3, 10512(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 217
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 217
               xxspltd rB3, rb4, 0
               lxv rb4, 10528(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 217
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 217
               lxv rA0, 20928(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 217
               lxv rA1, 20944(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 217
               lxv rA2, 20960(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 217
               lxv rA3, 20976(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 217
                lxv rA4, 20992(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 218
               lxv rA5, 21008(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 10544(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 218
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 218
               xxspltd rB1, rb0, 0
               lxv rb0, 10560(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 218
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 218
               xxspltd rB3, rb1, 0
               lxv rb1, 10576(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 218
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 218
               lxv ra0, 21024(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 218
               lxv ra1, 21040(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 218
               lxv ra2, 21056(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 218
               lxv ra3, 21072(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 218
               lxv ra4, 21088(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 218
               lxv ra5, 21104(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 10592(pB)
            #endif
         #endif
         #if KB >= 219
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 219
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 219
               xxspltd rB1, rb3, 0
               lxv rb3, 10608(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 219
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 219
               xxspltd rB3, rb4, 0
               lxv rb4, 10624(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 219
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 219
               lxv rA0, 21120(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 219
               lxv rA1, 21136(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 219
               lxv rA2, 21152(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 219
               lxv rA3, 21168(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 219
                lxv rA4, 21184(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 220
               lxv rA5, 21200(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 10640(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 220
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 220
               xxspltd rB1, rb0, 0
               lxv rb0, 10656(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 220
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 220
               xxspltd rB3, rb1, 0
               lxv rb1, 10672(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 220
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 220
               lxv ra0, 21216(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 220
               lxv ra1, 21232(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 220
               lxv ra2, 21248(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 220
               lxv ra3, 21264(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 220
               lxv ra4, 21280(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 220
               lxv ra5, 21296(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 10688(pB)
            #endif
         #endif
         #if KB >= 221
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 221
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 221
               xxspltd rB1, rb3, 0
               lxv rb3, 10704(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 221
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 221
               xxspltd rB3, rb4, 0
               lxv rb4, 10720(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 221
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 221
               lxv rA0, 21312(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 221
               lxv rA1, 21328(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 221
               lxv rA2, 21344(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 221
               lxv rA3, 21360(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 221
                lxv rA4, 21376(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 222
               lxv rA5, 21392(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 10736(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 222
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 222
               xxspltd rB1, rb0, 0
               lxv rb0, 10752(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 222
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 222
               xxspltd rB3, rb1, 0
               lxv rb1, 10768(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 222
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 222
               lxv ra0, 21408(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 222
               lxv ra1, 21424(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 222
               lxv ra2, 21440(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 222
               lxv ra3, 21456(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 222
               lxv ra4, 21472(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 222
               lxv ra5, 21488(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 10784(pB)
            #endif
         #endif
         #if KB >= 223
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 223
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 223
               xxspltd rB1, rb3, 0
               lxv rb3, 10800(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 223
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 223
               xxspltd rB3, rb4, 0
               lxv rb4, 10816(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 223
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 223
               lxv rA0, 21504(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 223
               lxv rA1, 21520(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 223
               lxv rA2, 21536(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 223
               lxv rA3, 21552(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 223
                lxv rA4, 21568(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 224
               lxv rA5, 21584(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 10832(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 224
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 224
               xxspltd rB1, rb0, 0
               lxv rb0, 10848(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 224
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 224
               xxspltd rB3, rb1, 0
               lxv rb1, 10864(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 224
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 224
               lxv ra0, 21600(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 224
               lxv ra1, 21616(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 224
               lxv ra2, 21632(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 224
               lxv ra3, 21648(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 224
               lxv ra4, 21664(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 224
               lxv ra5, 21680(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 10880(pB)
            #endif
         #endif
         #if KB >= 225
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 225
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 225
               xxspltd rB1, rb3, 0
               lxv rb3, 10896(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 225
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 225
               xxspltd rB3, rb4, 0
               lxv rb4, 10912(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 225
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 225
               lxv rA0, 21696(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 225
               lxv rA1, 21712(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 225
               lxv rA2, 21728(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 225
               lxv rA3, 21744(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 225
                lxv rA4, 21760(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 226
               lxv rA5, 21776(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 10928(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 226
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 226
               xxspltd rB1, rb0, 0
               lxv rb0, 10944(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 226
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 226
               xxspltd rB3, rb1, 0
               lxv rb1, 10960(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 226
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 226
               lxv ra0, 21792(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 226
               lxv ra1, 21808(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 226
               lxv ra2, 21824(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 226
               lxv ra3, 21840(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 226
               lxv ra4, 21856(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 226
               lxv ra5, 21872(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 10976(pB)
            #endif
         #endif
         #if KB >= 227
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 227
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 227
               xxspltd rB1, rb3, 0
               lxv rb3, 10992(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 227
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 227
               xxspltd rB3, rb4, 0
               lxv rb4, 11008(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 227
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 227
               lxv rA0, 21888(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 227
               lxv rA1, 21904(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 227
               lxv rA2, 21920(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 227
               lxv rA3, 21936(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 227
                lxv rA4, 21952(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 228
               lxv rA5, 21968(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 11024(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 228
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 228
               xxspltd rB1, rb0, 0
               lxv rb0, 11040(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 228
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 228
               xxspltd rB3, rb1, 0
               lxv rb1, 11056(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 228
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 228
               lxv ra0, 21984(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 228
               lxv ra1, 22000(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 228
               lxv ra2, 22016(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 228
               lxv ra3, 22032(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 228
               lxv ra4, 22048(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 228
               lxv ra5, 22064(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 11072(pB)
            #endif
         #endif
         #if KB >= 229
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 229
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 229
               xxspltd rB1, rb3, 0
               lxv rb3, 11088(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 229
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 229
               xxspltd rB3, rb4, 0
               lxv rb4, 11104(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 229
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 229
               lxv rA0, 22080(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 229
               lxv rA1, 22096(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 229
               lxv rA2, 22112(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 229
               lxv rA3, 22128(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 229
                lxv rA4, 22144(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 230
               lxv rA5, 22160(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 11120(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 230
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 230
               xxspltd rB1, rb0, 0
               lxv rb0, 11136(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 230
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 230
               xxspltd rB3, rb1, 0
               lxv rb1, 11152(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 230
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 230
               lxv ra0, 22176(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 230
               lxv ra1, 22192(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 230
               lxv ra2, 22208(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 230
               lxv ra3, 22224(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 230
               lxv ra4, 22240(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 230
               lxv ra5, 22256(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 11168(pB)
            #endif
         #endif
         #if KB >= 231
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 231
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 231
               xxspltd rB1, rb3, 0
               lxv rb3, 11184(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 231
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 231
               xxspltd rB3, rb4, 0
               lxv rb4, 11200(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 231
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 231
               lxv rA0, 22272(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 231
               lxv rA1, 22288(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 231
               lxv rA2, 22304(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 231
               lxv rA3, 22320(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 231
                lxv rA4, 22336(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 232
               lxv rA5, 22352(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 11216(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 232
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 232
               xxspltd rB1, rb0, 0
               lxv rb0, 11232(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 232
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 232
               xxspltd rB3, rb1, 0
               lxv rb1, 11248(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 232
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 232
               lxv ra0, 22368(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 232
               lxv ra1, 22384(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 232
               lxv ra2, 22400(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 232
               lxv ra3, 22416(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 232
               lxv ra4, 22432(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 232
               lxv ra5, 22448(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 11264(pB)
            #endif
         #endif
         #if KB >= 233
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 233
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 233
               xxspltd rB1, rb3, 0
               lxv rb3, 11280(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 233
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 233
               xxspltd rB3, rb4, 0
               lxv rb4, 11296(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 233
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 233
               lxv rA0, 22464(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 233
               lxv rA1, 22480(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 233
               lxv rA2, 22496(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 233
               lxv rA3, 22512(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 233
                lxv rA4, 22528(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 234
               lxv rA5, 22544(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 11312(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 234
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 234
               xxspltd rB1, rb0, 0
               lxv rb0, 11328(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 234
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 234
               xxspltd rB3, rb1, 0
               lxv rb1, 11344(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 234
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 234
               lxv ra0, 22560(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 234
               lxv ra1, 22576(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 234
               lxv ra2, 22592(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 234
               lxv ra3, 22608(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 234
               lxv ra4, 22624(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 234
               lxv ra5, 22640(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 11360(pB)
            #endif
         #endif
         #if KB >= 235
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 235
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 235
               xxspltd rB1, rb3, 0
               lxv rb3, 11376(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 235
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 235
               xxspltd rB3, rb4, 0
               lxv rb4, 11392(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 235
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 235
               lxv rA0, 22656(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 235
               lxv rA1, 22672(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 235
               lxv rA2, 22688(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 235
               lxv rA3, 22704(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 235
                lxv rA4, 22720(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 236
               lxv rA5, 22736(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 11408(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 236
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 236
               xxspltd rB1, rb0, 0
               lxv rb0, 11424(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 236
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 236
               xxspltd rB3, rb1, 0
               lxv rb1, 11440(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 236
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 236
               lxv ra0, 22752(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 236
               lxv ra1, 22768(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 236
               lxv ra2, 22784(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 236
               lxv ra3, 22800(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 236
               lxv ra4, 22816(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 236
               lxv ra5, 22832(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 11456(pB)
            #endif
         #endif
         #if KB >= 237
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 237
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 237
               xxspltd rB1, rb3, 0
               lxv rb3, 11472(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 237
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 237
               xxspltd rB3, rb4, 0
               lxv rb4, 11488(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 237
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 237
               lxv rA0, 22848(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 237
               lxv rA1, 22864(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 237
               lxv rA2, 22880(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 237
               lxv rA3, 22896(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 237
                lxv rA4, 22912(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 238
               lxv rA5, 22928(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 11504(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 238
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 238
               xxspltd rB1, rb0, 0
               lxv rb0, 11520(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 238
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 238
               xxspltd rB3, rb1, 0
               lxv rb1, 11536(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 238
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 238
               lxv ra0, 22944(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 238
               lxv ra1, 22960(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 238
               lxv ra2, 22976(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 238
               lxv ra3, 22992(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 238
               lxv ra4, 23008(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 238
               lxv ra5, 23024(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 11552(pB)
            #endif
         #endif
         #if KB >= 239
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 239
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 239
               xxspltd rB1, rb3, 0
               lxv rb3, 11568(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 239
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 239
               xxspltd rB3, rb4, 0
               lxv rb4, 11584(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 239
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 239
               lxv rA0, 23040(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 239
               lxv rA1, 23056(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 239
               lxv rA2, 23072(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 239
               lxv rA3, 23088(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 239
                lxv rA4, 23104(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 240
               lxv rA5, 23120(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 11600(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 240
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 240
               xxspltd rB1, rb0, 0
               lxv rb0, 11616(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 240
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 240
               xxspltd rB3, rb1, 0
               lxv rb1, 11632(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 240
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 240
               lxv ra0, 23136(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 240
               lxv ra1, 23152(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 240
               lxv ra2, 23168(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 240
               lxv ra3, 23184(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 240
               lxv ra4, 23200(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 240
               lxv ra5, 23216(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 11648(pB)
            #endif
         #endif
         #if KB >= 241
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 241
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 241
               xxspltd rB1, rb3, 0
               lxv rb3, 11664(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 241
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 241
               xxspltd rB3, rb4, 0
               lxv rb4, 11680(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 241
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 241
               lxv rA0, 23232(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 241
               lxv rA1, 23248(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 241
               lxv rA2, 23264(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 241
               lxv rA3, 23280(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 241
                lxv rA4, 23296(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 242
               lxv rA5, 23312(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 11696(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 242
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 242
               xxspltd rB1, rb0, 0
               lxv rb0, 11712(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 242
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 242
               xxspltd rB3, rb1, 0
               lxv rb1, 11728(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 242
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 242
               lxv ra0, 23328(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 242
               lxv ra1, 23344(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 242
               lxv ra2, 23360(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 242
               lxv ra3, 23376(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 242
               lxv ra4, 23392(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 242
               lxv ra5, 23408(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 11744(pB)
            #endif
         #endif
         #if KB >= 243
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 243
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 243
               xxspltd rB1, rb3, 0
               lxv rb3, 11760(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 243
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 243
               xxspltd rB3, rb4, 0
               lxv rb4, 11776(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 243
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 243
               lxv rA0, 23424(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 243
               lxv rA1, 23440(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 243
               lxv rA2, 23456(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 243
               lxv rA3, 23472(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 243
                lxv rA4, 23488(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 244
               lxv rA5, 23504(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 11792(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 244
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 244
               xxspltd rB1, rb0, 0
               lxv rb0, 11808(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 244
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 244
               xxspltd rB3, rb1, 0
               lxv rb1, 11824(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 244
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 244
               lxv ra0, 23520(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 244
               lxv ra1, 23536(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 244
               lxv ra2, 23552(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 244
               lxv ra3, 23568(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 244
               lxv ra4, 23584(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 244
               lxv ra5, 23600(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 11840(pB)
            #endif
         #endif
         #if KB >= 245
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 245
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 245
               xxspltd rB1, rb3, 0
               lxv rb3, 11856(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 245
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 245
               xxspltd rB3, rb4, 0
               lxv rb4, 11872(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 245
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 245
               lxv rA0, 23616(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 245
               lxv rA1, 23632(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 245
               lxv rA2, 23648(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 245
               lxv rA3, 23664(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 245
                lxv rA4, 23680(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 246
               lxv rA5, 23696(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 11888(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 246
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 246
               xxspltd rB1, rb0, 0
               lxv rb0, 11904(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 246
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 246
               xxspltd rB3, rb1, 0
               lxv rb1, 11920(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 246
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 246
               lxv ra0, 23712(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 246
               lxv ra1, 23728(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 246
               lxv ra2, 23744(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 246
               lxv ra3, 23760(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 246
               lxv ra4, 23776(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 246
               lxv ra5, 23792(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 11936(pB)
            #endif
         #endif
         #if KB >= 247
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 247
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 247
               xxspltd rB1, rb3, 0
               lxv rb3, 11952(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 247
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 247
               xxspltd rB3, rb4, 0
               lxv rb4, 11968(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 247
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 247
               lxv rA0, 23808(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 247
               lxv rA1, 23824(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 247
               lxv rA2, 23840(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 247
               lxv rA3, 23856(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 247
                lxv rA4, 23872(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 248
               lxv rA5, 23888(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 11984(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 248
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 248
               xxspltd rB1, rb0, 0
               lxv rb0, 12000(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 248
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 248
               xxspltd rB3, rb1, 0
               lxv rb1, 12016(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 248
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 248
               lxv ra0, 23904(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 248
               lxv ra1, 23920(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 248
               lxv ra2, 23936(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 248
               lxv ra3, 23952(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 248
               lxv ra4, 23968(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 248
               lxv ra5, 23984(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 12032(pB)
            #endif
         #endif
         #if KB >= 249
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 249
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 249
               xxspltd rB1, rb3, 0
               lxv rb3, 12048(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 249
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 249
               xxspltd rB3, rb4, 0
               lxv rb4, 12064(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 249
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 249
               lxv rA0, 24000(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 249
               lxv rA1, 24016(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 249
               lxv rA2, 24032(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 249
               lxv rA3, 24048(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 249
                lxv rA4, 24064(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 250
               lxv rA5, 24080(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 12080(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 250
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 250
               xxspltd rB1, rb0, 0
               lxv rb0, 12096(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 250
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 250
               xxspltd rB3, rb1, 0
               lxv rb1, 12112(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 250
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 250
               lxv ra0, 24096(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 250
               lxv ra1, 24112(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 250
               lxv ra2, 24128(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 250
               lxv ra3, 24144(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 250
               lxv ra4, 24160(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 250
               lxv ra5, 24176(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 12128(pB)
            #endif
         #endif
         #if KB >= 251
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 251
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 251
               xxspltd rB1, rb3, 0
               lxv rb3, 12144(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 251
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 251
               xxspltd rB3, rb4, 0
               lxv rb4, 12160(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 251
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 251
               lxv rA0, 24192(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 251
               lxv rA1, 24208(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 251
               lxv rA2, 24224(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 251
               lxv rA3, 24240(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 251
                lxv rA4, 24256(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 252
               lxv rA5, 24272(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 12176(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 252
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 252
               xxspltd rB1, rb0, 0
               lxv rb0, 12192(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 252
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 252
               xxspltd rB3, rb1, 0
               lxv rb1, 12208(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 252
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 252
               lxv ra0, 24288(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 252
               lxv ra1, 24304(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 252
               lxv ra2, 24320(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 252
               lxv ra3, 24336(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 252
               lxv ra4, 24352(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 252
               lxv ra5, 24368(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 12224(pB)
            #endif
         #endif
         #if KB >= 253
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 253
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 253
               xxspltd rB1, rb3, 0
               lxv rb3, 12240(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 253
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 253
               xxspltd rB3, rb4, 0
               lxv rb4, 12256(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 253
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 253
               lxv rA0, 24384(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 253
               lxv rA1, 24400(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 253
               lxv rA2, 24416(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 253
               lxv rA3, 24432(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 253
                lxv rA4, 24448(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 254
               lxv rA5, 24464(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 12272(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 254
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 254
               xxspltd rB1, rb0, 0
               lxv rb0, 12288(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 254
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 254
               xxspltd rB3, rb1, 0
               lxv rb1, 12304(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 254
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 254
               lxv ra0, 24480(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 254
               lxv ra1, 24496(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 254
               lxv ra2, 24512(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 254
               lxv ra3, 24528(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 254
               lxv ra4, 24544(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 254
               lxv ra5, 24560(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 12320(pB)
            #endif
         #endif
         #if KB >= 255
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 255
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 255
               xxspltd rB1, rb3, 0
               lxv rb3, 12336(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 255
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 255
               xxspltd rB3, rb4, 0
               lxv rb4, 12352(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 255
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 255
               lxv rA0, 24576(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 255
               lxv rA1, 24592(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 255
               lxv rA2, 24608(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 255
               lxv rA3, 24624(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 255
                lxv rA4, 24640(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 256
               lxv rA5, 24656(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 12368(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 256
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 256
               xxspltd rB1, rb0, 0
               lxv rb0, 12384(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 256
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 256
               xxspltd rB3, rb1, 0
               lxv rb1, 12400(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 256
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 256
               lxv ra0, 24672(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 256
               lxv ra1, 24688(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 256
               lxv ra2, 24704(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 256
               lxv ra3, 24720(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 256
               lxv ra4, 24736(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 256
               lxv ra5, 24752(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 12416(pB)
            #endif
         #endif
         #if KB >= 257
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 257
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 257
               xxspltd rB1, rb3, 0
               lxv rb3, 12432(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 257
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 257
               xxspltd rB3, rb4, 0
               lxv rb4, 12448(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 257
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 257
               lxv rA0, 24768(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 257
               lxv rA1, 24784(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 257
               lxv rA2, 24800(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 257
               lxv rA3, 24816(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 257
                lxv rA4, 24832(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 258
               lxv rA5, 24848(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 12464(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 258
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 258
               xxspltd rB1, rb0, 0
               lxv rb0, 12480(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 258
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 258
               xxspltd rB3, rb1, 0
               lxv rb1, 12496(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 258
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 258
               lxv ra0, 24864(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 258
               lxv ra1, 24880(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 258
               lxv ra2, 24896(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 258
               lxv ra3, 24912(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 258
               lxv ra4, 24928(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 258
               lxv ra5, 24944(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 12512(pB)
            #endif
         #endif
         #if KB >= 259
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 259
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 259
               xxspltd rB1, rb3, 0
               lxv rb3, 12528(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 259
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 259
               xxspltd rB3, rb4, 0
               lxv rb4, 12544(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 259
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 259
               lxv rA0, 24960(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 259
               lxv rA1, 24976(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 259
               lxv rA2, 24992(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 259
               lxv rA3, 25008(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 259
                lxv rA4, 25024(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 260
               lxv rA5, 25040(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 12560(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 260
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 260
               xxspltd rB1, rb0, 0
               lxv rb0, 12576(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 260
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 260
               xxspltd rB3, rb1, 0
               lxv rb1, 12592(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 260
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 260
               lxv ra0, 25056(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 260
               lxv ra1, 25072(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 260
               lxv ra2, 25088(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 260
               lxv ra3, 25104(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 260
               lxv ra4, 25120(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 260
               lxv ra5, 25136(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 12608(pB)
            #endif
         #endif
         #if KB >= 261
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 261
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 261
               xxspltd rB1, rb3, 0
               lxv rb3, 12624(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 261
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 261
               xxspltd rB3, rb4, 0
               lxv rb4, 12640(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 261
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 261
               lxv rA0, 25152(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 261
               lxv rA1, 25168(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 261
               lxv rA2, 25184(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 261
               lxv rA3, 25200(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 261
                lxv rA4, 25216(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 262
               lxv rA5, 25232(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 12656(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 262
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 262
               xxspltd rB1, rb0, 0
               lxv rb0, 12672(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 262
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 262
               xxspltd rB3, rb1, 0
               lxv rb1, 12688(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 262
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 262
               lxv ra0, 25248(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 262
               lxv ra1, 25264(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 262
               lxv ra2, 25280(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 262
               lxv ra3, 25296(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 262
               lxv ra4, 25312(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 262
               lxv ra5, 25328(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 12704(pB)
            #endif
         #endif
         #if KB >= 263
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 263
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 263
               xxspltd rB1, rb3, 0
               lxv rb3, 12720(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 263
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 263
               xxspltd rB3, rb4, 0
               lxv rb4, 12736(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 263
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 263
               lxv rA0, 25344(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 263
               lxv rA1, 25360(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 263
               lxv rA2, 25376(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 263
               lxv rA3, 25392(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 263
                lxv rA4, 25408(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 264
               lxv rA5, 25424(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 12752(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 264
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 264
               xxspltd rB1, rb0, 0
               lxv rb0, 12768(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 264
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 264
               xxspltd rB3, rb1, 0
               lxv rb1, 12784(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 264
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 264
               lxv ra0, 25440(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 264
               lxv ra1, 25456(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 264
               lxv ra2, 25472(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 264
               lxv ra3, 25488(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 264
               lxv ra4, 25504(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 264
               lxv ra5, 25520(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 12800(pB)
            #endif
         #endif
         #if KB >= 265
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 265
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 265
               xxspltd rB1, rb3, 0
               lxv rb3, 12816(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 265
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 265
               xxspltd rB3, rb4, 0
               lxv rb4, 12832(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 265
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 265
               lxv rA0, 25536(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 265
               lxv rA1, 25552(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 265
               lxv rA2, 25568(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 265
               lxv rA3, 25584(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 265
                lxv rA4, 25600(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 266
               lxv rA5, 25616(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 12848(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 266
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 266
               xxspltd rB1, rb0, 0
               lxv rb0, 12864(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 266
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 266
               xxspltd rB3, rb1, 0
               lxv rb1, 12880(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 266
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 266
               lxv ra0, 25632(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 266
               lxv ra1, 25648(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 266
               lxv ra2, 25664(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 266
               lxv ra3, 25680(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 266
               lxv ra4, 25696(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 266
               lxv ra5, 25712(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 12896(pB)
            #endif
         #endif
         #if KB >= 267
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 267
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 267
               xxspltd rB1, rb3, 0
               lxv rb3, 12912(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 267
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 267
               xxspltd rB3, rb4, 0
               lxv rb4, 12928(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 267
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 267
               lxv rA0, 25728(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 267
               lxv rA1, 25744(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 267
               lxv rA2, 25760(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 267
               lxv rA3, 25776(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 267
                lxv rA4, 25792(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 268
               lxv rA5, 25808(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 12944(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 268
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 268
               xxspltd rB1, rb0, 0
               lxv rb0, 12960(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 268
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 268
               xxspltd rB3, rb1, 0
               lxv rb1, 12976(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 268
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 268
               lxv ra0, 25824(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 268
               lxv ra1, 25840(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 268
               lxv ra2, 25856(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 268
               lxv ra3, 25872(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 268
               lxv ra4, 25888(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 268
               lxv ra5, 25904(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 12992(pB)
            #endif
         #endif
         #if KB >= 269
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 269
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 269
               xxspltd rB1, rb3, 0
               lxv rb3, 13008(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 269
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 269
               xxspltd rB3, rb4, 0
               lxv rb4, 13024(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 269
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 269
               lxv rA0, 25920(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 269
               lxv rA1, 25936(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 269
               lxv rA2, 25952(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 269
               lxv rA3, 25968(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 269
                lxv rA4, 25984(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 270
               lxv rA5, 26000(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 13040(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 270
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 270
               xxspltd rB1, rb0, 0
               lxv rb0, 13056(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 270
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 270
               xxspltd rB3, rb1, 0
               lxv rb1, 13072(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 270
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 270
               lxv ra0, 26016(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 270
               lxv ra1, 26032(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 270
               lxv ra2, 26048(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 270
               lxv ra3, 26064(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 270
               lxv ra4, 26080(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 270
               lxv ra5, 26096(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 13088(pB)
            #endif
         #endif
         #if KB >= 271
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 271
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 271
               xxspltd rB1, rb3, 0
               lxv rb3, 13104(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 271
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 271
               xxspltd rB3, rb4, 0
               lxv rb4, 13120(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 271
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 271
               lxv rA0, 26112(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 271
               lxv rA1, 26128(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 271
               lxv rA2, 26144(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 271
               lxv rA3, 26160(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 271
                lxv rA4, 26176(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 272
               lxv rA5, 26192(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 13136(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 272
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 272
               xxspltd rB1, rb0, 0
               lxv rb0, 13152(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 272
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 272
               xxspltd rB3, rb1, 0
               lxv rb1, 13168(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 272
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 272
               lxv ra0, 26208(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 272
               lxv ra1, 26224(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 272
               lxv ra2, 26240(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 272
               lxv ra3, 26256(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 272
               lxv ra4, 26272(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 272
               lxv ra5, 26288(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 13184(pB)
            #endif
         #endif
         #if KB >= 273
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 273
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 273
               xxspltd rB1, rb3, 0
               lxv rb3, 13200(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 273
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 273
               xxspltd rB3, rb4, 0
               lxv rb4, 13216(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 273
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 273
               lxv rA0, 26304(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 273
               lxv rA1, 26320(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 273
               lxv rA2, 26336(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 273
               lxv rA3, 26352(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 273
                lxv rA4, 26368(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 274
               lxv rA5, 26384(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 13232(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 274
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 274
               xxspltd rB1, rb0, 0
               lxv rb0, 13248(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 274
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 274
               xxspltd rB3, rb1, 0
               lxv rb1, 13264(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 274
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 274
               lxv ra0, 26400(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 274
               lxv ra1, 26416(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 274
               lxv ra2, 26432(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 274
               lxv ra3, 26448(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 274
               lxv ra4, 26464(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 274
               lxv ra5, 26480(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 13280(pB)
            #endif
         #endif
         #if KB >= 275
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 275
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 275
               xxspltd rB1, rb3, 0
               lxv rb3, 13296(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 275
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 275
               xxspltd rB3, rb4, 0
               lxv rb4, 13312(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 275
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 275
               lxv rA0, 26496(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 275
               lxv rA1, 26512(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 275
               lxv rA2, 26528(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 275
               lxv rA3, 26544(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 275
                lxv rA4, 26560(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 276
               lxv rA5, 26576(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 13328(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 276
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 276
               xxspltd rB1, rb0, 0
               lxv rb0, 13344(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 276
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 276
               xxspltd rB3, rb1, 0
               lxv rb1, 13360(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 276
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 276
               lxv ra0, 26592(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 276
               lxv ra1, 26608(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 276
               lxv ra2, 26624(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 276
               lxv ra3, 26640(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 276
               lxv ra4, 26656(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 276
               lxv ra5, 26672(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 13376(pB)
            #endif
         #endif
         #if KB >= 277
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 277
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 277
               xxspltd rB1, rb3, 0
               lxv rb3, 13392(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 277
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 277
               xxspltd rB3, rb4, 0
               lxv rb4, 13408(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 277
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 277
               lxv rA0, 26688(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 277
               lxv rA1, 26704(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 277
               lxv rA2, 26720(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 277
               lxv rA3, 26736(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 277
                lxv rA4, 26752(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 278
               lxv rA5, 26768(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 13424(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 278
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 278
               xxspltd rB1, rb0, 0
               lxv rb0, 13440(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 278
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 278
               xxspltd rB3, rb1, 0
               lxv rb1, 13456(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 278
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 278
               lxv ra0, 26784(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 278
               lxv ra1, 26800(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 278
               lxv ra2, 26816(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 278
               lxv ra3, 26832(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 278
               lxv ra4, 26848(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 278
               lxv ra5, 26864(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 13472(pB)
            #endif
         #endif
         #if KB >= 279
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 279
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 279
               xxspltd rB1, rb3, 0
               lxv rb3, 13488(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 279
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 279
               xxspltd rB3, rb4, 0
               lxv rb4, 13504(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 279
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 279
               lxv rA0, 26880(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 279
               lxv rA1, 26896(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 279
               lxv rA2, 26912(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 279
               lxv rA3, 26928(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 279
                lxv rA4, 26944(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 280
               lxv rA5, 26960(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 13520(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 280
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 280
               xxspltd rB1, rb0, 0
               lxv rb0, 13536(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 280
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 280
               xxspltd rB3, rb1, 0
               lxv rb1, 13552(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 280
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 280
               lxv ra0, 26976(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 280
               lxv ra1, 26992(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 280
               lxv ra2, 27008(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 280
               lxv ra3, 27024(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 280
               lxv ra4, 27040(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 280
               lxv ra5, 27056(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 13568(pB)
            #endif
         #endif
         #if KB >= 281
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 281
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 281
               xxspltd rB1, rb3, 0
               lxv rb3, 13584(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 281
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 281
               xxspltd rB3, rb4, 0
               lxv rb4, 13600(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 281
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 281
               lxv rA0, 27072(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 281
               lxv rA1, 27088(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 281
               lxv rA2, 27104(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 281
               lxv rA3, 27120(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 281
                lxv rA4, 27136(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 282
               lxv rA5, 27152(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 13616(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 282
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 282
               xxspltd rB1, rb0, 0
               lxv rb0, 13632(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 282
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 282
               xxspltd rB3, rb1, 0
               lxv rb1, 13648(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 282
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 282
               lxv ra0, 27168(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 282
               lxv ra1, 27184(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 282
               lxv ra2, 27200(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 282
               lxv ra3, 27216(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 282
               lxv ra4, 27232(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 282
               lxv ra5, 27248(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 13664(pB)
            #endif
         #endif
         #if KB >= 283
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 283
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 283
               xxspltd rB1, rb3, 0
               lxv rb3, 13680(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 283
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 283
               xxspltd rB3, rb4, 0
               lxv rb4, 13696(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 283
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 283
               lxv rA0, 27264(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 283
               lxv rA1, 27280(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 283
               lxv rA2, 27296(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 283
               lxv rA3, 27312(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 283
                lxv rA4, 27328(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 284
               lxv rA5, 27344(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 13712(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 284
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 284
               xxspltd rB1, rb0, 0
               lxv rb0, 13728(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 284
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 284
               xxspltd rB3, rb1, 0
               lxv rb1, 13744(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 284
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 284
               lxv ra0, 27360(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 284
               lxv ra1, 27376(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 284
               lxv ra2, 27392(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 284
               lxv ra3, 27408(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 284
               lxv ra4, 27424(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 284
               lxv ra5, 27440(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 13760(pB)
            #endif
         #endif
         #if KB >= 285
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 285
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 285
               xxspltd rB1, rb3, 0
               lxv rb3, 13776(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 285
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 285
               xxspltd rB3, rb4, 0
               lxv rb4, 13792(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 285
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 285
               lxv rA0, 27456(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 285
               lxv rA1, 27472(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 285
               lxv rA2, 27488(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 285
               lxv rA3, 27504(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 285
                lxv rA4, 27520(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 286
               lxv rA5, 27536(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 13808(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 286
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 286
               xxspltd rB1, rb0, 0
               lxv rb0, 13824(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 286
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 286
               xxspltd rB3, rb1, 0
               lxv rb1, 13840(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 286
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 286
               lxv ra0, 27552(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 286
               lxv ra1, 27568(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 286
               lxv ra2, 27584(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 286
               lxv ra3, 27600(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 286
               lxv ra4, 27616(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 286
               lxv ra5, 27632(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 13856(pB)
            #endif
         #endif
         #if KB >= 287
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 287
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 287
               xxspltd rB1, rb3, 0
               lxv rb3, 13872(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 287
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 287
               xxspltd rB3, rb4, 0
               lxv rb4, 13888(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 287
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 287
               lxv rA0, 27648(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 287
               lxv rA1, 27664(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 287
               lxv rA2, 27680(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 287
               lxv rA3, 27696(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 287
                lxv rA4, 27712(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 288
               lxv rA5, 27728(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 13904(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 288
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 288
               xxspltd rB1, rb0, 0
               lxv rb0, 13920(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 288
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 288
               xxspltd rB3, rb1, 0
               lxv rb1, 13936(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 288
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 288
               lxv ra0, 27744(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 288
               lxv ra1, 27760(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 288
               lxv ra2, 27776(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 288
               lxv ra3, 27792(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 288
               lxv ra4, 27808(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 288
               lxv ra5, 27824(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 13952(pB)
            #endif
         #endif
         #if KB >= 289
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 289
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 289
               xxspltd rB1, rb3, 0
               lxv rb3, 13968(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 289
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 289
               xxspltd rB3, rb4, 0
               lxv rb4, 13984(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 289
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 289
               lxv rA0, 27840(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 289
               lxv rA1, 27856(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 289
               lxv rA2, 27872(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 289
               lxv rA3, 27888(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 289
                lxv rA4, 27904(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 290
               lxv rA5, 27920(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 14000(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 290
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 290
               xxspltd rB1, rb0, 0
               lxv rb0, 14016(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 290
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 290
               xxspltd rB3, rb1, 0
               lxv rb1, 14032(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 290
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 290
               lxv ra0, 27936(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 290
               lxv ra1, 27952(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 290
               lxv ra2, 27968(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 290
               lxv ra3, 27984(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 290
               lxv ra4, 28000(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 290
               lxv ra5, 28016(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 14048(pB)
            #endif
         #endif
         #if KB >= 291
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 291
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 291
               xxspltd rB1, rb3, 0
               lxv rb3, 14064(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 291
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 291
               xxspltd rB3, rb4, 0
               lxv rb4, 14080(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 291
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 291
               lxv rA0, 28032(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 291
               lxv rA1, 28048(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 291
               lxv rA2, 28064(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 291
               lxv rA3, 28080(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 291
                lxv rA4, 28096(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 292
               lxv rA5, 28112(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 14096(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 292
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 292
               xxspltd rB1, rb0, 0
               lxv rb0, 14112(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 292
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 292
               xxspltd rB3, rb1, 0
               lxv rb1, 14128(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 292
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 292
               lxv ra0, 28128(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 292
               lxv ra1, 28144(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 292
               lxv ra2, 28160(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 292
               lxv ra3, 28176(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 292
               lxv ra4, 28192(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 292
               lxv ra5, 28208(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 14144(pB)
            #endif
         #endif
         #if KB >= 293
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 293
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 293
               xxspltd rB1, rb3, 0
               lxv rb3, 14160(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 293
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 293
               xxspltd rB3, rb4, 0
               lxv rb4, 14176(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 293
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 293
               lxv rA0, 28224(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 293
               lxv rA1, 28240(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 293
               lxv rA2, 28256(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 293
               lxv rA3, 28272(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 293
                lxv rA4, 28288(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 294
               lxv rA5, 28304(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 14192(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 294
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 294
               xxspltd rB1, rb0, 0
               lxv rb0, 14208(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 294
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 294
               xxspltd rB3, rb1, 0
               lxv rb1, 14224(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 294
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 294
               lxv ra0, 28320(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 294
               lxv ra1, 28336(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 294
               lxv ra2, 28352(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 294
               lxv ra3, 28368(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 294
               lxv ra4, 28384(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 294
               lxv ra5, 28400(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 14240(pB)
            #endif
         #endif
         #if KB >= 295
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 295
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 295
               xxspltd rB1, rb3, 0
               lxv rb3, 14256(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 295
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 295
               xxspltd rB3, rb4, 0
               lxv rb4, 14272(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 295
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 295
               lxv rA0, 28416(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 295
               lxv rA1, 28432(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 295
               lxv rA2, 28448(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 295
               lxv rA3, 28464(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 295
                lxv rA4, 28480(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 296
               lxv rA5, 28496(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 14288(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 296
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 296
               xxspltd rB1, rb0, 0
               lxv rb0, 14304(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 296
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 296
               xxspltd rB3, rb1, 0
               lxv rb1, 14320(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 296
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 296
               lxv ra0, 28512(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 296
               lxv ra1, 28528(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 296
               lxv ra2, 28544(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 296
               lxv ra3, 28560(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 296
               lxv ra4, 28576(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 296
               lxv ra5, 28592(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 14336(pB)
            #endif
         #endif
         #if KB >= 297
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 297
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 297
               xxspltd rB1, rb3, 0
               lxv rb3, 14352(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 297
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 297
               xxspltd rB3, rb4, 0
               lxv rb4, 14368(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 297
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 297
               lxv rA0, 28608(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 297
               lxv rA1, 28624(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 297
               lxv rA2, 28640(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 297
               lxv rA3, 28656(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 297
                lxv rA4, 28672(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 298
               lxv rA5, 28688(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 14384(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 298
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 298
               xxspltd rB1, rb0, 0
               lxv rb0, 14400(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 298
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 298
               xxspltd rB3, rb1, 0
               lxv rb1, 14416(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 298
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 298
               lxv ra0, 28704(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 298
               lxv ra1, 28720(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 298
               lxv ra2, 28736(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 298
               lxv ra3, 28752(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 298
               lxv ra4, 28768(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 298
               lxv ra5, 28784(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 14432(pB)
            #endif
         #endif
         #if KB >= 299
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 299
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 299
               xxspltd rB1, rb3, 0
               lxv rb3, 14448(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 299
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 299
               xxspltd rB3, rb4, 0
               lxv rb4, 14464(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 299
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 299
               lxv rA0, 28800(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 299
               lxv rA1, 28816(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 299
               lxv rA2, 28832(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 299
               lxv rA3, 28848(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 299
                lxv rA4, 28864(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 300
               lxv rA5, 28880(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 14480(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 300
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 300
               xxspltd rB1, rb0, 0
               lxv rb0, 14496(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 300
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 300
               xxspltd rB3, rb1, 0
               lxv rb1, 14512(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 300
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 300
               lxv ra0, 28896(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 300
               lxv ra1, 28912(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 300
               lxv ra2, 28928(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 300
               lxv ra3, 28944(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 300
               lxv ra4, 28960(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 300
               lxv ra5, 28976(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 14528(pB)
            #endif
         #endif
         #if KB >= 301
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 301
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 301
               xxspltd rB1, rb3, 0
               lxv rb3, 14544(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 301
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 301
               xxspltd rB3, rb4, 0
               lxv rb4, 14560(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 301
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 301
               lxv rA0, 28992(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 301
               lxv rA1, 29008(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 301
               lxv rA2, 29024(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 301
               lxv rA3, 29040(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 301
                lxv rA4, 29056(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 302
               lxv rA5, 29072(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 14576(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 302
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 302
               xxspltd rB1, rb0, 0
               lxv rb0, 14592(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 302
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 302
               xxspltd rB3, rb1, 0
               lxv rb1, 14608(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 302
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 302
               lxv ra0, 29088(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 302
               lxv ra1, 29104(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 302
               lxv ra2, 29120(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 302
               lxv ra3, 29136(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 302
               lxv ra4, 29152(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 302
               lxv ra5, 29168(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 14624(pB)
            #endif
         #endif
         #if KB >= 303
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 303
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 303
               xxspltd rB1, rb3, 0
               lxv rb3, 14640(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 303
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 303
               xxspltd rB3, rb4, 0
               lxv rb4, 14656(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 303
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 303
               lxv rA0, 29184(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 303
               lxv rA1, 29200(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 303
               lxv rA2, 29216(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 303
               lxv rA3, 29232(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 303
                lxv rA4, 29248(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 304
               lxv rA5, 29264(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 14672(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 304
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 304
               xxspltd rB1, rb0, 0
               lxv rb0, 14688(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 304
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 304
               xxspltd rB3, rb1, 0
               lxv rb1, 14704(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 304
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 304
               lxv ra0, 29280(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 304
               lxv ra1, 29296(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 304
               lxv ra2, 29312(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 304
               lxv ra3, 29328(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 304
               lxv ra4, 29344(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 304
               lxv ra5, 29360(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 14720(pB)
            #endif
         #endif
         #if KB >= 305
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 305
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 305
               xxspltd rB1, rb3, 0
               lxv rb3, 14736(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 305
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 305
               xxspltd rB3, rb4, 0
               lxv rb4, 14752(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 305
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 305
               lxv rA0, 29376(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 305
               lxv rA1, 29392(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 305
               lxv rA2, 29408(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 305
               lxv rA3, 29424(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 305
                lxv rA4, 29440(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 306
               lxv rA5, 29456(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 14768(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 306
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 306
               xxspltd rB1, rb0, 0
               lxv rb0, 14784(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 306
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 306
               xxspltd rB3, rb1, 0
               lxv rb1, 14800(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 306
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 306
               lxv ra0, 29472(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 306
               lxv ra1, 29488(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 306
               lxv ra2, 29504(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 306
               lxv ra3, 29520(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 306
               lxv ra4, 29536(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 306
               lxv ra5, 29552(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 14816(pB)
            #endif
         #endif
         #if KB >= 307
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 307
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 307
               xxspltd rB1, rb3, 0
               lxv rb3, 14832(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 307
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 307
               xxspltd rB3, rb4, 0
               lxv rb4, 14848(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 307
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 307
               lxv rA0, 29568(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 307
               lxv rA1, 29584(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 307
               lxv rA2, 29600(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 307
               lxv rA3, 29616(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 307
                lxv rA4, 29632(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 308
               lxv rA5, 29648(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 14864(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 308
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 308
               xxspltd rB1, rb0, 0
               lxv rb0, 14880(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 308
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 308
               xxspltd rB3, rb1, 0
               lxv rb1, 14896(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 308
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 308
               lxv ra0, 29664(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 308
               lxv ra1, 29680(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 308
               lxv ra2, 29696(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 308
               lxv ra3, 29712(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 308
               lxv ra4, 29728(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 308
               lxv ra5, 29744(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 14912(pB)
            #endif
         #endif
         #if KB >= 309
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 309
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 309
               xxspltd rB1, rb3, 0
               lxv rb3, 14928(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 309
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 309
               xxspltd rB3, rb4, 0
               lxv rb4, 14944(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 309
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 309
               lxv rA0, 29760(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 309
               lxv rA1, 29776(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 309
               lxv rA2, 29792(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 309
               lxv rA3, 29808(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 309
                lxv rA4, 29824(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 310
               lxv rA5, 29840(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 14960(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 310
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 310
               xxspltd rB1, rb0, 0
               lxv rb0, 14976(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 310
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 310
               xxspltd rB3, rb1, 0
               lxv rb1, 14992(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 310
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 310
               lxv ra0, 29856(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 310
               lxv ra1, 29872(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 310
               lxv ra2, 29888(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 310
               lxv ra3, 29904(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 310
               lxv ra4, 29920(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 310
               lxv ra5, 29936(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 15008(pB)
            #endif
         #endif
         #if KB >= 311
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 311
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 311
               xxspltd rB1, rb3, 0
               lxv rb3, 15024(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 311
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 311
               xxspltd rB3, rb4, 0
               lxv rb4, 15040(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 311
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 311
               lxv rA0, 29952(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 311
               lxv rA1, 29968(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 311
               lxv rA2, 29984(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 311
               lxv rA3, 30000(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 311
                lxv rA4, 30016(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 312
               lxv rA5, 30032(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 15056(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 312
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 312
               xxspltd rB1, rb0, 0
               lxv rb0, 15072(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 312
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 312
               xxspltd rB3, rb1, 0
               lxv rb1, 15088(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 312
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 312
               lxv ra0, 30048(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 312
               lxv ra1, 30064(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 312
               lxv ra2, 30080(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 312
               lxv ra3, 30096(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 312
               lxv ra4, 30112(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 312
               lxv ra5, 30128(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 15104(pB)
            #endif
         #endif
         #if KB >= 313
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 313
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 313
               xxspltd rB1, rb3, 0
               lxv rb3, 15120(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 313
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 313
               xxspltd rB3, rb4, 0
               lxv rb4, 15136(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 313
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 313
               lxv rA0, 30144(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 313
               lxv rA1, 30160(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 313
               lxv rA2, 30176(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 313
               lxv rA3, 30192(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 313
                lxv rA4, 30208(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 314
               lxv rA5, 30224(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 15152(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 314
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 314
               xxspltd rB1, rb0, 0
               lxv rb0, 15168(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 314
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 314
               xxspltd rB3, rb1, 0
               lxv rb1, 15184(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 314
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 314
               lxv ra0, 30240(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 314
               lxv ra1, 30256(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 314
               lxv ra2, 30272(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 314
               lxv ra3, 30288(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 314
               lxv ra4, 30304(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 314
               lxv ra5, 30320(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 15200(pB)
            #endif
         #endif
         #if KB >= 315
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 315
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 315
               xxspltd rB1, rb3, 0
               lxv rb3, 15216(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 315
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 315
               xxspltd rB3, rb4, 0
               lxv rb4, 15232(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 315
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 315
               lxv rA0, 30336(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 315
               lxv rA1, 30352(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 315
               lxv rA2, 30368(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 315
               lxv rA3, 30384(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 315
                lxv rA4, 30400(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 316
               lxv rA5, 30416(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 15248(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 316
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 316
               xxspltd rB1, rb0, 0
               lxv rb0, 15264(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 316
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 316
               xxspltd rB3, rb1, 0
               lxv rb1, 15280(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 316
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 316
               lxv ra0, 30432(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 316
               lxv ra1, 30448(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 316
               lxv ra2, 30464(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 316
               lxv ra3, 30480(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 316
               lxv ra4, 30496(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 316
               lxv ra5, 30512(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 15296(pB)
            #endif
         #endif
         #if KB >= 317
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 317
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 317
               xxspltd rB1, rb3, 0
               lxv rb3, 15312(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 317
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 317
               xxspltd rB3, rb4, 0
               lxv rb4, 15328(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 317
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 317
               lxv rA0, 30528(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 317
               lxv rA1, 30544(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 317
               lxv rA2, 30560(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 317
               lxv rA3, 30576(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 317
                lxv rA4, 30592(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 318
               lxv rA5, 30608(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 15344(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 318
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 318
               xxspltd rB1, rb0, 0
               lxv rb0, 15360(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 318
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 318
               xxspltd rB3, rb1, 0
               lxv rb1, 15376(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 318
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 318
               lxv ra0, 30624(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 318
               lxv ra1, 30640(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 318
               lxv ra2, 30656(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 318
               lxv ra3, 30672(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 318
               lxv ra4, 30688(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 318
               lxv ra5, 30704(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 15392(pB)
            #endif
         #endif
         #if KB >= 319
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 319
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 319
               xxspltd rB1, rb3, 0
               lxv rb3, 15408(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 319
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 319
               xxspltd rB3, rb4, 0
               lxv rb4, 15424(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 319
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 319
               lxv rA0, 30720(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 319
               lxv rA1, 30736(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 319
               lxv rA2, 30752(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 319
               lxv rA3, 30768(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 319
                lxv rA4, 30784(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 320
               lxv rA5, 30800(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 15440(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 320
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 320
               xxspltd rB1, rb0, 0
               lxv rb0, 15456(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 320
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 320
               xxspltd rB3, rb1, 0
               lxv rb1, 15472(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 320
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 320
               lxv ra0, 30816(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 320
               lxv ra1, 30832(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 320
               lxv ra2, 30848(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 320
               lxv ra3, 30864(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 320
               lxv ra4, 30880(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 320
               lxv ra5, 30896(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 15488(pB)
            #endif
         #endif
         #if KB >= 321
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 321
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 321
               xxspltd rB1, rb3, 0
               lxv rb3, 15504(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 321
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 321
               xxspltd rB3, rb4, 0
               lxv rb4, 15520(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 321
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 321
               lxv rA0, 30912(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 321
               lxv rA1, 30928(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 321
               lxv rA2, 30944(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 321
               lxv rA3, 30960(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 321
                lxv rA4, 30976(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 322
               lxv rA5, 30992(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 15536(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 322
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 322
               xxspltd rB1, rb0, 0
               lxv rb0, 15552(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 322
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 322
               xxspltd rB3, rb1, 0
               lxv rb1, 15568(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 322
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 322
               lxv ra0, 31008(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 322
               lxv ra1, 31024(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 322
               lxv ra2, 31040(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 322
               lxv ra3, 31056(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 322
               lxv ra4, 31072(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 322
               lxv ra5, 31088(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 15584(pB)
            #endif
         #endif
         #if KB >= 323
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 323
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 323
               xxspltd rB1, rb3, 0
               lxv rb3, 15600(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 323
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 323
               xxspltd rB3, rb4, 0
               lxv rb4, 15616(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 323
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 323
               lxv rA0, 31104(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 323
               lxv rA1, 31120(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 323
               lxv rA2, 31136(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 323
               lxv rA3, 31152(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 323
                lxv rA4, 31168(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 324
               lxv rA5, 31184(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 15632(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 324
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 324
               xxspltd rB1, rb0, 0
               lxv rb0, 15648(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 324
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 324
               xxspltd rB3, rb1, 0
               lxv rb1, 15664(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 324
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 324
               lxv ra0, 31200(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 324
               lxv ra1, 31216(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 324
               lxv ra2, 31232(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 324
               lxv ra3, 31248(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 324
               lxv ra4, 31264(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 324
               lxv ra5, 31280(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 15680(pB)
            #endif
         #endif
         #if KB >= 325
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 325
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 325
               xxspltd rB1, rb3, 0
               lxv rb3, 15696(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 325
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 325
               xxspltd rB3, rb4, 0
               lxv rb4, 15712(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 325
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 325
               lxv rA0, 31296(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 325
               lxv rA1, 31312(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 325
               lxv rA2, 31328(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 325
               lxv rA3, 31344(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 325
                lxv rA4, 31360(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 326
               lxv rA5, 31376(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 15728(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 326
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 326
               xxspltd rB1, rb0, 0
               lxv rb0, 15744(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 326
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 326
               xxspltd rB3, rb1, 0
               lxv rb1, 15760(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 326
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 326
               lxv ra0, 31392(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 326
               lxv ra1, 31408(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 326
               lxv ra2, 31424(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 326
               lxv ra3, 31440(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 326
               lxv ra4, 31456(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 326
               lxv ra5, 31472(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 15776(pB)
            #endif
         #endif
         #if KB >= 327
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 327
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 327
               xxspltd rB1, rb3, 0
               lxv rb3, 15792(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 327
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 327
               xxspltd rB3, rb4, 0
               lxv rb4, 15808(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 327
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 327
               lxv rA0, 31488(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 327
               lxv rA1, 31504(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 327
               lxv rA2, 31520(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 327
               lxv rA3, 31536(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 327
                lxv rA4, 31552(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 328
               lxv rA5, 31568(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 15824(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 328
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 328
               xxspltd rB1, rb0, 0
               lxv rb0, 15840(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 328
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 328
               xxspltd rB3, rb1, 0
               lxv rb1, 15856(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 328
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 328
               lxv ra0, 31584(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 328
               lxv ra1, 31600(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 328
               lxv ra2, 31616(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 328
               lxv ra3, 31632(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 328
               lxv ra4, 31648(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 328
               lxv ra5, 31664(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 15872(pB)
            #endif
         #endif
         #if KB >= 329
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 329
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 329
               xxspltd rB1, rb3, 0
               lxv rb3, 15888(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 329
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 329
               xxspltd rB3, rb4, 0
               lxv rb4, 15904(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 329
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 329
               lxv rA0, 31680(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 329
               lxv rA1, 31696(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 329
               lxv rA2, 31712(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 329
               lxv rA3, 31728(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 329
                lxv rA4, 31744(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 330
               lxv rA5, 31760(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 15920(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 330
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 330
               xxspltd rB1, rb0, 0
               lxv rb0, 15936(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 330
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 330
               xxspltd rB3, rb1, 0
               lxv rb1, 15952(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 330
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 330
               lxv ra0, 31776(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 330
               lxv ra1, 31792(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 330
               lxv ra2, 31808(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 330
               lxv ra3, 31824(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 330
               lxv ra4, 31840(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 330
               lxv ra5, 31856(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 15968(pB)
            #endif
         #endif
         #if KB >= 331
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 331
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 331
               xxspltd rB1, rb3, 0
               lxv rb3, 15984(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 331
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 331
               xxspltd rB3, rb4, 0
               lxv rb4, 16000(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 331
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 331
               lxv rA0, 31872(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 331
               lxv rA1, 31888(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 331
               lxv rA2, 31904(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 331
               lxv rA3, 31920(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 331
                lxv rA4, 31936(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 332
               lxv rA5, 31952(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 16016(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 332
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 332
               xxspltd rB1, rb0, 0
               lxv rb0, 16032(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 332
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 332
               xxspltd rB3, rb1, 0
               lxv rb1, 16048(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 332
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 332
               lxv ra0, 31968(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 332
               lxv ra1, 31984(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 332
               lxv ra2, 32000(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 332
               lxv ra3, 32016(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 332
               lxv ra4, 32032(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 332
               lxv ra5, 32048(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 16064(pB)
            #endif
         #endif
         #if KB >= 333
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 333
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 333
               xxspltd rB1, rb3, 0
               lxv rb3, 16080(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 333
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 333
               xxspltd rB3, rb4, 0
               lxv rb4, 16096(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 333
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 333
               lxv rA0, 32064(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 333
               lxv rA1, 32080(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 333
               lxv rA2, 32096(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 333
               lxv rA3, 32112(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 333
                lxv rA4, 32128(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 334
               lxv rA5, 32144(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 16112(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 334
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 334
               xxspltd rB1, rb0, 0
               lxv rb0, 16128(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 334
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 334
               xxspltd rB3, rb1, 0
               lxv rb1, 16144(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 334
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 334
               lxv ra0, 32160(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 334
               lxv ra1, 32176(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 334
               lxv ra2, 32192(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 334
               lxv ra3, 32208(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 334
               lxv ra4, 32224(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 334
               lxv ra5, 32240(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 16160(pB)
            #endif
         #endif
         #if KB >= 335
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 335
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 335
               xxspltd rB1, rb3, 0
               lxv rb3, 16176(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 335
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 335
               xxspltd rB3, rb4, 0
               lxv rb4, 16192(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 335
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 335
               lxv rA0, 32256(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 335
               lxv rA1, 32272(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 335
               lxv rA2, 32288(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 335
               lxv rA3, 32304(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 335
                lxv rA4, 32320(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 336
               lxv rA5, 32336(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 16208(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 336
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 336
               xxspltd rB1, rb0, 0
               lxv rb0, 16224(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 336
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 336
               xxspltd rB3, rb1, 0
               lxv rb1, 16240(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 336
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 336
               lxv ra0, 32352(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 336
               lxv ra1, 32368(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 336
               lxv ra2, 32384(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 336
               lxv ra3, 32400(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 336
               lxv ra4, 32416(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 336
               lxv ra5, 32432(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 16256(pB)
            #endif
         #endif
         #if KB >= 337
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 337
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 337
               xxspltd rB1, rb3, 0
               lxv rb3, 16272(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 337
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 337
               xxspltd rB3, rb4, 0
               lxv rb4, 16288(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 337
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 337
               lxv rA0, 32448(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 337
               lxv rA1, 32464(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 337
               lxv rA2, 32480(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 337
               lxv rA3, 32496(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 337
                lxv rA4, 32512(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 338
               lxv rA5, 32528(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 16304(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 338
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 338
               xxspltd rB1, rb0, 0
               lxv rb0, 16320(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 338
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 338
               xxspltd rB3, rb1, 0
               lxv rb1, 16336(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 338
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 338
               lxv ra0, 32544(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 338
               lxv ra1, 32560(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 338
               lxv ra2, 32576(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 338
               lxv ra3, 32592(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 338
               lxv ra4, 32608(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 338
               lxv ra5, 32624(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 16352(pB)
            #endif
         #endif
         #if KB >= 339
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 339
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 339
               xxspltd rB1, rb3, 0
               lxv rb3, 16368(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 339
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 339
               xxspltd rB3, rb4, 0
               lxv rb4, 16384(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 339
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 339
               lxv rA0, 32640(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 339
               lxv rA1, 32656(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 339
               lxv rA2, 32672(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 339
               lxv rA3, 32688(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 339
                lxv rA4, 32704(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 340
               lxv rA5, 32720(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 16400(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 340
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 340
               xxspltd rB1, rb0, 0
               lxv rb0, 16416(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 340
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 340
               xxspltd rB3, rb1, 0
               lxv rb1, 16432(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 340
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 340
               lxv ra0, 32736(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 340
               lxv ra1, 32752(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 340
               lxv ra2, 32768(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 340
               lxv ra3, 32784(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 340
               lxv ra4, 32800(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 340
               lxv ra5, 32816(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 16448(pB)
            #endif
         #endif
         #if KB >= 341
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 341
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 341
               xxspltd rB1, rb3, 0
               lxv rb3, 16464(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 341
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 341
               xxspltd rB3, rb4, 0
               lxv rb4, 16480(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 341
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 341
               lxv rA0, 32832(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 341
               lxv rA1, 32848(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 341
               lxv rA2, 32864(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 341
               lxv rA3, 32880(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 341
                lxv rA4, 32896(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 342
               lxv rA5, 32912(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 16496(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 342
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 342
               xxspltd rB1, rb0, 0
               lxv rb0, 16512(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 342
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 342
               xxspltd rB3, rb1, 0
               lxv rb1, 16528(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 342
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 342
               lxv ra0, 32928(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 342
               lxv ra1, 32944(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 342
               lxv ra2, 32960(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 342
               lxv ra3, 32976(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 342
               lxv ra4, 32992(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 342
               lxv ra5, 33008(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 16544(pB)
            #endif
         #endif
         #if KB >= 343
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 343
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 343
               xxspltd rB1, rb3, 0
               lxv rb3, 16560(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 343
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 343
               xxspltd rB3, rb4, 0
               lxv rb4, 16576(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 343
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 343
               lxv rA0, 33024(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 343
               lxv rA1, 33040(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 343
               lxv rA2, 33056(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 343
               lxv rA3, 33072(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 343
                lxv rA4, 33088(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 344
               lxv rA5, 33104(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 16592(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 344
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 344
               xxspltd rB1, rb0, 0
               lxv rb0, 16608(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 344
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 344
               xxspltd rB3, rb1, 0
               lxv rb1, 16624(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 344
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 344
               lxv ra0, 33120(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 344
               lxv ra1, 33136(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 344
               lxv ra2, 33152(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 344
               lxv ra3, 33168(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 344
               lxv ra4, 33184(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 344
               lxv ra5, 33200(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 16640(pB)
            #endif
         #endif
         #if KB >= 345
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 345
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 345
               xxspltd rB1, rb3, 0
               lxv rb3, 16656(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 345
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 345
               xxspltd rB3, rb4, 0
               lxv rb4, 16672(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 345
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 345
               lxv rA0, 33216(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 345
               lxv rA1, 33232(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 345
               lxv rA2, 33248(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 345
               lxv rA3, 33264(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 345
                lxv rA4, 33280(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 346
               lxv rA5, 33296(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 16688(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 346
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 346
               xxspltd rB1, rb0, 0
               lxv rb0, 16704(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 346
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 346
               xxspltd rB3, rb1, 0
               lxv rb1, 16720(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 346
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 346
               lxv ra0, 33312(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 346
               lxv ra1, 33328(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 346
               lxv ra2, 33344(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 346
               lxv ra3, 33360(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 346
               lxv ra4, 33376(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 346
               lxv ra5, 33392(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 16736(pB)
            #endif
         #endif
         #if KB >= 347
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 347
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 347
               xxspltd rB1, rb3, 0
               lxv rb3, 16752(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 347
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 347
               xxspltd rB3, rb4, 0
               lxv rb4, 16768(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 347
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 347
               lxv rA0, 33408(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 347
               lxv rA1, 33424(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 347
               lxv rA2, 33440(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 347
               lxv rA3, 33456(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 347
                lxv rA4, 33472(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 348
               lxv rA5, 33488(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 16784(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 348
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 348
               xxspltd rB1, rb0, 0
               lxv rb0, 16800(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 348
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 348
               xxspltd rB3, rb1, 0
               lxv rb1, 16816(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 348
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 348
               lxv ra0, 33504(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 348
               lxv ra1, 33520(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 348
               lxv ra2, 33536(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 348
               lxv ra3, 33552(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 348
               lxv ra4, 33568(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 348
               lxv ra5, 33584(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 16832(pB)
            #endif
         #endif
         #if KB >= 349
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 349
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 349
               xxspltd rB1, rb3, 0
               lxv rb3, 16848(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 349
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 349
               xxspltd rB3, rb4, 0
               lxv rb4, 16864(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 349
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 349
               lxv rA0, 33600(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 349
               lxv rA1, 33616(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 349
               lxv rA2, 33632(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 349
               lxv rA3, 33648(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 349
                lxv rA4, 33664(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 350
               lxv rA5, 33680(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 16880(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 350
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 350
               xxspltd rB1, rb0, 0
               lxv rb0, 16896(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 350
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 350
               xxspltd rB3, rb1, 0
               lxv rb1, 16912(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 350
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 350
               lxv ra0, 33696(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 350
               lxv ra1, 33712(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 350
               lxv ra2, 33728(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 350
               lxv ra3, 33744(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 350
               lxv ra4, 33760(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 350
               lxv ra5, 33776(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 16928(pB)
            #endif
         #endif
         #if KB >= 351
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 351
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 351
               xxspltd rB1, rb3, 0
               lxv rb3, 16944(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 351
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 351
               xxspltd rB3, rb4, 0
               lxv rb4, 16960(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 351
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 351
               lxv rA0, 33792(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 351
               lxv rA1, 33808(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 351
               lxv rA2, 33824(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 351
               lxv rA3, 33840(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 351
                lxv rA4, 33856(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 352
               lxv rA5, 33872(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 16976(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 352
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 352
               xxspltd rB1, rb0, 0
               lxv rb0, 16992(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 352
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 352
               xxspltd rB3, rb1, 0
               lxv rb1, 17008(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 352
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 352
               lxv ra0, 33888(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 352
               lxv ra1, 33904(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 352
               lxv ra2, 33920(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 352
               lxv ra3, 33936(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 352
               lxv ra4, 33952(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 352
               lxv ra5, 33968(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 17024(pB)
            #endif
         #endif
         #if KB >= 353
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 353
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 353
               xxspltd rB1, rb3, 0
               lxv rb3, 17040(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 353
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 353
               xxspltd rB3, rb4, 0
               lxv rb4, 17056(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 353
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 353
               lxv rA0, 33984(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 353
               lxv rA1, 34000(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 353
               lxv rA2, 34016(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 353
               lxv rA3, 34032(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 353
                lxv rA4, 34048(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 354
               lxv rA5, 34064(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 17072(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 354
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 354
               xxspltd rB1, rb0, 0
               lxv rb0, 17088(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 354
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 354
               xxspltd rB3, rb1, 0
               lxv rb1, 17104(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 354
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 354
               lxv ra0, 34080(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 354
               lxv ra1, 34096(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 354
               lxv ra2, 34112(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 354
               lxv ra3, 34128(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 354
               lxv ra4, 34144(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 354
               lxv ra5, 34160(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 17120(pB)
            #endif
         #endif
         #if KB >= 355
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 355
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 355
               xxspltd rB1, rb3, 0
               lxv rb3, 17136(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 355
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 355
               xxspltd rB3, rb4, 0
               lxv rb4, 17152(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 355
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 355
               lxv rA0, 34176(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 355
               lxv rA1, 34192(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 355
               lxv rA2, 34208(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 355
               lxv rA3, 34224(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 355
                lxv rA4, 34240(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 356
               lxv rA5, 34256(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 17168(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 356
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 356
               xxspltd rB1, rb0, 0
               lxv rb0, 17184(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 356
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 356
               xxspltd rB3, rb1, 0
               lxv rb1, 17200(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 356
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 356
               lxv ra0, 34272(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 356
               lxv ra1, 34288(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 356
               lxv ra2, 34304(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 356
               lxv ra3, 34320(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 356
               lxv ra4, 34336(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 356
               lxv ra5, 34352(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 17216(pB)
            #endif
         #endif
         #if KB >= 357
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 357
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 357
               xxspltd rB1, rb3, 0
               lxv rb3, 17232(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 357
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 357
               xxspltd rB3, rb4, 0
               lxv rb4, 17248(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 357
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 357
               lxv rA0, 34368(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 357
               lxv rA1, 34384(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 357
               lxv rA2, 34400(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 357
               lxv rA3, 34416(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 357
                lxv rA4, 34432(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 358
               lxv rA5, 34448(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 17264(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 358
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 358
               xxspltd rB1, rb0, 0
               lxv rb0, 17280(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 358
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 358
               xxspltd rB3, rb1, 0
               lxv rb1, 17296(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 358
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 358
               lxv ra0, 34464(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 358
               lxv ra1, 34480(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 358
               lxv ra2, 34496(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 358
               lxv ra3, 34512(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 358
               lxv ra4, 34528(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 358
               lxv ra5, 34544(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 17312(pB)
            #endif
         #endif
         #if KB >= 359
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 359
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 359
               xxspltd rB1, rb3, 0
               lxv rb3, 17328(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 359
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 359
               xxspltd rB3, rb4, 0
               lxv rb4, 17344(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 359
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 359
               lxv rA0, 34560(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 359
               lxv rA1, 34576(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 359
               lxv rA2, 34592(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 359
               lxv rA3, 34608(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 359
                lxv rA4, 34624(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 360
               lxv rA5, 34640(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 17360(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 360
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 360
               xxspltd rB1, rb0, 0
               lxv rb0, 17376(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 360
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 360
               xxspltd rB3, rb1, 0
               lxv rb1, 17392(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 360
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 360
               lxv ra0, 34656(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 360
               lxv ra1, 34672(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 360
               lxv ra2, 34688(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 360
               lxv ra3, 34704(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 360
               lxv ra4, 34720(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 360
               lxv ra5, 34736(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 17408(pB)
            #endif
         #endif
         #if KB >= 361
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 361
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 361
               xxspltd rB1, rb3, 0
               lxv rb3, 17424(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 361
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 361
               xxspltd rB3, rb4, 0
               lxv rb4, 17440(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 361
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 361
               lxv rA0, 34752(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 361
               lxv rA1, 34768(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 361
               lxv rA2, 34784(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 361
               lxv rA3, 34800(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 361
                lxv rA4, 34816(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 362
               lxv rA5, 34832(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 17456(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 362
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 362
               xxspltd rB1, rb0, 0
               lxv rb0, 17472(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 362
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 362
               xxspltd rB3, rb1, 0
               lxv rb1, 17488(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 362
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 362
               lxv ra0, 34848(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 362
               lxv ra1, 34864(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 362
               lxv ra2, 34880(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 362
               lxv ra3, 34896(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 362
               lxv ra4, 34912(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 362
               lxv ra5, 34928(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 17504(pB)
            #endif
         #endif
         #if KB >= 363
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 363
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 363
               xxspltd rB1, rb3, 0
               lxv rb3, 17520(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 363
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 363
               xxspltd rB3, rb4, 0
               lxv rb4, 17536(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 363
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 363
               lxv rA0, 34944(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 363
               lxv rA1, 34960(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 363
               lxv rA2, 34976(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 363
               lxv rA3, 34992(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 363
                lxv rA4, 35008(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 364
               lxv rA5, 35024(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 17552(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 364
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 364
               xxspltd rB1, rb0, 0
               lxv rb0, 17568(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 364
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 364
               xxspltd rB3, rb1, 0
               lxv rb1, 17584(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 364
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 364
               lxv ra0, 35040(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 364
               lxv ra1, 35056(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 364
               lxv ra2, 35072(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 364
               lxv ra3, 35088(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 364
               lxv ra4, 35104(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 364
               lxv ra5, 35120(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 17600(pB)
            #endif
         #endif
         #if KB >= 365
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 365
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 365
               xxspltd rB1, rb3, 0
               lxv rb3, 17616(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 365
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 365
               xxspltd rB3, rb4, 0
               lxv rb4, 17632(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 365
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 365
               lxv rA0, 35136(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 365
               lxv rA1, 35152(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 365
               lxv rA2, 35168(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 365
               lxv rA3, 35184(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 365
                lxv rA4, 35200(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 366
               lxv rA5, 35216(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 17648(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 366
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 366
               xxspltd rB1, rb0, 0
               lxv rb0, 17664(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 366
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 366
               xxspltd rB3, rb1, 0
               lxv rb1, 17680(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 366
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 366
               lxv ra0, 35232(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 366
               lxv ra1, 35248(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 366
               lxv ra2, 35264(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 366
               lxv ra3, 35280(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 366
               lxv ra4, 35296(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 366
               lxv ra5, 35312(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 17696(pB)
            #endif
         #endif
         #if KB >= 367
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 367
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 367
               xxspltd rB1, rb3, 0
               lxv rb3, 17712(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 367
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 367
               xxspltd rB3, rb4, 0
               lxv rb4, 17728(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 367
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 367
               lxv rA0, 35328(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 367
               lxv rA1, 35344(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 367
               lxv rA2, 35360(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 367
               lxv rA3, 35376(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 367
                lxv rA4, 35392(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 368
               lxv rA5, 35408(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 17744(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 368
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 368
               xxspltd rB1, rb0, 0
               lxv rb0, 17760(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 368
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 368
               xxspltd rB3, rb1, 0
               lxv rb1, 17776(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 368
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 368
               lxv ra0, 35424(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 368
               lxv ra1, 35440(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 368
               lxv ra2, 35456(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 368
               lxv ra3, 35472(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 368
               lxv ra4, 35488(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 368
               lxv ra5, 35504(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 17792(pB)
            #endif
         #endif
         #if KB >= 369
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 369
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 369
               xxspltd rB1, rb3, 0
               lxv rb3, 17808(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 369
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 369
               xxspltd rB3, rb4, 0
               lxv rb4, 17824(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 369
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 369
               lxv rA0, 35520(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 369
               lxv rA1, 35536(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 369
               lxv rA2, 35552(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 369
               lxv rA3, 35568(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 369
                lxv rA4, 35584(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 370
               lxv rA5, 35600(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 17840(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 370
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 370
               xxspltd rB1, rb0, 0
               lxv rb0, 17856(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 370
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 370
               xxspltd rB3, rb1, 0
               lxv rb1, 17872(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 370
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 370
               lxv ra0, 35616(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 370
               lxv ra1, 35632(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 370
               lxv ra2, 35648(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 370
               lxv ra3, 35664(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 370
               lxv ra4, 35680(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 370
               lxv ra5, 35696(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 17888(pB)
            #endif
         #endif
         #if KB >= 371
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 371
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 371
               xxspltd rB1, rb3, 0
               lxv rb3, 17904(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 371
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 371
               xxspltd rB3, rb4, 0
               lxv rb4, 17920(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 371
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 371
               lxv rA0, 35712(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 371
               lxv rA1, 35728(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 371
               lxv rA2, 35744(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 371
               lxv rA3, 35760(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 371
                lxv rA4, 35776(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 372
               lxv rA5, 35792(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 17936(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 372
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 372
               xxspltd rB1, rb0, 0
               lxv rb0, 17952(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 372
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 372
               xxspltd rB3, rb1, 0
               lxv rb1, 17968(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 372
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 372
               lxv ra0, 35808(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 372
               lxv ra1, 35824(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 372
               lxv ra2, 35840(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 372
               lxv ra3, 35856(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 372
               lxv ra4, 35872(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 372
               lxv ra5, 35888(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 17984(pB)
            #endif
         #endif
         #if KB >= 373
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 373
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 373
               xxspltd rB1, rb3, 0
               lxv rb3, 18000(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 373
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 373
               xxspltd rB3, rb4, 0
               lxv rb4, 18016(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 373
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 373
               lxv rA0, 35904(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 373
               lxv rA1, 35920(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 373
               lxv rA2, 35936(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 373
               lxv rA3, 35952(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 373
                lxv rA4, 35968(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 374
               lxv rA5, 35984(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 18032(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 374
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 374
               xxspltd rB1, rb0, 0
               lxv rb0, 18048(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 374
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 374
               xxspltd rB3, rb1, 0
               lxv rb1, 18064(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 374
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 374
               lxv ra0, 36000(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 374
               lxv ra1, 36016(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 374
               lxv ra2, 36032(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 374
               lxv ra3, 36048(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 374
               lxv ra4, 36064(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 374
               lxv ra5, 36080(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 18080(pB)
            #endif
         #endif
         #if KB >= 375
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 375
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 375
               xxspltd rB1, rb3, 0
               lxv rb3, 18096(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 375
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 375
               xxspltd rB3, rb4, 0
               lxv rb4, 18112(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 375
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 375
               lxv rA0, 36096(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 375
               lxv rA1, 36112(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 375
               lxv rA2, 36128(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 375
               lxv rA3, 36144(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 375
                lxv rA4, 36160(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 376
               lxv rA5, 36176(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 18128(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 376
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 376
               xxspltd rB1, rb0, 0
               lxv rb0, 18144(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 376
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 376
               xxspltd rB3, rb1, 0
               lxv rb1, 18160(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 376
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 376
               lxv ra0, 36192(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 376
               lxv ra1, 36208(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 376
               lxv ra2, 36224(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 376
               lxv ra3, 36240(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 376
               lxv ra4, 36256(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 376
               lxv ra5, 36272(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 18176(pB)
            #endif
         #endif
         #if KB >= 377
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 377
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 377
               xxspltd rB1, rb3, 0
               lxv rb3, 18192(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 377
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 377
               xxspltd rB3, rb4, 0
               lxv rb4, 18208(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 377
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 377
               lxv rA0, 36288(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 377
               lxv rA1, 36304(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 377
               lxv rA2, 36320(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 377
               lxv rA3, 36336(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 377
                lxv rA4, 36352(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 378
               lxv rA5, 36368(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 18224(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 378
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 378
               xxspltd rB1, rb0, 0
               lxv rb0, 18240(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 378
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 378
               xxspltd rB3, rb1, 0
               lxv rb1, 18256(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 378
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 378
               lxv ra0, 36384(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 378
               lxv ra1, 36400(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 378
               lxv ra2, 36416(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 378
               lxv ra3, 36432(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 378
               lxv ra4, 36448(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 378
               lxv ra5, 36464(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 18272(pB)
            #endif
         #endif
         #if KB >= 379
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 379
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 379
               xxspltd rB1, rb3, 0
               lxv rb3, 18288(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 379
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 379
               xxspltd rB3, rb4, 0
               lxv rb4, 18304(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 379
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 379
               lxv rA0, 36480(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 379
               lxv rA1, 36496(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 379
               lxv rA2, 36512(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 379
               lxv rA3, 36528(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 379
                lxv rA4, 36544(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 380
               lxv rA5, 36560(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 18320(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 380
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 380
               xxspltd rB1, rb0, 0
               lxv rb0, 18336(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 380
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 380
               xxspltd rB3, rb1, 0
               lxv rb1, 18352(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 380
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 380
               lxv ra0, 36576(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 380
               lxv ra1, 36592(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 380
               lxv ra2, 36608(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 380
               lxv ra3, 36624(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 380
               lxv ra4, 36640(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 380
               lxv ra5, 36656(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 18368(pB)
            #endif
         #endif
         #if KB >= 381
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 381
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 381
               xxspltd rB1, rb3, 0
               lxv rb3, 18384(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 381
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 381
               xxspltd rB3, rb4, 0
               lxv rb4, 18400(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 381
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 381
               lxv rA0, 36672(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 381
               lxv rA1, 36688(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 381
               lxv rA2, 36704(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 381
               lxv rA3, 36720(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 381
                lxv rA4, 36736(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 382
               lxv rA5, 36752(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 18416(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 382
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 382
               xxspltd rB1, rb0, 0
               lxv rb0, 18432(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 382
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 382
               xxspltd rB3, rb1, 0
               lxv rb1, 18448(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 382
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 382
               lxv ra0, 36768(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 382
               lxv ra1, 36784(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 382
               lxv ra2, 36800(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 382
               lxv ra3, 36816(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 382
               lxv ra4, 36832(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 382
               lxv ra5, 36848(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 18464(pB)
            #endif
         #endif
         #if KB >= 383
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 383
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 383
               xxspltd rB1, rb3, 0
               lxv rb3, 18480(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 383
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 383
               xxspltd rB3, rb4, 0
               lxv rb4, 18496(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 383
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 383
               lxv rA0, 36864(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 383
               lxv rA1, 36880(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 383
               lxv rA2, 36896(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 383
               lxv rA3, 36912(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 383
                lxv rA4, 36928(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 384
               lxv rA5, 36944(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 18512(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 384
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 384
               xxspltd rB1, rb0, 0
               lxv rb0, 18528(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 384
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 384
               xxspltd rB3, rb1, 0
               lxv rb1, 18544(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 384
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 384
               lxv ra0, 36960(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 384
               lxv ra1, 36976(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 384
               lxv ra2, 36992(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 384
               lxv ra3, 37008(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 384
               lxv ra4, 37024(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 384
               lxv ra5, 37040(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 18560(pB)
            #endif
         #endif
         #if KB >= 385
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 385
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 385
               xxspltd rB1, rb3, 0
               lxv rb3, 18576(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 385
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 385
               xxspltd rB3, rb4, 0
               lxv rb4, 18592(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 385
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 385
               lxv rA0, 37056(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 385
               lxv rA1, 37072(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 385
               lxv rA2, 37088(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 385
               lxv rA3, 37104(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 385
                lxv rA4, 37120(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 386
               lxv rA5, 37136(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 18608(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 386
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 386
               xxspltd rB1, rb0, 0
               lxv rb0, 18624(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 386
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 386
               xxspltd rB3, rb1, 0
               lxv rb1, 18640(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 386
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 386
               lxv ra0, 37152(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 386
               lxv ra1, 37168(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 386
               lxv ra2, 37184(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 386
               lxv ra3, 37200(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 386
               lxv ra4, 37216(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 386
               lxv ra5, 37232(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 18656(pB)
            #endif
         #endif
         #if KB >= 387
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 387
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 387
               xxspltd rB1, rb3, 0
               lxv rb3, 18672(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 387
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 387
               xxspltd rB3, rb4, 0
               lxv rb4, 18688(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 387
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 387
               lxv rA0, 37248(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 387
               lxv rA1, 37264(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 387
               lxv rA2, 37280(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 387
               lxv rA3, 37296(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 387
                lxv rA4, 37312(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 388
               lxv rA5, 37328(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 18704(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 388
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 388
               xxspltd rB1, rb0, 0
               lxv rb0, 18720(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 388
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 388
               xxspltd rB3, rb1, 0
               lxv rb1, 18736(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 388
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 388
               lxv ra0, 37344(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 388
               lxv ra1, 37360(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 388
               lxv ra2, 37376(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 388
               lxv ra3, 37392(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 388
               lxv ra4, 37408(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 388
               lxv ra5, 37424(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 18752(pB)
            #endif
         #endif
         #if KB >= 389
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 389
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 389
               xxspltd rB1, rb3, 0
               lxv rb3, 18768(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 389
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 389
               xxspltd rB3, rb4, 0
               lxv rb4, 18784(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 389
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 389
               lxv rA0, 37440(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 389
               lxv rA1, 37456(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 389
               lxv rA2, 37472(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 389
               lxv rA3, 37488(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 389
                lxv rA4, 37504(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 390
               lxv rA5, 37520(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 18800(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 390
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 390
               xxspltd rB1, rb0, 0
               lxv rb0, 18816(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 390
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 390
               xxspltd rB3, rb1, 0
               lxv rb1, 18832(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 390
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 390
               lxv ra0, 37536(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 390
               lxv ra1, 37552(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 390
               lxv ra2, 37568(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 390
               lxv ra3, 37584(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 390
               lxv ra4, 37600(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 390
               lxv ra5, 37616(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 18848(pB)
            #endif
         #endif
         #if KB >= 391
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 391
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 391
               xxspltd rB1, rb3, 0
               lxv rb3, 18864(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 391
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 391
               xxspltd rB3, rb4, 0
               lxv rb4, 18880(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 391
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 391
               lxv rA0, 37632(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 391
               lxv rA1, 37648(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 391
               lxv rA2, 37664(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 391
               lxv rA3, 37680(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 391
                lxv rA4, 37696(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 392
               lxv rA5, 37712(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 18896(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 392
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 392
               xxspltd rB1, rb0, 0
               lxv rb0, 18912(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 392
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 392
               xxspltd rB3, rb1, 0
               lxv rb1, 18928(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 392
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 392
               lxv ra0, 37728(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 392
               lxv ra1, 37744(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 392
               lxv ra2, 37760(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 392
               lxv ra3, 37776(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 392
               lxv ra4, 37792(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 392
               lxv ra5, 37808(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 18944(pB)
            #endif
         #endif
         #if KB >= 393
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 393
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 393
               xxspltd rB1, rb3, 0
               lxv rb3, 18960(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 393
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 393
               xxspltd rB3, rb4, 0
               lxv rb4, 18976(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 393
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 393
               lxv rA0, 37824(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 393
               lxv rA1, 37840(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 393
               lxv rA2, 37856(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 393
               lxv rA3, 37872(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 393
                lxv rA4, 37888(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 394
               lxv rA5, 37904(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 18992(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 394
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 394
               xxspltd rB1, rb0, 0
               lxv rb0, 19008(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 394
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 394
               xxspltd rB3, rb1, 0
               lxv rb1, 19024(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 394
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 394
               lxv ra0, 37920(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 394
               lxv ra1, 37936(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 394
               lxv ra2, 37952(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 394
               lxv ra3, 37968(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 394
               lxv ra4, 37984(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 394
               lxv ra5, 38000(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 19040(pB)
            #endif
         #endif
         #if KB >= 395
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 395
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 395
               xxspltd rB1, rb3, 0
               lxv rb3, 19056(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 395
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 395
               xxspltd rB3, rb4, 0
               lxv rb4, 19072(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 395
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 395
               lxv rA0, 38016(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 395
               lxv rA1, 38032(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 395
               lxv rA2, 38048(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 395
               lxv rA3, 38064(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 395
                lxv rA4, 38080(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 396
               lxv rA5, 38096(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 19088(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 396
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 396
               xxspltd rB1, rb0, 0
               lxv rb0, 19104(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 396
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 396
               xxspltd rB3, rb1, 0
               lxv rb1, 19120(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 396
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 396
               lxv ra0, 38112(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 396
               lxv ra1, 38128(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 396
               lxv ra2, 38144(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 396
               lxv ra3, 38160(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 396
               lxv ra4, 38176(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 396
               lxv ra5, 38192(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 19136(pB)
            #endif
         #endif
         #if KB >= 397
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 397
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 397
               xxspltd rB1, rb3, 0
               lxv rb3, 19152(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 397
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 397
               xxspltd rB3, rb4, 0
               lxv rb4, 19168(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 397
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 397
               lxv rA0, 38208(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 397
               lxv rA1, 38224(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 397
               lxv rA2, 38240(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 397
               lxv rA3, 38256(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 397
                lxv rA4, 38272(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 398
               lxv rA5, 38288(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 19184(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 398
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 398
               xxspltd rB1, rb0, 0
               lxv rb0, 19200(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 398
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 398
               xxspltd rB3, rb1, 0
               lxv rb1, 19216(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 398
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 398
               lxv ra0, 38304(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 398
               lxv ra1, 38320(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 398
               lxv ra2, 38336(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 398
               lxv ra3, 38352(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 398
               lxv ra4, 38368(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 398
               lxv ra5, 38384(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 19232(pB)
            #endif
         #endif
         #if KB >= 399
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 399
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 399
               xxspltd rB1, rb3, 0
               lxv rb3, 19248(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 399
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 399
               xxspltd rB3, rb4, 0
               lxv rb4, 19264(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 399
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 399
               lxv rA0, 38400(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 399
               lxv rA1, 38416(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 399
               lxv rA2, 38432(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 399
               lxv rA3, 38448(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 399
                lxv rA4, 38464(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 400
               lxv rA5, 38480(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 19280(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 400
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 400
               xxspltd rB1, rb0, 0
               lxv rb0, 19296(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 400
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 400
               xxspltd rB3, rb1, 0
               lxv rb1, 19312(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 400
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 400
               lxv ra0, 38496(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 400
               lxv ra1, 38512(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 400
               lxv ra2, 38528(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 400
               lxv ra3, 38544(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 400
               lxv ra4, 38560(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 400
               lxv ra5, 38576(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 19328(pB)
            #endif
         #endif
         #if KB >= 401
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 401
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 401
               xxspltd rB1, rb3, 0
               lxv rb3, 19344(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 401
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 401
               xxspltd rB3, rb4, 0
               lxv rb4, 19360(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 401
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 401
               lxv rA0, 38592(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 401
               lxv rA1, 38608(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 401
               lxv rA2, 38624(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 401
               lxv rA3, 38640(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 401
                lxv rA4, 38656(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 402
               lxv rA5, 38672(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 19376(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 402
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 402
               xxspltd rB1, rb0, 0
               lxv rb0, 19392(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 402
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 402
               xxspltd rB3, rb1, 0
               lxv rb1, 19408(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 402
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 402
               lxv ra0, 38688(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 402
               lxv ra1, 38704(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 402
               lxv ra2, 38720(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 402
               lxv ra3, 38736(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 402
               lxv ra4, 38752(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 402
               lxv ra5, 38768(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 19424(pB)
            #endif
         #endif
         #if KB >= 403
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 403
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 403
               xxspltd rB1, rb3, 0
               lxv rb3, 19440(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 403
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 403
               xxspltd rB3, rb4, 0
               lxv rb4, 19456(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 403
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 403
               lxv rA0, 38784(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 403
               lxv rA1, 38800(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 403
               lxv rA2, 38816(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 403
               lxv rA3, 38832(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 403
                lxv rA4, 38848(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 404
               lxv rA5, 38864(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 19472(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 404
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 404
               xxspltd rB1, rb0, 0
               lxv rb0, 19488(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 404
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 404
               xxspltd rB3, rb1, 0
               lxv rb1, 19504(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 404
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 404
               lxv ra0, 38880(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 404
               lxv ra1, 38896(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 404
               lxv ra2, 38912(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 404
               lxv ra3, 38928(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 404
               lxv ra4, 38944(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 404
               lxv ra5, 38960(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 19520(pB)
            #endif
         #endif
         #if KB >= 405
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 405
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 405
               xxspltd rB1, rb3, 0
               lxv rb3, 19536(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 405
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 405
               xxspltd rB3, rb4, 0
               lxv rb4, 19552(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 405
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 405
               lxv rA0, 38976(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 405
               lxv rA1, 38992(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 405
               lxv rA2, 39008(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 405
               lxv rA3, 39024(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 405
                lxv rA4, 39040(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 406
               lxv rA5, 39056(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 19568(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 406
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 406
               xxspltd rB1, rb0, 0
               lxv rb0, 19584(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 406
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 406
               xxspltd rB3, rb1, 0
               lxv rb1, 19600(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 406
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 406
               lxv ra0, 39072(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 406
               lxv ra1, 39088(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 406
               lxv ra2, 39104(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 406
               lxv ra3, 39120(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 406
               lxv ra4, 39136(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 406
               lxv ra5, 39152(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 19616(pB)
            #endif
         #endif
         #if KB >= 407
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 407
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 407
               xxspltd rB1, rb3, 0
               lxv rb3, 19632(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 407
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 407
               xxspltd rB3, rb4, 0
               lxv rb4, 19648(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 407
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 407
               lxv rA0, 39168(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 407
               lxv rA1, 39184(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 407
               lxv rA2, 39200(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 407
               lxv rA3, 39216(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 407
                lxv rA4, 39232(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 408
               lxv rA5, 39248(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 19664(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 408
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 408
               xxspltd rB1, rb0, 0
               lxv rb0, 19680(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 408
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 408
               xxspltd rB3, rb1, 0
               lxv rb1, 19696(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 408
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 408
               lxv ra0, 39264(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 408
               lxv ra1, 39280(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 408
               lxv ra2, 39296(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 408
               lxv ra3, 39312(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 408
               lxv ra4, 39328(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 408
               lxv ra5, 39344(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 19712(pB)
            #endif
         #endif
         #if KB >= 409
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 409
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 409
               xxspltd rB1, rb3, 0
               lxv rb3, 19728(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 409
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 409
               xxspltd rB3, rb4, 0
               lxv rb4, 19744(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 409
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 409
               lxv rA0, 39360(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 409
               lxv rA1, 39376(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 409
               lxv rA2, 39392(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 409
               lxv rA3, 39408(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 409
                lxv rA4, 39424(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 410
               lxv rA5, 39440(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 19760(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 410
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 410
               xxspltd rB1, rb0, 0
               lxv rb0, 19776(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 410
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 410
               xxspltd rB3, rb1, 0
               lxv rb1, 19792(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 410
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 410
               lxv ra0, 39456(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 410
               lxv ra1, 39472(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 410
               lxv ra2, 39488(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 410
               lxv ra3, 39504(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 410
               lxv ra4, 39520(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 410
               lxv ra5, 39536(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 19808(pB)
            #endif
         #endif
         #if KB >= 411
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 411
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 411
               xxspltd rB1, rb3, 0
               lxv rb3, 19824(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 411
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 411
               xxspltd rB3, rb4, 0
               lxv rb4, 19840(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 411
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 411
               lxv rA0, 39552(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 411
               lxv rA1, 39568(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 411
               lxv rA2, 39584(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 411
               lxv rA3, 39600(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 411
                lxv rA4, 39616(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 412
               lxv rA5, 39632(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 19856(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 412
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 412
               xxspltd rB1, rb0, 0
               lxv rb0, 19872(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 412
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 412
               xxspltd rB3, rb1, 0
               lxv rb1, 19888(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 412
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 412
               lxv ra0, 39648(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 412
               lxv ra1, 39664(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 412
               lxv ra2, 39680(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 412
               lxv ra3, 39696(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 412
               lxv ra4, 39712(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 412
               lxv ra5, 39728(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 19904(pB)
            #endif
         #endif
         #if KB >= 413
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 413
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 413
               xxspltd rB1, rb3, 0
               lxv rb3, 19920(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 413
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 413
               xxspltd rB3, rb4, 0
               lxv rb4, 19936(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 413
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 413
               lxv rA0, 39744(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 413
               lxv rA1, 39760(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 413
               lxv rA2, 39776(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 413
               lxv rA3, 39792(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 413
                lxv rA4, 39808(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 414
               lxv rA5, 39824(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 19952(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 414
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 414
               xxspltd rB1, rb0, 0
               lxv rb0, 19968(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 414
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 414
               xxspltd rB3, rb1, 0
               lxv rb1, 19984(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 414
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 414
               lxv ra0, 39840(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 414
               lxv ra1, 39856(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 414
               lxv ra2, 39872(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 414
               lxv ra3, 39888(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 414
               lxv ra4, 39904(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 414
               lxv ra5, 39920(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 20000(pB)
            #endif
         #endif
         #if KB >= 415
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 415
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 415
               xxspltd rB1, rb3, 0
               lxv rb3, 20016(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 415
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 415
               xxspltd rB3, rb4, 0
               lxv rb4, 20032(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 415
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 415
               lxv rA0, 39936(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 415
               lxv rA1, 39952(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 415
               lxv rA2, 39968(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 415
               lxv rA3, 39984(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 415
                lxv rA4, 40000(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 416
               lxv rA5, 40016(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 20048(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 416
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 416
               xxspltd rB1, rb0, 0
               lxv rb0, 20064(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 416
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 416
               xxspltd rB3, rb1, 0
               lxv rb1, 20080(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 416
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 416
               lxv ra0, 40032(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 416
               lxv ra1, 40048(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 416
               lxv ra2, 40064(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 416
               lxv ra3, 40080(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 416
               lxv ra4, 40096(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 416
               lxv ra5, 40112(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 20096(pB)
            #endif
         #endif
         #if KB >= 417
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 417
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 417
               xxspltd rB1, rb3, 0
               lxv rb3, 20112(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 417
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 417
               xxspltd rB3, rb4, 0
               lxv rb4, 20128(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 417
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 417
               lxv rA0, 40128(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 417
               lxv rA1, 40144(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 417
               lxv rA2, 40160(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 417
               lxv rA3, 40176(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 417
                lxv rA4, 40192(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 418
               lxv rA5, 40208(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 20144(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 418
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 418
               xxspltd rB1, rb0, 0
               lxv rb0, 20160(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 418
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 418
               xxspltd rB3, rb1, 0
               lxv rb1, 20176(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 418
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 418
               lxv ra0, 40224(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 418
               lxv ra1, 40240(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 418
               lxv ra2, 40256(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 418
               lxv ra3, 40272(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 418
               lxv ra4, 40288(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 418
               lxv ra5, 40304(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 20192(pB)
            #endif
         #endif
         #if KB >= 419
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 419
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 419
               xxspltd rB1, rb3, 0
               lxv rb3, 20208(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 419
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 419
               xxspltd rB3, rb4, 0
               lxv rb4, 20224(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 419
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 419
               lxv rA0, 40320(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 419
               lxv rA1, 40336(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 419
               lxv rA2, 40352(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 419
               lxv rA3, 40368(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 419
                lxv rA4, 40384(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 420
               lxv rA5, 40400(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 20240(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 420
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 420
               xxspltd rB1, rb0, 0
               lxv rb0, 20256(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 420
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 420
               xxspltd rB3, rb1, 0
               lxv rb1, 20272(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 420
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 420
               lxv ra0, 40416(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 420
               lxv ra1, 40432(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 420
               lxv ra2, 40448(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 420
               lxv ra3, 40464(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 420
               lxv ra4, 40480(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 420
               lxv ra5, 40496(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 20288(pB)
            #endif
         #endif
         #if KB >= 421
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 421
               xxspltd rB0, rb3, 1
            #endif

            xvmaddadp rC01, rA0, rB1
            xvmaddadp rC11, rA1, rB1
            xvmaddadp rC21, rA2, rB1
            xvmaddadp rC31, rA3, rB1
            xvmaddadp rC41, rA4, rB1
            xvmaddadp rC51, rA5, rB1
            #if KB > 421
               xxspltd rB1, rb3, 0
               lxv rb3, 20304(pB)
            #endif

            xvmaddadp rC02, rA0, rB2
            xvmaddadp rC12, rA1, rB2
            xvmaddadp rC22, rA2, rB2
            xvmaddadp rC32, rA3, rB2
            xvmaddadp rC42, rA4, rB2
            xvmaddadp rC52, rA5, rB2
            #if KB > 421
               xxspltd rB2, rb4, 1
            #endif

            xvmaddadp rC03, rA0, rB3
            xvmaddadp rC13, rA1, rB3
            xvmaddadp rC23, rA2, rB3
            xvmaddadp rC33, rA3, rB3
            xvmaddadp rC43, rA4, rB3
            xvmaddadp rC53, rA5, rB3
            #if KB > 421
               xxspltd rB3, rb4, 0
               lxv rb4, 20320(pB)
            #endif

            xvmaddadp rC04, rA0, rB4
            xvmaddadp rC14, rA1, rB4
            xvmaddadp rC24, rA2, rB4
            xvmaddadp rC34, rA3, rB4
            xvmaddadp rC44, rA4, rB4
            xvmaddadp rC54, rA5, rB4
            #if KB > 421
               xxspltd rB4, rb5, 1
            #endif

            xvmaddadp rC05, rA0, rB5
            #if KB > 421
               lxv rA0, 40512(pA)
            #endif
            xvmaddadp rC15, rA1, rB5
            #if KB > 421
               lxv rA1, 40528(pA)
            #endif
            xvmaddadp rC25, rA2, rB5
            #if KB > 421
               lxv rA2, 40544(pA)
            #endif
            xvmaddadp rC35, rA3, rB5
            #if KB > 421
               lxv rA3, 40560(pA)
            #endif
            xvmaddadp rC45, rA4, rB5
            #if KB > 421
                lxv rA4, 40576(pA)
            #endif
            xvmaddadp rC55, rA5, rB5
         #endif

         #if KB >= 422
               lxv rA5, 40592(pA)
               xxspltd rB5, rb5, 0
               lxv rb5, 20336(pB)

            xvmaddadp rC00, ra0, rB0
            xvmaddadp rC10, ra1, rB0
            xvmaddadp rC20, ra2, rB0
            xvmaddadp rC30, ra3, rB0
            xvmaddadp rC40, ra4, rB0
            xvmaddadp rC50, ra5, rB0
            #if KB > 422
               xxspltd rB0, rb0, 1
            #endif

            xvmaddadp rC01, ra0, rB1
            xvmaddadp rC11, ra1, rB1
            xvmaddadp rC21, ra2, rB1
            xvmaddadp rC31, ra3, rB1
            xvmaddadp rC41, ra4, rB1
            xvmaddadp rC51, ra5, rB1
            #if KB > 422
               xxspltd rB1, rb0, 0
               lxv rb0, 20352(pB)
            #endif
            xvmaddadp rC02, ra0, rB2
            xvmaddadp rC12, ra1, rB2
            xvmaddadp rC22, ra2, rB2
            xvmaddadp rC32, ra3, rB2
            xvmaddadp rC42, ra4, rB2
            xvmaddadp rC52, ra5, rB2
            #if KB > 422
               xxspltd rB2, rb1, 1
            #endif

            xvmaddadp rC03, ra0, rB3
            xvmaddadp rC13, ra1, rB3
            xvmaddadp rC23, ra2, rB3
            xvmaddadp rC33, ra3, rB3
            xvmaddadp rC43, ra4, rB3
            xvmaddadp rC53, ra5, rB3
            #if KB > 422
               xxspltd rB3, rb1, 0
               lxv rb1, 20368(pB)
            #endif
            xvmaddadp rC04, ra0, rB4
            xvmaddadp rC14, ra1, rB4
            xvmaddadp rC24, ra2, rB4
            xvmaddadp rC34, ra3, rB4
            xvmaddadp rC44, ra4, rB4
            xvmaddadp rC54, ra5, rB4
            #if KB > 422
               xxspltd rB4, rb2, 1
            #endif

            xvmaddadp rC05, ra0, rB5
            #if KB > 422
               lxv ra0, 40608(pA)
            #endif
            xvmaddadp rC15, ra1, rB5
            #if KB > 422
               lxv ra1, 40624(pA)
            #endif
            xvmaddadp rC25, ra2, rB5
            #if KB > 422
               lxv ra2, 40640(pA)
            #endif
            xvmaddadp rC35, ra3, rB5
            #if KB > 422
               lxv ra3, 40656(pA)
            #endif
            xvmaddadp rC45, ra4, rB5
            #if KB > 422
               lxv ra4, 40672(pA)
            #endif
            xvmaddadp rC55, ra5, rB5
            #if KB > 422
               lxv ra5, 40688(pA)
               xxspltd rB5, rb2, 0
               lxv rb2, 20384(pB)
            #endif
         #endif
         #if KB >= 423
            xvmaddadp rC00, rA0, rB0
            xvmaddadp rC10, rA1, rB0
            xvmaddadp rC20, rA2, rB0
            xvmaddadp rC30, rA3, rB0
            xvmaddadp rC40, rA4, rB0
            xvmaddadp rC50, rA5, rB0
            #if KB > 423
               xxspltd rB0, rb3, 1
            #endif

 