/*
 * Decompiled with CFR 0.152.
 */
package prolog;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import prolog.PrologException;

public class Prolog {
    static Boolean started = false;
    private static List<Object[]> evQueue = new Vector<Object[]>();

    public static native void touch();

    public static native void hello();

    public static native void SetupProlog();

    public static void StartProlog() {
        if (started.booleanValue()) {
            System.err.println("[prolog.Prolog.StartProlog] called twice");
            System.exit(1);
        }
        started = true;
        try {
            System.loadLibrary("cxprolog");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("[prolog.Prolog.StartProlog] " + unsatisfiedLinkError);
            System.exit(1);
        }
        try {
            Prolog.touch();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("[prolog.Prolog.StartProlog] Java is disabled in the CxProlog dynamic library. Recompile: make lib JAVA=y");
            System.exit(1);
        }
        Prolog.SetupProlog();
    }

    public static void main(String[] stringArray) {
        Prolog.StartProlog();
        System.out.println("---");
        Prolog.TestCallProlog();
        System.out.println("---");
        Prolog.TestIVars();
        System.out.println("---");
    }

    public static synchronized void PostEvent(Object ... objectArray) {
        evQueue.add(objectArray);
        if (evQueue.size() == 1) {
            Prolog.NotifyEvent();
            Prolog.class.notify();
        }
    }

    public static synchronized Object[] GetNextEvent() {
        while (evQueue.size() == 0) {
            try {
                Prolog.class.wait();
            }
            catch (Exception exception) {}
        }
        return evQueue.remove(0);
    }

    public static synchronized void DiscardEvents() {
        evQueue.clear();
    }

    public static int HowManyEvents() {
        return evQueue.size();
    }

    private static native void NotifyEvent();

    public static synchronized native boolean CallProlog(String var0);

    public static synchronized native boolean CallProlog(Object ... var0);

    public static void TestCallProlog() {
        block2: {
            Prolog.CallProlog("writeln('Testing CallProlog...')");
            Prolog.CallProlog("zjava");
            try {
                Prolog.CallProlog("writeln('Testing PrologException:'), see(1), writeln(ole)");
            }
            catch (Exception exception) {
                System.out.println("    " + exception.getClass().getCanonicalName() + " occurred");
                System.out.print("    " + exception.getMessage());
                if (!(exception instanceof PrologException)) break block2;
                System.out.println("    " + ((PrologException)exception).getExceptionTerm()[0]);
            }
        }
        Prolog.CallProlog("writeln('Test done!')");
    }

    public static synchronized native Object[] IVarGet(String var0);

    public static synchronized native void IVarSet(String var0, String var1);

    public static synchronized native void IVarSet(String var0, Object ... var1);

    public static void TestIVars() {
        Vector<String> vector = new Vector<String>(2);
        vector.add("ola");
        vector.add("ole");
        System.out.println("Testing IVARS:");
        Prolog.CallProlog("ivars");
        Prolog.IVarSet("aaa", "aaa(4)");
        Prolog.IVarSet("bbb", "bbb", "ccc");
        Prolog.IVarSet("ccc", "bbb", "ccc", "ddd", null, 123, null, 123.123, null, vector);
        Prolog.CallProlog("ivars");
        Object[] objectArray = Prolog.IVarGet("ccc");
        System.out.print("    ");
        for (Object object : objectArray) {
            System.out.print("" + object + ", ");
        }
        System.out.println();
        System.out.println("Test done!");
    }

    public static void GuiCall(Runnable runnable) {
        SwingUtilities.invokeLater(runnable);
    }

    public static void GuiCallWait(Runnable runnable) {
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Boolean sleep(long l) {
        try {
            Thread.sleep(l);
            return true;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public static void Identify() {
        System.out.println("prolog.Prolog");
    }

    public static void PrintThreadId(String string) {
        Prolog.Info("Java thread " + string + ", id = " + Thread.currentThread().getId());
    }

    public static boolean PreValidateTerm(String string) {
        return true;
    }

    public static void CheckThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Prolog.Warning("Graphic op. OUTSIDE the GUI thread?!?!");
        } else {
            Prolog.Info("Graphic op. inside the GUI thread");
        }
    }

    public static String getClasspath() {
        return System.getProperty("java.class.path");
    }

    public static Object Null() {
        return null;
    }

    public static void genException() throws ParseException {
        throw new ParseException("just a test", 21056);
    }

    public static void testMixArray(Object ... objectArray) {
        for (Object object : objectArray) {
            System.out.print("" + object + ", ");
        }
        if (objectArray.length > 0) {
            System.out.println();
        }
    }

    public static Object objId(Object object) {
        return object;
    }

    public static Object someObj() {
        return new int[10];
    }

    public static synchronized native void Info(String var0);

    public static synchronized native void Warning(String var0);

    public static synchronized native void Error(String var0);

    public static void Init() {
        started = true;
    }

    public static void coroutiningStart() {
        CoroutiningEventQueue.start();
    }

    public static void coroutiningStop() {
        CoroutiningEventQueue.stop();
    }

    public static boolean coroutiningRunABit(String string) {
        try {
            Prolog.CallProlog("thread_run_a_bit", string);
        }
        catch (Throwable throwable) {
            System.err.print(throwable.getMessage());
        }
        return !Prolog.coroutiningWaitingInput(string);
    }

    public static native void coroutiningInputLine(String var0, String var1);

    public static native String coroutiningOutputText(String var0);

    public static native boolean coroutiningWaitingInput(String var0);

    private static class CoroutiningEventQueue
    extends EventQueue {
        private static CoroutiningEventQueue singleton = null;
        private static AWTEvent runABitEvent = null;
        private static boolean coroutiningOn = false;

        private CoroutiningEventQueue() {
        }

        @Override
        protected void dispatchEvent(AWTEvent aWTEvent) {
            if (aWTEvent == runABitEvent) {
                if (coroutiningOn) {
                    if (!Prolog.coroutiningRunABit("mythread")) {
                        Prolog.sleep(300L);
                    } else {
                        System.out.println("****    INPUT");
                    }
                    singleton.postEvent(runABitEvent);
                }
            } else {
                super.dispatchEvent(aWTEvent);
            }
        }

        public static void start() {
            if (singleton == null) {
                coroutiningOn = false;
                singleton = new CoroutiningEventQueue();
                runABitEvent = new ActionEvent(singleton, 0, "");
            }
            if (!coroutiningOn) {
                Toolkit.getDefaultToolkit().getSystemEventQueue().push(singleton);
            }
            coroutiningOn = true;
            singleton.postEvent(runABitEvent);
        }

        public static void stop() {
            boolean bl = coroutiningOn;
            coroutiningOn = false;
            if (bl) {
                singleton.pop();
            }
        }
    }
}

