// Code generated by optgen; DO NOT EDIT.

package opt

const (
	UnknownOp Operator = iota

	// ------------------------------------------------------------
	// Enforcer Operators
	// ------------------------------------------------------------

	// SortOp enforces the ordering of rows returned by its input expression. Rows can
	// be sorted by one or more of the input columns, each of which can be sorted in
	// either ascending or descending order. See the Ordering field in the
	// PhysicalProps struct.
	SortOp

	// ------------------------------------------------------------
	// Relational Operators
	// ------------------------------------------------------------

	// ScanOp returns a result set containing every row in a table by scanning one of
	// the table's indexes according to its ordering. The private Def field is an
	// *opt.ScanOpDef that identifies the table and index to scan, as well as the
	// subset of columns to project from it.
	//
	// The scan can be constrained and/or have an internal row limit. A scan can be
	// executed either as a forward or as a reverse scan (except when it has a limit,
	// in which case the direction is fixed).
	ScanOp

	// VirtualScanOp returns a result set containing every row in a virtual table.
	// Virtual tables are system tables that are populated "on the fly" with rows
	// synthesized from system metadata and other state. An example is the
	// "information_schema.tables" virtual table which returns one row for each
	// accessible system or user table.
	//
	// VirtualScan has many of the same characteristics as the Scan operator.
	// However, virtual tables do not have indexes or keys, and the physical operator
	// used to scan virtual tables does not support limits or constraints. Therefore,
	// nearly all the rules that apply to Scan do not apply to VirtualScan, so it
	// makes sense to have a separate operator.
	VirtualScanOp

	// ValuesOp returns a manufactured result set containing a constant number of rows.
	// specified by the Rows list field. Each row must contain the same set of
	// columns in the same order.
	//
	// The Rows field contains a list of Tuples, one for each row. Each tuple has
	// the same length (same with that of Cols).
	//
	// The Cols field contains the set of column indices returned by each row
	// as an opt.ColList. It is legal for Cols to be empty.
	ValuesOp

	// SelectOp filters rows from its input result set, based on the boolean filter
	// predicate expression. Rows which do not match the filter are discarded. While
	// the Filter operand can be any boolean expression, normalization rules will
	// typically convert it to a Filters operator in order to make conjunction list
	// matching easier.
	SelectOp

	// ProjectOp modifies the set of columns returned by the input result set. Columns
	// can be removed, reordered, or renamed. In addition, new columns can be
	// synthesized.
	// Projections is a scalar Projections list operator that contains information
	// about the projected columns and any expressions that describe newly
	// synthesized output columns.
	ProjectOp

	// InnerJoinOp creates a result set that combines columns from its left and right
	// inputs, based upon its "on" join predicate. Rows which do not match the
	// predicate are filtered. While expressions in the predicate can refer to
	// columns projected by either the left or right inputs, the inputs are not
	// allowed to refer to the other's projected columns.
	InnerJoinOp

	LeftJoinOp

	RightJoinOp

	FullJoinOp

	SemiJoinOp

	AntiJoinOp

	// IndexJoinOp represents an inner join between an input expression and a primary
	// index. It is a special case of LookupJoin where the input columns are the PK
	// columns of the table we are looking up into, and every input row results in
	// exactly one output row.
	//
	// IndexJoin operators are created from Scan operators (unlike lookup joins which
	// are created from Join operators).
	IndexJoinOp

	// LookupJoinOp represents a join between an input expression and an index.
	// The type of join is in the Def private.
	LookupJoinOp

	// MergeJoinOp represents a join that is executed using merge-join.
	// MergeOn is a scalar which contains the ON condition and merge-join ordering
	// information; see the MergeOn scalar operator.
	// It can be any type of join (identified in the private of MergeOn).
	MergeJoinOp

	// InnerJoinApplyOp has the same join semantics as InnerJoin. However, unlike
	// InnerJoin, it allows the right input to refer to columns projected by the
	// left input.
	InnerJoinApplyOp

	LeftJoinApplyOp

	RightJoinApplyOp

	FullJoinApplyOp

	SemiJoinApplyOp

	AntiJoinApplyOp

	// GroupByOp computes aggregate functions over groups of input rows. Input rows
	// that are equal on the grouping columns are grouped together. The set of
	// computed aggregate functions is described by the Aggregations field (which is
	// always an Aggregations operator).
	//
	// The arguments of the aggregate functions are columns from the input
	// (i.e. Variables), possibly wrapped in aggregate modifiers like AggDistinct.
	//
	// If the set of input rows is empty, then the output of the GroupBy operator
	// will also be empty. If the grouping columns are empty, then all input rows
	// form a single group. GroupBy is used for queries with aggregate functions,
	// HAVING clauses and/or GROUP BY expressions.
	//
	// The Def private contains an ordering; this ordering is used to determine
	// intra-group ordering and is only useful if there is an order-dependent
	// aggregation (like ARRAY_AGG). Grouping columns are inconsequential in this
	// ordering; we currently set all grouping columns as optional in this ordering
	// (but note that this is not required by the operator).
	GroupByOp

	// ScalarGroupByOp computes aggregate functions over the complete set of input
	// rows. This is similar to GroupBy with empty grouping columns, where all input
	// rows form a single group. However, there is an important difference. If the
	// input set is empty, then the output of the ScalarGroupBy operator will have a
	// single row containing default values for each aggregate function (typically
	// null or zero, depending on the function). ScalarGroupBy always returns exactly
	// one row - either the single-group aggregates or the default aggregate values.
	//
	// ScalarGroupBy uses the same GroupByDef private so that it's polymorphic with
	// GroupBy and can be used in the same rules (when appropriate). In the
	// ScalarGroupBy case, the grouping column field in GroupByDef is always empty.
	ScalarGroupByOp

	// DistinctOnOp filters out rows that are identical on the set of grouping columns;
	// only the first row (according to an ordering) is kept for each set of possible
	// values. It is roughly equivalent with a GroupBy on the same grouping columns
	// except that it uses FirstAgg functions that ensure the value on the first row
	// is chosen (across all aggregations).
	//
	// In addition, the value on that first row must be chosen for all the grouping
	// columns as well; this is relevant in the case of equal but non-identical
	// values, like decimals. For example, if we have rows (1, 2.0) and (1.0, 2) and
	// we are grouping on these two columns, the values output can be either (1, 2.0)
	// or (1.0, 2), but not (1.0, 2.0).
	//
	// The execution of DistinctOn resembles that of Select more than that of
	// GroupBy: each row is tested against a map of what groups we have seen already,
	// and is either passed through or discarded. In particular, note that this
	// preserves the input ordering.
	//
	// The ordering in the private will be required of the input; it determines which
	// row can get "chosen" for each group of values on the grouping columns.
	// There is no restriction on the ordering; but note that grouping columns are
	// inconsequential - they can appear anywhere in the ordering and they won't
	// change the results (other than the result ordering).
	//
	// Currently when we build DistinctOn, we set all grouping columns as optional
	// cols in Ordering (but this is not required by the operator).
	//
	// TODO(radu): in the future we may want an exploration transform to try out more
	// specific interesting orderings because execution is more efficient when we can
	// rely on an ordering on the grouping columns (or a subset of them).
	//
	// DistinctOn uses an Aggregations child and the GroupByDef private so that it's
	// polymorphic with GroupBy and can be used in the same rules (when appropriate).
	// In the DistinctOn case, the aggregations can be only FirstAgg or ConstAgg.
	DistinctOnOp

	// UnionOp is an operator used to combine the Left and Right input relations into
	// a single set containing rows from both inputs. Duplicate rows are discarded.
	// The private field, ColMap, matches columns from the Left and Right inputs
	// of the Union with the output columns. See the comment above opt.SetOpColMap
	// for more details.
	UnionOp

	// IntersectOp is an operator used to perform an intersection between the Left
	// and Right input relations. The result consists only of rows in the Left
	// relation that are also present in the Right relation. Duplicate rows are
	// discarded.
	// The private field, ColMap, matches columns from the Left and Right inputs
	// of the Intersect with the output columns. See the comment above
	// opt.SetOpColMap for more details.
	IntersectOp

	// ExceptOp is an operator used to perform a set difference between the Left and
	// Right input relations. The result consists only of rows in the Left relation
	// that are not present in the Right relation. Duplicate rows are discarded.
	// The private field, ColMap, matches columns from the Left and Right inputs
	// of the Except with the output columns. See the comment above opt.SetOpColMap
	// for more details.
	ExceptOp

	// UnionAllOp is an operator used to combine the Left and Right input relations
	// into a single set containing rows from both inputs. Duplicate rows are
	// not discarded. For example:
	//   SELECT x FROM xx UNION ALL SELECT y FROM yy
	//     x       y         out
	//   -----   -----      -----
	//     1       1          1
	//     1       2    ->    1
	//     2       3          1
	//                        2
	//                        2
	//                        3
	//
	// The private field, ColMap, matches columns from the Left and Right inputs
	// of the UnionAll with the output columns. See the comment above
	// opt.SetOpColMap for more details.
	UnionAllOp

	// IntersectAllOp is an operator used to perform an intersection between the Left
	// and Right input relations. The result consists only of rows in the Left
	// relation that have a corresponding row in the Right relation. Duplicate rows
	// are not discarded. This effectively creates a one-to-one mapping between the
	// Left and Right rows. For example:
	//   SELECT x FROM xx INTERSECT ALL SELECT y FROM yy
	//     x       y         out
	//   -----   -----      -----
	//     1       1          1
	//     1       1    ->    1
	//     1       2          2
	//     2       2          2
	//     2       3
	//     4
	//
	// The private field, ColMap, matches columns from the Left and Right inputs
	// of the IntersectAll with the output columns. See the comment above
	// opt.SetOpColMap for more details.
	IntersectAllOp

	// ExceptAllOp is an operator used to perform a set difference between the Left
	// and Right input relations. The result consists only of rows in the Left
	// relation that do not have a corresponding row in the Right relation.
	// Duplicate rows are not discarded. This effectively creates a one-to-one
	// mapping between the Left and Right rows. For example:
	//   SELECT x FROM xx EXCEPT ALL SELECT y FROM yy
	//     x       y         out
	//   -----   -----      -----
	//     1       1    ->    1
	//     1       1          4
	//     1       2
	//     2       2
	//     2       3
	//     4
	//
	// The private field, ColMap, matches columns from the Left and Right inputs
	// of the ExceptAll with the output columns. See the comment above
	// opt.SetOpColMap for more details.
	ExceptAllOp

	// LimitOp returns a limited subset of the results in the input relation.
	// The limit expression is a scalar value; the operator returns at most this many
	// rows. The private field is a props.OrderingChoice which indicates the row
	// ordering required from the input (the first rows with respect to this ordering
	// are returned).
	LimitOp

	// OffsetOp filters out the first Offset rows of the input relation; used in
	// conjunction with Limit.
	OffsetOp

	// Max1RowOp enforces that its input must return at most one row. It is used as
	// input to the Subquery operator. See the comment above Subquery for more
	// details.
	Max1RowOp

	// ExplainOp returns information about the execution plan of the "input"
	// expression.
	ExplainOp

	// ShowTraceForSessionOp returns the current session traces.
	ShowTraceForSessionOp

	// RowNumberOp adds a column to each row in its input containing a unique,
	// increasing number.
	RowNumberOp

	// ZipOp represents a functional zip over generators a,b,c, which returns tuples of
	// values from a,b,c picked "simultaneously". NULLs are used when a generator is
	// "shorter" than another. In SQL, these generators can be either a generator
	// function such as generate_series(), or a scalar function such as
	// upper(). For example, consider this query:
	//
	//    SELECT * FROM ROWS FROM (generate_series(0, 1), upper('abc'));
	//
	// It is equivalent to (Zip [(Function generate_series), (Function upper)]).
	// It produces:
	//
	//     generate_series | upper
	//    -----------------+-------
	//                   0 | ABC
	//                   1 | NULL
	//
	// In the Zip operation, Funcs represents the list of functions, and Cols
	// represents the columns output by the functions. Funcs and Cols might not be
	// the same length since a single function may output multiple columns
	// (e.g., pg_get_keywords() outputs three columns).
	ZipOp

	// ------------------------------------------------------------
	// Scalar Operators
	// ------------------------------------------------------------

	// SubqueryOp is a subquery in a single-row context. Here are some examples:
	//
	//   SELECT 1 = (SELECT 1)
	//   SELECT (1, 'a') = (SELECT 1, 'a')`
	//
	// In a single-row context, the outer query is only valid if the subquery returns
	// at most one row. Subqueries in a multi-row context can be transformed to a
	// single row context using the Any operator. See the comment above the Any
	// operator for more details.
	//
	// The Input field contains the subquery itself, which should be wrapped in a
	// Max1Row operator to enforce that the subquery can return at most one row
	// (Max1Row may be removed by the optimizer later if it can determine statically
	// that the subquery will always return at most one row). In addition, the
	// subquery must project exactly one output column. If the subquery returns one
	// row, then that column is bound to the single column value in that row. If the
	// subquery returns zero rows, then that column is bound to NULL.
	SubqueryOp

	// AnyOp is a SQL operator that applies a comparison to every row of an input
	// subquery and returns true if any of the comparisons are true, else returns
	// null if any of the comparisons are null, else returns false. The following
	// transformations map from various SQL operators into the Any operator:
	//
	//   <scalar> IN (<subquery>)
	//   ==> (Any <subquery> <scalar> EqOp)
	//
	//   <scalar> NOT IN (<subquery>)
	//   ==> (Not (Any <subquery> <scalar> EqOp))
	//
	//   <scalar> <comp> {SOME|ANY}(<subquery>)
	//   ==> (Any <subquery> <scalar> <comp>)
	//
	//   <scalar> <comp> ALL(<subquery>)
	//   ==> (Not (Any <subquery> <scalar> <negated-comp>))
	//
	// Any expects the input subquery to return a single column of any data type. The
	// scalar value is compared with that column using the specified comparison
	// operator.
	AnyOp

	// VariableOp is the typed scalar value of a column in the query. The private
	// field is a Metadata.ColumnID that references the column by index.
	VariableOp

	// ConstOp is a typed scalar constant value. The private field is a tree.Datum
	// value having any datum type that's legal in the expression's context.
	ConstOp

	// NullOp is the constant SQL null value that has "unknown value" semantics. If
	// the Typ field is not types.Unknown, then the value is known to be in the
	// domain of that type. This is important for preserving correct types in
	// replacement patterns. For example:
	//   (Plus (Function ...) (Const 1))
	//
	// If the function in that expression has a static type of Int, but then it gets
	// constant folded to (Null), then its type must remain as Int. Any other type
	// violates logical equivalence of the expression, breaking type inference and
	// possibly changing the results of execution. The solution is to tag the null
	// with the correct type:
	//   (Plus (Null (Int)) (Const 1))
	//
	// Null is its own operator rather than a Const datum in order to make matching
	// and replacement easier and more efficient, as patterns can contain (Null)
	// expressions.
	NullOp

	// TrueOp is the boolean true value that is equivalent to the tree.DBoolTrue datum
	// value. It is a separate operator to make matching and replacement simpler and
	// more efficient, as patterns can contain (True) expressions.
	TrueOp

	// FalseOp is the boolean false value that is equivalent to the tree.DBoolFalse
	// datum value. It is a separate operator to make matching and replacement
	// simpler and more efficient, as patterns can contain (False) expressions.
	FalseOp

	PlaceholderOp

	TupleOp

	// ProjectionsOp is a set of typed scalar expressions that will become output
	// columns for a containing Project operator.
	//
	// The private Defs field contains the list of column indexes returned by each
	// expression, and a list of pass-through columns.
	//
	// Elems cannot contain a simple VariableOp with the same ColumnID as the
	// synthesized column (in Def.SynthesizedCols); that is a pass-through column.
	// Elems can contain a VariableOp when a new ColumnID is being assigned, such as
	// in the case of an outer column reference.
	ProjectionsOp

	// AggregationsOp is a set of aggregate expressions that will become output columns
	// for a containing GroupBy operator. The expressions can only consist of
	// aggregate functions, variable references, and modifiers like AggDistinct.
	// Examples of valid expressions:
	//   (Min (Variable 1))
	//   (Count (AggDistinct (Variable 1)))
	//
	// More complex arguments must be formulated using a Project operator as input to
	// the GroupBy operator.
	//
	// The private Cols field contains the list of column indexes returned by the
	// expression, as an opt.ColList. It is legal for Cols to be empty.
	AggregationsOp

	// MergeOnOp contains the ON condition and the metadata for a merge join; it is
	// always a child of MergeJoin.
	MergeOnOp

	// ExistsOp takes a relational query as its input, and evaluates to true if the
	// query returns at least one row.
	ExistsOp

	// FiltersOp is a boolean And operator that only appears as the Filters child of
	// a Select operator, or the On child of a Join operator. For example:
	//   (Select
	//     (Scan a)
	//     (Filters (Gt (Variable a) 1) (Lt (Variable a) 5))
	//   )
	//
	// Normalization rules ensure that a Filters expression is always created if
	// there is at least one condition, so that other rules can rely on its presence
	// when matching, even in the case where there is only one condition. The
	// semantics of the Filters operator are identical to those of the And operator.
	FiltersOp

	// AndOp is the boolean conjunction operator that evalutes to true if all of its
	// conditions evaluate to true. If the conditions list is empty, it evalutes to
	// true.
	AndOp

	// OrOp is the boolean disjunction operator that evalutes to true if any of its
	// conditions evaluate to true. If the conditions list is empty, it evaluates to
	// false.
	OrOp

	// NotOp is the boolean negation operator that evaluates to true if its input
	// evalutes to false.
	NotOp

	EqOp

	LtOp

	GtOp

	LeOp

	GeOp

	NeOp

	InOp

	NotInOp

	LikeOp

	NotLikeOp

	ILikeOp

	NotILikeOp

	SimilarToOp

	NotSimilarToOp

	RegMatchOp

	NotRegMatchOp

	RegIMatchOp

	NotRegIMatchOp

	IsOp

	IsNotOp

	ContainsOp

	JsonExistsOp

	JsonAllExistsOp

	JsonSomeExistsOp

	// AnyScalarOp is the form of ANY which refers to an ANY operation on a
	// tuple or array, as opposed to Any which operates on a subquery.
	AnyScalarOp

	BitandOp

	BitorOp

	BitxorOp

	PlusOp

	MinusOp

	MultOp

	DivOp

	FloorDivOp

	ModOp

	PowOp

	ConcatOp

	LShiftOp

	RShiftOp

	FetchValOp

	FetchTextOp

	FetchValPathOp

	FetchTextPathOp

	UnaryMinusOp

	UnaryComplementOp

	// CastOp converts the input expression into an expression of the target type.
	// While the input's type is restricted to the datum types in the types package,
	// the target type can be any of the column types in the coltypes package. For
	// example, this is a legal cast:
	//
	//   'hello'::VARCHAR(2)
	//
	// That expression has the effect of truncating the string to just 'he', since
	// the target data type allows a maximum of two characters. This is one example
	// of a "lossy" cast.
	CastOp

	// CaseOp is a CASE statement of the form:
	//   CASE [ <Input> ]
	//       WHEN <condval1> THEN <expr1>
	//     [ WHEN <condval2> THEN <expr2> ] ...
	//     [ ELSE <expr> ]
	//   END
	//
	// The Case operator evaluates <Input> (if not provided, Input is set to True),
	// then picks the WHEN branch where <condval> is equal to
	// <Input>, then evaluates and returns the corresponding THEN expression. If no
	// WHEN branch matches, the ELSE expression is evaluated and returned, if any.
	// Otherwise, NULL is returned.
	//
	// Note that the Whens list inside Case is used to represent all the WHEN
	// branches as well as the ELSE statement if it exists. It is of the form:
	// [(When <condval1> <expr1>),(When <condval2> <expr2>),...,<expr>]
	CaseOp

	// WhenOp represents a single WHEN ... THEN ... condition inside a CASE statement.
	// It is the type of each list item in Whens (except for the last item which is
	// a raw expression for the ELSE statement).
	WhenOp

	// ArrayOp is an ARRAY literal of the form ARRAY[<expr1>, <expr2>, ..., <exprN>].
	ArrayOp

	// FunctionOp invokes a builtin SQL function like CONCAT or NOW, passing the given
	// arguments. The private field is a *opt.FuncOpDef struct that provides the
	// name of the function as well as a pointer to the builtin overload definition.
	FunctionOp

	CoalesceOp

	// ColumnAccessOp is a scalar expression that returns a column from the given
	// input expression (which is assumed to be of type Tuple). Idx is the ordinal
	// index of the column in Input.
	ColumnAccessOp

	// UnsupportedExprOp is used for interfacing with the old planner code. It can
	// encapsulate a TypedExpr that is otherwise not supported by the optimizer.
	UnsupportedExprOp

	ArrayAggOp

	AvgOp

	BoolAndOp

	BoolOrOp

	ConcatAggOp

	CountOp

	CountRowsOp

	MaxOp

	MinOp

	SumIntOp

	SumOp

	SqrDiffOp

	VarianceOp

	StdDevOp

	XorAggOp

	JsonAggOp

	JsonbAggOp

	// ConstAggOp is used in the special case when the value of a column is known to be
	// constant within a grouping set; it returns that value. If there are no rows
	// in the grouping set, then ConstAgg returns NULL.
	//
	// ConstAgg is not part of SQL, but it's used internally to rewrite correlated
	// subqueries into an efficient and convenient form.
	ConstAggOp

	// ConstNotNullAggOp is used in the special case when the value of a column is
	// known to be constant within a grouping set, except on some rows where it can
	// have a NULL value; it returns the non-NULL constant value. If there are no
	// rows in the grouping set, or all rows have a NULL value, then ConstNotNullAgg
	// returns NULL.
	//
	// ConstNotNullAgg is not part of SQL, but it's used internally to rewrite
	// correlated subqueries into an efficient and convenient form.
	ConstNotNullAggOp

	// AnyNotNullAggOp returns any non-NULL value it receives, with no other guarantees.
	// If it does not receive any values, it returns NULL.
	//
	// AnyNotNullAgg is not part of SQL, but it's used internally to rewrite
	// correlated subqueries into an efficient and convenient form.
	AnyNotNullAggOp

	// FirstAggOp is used only by DistinctOn; it returns the value on the first row
	// according to an ordering; if the ordering is unspecified (or partially
	// specified), it is an arbitrary ordering but it must be the same across all
	// FirstAggs in a DistinctOn.
	FirstAggOp

	// AggDistinctOp is used as a modifier that wraps the input of an aggregate
	// function. It causes the respective aggregation to only process each distinct
	// value once.
	AggDistinctOp

	// NumOperators tracks the total count of operators.
	NumOperators
)

const opNames = "unknownsortscanvirtual-scanvaluesselectprojectinner-joinleft-joinright-joinfull-joinsemi-joinanti-joinindex-joinlookup-joinmerge-joininner-join-applyleft-join-applyright-join-applyfull-join-applysemi-join-applyanti-join-applygroup-byscalar-group-bydistinct-onunionintersectexceptunion-allintersect-allexcept-alllimitoffsetmax1-rowexplainshow-trace-for-sessionrow-numberzipsubqueryanyvariableconstnulltruefalseplaceholdertupleprojectionsaggregationsmerge-onexistsfiltersandornoteqltgtlegeneinnot-inlikenot-likei-likenot-i-likesimilar-tonot-similar-toreg-matchnot-reg-matchreg-i-matchnot-reg-i-matchisis-notcontainsjson-existsjson-all-existsjson-some-existsany-scalarbitandbitorbitxorplusminusmultdivfloor-divmodpowconcatl-shiftr-shiftfetch-valfetch-textfetch-val-pathfetch-text-pathunary-minusunary-complementcastcasewhenarrayfunctioncoalescecolumn-accessunsupported-exprarray-aggavgbool-andbool-orconcat-aggcountcount-rowsmaxminsum-intsumsqr-diffvariancestd-devxor-aggjson-aggjsonb-aggconst-aggconst-not-null-aggany-not-null-aggfirst-aggagg-distinct"

var opIndexes = [...]uint32{0, 7, 11, 15, 27, 33, 39, 46, 56, 65, 75, 84, 93, 102, 112, 123, 133, 149, 164, 180, 195, 210, 225, 233, 248, 259, 264, 273, 279, 288, 301, 311, 316, 322, 330, 337, 359, 369, 372, 380, 383, 391, 396, 400, 404, 409, 420, 425, 436, 448, 456, 462, 469, 472, 474, 477, 479, 481, 483, 485, 487, 489, 491, 497, 501, 509, 515, 525, 535, 549, 558, 571, 582, 597, 599, 605, 613, 624, 639, 655, 665, 671, 676, 682, 686, 691, 695, 698, 707, 710, 713, 719, 726, 733, 742, 752, 766, 781, 792, 808, 812, 816, 820, 825, 833, 841, 854, 870, 879, 882, 890, 897, 907, 912, 922, 925, 928, 935, 938, 946, 954, 961, 968, 976, 985, 994, 1012, 1028, 1037, 1049}

var EnforcerOperators = [...]Operator{
	SortOp,
}

var RelationalOperators = [...]Operator{
	ScanOp,
	VirtualScanOp,
	ValuesOp,
	SelectOp,
	ProjectOp,
	InnerJoinOp,
	LeftJoinOp,
	RightJoinOp,
	FullJoinOp,
	SemiJoinOp,
	AntiJoinOp,
	IndexJoinOp,
	LookupJoinOp,
	MergeJoinOp,
	InnerJoinApplyOp,
	LeftJoinApplyOp,
	RightJoinApplyOp,
	FullJoinApplyOp,
	SemiJoinApplyOp,
	AntiJoinApplyOp,
	GroupByOp,
	ScalarGroupByOp,
	DistinctOnOp,
	UnionOp,
	IntersectOp,
	ExceptOp,
	UnionAllOp,
	IntersectAllOp,
	ExceptAllOp,
	LimitOp,
	OffsetOp,
	Max1RowOp,
	ExplainOp,
	ShowTraceForSessionOp,
	RowNumberOp,
	ZipOp,
}

var JoinOperators = [...]Operator{
	InnerJoinOp,
	LeftJoinOp,
	RightJoinOp,
	FullJoinOp,
	SemiJoinOp,
	AntiJoinOp,
	InnerJoinApplyOp,
	LeftJoinApplyOp,
	RightJoinApplyOp,
	FullJoinApplyOp,
	SemiJoinApplyOp,
	AntiJoinApplyOp,
}

var JoinNonApplyOperators = [...]Operator{
	InnerJoinOp,
	LeftJoinOp,
	RightJoinOp,
	FullJoinOp,
	SemiJoinOp,
	AntiJoinOp,
}

var JoinApplyOperators = [...]Operator{
	InnerJoinApplyOp,
	LeftJoinApplyOp,
	RightJoinApplyOp,
	FullJoinApplyOp,
	SemiJoinApplyOp,
	AntiJoinApplyOp,
}

var ScalarOperators = [...]Operator{
	SubqueryOp,
	AnyOp,
	VariableOp,
	ConstOp,
	NullOp,
	TrueOp,
	FalseOp,
	PlaceholderOp,
	TupleOp,
	ProjectionsOp,
	AggregationsOp,
	MergeOnOp,
	ExistsOp,
	FiltersOp,
	AndOp,
	OrOp,
	NotOp,
	EqOp,
	LtOp,
	GtOp,
	LeOp,
	GeOp,
	NeOp,
	InOp,
	NotInOp,
	LikeOp,
	NotLikeOp,
	ILikeOp,
	NotILikeOp,
	SimilarToOp,
	NotSimilarToOp,
	RegMatchOp,
	NotRegMatchOp,
	RegIMatchOp,
	NotRegIMatchOp,
	IsOp,
	IsNotOp,
	ContainsOp,
	JsonExistsOp,
	JsonAllExistsOp,
	JsonSomeExistsOp,
	AnyScalarOp,
	BitandOp,
	BitorOp,
	BitxorOp,
	PlusOp,
	MinusOp,
	MultOp,
	DivOp,
	FloorDivOp,
	ModOp,
	PowOp,
	ConcatOp,
	LShiftOp,
	RShiftOp,
	FetchValOp,
	FetchTextOp,
	FetchValPathOp,
	FetchTextPathOp,
	UnaryMinusOp,
	UnaryComplementOp,
	CastOp,
	CaseOp,
	WhenOp,
	ArrayOp,
	FunctionOp,
	CoalesceOp,
	ColumnAccessOp,
	UnsupportedExprOp,
	ArrayAggOp,
	AvgOp,
	BoolAndOp,
	BoolOrOp,
	ConcatAggOp,
	CountOp,
	CountRowsOp,
	MaxOp,
	MinOp,
	SumIntOp,
	SumOp,
	SqrDiffOp,
	VarianceOp,
	StdDevOp,
	XorAggOp,
	JsonAggOp,
	JsonbAggOp,
	ConstAggOp,
	ConstNotNullAggOp,
	AnyNotNullAggOp,
	FirstAggOp,
	AggDistinctOp,
}

var ConstValueOperators = [...]Operator{
	ConstOp,
	NullOp,
	TrueOp,
	FalseOp,
}

var BooleanOperators = [...]Operator{
	TrueOp,
	FalseOp,
	FiltersOp,
	AndOp,
	OrOp,
	NotOp,
}

var ComparisonOperators = [...]Operator{
	EqOp,
	LtOp,
	GtOp,
	LeOp,
	GeOp,
	NeOp,
	InOp,
	NotInOp,
	LikeOp,
	NotLikeOp,
	ILikeOp,
	NotILikeOp,
	SimilarToOp,
	NotSimilarToOp,
	RegMatchOp,
	NotRegMatchOp,
	RegIMatchOp,
	NotRegIMatchOp,
	IsOp,
	IsNotOp,
	ContainsOp,
	JsonExistsOp,
	JsonAllExistsOp,
	JsonSomeExistsOp,
}

var BinaryOperators = [...]Operator{
	BitandOp,
	BitorOp,
	BitxorOp,
	PlusOp,
	MinusOp,
	MultOp,
	DivOp,
	FloorDivOp,
	ModOp,
	PowOp,
	ConcatOp,
	LShiftOp,
	RShiftOp,
	FetchValOp,
	FetchTextOp,
	FetchValPathOp,
	FetchTextPathOp,
}

var UnaryOperators = [...]Operator{
	UnaryMinusOp,
	UnaryComplementOp,
}

var AggregateOperators = [...]Operator{
	ArrayAggOp,
	AvgOp,
	BoolAndOp,
	BoolOrOp,
	ConcatAggOp,
	CountOp,
	CountRowsOp,
	MaxOp,
	MinOp,
	SumIntOp,
	SumOp,
	SqrDiffOp,
	VarianceOp,
	StdDevOp,
	XorAggOp,
	JsonAggOp,
	JsonbAggOp,
	ConstAggOp,
	ConstNotNullAggOp,
	AnyNotNullAggOp,
	FirstAggOp,
}
