#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 2809
#define LARGE_STATE_COUNT 190
#define SYMBOL_COUNT 273
#define ALIAS_COUNT 2
#define TOKEN_COUNT 108
#define EXTERNAL_TOKEN_COUNT 12
#define FIELD_COUNT 32
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 142

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_SEMI = 2,
  anon_sym_import = 3,
  anon_sym_DOT = 4,
  anon_sym_from = 5,
  anon_sym___future__ = 6,
  anon_sym_LPAREN = 7,
  anon_sym_RPAREN = 8,
  anon_sym_COMMA = 9,
  anon_sym_as = 10,
  anon_sym_STAR = 11,
  anon_sym_print = 12,
  anon_sym_GT_GT = 13,
  anon_sym_assert = 14,
  anon_sym_COLON_EQ = 15,
  anon_sym_return = 16,
  anon_sym_del = 17,
  anon_sym_raise = 18,
  anon_sym_pass = 19,
  anon_sym_break = 20,
  anon_sym_continue = 21,
  anon_sym_if = 22,
  anon_sym_COLON = 23,
  anon_sym_elif = 24,
  anon_sym_else = 25,
  anon_sym_match = 26,
  anon_sym_case = 27,
  anon_sym_async = 28,
  anon_sym_for = 29,
  anon_sym_in = 30,
  anon_sym_while = 31,
  anon_sym_try = 32,
  anon_sym_except = 33,
  anon_sym_except_STAR = 34,
  anon_sym_finally = 35,
  anon_sym_with = 36,
  anon_sym_def = 37,
  anon_sym_DASH_GT = 38,
  anon_sym_STAR_STAR = 39,
  anon_sym_global = 40,
  anon_sym_nonlocal = 41,
  anon_sym_exec = 42,
  anon_sym_type = 43,
  anon_sym_EQ = 44,
  anon_sym_class = 45,
  anon_sym_LBRACK = 46,
  anon_sym_RBRACK = 47,
  anon_sym_AT = 48,
  anon_sym_DASH = 49,
  anon_sym__ = 50,
  anon_sym_PIPE = 51,
  anon_sym_LBRACE = 52,
  anon_sym_RBRACE = 53,
  anon_sym_PLUS = 54,
  anon_sym_not = 55,
  anon_sym_and = 56,
  anon_sym_or = 57,
  anon_sym_SLASH = 58,
  anon_sym_PERCENT = 59,
  anon_sym_SLASH_SLASH = 60,
  anon_sym_AMP = 61,
  anon_sym_CARET = 62,
  anon_sym_LT_LT = 63,
  anon_sym_TILDE = 64,
  anon_sym_is = 65,
  anon_sym_LT = 66,
  anon_sym_LT_EQ = 67,
  anon_sym_EQ_EQ = 68,
  anon_sym_BANG_EQ = 69,
  anon_sym_GT_EQ = 70,
  anon_sym_GT = 71,
  anon_sym_LT_GT = 72,
  anon_sym_lambda = 73,
  anon_sym_PLUS_EQ = 74,
  anon_sym_DASH_EQ = 75,
  anon_sym_STAR_EQ = 76,
  anon_sym_SLASH_EQ = 77,
  anon_sym_AT_EQ = 78,
  anon_sym_SLASH_SLASH_EQ = 79,
  anon_sym_PERCENT_EQ = 80,
  anon_sym_STAR_STAR_EQ = 81,
  anon_sym_GT_GT_EQ = 82,
  anon_sym_LT_LT_EQ = 83,
  anon_sym_AMP_EQ = 84,
  anon_sym_CARET_EQ = 85,
  anon_sym_PIPE_EQ = 86,
  anon_sym_yield = 87,
  sym_ellipsis = 88,
  sym_escape_sequence = 89,
  anon_sym_BSLASH = 90,
  aux_sym_format_specifier_token1 = 91,
  sym_type_conversion = 92,
  sym_integer = 93,
  sym_float = 94,
  anon_sym_await = 95,
  sym_true = 96,
  sym_false = 97,
  sym_none = 98,
  sym_comment = 99,
  sym_line_continuation = 100,
  sym__newline = 101,
  sym__indent = 102,
  sym__dedent = 103,
  sym_string_start = 104,
  sym__string_content = 105,
  sym_escape_interpolation = 106,
  sym_string_end = 107,
  sym_module = 108,
  sym__statement = 109,
  sym__simple_statements = 110,
  sym_import_statement = 111,
  sym_import_prefix = 112,
  sym_relative_import = 113,
  sym_future_import_statement = 114,
  sym_import_from_statement = 115,
  sym__import_list = 116,
  sym_aliased_import = 117,
  sym_wildcard_import = 118,
  sym_print_statement = 119,
  sym_chevron = 120,
  sym_assert_statement = 121,
  sym_expression_statement = 122,
  sym_named_expression = 123,
  sym__named_expression_lhs = 124,
  sym_return_statement = 125,
  sym_delete_statement = 126,
  sym_raise_statement = 127,
  sym_pass_statement = 128,
  sym_break_statement = 129,
  sym_continue_statement = 130,
  sym_if_statement = 131,
  sym_elif_clause = 132,
  sym_else_clause = 133,
  sym_match_statement = 134,
  sym__match_block = 135,
  sym_case_clause = 136,
  sym_for_statement = 137,
  sym_while_statement = 138,
  sym_try_statement = 139,
  sym_except_clause = 140,
  sym_except_group_clause = 141,
  sym_finally_clause = 142,
  sym_with_statement = 143,
  sym_with_clause = 144,
  sym_with_item = 145,
  sym_function_definition = 146,
  sym_parameters = 147,
  sym_lambda_parameters = 148,
  sym_list_splat = 149,
  sym_dictionary_splat = 150,
  sym_global_statement = 151,
  sym_nonlocal_statement = 152,
  sym_exec_statement = 153,
  sym_type_alias_statement = 154,
  sym_class_definition = 155,
  sym_type_parameter = 156,
  sym_parenthesized_list_splat = 157,
  sym_argument_list = 158,
  sym_decorated_definition = 159,
  sym_decorator = 160,
  sym_block = 161,
  sym_expression_list = 162,
  sym_dotted_name = 163,
  sym_case_pattern = 164,
  sym__simple_pattern = 165,
  sym__as_pattern = 166,
  sym_union_pattern = 167,
  sym__list_pattern = 168,
  sym__tuple_pattern = 169,
  sym_dict_pattern = 170,
  sym__key_value_pattern = 171,
  sym_keyword_pattern = 172,
  sym_splat_pattern = 173,
  sym_class_pattern = 174,
  sym_complex_pattern = 175,
  sym__parameters = 176,
  sym__patterns = 177,
  sym_parameter = 178,
  sym_pattern = 179,
  sym_tuple_pattern = 180,
  sym_list_pattern = 181,
  sym_default_parameter = 182,
  sym_typed_default_parameter = 183,
  sym_list_splat_pattern = 184,
  sym_dictionary_splat_pattern = 185,
  sym_as_pattern = 186,
  sym__expression_within_for_in_clause = 187,
  sym_expression = 188,
  sym_primary_expression = 189,
  sym_not_operator = 190,
  sym_boolean_operator = 191,
  sym_binary_operator = 192,
  sym_unary_operator = 193,
  sym__not_in = 194,
  sym__is_not = 195,
  sym_comparison_operator = 196,
  sym_lambda = 197,
  sym_lambda_within_for_in_clause = 198,
  sym_assignment = 199,
  sym_augmented_assignment = 200,
  sym_pattern_list = 201,
  sym__right_hand_side = 202,
  sym_yield = 203,
  sym_attribute = 204,
  sym_subscript = 205,
  sym_slice = 206,
  sym_call = 207,
  sym_typed_parameter = 208,
  sym_type = 209,
  sym_splat_type = 210,
  sym_generic_type = 211,
  sym_union_type = 212,
  sym_constrained_type = 213,
  sym_member_type = 214,
  sym_keyword_argument = 215,
  sym_list = 216,
  sym_set = 217,
  sym_tuple = 218,
  sym_dictionary = 219,
  sym_pair = 220,
  sym_list_comprehension = 221,
  sym_dictionary_comprehension = 222,
  sym_set_comprehension = 223,
  sym_generator_expression = 224,
  sym__comprehension_clauses = 225,
  sym_parenthesized_expression = 226,
  sym__collection_elements = 227,
  sym_for_in_clause = 228,
  sym_if_clause = 229,
  sym_conditional_expression = 230,
  sym_concatenated_string = 231,
  sym_string = 232,
  sym_string_content = 233,
  sym_interpolation = 234,
  sym__f_expression = 235,
  sym__not_escape_sequence = 236,
  sym_format_specifier = 237,
  sym_await = 238,
  sym_positional_separator = 239,
  sym_keyword_separator = 240,
  aux_sym_module_repeat1 = 241,
  aux_sym__simple_statements_repeat1 = 242,
  aux_sym_import_prefix_repeat1 = 243,
  aux_sym__import_list_repeat1 = 244,
  aux_sym_print_statement_repeat1 = 245,
  aux_sym_assert_statement_repeat1 = 246,
  aux_sym_if_statement_repeat1 = 247,
  aux_sym_match_statement_repeat1 = 248,
  aux_sym__match_block_repeat1 = 249,
  aux_sym_case_clause_repeat1 = 250,
  aux_sym_try_statement_repeat1 = 251,
  aux_sym_try_statement_repeat2 = 252,
  aux_sym_with_clause_repeat1 = 253,
  aux_sym_global_statement_repeat1 = 254,
  aux_sym_type_parameter_repeat1 = 255,
  aux_sym_argument_list_repeat1 = 256,
  aux_sym_decorated_definition_repeat1 = 257,
  aux_sym_dotted_name_repeat1 = 258,
  aux_sym_union_pattern_repeat1 = 259,
  aux_sym_dict_pattern_repeat1 = 260,
  aux_sym__parameters_repeat1 = 261,
  aux_sym__patterns_repeat1 = 262,
  aux_sym_comparison_operator_repeat1 = 263,
  aux_sym_subscript_repeat1 = 264,
  aux_sym_dictionary_repeat1 = 265,
  aux_sym__comprehension_clauses_repeat1 = 266,
  aux_sym__collection_elements_repeat1 = 267,
  aux_sym_for_in_clause_repeat1 = 268,
  aux_sym_concatenated_string_repeat1 = 269,
  aux_sym_string_repeat1 = 270,
  aux_sym_string_content_repeat1 = 271,
  aux_sym_format_specifier_repeat1 = 272,
  alias_sym_as_pattern_target = 273,
  alias_sym_format_expression = 274,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_SEMI] = ";",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [anon_sym_from] = "from",
  [anon_sym___future__] = "__future__",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_COMMA] = ",",
  [anon_sym_as] = "as",
  [anon_sym_STAR] = "*",
  [anon_sym_print] = "print",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_assert] = "assert",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_return] = "return",
  [anon_sym_del] = "del",
  [anon_sym_raise] = "raise",
  [anon_sym_pass] = "pass",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_if] = "if",
  [anon_sym_COLON] = ":",
  [anon_sym_elif] = "elif",
  [anon_sym_else] = "else",
  [anon_sym_match] = "match",
  [anon_sym_case] = "case",
  [anon_sym_async] = "async",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_while] = "while",
  [anon_sym_try] = "try",
  [anon_sym_except] = "except",
  [anon_sym_except_STAR] = "except*",
  [anon_sym_finally] = "finally",
  [anon_sym_with] = "with",
  [anon_sym_def] = "def",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_global] = "global",
  [anon_sym_nonlocal] = "nonlocal",
  [anon_sym_exec] = "exec",
  [anon_sym_type] = "type",
  [anon_sym_EQ] = "=",
  [anon_sym_class] = "class",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_AT] = "@",
  [anon_sym_DASH] = "-",
  [anon_sym__] = "_",
  [anon_sym_PIPE] = "|",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_PLUS] = "+",
  [anon_sym_not] = "not",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_TILDE] = "~",
  [anon_sym_is] = "is",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_lambda] = "lambda",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_AT_EQ] = "@=",
  [anon_sym_SLASH_SLASH_EQ] = "//=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_yield] = "yield",
  [sym_ellipsis] = "ellipsis",
  [sym_escape_sequence] = "escape_sequence",
  [anon_sym_BSLASH] = "\\",
  [aux_sym_format_specifier_token1] = "format_specifier_token1",
  [sym_type_conversion] = "type_conversion",
  [sym_integer] = "integer",
  [sym_float] = "float",
  [anon_sym_await] = "await",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_none] = "none",
  [sym_comment] = "comment",
  [sym_line_continuation] = "line_continuation",
  [sym__newline] = "_newline",
  [sym__indent] = "_indent",
  [sym__dedent] = "_dedent",
  [sym_string_start] = "string_start",
  [sym__string_content] = "_string_content",
  [sym_escape_interpolation] = "escape_interpolation",
  [sym_string_end] = "string_end",
  [sym_module] = "module",
  [sym__statement] = "_statement",
  [sym__simple_statements] = "_simple_statements",
  [sym_import_statement] = "import_statement",
  [sym_import_prefix] = "import_prefix",
  [sym_relative_import] = "relative_import",
  [sym_future_import_statement] = "future_import_statement",
  [sym_import_from_statement] = "import_from_statement",
  [sym__import_list] = "_import_list",
  [sym_aliased_import] = "aliased_import",
  [sym_wildcard_import] = "wildcard_import",
  [sym_print_statement] = "print_statement",
  [sym_chevron] = "chevron",
  [sym_assert_statement] = "assert_statement",
  [sym_expression_statement] = "expression_statement",
  [sym_named_expression] = "named_expression",
  [sym__named_expression_lhs] = "_named_expression_lhs",
  [sym_return_statement] = "return_statement",
  [sym_delete_statement] = "delete_statement",
  [sym_raise_statement] = "raise_statement",
  [sym_pass_statement] = "pass_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_if_statement] = "if_statement",
  [sym_elif_clause] = "elif_clause",
  [sym_else_clause] = "else_clause",
  [sym_match_statement] = "match_statement",
  [sym__match_block] = "block",
  [sym_case_clause] = "case_clause",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_try_statement] = "try_statement",
  [sym_except_clause] = "except_clause",
  [sym_except_group_clause] = "except_group_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_with_statement] = "with_statement",
  [sym_with_clause] = "with_clause",
  [sym_with_item] = "with_item",
  [sym_function_definition] = "function_definition",
  [sym_parameters] = "parameters",
  [sym_lambda_parameters] = "lambda_parameters",
  [sym_list_splat] = "list_splat",
  [sym_dictionary_splat] = "dictionary_splat",
  [sym_global_statement] = "global_statement",
  [sym_nonlocal_statement] = "nonlocal_statement",
  [sym_exec_statement] = "exec_statement",
  [sym_type_alias_statement] = "type_alias_statement",
  [sym_class_definition] = "class_definition",
  [sym_type_parameter] = "type_parameter",
  [sym_parenthesized_list_splat] = "parenthesized_list_splat",
  [sym_argument_list] = "argument_list",
  [sym_decorated_definition] = "decorated_definition",
  [sym_decorator] = "decorator",
  [sym_block] = "block",
  [sym_expression_list] = "expression_list",
  [sym_dotted_name] = "dotted_name",
  [sym_case_pattern] = "case_pattern",
  [sym__simple_pattern] = "_simple_pattern",
  [sym__as_pattern] = "as_pattern",
  [sym_union_pattern] = "union_pattern",
  [sym__list_pattern] = "list_pattern",
  [sym__tuple_pattern] = "tuple_pattern",
  [sym_dict_pattern] = "dict_pattern",
  [sym__key_value_pattern] = "_key_value_pattern",
  [sym_keyword_pattern] = "keyword_pattern",
  [sym_splat_pattern] = "splat_pattern",
  [sym_class_pattern] = "class_pattern",
  [sym_complex_pattern] = "complex_pattern",
  [sym__parameters] = "_parameters",
  [sym__patterns] = "_patterns",
  [sym_parameter] = "parameter",
  [sym_pattern] = "pattern",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym_list_pattern] = "list_pattern",
  [sym_default_parameter] = "default_parameter",
  [sym_typed_default_parameter] = "typed_default_parameter",
  [sym_list_splat_pattern] = "list_splat_pattern",
  [sym_dictionary_splat_pattern] = "dictionary_splat_pattern",
  [sym_as_pattern] = "as_pattern",
  [sym__expression_within_for_in_clause] = "_expression_within_for_in_clause",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_not_operator] = "not_operator",
  [sym_boolean_operator] = "boolean_operator",
  [sym_binary_operator] = "binary_operator",
  [sym_unary_operator] = "unary_operator",
  [sym__not_in] = "not in",
  [sym__is_not] = "is not",
  [sym_comparison_operator] = "comparison_operator",
  [sym_lambda] = "lambda",
  [sym_lambda_within_for_in_clause] = "lambda",
  [sym_assignment] = "assignment",
  [sym_augmented_assignment] = "augmented_assignment",
  [sym_pattern_list] = "pattern_list",
  [sym__right_hand_side] = "_right_hand_side",
  [sym_yield] = "yield",
  [sym_attribute] = "attribute",
  [sym_subscript] = "subscript",
  [sym_slice] = "slice",
  [sym_call] = "call",
  [sym_typed_parameter] = "typed_parameter",
  [sym_type] = "type",
  [sym_splat_type] = "splat_type",
  [sym_generic_type] = "generic_type",
  [sym_union_type] = "union_type",
  [sym_constrained_type] = "constrained_type",
  [sym_member_type] = "member_type",
  [sym_keyword_argument] = "keyword_argument",
  [sym_list] = "list",
  [sym_set] = "set",
  [sym_tuple] = "tuple",
  [sym_dictionary] = "dictionary",
  [sym_pair] = "pair",
  [sym_list_comprehension] = "list_comprehension",
  [sym_dictionary_comprehension] = "dictionary_comprehension",
  [sym_set_comprehension] = "set_comprehension",
  [sym_generator_expression] = "generator_expression",
  [sym__comprehension_clauses] = "_comprehension_clauses",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym__collection_elements] = "_collection_elements",
  [sym_for_in_clause] = "for_in_clause",
  [sym_if_clause] = "if_clause",
  [sym_conditional_expression] = "conditional_expression",
  [sym_concatenated_string] = "concatenated_string",
  [sym_string] = "string",
  [sym_string_content] = "string_content",
  [sym_interpolation] = "interpolation",
  [sym__f_expression] = "_f_expression",
  [sym__not_escape_sequence] = "_not_escape_sequence",
  [sym_format_specifier] = "format_specifier",
  [sym_await] = "await",
  [sym_positional_separator] = "positional_separator",
  [sym_keyword_separator] = "keyword_separator",
  [aux_sym_module_repeat1] = "module_repeat1",
  [aux_sym__simple_statements_repeat1] = "_simple_statements_repeat1",
  [aux_sym_import_prefix_repeat1] = "import_prefix_repeat1",
  [aux_sym__import_list_repeat1] = "_import_list_repeat1",
  [aux_sym_print_statement_repeat1] = "print_statement_repeat1",
  [aux_sym_assert_statement_repeat1] = "assert_statement_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_match_statement_repeat1] = "match_statement_repeat1",
  [aux_sym__match_block_repeat1] = "_match_block_repeat1",
  [aux_sym_case_clause_repeat1] = "case_clause_repeat1",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym_try_statement_repeat2] = "try_statement_repeat2",
  [aux_sym_with_clause_repeat1] = "with_clause_repeat1",
  [aux_sym_global_statement_repeat1] = "global_statement_repeat1",
  [aux_sym_type_parameter_repeat1] = "type_parameter_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_decorated_definition_repeat1] = "decorated_definition_repeat1",
  [aux_sym_dotted_name_repeat1] = "dotted_name_repeat1",
  [aux_sym_union_pattern_repeat1] = "union_pattern_repeat1",
  [aux_sym_dict_pattern_repeat1] = "dict_pattern_repeat1",
  [aux_sym__parameters_repeat1] = "_parameters_repeat1",
  [aux_sym__patterns_repeat1] = "_patterns_repeat1",
  [aux_sym_comparison_operator_repeat1] = "comparison_operator_repeat1",
  [aux_sym_subscript_repeat1] = "subscript_repeat1",
  [aux_sym_dictionary_repeat1] = "dictionary_repeat1",
  [aux_sym__comprehension_clauses_repeat1] = "_comprehension_clauses_repeat1",
  [aux_sym__collection_elements_repeat1] = "_collection_elements_repeat1",
  [aux_sym_for_in_clause_repeat1] = "for_in_clause_repeat1",
  [aux_sym_concatenated_string_repeat1] = "concatenated_string_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_content_repeat1] = "string_content_repeat1",
  [aux_sym_format_specifier_repeat1] = "format_specifier_repeat1",
  [alias_sym_as_pattern_target] = "as_pattern_target",
  [alias_sym_format_expression] = "format_expression",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_from] = anon_sym_from,
  [anon_sym___future__] = anon_sym___future__,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_print] = anon_sym_print,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_del] = anon_sym_del,
  [anon_sym_raise] = anon_sym_raise,
  [anon_sym_pass] = anon_sym_pass,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_elif] = anon_sym_elif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_match] = anon_sym_match,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_except] = anon_sym_except,
  [anon_sym_except_STAR] = anon_sym_except_STAR,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_def] = anon_sym_def,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_nonlocal] = anon_sym_nonlocal,
  [anon_sym_exec] = anon_sym_exec,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym__] = anon_sym__,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_lambda] = anon_sym_lambda,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_AT_EQ] = anon_sym_AT_EQ,
  [anon_sym_SLASH_SLASH_EQ] = anon_sym_SLASH_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_yield] = anon_sym_yield,
  [sym_ellipsis] = sym_ellipsis,
  [sym_escape_sequence] = sym_escape_sequence,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [aux_sym_format_specifier_token1] = aux_sym_format_specifier_token1,
  [sym_type_conversion] = sym_type_conversion,
  [sym_integer] = sym_integer,
  [sym_float] = sym_float,
  [anon_sym_await] = anon_sym_await,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_none] = sym_none,
  [sym_comment] = sym_comment,
  [sym_line_continuation] = sym_line_continuation,
  [sym__newline] = sym__newline,
  [sym__indent] = sym__indent,
  [sym__dedent] = sym__dedent,
  [sym_string_start] = sym_string_start,
  [sym__string_content] = sym__string_content,
  [sym_escape_interpolation] = sym_escape_interpolation,
  [sym_string_end] = sym_string_end,
  [sym_module] = sym_module,
  [sym__statement] = sym__statement,
  [sym__simple_statements] = sym__simple_statements,
  [sym_import_statement] = sym_import_statement,
  [sym_import_prefix] = sym_import_prefix,
  [sym_relative_import] = sym_relative_import,
  [sym_future_import_statement] = sym_future_import_statement,
  [sym_import_from_statement] = sym_import_from_statement,
  [sym__import_list] = sym__import_list,
  [sym_aliased_import] = sym_aliased_import,
  [sym_wildcard_import] = sym_wildcard_import,
  [sym_print_statement] = sym_print_statement,
  [sym_chevron] = sym_chevron,
  [sym_assert_statement] = sym_assert_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_named_expression] = sym_named_expression,
  [sym__named_expression_lhs] = sym__named_expression_lhs,
  [sym_return_statement] = sym_return_statement,
  [sym_delete_statement] = sym_delete_statement,
  [sym_raise_statement] = sym_raise_statement,
  [sym_pass_statement] = sym_pass_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_elif_clause] = sym_elif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_match_statement] = sym_match_statement,
  [sym__match_block] = sym_block,
  [sym_case_clause] = sym_case_clause,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_except_clause] = sym_except_clause,
  [sym_except_group_clause] = sym_except_group_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_with_statement] = sym_with_statement,
  [sym_with_clause] = sym_with_clause,
  [sym_with_item] = sym_with_item,
  [sym_function_definition] = sym_function_definition,
  [sym_parameters] = sym_parameters,
  [sym_lambda_parameters] = sym_lambda_parameters,
  [sym_list_splat] = sym_list_splat,
  [sym_dictionary_splat] = sym_dictionary_splat,
  [sym_global_statement] = sym_global_statement,
  [sym_nonlocal_statement] = sym_nonlocal_statement,
  [sym_exec_statement] = sym_exec_statement,
  [sym_type_alias_statement] = sym_type_alias_statement,
  [sym_class_definition] = sym_class_definition,
  [sym_type_parameter] = sym_type_parameter,
  [sym_parenthesized_list_splat] = sym_parenthesized_list_splat,
  [sym_argument_list] = sym_argument_list,
  [sym_decorated_definition] = sym_decorated_definition,
  [sym_decorator] = sym_decorator,
  [sym_block] = sym_block,
  [sym_expression_list] = sym_expression_list,
  [sym_dotted_name] = sym_dotted_name,
  [sym_case_pattern] = sym_case_pattern,
  [sym__simple_pattern] = sym__simple_pattern,
  [sym__as_pattern] = sym_as_pattern,
  [sym_union_pattern] = sym_union_pattern,
  [sym__list_pattern] = sym_list_pattern,
  [sym__tuple_pattern] = sym_tuple_pattern,
  [sym_dict_pattern] = sym_dict_pattern,
  [sym__key_value_pattern] = sym__key_value_pattern,
  [sym_keyword_pattern] = sym_keyword_pattern,
  [sym_splat_pattern] = sym_splat_pattern,
  [sym_class_pattern] = sym_class_pattern,
  [sym_complex_pattern] = sym_complex_pattern,
  [sym__parameters] = sym__parameters,
  [sym__patterns] = sym__patterns,
  [sym_parameter] = sym_parameter,
  [sym_pattern] = sym_pattern,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym_list_pattern] = sym_list_pattern,
  [sym_default_parameter] = sym_default_parameter,
  [sym_typed_default_parameter] = sym_typed_default_parameter,
  [sym_list_splat_pattern] = sym_list_splat_pattern,
  [sym_dictionary_splat_pattern] = sym_dictionary_splat_pattern,
  [sym_as_pattern] = sym_as_pattern,
  [sym__expression_within_for_in_clause] = sym__expression_within_for_in_clause,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_not_operator] = sym_not_operator,
  [sym_boolean_operator] = sym_boolean_operator,
  [sym_binary_operator] = sym_binary_operator,
  [sym_unary_operator] = sym_unary_operator,
  [sym__not_in] = sym__not_in,
  [sym__is_not] = sym__is_not,
  [sym_comparison_operator] = sym_comparison_operator,
  [sym_lambda] = sym_lambda,
  [sym_lambda_within_for_in_clause] = sym_lambda,
  [sym_assignment] = sym_assignment,
  [sym_augmented_assignment] = sym_augmented_assignment,
  [sym_pattern_list] = sym_pattern_list,
  [sym__right_hand_side] = sym__right_hand_side,
  [sym_yield] = sym_yield,
  [sym_attribute] = sym_attribute,
  [sym_subscript] = sym_subscript,
  [sym_slice] = sym_slice,
  [sym_call] = sym_call,
  [sym_typed_parameter] = sym_typed_parameter,
  [sym_type] = sym_type,
  [sym_splat_type] = sym_splat_type,
  [sym_generic_type] = sym_generic_type,
  [sym_union_type] = sym_union_type,
  [sym_constrained_type] = sym_constrained_type,
  [sym_member_type] = sym_member_type,
  [sym_keyword_argument] = sym_keyword_argument,
  [sym_list] = sym_list,
  [sym_set] = sym_set,
  [sym_tuple] = sym_tuple,
  [sym_dictionary] = sym_dictionary,
  [sym_pair] = sym_pair,
  [sym_list_comprehension] = sym_list_comprehension,
  [sym_dictionary_comprehension] = sym_dictionary_comprehension,
  [sym_set_comprehension] = sym_set_comprehension,
  [sym_generator_expression] = sym_generator_expression,
  [sym__comprehension_clauses] = sym__comprehension_clauses,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym__collection_elements] = sym__collection_elements,
  [sym_for_in_clause] = sym_for_in_clause,
  [sym_if_clause] = sym_if_clause,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_concatenated_string] = sym_concatenated_string,
  [sym_string] = sym_string,
  [sym_string_content] = sym_string_content,
  [sym_interpolation] = sym_interpolation,
  [sym__f_expression] = sym__f_expression,
  [sym__not_escape_sequence] = sym__not_escape_sequence,
  [sym_format_specifier] = sym_format_specifier,
  [sym_await] = sym_await,
  [sym_positional_separator] = sym_positional_separator,
  [sym_keyword_separator] = sym_keyword_separator,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [aux_sym__simple_statements_repeat1] = aux_sym__simple_statements_repeat1,
  [aux_sym_import_prefix_repeat1] = aux_sym_import_prefix_repeat1,
  [aux_sym__import_list_repeat1] = aux_sym__import_list_repeat1,
  [aux_sym_print_statement_repeat1] = aux_sym_print_statement_repeat1,
  [aux_sym_assert_statement_repeat1] = aux_sym_assert_statement_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_match_statement_repeat1] = aux_sym_match_statement_repeat1,
  [aux_sym__match_block_repeat1] = aux_sym__match_block_repeat1,
  [aux_sym_case_clause_repeat1] = aux_sym_case_clause_repeat1,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym_try_statement_repeat2] = aux_sym_try_statement_repeat2,
  [aux_sym_with_clause_repeat1] = aux_sym_with_clause_repeat1,
  [aux_sym_global_statement_repeat1] = aux_sym_global_statement_repeat1,
  [aux_sym_type_parameter_repeat1] = aux_sym_type_parameter_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_decorated_definition_repeat1] = aux_sym_decorated_definition_repeat1,
  [aux_sym_dotted_name_repeat1] = aux_sym_dotted_name_repeat1,
  [aux_sym_union_pattern_repeat1] = aux_sym_union_pattern_repeat1,
  [aux_sym_dict_pattern_repeat1] = aux_sym_dict_pattern_repeat1,
  [aux_sym__parameters_repeat1] = aux_sym__parameters_repeat1,
  [aux_sym__patterns_repeat1] = aux_sym__patterns_repeat1,
  [aux_sym_comparison_operator_repeat1] = aux_sym_comparison_operator_repeat1,
  [aux_sym_subscript_repeat1] = aux_sym_subscript_repeat1,
  [aux_sym_dictionary_repeat1] = aux_sym_dictionary_repeat1,
  [aux_sym__comprehension_clauses_repeat1] = aux_sym__comprehension_clauses_repeat1,
  [aux_sym__collection_elements_repeat1] = aux_sym__collection_elements_repeat1,
  [aux_sym_for_in_clause_repeat1] = aux_sym_for_in_clause_repeat1,
  [aux_sym_concatenated_string_repeat1] = aux_sym_concatenated_string_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_content_repeat1] = aux_sym_string_content_repeat1,
  [aux_sym_format_specifier_repeat1] = aux_sym_format_specifier_repeat1,
  [alias_sym_as_pattern_target] = alias_sym_as_pattern_target,
  [alias_sym_format_expression] = alias_sym_format_expression,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___future__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_print] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_del] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_raise] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pass] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_except] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_except_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_def] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nonlocal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lambda] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [sym_ellipsis] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_format_specifier_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_type_conversion] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_none] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_line_continuation] = {
    .visible = true,
    .named = true,
  },
  [sym__newline] = {
    .visible = false,
    .named = true,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym__dedent] = {
    .visible = false,
    .named = true,
  },
  [sym_string_start] = {
    .visible = true,
    .named = true,
  },
  [sym__string_content] = {
    .visible = false,
    .named = true,
  },
  [sym_escape_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_string_end] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__simple_statements] = {
    .visible = false,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_prefix] = {
    .visible = true,
    .named = true,
  },
  [sym_relative_import] = {
    .visible = true,
    .named = true,
  },
  [sym_future_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_from_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__import_list] = {
    .visible = false,
    .named = true,
  },
  [sym_aliased_import] = {
    .visible = true,
    .named = true,
  },
  [sym_wildcard_import] = {
    .visible = true,
    .named = true,
  },
  [sym_print_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_chevron] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_named_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__named_expression_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_delete_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_raise_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_pass_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_match_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__match_block] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_except_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_except_group_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_with_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_list_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_global_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_nonlocal_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_exec_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_class_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_list_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_decorated_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_dotted_name] = {
    .visible = true,
    .named = true,
  },
  [sym_case_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym__as_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_union_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_dict_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__key_value_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_keyword_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_class_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_complex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__parameters] = {
    .visible = false,
    .named = true,
  },
  [sym__patterns] = {
    .visible = false,
    .named = true,
  },
  [sym_parameter] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_list_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_as_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_within_for_in_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_not_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym__not_in] = {
    .visible = true,
    .named = false,
  },
  [sym__is_not] = {
    .visible = true,
    .named = false,
  },
  [sym_comparison_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_within_for_in_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_augmented_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_list] = {
    .visible = true,
    .named = true,
  },
  [sym__right_hand_side] = {
    .visible = false,
    .named = true,
  },
  [sym_yield] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_slice] = {
    .visible = true,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_splat_type] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constrained_type] = {
    .visible = true,
    .named = true,
  },
  [sym_member_type] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_set] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_list_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_set_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__comprehension_clauses] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__collection_elements] = {
    .visible = false,
    .named = true,
  },
  [sym_for_in_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenated_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string_content] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym__f_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__not_escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [sym_format_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_await] = {
    .visible = true,
    .named = true,
  },
  [sym_positional_separator] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_separator] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__simple_statements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_prefix_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__import_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_print_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_assert_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_match_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__match_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_with_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_global_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameter_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_decorated_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dotted_name_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dict_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__patterns_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_comparison_operator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_subscript_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dictionary_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__comprehension_clauses_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__collection_elements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_in_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenated_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_format_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_as_pattern_target] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_format_expression] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_attribute = 5,
  field_body = 6,
  field_cause = 7,
  field_code = 8,
  field_condition = 9,
  field_consequence = 10,
  field_definition = 11,
  field_expression = 12,
  field_format_specifier = 13,
  field_function = 14,
  field_guard = 15,
  field_key = 16,
  field_left = 17,
  field_module_name = 18,
  field_name = 19,
  field_object = 20,
  field_operator = 21,
  field_operators = 22,
  field_parameters = 23,
  field_return_type = 24,
  field_right = 25,
  field_subject = 26,
  field_subscript = 27,
  field_superclasses = 28,
  field_type = 29,
  field_type_conversion = 30,
  field_type_parameters = 31,
  field_value = 32,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_cause] = "cause",
  [field_code] = "code",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_definition] = "definition",
  [field_expression] = "expression",
  [field_format_specifier] = "format_specifier",
  [field_function] = "function",
  [field_guard] = "guard",
  [field_key] = "key",
  [field_left] = "left",
  [field_module_name] = "module_name",
  [field_name] = "name",
  [field_object] = "object",
  [field_operator] = "operator",
  [field_operators] = "operators",
  [field_parameters] = "parameters",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_subject] = "subject",
  [field_subscript] = "subscript",
  [field_superclasses] = "superclasses",
  [field_type] = "type",
  [field_type_conversion] = "type_conversion",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [3] = {.index = 0, .length = 1},
  [4] = {.index = 1, .length = 1},
  [6] = {.index = 2, .length = 1},
  [7] = {.index = 3, .length = 1},
  [8] = {.index = 4, .length = 1},
  [9] = {.index = 5, .length = 2},
  [10] = {.index = 7, .length = 2},
  [11] = {.index = 9, .length = 1},
  [12] = {.index = 10, .length = 1},
  [13] = {.index = 11, .length = 2},
  [14] = {.index = 13, .length = 1},
  [15] = {.index = 14, .length = 2},
  [16] = {.index = 16, .length = 1},
  [17] = {.index = 17, .length = 1},
  [18] = {.index = 18, .length = 2},
  [19] = {.index = 20, .length = 2},
  [20] = {.index = 22, .length = 2},
  [21] = {.index = 24, .length = 3},
  [22] = {.index = 27, .length = 1},
  [23] = {.index = 28, .length = 2},
  [24] = {.index = 30, .length = 1},
  [25] = {.index = 31, .length = 2},
  [26] = {.index = 33, .length = 1},
  [27] = {.index = 34, .length = 1},
  [28] = {.index = 35, .length = 2},
  [29] = {.index = 37, .length = 2},
  [30] = {.index = 39, .length = 1},
  [31] = {.index = 40, .length = 2},
  [32] = {.index = 42, .length = 1},
  [34] = {.index = 43, .length = 1},
  [35] = {.index = 44, .length = 2},
  [36] = {.index = 46, .length = 1},
  [37] = {.index = 47, .length = 2},
  [38] = {.index = 49, .length = 1},
  [39] = {.index = 50, .length = 3},
  [40] = {.index = 53, .length = 2},
  [41] = {.index = 55, .length = 2},
  [42] = {.index = 17, .length = 1},
  [43] = {.index = 57, .length = 1},
  [44] = {.index = 58, .length = 2},
  [45] = {.index = 60, .length = 2},
  [46] = {.index = 62, .length = 2},
  [47] = {.index = 64, .length = 1},
  [48] = {.index = 65, .length = 2},
  [49] = {.index = 67, .length = 2},
  [51] = {.index = 69, .length = 2},
  [52] = {.index = 71, .length = 2},
  [53] = {.index = 73, .length = 1},
  [54] = {.index = 74, .length = 3},
  [55] = {.index = 77, .length = 3},
  [56] = {.index = 80, .length = 3},
  [57] = {.index = 83, .length = 3},
  [58] = {.index = 86, .length = 4},
  [59] = {.index = 90, .length = 1},
  [60] = {.index = 91, .length = 3},
  [61] = {.index = 94, .length = 3},
  [62] = {.index = 97, .length = 2},
  [63] = {.index = 99, .length = 2},
  [64] = {.index = 101, .length = 3},
  [65] = {.index = 104, .length = 3},
  [66] = {.index = 107, .length = 3},
  [67] = {.index = 110, .length = 3},
  [68] = {.index = 113, .length = 3},
  [69] = {.index = 18, .length = 2},
  [70] = {.index = 116, .length = 1},
  [71] = {.index = 117, .length = 3},
  [72] = {.index = 120, .length = 2},
  [73] = {.index = 122, .length = 2},
  [74] = {.index = 124, .length = 2},
  [75] = {.index = 126, .length = 3},
  [76] = {.index = 129, .length = 1},
  [77] = {.index = 130, .length = 2},
  [78] = {.index = 132, .length = 4},
  [79] = {.index = 136, .length = 2},
  [80] = {.index = 138, .length = 4},
  [81] = {.index = 142, .length = 4},
  [82] = {.index = 146, .length = 1},
  [83] = {.index = 147, .length = 4},
  [84] = {.index = 151, .length = 2},
  [85] = {.index = 153, .length = 3},
  [86] = {.index = 156, .length = 3},
  [87] = {.index = 159, .length = 4},
  [89] = {.index = 163, .length = 4},
  [90] = {.index = 167, .length = 4},
  [91] = {.index = 171, .length = 4},
  [92] = {.index = 175, .length = 4},
  [93] = {.index = 179, .length = 4},
  [94] = {.index = 183, .length = 3},
  [95] = {.index = 186, .length = 3},
  [96] = {.index = 189, .length = 2},
  [97] = {.index = 191, .length = 3},
  [98] = {.index = 194, .length = 5},
  [99] = {.index = 199, .length = 3},
  [100] = {.index = 202, .length = 4},
  [101] = {.index = 206, .length = 4},
  [102] = {.index = 210, .length = 4},
  [103] = {.index = 214, .length = 4},
  [104] = {.index = 218, .length = 1},
  [106] = {.index = 219, .length = 4},
  [107] = {.index = 223, .length = 5},
  [108] = {.index = 228, .length = 5},
  [109] = {.index = 233, .length = 3},
  [110] = {.index = 236, .length = 2},
  [111] = {.index = 238, .length = 1},
  [112] = {.index = 239, .length = 4},
  [113] = {.index = 243, .length = 4},
  [114] = {.index = 247, .length = 4},
  [115] = {.index = 251, .length = 5},
  [116] = {.index = 256, .length = 5},
  [117] = {.index = 218, .length = 1},
  [118] = {.index = 261, .length = 5},
  [119] = {.index = 266, .length = 5},
  [120] = {.index = 271, .length = 4},
  [121] = {.index = 275, .length = 4},
  [122] = {.index = 279, .length = 2},
  [123] = {.index = 281, .length = 1},
  [124] = {.index = 282, .length = 2},
  [125] = {.index = 284, .length = 2},
  [126] = {.index = 286, .length = 5},
  [127] = {.index = 291, .length = 5},
  [128] = {.index = 296, .length = 5},
  [129] = {.index = 301, .length = 2},
  [131] = {.index = 303, .length = 6},
  [132] = {.index = 309, .length = 2},
  [133] = {.index = 311, .length = 2},
  [134] = {.index = 313, .length = 3},
  [135] = {.index = 316, .length = 1},
  [136] = {.index = 317, .length = 6},
  [137] = {.index = 301, .length = 2},
  [138] = {.index = 323, .length = 3},
  [139] = {.index = 326, .length = 2},
  [140] = {.index = 328, .length = 2},
  [141] = {.index = 330, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 1, .inherited = true},
  [1] =
    {field_name, 0},
  [2] =
    {field_argument, 1},
  [3] =
    {field_value, 0},
  [4] =
    {field_code, 1},
  [5] =
    {field_argument, 1},
    {field_operator, 0},
  [7] =
    {field_arguments, 1},
    {field_function, 0},
  [9] =
    {field_operators, 1, .inherited = true},
  [10] =
    {field_definition, 1},
  [11] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
  [13] =
    {field_argument, 2, .inherited = true},
  [14] =
    {field_argument, 1},
    {field_argument, 2, .inherited = true},
  [16] =
    {field_cause, 2},
  [17] =
    {field_body, 2},
  [18] =
    {field_name, 0},
    {field_value, 2},
  [20] =
    {field_left, 0},
    {field_type, 2},
  [22] =
    {field_left, 0},
    {field_right, 2},
  [24] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [27] =
    {field_alias, 2},
  [28] =
    {field_attribute, 2},
    {field_object, 0},
  [30] =
    {field_operators, 0},
  [31] =
    {field_operators, 0, .inherited = true},
    {field_operators, 1, .inherited = true},
  [33] =
    {field_expression, 1},
  [34] =
    {field_name, 1},
  [35] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [37] =
    {field_alias, 2},
    {field_name, 0},
  [39] =
    {field_name, 3, .inherited = true},
  [40] =
    {field_module_name, 1},
    {field_name, 3, .inherited = true},
  [42] =
    {field_module_name, 1},
  [43] =
    {field_body, 1},
  [44] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [46] =
    {field_cause, 3},
  [47] =
    {field_condition, 1},
    {field_consequence, 3},
  [49] =
    {field_subject, 1},
  [50] =
    {field_alternative, 3, .inherited = true},
    {field_body, 3},
    {field_subject, 1},
  [53] =
    {field_subject, 0, .inherited = true},
    {field_subject, 1, .inherited = true},
  [55] =
    {field_body, 3},
    {field_condition, 1},
  [57] =
    {field_body, 3},
  [58] =
    {field_left, 1},
    {field_right, 3},
  [60] =
    {field_body, 3},
    {field_name, 1},
  [62] =
    {field_key, 0},
    {field_value, 2},
  [64] =
    {field_type, 2},
  [65] =
    {field_body, 3},
    {field_parameters, 1},
  [67] =
    {field_subscript, 2},
    {field_value, 0},
  [69] =
    {field_expression, 1},
    {field_type_conversion, 2},
  [71] =
    {field_expression, 1},
    {field_format_specifier, 2},
  [73] =
    {field_alternative, 0},
  [74] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 3},
  [77] =
    {field_alternative, 4, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
  [80] =
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [83] =
    {field_alternative, 4, .inherited = true},
    {field_body, 4},
    {field_subject, 1},
  [86] =
    {field_alternative, 4, .inherited = true},
    {field_body, 4},
    {field_subject, 1},
    {field_subject, 2, .inherited = true},
  [90] =
    {field_body, 4},
  [91] =
    {field_alternative, 4},
    {field_body, 3},
    {field_condition, 1},
  [94] =
    {field_body, 3},
    {field_body, 4},
    {field_condition, 1},
  [97] =
    {field_body, 2},
    {field_body, 3},
  [99] =
    {field_body, 3},
    {field_body, 4},
  [101] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 2},
  [104] =
    {field_body, 3},
    {field_body, 4},
    {field_name, 1},
  [107] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [110] =
    {field_body, 4},
    {field_name, 1},
    {field_superclasses, 2},
  [113] =
    {field_left, 0},
    {field_right, 4},
    {field_type, 2},
  [116] =
    {field_subscript, 1},
  [117] =
    {field_subscript, 2},
    {field_subscript, 3, .inherited = true},
    {field_value, 0},
  [120] =
    {field_subscript, 0, .inherited = true},
    {field_subscript, 1, .inherited = true},
  [122] =
    {field_expression, 1},
    {field_type_conversion, 3},
  [124] =
    {field_expression, 1},
    {field_format_specifier, 3},
  [126] =
    {field_expression, 1},
    {field_format_specifier, 3},
    {field_type_conversion, 2},
  [129] =
    {field_name, 4, .inherited = true},
  [130] =
    {field_module_name, 1},
    {field_name, 4, .inherited = true},
  [132] =
    {field_alternative, 4, .inherited = true},
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
  [136] =
    {field_alternative, 0, .inherited = true},
    {field_alternative, 1, .inherited = true},
  [138] =
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [142] =
    {field_alternative, 5, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [146] =
    {field_alternative, 1, .inherited = true},
  [147] =
    {field_alternative, 5, .inherited = true},
    {field_body, 5},
    {field_subject, 1},
    {field_subject, 2, .inherited = true},
  [151] =
    {field_body, 4},
    {field_body, 5},
  [153] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 3},
  [156] =
    {field_body, 5},
    {field_left, 1},
    {field_right, 3},
  [159] =
    {field_alternative, 5},
    {field_body, 3},
    {field_body, 4},
    {field_condition, 1},
  [163] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 2},
  [167] =
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [171] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_type_parameters, 2},
  [175] =
    {field_body, 5},
    {field_name, 1},
    {field_superclasses, 3},
    {field_type_parameters, 2},
  [179] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_superclasses, 2},
  [183] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 4},
  [186] =
    {field_expression, 1},
    {field_format_specifier, 4},
    {field_type_conversion, 3},
  [189] =
    {field_left, 2},
    {field_right, 4},
  [191] =
    {field_left, 1},
    {field_right, 3},
    {field_right, 4},
  [194] =
    {field_alternative, 5, .inherited = true},
    {field_alternative, 6},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [199] =
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [202] =
    {field_body, 5},
    {field_body, 6},
    {field_name, 2},
    {field_parameters, 3},
  [206] =
    {field_body, 6},
    {field_name, 2},
    {field_parameters, 4},
    {field_type_parameters, 3},
  [210] =
    {field_alternative, 6},
    {field_body, 5},
    {field_left, 1},
    {field_right, 3},
  [214] =
    {field_body, 5},
    {field_body, 6},
    {field_left, 1},
    {field_right, 3},
  [218] =
    {field_value, 1},
  [219] =
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [223] =
    {field_body, 5},
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [228] =
    {field_body, 5},
    {field_body, 6},
    {field_name, 1},
    {field_superclasses, 3},
    {field_type_parameters, 2},
  [233] =
    {field_left, 2},
    {field_right, 4},
    {field_right, 5},
  [236] =
    {field_key, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [238] =
    {field_consequence, 3},
  [239] =
    {field_alternative, 7},
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [243] =
    {field_body, 6},
    {field_body, 7},
    {field_left, 2},
    {field_right, 4},
  [247] =
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [251] =
    {field_body, 6},
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 4},
    {field_type_parameters, 3},
  [256] =
    {field_alternative, 7},
    {field_body, 5},
    {field_body, 6},
    {field_left, 1},
    {field_right, 3},
  [261] =
    {field_body, 6},
    {field_body, 7},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [266] =
    {field_body, 7},
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 5},
    {field_type_parameters, 2},
  [271] =
    {field_key, 1, .inherited = true},
    {field_key, 2, .inherited = true},
    {field_value, 1, .inherited = true},
    {field_value, 2, .inherited = true},
  [275] =
    {field_key, 0, .inherited = true},
    {field_key, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [279] =
    {field_key, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [281] =
    {field_consequence, 4},
  [282] =
    {field_consequence, 3},
    {field_consequence, 4},
  [284] =
    {field_consequence, 4},
    {field_guard, 2},
  [286] =
    {field_alternative, 8},
    {field_body, 6},
    {field_body, 7},
    {field_left, 2},
    {field_right, 4},
  [291] =
    {field_body, 7},
    {field_body, 8},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [296] =
    {field_body, 8},
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 6},
    {field_type_parameters, 3},
  [301] =
    {field_alias, 3},
    {field_value, 1},
  [303] =
    {field_body, 7},
    {field_body, 8},
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 5},
    {field_type_parameters, 2},
  [309] =
    {field_consequence, 4},
    {field_consequence, 5},
  [311] =
    {field_consequence, 5},
    {field_guard, 3},
  [313] =
    {field_consequence, 4},
    {field_consequence, 5},
    {field_guard, 2},
  [316] =
    {field_consequence, 5},
  [317] =
    {field_body, 8},
    {field_body, 9},
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 6},
    {field_type_parameters, 3},
  [323] =
    {field_consequence, 5},
    {field_consequence, 6},
    {field_guard, 3},
  [326] =
    {field_consequence, 5},
    {field_consequence, 6},
  [328] =
    {field_consequence, 6},
    {field_guard, 4},
  [330] =
    {field_consequence, 6},
    {field_consequence, 7},
    {field_guard, 4},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [2] = {
    [0] = sym_list_splat,
  },
  [5] = {
    [1] = sym_identifier,
  },
  [22] = {
    [2] = alias_sym_as_pattern_target,
  },
  [33] = {
    [1] = sym_parenthesized_expression,
  },
  [37] = {
    [3] = sym_block,
  },
  [41] = {
    [3] = sym_block,
  },
  [42] = {
    [2] = sym_block,
  },
  [43] = {
    [3] = sym_block,
  },
  [45] = {
    [3] = sym_block,
  },
  [50] = {
    [0] = alias_sym_format_expression,
  },
  [54] = {
    [3] = sym_block,
  },
  [55] = {
    [3] = sym_block,
  },
  [59] = {
    [4] = sym_block,
  },
  [60] = {
    [3] = sym_block,
  },
  [64] = {
    [4] = sym_block,
  },
  [66] = {
    [4] = sym_block,
  },
  [67] = {
    [4] = sym_block,
  },
  [69] = {
    [0] = sym_identifier,
  },
  [78] = {
    [3] = sym_block,
  },
  [85] = {
    [5] = sym_block,
  },
  [86] = {
    [5] = sym_block,
  },
  [88] = {
    [2] = sym_block,
  },
  [90] = {
    [5] = sym_block,
  },
  [92] = {
    [5] = sym_block,
  },
  [99] = {
    [6] = sym_block,
  },
  [101] = {
    [6] = sym_block,
  },
  [102] = {
    [5] = sym_block,
  },
  [104] = {
    [3] = sym_block,
  },
  [105] = {
    [3] = sym_block,
  },
  [106] = {
    [6] = sym_block,
  },
  [111] = {
    [3] = sym_block,
  },
  [112] = {
    [6] = sym_block,
  },
  [114] = {
    [7] = sym_block,
  },
  [119] = {
    [7] = sym_block,
  },
  [123] = {
    [4] = sym_block,
  },
  [125] = {
    [4] = sym_block,
  },
  [128] = {
    [8] = sym_block,
  },
  [129] = {
    [5] = sym_block,
  },
  [130] = {
    [5] = sym_block,
  },
  [133] = {
    [5] = sym_block,
  },
  [135] = {
    [5] = sym_block,
  },
  [140] = {
    [6] = sym_block,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__simple_statements, 2,
    sym__simple_statements,
    sym_block,
  sym_parenthesized_list_splat, 2,
    sym_parenthesized_list_splat,
    sym_parenthesized_expression,
  sym_list_splat_pattern, 2,
    sym_list_splat_pattern,
    sym_list_splat,
  sym_expression, 2,
    sym_expression,
    alias_sym_as_pattern_target,
  sym_interpolation, 2,
    sym_interpolation,
    alias_sym_format_expression,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 2,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 3,
  [36] = 4,
  [37] = 5,
  [38] = 6,
  [39] = 7,
  [40] = 8,
  [41] = 9,
  [42] = 10,
  [43] = 11,
  [44] = 12,
  [45] = 13,
  [46] = 14,
  [47] = 15,
  [48] = 34,
  [49] = 17,
  [50] = 18,
  [51] = 19,
  [52] = 20,
  [53] = 21,
  [54] = 22,
  [55] = 24,
  [56] = 25,
  [57] = 28,
  [58] = 29,
  [59] = 59,
  [60] = 30,
  [61] = 59,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 62,
  [66] = 62,
  [67] = 63,
  [68] = 62,
  [69] = 62,
  [70] = 62,
  [71] = 62,
  [72] = 62,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 75,
  [78] = 78,
  [79] = 78,
  [80] = 80,
  [81] = 80,
  [82] = 76,
  [83] = 83,
  [84] = 83,
  [85] = 85,
  [86] = 85,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 97,
  [107] = 107,
  [108] = 92,
  [109] = 96,
  [110] = 88,
  [111] = 95,
  [112] = 99,
  [113] = 113,
  [114] = 114,
  [115] = 90,
  [116] = 116,
  [117] = 98,
  [118] = 91,
  [119] = 119,
  [120] = 102,
  [121] = 121,
  [122] = 113,
  [123] = 103,
  [124] = 121,
  [125] = 93,
  [126] = 126,
  [127] = 104,
  [128] = 94,
  [129] = 100,
  [130] = 87,
  [131] = 107,
  [132] = 126,
  [133] = 114,
  [134] = 134,
  [135] = 135,
  [136] = 89,
  [137] = 137,
  [138] = 138,
  [139] = 138,
  [140] = 137,
  [141] = 138,
  [142] = 137,
  [143] = 138,
  [144] = 137,
  [145] = 137,
  [146] = 138,
  [147] = 137,
  [148] = 138,
  [149] = 137,
  [150] = 138,
  [151] = 137,
  [152] = 138,
  [153] = 153,
  [154] = 154,
  [155] = 154,
  [156] = 156,
  [157] = 157,
  [158] = 154,
  [159] = 156,
  [160] = 156,
  [161] = 161,
  [162] = 157,
  [163] = 157,
  [164] = 164,
  [165] = 157,
  [166] = 164,
  [167] = 167,
  [168] = 156,
  [169] = 157,
  [170] = 157,
  [171] = 161,
  [172] = 167,
  [173] = 161,
  [174] = 154,
  [175] = 157,
  [176] = 161,
  [177] = 154,
  [178] = 156,
  [179] = 164,
  [180] = 180,
  [181] = 161,
  [182] = 156,
  [183] = 157,
  [184] = 161,
  [185] = 161,
  [186] = 161,
  [187] = 180,
  [188] = 156,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 190,
  [194] = 190,
  [195] = 191,
  [196] = 192,
  [197] = 190,
  [198] = 198,
  [199] = 198,
  [200] = 191,
  [201] = 192,
  [202] = 190,
  [203] = 191,
  [204] = 192,
  [205] = 190,
  [206] = 192,
  [207] = 191,
  [208] = 192,
  [209] = 190,
  [210] = 191,
  [211] = 191,
  [212] = 212,
  [213] = 191,
  [214] = 192,
  [215] = 190,
  [216] = 192,
  [217] = 217,
  [218] = 218,
  [219] = 191,
  [220] = 192,
  [221] = 192,
  [222] = 192,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 226,
  [228] = 228,
  [229] = 228,
  [230] = 228,
  [231] = 228,
  [232] = 225,
  [233] = 226,
  [234] = 226,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 235,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 237,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 244,
  [247] = 244,
  [248] = 248,
  [249] = 224,
  [250] = 244,
  [251] = 251,
  [252] = 244,
  [253] = 253,
  [254] = 237,
  [255] = 255,
  [256] = 244,
  [257] = 236,
  [258] = 237,
  [259] = 244,
  [260] = 260,
  [261] = 235,
  [262] = 262,
  [263] = 235,
  [264] = 244,
  [265] = 255,
  [266] = 255,
  [267] = 255,
  [268] = 223,
  [269] = 240,
  [270] = 253,
  [271] = 248,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 273,
  [277] = 274,
  [278] = 278,
  [279] = 279,
  [280] = 275,
  [281] = 281,
  [282] = 275,
  [283] = 281,
  [284] = 284,
  [285] = 273,
  [286] = 274,
  [287] = 281,
  [288] = 278,
  [289] = 278,
  [290] = 279,
  [291] = 275,
  [292] = 281,
  [293] = 279,
  [294] = 273,
  [295] = 284,
  [296] = 284,
  [297] = 273,
  [298] = 278,
  [299] = 279,
  [300] = 278,
  [301] = 279,
  [302] = 275,
  [303] = 281,
  [304] = 281,
  [305] = 284,
  [306] = 273,
  [307] = 284,
  [308] = 273,
  [309] = 274,
  [310] = 284,
  [311] = 278,
  [312] = 279,
  [313] = 275,
  [314] = 281,
  [315] = 273,
  [316] = 274,
  [317] = 274,
  [318] = 278,
  [319] = 279,
  [320] = 284,
  [321] = 278,
  [322] = 279,
  [323] = 275,
  [324] = 281,
  [325] = 284,
  [326] = 275,
  [327] = 327,
  [328] = 327,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 330,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 330,
  [337] = 337,
  [338] = 331,
  [339] = 327,
  [340] = 340,
  [341] = 337,
  [342] = 337,
  [343] = 331,
  [344] = 329,
  [345] = 334,
  [346] = 329,
  [347] = 180,
  [348] = 334,
  [349] = 349,
  [350] = 245,
  [351] = 351,
  [352] = 352,
  [353] = 351,
  [354] = 351,
  [355] = 352,
  [356] = 352,
  [357] = 351,
  [358] = 352,
  [359] = 351,
  [360] = 351,
  [361] = 352,
  [362] = 362,
  [363] = 245,
  [364] = 349,
  [365] = 351,
  [366] = 352,
  [367] = 245,
  [368] = 352,
  [369] = 351,
  [370] = 352,
  [371] = 349,
  [372] = 156,
  [373] = 373,
  [374] = 374,
  [375] = 373,
  [376] = 376,
  [377] = 377,
  [378] = 373,
  [379] = 377,
  [380] = 333,
  [381] = 373,
  [382] = 374,
  [383] = 377,
  [384] = 374,
  [385] = 377,
  [386] = 373,
  [387] = 377,
  [388] = 374,
  [389] = 374,
  [390] = 377,
  [391] = 373,
  [392] = 373,
  [393] = 374,
  [394] = 377,
  [395] = 373,
  [396] = 373,
  [397] = 340,
  [398] = 374,
  [399] = 399,
  [400] = 374,
  [401] = 374,
  [402] = 402,
  [403] = 403,
  [404] = 377,
  [405] = 373,
  [406] = 374,
  [407] = 407,
  [408] = 377,
  [409] = 377,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 333,
  [414] = 414,
  [415] = 340,
  [416] = 156,
  [417] = 180,
  [418] = 333,
  [419] = 340,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 410,
  [424] = 424,
  [425] = 414,
  [426] = 426,
  [427] = 427,
  [428] = 424,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 430,
  [434] = 434,
  [435] = 435,
  [436] = 407,
  [437] = 434,
  [438] = 414,
  [439] = 180,
  [440] = 440,
  [441] = 441,
  [442] = 424,
  [443] = 430,
  [444] = 441,
  [445] = 435,
  [446] = 446,
  [447] = 447,
  [448] = 435,
  [449] = 180,
  [450] = 450,
  [451] = 451,
  [452] = 421,
  [453] = 421,
  [454] = 421,
  [455] = 421,
  [456] = 421,
  [457] = 421,
  [458] = 421,
  [459] = 421,
  [460] = 421,
  [461] = 441,
  [462] = 462,
  [463] = 463,
  [464] = 333,
  [465] = 340,
  [466] = 466,
  [467] = 467,
  [468] = 466,
  [469] = 469,
  [470] = 470,
  [471] = 471,
  [472] = 472,
  [473] = 467,
  [474] = 463,
  [475] = 475,
  [476] = 471,
  [477] = 462,
  [478] = 469,
  [479] = 475,
  [480] = 470,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 486,
  [487] = 487,
  [488] = 488,
  [489] = 489,
  [490] = 486,
  [491] = 482,
  [492] = 483,
  [493] = 485,
  [494] = 487,
  [495] = 495,
  [496] = 488,
  [497] = 489,
  [498] = 486,
  [499] = 482,
  [500] = 483,
  [501] = 485,
  [502] = 487,
  [503] = 503,
  [504] = 488,
  [505] = 489,
  [506] = 486,
  [507] = 482,
  [508] = 483,
  [509] = 485,
  [510] = 487,
  [511] = 482,
  [512] = 512,
  [513] = 513,
  [514] = 514,
  [515] = 515,
  [516] = 481,
  [517] = 517,
  [518] = 518,
  [519] = 519,
  [520] = 483,
  [521] = 521,
  [522] = 522,
  [523] = 523,
  [524] = 524,
  [525] = 513,
  [526] = 515,
  [527] = 527,
  [528] = 528,
  [529] = 483,
  [530] = 530,
  [531] = 485,
  [532] = 486,
  [533] = 487,
  [534] = 534,
  [535] = 488,
  [536] = 489,
  [537] = 537,
  [538] = 538,
  [539] = 539,
  [540] = 486,
  [541] = 541,
  [542] = 542,
  [543] = 523,
  [544] = 512,
  [545] = 513,
  [546] = 482,
  [547] = 517,
  [548] = 519,
  [549] = 485,
  [550] = 483,
  [551] = 551,
  [552] = 486,
  [553] = 482,
  [554] = 485,
  [555] = 542,
  [556] = 523,
  [557] = 512,
  [558] = 513,
  [559] = 559,
  [560] = 519,
  [561] = 519,
  [562] = 562,
  [563] = 512,
  [564] = 512,
  [565] = 513,
  [566] = 566,
  [567] = 514,
  [568] = 512,
  [569] = 513,
  [570] = 487,
  [571] = 571,
  [572] = 572,
  [573] = 573,
  [574] = 488,
  [575] = 542,
  [576] = 489,
  [577] = 486,
  [578] = 482,
  [579] = 483,
  [580] = 512,
  [581] = 488,
  [582] = 487,
  [583] = 523,
  [584] = 542,
  [585] = 512,
  [586] = 485,
  [587] = 489,
  [588] = 572,
  [589] = 573,
  [590] = 487,
  [591] = 551,
  [592] = 488,
  [593] = 551,
  [594] = 594,
  [595] = 551,
  [596] = 551,
  [597] = 551,
  [598] = 489,
  [599] = 551,
  [600] = 551,
  [601] = 488,
  [602] = 559,
  [603] = 518,
  [604] = 489,
  [605] = 571,
  [606] = 594,
  [607] = 495,
  [608] = 503,
  [609] = 527,
  [610] = 523,
  [611] = 611,
  [612] = 612,
  [613] = 613,
  [614] = 614,
  [615] = 615,
  [616] = 616,
  [617] = 612,
  [618] = 615,
  [619] = 619,
  [620] = 620,
  [621] = 621,
  [622] = 619,
  [623] = 620,
  [624] = 621,
  [625] = 614,
  [626] = 626,
  [627] = 626,
  [628] = 613,
  [629] = 629,
  [630] = 630,
  [631] = 631,
  [632] = 632,
  [633] = 630,
  [634] = 634,
  [635] = 635,
  [636] = 636,
  [637] = 637,
  [638] = 629,
  [639] = 639,
  [640] = 640,
  [641] = 641,
  [642] = 642,
  [643] = 643,
  [644] = 644,
  [645] = 640,
  [646] = 641,
  [647] = 644,
  [648] = 648,
  [649] = 649,
  [650] = 650,
  [651] = 651,
  [652] = 224,
  [653] = 653,
  [654] = 654,
  [655] = 653,
  [656] = 656,
  [657] = 656,
  [658] = 656,
  [659] = 659,
  [660] = 660,
  [661] = 661,
  [662] = 650,
  [663] = 654,
  [664] = 654,
  [665] = 665,
  [666] = 653,
  [667] = 659,
  [668] = 659,
  [669] = 661,
  [670] = 654,
  [671] = 671,
  [672] = 653,
  [673] = 673,
  [674] = 659,
  [675] = 675,
  [676] = 676,
  [677] = 650,
  [678] = 675,
  [679] = 679,
  [680] = 660,
  [681] = 679,
  [682] = 650,
  [683] = 650,
  [684] = 651,
  [685] = 223,
  [686] = 676,
  [687] = 673,
  [688] = 653,
  [689] = 659,
  [690] = 665,
  [691] = 659,
  [692] = 656,
  [693] = 656,
  [694] = 654,
  [695] = 654,
  [696] = 653,
  [697] = 656,
  [698] = 671,
  [699] = 699,
  [700] = 650,
  [701] = 699,
  [702] = 702,
  [703] = 703,
  [704] = 704,
  [705] = 703,
  [706] = 706,
  [707] = 704,
  [708] = 708,
  [709] = 709,
  [710] = 710,
  [711] = 709,
  [712] = 708,
  [713] = 713,
  [714] = 706,
  [715] = 715,
  [716] = 702,
  [717] = 713,
  [718] = 715,
  [719] = 719,
  [720] = 720,
  [721] = 720,
  [722] = 719,
  [723] = 710,
  [724] = 724,
  [725] = 724,
  [726] = 726,
  [727] = 727,
  [728] = 727,
  [729] = 726,
  [730] = 730,
  [731] = 731,
  [732] = 732,
  [733] = 733,
  [734] = 734,
  [735] = 735,
  [736] = 736,
  [737] = 737,
  [738] = 735,
  [739] = 739,
  [740] = 740,
  [741] = 741,
  [742] = 742,
  [743] = 743,
  [744] = 744,
  [745] = 740,
  [746] = 743,
  [747] = 747,
  [748] = 748,
  [749] = 749,
  [750] = 750,
  [751] = 744,
  [752] = 752,
  [753] = 753,
  [754] = 754,
  [755] = 755,
  [756] = 756,
  [757] = 757,
  [758] = 747,
  [759] = 748,
  [760] = 749,
  [761] = 750,
  [762] = 762,
  [763] = 763,
  [764] = 752,
  [765] = 765,
  [766] = 731,
  [767] = 767,
  [768] = 768,
  [769] = 769,
  [770] = 770,
  [771] = 771,
  [772] = 772,
  [773] = 773,
  [774] = 732,
  [775] = 733,
  [776] = 776,
  [777] = 777,
  [778] = 778,
  [779] = 779,
  [780] = 780,
  [781] = 781,
  [782] = 765,
  [783] = 783,
  [784] = 784,
  [785] = 785,
  [786] = 767,
  [787] = 787,
  [788] = 788,
  [789] = 768,
  [790] = 770,
  [791] = 791,
  [792] = 792,
  [793] = 793,
  [794] = 794,
  [795] = 742,
  [796] = 796,
  [797] = 772,
  [798] = 773,
  [799] = 799,
  [800] = 800,
  [801] = 801,
  [802] = 780,
  [803] = 803,
  [804] = 804,
  [805] = 777,
  [806] = 778,
  [807] = 807,
  [808] = 223,
  [809] = 756,
  [810] = 769,
  [811] = 776,
  [812] = 730,
  [813] = 803,
  [814] = 792,
  [815] = 800,
  [816] = 807,
  [817] = 753,
  [818] = 781,
  [819] = 793,
  [820] = 784,
  [821] = 791,
  [822] = 794,
  [823] = 823,
  [824] = 824,
  [825] = 736,
  [826] = 734,
  [827] = 762,
  [828] = 828,
  [829] = 801,
  [830] = 779,
  [831] = 824,
  [832] = 737,
  [833] = 763,
  [834] = 785,
  [835] = 788,
  [836] = 741,
  [837] = 804,
  [838] = 739,
  [839] = 823,
  [840] = 840,
  [841] = 840,
  [842] = 771,
  [843] = 754,
  [844] = 783,
  [845] = 757,
  [846] = 755,
  [847] = 787,
  [848] = 796,
  [849] = 799,
  [850] = 840,
  [851] = 771,
  [852] = 828,
  [853] = 224,
  [854] = 854,
  [855] = 854,
  [856] = 854,
  [857] = 854,
  [858] = 854,
  [859] = 854,
  [860] = 860,
  [861] = 860,
  [862] = 862,
  [863] = 862,
  [864] = 862,
  [865] = 862,
  [866] = 862,
  [867] = 862,
  [868] = 862,
  [869] = 862,
  [870] = 870,
  [871] = 871,
  [872] = 872,
  [873] = 873,
  [874] = 874,
  [875] = 875,
  [876] = 876,
  [877] = 877,
  [878] = 872,
  [879] = 879,
  [880] = 873,
  [881] = 881,
  [882] = 874,
  [883] = 879,
  [884] = 872,
  [885] = 879,
  [886] = 873,
  [887] = 873,
  [888] = 881,
  [889] = 889,
  [890] = 890,
  [891] = 881,
  [892] = 871,
  [893] = 875,
  [894] = 874,
  [895] = 875,
  [896] = 890,
  [897] = 876,
  [898] = 871,
  [899] = 890,
  [900] = 879,
  [901] = 877,
  [902] = 872,
  [903] = 871,
  [904] = 876,
  [905] = 877,
  [906] = 874,
  [907] = 872,
  [908] = 879,
  [909] = 873,
  [910] = 890,
  [911] = 875,
  [912] = 890,
  [913] = 890,
  [914] = 914,
  [915] = 890,
  [916] = 873,
  [917] = 871,
  [918] = 875,
  [919] = 879,
  [920] = 881,
  [921] = 872,
  [922] = 879,
  [923] = 881,
  [924] = 877,
  [925] = 889,
  [926] = 914,
  [927] = 870,
  [928] = 870,
  [929] = 881,
  [930] = 890,
  [931] = 871,
  [932] = 876,
  [933] = 871,
  [934] = 872,
  [935] = 873,
  [936] = 881,
  [937] = 874,
  [938] = 890,
  [939] = 875,
  [940] = 871,
  [941] = 874,
  [942] = 875,
  [943] = 874,
  [944] = 875,
  [945] = 876,
  [946] = 877,
  [947] = 914,
  [948] = 872,
  [949] = 879,
  [950] = 914,
  [951] = 873,
  [952] = 914,
  [953] = 881,
  [954] = 876,
  [955] = 877,
  [956] = 877,
  [957] = 876,
  [958] = 890,
  [959] = 890,
  [960] = 890,
  [961] = 877,
  [962] = 890,
  [963] = 874,
  [964] = 870,
  [965] = 876,
  [966] = 966,
  [967] = 870,
  [968] = 870,
  [969] = 969,
  [970] = 970,
  [971] = 870,
  [972] = 870,
  [973] = 973,
  [974] = 974,
  [975] = 975,
  [976] = 976,
  [977] = 969,
  [978] = 970,
  [979] = 966,
  [980] = 969,
  [981] = 970,
  [982] = 966,
  [983] = 969,
  [984] = 970,
  [985] = 966,
  [986] = 986,
  [987] = 987,
  [988] = 988,
  [989] = 989,
  [990] = 990,
  [991] = 991,
  [992] = 870,
  [993] = 973,
  [994] = 970,
  [995] = 966,
  [996] = 996,
  [997] = 997,
  [998] = 975,
  [999] = 976,
  [1000] = 1000,
  [1001] = 1001,
  [1002] = 986,
  [1003] = 987,
  [1004] = 988,
  [1005] = 973,
  [1006] = 989,
  [1007] = 990,
  [1008] = 991,
  [1009] = 974,
  [1010] = 975,
  [1011] = 976,
  [1012] = 1012,
  [1013] = 975,
  [1014] = 976,
  [1015] = 1015,
  [1016] = 648,
  [1017] = 974,
  [1018] = 987,
  [1019] = 988,
  [1020] = 966,
  [1021] = 989,
  [1022] = 990,
  [1023] = 991,
  [1024] = 974,
  [1025] = 969,
  [1026] = 1026,
  [1027] = 642,
  [1028] = 649,
  [1029] = 634,
  [1030] = 636,
  [1031] = 635,
  [1032] = 637,
  [1033] = 870,
  [1034] = 969,
  [1035] = 970,
  [1036] = 966,
  [1037] = 870,
  [1038] = 986,
  [1039] = 987,
  [1040] = 988,
  [1041] = 973,
  [1042] = 989,
  [1043] = 990,
  [1044] = 969,
  [1045] = 991,
  [1046] = 970,
  [1047] = 870,
  [1048] = 986,
  [1049] = 1049,
  [1050] = 1050,
  [1051] = 1026,
  [1052] = 975,
  [1053] = 976,
  [1054] = 1015,
  [1055] = 989,
  [1056] = 1056,
  [1057] = 1057,
  [1058] = 1058,
  [1059] = 648,
  [1060] = 986,
  [1061] = 987,
  [1062] = 988,
  [1063] = 973,
  [1064] = 989,
  [1065] = 1001,
  [1066] = 1000,
  [1067] = 1012,
  [1068] = 1026,
  [1069] = 990,
  [1070] = 991,
  [1071] = 988,
  [1072] = 974,
  [1073] = 1073,
  [1074] = 1015,
  [1075] = 642,
  [1076] = 649,
  [1077] = 634,
  [1078] = 636,
  [1079] = 635,
  [1080] = 637,
  [1081] = 1081,
  [1082] = 616,
  [1083] = 1083,
  [1084] = 1084,
  [1085] = 639,
  [1086] = 996,
  [1087] = 997,
  [1088] = 990,
  [1089] = 1089,
  [1090] = 991,
  [1091] = 1091,
  [1092] = 1092,
  [1093] = 1093,
  [1094] = 1001,
  [1095] = 1095,
  [1096] = 975,
  [1097] = 976,
  [1098] = 1098,
  [1099] = 1015,
  [1100] = 986,
  [1101] = 973,
  [1102] = 988,
  [1103] = 973,
  [1104] = 989,
  [1105] = 990,
  [1106] = 991,
  [1107] = 974,
  [1108] = 1108,
  [1109] = 1109,
  [1110] = 969,
  [1111] = 1000,
  [1112] = 1012,
  [1113] = 1026,
  [1114] = 1114,
  [1115] = 1115,
  [1116] = 970,
  [1117] = 966,
  [1118] = 1118,
  [1119] = 1119,
  [1120] = 1120,
  [1121] = 1121,
  [1122] = 1122,
  [1123] = 1123,
  [1124] = 1124,
  [1125] = 974,
  [1126] = 1126,
  [1127] = 986,
  [1128] = 1128,
  [1129] = 612,
  [1130] = 621,
  [1131] = 631,
  [1132] = 1001,
  [1133] = 987,
  [1134] = 1134,
  [1135] = 1135,
  [1136] = 996,
  [1137] = 997,
  [1138] = 975,
  [1139] = 976,
  [1140] = 632,
  [1141] = 1056,
  [1142] = 1057,
  [1143] = 1143,
  [1144] = 1000,
  [1145] = 1145,
  [1146] = 1012,
  [1147] = 1147,
  [1148] = 987,
  [1149] = 621,
  [1150] = 1114,
  [1151] = 1115,
  [1152] = 1081,
  [1153] = 640,
  [1154] = 641,
  [1155] = 644,
  [1156] = 631,
  [1157] = 632,
  [1158] = 639,
  [1159] = 1000,
  [1160] = 1012,
  [1161] = 1026,
  [1162] = 630,
  [1163] = 1073,
  [1164] = 1083,
  [1165] = 1143,
  [1166] = 1089,
  [1167] = 1145,
  [1168] = 1056,
  [1169] = 1057,
  [1170] = 1058,
  [1171] = 1084,
  [1172] = 1049,
  [1173] = 1095,
  [1174] = 1118,
  [1175] = 1119,
  [1176] = 1120,
  [1177] = 648,
  [1178] = 1121,
  [1179] = 642,
  [1180] = 1147,
  [1181] = 1091,
  [1182] = 1093,
  [1183] = 1098,
  [1184] = 1108,
  [1185] = 1109,
  [1186] = 1126,
  [1187] = 642,
  [1188] = 1092,
  [1189] = 1134,
  [1190] = 1050,
  [1191] = 649,
  [1192] = 634,
  [1193] = 636,
  [1194] = 1114,
  [1195] = 1115,
  [1196] = 635,
  [1197] = 637,
  [1198] = 1081,
  [1199] = 639,
  [1200] = 1135,
  [1201] = 616,
  [1202] = 1073,
  [1203] = 1083,
  [1204] = 1089,
  [1205] = 1084,
  [1206] = 1049,
  [1207] = 1095,
  [1208] = 1143,
  [1209] = 1145,
  [1210] = 1118,
  [1211] = 1119,
  [1212] = 1120,
  [1213] = 1121,
  [1214] = 1001,
  [1215] = 649,
  [1216] = 1147,
  [1217] = 1091,
  [1218] = 1093,
  [1219] = 1098,
  [1220] = 1108,
  [1221] = 1109,
  [1222] = 1126,
  [1223] = 1092,
  [1224] = 1134,
  [1225] = 1050,
  [1226] = 1081,
  [1227] = 1114,
  [1228] = 1115,
  [1229] = 1135,
  [1230] = 634,
  [1231] = 636,
  [1232] = 1000,
  [1233] = 1050,
  [1234] = 1012,
  [1235] = 1026,
  [1236] = 1073,
  [1237] = 1083,
  [1238] = 996,
  [1239] = 642,
  [1240] = 649,
  [1241] = 634,
  [1242] = 636,
  [1243] = 635,
  [1244] = 637,
  [1245] = 1089,
  [1246] = 997,
  [1247] = 1001,
  [1248] = 639,
  [1249] = 1135,
  [1250] = 1084,
  [1251] = 975,
  [1252] = 976,
  [1253] = 1015,
  [1254] = 1143,
  [1255] = 1145,
  [1256] = 986,
  [1257] = 987,
  [1258] = 988,
  [1259] = 973,
  [1260] = 989,
  [1261] = 990,
  [1262] = 991,
  [1263] = 974,
  [1264] = 631,
  [1265] = 632,
  [1266] = 631,
  [1267] = 632,
  [1268] = 639,
  [1269] = 639,
  [1270] = 1049,
  [1271] = 1095,
  [1272] = 1118,
  [1273] = 1119,
  [1274] = 1120,
  [1275] = 1121,
  [1276] = 635,
  [1277] = 616,
  [1278] = 612,
  [1279] = 621,
  [1280] = 1001,
  [1281] = 612,
  [1282] = 637,
  [1283] = 1000,
  [1284] = 1012,
  [1285] = 1026,
  [1286] = 1015,
  [1287] = 1147,
  [1288] = 1091,
  [1289] = 1015,
  [1290] = 1093,
  [1291] = 1098,
  [1292] = 1058,
  [1293] = 1134,
  [1294] = 1108,
  [1295] = 1109,
  [1296] = 1126,
  [1297] = 996,
  [1298] = 997,
  [1299] = 1092,
  [1300] = 648,
  [1301] = 648,
  [1302] = 1049,
  [1303] = 644,
  [1304] = 631,
  [1305] = 632,
  [1306] = 1000,
  [1307] = 1012,
  [1308] = 1026,
  [1309] = 1073,
  [1310] = 1083,
  [1311] = 1081,
  [1312] = 1089,
  [1313] = 1143,
  [1314] = 1145,
  [1315] = 1084,
  [1316] = 1135,
  [1317] = 1049,
  [1318] = 1095,
  [1319] = 1118,
  [1320] = 1119,
  [1321] = 1120,
  [1322] = 631,
  [1323] = 1121,
  [1324] = 632,
  [1325] = 1135,
  [1326] = 630,
  [1327] = 635,
  [1328] = 1147,
  [1329] = 1147,
  [1330] = 1091,
  [1331] = 1093,
  [1332] = 1098,
  [1333] = 1108,
  [1334] = 1109,
  [1335] = 1126,
  [1336] = 1091,
  [1337] = 1092,
  [1338] = 1134,
  [1339] = 1050,
  [1340] = 1340,
  [1341] = 1341,
  [1342] = 1093,
  [1343] = 1114,
  [1344] = 1115,
  [1345] = 1109,
  [1346] = 1121,
  [1347] = 1098,
  [1348] = 1126,
  [1349] = 1108,
  [1350] = 1109,
  [1351] = 1073,
  [1352] = 637,
  [1353] = 1083,
  [1354] = 1126,
  [1355] = 1108,
  [1356] = 648,
  [1357] = 1091,
  [1358] = 1093,
  [1359] = 1098,
  [1360] = 1124,
  [1361] = 642,
  [1362] = 649,
  [1363] = 634,
  [1364] = 636,
  [1365] = 635,
  [1366] = 637,
  [1367] = 1001,
  [1368] = 639,
  [1369] = 1015,
  [1370] = 640,
  [1371] = 641,
  [1372] = 644,
  [1373] = 1092,
  [1374] = 639,
  [1375] = 630,
  [1376] = 1134,
  [1377] = 1050,
  [1378] = 1092,
  [1379] = 1143,
  [1380] = 1145,
  [1381] = 643,
  [1382] = 1134,
  [1383] = 1114,
  [1384] = 1115,
  [1385] = 1115,
  [1386] = 648,
  [1387] = 1050,
  [1388] = 1089,
  [1389] = 1081,
  [1390] = 1135,
  [1391] = 640,
  [1392] = 636,
  [1393] = 641,
  [1394] = 1118,
  [1395] = 649,
  [1396] = 644,
  [1397] = 1084,
  [1398] = 631,
  [1399] = 632,
  [1400] = 639,
  [1401] = 1119,
  [1402] = 639,
  [1403] = 1120,
  [1404] = 630,
  [1405] = 1073,
  [1406] = 1083,
  [1407] = 1147,
  [1408] = 1089,
  [1409] = 1084,
  [1410] = 634,
  [1411] = 1049,
  [1412] = 1143,
  [1413] = 1095,
  [1414] = 1145,
  [1415] = 1095,
  [1416] = 640,
  [1417] = 642,
  [1418] = 1081,
  [1419] = 643,
  [1420] = 1118,
  [1421] = 1119,
  [1422] = 1120,
  [1423] = 641,
  [1424] = 1121,
  [1425] = 1122,
  [1426] = 1123,
  [1427] = 1114,
  [1428] = 1121,
  [1429] = 635,
  [1430] = 637,
  [1431] = 1073,
  [1432] = 1083,
  [1433] = 643,
  [1434] = 1089,
  [1435] = 639,
  [1436] = 1143,
  [1437] = 1145,
  [1438] = 643,
  [1439] = 1056,
  [1440] = 1084,
  [1441] = 1057,
  [1442] = 1049,
  [1443] = 1095,
  [1444] = 1118,
  [1445] = 1119,
  [1446] = 1120,
  [1447] = 634,
  [1448] = 1056,
  [1449] = 1057,
  [1450] = 1058,
  [1451] = 1135,
  [1452] = 1058,
  [1453] = 1147,
  [1454] = 1091,
  [1455] = 1056,
  [1456] = 1093,
  [1457] = 1098,
  [1458] = 1108,
  [1459] = 1109,
  [1460] = 1126,
  [1461] = 1057,
  [1462] = 1081,
  [1463] = 1058,
  [1464] = 1092,
  [1465] = 1134,
  [1466] = 1050,
  [1467] = 1114,
  [1468] = 1115,
  [1469] = 631,
  [1470] = 632,
  [1471] = 649,
  [1472] = 648,
  [1473] = 642,
  [1474] = 636,
  [1475] = 632,
  [1476] = 648,
  [1477] = 642,
  [1478] = 649,
  [1479] = 630,
  [1480] = 639,
  [1481] = 639,
  [1482] = 639,
  [1483] = 639,
  [1484] = 644,
  [1485] = 635,
  [1486] = 634,
  [1487] = 636,
  [1488] = 1341,
  [1489] = 640,
  [1490] = 1340,
  [1491] = 641,
  [1492] = 637,
  [1493] = 631,
  [1494] = 1494,
  [1495] = 1495,
  [1496] = 1496,
  [1497] = 1497,
  [1498] = 1498,
  [1499] = 1498,
  [1500] = 1496,
  [1501] = 1501,
  [1502] = 1502,
  [1503] = 1503,
  [1504] = 1504,
  [1505] = 1505,
  [1506] = 1506,
  [1507] = 1497,
  [1508] = 1498,
  [1509] = 1501,
  [1510] = 1496,
  [1511] = 1501,
  [1512] = 1503,
  [1513] = 1504,
  [1514] = 1502,
  [1515] = 1503,
  [1516] = 1504,
  [1517] = 1502,
  [1518] = 1505,
  [1519] = 1506,
  [1520] = 1497,
  [1521] = 1498,
  [1522] = 1505,
  [1523] = 1506,
  [1524] = 1505,
  [1525] = 1496,
  [1526] = 1501,
  [1527] = 1497,
  [1528] = 1502,
  [1529] = 1503,
  [1530] = 1504,
  [1531] = 1506,
  [1532] = 1532,
  [1533] = 1533,
  [1534] = 1533,
  [1535] = 1533,
  [1536] = 1536,
  [1537] = 1537,
  [1538] = 1538,
  [1539] = 1539,
  [1540] = 1538,
  [1541] = 1541,
  [1542] = 1537,
  [1543] = 1541,
  [1544] = 1539,
  [1545] = 1538,
  [1546] = 1537,
  [1547] = 1537,
  [1548] = 1548,
  [1549] = 1548,
  [1550] = 1541,
  [1551] = 1548,
  [1552] = 1548,
  [1553] = 1539,
  [1554] = 1538,
  [1555] = 1539,
  [1556] = 1541,
  [1557] = 1557,
  [1558] = 1558,
  [1559] = 1559,
  [1560] = 1558,
  [1561] = 1558,
  [1562] = 1559,
  [1563] = 1559,
  [1564] = 1564,
  [1565] = 1559,
  [1566] = 1558,
  [1567] = 1567,
  [1568] = 1567,
  [1569] = 1564,
  [1570] = 1567,
  [1571] = 1567,
  [1572] = 1564,
  [1573] = 1564,
  [1574] = 1564,
  [1575] = 1567,
  [1576] = 1564,
  [1577] = 1567,
  [1578] = 1564,
  [1579] = 1567,
  [1580] = 1567,
  [1581] = 1581,
  [1582] = 1340,
  [1583] = 1341,
  [1584] = 640,
  [1585] = 641,
  [1586] = 644,
  [1587] = 630,
  [1588] = 1588,
  [1589] = 1564,
  [1590] = 1590,
  [1591] = 632,
  [1592] = 639,
  [1593] = 631,
  [1594] = 1594,
  [1595] = 1595,
  [1596] = 1596,
  [1597] = 1597,
  [1598] = 640,
  [1599] = 640,
  [1600] = 641,
  [1601] = 1340,
  [1602] = 1341,
  [1603] = 1596,
  [1604] = 1597,
  [1605] = 1594,
  [1606] = 640,
  [1607] = 641,
  [1608] = 644,
  [1609] = 630,
  [1610] = 641,
  [1611] = 631,
  [1612] = 632,
  [1613] = 644,
  [1614] = 1614,
  [1615] = 1341,
  [1616] = 1616,
  [1617] = 1617,
  [1618] = 1340,
  [1619] = 1341,
  [1620] = 630,
  [1621] = 644,
  [1622] = 1616,
  [1623] = 1616,
  [1624] = 1616,
  [1625] = 1616,
  [1626] = 1616,
  [1627] = 1616,
  [1628] = 1628,
  [1629] = 1616,
  [1630] = 639,
  [1631] = 1616,
  [1632] = 1616,
  [1633] = 630,
  [1634] = 1634,
  [1635] = 1340,
  [1636] = 1636,
  [1637] = 1636,
  [1638] = 1634,
  [1639] = 1636,
  [1640] = 1614,
  [1641] = 1641,
  [1642] = 1636,
  [1643] = 1590,
  [1644] = 1636,
  [1645] = 1636,
  [1646] = 1617,
  [1647] = 1636,
  [1648] = 1648,
  [1649] = 1648,
  [1650] = 1628,
  [1651] = 1651,
  [1652] = 1651,
  [1653] = 1595,
  [1654] = 1636,
  [1655] = 1648,
  [1656] = 1656,
  [1657] = 1657,
  [1658] = 1657,
  [1659] = 1659,
  [1660] = 1660,
  [1661] = 1659,
  [1662] = 1662,
  [1663] = 1663,
  [1664] = 1662,
  [1665] = 1665,
  [1666] = 1666,
  [1667] = 1665,
  [1668] = 1668,
  [1669] = 1669,
  [1670] = 1670,
  [1671] = 1665,
  [1672] = 1672,
  [1673] = 1665,
  [1674] = 1665,
  [1675] = 1665,
  [1676] = 1676,
  [1677] = 1677,
  [1678] = 1665,
  [1679] = 1679,
  [1680] = 1680,
  [1681] = 1665,
  [1682] = 1682,
  [1683] = 1683,
  [1684] = 1684,
  [1685] = 1685,
  [1686] = 1682,
  [1687] = 1684,
  [1688] = 1683,
  [1689] = 1689,
  [1690] = 1683,
  [1691] = 1684,
  [1692] = 1685,
  [1693] = 1693,
  [1694] = 1682,
  [1695] = 1679,
  [1696] = 1683,
  [1697] = 1684,
  [1698] = 1685,
  [1699] = 1682,
  [1700] = 1685,
  [1701] = 1683,
  [1702] = 1684,
  [1703] = 1685,
  [1704] = 1682,
  [1705] = 1668,
  [1706] = 1670,
  [1707] = 1684,
  [1708] = 1685,
  [1709] = 1709,
  [1710] = 1682,
  [1711] = 1683,
  [1712] = 1684,
  [1713] = 1685,
  [1714] = 1682,
  [1715] = 1683,
  [1716] = 1684,
  [1717] = 1685,
  [1718] = 1682,
  [1719] = 1683,
  [1720] = 1684,
  [1721] = 1721,
  [1722] = 1677,
  [1723] = 1721,
  [1724] = 1680,
  [1725] = 1721,
  [1726] = 1676,
  [1727] = 1721,
  [1728] = 1721,
  [1729] = 1672,
  [1730] = 1721,
  [1731] = 1721,
  [1732] = 1721,
  [1733] = 1666,
  [1734] = 1669,
  [1735] = 1683,
  [1736] = 1668,
  [1737] = 1737,
  [1738] = 1679,
  [1739] = 1676,
  [1740] = 1740,
  [1741] = 1680,
  [1742] = 1669,
  [1743] = 1670,
  [1744] = 1672,
  [1745] = 1669,
  [1746] = 1740,
  [1747] = 1668,
  [1748] = 1679,
  [1749] = 1670,
  [1750] = 1672,
  [1751] = 1666,
  [1752] = 1676,
  [1753] = 1677,
  [1754] = 1677,
  [1755] = 1680,
  [1756] = 1756,
  [1757] = 1666,
  [1758] = 1758,
  [1759] = 1672,
  [1760] = 1679,
  [1761] = 1668,
  [1762] = 1762,
  [1763] = 1680,
  [1764] = 1666,
  [1765] = 1680,
  [1766] = 1677,
  [1767] = 1740,
  [1768] = 1679,
  [1769] = 1769,
  [1770] = 1770,
  [1771] = 1668,
  [1772] = 1677,
  [1773] = 1670,
  [1774] = 1774,
  [1775] = 1680,
  [1776] = 1677,
  [1777] = 1676,
  [1778] = 1676,
  [1779] = 1669,
  [1780] = 1669,
  [1781] = 1740,
  [1782] = 1669,
  [1783] = 1670,
  [1784] = 1670,
  [1785] = 1672,
  [1786] = 1672,
  [1787] = 1679,
  [1788] = 1666,
  [1789] = 1789,
  [1790] = 1790,
  [1791] = 1668,
  [1792] = 1666,
  [1793] = 1676,
  [1794] = 1774,
  [1795] = 1795,
  [1796] = 1796,
  [1797] = 1797,
  [1798] = 1798,
  [1799] = 1799,
  [1800] = 1800,
  [1801] = 1795,
  [1802] = 1802,
  [1803] = 1803,
  [1804] = 1680,
  [1805] = 1805,
  [1806] = 1806,
  [1807] = 1807,
  [1808] = 1796,
  [1809] = 1806,
  [1810] = 1668,
  [1811] = 1795,
  [1812] = 1812,
  [1813] = 1796,
  [1814] = 1795,
  [1815] = 1774,
  [1816] = 1795,
  [1817] = 1795,
  [1818] = 1679,
  [1819] = 1795,
  [1820] = 1820,
  [1821] = 1821,
  [1822] = 1822,
  [1823] = 1821,
  [1824] = 1824,
  [1825] = 1666,
  [1826] = 1826,
  [1827] = 1827,
  [1828] = 1828,
  [1829] = 1807,
  [1830] = 1795,
  [1831] = 1822,
  [1832] = 1806,
  [1833] = 1795,
  [1834] = 1756,
  [1835] = 1677,
  [1836] = 1798,
  [1837] = 1676,
  [1838] = 1774,
  [1839] = 1822,
  [1840] = 1669,
  [1841] = 1670,
  [1842] = 1672,
  [1843] = 1790,
  [1844] = 1795,
  [1845] = 1845,
  [1846] = 1846,
  [1847] = 1756,
  [1848] = 1848,
  [1849] = 1849,
  [1850] = 1850,
  [1851] = 1851,
  [1852] = 1851,
  [1853] = 1758,
  [1854] = 1845,
  [1855] = 1845,
  [1856] = 1856,
  [1857] = 1851,
  [1858] = 1820,
  [1859] = 1789,
  [1860] = 1846,
  [1861] = 1861,
  [1862] = 1862,
  [1863] = 1756,
  [1864] = 1864,
  [1865] = 1865,
  [1866] = 1762,
  [1867] = 1867,
  [1868] = 1789,
  [1869] = 1848,
  [1870] = 1851,
  [1871] = 1851,
  [1872] = 1850,
  [1873] = 1873,
  [1874] = 1874,
  [1875] = 1758,
  [1876] = 1873,
  [1877] = 1820,
  [1878] = 1878,
  [1879] = 1851,
  [1880] = 1880,
  [1881] = 1873,
  [1882] = 1851,
  [1883] = 1758,
  [1884] = 1762,
  [1885] = 1762,
  [1886] = 1886,
  [1887] = 1880,
  [1888] = 1849,
  [1889] = 1851,
  [1890] = 1880,
  [1891] = 1891,
  [1892] = 1789,
  [1893] = 1846,
  [1894] = 1820,
  [1895] = 1895,
  [1896] = 1896,
  [1897] = 1897,
  [1898] = 1790,
  [1899] = 1899,
  [1900] = 1900,
  [1901] = 1789,
  [1902] = 1902,
  [1903] = 1874,
  [1904] = 1904,
  [1905] = 1874,
  [1906] = 1906,
  [1907] = 1891,
  [1908] = 1908,
  [1909] = 1909,
  [1910] = 1802,
  [1911] = 1911,
  [1912] = 1912,
  [1913] = 1913,
  [1914] = 1914,
  [1915] = 1915,
  [1916] = 1916,
  [1917] = 1917,
  [1918] = 1802,
  [1919] = 1919,
  [1920] = 1920,
  [1921] = 1921,
  [1922] = 1922,
  [1923] = 1909,
  [1924] = 1924,
  [1925] = 1916,
  [1926] = 1926,
  [1927] = 1769,
  [1928] = 1928,
  [1929] = 1908,
  [1930] = 1802,
  [1931] = 1931,
  [1932] = 1904,
  [1933] = 1933,
  [1934] = 1934,
  [1935] = 1917,
  [1936] = 1900,
  [1937] = 1891,
  [1938] = 1909,
  [1939] = 1939,
  [1940] = 1762,
  [1941] = 1931,
  [1942] = 1942,
  [1943] = 1911,
  [1944] = 1803,
  [1945] = 1945,
  [1946] = 1891,
  [1947] = 1947,
  [1948] = 1948,
  [1949] = 1949,
  [1950] = 1911,
  [1951] = 1908,
  [1952] = 1919,
  [1953] = 1953,
  [1954] = 1954,
  [1955] = 1904,
  [1956] = 1947,
  [1957] = 1957,
  [1958] = 1947,
  [1959] = 1920,
  [1960] = 1960,
  [1961] = 1961,
  [1962] = 1874,
  [1963] = 1595,
  [1964] = 1926,
  [1965] = 1758,
  [1966] = 1954,
  [1967] = 1967,
  [1968] = 1968,
  [1969] = 1957,
  [1970] = 1970,
  [1971] = 1926,
  [1972] = 1972,
  [1973] = 1973,
  [1974] = 1931,
  [1975] = 1975,
  [1976] = 1916,
  [1977] = 1975,
  [1978] = 1954,
  [1979] = 1979,
  [1980] = 1980,
  [1981] = 1769,
  [1982] = 1790,
  [1983] = 1967,
  [1984] = 1968,
  [1985] = 1985,
  [1986] = 1986,
  [1987] = 1899,
  [1988] = 1970,
  [1989] = 1922,
  [1990] = 1917,
  [1991] = 1948,
  [1992] = 1992,
  [1993] = 1957,
  [1994] = 1590,
  [1995] = 1995,
  [1996] = 1949,
  [1997] = 1997,
  [1998] = 1911,
  [1999] = 1790,
  [2000] = 1769,
  [2001] = 2001,
  [2002] = 2002,
  [2003] = 1902,
  [2004] = 2004,
  [2005] = 2005,
  [2006] = 2006,
  [2007] = 1617,
  [2008] = 1912,
  [2009] = 1914,
  [2010] = 2010,
  [2011] = 1922,
  [2012] = 2012,
  [2013] = 2013,
  [2014] = 2014,
  [2015] = 2015,
  [2016] = 1933,
  [2017] = 1979,
  [2018] = 2005,
  [2019] = 2019,
  [2020] = 2020,
  [2021] = 2021,
  [2022] = 2022,
  [2023] = 1933,
  [2024] = 1997,
  [2025] = 1802,
  [2026] = 2005,
  [2027] = 2027,
  [2028] = 2028,
  [2029] = 2029,
  [2030] = 1967,
  [2031] = 1947,
  [2032] = 2032,
  [2033] = 2005,
  [2034] = 2034,
  [2035] = 2035,
  [2036] = 2036,
  [2037] = 2037,
  [2038] = 2010,
  [2039] = 2039,
  [2040] = 2040,
  [2041] = 2041,
  [2042] = 2015,
  [2043] = 2043,
  [2044] = 2021,
  [2045] = 2045,
  [2046] = 2046,
  [2047] = 2047,
  [2048] = 1634,
  [2049] = 2049,
  [2050] = 2050,
  [2051] = 2006,
  [2052] = 2002,
  [2053] = 2028,
  [2054] = 2054,
  [2055] = 2055,
  [2056] = 2056,
  [2057] = 2057,
  [2058] = 1972,
  [2059] = 1895,
  [2060] = 1980,
  [2061] = 1967,
  [2062] = 1968,
  [2063] = 1972,
  [2064] = 1919,
  [2065] = 2065,
  [2066] = 1895,
  [2067] = 2067,
  [2068] = 2068,
  [2069] = 1912,
  [2070] = 2034,
  [2071] = 2067,
  [2072] = 1980,
  [2073] = 2073,
  [2074] = 2010,
  [2075] = 2075,
  [2076] = 1968,
  [2077] = 1970,
  [2078] = 1902,
  [2079] = 2079,
  [2080] = 2054,
  [2081] = 2015,
  [2082] = 2021,
  [2083] = 1922,
  [2084] = 1902,
  [2085] = 1912,
  [2086] = 2073,
  [2087] = 1914,
  [2088] = 1614,
  [2089] = 1873,
  [2090] = 1970,
  [2091] = 2005,
  [2092] = 1917,
  [2093] = 1914,
  [2094] = 2068,
  [2095] = 2073,
  [2096] = 2005,
  [2097] = 1909,
  [2098] = 1919,
  [2099] = 2099,
  [2100] = 2100,
  [2101] = 1920,
  [2102] = 2102,
  [2103] = 2005,
  [2104] = 2104,
  [2105] = 1972,
  [2106] = 1895,
  [2107] = 2107,
  [2108] = 2021,
  [2109] = 1920,
  [2110] = 2065,
  [2111] = 1933,
  [2112] = 2112,
  [2113] = 2113,
  [2114] = 2114,
  [2115] = 2115,
  [2116] = 2116,
  [2117] = 2117,
  [2118] = 2041,
  [2119] = 2119,
  [2120] = 2120,
  [2121] = 1980,
  [2122] = 1628,
  [2123] = 2005,
  [2124] = 2119,
  [2125] = 2012,
  [2126] = 2020,
  [2127] = 2112,
  [2128] = 2128,
  [2129] = 2029,
  [2130] = 2035,
  [2131] = 2131,
  [2132] = 2040,
  [2133] = 2043,
  [2134] = 2050,
  [2135] = 2041,
  [2136] = 2055,
  [2137] = 2012,
  [2138] = 2102,
  [2139] = 2107,
  [2140] = 2004,
  [2141] = 2113,
  [2142] = 2115,
  [2143] = 2116,
  [2144] = 2119,
  [2145] = 2120,
  [2146] = 2014,
  [2147] = 2022,
  [2148] = 2027,
  [2149] = 2045,
  [2150] = 2047,
  [2151] = 2019,
  [2152] = 2020,
  [2153] = 2153,
  [2154] = 2154,
  [2155] = 2155,
  [2156] = 2156,
  [2157] = 2157,
  [2158] = 2032,
  [2159] = 2159,
  [2160] = 2160,
  [2161] = 2161,
  [2162] = 2162,
  [2163] = 2160,
  [2164] = 2164,
  [2165] = 2112,
  [2166] = 2029,
  [2167] = 2035,
  [2168] = 2040,
  [2169] = 2043,
  [2170] = 2050,
  [2171] = 2041,
  [2172] = 2055,
  [2173] = 2173,
  [2174] = 2012,
  [2175] = 2175,
  [2176] = 2020,
  [2177] = 2102,
  [2178] = 2107,
  [2179] = 2004,
  [2180] = 2113,
  [2181] = 2115,
  [2182] = 2116,
  [2183] = 2119,
  [2184] = 2184,
  [2185] = 2120,
  [2186] = 2014,
  [2187] = 2022,
  [2188] = 2027,
  [2189] = 2045,
  [2190] = 2153,
  [2191] = 2154,
  [2192] = 2047,
  [2193] = 2019,
  [2194] = 2160,
  [2195] = 2195,
  [2196] = 2112,
  [2197] = 2197,
  [2198] = 2036,
  [2199] = 2199,
  [2200] = 2200,
  [2201] = 2201,
  [2202] = 2153,
  [2203] = 2154,
  [2204] = 2160,
  [2205] = 2104,
  [2206] = 2029,
  [2207] = 2131,
  [2208] = 2035,
  [2209] = 2209,
  [2210] = 2040,
  [2211] = 2043,
  [2212] = 2050,
  [2213] = 2055,
  [2214] = 2114,
  [2215] = 2215,
  [2216] = 2216,
  [2217] = 2217,
  [2218] = 2218,
  [2219] = 2102,
  [2220] = 2107,
  [2221] = 2004,
  [2222] = 2113,
  [2223] = 2115,
  [2224] = 2224,
  [2225] = 2225,
  [2226] = 2116,
  [2227] = 2227,
  [2228] = 2120,
  [2229] = 2229,
  [2230] = 2230,
  [2231] = 2231,
  [2232] = 2232,
  [2233] = 2014,
  [2234] = 2234,
  [2235] = 2022,
  [2236] = 2027,
  [2237] = 2037,
  [2238] = 2238,
  [2239] = 2239,
  [2240] = 2045,
  [2241] = 2153,
  [2242] = 2047,
  [2243] = 2019,
  [2244] = 2154,
  [2245] = 2245,
  [2246] = 2195,
  [2247] = 2201,
  [2248] = 2248,
  [2249] = 2224,
  [2250] = 2250,
  [2251] = 2215,
  [2252] = 2252,
  [2253] = 2253,
  [2254] = 2254,
  [2255] = 2255,
  [2256] = 2256,
  [2257] = 2257,
  [2258] = 2258,
  [2259] = 2259,
  [2260] = 2260,
  [2261] = 2261,
  [2262] = 2262,
  [2263] = 2261,
  [2264] = 2264,
  [2265] = 2265,
  [2266] = 2266,
  [2267] = 2267,
  [2268] = 2268,
  [2269] = 2258,
  [2270] = 2253,
  [2271] = 2259,
  [2272] = 2272,
  [2273] = 2273,
  [2274] = 2229,
  [2275] = 2275,
  [2276] = 2276,
  [2277] = 2277,
  [2278] = 2278,
  [2279] = 2279,
  [2280] = 2280,
  [2281] = 2281,
  [2282] = 2282,
  [2283] = 2283,
  [2284] = 2280,
  [2285] = 2285,
  [2286] = 2286,
  [2287] = 2286,
  [2288] = 2273,
  [2289] = 2255,
  [2290] = 2266,
  [2291] = 2278,
  [2292] = 2282,
  [2293] = 2293,
  [2294] = 2285,
  [2295] = 1001,
  [2296] = 2296,
  [2297] = 2297,
  [2298] = 1979,
  [2299] = 2299,
  [2300] = 2300,
  [2301] = 2301,
  [2302] = 2162,
  [2303] = 2275,
  [2304] = 2304,
  [2305] = 2300,
  [2306] = 2254,
  [2307] = 2257,
  [2308] = 1961,
  [2309] = 2264,
  [2310] = 2261,
  [2311] = 2311,
  [2312] = 2264,
  [2313] = 2265,
  [2314] = 2267,
  [2315] = 2265,
  [2316] = 2316,
  [2317] = 2317,
  [2318] = 2273,
  [2319] = 2275,
  [2320] = 2320,
  [2321] = 2276,
  [2322] = 2277,
  [2323] = 2002,
  [2324] = 2280,
  [2325] = 2325,
  [2326] = 2326,
  [2327] = 654,
  [2328] = 2286,
  [2329] = 2329,
  [2330] = 2317,
  [2331] = 2255,
  [2332] = 2311,
  [2333] = 2266,
  [2334] = 2278,
  [2335] = 2282,
  [2336] = 1973,
  [2337] = 1995,
  [2338] = 2338,
  [2339] = 653,
  [2340] = 2285,
  [2341] = 2255,
  [2342] = 1897,
  [2343] = 2343,
  [2344] = 2344,
  [2345] = 2345,
  [2346] = 2300,
  [2347] = 2254,
  [2348] = 2304,
  [2349] = 2254,
  [2350] = 2280,
  [2351] = 2266,
  [2352] = 2257,
  [2353] = 2267,
  [2354] = 2261,
  [2355] = 1979,
  [2356] = 2356,
  [2357] = 2264,
  [2358] = 2265,
  [2359] = 2267,
  [2360] = 2278,
  [2361] = 2282,
  [2362] = 2273,
  [2363] = 2363,
  [2364] = 2275,
  [2365] = 2276,
  [2366] = 2277,
  [2367] = 1015,
  [2368] = 2368,
  [2369] = 2227,
  [2370] = 2161,
  [2371] = 2162,
  [2372] = 2218,
  [2373] = 2164,
  [2374] = 2300,
  [2375] = 1979,
  [2376] = 2304,
  [2377] = 2368,
  [2378] = 2378,
  [2379] = 2254,
  [2380] = 1590,
  [2381] = 2257,
  [2382] = 2338,
  [2383] = 2230,
  [2384] = 2261,
  [2385] = 2264,
  [2386] = 2265,
  [2387] = 2387,
  [2388] = 2267,
  [2389] = 2002,
  [2390] = 2276,
  [2391] = 2273,
  [2392] = 2001,
  [2393] = 2275,
  [2394] = 2276,
  [2395] = 2277,
  [2396] = 2273,
  [2397] = 2397,
  [2398] = 1921,
  [2399] = 1942,
  [2400] = 2256,
  [2401] = 2275,
  [2402] = 659,
  [2403] = 2300,
  [2404] = 2304,
  [2405] = 2002,
  [2406] = 2254,
  [2407] = 2277,
  [2408] = 2257,
  [2409] = 2261,
  [2410] = 2285,
  [2411] = 2411,
  [2412] = 2264,
  [2413] = 2265,
  [2414] = 2267,
  [2415] = 2415,
  [2416] = 2273,
  [2417] = 2299,
  [2418] = 2275,
  [2419] = 2343,
  [2420] = 2276,
  [2421] = 2277,
  [2422] = 2422,
  [2423] = 2423,
  [2424] = 2378,
  [2425] = 2425,
  [2426] = 2225,
  [2427] = 656,
  [2428] = 2304,
  [2429] = 2300,
  [2430] = 2304,
  [2431] = 2257,
  [2432] = 2432,
  [2433] = 2254,
  [2434] = 2257,
  [2435] = 2261,
  [2436] = 2436,
  [2437] = 2387,
  [2438] = 2264,
  [2439] = 2265,
  [2440] = 2267,
  [2441] = 2441,
  [2442] = 2442,
  [2443] = 2273,
  [2444] = 2275,
  [2445] = 2276,
  [2446] = 2277,
  [2447] = 2276,
  [2448] = 2448,
  [2449] = 2449,
  [2450] = 2267,
  [2451] = 2276,
  [2452] = 2277,
  [2453] = 2216,
  [2454] = 2217,
  [2455] = 2161,
  [2456] = 2267,
  [2457] = 2300,
  [2458] = 2276,
  [2459] = 2277,
  [2460] = 2338,
  [2461] = 2162,
  [2462] = 2277,
  [2463] = 2300,
  [2464] = 1617,
  [2465] = 2465,
  [2466] = 2466,
  [2467] = 2467,
  [2468] = 2468,
  [2469] = 2469,
  [2470] = 2304,
  [2471] = 2293,
  [2472] = 2472,
  [2473] = 2473,
  [2474] = 2356,
  [2475] = 2368,
  [2476] = 2320,
  [2477] = 2397,
  [2478] = 2286,
  [2479] = 2411,
  [2480] = 2254,
  [2481] = 2164,
  [2482] = 2425,
  [2483] = 2469,
  [2484] = 2293,
  [2485] = 2257,
  [2486] = 1595,
  [2487] = 1960,
  [2488] = 2258,
  [2489] = 2259,
  [2490] = 2449,
  [2491] = 2268,
  [2492] = 2261,
  [2493] = 2225,
  [2494] = 2363,
  [2495] = 2297,
  [2496] = 2225,
  [2497] = 1590,
  [2498] = 2469,
  [2499] = 2304,
  [2500] = 2264,
  [2501] = 2265,
  [2502] = 2415,
  [2503] = 2425,
  [2504] = 650,
  [2505] = 2267,
  [2506] = 1590,
  [2507] = 2468,
  [2508] = 2423,
  [2509] = 2329,
  [2510] = 2262,
  [2511] = 2279,
  [2512] = 2467,
  [2513] = 2513,
  [2514] = 2422,
  [2515] = 2515,
  [2516] = 2516,
  [2517] = 2517,
  [2518] = 2515,
  [2519] = 2049,
  [2520] = 2520,
  [2521] = 2521,
  [2522] = 2522,
  [2523] = 2436,
  [2524] = 2524,
  [2525] = 2049,
  [2526] = 2526,
  [2527] = 2527,
  [2528] = 2528,
  [2529] = 2529,
  [2530] = 656,
  [2531] = 2531,
  [2532] = 2532,
  [2533] = 2533,
  [2534] = 2531,
  [2535] = 2535,
  [2536] = 2533,
  [2537] = 2535,
  [2538] = 2538,
  [2539] = 2539,
  [2540] = 2540,
  [2541] = 2516,
  [2542] = 2542,
  [2543] = 2515,
  [2544] = 2544,
  [2545] = 2545,
  [2546] = 2524,
  [2547] = 2547,
  [2548] = 2538,
  [2549] = 2049,
  [2550] = 2550,
  [2551] = 2551,
  [2552] = 2552,
  [2553] = 2553,
  [2554] = 2554,
  [2555] = 1617,
  [2556] = 2524,
  [2557] = 2557,
  [2558] = 2558,
  [2559] = 2559,
  [2560] = 2547,
  [2561] = 2561,
  [2562] = 2562,
  [2563] = 2531,
  [2564] = 2564,
  [2565] = 2551,
  [2566] = 2566,
  [2567] = 2567,
  [2568] = 2568,
  [2569] = 650,
  [2570] = 2570,
  [2571] = 2535,
  [2572] = 2572,
  [2573] = 2573,
  [2574] = 2574,
  [2575] = 2533,
  [2576] = 2576,
  [2577] = 2577,
  [2578] = 2578,
  [2579] = 2538,
  [2580] = 2542,
  [2581] = 2531,
  [2582] = 2582,
  [2583] = 2583,
  [2584] = 2542,
  [2585] = 2527,
  [2586] = 2586,
  [2587] = 2587,
  [2588] = 2587,
  [2589] = 2572,
  [2590] = 2524,
  [2591] = 2591,
  [2592] = 2515,
  [2593] = 659,
  [2594] = 2533,
  [2595] = 2595,
  [2596] = 1628,
  [2597] = 1628,
  [2598] = 2598,
  [2599] = 1634,
  [2600] = 2586,
  [2601] = 1634,
  [2602] = 2602,
  [2603] = 654,
  [2604] = 2604,
  [2605] = 653,
  [2606] = 2432,
  [2607] = 2553,
  [2608] = 2608,
  [2609] = 2602,
  [2610] = 2545,
  [2611] = 1614,
  [2612] = 1614,
  [2613] = 2613,
  [2614] = 2614,
  [2615] = 2615,
  [2616] = 2616,
  [2617] = 2617,
  [2618] = 2618,
  [2619] = 2619,
  [2620] = 2620,
  [2621] = 2621,
  [2622] = 2622,
  [2623] = 2623,
  [2624] = 2624,
  [2625] = 2625,
  [2626] = 2620,
  [2627] = 2627,
  [2628] = 2628,
  [2629] = 2629,
  [2630] = 2630,
  [2631] = 2631,
  [2632] = 2632,
  [2633] = 2616,
  [2634] = 2634,
  [2635] = 2628,
  [2636] = 2636,
  [2637] = 2623,
  [2638] = 2638,
  [2639] = 2639,
  [2640] = 2640,
  [2641] = 2632,
  [2642] = 2636,
  [2643] = 2615,
  [2644] = 2628,
  [2645] = 2630,
  [2646] = 2617,
  [2647] = 2618,
  [2648] = 2619,
  [2649] = 2630,
  [2650] = 2650,
  [2651] = 2651,
  [2652] = 2652,
  [2653] = 2653,
  [2654] = 2622,
  [2655] = 2623,
  [2656] = 2622,
  [2657] = 2638,
  [2658] = 2615,
  [2659] = 2615,
  [2660] = 2620,
  [2661] = 2620,
  [2662] = 2662,
  [2663] = 2663,
  [2664] = 2628,
  [2665] = 2652,
  [2666] = 2629,
  [2667] = 2618,
  [2668] = 2628,
  [2669] = 2669,
  [2670] = 2620,
  [2671] = 2619,
  [2672] = 2630,
  [2673] = 2650,
  [2674] = 2622,
  [2675] = 2623,
  [2676] = 2632,
  [2677] = 2616,
  [2678] = 2630,
  [2679] = 2679,
  [2680] = 2680,
  [2681] = 2681,
  [2682] = 2620,
  [2683] = 2636,
  [2684] = 2630,
  [2685] = 2618,
  [2686] = 2624,
  [2687] = 2628,
  [2688] = 2688,
  [2689] = 2629,
  [2690] = 2622,
  [2691] = 2615,
  [2692] = 2650,
  [2693] = 2651,
  [2694] = 2650,
  [2695] = 2629,
  [2696] = 2620,
  [2697] = 2697,
  [2698] = 2698,
  [2699] = 2632,
  [2700] = 2700,
  [2701] = 2701,
  [2702] = 2702,
  [2703] = 2616,
  [2704] = 2615,
  [2705] = 2679,
  [2706] = 2706,
  [2707] = 2707,
  [2708] = 2636,
  [2709] = 2709,
  [2710] = 2710,
  [2711] = 2711,
  [2712] = 2623,
  [2713] = 2652,
  [2714] = 2714,
  [2715] = 2636,
  [2716] = 2716,
  [2717] = 2716,
  [2718] = 2652,
  [2719] = 2652,
  [2720] = 2720,
  [2721] = 2721,
  [2722] = 2629,
  [2723] = 2618,
  [2724] = 2618,
  [2725] = 2619,
  [2726] = 2638,
  [2727] = 2710,
  [2728] = 2728,
  [2729] = 2622,
  [2730] = 2730,
  [2731] = 2619,
  [2732] = 2732,
  [2733] = 2733,
  [2734] = 2700,
  [2735] = 2614,
  [2736] = 2709,
  [2737] = 2623,
  [2738] = 2721,
  [2739] = 2632,
  [2740] = 2622,
  [2741] = 2716,
  [2742] = 2620,
  [2743] = 2623,
  [2744] = 2720,
  [2745] = 2614,
  [2746] = 2746,
  [2747] = 2747,
  [2748] = 2616,
  [2749] = 2628,
  [2750] = 2638,
  [2751] = 2620,
  [2752] = 2622,
  [2753] = 2616,
  [2754] = 2620,
  [2755] = 2623,
  [2756] = 2756,
  [2757] = 2680,
  [2758] = 2663,
  [2759] = 2629,
  [2760] = 2702,
  [2761] = 2618,
  [2762] = 2629,
  [2763] = 2632,
  [2764] = 2616,
  [2765] = 2614,
  [2766] = 2628,
  [2767] = 2680,
  [2768] = 2768,
  [2769] = 2769,
  [2770] = 2636,
  [2771] = 2746,
  [2772] = 2697,
  [2773] = 2650,
  [2774] = 2669,
  [2775] = 2700,
  [2776] = 2629,
  [2777] = 2711,
  [2778] = 2615,
  [2779] = 2619,
  [2780] = 2636,
  [2781] = 2630,
  [2782] = 2636,
  [2783] = 2709,
  [2784] = 2707,
  [2785] = 2619,
  [2786] = 2630,
  [2787] = 2721,
  [2788] = 2632,
  [2789] = 2632,
  [2790] = 2615,
  [2791] = 2616,
  [2792] = 2769,
  [2793] = 2680,
  [2794] = 2698,
  [2795] = 2795,
  [2796] = 2716,
  [2797] = 2688,
  [2798] = 2798,
  [2799] = 2618,
  [2800] = 2714,
  [2801] = 2681,
  [2802] = 2701,
  [2803] = 2803,
  [2804] = 2795,
  [2805] = 2701,
  [2806] = 2798,
  [2807] = 2619,
  [2808] = 2614,
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xba, 0xba}, {0xc0, 0xd6}, {0xd8, 0xf6},
  {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x370, 0x374}, {0x376, 0x377}, {0x37b, 0x37d},
  {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481}, {0x48a, 0x52f},
  {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x620, 0x64a}, {0x66e, 0x66f}, {0x671, 0x6d3},
  {0x6d5, 0x6d5}, {0x6e5, 0x6e6}, {0x6ee, 0x6ef}, {0x6fa, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x710}, {0x712, 0x72f}, {0x74d, 0x7a5},
  {0x7b1, 0x7b1}, {0x7ca, 0x7ea}, {0x7f4, 0x7f5}, {0x7fa, 0x7fa}, {0x800, 0x815}, {0x81a, 0x81a}, {0x824, 0x824}, {0x828, 0x828},
  {0x840, 0x858}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x8a0, 0x8c9}, {0x904, 0x939}, {0x93d, 0x93d}, {0x950, 0x950},
  {0x958, 0x961}, {0x971, 0x980}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9},
  {0x9bd, 0x9bd}, {0x9ce, 0x9ce}, {0x9dc, 0x9dd}, {0x9df, 0x9e1}, {0x9f0, 0x9f1}, {0x9fc, 0x9fc}, {0xa05, 0xa0a}, {0xa0f, 0xa10},
  {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39}, {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa72, 0xa74},
  {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabd, 0xabd}, {0xad0, 0xad0},
  {0xae0, 0xae1}, {0xaf9, 0xaf9}, {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39},
  {0xb3d, 0xb3d}, {0xb5c, 0xb5d}, {0xb5f, 0xb61}, {0xb71, 0xb71}, {0xb83, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90}, {0xb92, 0xb95},
  {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbd0, 0xbd0}, {0xc05, 0xc0c},
  {0xc0e, 0xc10}, {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3d, 0xc3d}, {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc61}, {0xc80, 0xc80},
  {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbd, 0xcbd}, {0xcdd, 0xcde}, {0xce0, 0xce1},
  {0xcf1, 0xcf2}, {0xd04, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd3a}, {0xd3d, 0xd3d}, {0xd4e, 0xd4e}, {0xd54, 0xd56}, {0xd5f, 0xd61},
  {0xd7a, 0xd7f}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xe01, 0xe30}, {0xe32, 0xe32},
  {0xe40, 0xe46}, {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xeb0}, {0xeb2, 0xeb2},
  {0xebd, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf40, 0xf47}, {0xf49, 0xf6c}, {0xf88, 0xf8c},
  {0x1000, 0x102a}, {0x103f, 0x103f}, {0x1050, 0x1055}, {0x105a, 0x105d}, {0x1061, 0x1061}, {0x1065, 0x1066}, {0x106e, 0x1070}, {0x1075, 0x1081},
  {0x108e, 0x108e}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256},
  {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0},
  {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd},
  {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1711}, {0x171f, 0x1731}, {0x1740, 0x1751},
  {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dc}, {0x1820, 0x1878}, {0x1880, 0x18a8}, {0x18aa, 0x18aa},
  {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1950, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x1a00, 0x1a16}, {0x1a20, 0x1a54},
  {0x1aa7, 0x1aa7}, {0x1b05, 0x1b33}, {0x1b45, 0x1b4c}, {0x1b83, 0x1ba0}, {0x1bae, 0x1baf}, {0x1bba, 0x1be5}, {0x1c00, 0x1c23}, {0x1c4d, 0x1c4f},
  {0x1c5a, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3}, {0x1cf5, 0x1cf6}, {0x1cfa, 0x1cfa},
  {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b},
  {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3},
  {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x2071, 0x2071}, {0x207f, 0x207f}, {0x2090, 0x209c}, {0x2102, 0x2102},
  {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139},
  {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25},
  {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6},
  {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x3005, 0x3007}, {0x3021, 0x3029}, {0x3031, 0x3035},
  {0x3038, 0x303c}, {0x3041, 0x3096}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf},
  {0x31f0, 0x31ff}, {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa61f}, {0xa62a, 0xa62b}, {0xa640, 0xa66e},
  {0xa67f, 0xa69d}, {0xa6a0, 0xa6ef}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9},
  {0xa7f2, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa822}, {0xa840, 0xa873}, {0xa882, 0xa8b3}, {0xa8f2, 0xa8f7}, {0xa8fb, 0xa8fb},
  {0xa8fd, 0xa8fe}, {0xa90a, 0xa925}, {0xa930, 0xa946}, {0xa960, 0xa97c}, {0xa984, 0xa9b2}, {0xa9cf, 0xa9cf}, {0xa9e0, 0xa9e4}, {0xa9e6, 0xa9ef},
  {0xa9fa, 0xa9fe}, {0xaa00, 0xaa28}, {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa60, 0xaa76}, {0xaa7a, 0xaa7a}, {0xaa7e, 0xaaaf}, {0xaab1, 0xaab1},
  {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaac0, 0xaac0}, {0xaac2, 0xaac2}, {0xaadb, 0xaadd}, {0xaae0, 0xaaea}, {0xaaf2, 0xaaf4}, {0xab01, 0xab06},
  {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab69}, {0xab70, 0xabe2}, {0xac00, 0xd7a3},
  {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb1d}, {0xfb1f, 0xfb28},
  {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d},
  {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b},
  {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xff9d}, {0xffa0, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf},
  {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d},
  {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x10375}, {0x10380, 0x1039d},
  {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563},
  {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc},
  {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808},
  {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5},
  {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a00}, {0x10a10, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35},
  {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91},
  {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d23}, {0x10e80, 0x10ea9}, {0x10eb0, 0x10eb1}, {0x10f00, 0x10f1c}, {0x10f27, 0x10f27},
  {0x10f30, 0x10f45}, {0x10f70, 0x10f81}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11003, 0x11037}, {0x11071, 0x11072}, {0x11075, 0x11075}, {0x11083, 0x110af},
  {0x110d0, 0x110e8}, {0x11103, 0x11126}, {0x11144, 0x11144}, {0x11147, 0x11147}, {0x11150, 0x11172}, {0x11176, 0x11176}, {0x11183, 0x111b2}, {0x111c1, 0x111c4},
  {0x111da, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x1122b}, {0x1123f, 0x11240}, {0x11280, 0x11286}, {0x11288, 0x11288}, {0x1128a, 0x1128d},
  {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112de}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333},
  {0x11335, 0x11339}, {0x1133d, 0x1133d}, {0x11350, 0x11350}, {0x1135d, 0x11361}, {0x11400, 0x11434}, {0x11447, 0x1144a}, {0x1145f, 0x11461}, {0x11480, 0x114af},
  {0x114c4, 0x114c5}, {0x114c7, 0x114c7}, {0x11580, 0x115ae}, {0x115d8, 0x115db}, {0x11600, 0x1162f}, {0x11644, 0x11644}, {0x11680, 0x116aa}, {0x116b8, 0x116b8},
  {0x11700, 0x1171a}, {0x11740, 0x11746}, {0x11800, 0x1182b}, {0x118a0, 0x118df}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916},
  {0x11918, 0x1192f}, {0x1193f, 0x1193f}, {0x11941, 0x11941}, {0x119a0, 0x119a7}, {0x119aa, 0x119d0}, {0x119e1, 0x119e1}, {0x119e3, 0x119e3}, {0x11a00, 0x11a00},
  {0x11a0b, 0x11a32}, {0x11a3a, 0x11a3a}, {0x11a50, 0x11a50}, {0x11a5c, 0x11a89}, {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c2e},
  {0x11c40, 0x11c40}, {0x11c72, 0x11c8f}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d30}, {0x11d46, 0x11d46}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68},
  {0x11d6a, 0x11d89}, {0x11d98, 0x11d98}, {0x11ee0, 0x11ef2}, {0x11f02, 0x11f02}, {0x11f04, 0x11f10}, {0x11f12, 0x11f33}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399},
  {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0}, {0x13000, 0x1342f}, {0x13441, 0x13446}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e},
  {0x16a70, 0x16abe}, {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f}, {0x16b40, 0x16b43}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f}, {0x16f00, 0x16f4a},
  {0x16f50, 0x16f50}, {0x16f93, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe3}, {0x17000, 0x187f7}, {0x18800, 0x18cd5}, {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3},
  {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b132, 0x1b132}, {0x1b150, 0x1b152}, {0x1b155, 0x1b155}, {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb},
  {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2},
  {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514},
  {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0},
  {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8},
  {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e030, 0x1e06d}, {0x1e100, 0x1e12c}, {0x1e137, 0x1e13d}, {0x1e14e, 0x1e14e},
  {0x1e290, 0x1e2ad}, {0x1e2c0, 0x1e2eb}, {0x1e4d0, 0x1e4eb}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4},
  {0x1e900, 0x1e943}, {0x1e94b, 0x1e94b}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24}, {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32},
  {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49}, {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f},
  {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d}, {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62},
  {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b},
  {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x20000, 0x2a6df}, {0x2a700, 0x2b739}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0},
  {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x323af},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'0', '9'}, {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xb7, 0xb7}, {0xba, 0xba},
  {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x300, 0x374},
  {0x376, 0x377}, {0x37b, 0x37d}, {0x37f, 0x37f}, {0x386, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481},
  {0x483, 0x487}, {0x48a, 0x52f}, {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x591, 0x5bd}, {0x5bf, 0x5bf}, {0x5c1, 0x5c2},
  {0x5c4, 0x5c5}, {0x5c7, 0x5c7}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x610, 0x61a}, {0x620, 0x669}, {0x66e, 0x6d3}, {0x6d5, 0x6dc},
  {0x6df, 0x6e8}, {0x6ea, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x74a}, {0x74d, 0x7b1}, {0x7c0, 0x7f5}, {0x7fa, 0x7fa}, {0x7fd, 0x7fd},
  {0x800, 0x82d}, {0x840, 0x85b}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x898, 0x8e1}, {0x8e3, 0x963}, {0x966, 0x96f},
  {0x971, 0x983}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9}, {0x9bc, 0x9c4},
  {0x9c7, 0x9c8}, {0x9cb, 0x9ce}, {0x9d7, 0x9d7}, {0x9dc, 0x9dd}, {0x9df, 0x9e3}, {0x9e6, 0x9f1}, {0x9fc, 0x9fc}, {0x9fe, 0x9fe},
  {0xa01, 0xa03}, {0xa05, 0xa0a}, {0xa0f, 0xa10}, {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39},
  {0xa3c, 0xa3c}, {0xa3e, 0xa42}, {0xa47, 0xa48}, {0xa4b, 0xa4d}, {0xa51, 0xa51}, {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa66, 0xa75},
  {0xa81, 0xa83}, {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabc, 0xac5},
  {0xac7, 0xac9}, {0xacb, 0xacd}, {0xad0, 0xad0}, {0xae0, 0xae3}, {0xae6, 0xaef}, {0xaf9, 0xaff}, {0xb01, 0xb03}, {0xb05, 0xb0c},
  {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39}, {0xb3c, 0xb44}, {0xb47, 0xb48}, {0xb4b, 0xb4d},
  {0xb55, 0xb57}, {0xb5c, 0xb5d}, {0xb5f, 0xb63}, {0xb66, 0xb6f}, {0xb71, 0xb71}, {0xb82, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90},
  {0xb92, 0xb95}, {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbbe, 0xbc2},
  {0xbc6, 0xbc8}, {0xbca, 0xbcd}, {0xbd0, 0xbd0}, {0xbd7, 0xbd7}, {0xbe6, 0xbef}, {0xc00, 0xc0c}, {0xc0e, 0xc10}, {0xc12, 0xc28},
  {0xc2a, 0xc39}, {0xc3c, 0xc44}, {0xc46, 0xc48}, {0xc4a, 0xc4d}, {0xc55, 0xc56}, {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc63},
  {0xc66, 0xc6f}, {0xc80, 0xc83}, {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbc, 0xcc4},
  {0xcc6, 0xcc8}, {0xcca, 0xccd}, {0xcd5, 0xcd6}, {0xcdd, 0xcde}, {0xce0, 0xce3}, {0xce6, 0xcef}, {0xcf1, 0xcf3}, {0xd00, 0xd0c},
  {0xd0e, 0xd10}, {0xd12, 0xd44}, {0xd46, 0xd48}, {0xd4a, 0xd4e}, {0xd54, 0xd57}, {0xd5f, 0xd63}, {0xd66, 0xd6f}, {0xd7a, 0xd7f},
  {0xd81, 0xd83}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xdca, 0xdca}, {0xdcf, 0xdd4},
  {0xdd6, 0xdd6}, {0xdd8, 0xddf}, {0xde6, 0xdef}, {0xdf2, 0xdf3}, {0xe01, 0xe3a}, {0xe40, 0xe4e}, {0xe50, 0xe59}, {0xe81, 0xe82},
  {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xec8, 0xece},
  {0xed0, 0xed9}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf18, 0xf19}, {0xf20, 0xf29}, {0xf35, 0xf35}, {0xf37, 0xf37}, {0xf39, 0xf39},
  {0xf3e, 0xf47}, {0xf49, 0xf6c}, {0xf71, 0xf84}, {0xf86, 0xf97}, {0xf99, 0xfbc}, {0xfc6, 0xfc6}, {0x1000, 0x1049}, {0x1050, 0x109d},
  {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256}, {0x1258, 0x1258},
  {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0}, {0x12c2, 0x12c5},
  {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x135d, 0x135f}, {0x1369, 0x1371}, {0x1380, 0x138f}, {0x13a0, 0x13f5},
  {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1715}, {0x171f, 0x1734},
  {0x1740, 0x1753}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}, {0x1780, 0x17d3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dd}, {0x17e0, 0x17e9},
  {0x180b, 0x180d}, {0x180f, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1920, 0x192b}, {0x1930, 0x193b},
  {0x1946, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, {0x1a00, 0x1a1b}, {0x1a20, 0x1a5e}, {0x1a60, 0x1a7c},
  {0x1a7f, 0x1a89}, {0x1a90, 0x1a99}, {0x1aa7, 0x1aa7}, {0x1ab0, 0x1abd}, {0x1abf, 0x1ace}, {0x1b00, 0x1b4c}, {0x1b50, 0x1b59}, {0x1b6b, 0x1b73},
  {0x1b80, 0x1bf3}, {0x1c00, 0x1c37}, {0x1c40, 0x1c49}, {0x1c4d, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1cd0, 0x1cd2},
  {0x1cd4, 0x1cfa}, {0x1d00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b},
  {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3},
  {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x200c, 0x200d}, {0x203f, 0x2040}, {0x2054, 0x2054}, {0x2071, 0x2071},
  {0x207f, 0x207f}, {0x2090, 0x209c}, {0x20d0, 0x20dc}, {0x20e1, 0x20e1}, {0x20e5, 0x20f0}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210a, 0x2113},
  {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149},
  {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67},
  {0x2d6f, 0x2d6f}, {0x2d7f, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce},
  {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2de0, 0x2dff}, {0x3005, 0x3007}, {0x3021, 0x302f}, {0x3031, 0x3035}, {0x3038, 0x303c}, {0x3041, 0x3096},
  {0x3099, 0x309a}, {0x309d, 0x309f}, {0x30a1, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf}, {0x31f0, 0x31ff}, {0x3400, 0x4dbf},
  {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa62b}, {0xa640, 0xa66f}, {0xa674, 0xa67d}, {0xa67f, 0xa6f1}, {0xa717, 0xa71f},
  {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f2, 0xa827}, {0xa82c, 0xa82c}, {0xa840, 0xa873},
  {0xa880, 0xa8c5}, {0xa8d0, 0xa8d9}, {0xa8e0, 0xa8f7}, {0xa8fb, 0xa8fb}, {0xa8fd, 0xa92d}, {0xa930, 0xa953}, {0xa960, 0xa97c}, {0xa980, 0xa9c0},
  {0xa9cf, 0xa9d9}, {0xa9e0, 0xa9fe}, {0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, {0xaa50, 0xaa59}, {0xaa60, 0xaa76}, {0xaa7a, 0xaac2}, {0xaadb, 0xaadd},
  {0xaae0, 0xaaef}, {0xaaf2, 0xaaf6}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a},
  {0xab5c, 0xab69}, {0xab70, 0xabea}, {0xabec, 0xabed}, {0xabf0, 0xabf9}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d},
  {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41},
  {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe00, 0xfe0f},
  {0xfe20, 0xfe2f}, {0xfe33, 0xfe34}, {0xfe4d, 0xfe4f}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b},
  {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff10, 0xff19}, {0xff21, 0xff3a}, {0xff3f, 0xff3f}, {0xff41, 0xff5a}, {0xff65, 0xffbe}, {0xffc2, 0xffc7},
  {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d},
  {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x101fd, 0x101fd}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x102e0, 0x102e0}, {0x10300, 0x1031f},
  {0x1032d, 0x1034a}, {0x10350, 0x1037a}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104a0, 0x104a9},
  {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595},
  {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785},
  {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855},
  {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf},
  {0x10a00, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a38, 0x10a3a}, {0x10a3f, 0x10a3f}, {0x10a60, 0x10a7c},
  {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae6}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, {0x10c00, 0x10c48},
  {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d27}, {0x10d30, 0x10d39}, {0x10e80, 0x10ea9}, {0x10eab, 0x10eac}, {0x10eb0, 0x10eb1}, {0x10efd, 0x10f1c},
  {0x10f27, 0x10f27}, {0x10f30, 0x10f50}, {0x10f70, 0x10f85}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11000, 0x11046}, {0x11066, 0x11075}, {0x1107f, 0x110ba},
  {0x110c2, 0x110c2}, {0x110d0, 0x110e8}, {0x110f0, 0x110f9}, {0x11100, 0x11134}, {0x11136, 0x1113f}, {0x11144, 0x11147}, {0x11150, 0x11173}, {0x11176, 0x11176},
  {0x11180, 0x111c4}, {0x111c9, 0x111cc}, {0x111ce, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x11237}, {0x1123e, 0x11241}, {0x11280, 0x11286},
  {0x11288, 0x11288}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112ea}, {0x112f0, 0x112f9}, {0x11300, 0x11303}, {0x11305, 0x1130c},
  {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1133b, 0x11344}, {0x11347, 0x11348}, {0x1134b, 0x1134d},
  {0x11350, 0x11350}, {0x11357, 0x11357}, {0x1135d, 0x11363}, {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11400, 0x1144a}, {0x11450, 0x11459}, {0x1145e, 0x11461},
  {0x11480, 0x114c5}, {0x114c7, 0x114c7}, {0x114d0, 0x114d9}, {0x11580, 0x115b5}, {0x115b8, 0x115c0}, {0x115d8, 0x115dd}, {0x11600, 0x11640}, {0x11644, 0x11644},
  {0x11650, 0x11659}, {0x11680, 0x116b8}, {0x116c0, 0x116c9}, {0x11700, 0x1171a}, {0x1171d, 0x1172b}, {0x11730, 0x11739}, {0x11740, 0x11746}, {0x11800, 0x1183a},
  {0x118a0, 0x118e9}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x11935}, {0x11937, 0x11938}, {0x1193b, 0x11943},
  {0x11950, 0x11959}, {0x119a0, 0x119a7}, {0x119aa, 0x119d7}, {0x119da, 0x119e1}, {0x119e3, 0x119e4}, {0x11a00, 0x11a3e}, {0x11a47, 0x11a47}, {0x11a50, 0x11a99},
  {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c36}, {0x11c38, 0x11c40}, {0x11c50, 0x11c59}, {0x11c72, 0x11c8f}, {0x11c92, 0x11ca7},
  {0x11ca9, 0x11cb6}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, {0x11d3a, 0x11d3a}, {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d47}, {0x11d50, 0x11d59},
  {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e}, {0x11d90, 0x11d91}, {0x11d93, 0x11d98}, {0x11da0, 0x11da9}, {0x11ee0, 0x11ef6}, {0x11f00, 0x11f10},
  {0x11f12, 0x11f3a}, {0x11f3e, 0x11f42}, {0x11f50, 0x11f59}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0},
  {0x13000, 0x1342f}, {0x13440, 0x13455}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a60, 0x16a69}, {0x16a70, 0x16abe}, {0x16ac0, 0x16ac9},
  {0x16ad0, 0x16aed}, {0x16af0, 0x16af4}, {0x16b00, 0x16b36}, {0x16b40, 0x16b43}, {0x16b50, 0x16b59}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f},
  {0x16f00, 0x16f4a}, {0x16f4f, 0x16f87}, {0x16f8f, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe4}, {0x16ff0, 0x16ff1}, {0x17000, 0x187f7}, {0x18800, 0x18cd5},
  {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b132, 0x1b132}, {0x1b150, 0x1b152}, {0x1b155, 0x1b155},
  {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1bc9d, 0x1bc9e}, {0x1cf00, 0x1cf2d},
  {0x1cf30, 0x1cf46}, {0x1d165, 0x1d169}, {0x1d16d, 0x1d172}, {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad}, {0x1d242, 0x1d244}, {0x1d400, 0x1d454},
  {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3},
  {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546},
  {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e},
  {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1d7ce, 0x1d7ff}, {0x1da00, 0x1da36}, {0x1da3b, 0x1da6c},
  {0x1da75, 0x1da75}, {0x1da84, 0x1da84}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e000, 0x1e006}, {0x1e008, 0x1e018},
  {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, {0x1e030, 0x1e06d}, {0x1e08f, 0x1e08f}, {0x1e100, 0x1e12c}, {0x1e130, 0x1e13d}, {0x1e140, 0x1e149},
  {0x1e14e, 0x1e14e}, {0x1e290, 0x1e2ae}, {0x1e2c0, 0x1e2f9}, {0x1e4d0, 0x1e4f9}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe},
  {0x1e800, 0x1e8c4}, {0x1e8d0, 0x1e8d6}, {0x1e900, 0x1e94b}, {0x1e950, 0x1e959}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24},
  {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49},
  {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d},
  {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62}, {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e},
  {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1fbf0, 0x1fbf9}, {0x20000, 0x2a6df}, {0x2a700, 0x2b739},
  {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x323af}, {0xe0100, 0xe01ef},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(55);
      if (lookahead == '\r') SKIP(51);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(95);
      if (lookahead == '&') ADVANCE(99);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(63);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(58);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '0') ADVANCE(139);
      if (lookahead == ':') ADVANCE(70);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(105);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(113);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(133);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '^') ADVANCE(101);
      if (lookahead == 'e') ADVANCE(163);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '|') ADVANCE(87);
      if (lookahead == '}') ADVANCE(89);
      if (lookahead == '~') ADVANCE(104);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(51);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(140);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(168);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(130);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(3);
      if (lookahead == '\r') ADVANCE(135);
      if (lookahead == '#') ADVANCE(136);
      if (lookahead == '\\') ADVANCE(134);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '}') ADVANCE(89);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) ADVANCE(135);
      if (lookahead != 0) ADVANCE(136);
      END_STATE();
    case 4:
      if (lookahead == '\r') SKIP(4);
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(95);
      if (lookahead == '&') ADVANCE(99);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(63);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(84);
      if (lookahead == '.') ADVANCE(58);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '0') ADVANCE(139);
      if (lookahead == ':') ADVANCE(70);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(105);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(113);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '^') ADVANCE(101);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '|') ADVANCE(87);
      if (lookahead == '~') ADVANCE(104);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(4);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(140);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 5:
      if (lookahead == '\r') SKIP(5);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(94);
      if (lookahead == '&') ADVANCE(98);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(64);
      if (lookahead == '+') ADVANCE(90);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(83);
      if (lookahead == '.') ADVANCE(58);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == '0') ADVANCE(139);
      if (lookahead == ':') ADVANCE(70);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(106);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(114);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '^') ADVANCE(100);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '|') ADVANCE(86);
      if (lookahead == '}') ADVANCE(89);
      if (lookahead == '~') ADVANCE(104);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(5);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(140);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 6:
      if (lookahead == '\r') SKIP(6);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(21);
      if (lookahead == '&') ADVANCE(22);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(65);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == '-') ADVANCE(84);
      if (lookahead == '.') ADVANCE(15);
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == '0') ADVANCE(139);
      if (lookahead == ':') ADVANCE(69);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(18);
      if (lookahead == '=') ADVANCE(77);
      if (lookahead == '>') ADVANCE(31);
      if (lookahead == '@') ADVANCE(23);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '^') ADVANCE(24);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '|') ADVANCE(25);
      if (lookahead == '~') ADVANCE(104);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(6);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(140);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 7:
      if (lookahead == '\r') SKIP(7);
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(95);
      if (lookahead == '&') ADVANCE(99);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(63);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(84);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == ':') ADVANCE(70);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(105);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(113);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '^') ADVANCE(101);
      if (lookahead == '|') ADVANCE(87);
      if (lookahead == '}') ADVANCE(89);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(7);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 8:
      if (lookahead == '\r') SKIP(8);
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(95);
      if (lookahead == '&') ADVANCE(99);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(63);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(84);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == ':') ADVANCE(69);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(105);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(113);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '^') ADVANCE(101);
      if (lookahead == '|') ADVANCE(87);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(8);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 9:
      if (lookahead == '\r') SKIP(9);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '-') ADVANCE(30);
      if (lookahead == ':') ADVANCE(69);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == 'e') ADVANCE(163);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(9);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 10:
      if (lookahead == '\r') ADVANCE(1);
      if ((!eof && lookahead == 00) ||
          lookahead == '\n') ADVANCE(168);
      END_STATE();
    case 11:
      if (lookahead == '\r') SKIP(11);
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(95);
      if (lookahead == '&') ADVANCE(99);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(63);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(84);
      if (lookahead == '.') ADVANCE(58);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '0') ADVANCE(139);
      if (lookahead == ':') ADVANCE(69);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(105);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(113);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '^') ADVANCE(101);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '|') ADVANCE(87);
      if (lookahead == '~') ADVANCE(104);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(11);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(140);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 12:
      if (lookahead == '\r') SKIP(12);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(94);
      if (lookahead == '&') ADVANCE(98);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(64);
      if (lookahead == '+') ADVANCE(90);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(83);
      if (lookahead == '.') ADVANCE(58);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == '0') ADVANCE(139);
      if (lookahead == ':') ADVANCE(69);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(106);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(114);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '^') ADVANCE(100);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '|') ADVANCE(86);
      if (lookahead == '}') ADVANCE(89);
      if (lookahead == '~') ADVANCE(104);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(12);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(140);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 13:
      if (lookahead == '\r') SKIP(13);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(94);
      if (lookahead == '&') ADVANCE(98);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(64);
      if (lookahead == '+') ADVANCE(90);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(83);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == ':') ADVANCE(69);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(106);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(114);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '^') ADVANCE(100);
      if (lookahead == '|') ADVANCE(86);
      if (lookahead == '}') ADVANCE(89);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(13);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 14:
      if (lookahead == '\r') SKIP(14);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(94);
      if (lookahead == '&') ADVANCE(98);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(64);
      if (lookahead == '+') ADVANCE(90);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(83);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == ':') ADVANCE(70);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(106);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(114);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '^') ADVANCE(100);
      if (lookahead == '|') ADVANCE(86);
      if (lookahead == '}') ADVANCE(89);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(14);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 15:
      if (lookahead == '.') ADVANCE(16);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(146);
      END_STATE();
    case 16:
      if (lookahead == '.') ADVANCE(129);
      END_STATE();
    case 17:
      if (lookahead == '/') ADVANCE(27);
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 18:
      if (lookahead == '<') ADVANCE(28);
      END_STATE();
    case 19:
      if (lookahead == '=') ADVANCE(110);
      END_STATE();
    case 20:
      if (lookahead == '=') ADVANCE(110);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 21:
      if (lookahead == '=') ADVANCE(122);
      END_STATE();
    case 22:
      if (lookahead == '=') ADVANCE(126);
      END_STATE();
    case 23:
      if (lookahead == '=') ADVANCE(120);
      END_STATE();
    case 24:
      if (lookahead == '=') ADVANCE(127);
      END_STATE();
    case 25:
      if (lookahead == '=') ADVANCE(128);
      END_STATE();
    case 26:
      if (lookahead == '=') ADVANCE(123);
      END_STATE();
    case 27:
      if (lookahead == '=') ADVANCE(121);
      END_STATE();
    case 28:
      if (lookahead == '=') ADVANCE(125);
      END_STATE();
    case 29:
      if (lookahead == '=') ADVANCE(124);
      END_STATE();
    case 30:
      if (lookahead == '>') ADVANCE(74);
      END_STATE();
    case 31:
      if (lookahead == '>') ADVANCE(29);
      END_STATE();
    case 32:
      if (lookahead == '_') ADVANCE(38);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(142);
      END_STATE();
    case 33:
      if (lookahead == '_') ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(143);
      END_STATE();
    case 34:
      if (lookahead == '_') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(144);
      END_STATE();
    case 35:
      if (lookahead == '{') ADVANCE(50);
      END_STATE();
    case 36:
      if (lookahead == '}') ADVANCE(130);
      if (lookahead != 0) ADVANCE(36);
      END_STATE();
    case 37:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(147);
      END_STATE();
    case 38:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(142);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(143);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(147);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(130);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(144);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(41);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 50:
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(36);
      END_STATE();
    case 51:
      if (eof) ADVANCE(55);
      if (lookahead == '\r') SKIP(51);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(95);
      if (lookahead == '&') ADVANCE(99);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(63);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(58);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '0') ADVANCE(139);
      if (lookahead == ':') ADVANCE(70);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(105);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(113);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '^') ADVANCE(101);
      if (lookahead == 'e') ADVANCE(163);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '|') ADVANCE(87);
      if (lookahead == '}') ADVANCE(89);
      if (lookahead == '~') ADVANCE(104);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(51);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(140);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 52:
      if (eof) ADVANCE(55);
      if (lookahead == '\r') SKIP(52);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '+') ADVANCE(90);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(83);
      if (lookahead == '.') ADVANCE(15);
      if (lookahead == '0') ADVANCE(139);
      if (lookahead == ':') ADVANCE(69);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(107);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(112);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '|') ADVANCE(86);
      if (lookahead == '}') ADVANCE(89);
      if (lookahead == '~') ADVANCE(104);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(52);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(140);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 53:
      if (eof) ADVANCE(55);
      if (lookahead == '\r') SKIP(53);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '+') ADVANCE(90);
      if (lookahead == '-') ADVANCE(83);
      if (lookahead == '.') ADVANCE(15);
      if (lookahead == '0') ADVANCE(139);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == 'e') ADVANCE(164);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '~') ADVANCE(104);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(53);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(140);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 54:
      if (eof) ADVANCE(55);
      if (lookahead == '\r') SKIP(54);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '+') ADVANCE(90);
      if (lookahead == '-') ADVANCE(83);
      if (lookahead == '.') ADVANCE(15);
      if (lookahead == '0') ADVANCE(139);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == 'e') ADVANCE(165);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '~') ADVANCE(104);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(54);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(140);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(16);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(146);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(76);
      if (lookahead == '=') ADVANCE(118);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(75);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(26);
      if (lookahead == '=') ADVANCE(118);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(124);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(68);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_except);
      if (lookahead == '*') ADVANCE(73);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_except);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_except_STAR);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(123);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(109);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '=') ADVANCE(120);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(117);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(117);
      if (lookahead == '>') ADVANCE(74);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(128);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(116);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(97);
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(96);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(122);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead == '=') ADVANCE(121);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '=') ADVANCE(126);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(127);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(125);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(103);
      if (lookahead == '=') ADVANCE(108);
      if (lookahead == '>') ADVANCE(115);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(102);
      if (lookahead == '=') ADVANCE(108);
      if (lookahead == '>') ADVANCE(115);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(108);
      if (lookahead == '>') ADVANCE(115);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(111);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(111);
      if (lookahead == '>') ADVANCE(67);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(111);
      if (lookahead == '>') ADVANCE(66);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_AT_EQ);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH_EQ);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_ellipsis);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(130);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(131);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      ADVANCE_MAP(
        0, 168,
        '\n', 130,
        '\r', 2,
        'N', 35,
        'U', 49,
        'u', 45,
        'x', 43,
        '"', 130,
        '\'', 130,
        '\\', 130,
        'a', 130,
        'b', 130,
        'f', 130,
        'n', 130,
        'r', 130,
        't', 130,
        'v', 130,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(132);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if ((!eof && lookahead == 00)) ADVANCE(136);
      if (lookahead == '\r') ADVANCE(136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(136);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      ADVANCE_MAP(
        '\r', 135,
        '#', 136,
        '\\', 134,
        '\t', 135,
        0x0b, 135,
        '\f', 135,
        ' ', 135,
        0x200b, 135,
        0x2060, 135,
        0xfeff, 135,
      );
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(136);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(136);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_type_conversion);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_integer);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_integer);
      ADVANCE_MAP(
        '.', 148,
        '_', 141,
        'B', 32,
        'b', 32,
        'E', 37,
        'e', 37,
        'O', 33,
        'o', 33,
        'X', 34,
        'x', 34,
        'J', 138,
        'L', 138,
        'j', 138,
        'l', 138,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(140);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_integer);
      ADVANCE_MAP(
        '.', 148,
        '_', 141,
        'E', 37,
        'e', 37,
        'J', 138,
        'L', 138,
        'j', 138,
        'l', 138,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(140);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(37);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(138);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(140);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(38);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(138);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(142);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(39);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(138);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(143);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(42);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(138);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(144);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_float);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(148);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(37);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(145);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(146);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(149);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(145);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(147);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(37);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(145);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(146);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(145);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(147);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '*') ADVANCE(73);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(154);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(155);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(156);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(157);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(158);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(159);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(160);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(161);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(162);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(71);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(150);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'x') ADVANCE(151);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'x') ADVANCE(152);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'x') ADVANCE(153);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_identifier);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(167);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_line_continuation);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\r') SKIP(0);
      if (lookahead == 'F') ADVANCE(1);
      if (lookahead == 'N') ADVANCE(2);
      if (lookahead == 'T') ADVANCE(3);
      if (lookahead == '_') ADVANCE(4);
      if (lookahead == 'a') ADVANCE(5);
      if (lookahead == 'b') ADVANCE(6);
      if (lookahead == 'c') ADVANCE(7);
      if (lookahead == 'd') ADVANCE(8);
      if (lookahead == 'e') ADVANCE(9);
      if (lookahead == 'f') ADVANCE(10);
      if (lookahead == 'g') ADVANCE(11);
      if (lookahead == 'i') ADVANCE(12);
      if (lookahead == 'l') ADVANCE(13);
      if (lookahead == 'm') ADVANCE(14);
      if (lookahead == 'n') ADVANCE(15);
      if (lookahead == 'o') ADVANCE(16);
      if (lookahead == 'p') ADVANCE(17);
      if (lookahead == 'r') ADVANCE(18);
      if (lookahead == 't') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      if (lookahead == 'y') ADVANCE(21);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'a') ADVANCE(22);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(23);
      END_STATE();
    case 3:
      if (lookahead == 'r') ADVANCE(24);
      END_STATE();
    case 4:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '_') ADVANCE(25);
      END_STATE();
    case 5:
      if (lookahead == 'n') ADVANCE(26);
      if (lookahead == 's') ADVANCE(27);
      if (lookahead == 'w') ADVANCE(28);
      END_STATE();
    case 6:
      if (lookahead == 'r') ADVANCE(29);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(30);
      if (lookahead == 'l') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(32);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(33);
      END_STATE();
    case 9:
      if (lookahead == 'l') ADVANCE(34);
      if (lookahead == 'x') ADVANCE(35);
      END_STATE();
    case 10:
      if (lookahead == 'i') ADVANCE(36);
      if (lookahead == 'o') ADVANCE(37);
      if (lookahead == 'r') ADVANCE(38);
      END_STATE();
    case 11:
      if (lookahead == 'l') ADVANCE(39);
      END_STATE();
    case 12:
      if (lookahead == 'f') ADVANCE(40);
      if (lookahead == 'm') ADVANCE(41);
      if (lookahead == 'n') ADVANCE(42);
      if (lookahead == 's') ADVANCE(43);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(44);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(45);
      END_STATE();
    case 15:
      if (lookahead == 'o') ADVANCE(46);
      END_STATE();
    case 16:
      if (lookahead == 'r') ADVANCE(47);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(48);
      if (lookahead == 'r') ADVANCE(49);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(50);
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 19:
      if (lookahead == 'r') ADVANCE(52);
      if (lookahead == 'y') ADVANCE(53);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(54);
      if (lookahead == 'i') ADVANCE(55);
      END_STATE();
    case 21:
      if (lookahead == 'i') ADVANCE(56);
      END_STATE();
    case 22:
      if (lookahead == 'l') ADVANCE(57);
      END_STATE();
    case 23:
      if (lookahead == 'n') ADVANCE(58);
      END_STATE();
    case 24:
      if (lookahead == 'u') ADVANCE(59);
      END_STATE();
    case 25:
      if (lookahead == 'f') ADVANCE(60);
      END_STATE();
    case 26:
      if (lookahead == 'd') ADVANCE(61);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(62);
      if (lookahead == 'y') ADVANCE(63);
      END_STATE();
    case 28:
      if (lookahead == 'a') ADVANCE(64);
      END_STATE();
    case 29:
      if (lookahead == 'e') ADVANCE(65);
      END_STATE();
    case 30:
      if (lookahead == 's') ADVANCE(66);
      END_STATE();
    case 31:
      if (lookahead == 'a') ADVANCE(67);
      END_STATE();
    case 32:
      if (lookahead == 'n') ADVANCE(68);
      END_STATE();
    case 33:
      if (lookahead == 'f') ADVANCE(69);
      if (lookahead == 'l') ADVANCE(70);
      END_STATE();
    case 34:
      if (lookahead == 'i') ADVANCE(71);
      if (lookahead == 's') ADVANCE(72);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(73);
      END_STATE();
    case 36:
      if (lookahead == 'n') ADVANCE(74);
      END_STATE();
    case 37:
      if (lookahead == 'r') ADVANCE(75);
      END_STATE();
    case 38:
      if (lookahead == 'o') ADVANCE(76);
      END_STATE();
    case 39:
      if (lookahead == 'o') ADVANCE(77);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 41:
      if (lookahead == 'p') ADVANCE(78);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 44:
      if (lookahead == 'm') ADVANCE(79);
      END_STATE();
    case 45:
      if (lookahead == 't') ADVANCE(80);
      END_STATE();
    case 46:
      if (lookahead == 'n') ADVANCE(81);
      if (lookahead == 't') ADVANCE(82);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 48:
      if (lookahead == 's') ADVANCE(83);
      END_STATE();
    case 49:
      if (lookahead == 'i') ADVANCE(84);
      END_STATE();
    case 50:
      if (lookahead == 'i') ADVANCE(85);
      END_STATE();
    case 51:
      if (lookahead == 't') ADVANCE(86);
      END_STATE();
    case 52:
      if (lookahead == 'y') ADVANCE(87);
      END_STATE();
    case 53:
      if (lookahead == 'p') ADVANCE(88);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(89);
      END_STATE();
    case 55:
      if (lookahead == 't') ADVANCE(90);
      END_STATE();
    case 56:
      if (lookahead == 'e') ADVANCE(91);
      END_STATE();
    case 57:
      if (lookahead == 's') ADVANCE(92);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(93);
      END_STATE();
    case 59:
      if (lookahead == 'e') ADVANCE(94);
      END_STATE();
    case 60:
      if (lookahead == 'u') ADVANCE(95);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(96);
      END_STATE();
    case 63:
      if (lookahead == 'n') ADVANCE(97);
      END_STATE();
    case 64:
      if (lookahead == 'i') ADVANCE(98);
      END_STATE();
    case 65:
      if (lookahead == 'a') ADVANCE(99);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(100);
      END_STATE();
    case 67:
      if (lookahead == 's') ADVANCE(101);
      END_STATE();
    case 68:
      if (lookahead == 't') ADVANCE(102);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_def);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_del);
      END_STATE();
    case 71:
      if (lookahead == 'f') ADVANCE(103);
      END_STATE();
    case 72:
      if (lookahead == 'e') ADVANCE(104);
      END_STATE();
    case 73:
      if (lookahead == 'c') ADVANCE(105);
      END_STATE();
    case 74:
      if (lookahead == 'a') ADVANCE(106);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 76:
      if (lookahead == 'm') ADVANCE(107);
      END_STATE();
    case 77:
      if (lookahead == 'b') ADVANCE(108);
      END_STATE();
    case 78:
      if (lookahead == 'o') ADVANCE(109);
      END_STATE();
    case 79:
      if (lookahead == 'b') ADVANCE(110);
      END_STATE();
    case 80:
      if (lookahead == 'c') ADVANCE(111);
      END_STATE();
    case 81:
      if (lookahead == 'l') ADVANCE(112);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 83:
      if (lookahead == 's') ADVANCE(113);
      END_STATE();
    case 84:
      if (lookahead == 'n') ADVANCE(114);
      END_STATE();
    case 85:
      if (lookahead == 's') ADVANCE(115);
      END_STATE();
    case 86:
      if (lookahead == 'u') ADVANCE(116);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 88:
      if (lookahead == 'e') ADVANCE(117);
      END_STATE();
    case 89:
      if (lookahead == 'l') ADVANCE(118);
      END_STATE();
    case 90:
      if (lookahead == 'h') ADVANCE(119);
      END_STATE();
    case 91:
      if (lookahead == 'l') ADVANCE(120);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(121);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_none);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 95:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 96:
      if (lookahead == 'r') ADVANCE(123);
      END_STATE();
    case 97:
      if (lookahead == 'c') ADVANCE(124);
      END_STATE();
    case 98:
      if (lookahead == 't') ADVANCE(125);
      END_STATE();
    case 99:
      if (lookahead == 'k') ADVANCE(126);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 101:
      if (lookahead == 's') ADVANCE(127);
      END_STATE();
    case 102:
      if (lookahead == 'i') ADVANCE(128);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_elif);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_exec);
      END_STATE();
    case 106:
      if (lookahead == 'l') ADVANCE(129);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 108:
      if (lookahead == 'a') ADVANCE(130);
      END_STATE();
    case 109:
      if (lookahead == 'r') ADVANCE(131);
      END_STATE();
    case 110:
      if (lookahead == 'd') ADVANCE(132);
      END_STATE();
    case 111:
      if (lookahead == 'h') ADVANCE(133);
      END_STATE();
    case 112:
      if (lookahead == 'o') ADVANCE(134);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_pass);
      END_STATE();
    case 114:
      if (lookahead == 't') ADVANCE(135);
      END_STATE();
    case 115:
      if (lookahead == 'e') ADVANCE(136);
      END_STATE();
    case 116:
      if (lookahead == 'r') ADVANCE(137);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 118:
      if (lookahead == 'e') ADVANCE(138);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 120:
      if (lookahead == 'd') ADVANCE(139);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 122:
      if (lookahead == 'u') ADVANCE(140);
      END_STATE();
    case 123:
      if (lookahead == 't') ADVANCE(141);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 128:
      if (lookahead == 'n') ADVANCE(142);
      END_STATE();
    case 129:
      if (lookahead == 'l') ADVANCE(143);
      END_STATE();
    case 130:
      if (lookahead == 'l') ADVANCE(144);
      END_STATE();
    case 131:
      if (lookahead == 't') ADVANCE(145);
      END_STATE();
    case 132:
      if (lookahead == 'a') ADVANCE(146);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_match);
      END_STATE();
    case 134:
      if (lookahead == 'c') ADVANCE(147);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_print);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_raise);
      END_STATE();
    case 137:
      if (lookahead == 'n') ADVANCE(148);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 140:
      if (lookahead == 'r') ADVANCE(149);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 142:
      if (lookahead == 'u') ADVANCE(150);
      END_STATE();
    case 143:
      if (lookahead == 'y') ADVANCE(151);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_lambda);
      END_STATE();
    case 147:
      if (lookahead == 'a') ADVANCE(152);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 149:
      if (lookahead == 'e') ADVANCE(153);
      END_STATE();
    case 150:
      if (lookahead == 'e') ADVANCE(154);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 152:
      if (lookahead == 'l') ADVANCE(155);
      END_STATE();
    case 153:
      if (lookahead == '_') ADVANCE(156);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_nonlocal);
      END_STATE();
    case 156:
      if (lookahead == '_') ADVANCE(157);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym___future__);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 52, .external_lex_state = 2},
  [2] = {.lex_state = 52, .external_lex_state = 3},
  [3] = {.lex_state = 52, .external_lex_state = 3},
  [4] = {.lex_state = 52, .external_lex_state = 3},
  [5] = {.lex_state = 52, .external_lex_state = 3},
  [6] = {.lex_state = 52, .external_lex_state = 3},
  [7] = {.lex_state = 52, .external_lex_state = 3},
  [8] = {.lex_state = 52, .external_lex_state = 3},
  [9] = {.lex_state = 52, .external_lex_state = 3},
  [10] = {.lex_state = 52, .external_lex_state = 3},
  [11] = {.lex_state = 52, .external_lex_state = 3},
  [12] = {.lex_state = 52, .external_lex_state = 3},
  [13] = {.lex_state = 52, .external_lex_state = 3},
  [14] = {.lex_state = 52, .external_lex_state = 3},
  [15] = {.lex_state = 52, .external_lex_state = 3},
  [16] = {.lex_state = 52, .external_lex_state = 3},
  [17] = {.lex_state = 52, .external_lex_state = 3},
  [18] = {.lex_state = 52, .external_lex_state = 3},
  [19] = {.lex_state = 52, .external_lex_state = 3},
  [20] = {.lex_state = 52, .external_lex_state = 3},
  [21] = {.lex_state = 52, .external_lex_state = 3},
  [22] = {.lex_state = 52, .external_lex_state = 3},
  [23] = {.lex_state = 52, .external_lex_state = 3},
  [24] = {.lex_state = 52, .external_lex_state = 3},
  [25] = {.lex_state = 52, .external_lex_state = 3},
  [26] = {.lex_state = 52, .external_lex_state = 3},
  [27] = {.lex_state = 52, .external_lex_state = 3},
  [28] = {.lex_state = 52, .external_lex_state = 3},
  [29] = {.lex_state = 52, .external_lex_state = 3},
  [30] = {.lex_state = 52, .external_lex_state = 3},
  [31] = {.lex_state = 52, .external_lex_state = 3},
  [32] = {.lex_state = 52, .external_lex_state = 3},
  [33] = {.lex_state = 52, .external_lex_state = 3},
  [34] = {.lex_state = 52, .external_lex_state = 3},
  [35] = {.lex_state = 52, .external_lex_state = 3},
  [36] = {.lex_state = 52, .external_lex_state = 3},
  [37] = {.lex_state = 52, .external_lex_state = 3},
  [38] = {.lex_state = 52, .external_lex_state = 3},
  [39] = {.lex_state = 52, .external_lex_state = 3},
  [40] = {.lex_state = 52, .external_lex_state = 3},
  [41] = {.lex_state = 52, .external_lex_state = 3},
  [42] = {.lex_state = 52, .external_lex_state = 3},
  [43] = {.lex_state = 52, .external_lex_state = 3},
  [44] = {.lex_state = 52, .external_lex_state = 3},
  [45] = {.lex_state = 52, .external_lex_state = 3},
  [46] = {.lex_state = 52, .external_lex_state = 3},
  [47] = {.lex_state = 52, .external_lex_state = 3},
  [48] = {.lex_state = 52, .external_lex_state = 3},
  [49] = {.lex_state = 52, .external_lex_state = 3},
  [50] = {.lex_state = 52, .external_lex_state = 3},
  [51] = {.lex_state = 52, .external_lex_state = 3},
  [52] = {.lex_state = 52, .external_lex_state = 3},
  [53] = {.lex_state = 52, .external_lex_state = 3},
  [54] = {.lex_state = 52, .external_lex_state = 3},
  [55] = {.lex_state = 52, .external_lex_state = 3},
  [56] = {.lex_state = 52, .external_lex_state = 3},
  [57] = {.lex_state = 52, .external_lex_state = 3},
  [58] = {.lex_state = 52, .external_lex_state = 3},
  [59] = {.lex_state = 52, .external_lex_state = 3},
  [60] = {.lex_state = 52, .external_lex_state = 3},
  [61] = {.lex_state = 52, .external_lex_state = 3},
  [62] = {.lex_state = 52, .external_lex_state = 3},
  [63] = {.lex_state = 52, .external_lex_state = 3},
  [64] = {.lex_state = 52, .external_lex_state = 2},
  [65] = {.lex_state = 52, .external_lex_state = 3},
  [66] = {.lex_state = 52, .external_lex_state = 3},
  [67] = {.lex_state = 52, .external_lex_state = 2},
  [68] = {.lex_state = 52, .external_lex_state = 3},
  [69] = {.lex_state = 52, .external_lex_state = 3},
  [70] = {.lex_state = 52, .external_lex_state = 3},
  [71] = {.lex_state = 52, .external_lex_state = 3},
  [72] = {.lex_state = 52, .external_lex_state = 3},
  [73] = {.lex_state = 4, .external_lex_state = 4},
  [74] = {.lex_state = 4, .external_lex_state = 4},
  [75] = {.lex_state = 5, .external_lex_state = 5},
  [76] = {.lex_state = 5, .external_lex_state = 5},
  [77] = {.lex_state = 5, .external_lex_state = 5},
  [78] = {.lex_state = 5, .external_lex_state = 5},
  [79] = {.lex_state = 5, .external_lex_state = 5},
  [80] = {.lex_state = 5, .external_lex_state = 5},
  [81] = {.lex_state = 5, .external_lex_state = 5},
  [82] = {.lex_state = 5, .external_lex_state = 5},
  [83] = {.lex_state = 4, .external_lex_state = 4},
  [84] = {.lex_state = 4, .external_lex_state = 4},
  [85] = {.lex_state = 4, .external_lex_state = 4},
  [86] = {.lex_state = 4, .external_lex_state = 4},
  [87] = {.lex_state = 52, .external_lex_state = 5},
  [88] = {.lex_state = 52, .external_lex_state = 5},
  [89] = {.lex_state = 52, .external_lex_state = 5},
  [90] = {.lex_state = 52, .external_lex_state = 5},
  [91] = {.lex_state = 52, .external_lex_state = 5},
  [92] = {.lex_state = 52, .external_lex_state = 5},
  [93] = {.lex_state = 52, .external_lex_state = 5},
  [94] = {.lex_state = 52, .external_lex_state = 5},
  [95] = {.lex_state = 52, .external_lex_state = 5},
  [96] = {.lex_state = 52, .external_lex_state = 5},
  [97] = {.lex_state = 52, .external_lex_state = 5},
  [98] = {.lex_state = 52, .external_lex_state = 5},
  [99] = {.lex_state = 52, .external_lex_state = 5},
  [100] = {.lex_state = 52, .external_lex_state = 5},
  [101] = {.lex_state = 52, .external_lex_state = 5},
  [102] = {.lex_state = 52, .external_lex_state = 5},
  [103] = {.lex_state = 52, .external_lex_state = 5},
  [104] = {.lex_state = 52, .external_lex_state = 5},
  [105] = {.lex_state = 52, .external_lex_state = 5},
  [106] = {.lex_state = 52, .external_lex_state = 5},
  [107] = {.lex_state = 52, .external_lex_state = 5},
  [108] = {.lex_state = 52, .external_lex_state = 5},
  [109] = {.lex_state = 52, .external_lex_state = 5},
  [110] = {.lex_state = 52, .external_lex_state = 5},
  [111] = {.lex_state = 52, .external_lex_state = 5},
  [112] = {.lex_state = 52, .external_lex_state = 5},
  [113] = {.lex_state = 52, .external_lex_state = 5},
  [114] = {.lex_state = 52, .external_lex_state = 5},
  [115] = {.lex_state = 52, .external_lex_state = 5},
  [116] = {.lex_state = 52, .external_lex_state = 5},
  [117] = {.lex_state = 52, .external_lex_state = 5},
  [118] = {.lex_state = 52, .external_lex_state = 5},
  [119] = {.lex_state = 52, .external_lex_state = 5},
  [120] = {.lex_state = 52, .external_lex_state = 5},
  [121] = {.lex_state = 52, .external_lex_state = 5},
  [122] = {.lex_state = 52, .external_lex_state = 5},
  [123] = {.lex_state = 52, .external_lex_state = 5},
  [124] = {.lex_state = 52, .external_lex_state = 5},
  [125] = {.lex_state = 52, .external_lex_state = 5},
  [126] = {.lex_state = 52, .external_lex_state = 5},
  [127] = {.lex_state = 52, .external_lex_state = 5},
  [128] = {.lex_state = 52, .external_lex_state = 5},
  [129] = {.lex_state = 52, .external_lex_state = 5},
  [130] = {.lex_state = 52, .external_lex_state = 5},
  [131] = {.lex_state = 52, .external_lex_state = 5},
  [132] = {.lex_state = 52, .external_lex_state = 5},
  [133] = {.lex_state = 52, .external_lex_state = 5},
  [134] = {.lex_state = 52, .external_lex_state = 5},
  [135] = {.lex_state = 52, .external_lex_state = 5},
  [136] = {.lex_state = 52, .external_lex_state = 5},
  [137] = {.lex_state = 52, .external_lex_state = 4},
  [138] = {.lex_state = 52, .external_lex_state = 4},
  [139] = {.lex_state = 52, .external_lex_state = 4},
  [140] = {.lex_state = 52, .external_lex_state = 4},
  [141] = {.lex_state = 52, .external_lex_state = 4},
  [142] = {.lex_state = 52, .external_lex_state = 4},
  [143] = {.lex_state = 52, .external_lex_state = 4},
  [144] = {.lex_state = 52, .external_lex_state = 4},
  [145] = {.lex_state = 52, .external_lex_state = 4},
  [146] = {.lex_state = 52, .external_lex_state = 4},
  [147] = {.lex_state = 52, .external_lex_state = 4},
  [148] = {.lex_state = 52, .external_lex_state = 4},
  [149] = {.lex_state = 52, .external_lex_state = 4},
  [150] = {.lex_state = 52, .external_lex_state = 4},
  [151] = {.lex_state = 52, .external_lex_state = 4},
  [152] = {.lex_state = 52, .external_lex_state = 4},
  [153] = {.lex_state = 52, .external_lex_state = 2},
  [154] = {.lex_state = 4, .external_lex_state = 4},
  [155] = {.lex_state = 4, .external_lex_state = 4},
  [156] = {.lex_state = 11, .external_lex_state = 4},
  [157] = {.lex_state = 5, .external_lex_state = 4},
  [158] = {.lex_state = 5, .external_lex_state = 6},
  [159] = {.lex_state = 12, .external_lex_state = 4},
  [160] = {.lex_state = 12, .external_lex_state = 6},
  [161] = {.lex_state = 12, .external_lex_state = 4},
  [162] = {.lex_state = 5, .external_lex_state = 6},
  [163] = {.lex_state = 5, .external_lex_state = 2},
  [164] = {.lex_state = 5, .external_lex_state = 6},
  [165] = {.lex_state = 5, .external_lex_state = 6},
  [166] = {.lex_state = 5, .external_lex_state = 7},
  [167] = {.lex_state = 5, .external_lex_state = 8},
  [168] = {.lex_state = 12, .external_lex_state = 8},
  [169] = {.lex_state = 5, .external_lex_state = 8},
  [170] = {.lex_state = 5, .external_lex_state = 7},
  [171] = {.lex_state = 12, .external_lex_state = 6},
  [172] = {.lex_state = 5, .external_lex_state = 8},
  [173] = {.lex_state = 12, .external_lex_state = 2},
  [174] = {.lex_state = 5, .external_lex_state = 8},
  [175] = {.lex_state = 5, .external_lex_state = 8},
  [176] = {.lex_state = 12, .external_lex_state = 7},
  [177] = {.lex_state = 5, .external_lex_state = 7},
  [178] = {.lex_state = 12, .external_lex_state = 2},
  [179] = {.lex_state = 5, .external_lex_state = 8},
  [180] = {.lex_state = 11, .external_lex_state = 4},
  [181] = {.lex_state = 12, .external_lex_state = 6},
  [182] = {.lex_state = 12, .external_lex_state = 7},
  [183] = {.lex_state = 5, .external_lex_state = 7},
  [184] = {.lex_state = 12, .external_lex_state = 8},
  [185] = {.lex_state = 5, .external_lex_state = 8},
  [186] = {.lex_state = 12, .external_lex_state = 7},
  [187] = {.lex_state = 11, .external_lex_state = 2},
  [188] = {.lex_state = 11, .external_lex_state = 2},
  [189] = {.lex_state = 5, .external_lex_state = 7},
  [190] = {.lex_state = 5, .external_lex_state = 6},
  [191] = {.lex_state = 52, .external_lex_state = 8},
  [192] = {.lex_state = 52, .external_lex_state = 7},
  [193] = {.lex_state = 5, .external_lex_state = 6},
  [194] = {.lex_state = 5, .external_lex_state = 6},
  [195] = {.lex_state = 52, .external_lex_state = 8},
  [196] = {.lex_state = 52, .external_lex_state = 7},
  [197] = {.lex_state = 5, .external_lex_state = 6},
  [198] = {.lex_state = 52, .external_lex_state = 8},
  [199] = {.lex_state = 52, .external_lex_state = 8},
  [200] = {.lex_state = 52, .external_lex_state = 8},
  [201] = {.lex_state = 52, .external_lex_state = 7},
  [202] = {.lex_state = 5, .external_lex_state = 6},
  [203] = {.lex_state = 52, .external_lex_state = 8},
  [204] = {.lex_state = 52, .external_lex_state = 7},
  [205] = {.lex_state = 5, .external_lex_state = 6},
  [206] = {.lex_state = 52, .external_lex_state = 7},
  [207] = {.lex_state = 52, .external_lex_state = 8},
  [208] = {.lex_state = 52, .external_lex_state = 7},
  [209] = {.lex_state = 5, .external_lex_state = 6},
  [210] = {.lex_state = 52, .external_lex_state = 8},
  [211] = {.lex_state = 52, .external_lex_state = 8},
  [212] = {.lex_state = 52, .external_lex_state = 2},
  [213] = {.lex_state = 52, .external_lex_state = 8},
  [214] = {.lex_state = 52, .external_lex_state = 7},
  [215] = {.lex_state = 5, .external_lex_state = 6},
  [216] = {.lex_state = 52, .external_lex_state = 7},
  [217] = {.lex_state = 52, .external_lex_state = 2},
  [218] = {.lex_state = 52, .external_lex_state = 2},
  [219] = {.lex_state = 52, .external_lex_state = 8},
  [220] = {.lex_state = 52, .external_lex_state = 7},
  [221] = {.lex_state = 52, .external_lex_state = 7},
  [222] = {.lex_state = 52, .external_lex_state = 7},
  [223] = {.lex_state = 6, .external_lex_state = 4},
  [224] = {.lex_state = 6, .external_lex_state = 4},
  [225] = {.lex_state = 52, .external_lex_state = 2},
  [226] = {.lex_state = 5, .external_lex_state = 7},
  [227] = {.lex_state = 5, .external_lex_state = 7},
  [228] = {.lex_state = 5, .external_lex_state = 7},
  [229] = {.lex_state = 5, .external_lex_state = 7},
  [230] = {.lex_state = 5, .external_lex_state = 7},
  [231] = {.lex_state = 5, .external_lex_state = 7},
  [232] = {.lex_state = 52, .external_lex_state = 2},
  [233] = {.lex_state = 5, .external_lex_state = 7},
  [234] = {.lex_state = 5, .external_lex_state = 7},
  [235] = {.lex_state = 5, .external_lex_state = 2},
  [236] = {.lex_state = 5, .external_lex_state = 2},
  [237] = {.lex_state = 5, .external_lex_state = 2},
  [238] = {.lex_state = 5, .external_lex_state = 2},
  [239] = {.lex_state = 52, .external_lex_state = 8},
  [240] = {.lex_state = 5, .external_lex_state = 2},
  [241] = {.lex_state = 5, .external_lex_state = 2},
  [242] = {.lex_state = 5, .external_lex_state = 2},
  [243] = {.lex_state = 5, .external_lex_state = 2},
  [244] = {.lex_state = 5, .external_lex_state = 8},
  [245] = {.lex_state = 52, .external_lex_state = 6},
  [246] = {.lex_state = 5, .external_lex_state = 8},
  [247] = {.lex_state = 5, .external_lex_state = 8},
  [248] = {.lex_state = 5, .external_lex_state = 2},
  [249] = {.lex_state = 6, .external_lex_state = 2},
  [250] = {.lex_state = 5, .external_lex_state = 8},
  [251] = {.lex_state = 5, .external_lex_state = 2},
  [252] = {.lex_state = 5, .external_lex_state = 8},
  [253] = {.lex_state = 5, .external_lex_state = 2},
  [254] = {.lex_state = 5, .external_lex_state = 2},
  [255] = {.lex_state = 5, .external_lex_state = 2},
  [256] = {.lex_state = 5, .external_lex_state = 8},
  [257] = {.lex_state = 5, .external_lex_state = 2},
  [258] = {.lex_state = 5, .external_lex_state = 2},
  [259] = {.lex_state = 5, .external_lex_state = 8},
  [260] = {.lex_state = 5, .external_lex_state = 2},
  [261] = {.lex_state = 5, .external_lex_state = 2},
  [262] = {.lex_state = 5, .external_lex_state = 8},
  [263] = {.lex_state = 5, .external_lex_state = 2},
  [264] = {.lex_state = 5, .external_lex_state = 8},
  [265] = {.lex_state = 5, .external_lex_state = 2},
  [266] = {.lex_state = 5, .external_lex_state = 2},
  [267] = {.lex_state = 5, .external_lex_state = 2},
  [268] = {.lex_state = 6, .external_lex_state = 2},
  [269] = {.lex_state = 5, .external_lex_state = 2},
  [270] = {.lex_state = 5, .external_lex_state = 2},
  [271] = {.lex_state = 5, .external_lex_state = 2},
  [272] = {.lex_state = 5, .external_lex_state = 2},
  [273] = {.lex_state = 52, .external_lex_state = 7},
  [274] = {.lex_state = 52, .external_lex_state = 8},
  [275] = {.lex_state = 5, .external_lex_state = 8},
  [276] = {.lex_state = 52, .external_lex_state = 7},
  [277] = {.lex_state = 52, .external_lex_state = 8},
  [278] = {.lex_state = 5, .external_lex_state = 8},
  [279] = {.lex_state = 5, .external_lex_state = 8},
  [280] = {.lex_state = 5, .external_lex_state = 8},
  [281] = {.lex_state = 5, .external_lex_state = 8},
  [282] = {.lex_state = 5, .external_lex_state = 8},
  [283] = {.lex_state = 5, .external_lex_state = 8},
  [284] = {.lex_state = 52, .external_lex_state = 8},
  [285] = {.lex_state = 52, .external_lex_state = 7},
  [286] = {.lex_state = 52, .external_lex_state = 8},
  [287] = {.lex_state = 5, .external_lex_state = 8},
  [288] = {.lex_state = 5, .external_lex_state = 8},
  [289] = {.lex_state = 5, .external_lex_state = 8},
  [290] = {.lex_state = 5, .external_lex_state = 8},
  [291] = {.lex_state = 5, .external_lex_state = 8},
  [292] = {.lex_state = 5, .external_lex_state = 8},
  [293] = {.lex_state = 5, .external_lex_state = 8},
  [294] = {.lex_state = 52, .external_lex_state = 7},
  [295] = {.lex_state = 52, .external_lex_state = 8},
  [296] = {.lex_state = 52, .external_lex_state = 8},
  [297] = {.lex_state = 52, .external_lex_state = 7},
  [298] = {.lex_state = 5, .external_lex_state = 8},
  [299] = {.lex_state = 5, .external_lex_state = 8},
  [300] = {.lex_state = 5, .external_lex_state = 8},
  [301] = {.lex_state = 5, .external_lex_state = 8},
  [302] = {.lex_state = 5, .external_lex_state = 8},
  [303] = {.lex_state = 5, .external_lex_state = 8},
  [304] = {.lex_state = 5, .external_lex_state = 8},
  [305] = {.lex_state = 52, .external_lex_state = 8},
  [306] = {.lex_state = 52, .external_lex_state = 7},
  [307] = {.lex_state = 52, .external_lex_state = 8},
  [308] = {.lex_state = 52, .external_lex_state = 7},
  [309] = {.lex_state = 52, .external_lex_state = 8},
  [310] = {.lex_state = 52, .external_lex_state = 8},
  [311] = {.lex_state = 5, .external_lex_state = 8},
  [312] = {.lex_state = 5, .external_lex_state = 8},
  [313] = {.lex_state = 5, .external_lex_state = 8},
  [314] = {.lex_state = 5, .external_lex_state = 8},
  [315] = {.lex_state = 52, .external_lex_state = 7},
  [316] = {.lex_state = 52, .external_lex_state = 8},
  [317] = {.lex_state = 52, .external_lex_state = 8},
  [318] = {.lex_state = 5, .external_lex_state = 8},
  [319] = {.lex_state = 5, .external_lex_state = 8},
  [320] = {.lex_state = 52, .external_lex_state = 8},
  [321] = {.lex_state = 5, .external_lex_state = 8},
  [322] = {.lex_state = 5, .external_lex_state = 8},
  [323] = {.lex_state = 5, .external_lex_state = 8},
  [324] = {.lex_state = 5, .external_lex_state = 8},
  [325] = {.lex_state = 52, .external_lex_state = 8},
  [326] = {.lex_state = 5, .external_lex_state = 8},
  [327] = {.lex_state = 52, .external_lex_state = 7},
  [328] = {.lex_state = 52, .external_lex_state = 8},
  [329] = {.lex_state = 52, .external_lex_state = 8},
  [330] = {.lex_state = 52, .external_lex_state = 8},
  [331] = {.lex_state = 52, .external_lex_state = 6},
  [332] = {.lex_state = 52, .external_lex_state = 7},
  [333] = {.lex_state = 52, .external_lex_state = 6},
  [334] = {.lex_state = 52, .external_lex_state = 8},
  [335] = {.lex_state = 5, .external_lex_state = 2},
  [336] = {.lex_state = 52, .external_lex_state = 6},
  [337] = {.lex_state = 52, .external_lex_state = 6},
  [338] = {.lex_state = 52, .external_lex_state = 8},
  [339] = {.lex_state = 52, .external_lex_state = 6},
  [340] = {.lex_state = 52, .external_lex_state = 6},
  [341] = {.lex_state = 52, .external_lex_state = 7},
  [342] = {.lex_state = 52, .external_lex_state = 8},
  [343] = {.lex_state = 52, .external_lex_state = 7},
  [344] = {.lex_state = 52, .external_lex_state = 7},
  [345] = {.lex_state = 52, .external_lex_state = 7},
  [346] = {.lex_state = 52, .external_lex_state = 6},
  [347] = {.lex_state = 12, .external_lex_state = 6},
  [348] = {.lex_state = 52, .external_lex_state = 6},
  [349] = {.lex_state = 52, .external_lex_state = 2},
  [350] = {.lex_state = 52, .external_lex_state = 4},
  [351] = {.lex_state = 5, .external_lex_state = 6},
  [352] = {.lex_state = 5, .external_lex_state = 6},
  [353] = {.lex_state = 5, .external_lex_state = 6},
  [354] = {.lex_state = 5, .external_lex_state = 6},
  [355] = {.lex_state = 5, .external_lex_state = 6},
  [356] = {.lex_state = 5, .external_lex_state = 6},
  [357] = {.lex_state = 5, .external_lex_state = 6},
  [358] = {.lex_state = 5, .external_lex_state = 6},
  [359] = {.lex_state = 5, .external_lex_state = 6},
  [360] = {.lex_state = 5, .external_lex_state = 6},
  [361] = {.lex_state = 5, .external_lex_state = 6},
  [362] = {.lex_state = 52, .external_lex_state = 4},
  [363] = {.lex_state = 52, .external_lex_state = 7},
  [364] = {.lex_state = 52, .external_lex_state = 2},
  [365] = {.lex_state = 5, .external_lex_state = 6},
  [366] = {.lex_state = 5, .external_lex_state = 6},
  [367] = {.lex_state = 52, .external_lex_state = 8},
  [368] = {.lex_state = 5, .external_lex_state = 6},
  [369] = {.lex_state = 5, .external_lex_state = 6},
  [370] = {.lex_state = 5, .external_lex_state = 6},
  [371] = {.lex_state = 52, .external_lex_state = 2},
  [372] = {.lex_state = 12, .external_lex_state = 8},
  [373] = {.lex_state = 52, .external_lex_state = 7},
  [374] = {.lex_state = 52, .external_lex_state = 7},
  [375] = {.lex_state = 52, .external_lex_state = 7},
  [376] = {.lex_state = 52, .external_lex_state = 4},
  [377] = {.lex_state = 52, .external_lex_state = 7},
  [378] = {.lex_state = 52, .external_lex_state = 7},
  [379] = {.lex_state = 52, .external_lex_state = 7},
  [380] = {.lex_state = 52, .external_lex_state = 4},
  [381] = {.lex_state = 52, .external_lex_state = 7},
  [382] = {.lex_state = 52, .external_lex_state = 7},
  [383] = {.lex_state = 52, .external_lex_state = 7},
  [384] = {.lex_state = 52, .external_lex_state = 7},
  [385] = {.lex_state = 52, .external_lex_state = 7},
  [386] = {.lex_state = 52, .external_lex_state = 7},
  [387] = {.lex_state = 52, .external_lex_state = 7},
  [388] = {.lex_state = 52, .external_lex_state = 7},
  [389] = {.lex_state = 52, .external_lex_state = 7},
  [390] = {.lex_state = 52, .external_lex_state = 7},
  [391] = {.lex_state = 52, .external_lex_state = 7},
  [392] = {.lex_state = 52, .external_lex_state = 7},
  [393] = {.lex_state = 52, .external_lex_state = 7},
  [394] = {.lex_state = 52, .external_lex_state = 7},
  [395] = {.lex_state = 52, .external_lex_state = 7},
  [396] = {.lex_state = 52, .external_lex_state = 7},
  [397] = {.lex_state = 52, .external_lex_state = 4},
  [398] = {.lex_state = 52, .external_lex_state = 7},
  [399] = {.lex_state = 52, .external_lex_state = 7},
  [400] = {.lex_state = 52, .external_lex_state = 7},
  [401] = {.lex_state = 52, .external_lex_state = 7},
  [402] = {.lex_state = 52, .external_lex_state = 7},
  [403] = {.lex_state = 5, .external_lex_state = 2},
  [404] = {.lex_state = 52, .external_lex_state = 7},
  [405] = {.lex_state = 52, .external_lex_state = 7},
  [406] = {.lex_state = 52, .external_lex_state = 7},
  [407] = {.lex_state = 12, .external_lex_state = 8},
  [408] = {.lex_state = 52, .external_lex_state = 7},
  [409] = {.lex_state = 52, .external_lex_state = 7},
  [410] = {.lex_state = 52, .external_lex_state = 2},
  [411] = {.lex_state = 52, .external_lex_state = 4},
  [412] = {.lex_state = 52, .external_lex_state = 7},
  [413] = {.lex_state = 52, .external_lex_state = 8},
  [414] = {.lex_state = 52, .external_lex_state = 2},
  [415] = {.lex_state = 52, .external_lex_state = 8},
  [416] = {.lex_state = 12, .external_lex_state = 2},
  [417] = {.lex_state = 5, .external_lex_state = 7},
  [418] = {.lex_state = 52, .external_lex_state = 7},
  [419] = {.lex_state = 52, .external_lex_state = 7},
  [420] = {.lex_state = 52, .external_lex_state = 8},
  [421] = {.lex_state = 52, .external_lex_state = 2},
  [422] = {.lex_state = 52, .external_lex_state = 7},
  [423] = {.lex_state = 52, .external_lex_state = 2},
  [424] = {.lex_state = 52, .external_lex_state = 2},
  [425] = {.lex_state = 52, .external_lex_state = 2},
  [426] = {.lex_state = 52, .external_lex_state = 4},
  [427] = {.lex_state = 52, .external_lex_state = 4},
  [428] = {.lex_state = 52, .external_lex_state = 2},
  [429] = {.lex_state = 52, .external_lex_state = 2},
  [430] = {.lex_state = 52, .external_lex_state = 2},
  [431] = {.lex_state = 52, .external_lex_state = 7},
  [432] = {.lex_state = 52, .external_lex_state = 2},
  [433] = {.lex_state = 52, .external_lex_state = 2},
  [434] = {.lex_state = 52, .external_lex_state = 2},
  [435] = {.lex_state = 52, .external_lex_state = 2},
  [436] = {.lex_state = 12, .external_lex_state = 2},
  [437] = {.lex_state = 52, .external_lex_state = 2},
  [438] = {.lex_state = 52, .external_lex_state = 2},
  [439] = {.lex_state = 5, .external_lex_state = 2},
  [440] = {.lex_state = 52, .external_lex_state = 4},
  [441] = {.lex_state = 52, .external_lex_state = 2},
  [442] = {.lex_state = 52, .external_lex_state = 2},
  [443] = {.lex_state = 52, .external_lex_state = 2},
  [444] = {.lex_state = 52, .external_lex_state = 2},
  [445] = {.lex_state = 52, .external_lex_state = 2},
  [446] = {.lex_state = 52, .external_lex_state = 4},
  [447] = {.lex_state = 52, .external_lex_state = 4},
  [448] = {.lex_state = 52, .external_lex_state = 2},
  [449] = {.lex_state = 5, .external_lex_state = 8},
  [450] = {.lex_state = 52, .external_lex_state = 8},
  [451] = {.lex_state = 52, .external_lex_state = 2},
  [452] = {.lex_state = 52, .external_lex_state = 2},
  [453] = {.lex_state = 52, .external_lex_state = 2},
  [454] = {.lex_state = 52, .external_lex_state = 2},
  [455] = {.lex_state = 52, .external_lex_state = 2},
  [456] = {.lex_state = 52, .external_lex_state = 2},
  [457] = {.lex_state = 52, .external_lex_state = 2},
  [458] = {.lex_state = 52, .external_lex_state = 2},
  [459] = {.lex_state = 52, .external_lex_state = 2},
  [460] = {.lex_state = 52, .external_lex_state = 2},
  [461] = {.lex_state = 52, .external_lex_state = 2},
  [462] = {.lex_state = 7, .external_lex_state = 9},
  [463] = {.lex_state = 52, .external_lex_state = 2},
  [464] = {.lex_state = 52, .external_lex_state = 2},
  [465] = {.lex_state = 52, .external_lex_state = 2},
  [466] = {.lex_state = 52, .external_lex_state = 2},
  [467] = {.lex_state = 52, .external_lex_state = 2},
  [468] = {.lex_state = 52, .external_lex_state = 2},
  [469] = {.lex_state = 52, .external_lex_state = 2},
  [470] = {.lex_state = 52, .external_lex_state = 2},
  [471] = {.lex_state = 7, .external_lex_state = 4},
  [472] = {.lex_state = 52, .external_lex_state = 2},
  [473] = {.lex_state = 52, .external_lex_state = 2},
  [474] = {.lex_state = 52, .external_lex_state = 2},
  [475] = {.lex_state = 52, .external_lex_state = 2},
  [476] = {.lex_state = 7, .external_lex_state = 4},
  [477] = {.lex_state = 7, .external_lex_state = 9},
  [478] = {.lex_state = 52, .external_lex_state = 2},
  [479] = {.lex_state = 52, .external_lex_state = 2},
  [480] = {.lex_state = 52, .external_lex_state = 2},
  [481] = {.lex_state = 52, .external_lex_state = 2},
  [482] = {.lex_state = 52, .external_lex_state = 2},
  [483] = {.lex_state = 52, .external_lex_state = 2},
  [484] = {.lex_state = 52, .external_lex_state = 2},
  [485] = {.lex_state = 52, .external_lex_state = 2},
  [486] = {.lex_state = 52, .external_lex_state = 2},
  [487] = {.lex_state = 52, .external_lex_state = 2},
  [488] = {.lex_state = 52, .external_lex_state = 2},
  [489] = {.lex_state = 52, .external_lex_state = 2},
  [490] = {.lex_state = 52, .external_lex_state = 2},
  [491] = {.lex_state = 52, .external_lex_state = 2},
  [492] = {.lex_state = 52, .external_lex_state = 2},
  [493] = {.lex_state = 52, .external_lex_state = 2},
  [494] = {.lex_state = 52, .external_lex_state = 2},
  [495] = {.lex_state = 53, .external_lex_state = 10},
  [496] = {.lex_state = 52, .external_lex_state = 2},
  [497] = {.lex_state = 52, .external_lex_state = 2},
  [498] = {.lex_state = 52, .external_lex_state = 2},
  [499] = {.lex_state = 52, .external_lex_state = 2},
  [500] = {.lex_state = 52, .external_lex_state = 2},
  [501] = {.lex_state = 52, .external_lex_state = 2},
  [502] = {.lex_state = 52, .external_lex_state = 2},
  [503] = {.lex_state = 54, .external_lex_state = 2},
  [504] = {.lex_state = 52, .external_lex_state = 2},
  [505] = {.lex_state = 52, .external_lex_state = 2},
  [506] = {.lex_state = 52, .external_lex_state = 2},
  [507] = {.lex_state = 52, .external_lex_state = 2},
  [508] = {.lex_state = 52, .external_lex_state = 2},
  [509] = {.lex_state = 52, .external_lex_state = 2},
  [510] = {.lex_state = 52, .external_lex_state = 2},
  [511] = {.lex_state = 52, .external_lex_state = 2},
  [512] = {.lex_state = 52, .external_lex_state = 2},
  [513] = {.lex_state = 52, .external_lex_state = 2},
  [514] = {.lex_state = 52, .external_lex_state = 2},
  [515] = {.lex_state = 52, .external_lex_state = 2},
  [516] = {.lex_state = 52, .external_lex_state = 2},
  [517] = {.lex_state = 52, .external_lex_state = 2},
  [518] = {.lex_state = 52, .external_lex_state = 2},
  [519] = {.lex_state = 52, .external_lex_state = 2},
  [520] = {.lex_state = 52, .external_lex_state = 2},
  [521] = {.lex_state = 52, .external_lex_state = 2},
  [522] = {.lex_state = 52, .external_lex_state = 2},
  [523] = {.lex_state = 52, .external_lex_state = 2},
  [524] = {.lex_state = 52, .external_lex_state = 2},
  [525] = {.lex_state = 52, .external_lex_state = 2},
  [526] = {.lex_state = 52, .external_lex_state = 2},
  [527] = {.lex_state = 52, .external_lex_state = 2},
  [528] = {.lex_state = 52, .external_lex_state = 2},
  [529] = {.lex_state = 52, .external_lex_state = 2},
  [530] = {.lex_state = 52, .external_lex_state = 2},
  [531] = {.lex_state = 52, .external_lex_state = 2},
  [532] = {.lex_state = 52, .external_lex_state = 2},
  [533] = {.lex_state = 52, .external_lex_state = 2},
  [534] = {.lex_state = 52, .external_lex_state = 2},
  [535] = {.lex_state = 52, .external_lex_state = 2},
  [536] = {.lex_state = 52, .external_lex_state = 2},
  [537] = {.lex_state = 52, .external_lex_state = 2},
  [538] = {.lex_state = 52, .external_lex_state = 2},
  [539] = {.lex_state = 52, .external_lex_state = 2},
  [540] = {.lex_state = 52, .external_lex_state = 2},
  [541] = {.lex_state = 52, .external_lex_state = 2},
  [542] = {.lex_state = 52, .external_lex_state = 2},
  [543] = {.lex_state = 52, .external_lex_state = 2},
  [544] = {.lex_state = 52, .external_lex_state = 2},
  [545] = {.lex_state = 52, .external_lex_state = 2},
  [546] = {.lex_state = 52, .external_lex_state = 2},
  [547] = {.lex_state = 52, .external_lex_state = 2},
  [548] = {.lex_state = 52, .external_lex_state = 2},
  [549] = {.lex_state = 52, .external_lex_state = 2},
  [550] = {.lex_state = 52, .external_lex_state = 2},
  [551] = {.lex_state = 52, .external_lex_state = 2},
  [552] = {.lex_state = 52, .external_lex_state = 2},
  [553] = {.lex_state = 52, .external_lex_state = 2},
  [554] = {.lex_state = 52, .external_lex_state = 2},
  [555] = {.lex_state = 52, .external_lex_state = 2},
  [556] = {.lex_state = 52, .external_lex_state = 2},
  [557] = {.lex_state = 52, .external_lex_state = 2},
  [558] = {.lex_state = 52, .external_lex_state = 2},
  [559] = {.lex_state = 52, .external_lex_state = 2},
  [560] = {.lex_state = 52, .external_lex_state = 2},
  [561] = {.lex_state = 52, .external_lex_state = 2},
  [562] = {.lex_state = 52, .external_lex_state = 2},
  [563] = {.lex_state = 52, .external_lex_state = 2},
  [564] = {.lex_state = 52, .external_lex_state = 2},
  [565] = {.lex_state = 52, .external_lex_state = 2},
  [566] = {.lex_state = 52, .external_lex_state = 2},
  [567] = {.lex_state = 52, .external_lex_state = 2},
  [568] = {.lex_state = 52, .external_lex_state = 2},
  [569] = {.lex_state = 52, .external_lex_state = 2},
  [570] = {.lex_state = 52, .external_lex_state = 2},
  [571] = {.lex_state = 52, .external_lex_state = 2},
  [572] = {.lex_state = 53, .external_lex_state = 10},
  [573] = {.lex_state = 54, .external_lex_state = 2},
  [574] = {.lex_state = 52, .external_lex_state = 2},
  [575] = {.lex_state = 52, .external_lex_state = 2},
  [576] = {.lex_state = 52, .external_lex_state = 2},
  [577] = {.lex_state = 52, .external_lex_state = 2},
  [578] = {.lex_state = 52, .external_lex_state = 2},
  [579] = {.lex_state = 52, .external_lex_state = 2},
  [580] = {.lex_state = 52, .external_lex_state = 2},
  [581] = {.lex_state = 52, .external_lex_state = 2},
  [582] = {.lex_state = 52, .external_lex_state = 2},
  [583] = {.lex_state = 52, .external_lex_state = 2},
  [584] = {.lex_state = 52, .external_lex_state = 2},
  [585] = {.lex_state = 52, .external_lex_state = 2},
  [586] = {.lex_state = 52, .external_lex_state = 2},
  [587] = {.lex_state = 52, .external_lex_state = 2},
  [588] = {.lex_state = 53, .external_lex_state = 11},
  [589] = {.lex_state = 54, .external_lex_state = 3},
  [590] = {.lex_state = 52, .external_lex_state = 2},
  [591] = {.lex_state = 52, .external_lex_state = 2},
  [592] = {.lex_state = 52, .external_lex_state = 2},
  [593] = {.lex_state = 52, .external_lex_state = 2},
  [594] = {.lex_state = 52, .external_lex_state = 2},
  [595] = {.lex_state = 52, .external_lex_state = 2},
  [596] = {.lex_state = 52, .external_lex_state = 2},
  [597] = {.lex_state = 52, .external_lex_state = 2},
  [598] = {.lex_state = 52, .external_lex_state = 2},
  [599] = {.lex_state = 52, .external_lex_state = 2},
  [600] = {.lex_state = 52, .external_lex_state = 2},
  [601] = {.lex_state = 52, .external_lex_state = 2},
  [602] = {.lex_state = 52, .external_lex_state = 2},
  [603] = {.lex_state = 52, .external_lex_state = 2},
  [604] = {.lex_state = 52, .external_lex_state = 2},
  [605] = {.lex_state = 52, .external_lex_state = 2},
  [606] = {.lex_state = 52, .external_lex_state = 2},
  [607] = {.lex_state = 53, .external_lex_state = 11},
  [608] = {.lex_state = 54, .external_lex_state = 3},
  [609] = {.lex_state = 52, .external_lex_state = 2},
  [610] = {.lex_state = 52, .external_lex_state = 2},
  [611] = {.lex_state = 7, .external_lex_state = 9},
  [612] = {.lex_state = 7, .external_lex_state = 9},
  [613] = {.lex_state = 54, .external_lex_state = 2},
  [614] = {.lex_state = 52, .external_lex_state = 3},
  [615] = {.lex_state = 52, .external_lex_state = 2},
  [616] = {.lex_state = 7, .external_lex_state = 9},
  [617] = {.lex_state = 7, .external_lex_state = 9},
  [618] = {.lex_state = 52, .external_lex_state = 3},
  [619] = {.lex_state = 52, .external_lex_state = 3},
  [620] = {.lex_state = 52, .external_lex_state = 3},
  [621] = {.lex_state = 7, .external_lex_state = 9},
  [622] = {.lex_state = 52, .external_lex_state = 2},
  [623] = {.lex_state = 52, .external_lex_state = 2},
  [624] = {.lex_state = 7, .external_lex_state = 9},
  [625] = {.lex_state = 52, .external_lex_state = 2},
  [626] = {.lex_state = 53, .external_lex_state = 10},
  [627] = {.lex_state = 53, .external_lex_state = 11},
  [628] = {.lex_state = 54, .external_lex_state = 3},
  [629] = {.lex_state = 52, .external_lex_state = 3},
  [630] = {.lex_state = 8, .external_lex_state = 9},
  [631] = {.lex_state = 8, .external_lex_state = 9},
  [632] = {.lex_state = 8, .external_lex_state = 9},
  [633] = {.lex_state = 8, .external_lex_state = 9},
  [634] = {.lex_state = 8, .external_lex_state = 9},
  [635] = {.lex_state = 8, .external_lex_state = 9},
  [636] = {.lex_state = 8, .external_lex_state = 9},
  [637] = {.lex_state = 8, .external_lex_state = 9},
  [638] = {.lex_state = 52, .external_lex_state = 2},
  [639] = {.lex_state = 8, .external_lex_state = 9},
  [640] = {.lex_state = 8, .external_lex_state = 9},
  [641] = {.lex_state = 8, .external_lex_state = 9},
  [642] = {.lex_state = 8, .external_lex_state = 9},
  [643] = {.lex_state = 8, .external_lex_state = 9},
  [644] = {.lex_state = 8, .external_lex_state = 9},
  [645] = {.lex_state = 8, .external_lex_state = 9},
  [646] = {.lex_state = 8, .external_lex_state = 9},
  [647] = {.lex_state = 8, .external_lex_state = 9},
  [648] = {.lex_state = 8, .external_lex_state = 9},
  [649] = {.lex_state = 8, .external_lex_state = 9},
  [650] = {.lex_state = 54, .external_lex_state = 2},
  [651] = {.lex_state = 53, .external_lex_state = 10},
  [652] = {.lex_state = 52, .external_lex_state = 6},
  [653] = {.lex_state = 53, .external_lex_state = 11},
  [654] = {.lex_state = 54, .external_lex_state = 2},
  [655] = {.lex_state = 52, .external_lex_state = 2},
  [656] = {.lex_state = 53, .external_lex_state = 11},
  [657] = {.lex_state = 54, .external_lex_state = 3},
  [658] = {.lex_state = 52, .external_lex_state = 2},
  [659] = {.lex_state = 54, .external_lex_state = 3},
  [660] = {.lex_state = 54, .external_lex_state = 3},
  [661] = {.lex_state = 54, .external_lex_state = 3},
  [662] = {.lex_state = 54, .external_lex_state = 3},
  [663] = {.lex_state = 52, .external_lex_state = 2},
  [664] = {.lex_state = 54, .external_lex_state = 3},
  [665] = {.lex_state = 53, .external_lex_state = 10},
  [666] = {.lex_state = 52, .external_lex_state = 3},
  [667] = {.lex_state = 52, .external_lex_state = 2},
  [668] = {.lex_state = 54, .external_lex_state = 2},
  [669] = {.lex_state = 54, .external_lex_state = 2},
  [670] = {.lex_state = 53, .external_lex_state = 10},
  [671] = {.lex_state = 53, .external_lex_state = 10},
  [672] = {.lex_state = 53, .external_lex_state = 10},
  [673] = {.lex_state = 53, .external_lex_state = 10},
  [674] = {.lex_state = 52, .external_lex_state = 3},
  [675] = {.lex_state = 53, .external_lex_state = 11},
  [676] = {.lex_state = 54, .external_lex_state = 2},
  [677] = {.lex_state = 53, .external_lex_state = 10},
  [678] = {.lex_state = 53, .external_lex_state = 10},
  [679] = {.lex_state = 54, .external_lex_state = 2},
  [680] = {.lex_state = 54, .external_lex_state = 2},
  [681] = {.lex_state = 54, .external_lex_state = 3},
  [682] = {.lex_state = 52, .external_lex_state = 2},
  [683] = {.lex_state = 53, .external_lex_state = 11},
  [684] = {.lex_state = 53, .external_lex_state = 11},
  [685] = {.lex_state = 52, .external_lex_state = 6},
  [686] = {.lex_state = 54, .external_lex_state = 3},
  [687] = {.lex_state = 53, .external_lex_state = 11},
  [688] = {.lex_state = 54, .external_lex_state = 2},
  [689] = {.lex_state = 53, .external_lex_state = 11},
  [690] = {.lex_state = 53, .external_lex_state = 11},
  [691] = {.lex_state = 53, .external_lex_state = 10},
  [692] = {.lex_state = 53, .external_lex_state = 10},
  [693] = {.lex_state = 54, .external_lex_state = 2},
  [694] = {.lex_state = 52, .external_lex_state = 3},
  [695] = {.lex_state = 53, .external_lex_state = 11},
  [696] = {.lex_state = 54, .external_lex_state = 3},
  [697] = {.lex_state = 52, .external_lex_state = 3},
  [698] = {.lex_state = 53, .external_lex_state = 11},
  [699] = {.lex_state = 53, .external_lex_state = 11},
  [700] = {.lex_state = 52, .external_lex_state = 3},
  [701] = {.lex_state = 53, .external_lex_state = 10},
  [702] = {.lex_state = 52, .external_lex_state = 3},
  [703] = {.lex_state = 52, .external_lex_state = 3},
  [704] = {.lex_state = 52, .external_lex_state = 3},
  [705] = {.lex_state = 52, .external_lex_state = 2},
  [706] = {.lex_state = 52, .external_lex_state = 2},
  [707] = {.lex_state = 52, .external_lex_state = 2},
  [708] = {.lex_state = 52, .external_lex_state = 3},
  [709] = {.lex_state = 52, .external_lex_state = 3},
  [710] = {.lex_state = 52, .external_lex_state = 2},
  [711] = {.lex_state = 52, .external_lex_state = 2},
  [712] = {.lex_state = 52, .external_lex_state = 2},
  [713] = {.lex_state = 52, .external_lex_state = 2},
  [714] = {.lex_state = 52, .external_lex_state = 3},
  [715] = {.lex_state = 52, .external_lex_state = 2},
  [716] = {.lex_state = 52, .external_lex_state = 2},
  [717] = {.lex_state = 52, .external_lex_state = 3},
  [718] = {.lex_state = 52, .external_lex_state = 3},
  [719] = {.lex_state = 52, .external_lex_state = 2},
  [720] = {.lex_state = 52, .external_lex_state = 3},
  [721] = {.lex_state = 52, .external_lex_state = 2},
  [722] = {.lex_state = 52, .external_lex_state = 3},
  [723] = {.lex_state = 52, .external_lex_state = 3},
  [724] = {.lex_state = 52, .external_lex_state = 2},
  [725] = {.lex_state = 52, .external_lex_state = 3},
  [726] = {.lex_state = 52, .external_lex_state = 3},
  [727] = {.lex_state = 52, .external_lex_state = 8},
  [728] = {.lex_state = 52, .external_lex_state = 8},
  [729] = {.lex_state = 52, .external_lex_state = 2},
  [730] = {.lex_state = 52, .external_lex_state = 2},
  [731] = {.lex_state = 52, .external_lex_state = 2},
  [732] = {.lex_state = 52, .external_lex_state = 2},
  [733] = {.lex_state = 52, .external_lex_state = 2},
  [734] = {.lex_state = 52, .external_lex_state = 3},
  [735] = {.lex_state = 52, .external_lex_state = 3},
  [736] = {.lex_state = 52, .external_lex_state = 2},
  [737] = {.lex_state = 52, .external_lex_state = 2},
  [738] = {.lex_state = 52, .external_lex_state = 2},
  [739] = {.lex_state = 52, .external_lex_state = 2},
  [740] = {.lex_state = 52, .external_lex_state = 2},
  [741] = {.lex_state = 52, .external_lex_state = 2},
  [742] = {.lex_state = 52, .external_lex_state = 2},
  [743] = {.lex_state = 52, .external_lex_state = 2},
  [744] = {.lex_state = 52, .external_lex_state = 2},
  [745] = {.lex_state = 52, .external_lex_state = 3},
  [746] = {.lex_state = 52, .external_lex_state = 3},
  [747] = {.lex_state = 52, .external_lex_state = 2},
  [748] = {.lex_state = 52, .external_lex_state = 2},
  [749] = {.lex_state = 52, .external_lex_state = 2},
  [750] = {.lex_state = 52, .external_lex_state = 2},
  [751] = {.lex_state = 52, .external_lex_state = 3},
  [752] = {.lex_state = 52, .external_lex_state = 2},
  [753] = {.lex_state = 52, .external_lex_state = 3},
  [754] = {.lex_state = 52, .external_lex_state = 3},
  [755] = {.lex_state = 52, .external_lex_state = 2},
  [756] = {.lex_state = 52, .external_lex_state = 3},
  [757] = {.lex_state = 52, .external_lex_state = 3},
  [758] = {.lex_state = 52, .external_lex_state = 3},
  [759] = {.lex_state = 52, .external_lex_state = 3},
  [760] = {.lex_state = 52, .external_lex_state = 3},
  [761] = {.lex_state = 52, .external_lex_state = 3},
  [762] = {.lex_state = 52, .external_lex_state = 3},
  [763] = {.lex_state = 52, .external_lex_state = 3},
  [764] = {.lex_state = 52, .external_lex_state = 3},
  [765] = {.lex_state = 52, .external_lex_state = 2},
  [766] = {.lex_state = 52, .external_lex_state = 3},
  [767] = {.lex_state = 52, .external_lex_state = 2},
  [768] = {.lex_state = 52, .external_lex_state = 2},
  [769] = {.lex_state = 52, .external_lex_state = 8},
  [770] = {.lex_state = 52, .external_lex_state = 2},
  [771] = {.lex_state = 52, .external_lex_state = 2},
  [772] = {.lex_state = 52, .external_lex_state = 2},
  [773] = {.lex_state = 52, .external_lex_state = 2},
  [774] = {.lex_state = 52, .external_lex_state = 3},
  [775] = {.lex_state = 52, .external_lex_state = 3},
  [776] = {.lex_state = 52, .external_lex_state = 2},
  [777] = {.lex_state = 52, .external_lex_state = 2},
  [778] = {.lex_state = 52, .external_lex_state = 2},
  [779] = {.lex_state = 52, .external_lex_state = 2},
  [780] = {.lex_state = 52, .external_lex_state = 3},
  [781] = {.lex_state = 52, .external_lex_state = 2},
  [782] = {.lex_state = 52, .external_lex_state = 3},
  [783] = {.lex_state = 52, .external_lex_state = 2},
  [784] = {.lex_state = 52, .external_lex_state = 2},
  [785] = {.lex_state = 52, .external_lex_state = 2},
  [786] = {.lex_state = 52, .external_lex_state = 3},
  [787] = {.lex_state = 52, .external_lex_state = 2},
  [788] = {.lex_state = 52, .external_lex_state = 2},
  [789] = {.lex_state = 52, .external_lex_state = 3},
  [790] = {.lex_state = 52, .external_lex_state = 3},
  [791] = {.lex_state = 52, .external_lex_state = 2},
  [792] = {.lex_state = 52, .external_lex_state = 2},
  [793] = {.lex_state = 52, .external_lex_state = 3},
  [794] = {.lex_state = 52, .external_lex_state = 2},
  [795] = {.lex_state = 52, .external_lex_state = 2},
  [796] = {.lex_state = 52, .external_lex_state = 3},
  [797] = {.lex_state = 52, .external_lex_state = 3},
  [798] = {.lex_state = 52, .external_lex_state = 3},
  [799] = {.lex_state = 52, .external_lex_state = 3},
  [800] = {.lex_state = 52, .external_lex_state = 2},
  [801] = {.lex_state = 52, .external_lex_state = 3},
  [802] = {.lex_state = 52, .external_lex_state = 2},
  [803] = {.lex_state = 52, .external_lex_state = 3},
  [804] = {.lex_state = 52, .external_lex_state = 7},
  [805] = {.lex_state = 52, .external_lex_state = 3},
  [806] = {.lex_state = 52, .external_lex_state = 3},
  [807] = {.lex_state = 52, .external_lex_state = 2},
  [808] = {.lex_state = 52, .external_lex_state = 2},
  [809] = {.lex_state = 52, .external_lex_state = 2},
  [810] = {.lex_state = 52, .external_lex_state = 7},
  [811] = {.lex_state = 52, .external_lex_state = 3},
  [812] = {.lex_state = 52, .external_lex_state = 3},
  [813] = {.lex_state = 52, .external_lex_state = 2},
  [814] = {.lex_state = 52, .external_lex_state = 3},
  [815] = {.lex_state = 52, .external_lex_state = 3},
  [816] = {.lex_state = 52, .external_lex_state = 3},
  [817] = {.lex_state = 52, .external_lex_state = 2},
  [818] = {.lex_state = 52, .external_lex_state = 3},
  [819] = {.lex_state = 52, .external_lex_state = 2},
  [820] = {.lex_state = 52, .external_lex_state = 3},
  [821] = {.lex_state = 52, .external_lex_state = 3},
  [822] = {.lex_state = 52, .external_lex_state = 3},
  [823] = {.lex_state = 52, .external_lex_state = 2},
  [824] = {.lex_state = 52, .external_lex_state = 3},
  [825] = {.lex_state = 52, .external_lex_state = 3},
  [826] = {.lex_state = 52, .external_lex_state = 2},
  [827] = {.lex_state = 52, .external_lex_state = 2},
  [828] = {.lex_state = 52, .external_lex_state = 2},
  [829] = {.lex_state = 52, .external_lex_state = 2},
  [830] = {.lex_state = 52, .external_lex_state = 3},
  [831] = {.lex_state = 52, .external_lex_state = 2},
  [832] = {.lex_state = 52, .external_lex_state = 3},
  [833] = {.lex_state = 52, .external_lex_state = 2},
  [834] = {.lex_state = 52, .external_lex_state = 3},
  [835] = {.lex_state = 52, .external_lex_state = 3},
  [836] = {.lex_state = 52, .external_lex_state = 3},
  [837] = {.lex_state = 52, .external_lex_state = 8},
  [838] = {.lex_state = 52, .external_lex_state = 3},
  [839] = {.lex_state = 52, .external_lex_state = 3},
  [840] = {.lex_state = 52, .external_lex_state = 2},
  [841] = {.lex_state = 52, .external_lex_state = 2},
  [842] = {.lex_state = 52, .external_lex_state = 2},
  [843] = {.lex_state = 52, .external_lex_state = 2},
  [844] = {.lex_state = 52, .external_lex_state = 3},
  [845] = {.lex_state = 52, .external_lex_state = 2},
  [846] = {.lex_state = 52, .external_lex_state = 3},
  [847] = {.lex_state = 52, .external_lex_state = 3},
  [848] = {.lex_state = 52, .external_lex_state = 2},
  [849] = {.lex_state = 52, .external_lex_state = 2},
  [850] = {.lex_state = 52, .external_lex_state = 2},
  [851] = {.lex_state = 52, .external_lex_state = 2},
  [852] = {.lex_state = 52, .external_lex_state = 2},
  [853] = {.lex_state = 52, .external_lex_state = 2},
  [854] = {.lex_state = 52, .external_lex_state = 2},
  [855] = {.lex_state = 52, .external_lex_state = 2},
  [856] = {.lex_state = 52, .external_lex_state = 2},
  [857] = {.lex_state = 52, .external_lex_state = 2},
  [858] = {.lex_state = 52, .external_lex_state = 2},
  [859] = {.lex_state = 52, .external_lex_state = 2},
  [860] = {.lex_state = 52, .external_lex_state = 8},
  [861] = {.lex_state = 52, .external_lex_state = 2},
  [862] = {.lex_state = 52, .external_lex_state = 2},
  [863] = {.lex_state = 52, .external_lex_state = 2},
  [864] = {.lex_state = 52, .external_lex_state = 2},
  [865] = {.lex_state = 52, .external_lex_state = 2},
  [866] = {.lex_state = 52, .external_lex_state = 2},
  [867] = {.lex_state = 52, .external_lex_state = 2},
  [868] = {.lex_state = 52, .external_lex_state = 2},
  [869] = {.lex_state = 52, .external_lex_state = 2},
  [870] = {.lex_state = 13, .external_lex_state = 9},
  [871] = {.lex_state = 52, .external_lex_state = 2},
  [872] = {.lex_state = 52, .external_lex_state = 2},
  [873] = {.lex_state = 52, .external_lex_state = 2},
  [874] = {.lex_state = 52, .external_lex_state = 2},
  [875] = {.lex_state = 52, .external_lex_state = 2},
  [876] = {.lex_state = 52, .external_lex_state = 2},
  [877] = {.lex_state = 52, .external_lex_state = 2},
  [878] = {.lex_state = 52, .external_lex_state = 2},
  [879] = {.lex_state = 52, .external_lex_state = 2},
  [880] = {.lex_state = 52, .external_lex_state = 2},
  [881] = {.lex_state = 52, .external_lex_state = 2},
  [882] = {.lex_state = 52, .external_lex_state = 2},
  [883] = {.lex_state = 52, .external_lex_state = 2},
  [884] = {.lex_state = 52, .external_lex_state = 2},
  [885] = {.lex_state = 52, .external_lex_state = 2},
  [886] = {.lex_state = 52, .external_lex_state = 2},
  [887] = {.lex_state = 52, .external_lex_state = 2},
  [888] = {.lex_state = 52, .external_lex_state = 2},
  [889] = {.lex_state = 52, .external_lex_state = 2},
  [890] = {.lex_state = 52, .external_lex_state = 2},
  [891] = {.lex_state = 52, .external_lex_state = 2},
  [892] = {.lex_state = 52, .external_lex_state = 2},
  [893] = {.lex_state = 52, .external_lex_state = 2},
  [894] = {.lex_state = 52, .external_lex_state = 2},
  [895] = {.lex_state = 52, .external_lex_state = 2},
  [896] = {.lex_state = 52, .external_lex_state = 2},
  [897] = {.lex_state = 52, .external_lex_state = 2},
  [898] = {.lex_state = 52, .external_lex_state = 2},
  [899] = {.lex_state = 52, .external_lex_state = 2},
  [900] = {.lex_state = 52, .external_lex_state = 2},
  [901] = {.lex_state = 52, .external_lex_state = 2},
  [902] = {.lex_state = 52, .external_lex_state = 2},
  [903] = {.lex_state = 52, .external_lex_state = 2},
  [904] = {.lex_state = 52, .external_lex_state = 2},
  [905] = {.lex_state = 52, .external_lex_state = 2},
  [906] = {.lex_state = 52, .external_lex_state = 2},
  [907] = {.lex_state = 52, .external_lex_state = 2},
  [908] = {.lex_state = 52, .external_lex_state = 2},
  [909] = {.lex_state = 52, .external_lex_state = 2},
  [910] = {.lex_state = 52, .external_lex_state = 2},
  [911] = {.lex_state = 52, .external_lex_state = 2},
  [912] = {.lex_state = 52, .external_lex_state = 2},
  [913] = {.lex_state = 52, .external_lex_state = 2},
  [914] = {.lex_state = 52, .external_lex_state = 2},
  [915] = {.lex_state = 52, .external_lex_state = 2},
  [916] = {.lex_state = 52, .external_lex_state = 2},
  [917] = {.lex_state = 52, .external_lex_state = 2},
  [918] = {.lex_state = 52, .external_lex_state = 2},
  [919] = {.lex_state = 52, .external_lex_state = 2},
  [920] = {.lex_state = 52, .external_lex_state = 2},
  [921] = {.lex_state = 52, .external_lex_state = 2},
  [922] = {.lex_state = 52, .external_lex_state = 2},
  [923] = {.lex_state = 52, .external_lex_state = 2},
  [924] = {.lex_state = 52, .external_lex_state = 2},
  [925] = {.lex_state = 52, .external_lex_state = 2},
  [926] = {.lex_state = 52, .external_lex_state = 2},
  [927] = {.lex_state = 13, .external_lex_state = 12},
  [928] = {.lex_state = 13, .external_lex_state = 13},
  [929] = {.lex_state = 52, .external_lex_state = 2},
  [930] = {.lex_state = 52, .external_lex_state = 2},
  [931] = {.lex_state = 52, .external_lex_state = 2},
  [932] = {.lex_state = 52, .external_lex_state = 2},
  [933] = {.lex_state = 52, .external_lex_state = 2},
  [934] = {.lex_state = 52, .external_lex_state = 2},
  [935] = {.lex_state = 52, .external_lex_state = 2},
  [936] = {.lex_state = 52, .external_lex_state = 2},
  [937] = {.lex_state = 52, .external_lex_state = 2},
  [938] = {.lex_state = 52, .external_lex_state = 2},
  [939] = {.lex_state = 52, .external_lex_state = 2},
  [940] = {.lex_state = 52, .external_lex_state = 2},
  [941] = {.lex_state = 52, .external_lex_state = 2},
  [942] = {.lex_state = 52, .external_lex_state = 2},
  [943] = {.lex_state = 52, .external_lex_state = 2},
  [944] = {.lex_state = 52, .external_lex_state = 2},
  [945] = {.lex_state = 52, .external_lex_state = 2},
  [946] = {.lex_state = 52, .external_lex_state = 2},
  [947] = {.lex_state = 52, .external_lex_state = 2},
  [948] = {.lex_state = 52, .external_lex_state = 2},
  [949] = {.lex_state = 52, .external_lex_state = 2},
  [950] = {.lex_state = 52, .external_lex_state = 2},
  [951] = {.lex_state = 52, .external_lex_state = 2},
  [952] = {.lex_state = 52, .external_lex_state = 2},
  [953] = {.lex_state = 52, .external_lex_state = 2},
  [954] = {.lex_state = 52, .external_lex_state = 2},
  [955] = {.lex_state = 52, .external_lex_state = 2},
  [956] = {.lex_state = 52, .external_lex_state = 2},
  [957] = {.lex_state = 52, .external_lex_state = 2},
  [958] = {.lex_state = 52, .external_lex_state = 2},
  [959] = {.lex_state = 52, .external_lex_state = 2},
  [960] = {.lex_state = 52, .external_lex_state = 2},
  [961] = {.lex_state = 52, .external_lex_state = 2},
  [962] = {.lex_state = 52, .external_lex_state = 2},
  [963] = {.lex_state = 52, .external_lex_state = 2},
  [964] = {.lex_state = 13, .external_lex_state = 12},
  [965] = {.lex_state = 52, .external_lex_state = 2},
  [966] = {.lex_state = 13, .external_lex_state = 4},
  [967] = {.lex_state = 13, .external_lex_state = 14},
  [968] = {.lex_state = 13, .external_lex_state = 9},
  [969] = {.lex_state = 13, .external_lex_state = 4},
  [970] = {.lex_state = 13, .external_lex_state = 4},
  [971] = {.lex_state = 13, .external_lex_state = 15},
  [972] = {.lex_state = 13, .external_lex_state = 14},
  [973] = {.lex_state = 13, .external_lex_state = 9},
  [974] = {.lex_state = 13, .external_lex_state = 9},
  [975] = {.lex_state = 13, .external_lex_state = 9},
  [976] = {.lex_state = 13, .external_lex_state = 9},
  [977] = {.lex_state = 13, .external_lex_state = 7},
  [978] = {.lex_state = 13, .external_lex_state = 7},
  [979] = {.lex_state = 13, .external_lex_state = 7},
  [980] = {.lex_state = 13, .external_lex_state = 6},
  [981] = {.lex_state = 13, .external_lex_state = 6},
  [982] = {.lex_state = 13, .external_lex_state = 6},
  [983] = {.lex_state = 13, .external_lex_state = 6},
  [984] = {.lex_state = 13, .external_lex_state = 6},
  [985] = {.lex_state = 13, .external_lex_state = 6},
  [986] = {.lex_state = 13, .external_lex_state = 9},
  [987] = {.lex_state = 13, .external_lex_state = 9},
  [988] = {.lex_state = 13, .external_lex_state = 9},
  [989] = {.lex_state = 13, .external_lex_state = 9},
  [990] = {.lex_state = 13, .external_lex_state = 9},
  [991] = {.lex_state = 13, .external_lex_state = 9},
  [992] = {.lex_state = 13, .external_lex_state = 13},
  [993] = {.lex_state = 13, .external_lex_state = 12},
  [994] = {.lex_state = 13, .external_lex_state = 2},
  [995] = {.lex_state = 13, .external_lex_state = 2},
  [996] = {.lex_state = 14, .external_lex_state = 13},
  [997] = {.lex_state = 14, .external_lex_state = 13},
  [998] = {.lex_state = 13, .external_lex_state = 12},
  [999] = {.lex_state = 13, .external_lex_state = 12},
  [1000] = {.lex_state = 14, .external_lex_state = 9},
  [1001] = {.lex_state = 13, .external_lex_state = 4},
  [1002] = {.lex_state = 13, .external_lex_state = 12},
  [1003] = {.lex_state = 13, .external_lex_state = 12},
  [1004] = {.lex_state = 13, .external_lex_state = 12},
  [1005] = {.lex_state = 13, .external_lex_state = 12},
  [1006] = {.lex_state = 13, .external_lex_state = 12},
  [1007] = {.lex_state = 13, .external_lex_state = 12},
  [1008] = {.lex_state = 13, .external_lex_state = 12},
  [1009] = {.lex_state = 13, .external_lex_state = 12},
  [1010] = {.lex_state = 13, .external_lex_state = 13},
  [1011] = {.lex_state = 13, .external_lex_state = 13},
  [1012] = {.lex_state = 14, .external_lex_state = 9},
  [1013] = {.lex_state = 13, .external_lex_state = 12},
  [1014] = {.lex_state = 13, .external_lex_state = 12},
  [1015] = {.lex_state = 13, .external_lex_state = 4},
  [1016] = {.lex_state = 13, .external_lex_state = 12},
  [1017] = {.lex_state = 13, .external_lex_state = 13},
  [1018] = {.lex_state = 13, .external_lex_state = 12},
  [1019] = {.lex_state = 13, .external_lex_state = 12},
  [1020] = {.lex_state = 13, .external_lex_state = 8},
  [1021] = {.lex_state = 13, .external_lex_state = 12},
  [1022] = {.lex_state = 13, .external_lex_state = 12},
  [1023] = {.lex_state = 13, .external_lex_state = 12},
  [1024] = {.lex_state = 13, .external_lex_state = 12},
  [1025] = {.lex_state = 13, .external_lex_state = 2},
  [1026] = {.lex_state = 14, .external_lex_state = 9},
  [1027] = {.lex_state = 13, .external_lex_state = 12},
  [1028] = {.lex_state = 13, .external_lex_state = 12},
  [1029] = {.lex_state = 13, .external_lex_state = 12},
  [1030] = {.lex_state = 13, .external_lex_state = 12},
  [1031] = {.lex_state = 13, .external_lex_state = 12},
  [1032] = {.lex_state = 13, .external_lex_state = 12},
  [1033] = {.lex_state = 13, .external_lex_state = 14},
  [1034] = {.lex_state = 13, .external_lex_state = 8},
  [1035] = {.lex_state = 13, .external_lex_state = 8},
  [1036] = {.lex_state = 13, .external_lex_state = 8},
  [1037] = {.lex_state = 13, .external_lex_state = 13},
  [1038] = {.lex_state = 13, .external_lex_state = 13},
  [1039] = {.lex_state = 13, .external_lex_state = 13},
  [1040] = {.lex_state = 13, .external_lex_state = 13},
  [1041] = {.lex_state = 13, .external_lex_state = 13},
  [1042] = {.lex_state = 13, .external_lex_state = 13},
  [1043] = {.lex_state = 13, .external_lex_state = 13},
  [1044] = {.lex_state = 13, .external_lex_state = 8},
  [1045] = {.lex_state = 13, .external_lex_state = 13},
  [1046] = {.lex_state = 13, .external_lex_state = 8},
  [1047] = {.lex_state = 13, .external_lex_state = 12},
  [1048] = {.lex_state = 13, .external_lex_state = 12},
  [1049] = {.lex_state = 13, .external_lex_state = 9},
  [1050] = {.lex_state = 13, .external_lex_state = 9},
  [1051] = {.lex_state = 14, .external_lex_state = 12},
  [1052] = {.lex_state = 13, .external_lex_state = 15},
  [1053] = {.lex_state = 13, .external_lex_state = 15},
  [1054] = {.lex_state = 13, .external_lex_state = 7},
  [1055] = {.lex_state = 13, .external_lex_state = 14},
  [1056] = {.lex_state = 14, .external_lex_state = 12},
  [1057] = {.lex_state = 14, .external_lex_state = 12},
  [1058] = {.lex_state = 14, .external_lex_state = 12},
  [1059] = {.lex_state = 13, .external_lex_state = 9},
  [1060] = {.lex_state = 13, .external_lex_state = 15},
  [1061] = {.lex_state = 13, .external_lex_state = 15},
  [1062] = {.lex_state = 13, .external_lex_state = 15},
  [1063] = {.lex_state = 13, .external_lex_state = 15},
  [1064] = {.lex_state = 13, .external_lex_state = 15},
  [1065] = {.lex_state = 13, .external_lex_state = 6},
  [1066] = {.lex_state = 14, .external_lex_state = 13},
  [1067] = {.lex_state = 14, .external_lex_state = 13},
  [1068] = {.lex_state = 14, .external_lex_state = 13},
  [1069] = {.lex_state = 13, .external_lex_state = 15},
  [1070] = {.lex_state = 13, .external_lex_state = 15},
  [1071] = {.lex_state = 13, .external_lex_state = 14},
  [1072] = {.lex_state = 13, .external_lex_state = 15},
  [1073] = {.lex_state = 13, .external_lex_state = 9},
  [1074] = {.lex_state = 13, .external_lex_state = 6},
  [1075] = {.lex_state = 13, .external_lex_state = 9},
  [1076] = {.lex_state = 13, .external_lex_state = 9},
  [1077] = {.lex_state = 13, .external_lex_state = 9},
  [1078] = {.lex_state = 13, .external_lex_state = 9},
  [1079] = {.lex_state = 13, .external_lex_state = 9},
  [1080] = {.lex_state = 13, .external_lex_state = 9},
  [1081] = {.lex_state = 13, .external_lex_state = 9},
  [1082] = {.lex_state = 14, .external_lex_state = 12},
  [1083] = {.lex_state = 13, .external_lex_state = 9},
  [1084] = {.lex_state = 13, .external_lex_state = 9},
  [1085] = {.lex_state = 13, .external_lex_state = 9},
  [1086] = {.lex_state = 14, .external_lex_state = 14},
  [1087] = {.lex_state = 14, .external_lex_state = 14},
  [1088] = {.lex_state = 13, .external_lex_state = 14},
  [1089] = {.lex_state = 13, .external_lex_state = 9},
  [1090] = {.lex_state = 13, .external_lex_state = 14},
  [1091] = {.lex_state = 13, .external_lex_state = 9},
  [1092] = {.lex_state = 13, .external_lex_state = 9},
  [1093] = {.lex_state = 13, .external_lex_state = 9},
  [1094] = {.lex_state = 13, .external_lex_state = 6},
  [1095] = {.lex_state = 13, .external_lex_state = 9},
  [1096] = {.lex_state = 13, .external_lex_state = 14},
  [1097] = {.lex_state = 13, .external_lex_state = 14},
  [1098] = {.lex_state = 13, .external_lex_state = 9},
  [1099] = {.lex_state = 13, .external_lex_state = 6},
  [1100] = {.lex_state = 13, .external_lex_state = 14},
  [1101] = {.lex_state = 13, .external_lex_state = 14},
  [1102] = {.lex_state = 13, .external_lex_state = 14},
  [1103] = {.lex_state = 13, .external_lex_state = 14},
  [1104] = {.lex_state = 13, .external_lex_state = 14},
  [1105] = {.lex_state = 13, .external_lex_state = 14},
  [1106] = {.lex_state = 13, .external_lex_state = 14},
  [1107] = {.lex_state = 13, .external_lex_state = 14},
  [1108] = {.lex_state = 13, .external_lex_state = 9},
  [1109] = {.lex_state = 13, .external_lex_state = 9},
  [1110] = {.lex_state = 13, .external_lex_state = 7},
  [1111] = {.lex_state = 14, .external_lex_state = 12},
  [1112] = {.lex_state = 14, .external_lex_state = 12},
  [1113] = {.lex_state = 14, .external_lex_state = 12},
  [1114] = {.lex_state = 13, .external_lex_state = 9},
  [1115] = {.lex_state = 13, .external_lex_state = 9},
  [1116] = {.lex_state = 13, .external_lex_state = 7},
  [1117] = {.lex_state = 13, .external_lex_state = 7},
  [1118] = {.lex_state = 13, .external_lex_state = 9},
  [1119] = {.lex_state = 13, .external_lex_state = 9},
  [1120] = {.lex_state = 13, .external_lex_state = 9},
  [1121] = {.lex_state = 13, .external_lex_state = 9},
  [1122] = {.lex_state = 14, .external_lex_state = 14},
  [1123] = {.lex_state = 14, .external_lex_state = 14},
  [1124] = {.lex_state = 14, .external_lex_state = 14},
  [1125] = {.lex_state = 13, .external_lex_state = 14},
  [1126] = {.lex_state = 13, .external_lex_state = 9},
  [1127] = {.lex_state = 13, .external_lex_state = 14},
  [1128] = {.lex_state = 14, .external_lex_state = 13},
  [1129] = {.lex_state = 14, .external_lex_state = 12},
  [1130] = {.lex_state = 14, .external_lex_state = 12},
  [1131] = {.lex_state = 13, .external_lex_state = 9},
  [1132] = {.lex_state = 13, .external_lex_state = 7},
  [1133] = {.lex_state = 13, .external_lex_state = 14},
  [1134] = {.lex_state = 13, .external_lex_state = 9},
  [1135] = {.lex_state = 13, .external_lex_state = 9},
  [1136] = {.lex_state = 14, .external_lex_state = 9},
  [1137] = {.lex_state = 14, .external_lex_state = 9},
  [1138] = {.lex_state = 13, .external_lex_state = 14},
  [1139] = {.lex_state = 13, .external_lex_state = 14},
  [1140] = {.lex_state = 13, .external_lex_state = 9},
  [1141] = {.lex_state = 14, .external_lex_state = 13},
  [1142] = {.lex_state = 14, .external_lex_state = 13},
  [1143] = {.lex_state = 13, .external_lex_state = 9},
  [1144] = {.lex_state = 14, .external_lex_state = 12},
  [1145] = {.lex_state = 13, .external_lex_state = 9},
  [1146] = {.lex_state = 14, .external_lex_state = 12},
  [1147] = {.lex_state = 13, .external_lex_state = 9},
  [1148] = {.lex_state = 13, .external_lex_state = 14},
  [1149] = {.lex_state = 14, .external_lex_state = 13},
  [1150] = {.lex_state = 13, .external_lex_state = 13},
  [1151] = {.lex_state = 13, .external_lex_state = 13},
  [1152] = {.lex_state = 13, .external_lex_state = 12},
  [1153] = {.lex_state = 13, .external_lex_state = 12},
  [1154] = {.lex_state = 13, .external_lex_state = 12},
  [1155] = {.lex_state = 13, .external_lex_state = 12},
  [1156] = {.lex_state = 13, .external_lex_state = 12},
  [1157] = {.lex_state = 13, .external_lex_state = 12},
  [1158] = {.lex_state = 13, .external_lex_state = 13},
  [1159] = {.lex_state = 14, .external_lex_state = 14},
  [1160] = {.lex_state = 14, .external_lex_state = 14},
  [1161] = {.lex_state = 14, .external_lex_state = 14},
  [1162] = {.lex_state = 13, .external_lex_state = 12},
  [1163] = {.lex_state = 13, .external_lex_state = 12},
  [1164] = {.lex_state = 13, .external_lex_state = 12},
  [1165] = {.lex_state = 13, .external_lex_state = 12},
  [1166] = {.lex_state = 13, .external_lex_state = 12},
  [1167] = {.lex_state = 13, .external_lex_state = 12},
  [1168] = {.lex_state = 14, .external_lex_state = 14},
  [1169] = {.lex_state = 14, .external_lex_state = 14},
  [1170] = {.lex_state = 14, .external_lex_state = 14},
  [1171] = {.lex_state = 13, .external_lex_state = 12},
  [1172] = {.lex_state = 13, .external_lex_state = 12},
  [1173] = {.lex_state = 13, .external_lex_state = 12},
  [1174] = {.lex_state = 13, .external_lex_state = 12},
  [1175] = {.lex_state = 13, .external_lex_state = 12},
  [1176] = {.lex_state = 13, .external_lex_state = 12},
  [1177] = {.lex_state = 13, .external_lex_state = 13},
  [1178] = {.lex_state = 13, .external_lex_state = 12},
  [1179] = {.lex_state = 13, .external_lex_state = 14},
  [1180] = {.lex_state = 13, .external_lex_state = 12},
  [1181] = {.lex_state = 13, .external_lex_state = 12},
  [1182] = {.lex_state = 13, .external_lex_state = 12},
  [1183] = {.lex_state = 13, .external_lex_state = 12},
  [1184] = {.lex_state = 13, .external_lex_state = 12},
  [1185] = {.lex_state = 13, .external_lex_state = 12},
  [1186] = {.lex_state = 13, .external_lex_state = 12},
  [1187] = {.lex_state = 13, .external_lex_state = 13},
  [1188] = {.lex_state = 13, .external_lex_state = 12},
  [1189] = {.lex_state = 13, .external_lex_state = 12},
  [1190] = {.lex_state = 13, .external_lex_state = 12},
  [1191] = {.lex_state = 13, .external_lex_state = 13},
  [1192] = {.lex_state = 13, .external_lex_state = 13},
  [1193] = {.lex_state = 13, .external_lex_state = 13},
  [1194] = {.lex_state = 13, .external_lex_state = 12},
  [1195] = {.lex_state = 13, .external_lex_state = 12},
  [1196] = {.lex_state = 13, .external_lex_state = 13},
  [1197] = {.lex_state = 13, .external_lex_state = 13},
  [1198] = {.lex_state = 13, .external_lex_state = 12},
  [1199] = {.lex_state = 13, .external_lex_state = 12},
  [1200] = {.lex_state = 13, .external_lex_state = 13},
  [1201] = {.lex_state = 14, .external_lex_state = 13},
  [1202] = {.lex_state = 13, .external_lex_state = 12},
  [1203] = {.lex_state = 13, .external_lex_state = 12},
  [1204] = {.lex_state = 13, .external_lex_state = 12},
  [1205] = {.lex_state = 13, .external_lex_state = 12},
  [1206] = {.lex_state = 13, .external_lex_state = 12},
  [1207] = {.lex_state = 13, .external_lex_state = 12},
  [1208] = {.lex_state = 13, .external_lex_state = 13},
  [1209] = {.lex_state = 13, .external_lex_state = 13},
  [1210] = {.lex_state = 13, .external_lex_state = 12},
  [1211] = {.lex_state = 13, .external_lex_state = 12},
  [1212] = {.lex_state = 13, .external_lex_state = 12},
  [1213] = {.lex_state = 13, .external_lex_state = 12},
  [1214] = {.lex_state = 13, .external_lex_state = 2},
  [1215] = {.lex_state = 13, .external_lex_state = 14},
  [1216] = {.lex_state = 13, .external_lex_state = 12},
  [1217] = {.lex_state = 13, .external_lex_state = 12},
  [1218] = {.lex_state = 13, .external_lex_state = 12},
  [1219] = {.lex_state = 13, .external_lex_state = 12},
  [1220] = {.lex_state = 13, .external_lex_state = 12},
  [1221] = {.lex_state = 13, .external_lex_state = 12},
  [1222] = {.lex_state = 13, .external_lex_state = 12},
  [1223] = {.lex_state = 13, .external_lex_state = 12},
  [1224] = {.lex_state = 13, .external_lex_state = 12},
  [1225] = {.lex_state = 13, .external_lex_state = 12},
  [1226] = {.lex_state = 13, .external_lex_state = 13},
  [1227] = {.lex_state = 13, .external_lex_state = 12},
  [1228] = {.lex_state = 13, .external_lex_state = 12},
  [1229] = {.lex_state = 13, .external_lex_state = 12},
  [1230] = {.lex_state = 13, .external_lex_state = 14},
  [1231] = {.lex_state = 13, .external_lex_state = 14},
  [1232] = {.lex_state = 14, .external_lex_state = 14},
  [1233] = {.lex_state = 13, .external_lex_state = 13},
  [1234] = {.lex_state = 14, .external_lex_state = 14},
  [1235] = {.lex_state = 14, .external_lex_state = 14},
  [1236] = {.lex_state = 13, .external_lex_state = 13},
  [1237] = {.lex_state = 13, .external_lex_state = 13},
  [1238] = {.lex_state = 14, .external_lex_state = 13},
  [1239] = {.lex_state = 13, .external_lex_state = 12},
  [1240] = {.lex_state = 13, .external_lex_state = 12},
  [1241] = {.lex_state = 13, .external_lex_state = 12},
  [1242] = {.lex_state = 13, .external_lex_state = 12},
  [1243] = {.lex_state = 13, .external_lex_state = 12},
  [1244] = {.lex_state = 13, .external_lex_state = 12},
  [1245] = {.lex_state = 13, .external_lex_state = 13},
  [1246] = {.lex_state = 14, .external_lex_state = 13},
  [1247] = {.lex_state = 13, .external_lex_state = 8},
  [1248] = {.lex_state = 13, .external_lex_state = 12},
  [1249] = {.lex_state = 13, .external_lex_state = 12},
  [1250] = {.lex_state = 13, .external_lex_state = 13},
  [1251] = {.lex_state = 13, .external_lex_state = 13},
  [1252] = {.lex_state = 13, .external_lex_state = 13},
  [1253] = {.lex_state = 13, .external_lex_state = 8},
  [1254] = {.lex_state = 13, .external_lex_state = 12},
  [1255] = {.lex_state = 13, .external_lex_state = 12},
  [1256] = {.lex_state = 13, .external_lex_state = 13},
  [1257] = {.lex_state = 13, .external_lex_state = 13},
  [1258] = {.lex_state = 13, .external_lex_state = 13},
  [1259] = {.lex_state = 13, .external_lex_state = 13},
  [1260] = {.lex_state = 13, .external_lex_state = 13},
  [1261] = {.lex_state = 13, .external_lex_state = 13},
  [1262] = {.lex_state = 13, .external_lex_state = 13},
  [1263] = {.lex_state = 13, .external_lex_state = 13},
  [1264] = {.lex_state = 13, .external_lex_state = 13},
  [1265] = {.lex_state = 13, .external_lex_state = 13},
  [1266] = {.lex_state = 13, .external_lex_state = 12},
  [1267] = {.lex_state = 13, .external_lex_state = 12},
  [1268] = {.lex_state = 13, .external_lex_state = 13},
  [1269] = {.lex_state = 13, .external_lex_state = 12},
  [1270] = {.lex_state = 13, .external_lex_state = 13},
  [1271] = {.lex_state = 13, .external_lex_state = 13},
  [1272] = {.lex_state = 13, .external_lex_state = 13},
  [1273] = {.lex_state = 13, .external_lex_state = 13},
  [1274] = {.lex_state = 13, .external_lex_state = 13},
  [1275] = {.lex_state = 13, .external_lex_state = 13},
  [1276] = {.lex_state = 13, .external_lex_state = 14},
  [1277] = {.lex_state = 14, .external_lex_state = 14},
  [1278] = {.lex_state = 14, .external_lex_state = 14},
  [1279] = {.lex_state = 14, .external_lex_state = 14},
  [1280] = {.lex_state = 13, .external_lex_state = 8},
  [1281] = {.lex_state = 14, .external_lex_state = 13},
  [1282] = {.lex_state = 13, .external_lex_state = 14},
  [1283] = {.lex_state = 14, .external_lex_state = 15},
  [1284] = {.lex_state = 14, .external_lex_state = 15},
  [1285] = {.lex_state = 14, .external_lex_state = 15},
  [1286] = {.lex_state = 13, .external_lex_state = 2},
  [1287] = {.lex_state = 13, .external_lex_state = 13},
  [1288] = {.lex_state = 13, .external_lex_state = 13},
  [1289] = {.lex_state = 13, .external_lex_state = 8},
  [1290] = {.lex_state = 13, .external_lex_state = 13},
  [1291] = {.lex_state = 13, .external_lex_state = 13},
  [1292] = {.lex_state = 14, .external_lex_state = 13},
  [1293] = {.lex_state = 13, .external_lex_state = 13},
  [1294] = {.lex_state = 13, .external_lex_state = 13},
  [1295] = {.lex_state = 13, .external_lex_state = 13},
  [1296] = {.lex_state = 13, .external_lex_state = 13},
  [1297] = {.lex_state = 14, .external_lex_state = 15},
  [1298] = {.lex_state = 14, .external_lex_state = 15},
  [1299] = {.lex_state = 13, .external_lex_state = 13},
  [1300] = {.lex_state = 13, .external_lex_state = 14},
  [1301] = {.lex_state = 13, .external_lex_state = 12},
  [1302] = {.lex_state = 13, .external_lex_state = 14},
  [1303] = {.lex_state = 13, .external_lex_state = 13},
  [1304] = {.lex_state = 13, .external_lex_state = 14},
  [1305] = {.lex_state = 13, .external_lex_state = 14},
  [1306] = {.lex_state = 14, .external_lex_state = 13},
  [1307] = {.lex_state = 14, .external_lex_state = 13},
  [1308] = {.lex_state = 14, .external_lex_state = 13},
  [1309] = {.lex_state = 13, .external_lex_state = 14},
  [1310] = {.lex_state = 13, .external_lex_state = 14},
  [1311] = {.lex_state = 13, .external_lex_state = 15},
  [1312] = {.lex_state = 13, .external_lex_state = 14},
  [1313] = {.lex_state = 13, .external_lex_state = 15},
  [1314] = {.lex_state = 13, .external_lex_state = 15},
  [1315] = {.lex_state = 13, .external_lex_state = 14},
  [1316] = {.lex_state = 13, .external_lex_state = 14},
  [1317] = {.lex_state = 13, .external_lex_state = 14},
  [1318] = {.lex_state = 13, .external_lex_state = 14},
  [1319] = {.lex_state = 13, .external_lex_state = 14},
  [1320] = {.lex_state = 13, .external_lex_state = 14},
  [1321] = {.lex_state = 13, .external_lex_state = 14},
  [1322] = {.lex_state = 13, .external_lex_state = 14},
  [1323] = {.lex_state = 13, .external_lex_state = 14},
  [1324] = {.lex_state = 13, .external_lex_state = 14},
  [1325] = {.lex_state = 13, .external_lex_state = 15},
  [1326] = {.lex_state = 13, .external_lex_state = 13},
  [1327] = {.lex_state = 13, .external_lex_state = 15},
  [1328] = {.lex_state = 13, .external_lex_state = 15},
  [1329] = {.lex_state = 13, .external_lex_state = 14},
  [1330] = {.lex_state = 13, .external_lex_state = 14},
  [1331] = {.lex_state = 13, .external_lex_state = 14},
  [1332] = {.lex_state = 13, .external_lex_state = 14},
  [1333] = {.lex_state = 13, .external_lex_state = 14},
  [1334] = {.lex_state = 13, .external_lex_state = 14},
  [1335] = {.lex_state = 13, .external_lex_state = 14},
  [1336] = {.lex_state = 13, .external_lex_state = 15},
  [1337] = {.lex_state = 13, .external_lex_state = 14},
  [1338] = {.lex_state = 13, .external_lex_state = 14},
  [1339] = {.lex_state = 13, .external_lex_state = 14},
  [1340] = {.lex_state = 8, .external_lex_state = 9},
  [1341] = {.lex_state = 8, .external_lex_state = 9},
  [1342] = {.lex_state = 13, .external_lex_state = 15},
  [1343] = {.lex_state = 13, .external_lex_state = 14},
  [1344] = {.lex_state = 13, .external_lex_state = 14},
  [1345] = {.lex_state = 13, .external_lex_state = 14},
  [1346] = {.lex_state = 13, .external_lex_state = 15},
  [1347] = {.lex_state = 13, .external_lex_state = 15},
  [1348] = {.lex_state = 13, .external_lex_state = 14},
  [1349] = {.lex_state = 13, .external_lex_state = 15},
  [1350] = {.lex_state = 13, .external_lex_state = 15},
  [1351] = {.lex_state = 13, .external_lex_state = 15},
  [1352] = {.lex_state = 13, .external_lex_state = 15},
  [1353] = {.lex_state = 13, .external_lex_state = 15},
  [1354] = {.lex_state = 13, .external_lex_state = 15},
  [1355] = {.lex_state = 13, .external_lex_state = 14},
  [1356] = {.lex_state = 13, .external_lex_state = 14},
  [1357] = {.lex_state = 13, .external_lex_state = 14},
  [1358] = {.lex_state = 13, .external_lex_state = 14},
  [1359] = {.lex_state = 13, .external_lex_state = 14},
  [1360] = {.lex_state = 14, .external_lex_state = 14},
  [1361] = {.lex_state = 13, .external_lex_state = 14},
  [1362] = {.lex_state = 13, .external_lex_state = 14},
  [1363] = {.lex_state = 13, .external_lex_state = 14},
  [1364] = {.lex_state = 13, .external_lex_state = 14},
  [1365] = {.lex_state = 13, .external_lex_state = 14},
  [1366] = {.lex_state = 13, .external_lex_state = 14},
  [1367] = {.lex_state = 13, .external_lex_state = 7},
  [1368] = {.lex_state = 13, .external_lex_state = 14},
  [1369] = {.lex_state = 13, .external_lex_state = 7},
  [1370] = {.lex_state = 8, .external_lex_state = 9},
  [1371] = {.lex_state = 8, .external_lex_state = 9},
  [1372] = {.lex_state = 8, .external_lex_state = 9},
  [1373] = {.lex_state = 13, .external_lex_state = 15},
  [1374] = {.lex_state = 13, .external_lex_state = 14},
  [1375] = {.lex_state = 8, .external_lex_state = 9},
  [1376] = {.lex_state = 13, .external_lex_state = 15},
  [1377] = {.lex_state = 13, .external_lex_state = 15},
  [1378] = {.lex_state = 13, .external_lex_state = 14},
  [1379] = {.lex_state = 13, .external_lex_state = 14},
  [1380] = {.lex_state = 13, .external_lex_state = 14},
  [1381] = {.lex_state = 13, .external_lex_state = 14},
  [1382] = {.lex_state = 13, .external_lex_state = 14},
  [1383] = {.lex_state = 13, .external_lex_state = 15},
  [1384] = {.lex_state = 13, .external_lex_state = 15},
  [1385] = {.lex_state = 13, .external_lex_state = 14},
  [1386] = {.lex_state = 13, .external_lex_state = 15},
  [1387] = {.lex_state = 13, .external_lex_state = 14},
  [1388] = {.lex_state = 13, .external_lex_state = 15},
  [1389] = {.lex_state = 13, .external_lex_state = 14},
  [1390] = {.lex_state = 13, .external_lex_state = 14},
  [1391] = {.lex_state = 13, .external_lex_state = 14},
  [1392] = {.lex_state = 13, .external_lex_state = 15},
  [1393] = {.lex_state = 13, .external_lex_state = 14},
  [1394] = {.lex_state = 13, .external_lex_state = 15},
  [1395] = {.lex_state = 13, .external_lex_state = 15},
  [1396] = {.lex_state = 13, .external_lex_state = 14},
  [1397] = {.lex_state = 13, .external_lex_state = 15},
  [1398] = {.lex_state = 13, .external_lex_state = 15},
  [1399] = {.lex_state = 13, .external_lex_state = 15},
  [1400] = {.lex_state = 13, .external_lex_state = 14},
  [1401] = {.lex_state = 13, .external_lex_state = 15},
  [1402] = {.lex_state = 13, .external_lex_state = 15},
  [1403] = {.lex_state = 13, .external_lex_state = 15},
  [1404] = {.lex_state = 13, .external_lex_state = 14},
  [1405] = {.lex_state = 13, .external_lex_state = 14},
  [1406] = {.lex_state = 13, .external_lex_state = 14},
  [1407] = {.lex_state = 13, .external_lex_state = 14},
  [1408] = {.lex_state = 13, .external_lex_state = 14},
  [1409] = {.lex_state = 13, .external_lex_state = 14},
  [1410] = {.lex_state = 13, .external_lex_state = 15},
  [1411] = {.lex_state = 13, .external_lex_state = 15},
  [1412] = {.lex_state = 13, .external_lex_state = 14},
  [1413] = {.lex_state = 13, .external_lex_state = 14},
  [1414] = {.lex_state = 13, .external_lex_state = 14},
  [1415] = {.lex_state = 13, .external_lex_state = 15},
  [1416] = {.lex_state = 13, .external_lex_state = 13},
  [1417] = {.lex_state = 13, .external_lex_state = 15},
  [1418] = {.lex_state = 13, .external_lex_state = 14},
  [1419] = {.lex_state = 13, .external_lex_state = 9},
  [1420] = {.lex_state = 13, .external_lex_state = 14},
  [1421] = {.lex_state = 13, .external_lex_state = 14},
  [1422] = {.lex_state = 13, .external_lex_state = 14},
  [1423] = {.lex_state = 13, .external_lex_state = 13},
  [1424] = {.lex_state = 13, .external_lex_state = 14},
  [1425] = {.lex_state = 14, .external_lex_state = 14},
  [1426] = {.lex_state = 14, .external_lex_state = 14},
  [1427] = {.lex_state = 13, .external_lex_state = 14},
  [1428] = {.lex_state = 13, .external_lex_state = 13},
  [1429] = {.lex_state = 13, .external_lex_state = 13},
  [1430] = {.lex_state = 13, .external_lex_state = 13},
  [1431] = {.lex_state = 13, .external_lex_state = 13},
  [1432] = {.lex_state = 13, .external_lex_state = 13},
  [1433] = {.lex_state = 13, .external_lex_state = 13},
  [1434] = {.lex_state = 13, .external_lex_state = 13},
  [1435] = {.lex_state = 13, .external_lex_state = 13},
  [1436] = {.lex_state = 13, .external_lex_state = 13},
  [1437] = {.lex_state = 13, .external_lex_state = 13},
  [1438] = {.lex_state = 13, .external_lex_state = 15},
  [1439] = {.lex_state = 14, .external_lex_state = 14},
  [1440] = {.lex_state = 13, .external_lex_state = 13},
  [1441] = {.lex_state = 14, .external_lex_state = 14},
  [1442] = {.lex_state = 13, .external_lex_state = 13},
  [1443] = {.lex_state = 13, .external_lex_state = 13},
  [1444] = {.lex_state = 13, .external_lex_state = 13},
  [1445] = {.lex_state = 13, .external_lex_state = 13},
  [1446] = {.lex_state = 13, .external_lex_state = 13},
  [1447] = {.lex_state = 13, .external_lex_state = 13},
  [1448] = {.lex_state = 14, .external_lex_state = 12},
  [1449] = {.lex_state = 14, .external_lex_state = 12},
  [1450] = {.lex_state = 14, .external_lex_state = 12},
  [1451] = {.lex_state = 13, .external_lex_state = 13},
  [1452] = {.lex_state = 14, .external_lex_state = 14},
  [1453] = {.lex_state = 13, .external_lex_state = 13},
  [1454] = {.lex_state = 13, .external_lex_state = 13},
  [1455] = {.lex_state = 14, .external_lex_state = 13},
  [1456] = {.lex_state = 13, .external_lex_state = 13},
  [1457] = {.lex_state = 13, .external_lex_state = 13},
  [1458] = {.lex_state = 13, .external_lex_state = 13},
  [1459] = {.lex_state = 13, .external_lex_state = 13},
  [1460] = {.lex_state = 13, .external_lex_state = 13},
  [1461] = {.lex_state = 14, .external_lex_state = 13},
  [1462] = {.lex_state = 13, .external_lex_state = 13},
  [1463] = {.lex_state = 14, .external_lex_state = 13},
  [1464] = {.lex_state = 13, .external_lex_state = 13},
  [1465] = {.lex_state = 13, .external_lex_state = 13},
  [1466] = {.lex_state = 13, .external_lex_state = 13},
  [1467] = {.lex_state = 13, .external_lex_state = 13},
  [1468] = {.lex_state = 13, .external_lex_state = 13},
  [1469] = {.lex_state = 13, .external_lex_state = 13},
  [1470] = {.lex_state = 13, .external_lex_state = 13},
  [1471] = {.lex_state = 13, .external_lex_state = 13},
  [1472] = {.lex_state = 13, .external_lex_state = 13},
  [1473] = {.lex_state = 13, .external_lex_state = 13},
  [1474] = {.lex_state = 13, .external_lex_state = 13},
  [1475] = {.lex_state = 8, .external_lex_state = 15},
  [1476] = {.lex_state = 8, .external_lex_state = 15},
  [1477] = {.lex_state = 8, .external_lex_state = 15},
  [1478] = {.lex_state = 8, .external_lex_state = 15},
  [1479] = {.lex_state = 8, .external_lex_state = 15},
  [1480] = {.lex_state = 8, .external_lex_state = 15},
  [1481] = {.lex_state = 13, .external_lex_state = 14},
  [1482] = {.lex_state = 13, .external_lex_state = 13},
  [1483] = {.lex_state = 13, .external_lex_state = 12},
  [1484] = {.lex_state = 8, .external_lex_state = 15},
  [1485] = {.lex_state = 8, .external_lex_state = 15},
  [1486] = {.lex_state = 8, .external_lex_state = 15},
  [1487] = {.lex_state = 8, .external_lex_state = 15},
  [1488] = {.lex_state = 8, .external_lex_state = 15},
  [1489] = {.lex_state = 8, .external_lex_state = 15},
  [1490] = {.lex_state = 8, .external_lex_state = 15},
  [1491] = {.lex_state = 8, .external_lex_state = 15},
  [1492] = {.lex_state = 8, .external_lex_state = 15},
  [1493] = {.lex_state = 8, .external_lex_state = 15},
  [1494] = {.lex_state = 12, .external_lex_state = 2},
  [1495] = {.lex_state = 12, .external_lex_state = 2},
  [1496] = {.lex_state = 5, .external_lex_state = 8},
  [1497] = {.lex_state = 5, .external_lex_state = 8},
  [1498] = {.lex_state = 5, .external_lex_state = 8},
  [1499] = {.lex_state = 5, .external_lex_state = 8},
  [1500] = {.lex_state = 5, .external_lex_state = 8},
  [1501] = {.lex_state = 5, .external_lex_state = 7},
  [1502] = {.lex_state = 5, .external_lex_state = 8},
  [1503] = {.lex_state = 5, .external_lex_state = 8},
  [1504] = {.lex_state = 5, .external_lex_state = 7},
  [1505] = {.lex_state = 5, .external_lex_state = 8},
  [1506] = {.lex_state = 5, .external_lex_state = 7},
  [1507] = {.lex_state = 5, .external_lex_state = 8},
  [1508] = {.lex_state = 5, .external_lex_state = 8},
  [1509] = {.lex_state = 5, .external_lex_state = 7},
  [1510] = {.lex_state = 5, .external_lex_state = 8},
  [1511] = {.lex_state = 5, .external_lex_state = 7},
  [1512] = {.lex_state = 5, .external_lex_state = 8},
  [1513] = {.lex_state = 5, .external_lex_state = 7},
  [1514] = {.lex_state = 5, .external_lex_state = 8},
  [1515] = {.lex_state = 5, .external_lex_state = 8},
  [1516] = {.lex_state = 5, .external_lex_state = 7},
  [1517] = {.lex_state = 5, .external_lex_state = 8},
  [1518] = {.lex_state = 5, .external_lex_state = 8},
  [1519] = {.lex_state = 5, .external_lex_state = 7},
  [1520] = {.lex_state = 5, .external_lex_state = 8},
  [1521] = {.lex_state = 5, .external_lex_state = 8},
  [1522] = {.lex_state = 5, .external_lex_state = 8},
  [1523] = {.lex_state = 5, .external_lex_state = 7},
  [1524] = {.lex_state = 5, .external_lex_state = 8},
  [1525] = {.lex_state = 5, .external_lex_state = 8},
  [1526] = {.lex_state = 5, .external_lex_state = 7},
  [1527] = {.lex_state = 5, .external_lex_state = 8},
  [1528] = {.lex_state = 5, .external_lex_state = 8},
  [1529] = {.lex_state = 5, .external_lex_state = 8},
  [1530] = {.lex_state = 5, .external_lex_state = 7},
  [1531] = {.lex_state = 5, .external_lex_state = 7},
  [1532] = {.lex_state = 5, .external_lex_state = 2},
  [1533] = {.lex_state = 5, .external_lex_state = 2},
  [1534] = {.lex_state = 5, .external_lex_state = 2},
  [1535] = {.lex_state = 5, .external_lex_state = 2},
  [1536] = {.lex_state = 5, .external_lex_state = 2},
  [1537] = {.lex_state = 5, .external_lex_state = 6},
  [1538] = {.lex_state = 5, .external_lex_state = 6},
  [1539] = {.lex_state = 5, .external_lex_state = 6},
  [1540] = {.lex_state = 5, .external_lex_state = 6},
  [1541] = {.lex_state = 5, .external_lex_state = 6},
  [1542] = {.lex_state = 5, .external_lex_state = 6},
  [1543] = {.lex_state = 5, .external_lex_state = 6},
  [1544] = {.lex_state = 5, .external_lex_state = 6},
  [1545] = {.lex_state = 5, .external_lex_state = 6},
  [1546] = {.lex_state = 5, .external_lex_state = 6},
  [1547] = {.lex_state = 5, .external_lex_state = 6},
  [1548] = {.lex_state = 5, .external_lex_state = 6},
  [1549] = {.lex_state = 5, .external_lex_state = 6},
  [1550] = {.lex_state = 5, .external_lex_state = 6},
  [1551] = {.lex_state = 5, .external_lex_state = 6},
  [1552] = {.lex_state = 5, .external_lex_state = 6},
  [1553] = {.lex_state = 5, .external_lex_state = 6},
  [1554] = {.lex_state = 5, .external_lex_state = 6},
  [1555] = {.lex_state = 5, .external_lex_state = 6},
  [1556] = {.lex_state = 5, .external_lex_state = 6},
  [1557] = {.lex_state = 5, .external_lex_state = 2},
  [1558] = {.lex_state = 5, .external_lex_state = 2},
  [1559] = {.lex_state = 5, .external_lex_state = 2},
  [1560] = {.lex_state = 5, .external_lex_state = 2},
  [1561] = {.lex_state = 5, .external_lex_state = 2},
  [1562] = {.lex_state = 5, .external_lex_state = 2},
  [1563] = {.lex_state = 5, .external_lex_state = 2},
  [1564] = {.lex_state = 8, .external_lex_state = 9},
  [1565] = {.lex_state = 5, .external_lex_state = 2},
  [1566] = {.lex_state = 5, .external_lex_state = 2},
  [1567] = {.lex_state = 8, .external_lex_state = 9},
  [1568] = {.lex_state = 8, .external_lex_state = 13},
  [1569] = {.lex_state = 8, .external_lex_state = 13},
  [1570] = {.lex_state = 8, .external_lex_state = 14},
  [1571] = {.lex_state = 8, .external_lex_state = 15},
  [1572] = {.lex_state = 8, .external_lex_state = 15},
  [1573] = {.lex_state = 8, .external_lex_state = 14},
  [1574] = {.lex_state = 52, .external_lex_state = 12},
  [1575] = {.lex_state = 52, .external_lex_state = 12},
  [1576] = {.lex_state = 52, .external_lex_state = 12},
  [1577] = {.lex_state = 52, .external_lex_state = 12},
  [1578] = {.lex_state = 8, .external_lex_state = 13},
  [1579] = {.lex_state = 8, .external_lex_state = 13},
  [1580] = {.lex_state = 52, .external_lex_state = 14},
  [1581] = {.lex_state = 52, .external_lex_state = 2},
  [1582] = {.lex_state = 13, .external_lex_state = 12},
  [1583] = {.lex_state = 13, .external_lex_state = 12},
  [1584] = {.lex_state = 13, .external_lex_state = 12},
  [1585] = {.lex_state = 13, .external_lex_state = 12},
  [1586] = {.lex_state = 13, .external_lex_state = 12},
  [1587] = {.lex_state = 13, .external_lex_state = 12},
  [1588] = {.lex_state = 52, .external_lex_state = 2},
  [1589] = {.lex_state = 52, .external_lex_state = 14},
  [1590] = {.lex_state = 11, .external_lex_state = 9},
  [1591] = {.lex_state = 13, .external_lex_state = 14},
  [1592] = {.lex_state = 13, .external_lex_state = 14},
  [1593] = {.lex_state = 13, .external_lex_state = 14},
  [1594] = {.lex_state = 13, .external_lex_state = 14},
  [1595] = {.lex_state = 11, .external_lex_state = 9},
  [1596] = {.lex_state = 13, .external_lex_state = 14},
  [1597] = {.lex_state = 13, .external_lex_state = 14},
  [1598] = {.lex_state = 13, .external_lex_state = 15},
  [1599] = {.lex_state = 13, .external_lex_state = 13},
  [1600] = {.lex_state = 13, .external_lex_state = 13},
  [1601] = {.lex_state = 13, .external_lex_state = 15},
  [1602] = {.lex_state = 13, .external_lex_state = 15},
  [1603] = {.lex_state = 13, .external_lex_state = 15},
  [1604] = {.lex_state = 13, .external_lex_state = 15},
  [1605] = {.lex_state = 13, .external_lex_state = 15},
  [1606] = {.lex_state = 13, .external_lex_state = 14},
  [1607] = {.lex_state = 13, .external_lex_state = 14},
  [1608] = {.lex_state = 13, .external_lex_state = 14},
  [1609] = {.lex_state = 13, .external_lex_state = 14},
  [1610] = {.lex_state = 13, .external_lex_state = 15},
  [1611] = {.lex_state = 13, .external_lex_state = 15},
  [1612] = {.lex_state = 13, .external_lex_state = 15},
  [1613] = {.lex_state = 13, .external_lex_state = 15},
  [1614] = {.lex_state = 11, .external_lex_state = 9},
  [1615] = {.lex_state = 13, .external_lex_state = 13},
  [1616] = {.lex_state = 13, .external_lex_state = 15},
  [1617] = {.lex_state = 11, .external_lex_state = 9},
  [1618] = {.lex_state = 13, .external_lex_state = 14},
  [1619] = {.lex_state = 13, .external_lex_state = 14},
  [1620] = {.lex_state = 13, .external_lex_state = 15},
  [1621] = {.lex_state = 13, .external_lex_state = 13},
  [1622] = {.lex_state = 13, .external_lex_state = 15},
  [1623] = {.lex_state = 13, .external_lex_state = 15},
  [1624] = {.lex_state = 13, .external_lex_state = 15},
  [1625] = {.lex_state = 13, .external_lex_state = 15},
  [1626] = {.lex_state = 13, .external_lex_state = 15},
  [1627] = {.lex_state = 13, .external_lex_state = 15},
  [1628] = {.lex_state = 11, .external_lex_state = 9},
  [1629] = {.lex_state = 13, .external_lex_state = 15},
  [1630] = {.lex_state = 13, .external_lex_state = 15},
  [1631] = {.lex_state = 13, .external_lex_state = 15},
  [1632] = {.lex_state = 13, .external_lex_state = 15},
  [1633] = {.lex_state = 13, .external_lex_state = 13},
  [1634] = {.lex_state = 11, .external_lex_state = 9},
  [1635] = {.lex_state = 13, .external_lex_state = 13},
  [1636] = {.lex_state = 12, .external_lex_state = 15},
  [1637] = {.lex_state = 12, .external_lex_state = 15},
  [1638] = {.lex_state = 11, .external_lex_state = 15},
  [1639] = {.lex_state = 12, .external_lex_state = 15},
  [1640] = {.lex_state = 11, .external_lex_state = 15},
  [1641] = {.lex_state = 11, .external_lex_state = 9},
  [1642] = {.lex_state = 12, .external_lex_state = 15},
  [1643] = {.lex_state = 11, .external_lex_state = 15},
  [1644] = {.lex_state = 12, .external_lex_state = 15},
  [1645] = {.lex_state = 12, .external_lex_state = 15},
  [1646] = {.lex_state = 11, .external_lex_state = 15},
  [1647] = {.lex_state = 12, .external_lex_state = 15},
  [1648] = {.lex_state = 12, .external_lex_state = 15},
  [1649] = {.lex_state = 12, .external_lex_state = 15},
  [1650] = {.lex_state = 11, .external_lex_state = 15},
  [1651] = {.lex_state = 11, .external_lex_state = 15},
  [1652] = {.lex_state = 11, .external_lex_state = 15},
  [1653] = {.lex_state = 11, .external_lex_state = 15},
  [1654] = {.lex_state = 12, .external_lex_state = 15},
  [1655] = {.lex_state = 12, .external_lex_state = 15},
  [1656] = {.lex_state = 5, .external_lex_state = 14},
  [1657] = {.lex_state = 12, .external_lex_state = 15},
  [1658] = {.lex_state = 5, .external_lex_state = 14},
  [1659] = {.lex_state = 12, .external_lex_state = 15},
  [1660] = {.lex_state = 11, .external_lex_state = 15},
  [1661] = {.lex_state = 5, .external_lex_state = 14},
  [1662] = {.lex_state = 5, .external_lex_state = 15},
  [1663] = {.lex_state = 8, .external_lex_state = 13},
  [1664] = {.lex_state = 5, .external_lex_state = 15},
  [1665] = {.lex_state = 52, .external_lex_state = 12},
  [1666] = {.lex_state = 8, .external_lex_state = 9},
  [1667] = {.lex_state = 52, .external_lex_state = 12},
  [1668] = {.lex_state = 8, .external_lex_state = 9},
  [1669] = {.lex_state = 8, .external_lex_state = 9},
  [1670] = {.lex_state = 8, .external_lex_state = 9},
  [1671] = {.lex_state = 52, .external_lex_state = 12},
  [1672] = {.lex_state = 8, .external_lex_state = 9},
  [1673] = {.lex_state = 52, .external_lex_state = 12},
  [1674] = {.lex_state = 52, .external_lex_state = 12},
  [1675] = {.lex_state = 52, .external_lex_state = 12},
  [1676] = {.lex_state = 8, .external_lex_state = 9},
  [1677] = {.lex_state = 8, .external_lex_state = 9},
  [1678] = {.lex_state = 52, .external_lex_state = 12},
  [1679] = {.lex_state = 8, .external_lex_state = 9},
  [1680] = {.lex_state = 8, .external_lex_state = 9},
  [1681] = {.lex_state = 52, .external_lex_state = 12},
  [1682] = {.lex_state = 52, .external_lex_state = 14},
  [1683] = {.lex_state = 0, .external_lex_state = 16},
  [1684] = {.lex_state = 0, .external_lex_state = 16},
  [1685] = {.lex_state = 52, .external_lex_state = 14},
  [1686] = {.lex_state = 52, .external_lex_state = 14},
  [1687] = {.lex_state = 0, .external_lex_state = 16},
  [1688] = {.lex_state = 0, .external_lex_state = 16},
  [1689] = {.lex_state = 8, .external_lex_state = 9},
  [1690] = {.lex_state = 0, .external_lex_state = 16},
  [1691] = {.lex_state = 0, .external_lex_state = 16},
  [1692] = {.lex_state = 52, .external_lex_state = 14},
  [1693] = {.lex_state = 52, .external_lex_state = 14},
  [1694] = {.lex_state = 52, .external_lex_state = 14},
  [1695] = {.lex_state = 8, .external_lex_state = 13},
  [1696] = {.lex_state = 0, .external_lex_state = 16},
  [1697] = {.lex_state = 0, .external_lex_state = 16},
  [1698] = {.lex_state = 52, .external_lex_state = 14},
  [1699] = {.lex_state = 52, .external_lex_state = 14},
  [1700] = {.lex_state = 52, .external_lex_state = 14},
  [1701] = {.lex_state = 0, .external_lex_state = 16},
  [1702] = {.lex_state = 0, .external_lex_state = 16},
  [1703] = {.lex_state = 52, .external_lex_state = 14},
  [1704] = {.lex_state = 52, .external_lex_state = 14},
  [1705] = {.lex_state = 8, .external_lex_state = 13},
  [1706] = {.lex_state = 8, .external_lex_state = 13},
  [1707] = {.lex_state = 0, .external_lex_state = 16},
  [1708] = {.lex_state = 52, .external_lex_state = 14},
  [1709] = {.lex_state = 0, .external_lex_state = 16},
  [1710] = {.lex_state = 52, .external_lex_state = 14},
  [1711] = {.lex_state = 0, .external_lex_state = 16},
  [1712] = {.lex_state = 0, .external_lex_state = 16},
  [1713] = {.lex_state = 52, .external_lex_state = 14},
  [1714] = {.lex_state = 52, .external_lex_state = 14},
  [1715] = {.lex_state = 0, .external_lex_state = 16},
  [1716] = {.lex_state = 0, .external_lex_state = 16},
  [1717] = {.lex_state = 52, .external_lex_state = 14},
  [1718] = {.lex_state = 52, .external_lex_state = 14},
  [1719] = {.lex_state = 0, .external_lex_state = 16},
  [1720] = {.lex_state = 0, .external_lex_state = 16},
  [1721] = {.lex_state = 52, .external_lex_state = 13},
  [1722] = {.lex_state = 8, .external_lex_state = 13},
  [1723] = {.lex_state = 52, .external_lex_state = 13},
  [1724] = {.lex_state = 8, .external_lex_state = 13},
  [1725] = {.lex_state = 52, .external_lex_state = 13},
  [1726] = {.lex_state = 8, .external_lex_state = 13},
  [1727] = {.lex_state = 52, .external_lex_state = 13},
  [1728] = {.lex_state = 52, .external_lex_state = 13},
  [1729] = {.lex_state = 8, .external_lex_state = 13},
  [1730] = {.lex_state = 52, .external_lex_state = 13},
  [1731] = {.lex_state = 52, .external_lex_state = 13},
  [1732] = {.lex_state = 52, .external_lex_state = 13},
  [1733] = {.lex_state = 8, .external_lex_state = 13},
  [1734] = {.lex_state = 8, .external_lex_state = 13},
  [1735] = {.lex_state = 0, .external_lex_state = 16},
  [1736] = {.lex_state = 8, .external_lex_state = 14},
  [1737] = {.lex_state = 52, .external_lex_state = 12},
  [1738] = {.lex_state = 8, .external_lex_state = 15},
  [1739] = {.lex_state = 8, .external_lex_state = 14},
  [1740] = {.lex_state = 8, .external_lex_state = 9},
  [1741] = {.lex_state = 8, .external_lex_state = 15},
  [1742] = {.lex_state = 8, .external_lex_state = 15},
  [1743] = {.lex_state = 8, .external_lex_state = 15},
  [1744] = {.lex_state = 8, .external_lex_state = 15},
  [1745] = {.lex_state = 8, .external_lex_state = 14},
  [1746] = {.lex_state = 8, .external_lex_state = 14},
  [1747] = {.lex_state = 8, .external_lex_state = 15},
  [1748] = {.lex_state = 8, .external_lex_state = 14},
  [1749] = {.lex_state = 8, .external_lex_state = 14},
  [1750] = {.lex_state = 8, .external_lex_state = 14},
  [1751] = {.lex_state = 8, .external_lex_state = 15},
  [1752] = {.lex_state = 8, .external_lex_state = 15},
  [1753] = {.lex_state = 8, .external_lex_state = 15},
  [1754] = {.lex_state = 8, .external_lex_state = 14},
  [1755] = {.lex_state = 8, .external_lex_state = 14},
  [1756] = {.lex_state = 52, .external_lex_state = 12},
  [1757] = {.lex_state = 8, .external_lex_state = 14},
  [1758] = {.lex_state = 8, .external_lex_state = 15},
  [1759] = {.lex_state = 8, .external_lex_state = 13},
  [1760] = {.lex_state = 52, .external_lex_state = 12},
  [1761] = {.lex_state = 52, .external_lex_state = 12},
  [1762] = {.lex_state = 8, .external_lex_state = 15},
  [1763] = {.lex_state = 8, .external_lex_state = 13},
  [1764] = {.lex_state = 8, .external_lex_state = 13},
  [1765] = {.lex_state = 52, .external_lex_state = 12},
  [1766] = {.lex_state = 8, .external_lex_state = 13},
  [1767] = {.lex_state = 8, .external_lex_state = 13},
  [1768] = {.lex_state = 8, .external_lex_state = 13},
  [1769] = {.lex_state = 52, .external_lex_state = 12},
  [1770] = {.lex_state = 52, .external_lex_state = 9},
  [1771] = {.lex_state = 8, .external_lex_state = 13},
  [1772] = {.lex_state = 52, .external_lex_state = 12},
  [1773] = {.lex_state = 8, .external_lex_state = 13},
  [1774] = {.lex_state = 8, .external_lex_state = 15},
  [1775] = {.lex_state = 52, .external_lex_state = 12},
  [1776] = {.lex_state = 52, .external_lex_state = 12},
  [1777] = {.lex_state = 8, .external_lex_state = 13},
  [1778] = {.lex_state = 52, .external_lex_state = 12},
  [1779] = {.lex_state = 52, .external_lex_state = 12},
  [1780] = {.lex_state = 8, .external_lex_state = 13},
  [1781] = {.lex_state = 8, .external_lex_state = 15},
  [1782] = {.lex_state = 52, .external_lex_state = 12},
  [1783] = {.lex_state = 52, .external_lex_state = 12},
  [1784] = {.lex_state = 52, .external_lex_state = 12},
  [1785] = {.lex_state = 52, .external_lex_state = 12},
  [1786] = {.lex_state = 52, .external_lex_state = 12},
  [1787] = {.lex_state = 52, .external_lex_state = 12},
  [1788] = {.lex_state = 52, .external_lex_state = 12},
  [1789] = {.lex_state = 8, .external_lex_state = 15},
  [1790] = {.lex_state = 52, .external_lex_state = 12},
  [1791] = {.lex_state = 52, .external_lex_state = 12},
  [1792] = {.lex_state = 52, .external_lex_state = 12},
  [1793] = {.lex_state = 52, .external_lex_state = 12},
  [1794] = {.lex_state = 7, .external_lex_state = 13},
  [1795] = {.lex_state = 52, .external_lex_state = 13},
  [1796] = {.lex_state = 52, .external_lex_state = 14},
  [1797] = {.lex_state = 0, .external_lex_state = 16},
  [1798] = {.lex_state = 52, .external_lex_state = 15},
  [1799] = {.lex_state = 52, .external_lex_state = 9},
  [1800] = {.lex_state = 0, .external_lex_state = 16},
  [1801] = {.lex_state = 52, .external_lex_state = 13},
  [1802] = {.lex_state = 8, .external_lex_state = 15},
  [1803] = {.lex_state = 52, .external_lex_state = 12},
  [1804] = {.lex_state = 52, .external_lex_state = 14},
  [1805] = {.lex_state = 52, .external_lex_state = 9},
  [1806] = {.lex_state = 52, .external_lex_state = 14},
  [1807] = {.lex_state = 9, .external_lex_state = 17},
  [1808] = {.lex_state = 52, .external_lex_state = 12},
  [1809] = {.lex_state = 52, .external_lex_state = 13},
  [1810] = {.lex_state = 52, .external_lex_state = 14},
  [1811] = {.lex_state = 52, .external_lex_state = 13},
  [1812] = {.lex_state = 52, .external_lex_state = 9},
  [1813] = {.lex_state = 52, .external_lex_state = 13},
  [1814] = {.lex_state = 52, .external_lex_state = 13},
  [1815] = {.lex_state = 7, .external_lex_state = 14},
  [1816] = {.lex_state = 52, .external_lex_state = 13},
  [1817] = {.lex_state = 52, .external_lex_state = 13},
  [1818] = {.lex_state = 52, .external_lex_state = 14},
  [1819] = {.lex_state = 52, .external_lex_state = 13},
  [1820] = {.lex_state = 52, .external_lex_state = 2},
  [1821] = {.lex_state = 9, .external_lex_state = 17},
  [1822] = {.lex_state = 52, .external_lex_state = 12},
  [1823] = {.lex_state = 9, .external_lex_state = 17},
  [1824] = {.lex_state = 52, .external_lex_state = 9},
  [1825] = {.lex_state = 52, .external_lex_state = 14},
  [1826] = {.lex_state = 52, .external_lex_state = 9},
  [1827] = {.lex_state = 52, .external_lex_state = 9},
  [1828] = {.lex_state = 52, .external_lex_state = 9},
  [1829] = {.lex_state = 9, .external_lex_state = 17},
  [1830] = {.lex_state = 52, .external_lex_state = 13},
  [1831] = {.lex_state = 52, .external_lex_state = 13},
  [1832] = {.lex_state = 52, .external_lex_state = 12},
  [1833] = {.lex_state = 52, .external_lex_state = 13},
  [1834] = {.lex_state = 52, .external_lex_state = 9},
  [1835] = {.lex_state = 52, .external_lex_state = 14},
  [1836] = {.lex_state = 52, .external_lex_state = 15},
  [1837] = {.lex_state = 52, .external_lex_state = 14},
  [1838] = {.lex_state = 7, .external_lex_state = 12},
  [1839] = {.lex_state = 52, .external_lex_state = 14},
  [1840] = {.lex_state = 52, .external_lex_state = 14},
  [1841] = {.lex_state = 52, .external_lex_state = 14},
  [1842] = {.lex_state = 52, .external_lex_state = 14},
  [1843] = {.lex_state = 52, .external_lex_state = 9},
  [1844] = {.lex_state = 52, .external_lex_state = 13},
  [1845] = {.lex_state = 52, .external_lex_state = 14},
  [1846] = {.lex_state = 52, .external_lex_state = 13},
  [1847] = {.lex_state = 52, .external_lex_state = 13},
  [1848] = {.lex_state = 52, .external_lex_state = 15},
  [1849] = {.lex_state = 52, .external_lex_state = 15},
  [1850] = {.lex_state = 52, .external_lex_state = 15},
  [1851] = {.lex_state = 52, .external_lex_state = 12},
  [1852] = {.lex_state = 52, .external_lex_state = 12},
  [1853] = {.lex_state = 7, .external_lex_state = 14},
  [1854] = {.lex_state = 52, .external_lex_state = 12},
  [1855] = {.lex_state = 52, .external_lex_state = 13},
  [1856] = {.lex_state = 7, .external_lex_state = 15},
  [1857] = {.lex_state = 52, .external_lex_state = 12},
  [1858] = {.lex_state = 52, .external_lex_state = 8},
  [1859] = {.lex_state = 7, .external_lex_state = 13},
  [1860] = {.lex_state = 52, .external_lex_state = 12},
  [1861] = {.lex_state = 52, .external_lex_state = 13},
  [1862] = {.lex_state = 52, .external_lex_state = 9},
  [1863] = {.lex_state = 52, .external_lex_state = 14},
  [1864] = {.lex_state = 52, .external_lex_state = 15},
  [1865] = {.lex_state = 52, .external_lex_state = 14},
  [1866] = {.lex_state = 7, .external_lex_state = 14},
  [1867] = {.lex_state = 52, .external_lex_state = 13},
  [1868] = {.lex_state = 7, .external_lex_state = 14},
  [1869] = {.lex_state = 52, .external_lex_state = 15},
  [1870] = {.lex_state = 52, .external_lex_state = 12},
  [1871] = {.lex_state = 52, .external_lex_state = 12},
  [1872] = {.lex_state = 52, .external_lex_state = 15},
  [1873] = {.lex_state = 52, .external_lex_state = 13},
  [1874] = {.lex_state = 52, .external_lex_state = 15},
  [1875] = {.lex_state = 7, .external_lex_state = 13},
  [1876] = {.lex_state = 52, .external_lex_state = 12},
  [1877] = {.lex_state = 52, .external_lex_state = 7},
  [1878] = {.lex_state = 52, .external_lex_state = 13},
  [1879] = {.lex_state = 52, .external_lex_state = 12},
  [1880] = {.lex_state = 52, .external_lex_state = 13},
  [1881] = {.lex_state = 52, .external_lex_state = 14},
  [1882] = {.lex_state = 52, .external_lex_state = 12},
  [1883] = {.lex_state = 7, .external_lex_state = 12},
  [1884] = {.lex_state = 7, .external_lex_state = 12},
  [1885] = {.lex_state = 7, .external_lex_state = 13},
  [1886] = {.lex_state = 52, .external_lex_state = 9},
  [1887] = {.lex_state = 52, .external_lex_state = 14},
  [1888] = {.lex_state = 52, .external_lex_state = 15},
  [1889] = {.lex_state = 52, .external_lex_state = 12},
  [1890] = {.lex_state = 52, .external_lex_state = 12},
  [1891] = {.lex_state = 52, .external_lex_state = 15},
  [1892] = {.lex_state = 7, .external_lex_state = 12},
  [1893] = {.lex_state = 52, .external_lex_state = 14},
  [1894] = {.lex_state = 52, .external_lex_state = 6},
  [1895] = {.lex_state = 52, .external_lex_state = 15},
  [1896] = {.lex_state = 52, .external_lex_state = 15},
  [1897] = {.lex_state = 0, .external_lex_state = 16},
  [1898] = {.lex_state = 52, .external_lex_state = 15},
  [1899] = {.lex_state = 52, .external_lex_state = 15},
  [1900] = {.lex_state = 52, .external_lex_state = 14},
  [1901] = {.lex_state = 7, .external_lex_state = 9},
  [1902] = {.lex_state = 8, .external_lex_state = 9},
  [1903] = {.lex_state = 52, .external_lex_state = 12},
  [1904] = {.lex_state = 52, .external_lex_state = 12},
  [1905] = {.lex_state = 52, .external_lex_state = 13},
  [1906] = {.lex_state = 52, .external_lex_state = 13},
  [1907] = {.lex_state = 52, .external_lex_state = 14},
  [1908] = {.lex_state = 52, .external_lex_state = 14},
  [1909] = {.lex_state = 8, .external_lex_state = 15},
  [1910] = {.lex_state = 7, .external_lex_state = 12},
  [1911] = {.lex_state = 8, .external_lex_state = 13},
  [1912] = {.lex_state = 52, .external_lex_state = 15},
  [1913] = {.lex_state = 52, .external_lex_state = 15},
  [1914] = {.lex_state = 52, .external_lex_state = 15},
  [1915] = {.lex_state = 52, .external_lex_state = 14},
  [1916] = {.lex_state = 52, .external_lex_state = 12},
  [1917] = {.lex_state = 8, .external_lex_state = 9},
  [1918] = {.lex_state = 7, .external_lex_state = 13},
  [1919] = {.lex_state = 8, .external_lex_state = 14},
  [1920] = {.lex_state = 8, .external_lex_state = 9},
  [1921] = {.lex_state = 0, .external_lex_state = 16},
  [1922] = {.lex_state = 8, .external_lex_state = 9},
  [1923] = {.lex_state = 8, .external_lex_state = 14},
  [1924] = {.lex_state = 52, .external_lex_state = 9},
  [1925] = {.lex_state = 52, .external_lex_state = 13},
  [1926] = {.lex_state = 52, .external_lex_state = 12},
  [1927] = {.lex_state = 52, .external_lex_state = 13},
  [1928] = {.lex_state = 52, .external_lex_state = 9},
  [1929] = {.lex_state = 52, .external_lex_state = 12},
  [1930] = {.lex_state = 7, .external_lex_state = 14},
  [1931] = {.lex_state = 52, .external_lex_state = 12},
  [1932] = {.lex_state = 52, .external_lex_state = 14},
  [1933] = {.lex_state = 52, .external_lex_state = 15},
  [1934] = {.lex_state = 52, .external_lex_state = 15},
  [1935] = {.lex_state = 8, .external_lex_state = 15},
  [1936] = {.lex_state = 52, .external_lex_state = 15},
  [1937] = {.lex_state = 52, .external_lex_state = 12},
  [1938] = {.lex_state = 8, .external_lex_state = 9},
  [1939] = {.lex_state = 52, .external_lex_state = 13},
  [1940] = {.lex_state = 7, .external_lex_state = 9},
  [1941] = {.lex_state = 52, .external_lex_state = 13},
  [1942] = {.lex_state = 0, .external_lex_state = 16},
  [1943] = {.lex_state = 8, .external_lex_state = 13},
  [1944] = {.lex_state = 52, .external_lex_state = 12},
  [1945] = {.lex_state = 52, .external_lex_state = 15},
  [1946] = {.lex_state = 52, .external_lex_state = 13},
  [1947] = {.lex_state = 8, .external_lex_state = 15},
  [1948] = {.lex_state = 52, .external_lex_state = 14},
  [1949] = {.lex_state = 52, .external_lex_state = 12},
  [1950] = {.lex_state = 8, .external_lex_state = 13},
  [1951] = {.lex_state = 52, .external_lex_state = 13},
  [1952] = {.lex_state = 8, .external_lex_state = 9},
  [1953] = {.lex_state = 52, .external_lex_state = 13},
  [1954] = {.lex_state = 52, .external_lex_state = 14},
  [1955] = {.lex_state = 52, .external_lex_state = 13},
  [1956] = {.lex_state = 8, .external_lex_state = 9},
  [1957] = {.lex_state = 52, .external_lex_state = 14},
  [1958] = {.lex_state = 8, .external_lex_state = 14},
  [1959] = {.lex_state = 8, .external_lex_state = 14},
  [1960] = {.lex_state = 0, .external_lex_state = 16},
  [1961] = {.lex_state = 0, .external_lex_state = 16},
  [1962] = {.lex_state = 52, .external_lex_state = 14},
  [1963] = {.lex_state = 52, .external_lex_state = 12},
  [1964] = {.lex_state = 52, .external_lex_state = 14},
  [1965] = {.lex_state = 7, .external_lex_state = 9},
  [1966] = {.lex_state = 52, .external_lex_state = 12},
  [1967] = {.lex_state = 8, .external_lex_state = 14},
  [1968] = {.lex_state = 8, .external_lex_state = 14},
  [1969] = {.lex_state = 52, .external_lex_state = 12},
  [1970] = {.lex_state = 8, .external_lex_state = 14},
  [1971] = {.lex_state = 52, .external_lex_state = 13},
  [1972] = {.lex_state = 52, .external_lex_state = 15},
  [1973] = {.lex_state = 0, .external_lex_state = 16},
  [1974] = {.lex_state = 52, .external_lex_state = 14},
  [1975] = {.lex_state = 52, .external_lex_state = 15},
  [1976] = {.lex_state = 52, .external_lex_state = 14},
  [1977] = {.lex_state = 52, .external_lex_state = 15},
  [1978] = {.lex_state = 52, .external_lex_state = 13},
  [1979] = {.lex_state = 52, .external_lex_state = 12},
  [1980] = {.lex_state = 52, .external_lex_state = 15},
  [1981] = {.lex_state = 52, .external_lex_state = 9},
  [1982] = {.lex_state = 52, .external_lex_state = 14},
  [1983] = {.lex_state = 8, .external_lex_state = 9},
  [1984] = {.lex_state = 8, .external_lex_state = 9},
  [1985] = {.lex_state = 52, .external_lex_state = 14},
  [1986] = {.lex_state = 8, .external_lex_state = 9},
  [1987] = {.lex_state = 52, .external_lex_state = 14},
  [1988] = {.lex_state = 8, .external_lex_state = 9},
  [1989] = {.lex_state = 8, .external_lex_state = 14},
  [1990] = {.lex_state = 8, .external_lex_state = 14},
  [1991] = {.lex_state = 52, .external_lex_state = 15},
  [1992] = {.lex_state = 52, .external_lex_state = 14},
  [1993] = {.lex_state = 52, .external_lex_state = 13},
  [1994] = {.lex_state = 52, .external_lex_state = 12},
  [1995] = {.lex_state = 0, .external_lex_state = 16},
  [1996] = {.lex_state = 52, .external_lex_state = 14},
  [1997] = {.lex_state = 8, .external_lex_state = 14},
  [1998] = {.lex_state = 8, .external_lex_state = 13},
  [1999] = {.lex_state = 52, .external_lex_state = 13},
  [2000] = {.lex_state = 52, .external_lex_state = 14},
  [2001] = {.lex_state = 0, .external_lex_state = 16},
  [2002] = {.lex_state = 52, .external_lex_state = 12},
  [2003] = {.lex_state = 8, .external_lex_state = 14},
  [2004] = {.lex_state = 52, .external_lex_state = 15},
  [2005] = {.lex_state = 52, .external_lex_state = 15},
  [2006] = {.lex_state = 52, .external_lex_state = 15},
  [2007] = {.lex_state = 52, .external_lex_state = 12},
  [2008] = {.lex_state = 52, .external_lex_state = 12},
  [2009] = {.lex_state = 52, .external_lex_state = 14},
  [2010] = {.lex_state = 52, .external_lex_state = 14},
  [2011] = {.lex_state = 8, .external_lex_state = 13},
  [2012] = {.lex_state = 52, .external_lex_state = 15},
  [2013] = {.lex_state = 3, .external_lex_state = 12},
  [2014] = {.lex_state = 52, .external_lex_state = 15},
  [2015] = {.lex_state = 52, .external_lex_state = 14},
  [2016] = {.lex_state = 52, .external_lex_state = 12},
  [2017] = {.lex_state = 52, .external_lex_state = 9},
  [2018] = {.lex_state = 52, .external_lex_state = 15},
  [2019] = {.lex_state = 52, .external_lex_state = 15},
  [2020] = {.lex_state = 52, .external_lex_state = 15},
  [2021] = {.lex_state = 52, .external_lex_state = 12},
  [2022] = {.lex_state = 52, .external_lex_state = 15},
  [2023] = {.lex_state = 52, .external_lex_state = 13},
  [2024] = {.lex_state = 8, .external_lex_state = 15},
  [2025] = {.lex_state = 7, .external_lex_state = 9},
  [2026] = {.lex_state = 52, .external_lex_state = 15},
  [2027] = {.lex_state = 52, .external_lex_state = 15},
  [2028] = {.lex_state = 52, .external_lex_state = 15},
  [2029] = {.lex_state = 52, .external_lex_state = 15},
  [2030] = {.lex_state = 8, .external_lex_state = 13},
  [2031] = {.lex_state = 8, .external_lex_state = 13},
  [2032] = {.lex_state = 52, .external_lex_state = 9},
  [2033] = {.lex_state = 52, .external_lex_state = 15},
  [2034] = {.lex_state = 52, .external_lex_state = 12},
  [2035] = {.lex_state = 52, .external_lex_state = 15},
  [2036] = {.lex_state = 52, .external_lex_state = 9},
  [2037] = {.lex_state = 52, .external_lex_state = 9},
  [2038] = {.lex_state = 52, .external_lex_state = 12},
  [2039] = {.lex_state = 3, .external_lex_state = 12},
  [2040] = {.lex_state = 52, .external_lex_state = 15},
  [2041] = {.lex_state = 52, .external_lex_state = 12},
  [2042] = {.lex_state = 52, .external_lex_state = 12},
  [2043] = {.lex_state = 52, .external_lex_state = 15},
  [2044] = {.lex_state = 52, .external_lex_state = 12},
  [2045] = {.lex_state = 52, .external_lex_state = 15},
  [2046] = {.lex_state = 52, .external_lex_state = 15},
  [2047] = {.lex_state = 52, .external_lex_state = 15},
  [2048] = {.lex_state = 52, .external_lex_state = 12},
  [2049] = {.lex_state = 52, .external_lex_state = 12},
  [2050] = {.lex_state = 52, .external_lex_state = 15},
  [2051] = {.lex_state = 52, .external_lex_state = 15},
  [2052] = {.lex_state = 52, .external_lex_state = 9},
  [2053] = {.lex_state = 52, .external_lex_state = 15},
  [2054] = {.lex_state = 52, .external_lex_state = 15},
  [2055] = {.lex_state = 52, .external_lex_state = 15},
  [2056] = {.lex_state = 52, .external_lex_state = 9},
  [2057] = {.lex_state = 52, .external_lex_state = 15},
  [2058] = {.lex_state = 52, .external_lex_state = 13},
  [2059] = {.lex_state = 52, .external_lex_state = 13},
  [2060] = {.lex_state = 52, .external_lex_state = 13},
  [2061] = {.lex_state = 8, .external_lex_state = 15},
  [2062] = {.lex_state = 8, .external_lex_state = 15},
  [2063] = {.lex_state = 52, .external_lex_state = 12},
  [2064] = {.lex_state = 8, .external_lex_state = 13},
  [2065] = {.lex_state = 52, .external_lex_state = 15},
  [2066] = {.lex_state = 52, .external_lex_state = 12},
  [2067] = {.lex_state = 52, .external_lex_state = 15},
  [2068] = {.lex_state = 52, .external_lex_state = 15},
  [2069] = {.lex_state = 52, .external_lex_state = 14},
  [2070] = {.lex_state = 52, .external_lex_state = 12},
  [2071] = {.lex_state = 52, .external_lex_state = 15},
  [2072] = {.lex_state = 52, .external_lex_state = 12},
  [2073] = {.lex_state = 52, .external_lex_state = 12},
  [2074] = {.lex_state = 52, .external_lex_state = 13},
  [2075] = {.lex_state = 52, .external_lex_state = 15},
  [2076] = {.lex_state = 8, .external_lex_state = 13},
  [2077] = {.lex_state = 8, .external_lex_state = 15},
  [2078] = {.lex_state = 8, .external_lex_state = 15},
  [2079] = {.lex_state = 8, .external_lex_state = 13},
  [2080] = {.lex_state = 52, .external_lex_state = 15},
  [2081] = {.lex_state = 52, .external_lex_state = 13},
  [2082] = {.lex_state = 52, .external_lex_state = 12},
  [2083] = {.lex_state = 8, .external_lex_state = 15},
  [2084] = {.lex_state = 8, .external_lex_state = 13},
  [2085] = {.lex_state = 52, .external_lex_state = 13},
  [2086] = {.lex_state = 52, .external_lex_state = 13},
  [2087] = {.lex_state = 52, .external_lex_state = 13},
  [2088] = {.lex_state = 52, .external_lex_state = 12},
  [2089] = {.lex_state = 52, .external_lex_state = 15},
  [2090] = {.lex_state = 8, .external_lex_state = 13},
  [2091] = {.lex_state = 52, .external_lex_state = 15},
  [2092] = {.lex_state = 8, .external_lex_state = 13},
  [2093] = {.lex_state = 52, .external_lex_state = 12},
  [2094] = {.lex_state = 52, .external_lex_state = 15},
  [2095] = {.lex_state = 52, .external_lex_state = 14},
  [2096] = {.lex_state = 52, .external_lex_state = 15},
  [2097] = {.lex_state = 8, .external_lex_state = 13},
  [2098] = {.lex_state = 8, .external_lex_state = 15},
  [2099] = {.lex_state = 52, .external_lex_state = 15},
  [2100] = {.lex_state = 8, .external_lex_state = 9},
  [2101] = {.lex_state = 8, .external_lex_state = 13},
  [2102] = {.lex_state = 52, .external_lex_state = 15},
  [2103] = {.lex_state = 52, .external_lex_state = 15},
  [2104] = {.lex_state = 8, .external_lex_state = 14},
  [2105] = {.lex_state = 52, .external_lex_state = 14},
  [2106] = {.lex_state = 52, .external_lex_state = 14},
  [2107] = {.lex_state = 52, .external_lex_state = 15},
  [2108] = {.lex_state = 52, .external_lex_state = 12},
  [2109] = {.lex_state = 8, .external_lex_state = 15},
  [2110] = {.lex_state = 52, .external_lex_state = 15},
  [2111] = {.lex_state = 52, .external_lex_state = 14},
  [2112] = {.lex_state = 52, .external_lex_state = 15},
  [2113] = {.lex_state = 52, .external_lex_state = 15},
  [2114] = {.lex_state = 52, .external_lex_state = 9},
  [2115] = {.lex_state = 52, .external_lex_state = 15},
  [2116] = {.lex_state = 52, .external_lex_state = 15},
  [2117] = {.lex_state = 3, .external_lex_state = 12},
  [2118] = {.lex_state = 52, .external_lex_state = 15},
  [2119] = {.lex_state = 52, .external_lex_state = 15},
  [2120] = {.lex_state = 52, .external_lex_state = 15},
  [2121] = {.lex_state = 52, .external_lex_state = 14},
  [2122] = {.lex_state = 52, .external_lex_state = 12},
  [2123] = {.lex_state = 52, .external_lex_state = 15},
  [2124] = {.lex_state = 52, .external_lex_state = 14},
  [2125] = {.lex_state = 52, .external_lex_state = 12},
  [2126] = {.lex_state = 52, .external_lex_state = 12},
  [2127] = {.lex_state = 52, .external_lex_state = 13},
  [2128] = {.lex_state = 52, .external_lex_state = 15},
  [2129] = {.lex_state = 52, .external_lex_state = 12},
  [2130] = {.lex_state = 52, .external_lex_state = 12},
  [2131] = {.lex_state = 52, .external_lex_state = 18},
  [2132] = {.lex_state = 52, .external_lex_state = 12},
  [2133] = {.lex_state = 52, .external_lex_state = 12},
  [2134] = {.lex_state = 52, .external_lex_state = 12},
  [2135] = {.lex_state = 52, .external_lex_state = 13},
  [2136] = {.lex_state = 52, .external_lex_state = 12},
  [2137] = {.lex_state = 52, .external_lex_state = 13},
  [2138] = {.lex_state = 52, .external_lex_state = 12},
  [2139] = {.lex_state = 52, .external_lex_state = 12},
  [2140] = {.lex_state = 52, .external_lex_state = 12},
  [2141] = {.lex_state = 52, .external_lex_state = 12},
  [2142] = {.lex_state = 52, .external_lex_state = 12},
  [2143] = {.lex_state = 52, .external_lex_state = 12},
  [2144] = {.lex_state = 52, .external_lex_state = 12},
  [2145] = {.lex_state = 52, .external_lex_state = 12},
  [2146] = {.lex_state = 52, .external_lex_state = 12},
  [2147] = {.lex_state = 52, .external_lex_state = 12},
  [2148] = {.lex_state = 52, .external_lex_state = 12},
  [2149] = {.lex_state = 52, .external_lex_state = 12},
  [2150] = {.lex_state = 52, .external_lex_state = 12},
  [2151] = {.lex_state = 52, .external_lex_state = 12},
  [2152] = {.lex_state = 52, .external_lex_state = 13},
  [2153] = {.lex_state = 52, .external_lex_state = 14},
  [2154] = {.lex_state = 52, .external_lex_state = 13},
  [2155] = {.lex_state = 52, .external_lex_state = 9},
  [2156] = {.lex_state = 52, .external_lex_state = 9},
  [2157] = {.lex_state = 52, .external_lex_state = 9},
  [2158] = {.lex_state = 52, .external_lex_state = 14},
  [2159] = {.lex_state = 52, .external_lex_state = 9},
  [2160] = {.lex_state = 52, .external_lex_state = 14},
  [2161] = {.lex_state = 52, .external_lex_state = 15},
  [2162] = {.lex_state = 52, .external_lex_state = 15},
  [2163] = {.lex_state = 52, .external_lex_state = 14},
  [2164] = {.lex_state = 52, .external_lex_state = 15},
  [2165] = {.lex_state = 52, .external_lex_state = 14},
  [2166] = {.lex_state = 52, .external_lex_state = 13},
  [2167] = {.lex_state = 52, .external_lex_state = 13},
  [2168] = {.lex_state = 52, .external_lex_state = 13},
  [2169] = {.lex_state = 52, .external_lex_state = 13},
  [2170] = {.lex_state = 52, .external_lex_state = 13},
  [2171] = {.lex_state = 52, .external_lex_state = 14},
  [2172] = {.lex_state = 52, .external_lex_state = 13},
  [2173] = {.lex_state = 7, .external_lex_state = 15},
  [2174] = {.lex_state = 52, .external_lex_state = 14},
  [2175] = {.lex_state = 52, .external_lex_state = 9},
  [2176] = {.lex_state = 52, .external_lex_state = 14},
  [2177] = {.lex_state = 52, .external_lex_state = 13},
  [2178] = {.lex_state = 52, .external_lex_state = 13},
  [2179] = {.lex_state = 52, .external_lex_state = 13},
  [2180] = {.lex_state = 52, .external_lex_state = 13},
  [2181] = {.lex_state = 52, .external_lex_state = 13},
  [2182] = {.lex_state = 52, .external_lex_state = 13},
  [2183] = {.lex_state = 52, .external_lex_state = 13},
  [2184] = {.lex_state = 52, .external_lex_state = 12},
  [2185] = {.lex_state = 52, .external_lex_state = 13},
  [2186] = {.lex_state = 52, .external_lex_state = 13},
  [2187] = {.lex_state = 52, .external_lex_state = 13},
  [2188] = {.lex_state = 52, .external_lex_state = 13},
  [2189] = {.lex_state = 52, .external_lex_state = 13},
  [2190] = {.lex_state = 52, .external_lex_state = 14},
  [2191] = {.lex_state = 52, .external_lex_state = 13},
  [2192] = {.lex_state = 52, .external_lex_state = 13},
  [2193] = {.lex_state = 52, .external_lex_state = 13},
  [2194] = {.lex_state = 52, .external_lex_state = 14},
  [2195] = {.lex_state = 52, .external_lex_state = 15},
  [2196] = {.lex_state = 52, .external_lex_state = 12},
  [2197] = {.lex_state = 52, .external_lex_state = 9},
  [2198] = {.lex_state = 52, .external_lex_state = 14},
  [2199] = {.lex_state = 52, .external_lex_state = 9},
  [2200] = {.lex_state = 52, .external_lex_state = 9},
  [2201] = {.lex_state = 52, .external_lex_state = 15},
  [2202] = {.lex_state = 52, .external_lex_state = 14},
  [2203] = {.lex_state = 52, .external_lex_state = 13},
  [2204] = {.lex_state = 52, .external_lex_state = 14},
  [2205] = {.lex_state = 8, .external_lex_state = 15},
  [2206] = {.lex_state = 52, .external_lex_state = 14},
  [2207] = {.lex_state = 52, .external_lex_state = 18},
  [2208] = {.lex_state = 52, .external_lex_state = 14},
  [2209] = {.lex_state = 52, .external_lex_state = 9},
  [2210] = {.lex_state = 52, .external_lex_state = 14},
  [2211] = {.lex_state = 52, .external_lex_state = 14},
  [2212] = {.lex_state = 52, .external_lex_state = 14},
  [2213] = {.lex_state = 52, .external_lex_state = 14},
  [2214] = {.lex_state = 52, .external_lex_state = 14},
  [2215] = {.lex_state = 52, .external_lex_state = 18},
  [2216] = {.lex_state = 52, .external_lex_state = 9},
  [2217] = {.lex_state = 52, .external_lex_state = 9},
  [2218] = {.lex_state = 52, .external_lex_state = 9},
  [2219] = {.lex_state = 52, .external_lex_state = 14},
  [2220] = {.lex_state = 52, .external_lex_state = 14},
  [2221] = {.lex_state = 52, .external_lex_state = 14},
  [2222] = {.lex_state = 52, .external_lex_state = 14},
  [2223] = {.lex_state = 52, .external_lex_state = 14},
  [2224] = {.lex_state = 52, .external_lex_state = 12},
  [2225] = {.lex_state = 52, .external_lex_state = 15},
  [2226] = {.lex_state = 52, .external_lex_state = 14},
  [2227] = {.lex_state = 52, .external_lex_state = 14},
  [2228] = {.lex_state = 52, .external_lex_state = 14},
  [2229] = {.lex_state = 52, .external_lex_state = 9},
  [2230] = {.lex_state = 52, .external_lex_state = 9},
  [2231] = {.lex_state = 52, .external_lex_state = 15},
  [2232] = {.lex_state = 52, .external_lex_state = 15},
  [2233] = {.lex_state = 52, .external_lex_state = 14},
  [2234] = {.lex_state = 52, .external_lex_state = 18},
  [2235] = {.lex_state = 52, .external_lex_state = 14},
  [2236] = {.lex_state = 52, .external_lex_state = 14},
  [2237] = {.lex_state = 52, .external_lex_state = 14},
  [2238] = {.lex_state = 52, .external_lex_state = 9},
  [2239] = {.lex_state = 52, .external_lex_state = 9},
  [2240] = {.lex_state = 52, .external_lex_state = 14},
  [2241] = {.lex_state = 52, .external_lex_state = 14},
  [2242] = {.lex_state = 52, .external_lex_state = 14},
  [2243] = {.lex_state = 52, .external_lex_state = 14},
  [2244] = {.lex_state = 52, .external_lex_state = 13},
  [2245] = {.lex_state = 52, .external_lex_state = 9},
  [2246] = {.lex_state = 52, .external_lex_state = 15},
  [2247] = {.lex_state = 52, .external_lex_state = 15},
  [2248] = {.lex_state = 8, .external_lex_state = 15},
  [2249] = {.lex_state = 52, .external_lex_state = 12},
  [2250] = {.lex_state = 52, .external_lex_state = 15},
  [2251] = {.lex_state = 52, .external_lex_state = 18},
  [2252] = {.lex_state = 7, .external_lex_state = 15},
  [2253] = {.lex_state = 8, .external_lex_state = 15},
  [2254] = {.lex_state = 52, .external_lex_state = 12},
  [2255] = {.lex_state = 52, .external_lex_state = 14},
  [2256] = {.lex_state = 52, .external_lex_state = 15},
  [2257] = {.lex_state = 52, .external_lex_state = 9},
  [2258] = {.lex_state = 52, .external_lex_state = 14},
  [2259] = {.lex_state = 52, .external_lex_state = 14},
  [2260] = {.lex_state = 52, .external_lex_state = 14},
  [2261] = {.lex_state = 52, .external_lex_state = 12},
  [2262] = {.lex_state = 52, .external_lex_state = 15},
  [2263] = {.lex_state = 52, .external_lex_state = 12},
  [2264] = {.lex_state = 52, .external_lex_state = 14},
  [2265] = {.lex_state = 52, .external_lex_state = 14},
  [2266] = {.lex_state = 52, .external_lex_state = 13},
  [2267] = {.lex_state = 52, .external_lex_state = 13},
  [2268] = {.lex_state = 52, .external_lex_state = 15},
  [2269] = {.lex_state = 52, .external_lex_state = 14},
  [2270] = {.lex_state = 8, .external_lex_state = 15},
  [2271] = {.lex_state = 52, .external_lex_state = 14},
  [2272] = {.lex_state = 52, .external_lex_state = 12},
  [2273] = {.lex_state = 52, .external_lex_state = 14},
  [2274] = {.lex_state = 52, .external_lex_state = 14},
  [2275] = {.lex_state = 52, .external_lex_state = 14},
  [2276] = {.lex_state = 52, .external_lex_state = 13},
  [2277] = {.lex_state = 52, .external_lex_state = 13},
  [2278] = {.lex_state = 52, .external_lex_state = 12},
  [2279] = {.lex_state = 52, .external_lex_state = 15},
  [2280] = {.lex_state = 52, .external_lex_state = 13},
  [2281] = {.lex_state = 52, .external_lex_state = 12},
  [2282] = {.lex_state = 52, .external_lex_state = 12},
  [2283] = {.lex_state = 52, .external_lex_state = 13},
  [2284] = {.lex_state = 52, .external_lex_state = 13},
  [2285] = {.lex_state = 52, .external_lex_state = 14},
  [2286] = {.lex_state = 52, .external_lex_state = 12},
  [2287] = {.lex_state = 52, .external_lex_state = 12},
  [2288] = {.lex_state = 52, .external_lex_state = 14},
  [2289] = {.lex_state = 52, .external_lex_state = 14},
  [2290] = {.lex_state = 52, .external_lex_state = 13},
  [2291] = {.lex_state = 52, .external_lex_state = 12},
  [2292] = {.lex_state = 52, .external_lex_state = 12},
  [2293] = {.lex_state = 52, .external_lex_state = 15},
  [2294] = {.lex_state = 52, .external_lex_state = 14},
  [2295] = {.lex_state = 52, .external_lex_state = 9},
  [2296] = {.lex_state = 52, .external_lex_state = 14},
  [2297] = {.lex_state = 52, .external_lex_state = 15},
  [2298] = {.lex_state = 52, .external_lex_state = 15},
  [2299] = {.lex_state = 52, .external_lex_state = 15},
  [2300] = {.lex_state = 52, .external_lex_state = 9},
  [2301] = {.lex_state = 52, .external_lex_state = 12},
  [2302] = {.lex_state = 52, .external_lex_state = 12},
  [2303] = {.lex_state = 52, .external_lex_state = 14},
  [2304] = {.lex_state = 52, .external_lex_state = 14},
  [2305] = {.lex_state = 52, .external_lex_state = 9},
  [2306] = {.lex_state = 52, .external_lex_state = 12},
  [2307] = {.lex_state = 52, .external_lex_state = 9},
  [2308] = {.lex_state = 3, .external_lex_state = 12},
  [2309] = {.lex_state = 52, .external_lex_state = 14},
  [2310] = {.lex_state = 52, .external_lex_state = 12},
  [2311] = {.lex_state = 52, .external_lex_state = 19},
  [2312] = {.lex_state = 52, .external_lex_state = 14},
  [2313] = {.lex_state = 52, .external_lex_state = 14},
  [2314] = {.lex_state = 52, .external_lex_state = 13},
  [2315] = {.lex_state = 52, .external_lex_state = 14},
  [2316] = {.lex_state = 52, .external_lex_state = 13},
  [2317] = {.lex_state = 52, .external_lex_state = 14},
  [2318] = {.lex_state = 52, .external_lex_state = 14},
  [2319] = {.lex_state = 52, .external_lex_state = 14},
  [2320] = {.lex_state = 8, .external_lex_state = 15},
  [2321] = {.lex_state = 52, .external_lex_state = 13},
  [2322] = {.lex_state = 52, .external_lex_state = 13},
  [2323] = {.lex_state = 52, .external_lex_state = 15},
  [2324] = {.lex_state = 52, .external_lex_state = 13},
  [2325] = {.lex_state = 52, .external_lex_state = 9},
  [2326] = {.lex_state = 52, .external_lex_state = 14},
  [2327] = {.lex_state = 9, .external_lex_state = 17},
  [2328] = {.lex_state = 52, .external_lex_state = 12},
  [2329] = {.lex_state = 52, .external_lex_state = 19},
  [2330] = {.lex_state = 52, .external_lex_state = 15},
  [2331] = {.lex_state = 52, .external_lex_state = 14},
  [2332] = {.lex_state = 52, .external_lex_state = 19},
  [2333] = {.lex_state = 52, .external_lex_state = 13},
  [2334] = {.lex_state = 52, .external_lex_state = 12},
  [2335] = {.lex_state = 52, .external_lex_state = 12},
  [2336] = {.lex_state = 3, .external_lex_state = 12},
  [2337] = {.lex_state = 3, .external_lex_state = 12},
  [2338] = {.lex_state = 52, .external_lex_state = 12},
  [2339] = {.lex_state = 9, .external_lex_state = 17},
  [2340] = {.lex_state = 52, .external_lex_state = 14},
  [2341] = {.lex_state = 52, .external_lex_state = 14},
  [2342] = {.lex_state = 3, .external_lex_state = 12},
  [2343] = {.lex_state = 52, .external_lex_state = 15},
  [2344] = {.lex_state = 52, .external_lex_state = 9},
  [2345] = {.lex_state = 52, .external_lex_state = 15},
  [2346] = {.lex_state = 52, .external_lex_state = 9},
  [2347] = {.lex_state = 52, .external_lex_state = 12},
  [2348] = {.lex_state = 52, .external_lex_state = 14},
  [2349] = {.lex_state = 52, .external_lex_state = 12},
  [2350] = {.lex_state = 52, .external_lex_state = 13},
  [2351] = {.lex_state = 52, .external_lex_state = 13},
  [2352] = {.lex_state = 52, .external_lex_state = 9},
  [2353] = {.lex_state = 52, .external_lex_state = 13},
  [2354] = {.lex_state = 52, .external_lex_state = 12},
  [2355] = {.lex_state = 52, .external_lex_state = 14},
  [2356] = {.lex_state = 8, .external_lex_state = 15},
  [2357] = {.lex_state = 52, .external_lex_state = 14},
  [2358] = {.lex_state = 52, .external_lex_state = 14},
  [2359] = {.lex_state = 52, .external_lex_state = 13},
  [2360] = {.lex_state = 52, .external_lex_state = 12},
  [2361] = {.lex_state = 52, .external_lex_state = 12},
  [2362] = {.lex_state = 52, .external_lex_state = 14},
  [2363] = {.lex_state = 52, .external_lex_state = 19},
  [2364] = {.lex_state = 52, .external_lex_state = 14},
  [2365] = {.lex_state = 52, .external_lex_state = 13},
  [2366] = {.lex_state = 52, .external_lex_state = 13},
  [2367] = {.lex_state = 52, .external_lex_state = 9},
  [2368] = {.lex_state = 52, .external_lex_state = 14},
  [2369] = {.lex_state = 52, .external_lex_state = 15},
  [2370] = {.lex_state = 52, .external_lex_state = 14},
  [2371] = {.lex_state = 52, .external_lex_state = 14},
  [2372] = {.lex_state = 52, .external_lex_state = 14},
  [2373] = {.lex_state = 52, .external_lex_state = 14},
  [2374] = {.lex_state = 52, .external_lex_state = 9},
  [2375] = {.lex_state = 52, .external_lex_state = 13},
  [2376] = {.lex_state = 52, .external_lex_state = 14},
  [2377] = {.lex_state = 52, .external_lex_state = 13},
  [2378] = {.lex_state = 52, .external_lex_state = 13},
  [2379] = {.lex_state = 52, .external_lex_state = 12},
  [2380] = {.lex_state = 52, .external_lex_state = 13},
  [2381] = {.lex_state = 52, .external_lex_state = 9},
  [2382] = {.lex_state = 52, .external_lex_state = 14},
  [2383] = {.lex_state = 52, .external_lex_state = 14},
  [2384] = {.lex_state = 52, .external_lex_state = 12},
  [2385] = {.lex_state = 52, .external_lex_state = 14},
  [2386] = {.lex_state = 52, .external_lex_state = 14},
  [2387] = {.lex_state = 52, .external_lex_state = 15},
  [2388] = {.lex_state = 52, .external_lex_state = 13},
  [2389] = {.lex_state = 52, .external_lex_state = 14},
  [2390] = {.lex_state = 52, .external_lex_state = 13},
  [2391] = {.lex_state = 52, .external_lex_state = 14},
  [2392] = {.lex_state = 3, .external_lex_state = 12},
  [2393] = {.lex_state = 52, .external_lex_state = 14},
  [2394] = {.lex_state = 52, .external_lex_state = 13},
  [2395] = {.lex_state = 52, .external_lex_state = 13},
  [2396] = {.lex_state = 52, .external_lex_state = 14},
  [2397] = {.lex_state = 8, .external_lex_state = 15},
  [2398] = {.lex_state = 3, .external_lex_state = 12},
  [2399] = {.lex_state = 3, .external_lex_state = 12},
  [2400] = {.lex_state = 52, .external_lex_state = 15},
  [2401] = {.lex_state = 52, .external_lex_state = 14},
  [2402] = {.lex_state = 9, .external_lex_state = 17},
  [2403] = {.lex_state = 52, .external_lex_state = 9},
  [2404] = {.lex_state = 52, .external_lex_state = 14},
  [2405] = {.lex_state = 52, .external_lex_state = 13},
  [2406] = {.lex_state = 52, .external_lex_state = 12},
  [2407] = {.lex_state = 52, .external_lex_state = 13},
  [2408] = {.lex_state = 52, .external_lex_state = 9},
  [2409] = {.lex_state = 52, .external_lex_state = 12},
  [2410] = {.lex_state = 52, .external_lex_state = 14},
  [2411] = {.lex_state = 52, .external_lex_state = 12},
  [2412] = {.lex_state = 52, .external_lex_state = 14},
  [2413] = {.lex_state = 52, .external_lex_state = 14},
  [2414] = {.lex_state = 52, .external_lex_state = 13},
  [2415] = {.lex_state = 52, .external_lex_state = 15},
  [2416] = {.lex_state = 52, .external_lex_state = 14},
  [2417] = {.lex_state = 52, .external_lex_state = 14},
  [2418] = {.lex_state = 52, .external_lex_state = 14},
  [2419] = {.lex_state = 52, .external_lex_state = 14},
  [2420] = {.lex_state = 52, .external_lex_state = 13},
  [2421] = {.lex_state = 52, .external_lex_state = 13},
  [2422] = {.lex_state = 52, .external_lex_state = 14},
  [2423] = {.lex_state = 52, .external_lex_state = 12},
  [2424] = {.lex_state = 52, .external_lex_state = 14},
  [2425] = {.lex_state = 52, .external_lex_state = 12},
  [2426] = {.lex_state = 52, .external_lex_state = 14},
  [2427] = {.lex_state = 9, .external_lex_state = 17},
  [2428] = {.lex_state = 52, .external_lex_state = 14},
  [2429] = {.lex_state = 52, .external_lex_state = 9},
  [2430] = {.lex_state = 52, .external_lex_state = 14},
  [2431] = {.lex_state = 52, .external_lex_state = 9},
  [2432] = {.lex_state = 52, .external_lex_state = 9},
  [2433] = {.lex_state = 52, .external_lex_state = 12},
  [2434] = {.lex_state = 52, .external_lex_state = 9},
  [2435] = {.lex_state = 52, .external_lex_state = 12},
  [2436] = {.lex_state = 52, .external_lex_state = 9},
  [2437] = {.lex_state = 52, .external_lex_state = 14},
  [2438] = {.lex_state = 52, .external_lex_state = 14},
  [2439] = {.lex_state = 52, .external_lex_state = 14},
  [2440] = {.lex_state = 52, .external_lex_state = 13},
  [2441] = {.lex_state = 52, .external_lex_state = 15},
  [2442] = {.lex_state = 52, .external_lex_state = 15},
  [2443] = {.lex_state = 52, .external_lex_state = 14},
  [2444] = {.lex_state = 52, .external_lex_state = 14},
  [2445] = {.lex_state = 52, .external_lex_state = 13},
  [2446] = {.lex_state = 52, .external_lex_state = 13},
  [2447] = {.lex_state = 52, .external_lex_state = 13},
  [2448] = {.lex_state = 52, .external_lex_state = 9},
  [2449] = {.lex_state = 52, .external_lex_state = 19},
  [2450] = {.lex_state = 52, .external_lex_state = 13},
  [2451] = {.lex_state = 52, .external_lex_state = 13},
  [2452] = {.lex_state = 52, .external_lex_state = 13},
  [2453] = {.lex_state = 52, .external_lex_state = 14},
  [2454] = {.lex_state = 52, .external_lex_state = 14},
  [2455] = {.lex_state = 52, .external_lex_state = 13},
  [2456] = {.lex_state = 52, .external_lex_state = 13},
  [2457] = {.lex_state = 52, .external_lex_state = 9},
  [2458] = {.lex_state = 52, .external_lex_state = 13},
  [2459] = {.lex_state = 52, .external_lex_state = 13},
  [2460] = {.lex_state = 52, .external_lex_state = 13},
  [2461] = {.lex_state = 52, .external_lex_state = 13},
  [2462] = {.lex_state = 52, .external_lex_state = 13},
  [2463] = {.lex_state = 52, .external_lex_state = 9},
  [2464] = {.lex_state = 52, .external_lex_state = 14},
  [2465] = {.lex_state = 3, .external_lex_state = 12},
  [2466] = {.lex_state = 52, .external_lex_state = 15},
  [2467] = {.lex_state = 52, .external_lex_state = 13},
  [2468] = {.lex_state = 52, .external_lex_state = 15},
  [2469] = {.lex_state = 52, .external_lex_state = 15},
  [2470] = {.lex_state = 52, .external_lex_state = 14},
  [2471] = {.lex_state = 52, .external_lex_state = 15},
  [2472] = {.lex_state = 52, .external_lex_state = 9},
  [2473] = {.lex_state = 52, .external_lex_state = 15},
  [2474] = {.lex_state = 8, .external_lex_state = 15},
  [2475] = {.lex_state = 52, .external_lex_state = 12},
  [2476] = {.lex_state = 8, .external_lex_state = 15},
  [2477] = {.lex_state = 8, .external_lex_state = 15},
  [2478] = {.lex_state = 52, .external_lex_state = 12},
  [2479] = {.lex_state = 52, .external_lex_state = 12},
  [2480] = {.lex_state = 52, .external_lex_state = 12},
  [2481] = {.lex_state = 52, .external_lex_state = 13},
  [2482] = {.lex_state = 52, .external_lex_state = 14},
  [2483] = {.lex_state = 52, .external_lex_state = 15},
  [2484] = {.lex_state = 52, .external_lex_state = 15},
  [2485] = {.lex_state = 52, .external_lex_state = 9},
  [2486] = {.lex_state = 52, .external_lex_state = 15},
  [2487] = {.lex_state = 3, .external_lex_state = 12},
  [2488] = {.lex_state = 52, .external_lex_state = 14},
  [2489] = {.lex_state = 52, .external_lex_state = 14},
  [2490] = {.lex_state = 52, .external_lex_state = 19},
  [2491] = {.lex_state = 52, .external_lex_state = 15},
  [2492] = {.lex_state = 52, .external_lex_state = 12},
  [2493] = {.lex_state = 52, .external_lex_state = 12},
  [2494] = {.lex_state = 52, .external_lex_state = 19},
  [2495] = {.lex_state = 52, .external_lex_state = 14},
  [2496] = {.lex_state = 52, .external_lex_state = 13},
  [2497] = {.lex_state = 52, .external_lex_state = 15},
  [2498] = {.lex_state = 52, .external_lex_state = 15},
  [2499] = {.lex_state = 52, .external_lex_state = 14},
  [2500] = {.lex_state = 52, .external_lex_state = 14},
  [2501] = {.lex_state = 52, .external_lex_state = 14},
  [2502] = {.lex_state = 52, .external_lex_state = 14},
  [2503] = {.lex_state = 52, .external_lex_state = 13},
  [2504] = {.lex_state = 9, .external_lex_state = 17},
  [2505] = {.lex_state = 52, .external_lex_state = 13},
  [2506] = {.lex_state = 52, .external_lex_state = 14},
  [2507] = {.lex_state = 52, .external_lex_state = 15},
  [2508] = {.lex_state = 52, .external_lex_state = 12},
  [2509] = {.lex_state = 52, .external_lex_state = 19},
  [2510] = {.lex_state = 52, .external_lex_state = 15},
  [2511] = {.lex_state = 52, .external_lex_state = 15},
  [2512] = {.lex_state = 52, .external_lex_state = 14},
  [2513] = {.lex_state = 52, .external_lex_state = 14},
  [2514] = {.lex_state = 52, .external_lex_state = 15},
  [2515] = {.lex_state = 52, .external_lex_state = 15},
  [2516] = {.lex_state = 52, .external_lex_state = 14},
  [2517] = {.lex_state = 52, .external_lex_state = 9},
  [2518] = {.lex_state = 52, .external_lex_state = 15},
  [2519] = {.lex_state = 52, .external_lex_state = 9},
  [2520] = {.lex_state = 9, .external_lex_state = 15},
  [2521] = {.lex_state = 52, .external_lex_state = 18},
  [2522] = {.lex_state = 52, .external_lex_state = 9},
  [2523] = {.lex_state = 52, .external_lex_state = 14},
  [2524] = {.lex_state = 52, .external_lex_state = 15},
  [2525] = {.lex_state = 52, .external_lex_state = 13},
  [2526] = {.lex_state = 52, .external_lex_state = 12},
  [2527] = {.lex_state = 9, .external_lex_state = 15},
  [2528] = {.lex_state = 52, .external_lex_state = 18},
  [2529] = {.lex_state = 52, .external_lex_state = 18},
  [2530] = {.lex_state = 52, .external_lex_state = 18},
  [2531] = {.lex_state = 52, .external_lex_state = 15},
  [2532] = {.lex_state = 52, .external_lex_state = 18},
  [2533] = {.lex_state = 52, .external_lex_state = 15},
  [2534] = {.lex_state = 52, .external_lex_state = 15},
  [2535] = {.lex_state = 52, .external_lex_state = 13},
  [2536] = {.lex_state = 52, .external_lex_state = 15},
  [2537] = {.lex_state = 52, .external_lex_state = 12},
  [2538] = {.lex_state = 52, .external_lex_state = 12},
  [2539] = {.lex_state = 52, .external_lex_state = 18},
  [2540] = {.lex_state = 52, .external_lex_state = 18},
  [2541] = {.lex_state = 52, .external_lex_state = 15},
  [2542] = {.lex_state = 52, .external_lex_state = 12},
  [2543] = {.lex_state = 52, .external_lex_state = 15},
  [2544] = {.lex_state = 52, .external_lex_state = 12},
  [2545] = {.lex_state = 52, .external_lex_state = 14},
  [2546] = {.lex_state = 52, .external_lex_state = 15},
  [2547] = {.lex_state = 52, .external_lex_state = 14},
  [2548] = {.lex_state = 52, .external_lex_state = 13},
  [2549] = {.lex_state = 52, .external_lex_state = 14},
  [2550] = {.lex_state = 52, .external_lex_state = 14},
  [2551] = {.lex_state = 52, .external_lex_state = 14},
  [2552] = {.lex_state = 52, .external_lex_state = 18},
  [2553] = {.lex_state = 52, .external_lex_state = 15},
  [2554] = {.lex_state = 52, .external_lex_state = 18},
  [2555] = {.lex_state = 52, .external_lex_state = 13},
  [2556] = {.lex_state = 52, .external_lex_state = 15},
  [2557] = {.lex_state = 52, .external_lex_state = 9},
  [2558] = {.lex_state = 52, .external_lex_state = 9},
  [2559] = {.lex_state = 52, .external_lex_state = 15},
  [2560] = {.lex_state = 52, .external_lex_state = 15},
  [2561] = {.lex_state = 52, .external_lex_state = 13},
  [2562] = {.lex_state = 52, .external_lex_state = 9},
  [2563] = {.lex_state = 52, .external_lex_state = 15},
  [2564] = {.lex_state = 9, .external_lex_state = 15},
  [2565] = {.lex_state = 52, .external_lex_state = 15},
  [2566] = {.lex_state = 52, .external_lex_state = 9},
  [2567] = {.lex_state = 52, .external_lex_state = 18},
  [2568] = {.lex_state = 52, .external_lex_state = 9},
  [2569] = {.lex_state = 52, .external_lex_state = 18},
  [2570] = {.lex_state = 52, .external_lex_state = 9},
  [2571] = {.lex_state = 52, .external_lex_state = 14},
  [2572] = {.lex_state = 9, .external_lex_state = 15},
  [2573] = {.lex_state = 52, .external_lex_state = 18},
  [2574] = {.lex_state = 52, .external_lex_state = 18},
  [2575] = {.lex_state = 52, .external_lex_state = 15},
  [2576] = {.lex_state = 52, .external_lex_state = 18},
  [2577] = {.lex_state = 52, .external_lex_state = 9},
  [2578] = {.lex_state = 52, .external_lex_state = 9},
  [2579] = {.lex_state = 52, .external_lex_state = 14},
  [2580] = {.lex_state = 52, .external_lex_state = 14},
  [2581] = {.lex_state = 52, .external_lex_state = 15},
  [2582] = {.lex_state = 52, .external_lex_state = 18},
  [2583] = {.lex_state = 52, .external_lex_state = 9},
  [2584] = {.lex_state = 52, .external_lex_state = 13},
  [2585] = {.lex_state = 9, .external_lex_state = 15},
  [2586] = {.lex_state = 9, .external_lex_state = 15},
  [2587] = {.lex_state = 9, .external_lex_state = 15},
  [2588] = {.lex_state = 9, .external_lex_state = 15},
  [2589] = {.lex_state = 9, .external_lex_state = 15},
  [2590] = {.lex_state = 52, .external_lex_state = 15},
  [2591] = {.lex_state = 52, .external_lex_state = 9},
  [2592] = {.lex_state = 52, .external_lex_state = 15},
  [2593] = {.lex_state = 52, .external_lex_state = 18},
  [2594] = {.lex_state = 52, .external_lex_state = 15},
  [2595] = {.lex_state = 52, .external_lex_state = 9},
  [2596] = {.lex_state = 52, .external_lex_state = 13},
  [2597] = {.lex_state = 52, .external_lex_state = 14},
  [2598] = {.lex_state = 52, .external_lex_state = 9},
  [2599] = {.lex_state = 52, .external_lex_state = 13},
  [2600] = {.lex_state = 9, .external_lex_state = 15},
  [2601] = {.lex_state = 52, .external_lex_state = 14},
  [2602] = {.lex_state = 52, .external_lex_state = 15},
  [2603] = {.lex_state = 52, .external_lex_state = 18},
  [2604] = {.lex_state = 52, .external_lex_state = 9},
  [2605] = {.lex_state = 52, .external_lex_state = 18},
  [2606] = {.lex_state = 52, .external_lex_state = 14},
  [2607] = {.lex_state = 52, .external_lex_state = 15},
  [2608] = {.lex_state = 52, .external_lex_state = 9},
  [2609] = {.lex_state = 52, .external_lex_state = 15},
  [2610] = {.lex_state = 52, .external_lex_state = 15},
  [2611] = {.lex_state = 52, .external_lex_state = 14},
  [2612] = {.lex_state = 52, .external_lex_state = 13},
  [2613] = {.lex_state = 52, .external_lex_state = 9},
  [2614] = {.lex_state = 52, .external_lex_state = 15},
  [2615] = {.lex_state = 52, .external_lex_state = 14},
  [2616] = {.lex_state = 52, .external_lex_state = 12},
  [2617] = {.lex_state = 52, .external_lex_state = 12},
  [2618] = {.lex_state = 52, .external_lex_state = 13},
  [2619] = {.lex_state = 52, .external_lex_state = 12},
  [2620] = {.lex_state = 52, .external_lex_state = 15},
  [2621] = {.lex_state = 52, .external_lex_state = 14},
  [2622] = {.lex_state = 52, .external_lex_state = 12},
  [2623] = {.lex_state = 52, .external_lex_state = 15},
  [2624] = {.lex_state = 52, .external_lex_state = 15},
  [2625] = {.lex_state = 52, .external_lex_state = 15},
  [2626] = {.lex_state = 52, .external_lex_state = 15},
  [2627] = {.lex_state = 52, .external_lex_state = 15},
  [2628] = {.lex_state = 52, .external_lex_state = 14},
  [2629] = {.lex_state = 52, .external_lex_state = 13},
  [2630] = {.lex_state = 4, .external_lex_state = 15},
  [2631] = {.lex_state = 52, .external_lex_state = 15},
  [2632] = {.lex_state = 52, .external_lex_state = 12},
  [2633] = {.lex_state = 52, .external_lex_state = 12},
  [2634] = {.lex_state = 52, .external_lex_state = 15},
  [2635] = {.lex_state = 52, .external_lex_state = 14},
  [2636] = {.lex_state = 52, .external_lex_state = 14},
  [2637] = {.lex_state = 52, .external_lex_state = 15},
  [2638] = {.lex_state = 52, .external_lex_state = 15},
  [2639] = {.lex_state = 52, .external_lex_state = 15},
  [2640] = {.lex_state = 52, .external_lex_state = 15},
  [2641] = {.lex_state = 52, .external_lex_state = 12},
  [2642] = {.lex_state = 52, .external_lex_state = 14},
  [2643] = {.lex_state = 52, .external_lex_state = 14},
  [2644] = {.lex_state = 52, .external_lex_state = 14},
  [2645] = {.lex_state = 4, .external_lex_state = 15},
  [2646] = {.lex_state = 52, .external_lex_state = 12},
  [2647] = {.lex_state = 52, .external_lex_state = 13},
  [2648] = {.lex_state = 52, .external_lex_state = 12},
  [2649] = {.lex_state = 4, .external_lex_state = 15},
  [2650] = {.lex_state = 52, .external_lex_state = 14},
  [2651] = {.lex_state = 52, .external_lex_state = 15},
  [2652] = {.lex_state = 52, .external_lex_state = 13},
  [2653] = {.lex_state = 52, .external_lex_state = 15},
  [2654] = {.lex_state = 52, .external_lex_state = 12},
  [2655] = {.lex_state = 52, .external_lex_state = 15},
  [2656] = {.lex_state = 52, .external_lex_state = 12},
  [2657] = {.lex_state = 52, .external_lex_state = 15},
  [2658] = {.lex_state = 52, .external_lex_state = 14},
  [2659] = {.lex_state = 52, .external_lex_state = 14},
  [2660] = {.lex_state = 52, .external_lex_state = 15},
  [2661] = {.lex_state = 52, .external_lex_state = 15},
  [2662] = {.lex_state = 52, .external_lex_state = 15},
  [2663] = {.lex_state = 52, .external_lex_state = 12},
  [2664] = {.lex_state = 52, .external_lex_state = 14},
  [2665] = {.lex_state = 52, .external_lex_state = 13},
  [2666] = {.lex_state = 52, .external_lex_state = 13},
  [2667] = {.lex_state = 52, .external_lex_state = 13},
  [2668] = {.lex_state = 52, .external_lex_state = 14},
  [2669] = {.lex_state = 52, .external_lex_state = 15},
  [2670] = {.lex_state = 52, .external_lex_state = 15},
  [2671] = {.lex_state = 52, .external_lex_state = 12},
  [2672] = {.lex_state = 4, .external_lex_state = 15},
  [2673] = {.lex_state = 52, .external_lex_state = 14},
  [2674] = {.lex_state = 52, .external_lex_state = 12},
  [2675] = {.lex_state = 52, .external_lex_state = 15},
  [2676] = {.lex_state = 52, .external_lex_state = 12},
  [2677] = {.lex_state = 52, .external_lex_state = 12},
  [2678] = {.lex_state = 4, .external_lex_state = 15},
  [2679] = {.lex_state = 52, .external_lex_state = 15},
  [2680] = {.lex_state = 52, .external_lex_state = 15},
  [2681] = {.lex_state = 52, .external_lex_state = 15},
  [2682] = {.lex_state = 52, .external_lex_state = 15},
  [2683] = {.lex_state = 52, .external_lex_state = 14},
  [2684] = {.lex_state = 4, .external_lex_state = 15},
  [2685] = {.lex_state = 52, .external_lex_state = 13},
  [2686] = {.lex_state = 52, .external_lex_state = 15},
  [2687] = {.lex_state = 52, .external_lex_state = 14},
  [2688] = {.lex_state = 52, .external_lex_state = 15},
  [2689] = {.lex_state = 52, .external_lex_state = 13},
  [2690] = {.lex_state = 52, .external_lex_state = 12},
  [2691] = {.lex_state = 52, .external_lex_state = 14},
  [2692] = {.lex_state = 52, .external_lex_state = 14},
  [2693] = {.lex_state = 52, .external_lex_state = 15},
  [2694] = {.lex_state = 52, .external_lex_state = 14},
  [2695] = {.lex_state = 52, .external_lex_state = 13},
  [2696] = {.lex_state = 52, .external_lex_state = 15},
  [2697] = {.lex_state = 52, .external_lex_state = 15},
  [2698] = {.lex_state = 52, .external_lex_state = 15},
  [2699] = {.lex_state = 52, .external_lex_state = 12},
  [2700] = {.lex_state = 52, .external_lex_state = 15},
  [2701] = {.lex_state = 52, .external_lex_state = 15},
  [2702] = {.lex_state = 52, .external_lex_state = 15},
  [2703] = {.lex_state = 52, .external_lex_state = 12},
  [2704] = {.lex_state = 52, .external_lex_state = 14},
  [2705] = {.lex_state = 52, .external_lex_state = 15},
  [2706] = {.lex_state = 52, .external_lex_state = 14},
  [2707] = {.lex_state = 52, .external_lex_state = 15},
  [2708] = {.lex_state = 52, .external_lex_state = 14},
  [2709] = {.lex_state = 52, .external_lex_state = 15},
  [2710] = {.lex_state = 52, .external_lex_state = 15},
  [2711] = {.lex_state = 52, .external_lex_state = 15},
  [2712] = {.lex_state = 52, .external_lex_state = 15},
  [2713] = {.lex_state = 52, .external_lex_state = 13},
  [2714] = {.lex_state = 52, .external_lex_state = 15},
  [2715] = {.lex_state = 52, .external_lex_state = 14},
  [2716] = {.lex_state = 52, .external_lex_state = 15},
  [2717] = {.lex_state = 52, .external_lex_state = 15},
  [2718] = {.lex_state = 52, .external_lex_state = 13},
  [2719] = {.lex_state = 52, .external_lex_state = 13},
  [2720] = {.lex_state = 52, .external_lex_state = 12},
  [2721] = {.lex_state = 52, .external_lex_state = 15},
  [2722] = {.lex_state = 52, .external_lex_state = 13},
  [2723] = {.lex_state = 52, .external_lex_state = 13},
  [2724] = {.lex_state = 52, .external_lex_state = 13},
  [2725] = {.lex_state = 52, .external_lex_state = 12},
  [2726] = {.lex_state = 52, .external_lex_state = 15},
  [2727] = {.lex_state = 52, .external_lex_state = 15},
  [2728] = {.lex_state = 52, .external_lex_state = 15},
  [2729] = {.lex_state = 52, .external_lex_state = 12},
  [2730] = {.lex_state = 52, .external_lex_state = 14},
  [2731] = {.lex_state = 52, .external_lex_state = 12},
  [2732] = {.lex_state = 52, .external_lex_state = 15},
  [2733] = {.lex_state = 52, .external_lex_state = 15},
  [2734] = {.lex_state = 52, .external_lex_state = 15},
  [2735] = {.lex_state = 52, .external_lex_state = 15},
  [2736] = {.lex_state = 52, .external_lex_state = 15},
  [2737] = {.lex_state = 52, .external_lex_state = 15},
  [2738] = {.lex_state = 52, .external_lex_state = 15},
  [2739] = {.lex_state = 52, .external_lex_state = 12},
  [2740] = {.lex_state = 52, .external_lex_state = 12},
  [2741] = {.lex_state = 52, .external_lex_state = 15},
  [2742] = {.lex_state = 52, .external_lex_state = 15},
  [2743] = {.lex_state = 52, .external_lex_state = 15},
  [2744] = {.lex_state = 52, .external_lex_state = 12},
  [2745] = {.lex_state = 52, .external_lex_state = 15},
  [2746] = {.lex_state = 52, .external_lex_state = 15},
  [2747] = {.lex_state = 52, .external_lex_state = 15},
  [2748] = {.lex_state = 52, .external_lex_state = 12},
  [2749] = {.lex_state = 52, .external_lex_state = 14},
  [2750] = {.lex_state = 52, .external_lex_state = 15},
  [2751] = {.lex_state = 52, .external_lex_state = 15},
  [2752] = {.lex_state = 52, .external_lex_state = 12},
  [2753] = {.lex_state = 52, .external_lex_state = 12},
  [2754] = {.lex_state = 52, .external_lex_state = 15},
  [2755] = {.lex_state = 52, .external_lex_state = 15},
  [2756] = {.lex_state = 52, .external_lex_state = 15},
  [2757] = {.lex_state = 52, .external_lex_state = 15},
  [2758] = {.lex_state = 52, .external_lex_state = 12},
  [2759] = {.lex_state = 52, .external_lex_state = 13},
  [2760] = {.lex_state = 52, .external_lex_state = 15},
  [2761] = {.lex_state = 52, .external_lex_state = 13},
  [2762] = {.lex_state = 52, .external_lex_state = 13},
  [2763] = {.lex_state = 52, .external_lex_state = 12},
  [2764] = {.lex_state = 52, .external_lex_state = 12},
  [2765] = {.lex_state = 52, .external_lex_state = 15},
  [2766] = {.lex_state = 52, .external_lex_state = 14},
  [2767] = {.lex_state = 52, .external_lex_state = 15},
  [2768] = {.lex_state = 52, .external_lex_state = 15},
  [2769] = {.lex_state = 52, .external_lex_state = 12},
  [2770] = {.lex_state = 52, .external_lex_state = 14},
  [2771] = {.lex_state = 52, .external_lex_state = 15},
  [2772] = {.lex_state = 52, .external_lex_state = 15},
  [2773] = {.lex_state = 52, .external_lex_state = 14},
  [2774] = {.lex_state = 52, .external_lex_state = 15},
  [2775] = {.lex_state = 52, .external_lex_state = 15},
  [2776] = {.lex_state = 52, .external_lex_state = 13},
  [2777] = {.lex_state = 52, .external_lex_state = 15},
  [2778] = {.lex_state = 52, .external_lex_state = 14},
  [2779] = {.lex_state = 52, .external_lex_state = 12},
  [2780] = {.lex_state = 52, .external_lex_state = 14},
  [2781] = {.lex_state = 4, .external_lex_state = 15},
  [2782] = {.lex_state = 52, .external_lex_state = 14},
  [2783] = {.lex_state = 52, .external_lex_state = 15},
  [2784] = {.lex_state = 52, .external_lex_state = 15},
  [2785] = {.lex_state = 52, .external_lex_state = 12},
  [2786] = {.lex_state = 4, .external_lex_state = 15},
  [2787] = {.lex_state = 52, .external_lex_state = 15},
  [2788] = {.lex_state = 52, .external_lex_state = 12},
  [2789] = {.lex_state = 52, .external_lex_state = 12},
  [2790] = {.lex_state = 52, .external_lex_state = 14},
  [2791] = {.lex_state = 52, .external_lex_state = 12},
  [2792] = {.lex_state = 52, .external_lex_state = 12},
  [2793] = {.lex_state = 52, .external_lex_state = 15},
  [2794] = {.lex_state = 52, .external_lex_state = 15},
  [2795] = {.lex_state = 52, .external_lex_state = 15},
  [2796] = {.lex_state = 52, .external_lex_state = 15},
  [2797] = {.lex_state = 52, .external_lex_state = 15},
  [2798] = {.lex_state = 52, .external_lex_state = 15},
  [2799] = {.lex_state = 52, .external_lex_state = 13},
  [2800] = {.lex_state = 52, .external_lex_state = 15},
  [2801] = {.lex_state = 52, .external_lex_state = 15},
  [2802] = {.lex_state = 52, .external_lex_state = 15},
  [2803] = {.lex_state = 52, .external_lex_state = 15},
  [2804] = {.lex_state = 52, .external_lex_state = 15},
  [2805] = {.lex_state = 52, .external_lex_state = 15},
  [2806] = {.lex_state = 52, .external_lex_state = 15},
  [2807] = {.lex_state = 52, .external_lex_state = 12},
  [2808] = {.lex_state = 52, .external_lex_state = 15},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym___future__] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_print] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_del] = ACTIONS(1),
    [anon_sym_raise] = ACTIONS(1),
    [anon_sym_pass] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_elif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_match] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_except] = ACTIONS(1),
    [anon_sym_except_STAR] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_def] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_nonlocal] = ACTIONS(1),
    [anon_sym_exec] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_lambda] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_AT_EQ] = ACTIONS(1),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [sym_ellipsis] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [sym_type_conversion] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_none] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(5),
    [sym__newline] = ACTIONS(1),
    [sym__indent] = ACTIONS(1),
    [sym__dedent] = ACTIONS(1),
    [sym_string_start] = ACTIONS(1),
    [sym__string_content] = ACTIONS(1),
    [sym_escape_interpolation] = ACTIONS(1),
    [sym_string_end] = ACTIONS(1),
  },
  [1] = {
    [sym_module] = STATE(2732),
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2305),
    [sym_future_import_statement] = STATE(2305),
    [sym_import_from_statement] = STATE(2305),
    [sym_print_statement] = STATE(2305),
    [sym_assert_statement] = STATE(2305),
    [sym_expression_statement] = STATE(2305),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2305),
    [sym_delete_statement] = STATE(2305),
    [sym_raise_statement] = STATE(2305),
    [sym_pass_statement] = STATE(2305),
    [sym_break_statement] = STATE(2305),
    [sym_continue_statement] = STATE(2305),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2305),
    [sym_nonlocal_statement] = STATE(2305),
    [sym_exec_statement] = STATE(2305),
    [sym_type_alias_statement] = STATE(2305),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1798),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1798),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_match] = ACTIONS(37),
    [anon_sym_async] = ACTIONS(39),
    [anon_sym_for] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_def] = ACTIONS(49),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(81),
  },
  [2] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(726),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [3] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(706),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [4] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(802),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [5] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(819),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [6] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(813),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [7] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(827),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [8] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(731),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [9] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(733),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [10] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(740),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [11] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(712),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [12] = {
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(671),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(105),
    [sym_string_start] = ACTIONS(81),
  },
  [13] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(747),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [14] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(750),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [15] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(752),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [16] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(729),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [17] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(715),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [18] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(768),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [19] = {
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(673),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(105),
    [sym_string_start] = ACTIONS(81),
  },
  [20] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(680),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [21] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(772),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [22] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(716),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [23] = {
    [sym__statement] = STATE(70),
    [sym__simple_statements] = STATE(70),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(70),
    [sym_match_statement] = STATE(70),
    [sym_for_statement] = STATE(70),
    [sym_while_statement] = STATE(70),
    [sym_try_statement] = STATE(70),
    [sym_with_statement] = STATE(70),
    [sym_function_definition] = STATE(70),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(70),
    [sym_decorated_definition] = STATE(70),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(2552),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(70),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [24] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(778),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [25] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(785),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [26] = {
    [sym__statement] = STATE(70),
    [sym__simple_statements] = STATE(70),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(70),
    [sym_match_statement] = STATE(70),
    [sym_for_statement] = STATE(70),
    [sym_while_statement] = STATE(70),
    [sym_try_statement] = STATE(70),
    [sym_with_statement] = STATE(70),
    [sym_function_definition] = STATE(70),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(70),
    [sym_decorated_definition] = STATE(70),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(2528),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(70),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [27] = {
    [sym__statement] = STATE(70),
    [sym__simple_statements] = STATE(70),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(70),
    [sym_match_statement] = STATE(70),
    [sym_for_statement] = STATE(70),
    [sym_while_statement] = STATE(70),
    [sym_try_statement] = STATE(70),
    [sym_with_statement] = STATE(70),
    [sym_function_definition] = STATE(70),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(70),
    [sym_decorated_definition] = STATE(70),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(2532),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(70),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [28] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(788),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [29] = {
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(678),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(105),
    [sym_string_start] = ACTIONS(81),
  },
  [30] = {
    [sym__statement] = STATE(66),
    [sym__simple_statements] = STATE(66),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(66),
    [sym_match_statement] = STATE(66),
    [sym_for_statement] = STATE(66),
    [sym_while_statement] = STATE(66),
    [sym_try_statement] = STATE(66),
    [sym_with_statement] = STATE(66),
    [sym_function_definition] = STATE(66),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(66),
    [sym_decorated_definition] = STATE(66),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(1821),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(66),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(111),
    [sym_string_start] = ACTIONS(81),
  },
  [31] = {
    [sym__statement] = STATE(70),
    [sym__simple_statements] = STATE(70),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(70),
    [sym_match_statement] = STATE(70),
    [sym_for_statement] = STATE(70),
    [sym_while_statement] = STATE(70),
    [sym_try_statement] = STATE(70),
    [sym_with_statement] = STATE(70),
    [sym_function_definition] = STATE(70),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(70),
    [sym_decorated_definition] = STATE(70),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(2573),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(70),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [32] = {
    [sym__statement] = STATE(70),
    [sym__simple_statements] = STATE(70),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(70),
    [sym_match_statement] = STATE(70),
    [sym_for_statement] = STATE(70),
    [sym_while_statement] = STATE(70),
    [sym_try_statement] = STATE(70),
    [sym_with_statement] = STATE(70),
    [sym_function_definition] = STATE(70),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(70),
    [sym_decorated_definition] = STATE(70),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(2574),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(70),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [33] = {
    [sym__statement] = STATE(70),
    [sym__simple_statements] = STATE(70),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(70),
    [sym_match_statement] = STATE(70),
    [sym_for_statement] = STATE(70),
    [sym_while_statement] = STATE(70),
    [sym_try_statement] = STATE(70),
    [sym_with_statement] = STATE(70),
    [sym_function_definition] = STATE(70),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(70),
    [sym_decorated_definition] = STATE(70),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(2582),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(70),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [34] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(620),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [35] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(714),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [36] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(780),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [37] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(793),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [38] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(803),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [39] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(762),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [40] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(766),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [41] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(775),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [42] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(745),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [43] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(708),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [44] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(698),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(113),
    [sym_string_start] = ACTIONS(81),
  },
  [45] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(758),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [46] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(761),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [47] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(764),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [48] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(623),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [49] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(718),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [50] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(789),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [51] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(687),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(113),
    [sym_string_start] = ACTIONS(81),
  },
  [52] = {
    [sym__statement] = STATE(72),
    [sym__simple_statements] = STATE(72),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(72),
    [sym_match_statement] = STATE(72),
    [sym_for_statement] = STATE(72),
    [sym_while_statement] = STATE(72),
    [sym_try_statement] = STATE(72),
    [sym_with_statement] = STATE(72),
    [sym_function_definition] = STATE(72),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(72),
    [sym_decorated_definition] = STATE(72),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(660),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(72),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(115),
    [sym_string_start] = ACTIONS(81),
  },
  [53] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(797),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [54] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(702),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [55] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(806),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [56] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(834),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [57] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(835),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [58] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(675),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(113),
    [sym_string_start] = ACTIONS(81),
  },
  [59] = {
    [sym__statement] = STATE(72),
    [sym__simple_statements] = STATE(72),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(72),
    [sym_match_statement] = STATE(72),
    [sym_for_statement] = STATE(72),
    [sym_while_statement] = STATE(72),
    [sym_try_statement] = STATE(72),
    [sym_with_statement] = STATE(72),
    [sym_function_definition] = STATE(72),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(72),
    [sym_decorated_definition] = STATE(72),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(681),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(72),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(115),
    [sym_string_start] = ACTIONS(81),
  },
  [60] = {
    [sym__statement] = STATE(66),
    [sym__simple_statements] = STATE(66),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(66),
    [sym_match_statement] = STATE(66),
    [sym_for_statement] = STATE(66),
    [sym_while_statement] = STATE(66),
    [sym_try_statement] = STATE(66),
    [sym_with_statement] = STATE(66),
    [sym_function_definition] = STATE(66),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(66),
    [sym_decorated_definition] = STATE(66),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(1823),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(66),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(111),
    [sym_string_start] = ACTIONS(81),
  },
  [61] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1836),
    [sym_block] = STATE(679),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [62] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1836),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(117),
    [sym_string_start] = ACTIONS(81),
  },
  [63] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1836),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(119),
    [anon_sym_import] = ACTIONS(122),
    [anon_sym_from] = ACTIONS(125),
    [anon_sym_LPAREN] = ACTIONS(128),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_print] = ACTIONS(134),
    [anon_sym_assert] = ACTIONS(137),
    [anon_sym_return] = ACTIONS(140),
    [anon_sym_del] = ACTIONS(143),
    [anon_sym_raise] = ACTIONS(146),
    [anon_sym_pass] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(152),
    [anon_sym_continue] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(158),
    [anon_sym_match] = ACTIONS(161),
    [anon_sym_async] = ACTIONS(164),
    [anon_sym_for] = ACTIONS(167),
    [anon_sym_while] = ACTIONS(170),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(176),
    [anon_sym_def] = ACTIONS(179),
    [anon_sym_global] = ACTIONS(182),
    [anon_sym_nonlocal] = ACTIONS(185),
    [anon_sym_exec] = ACTIONS(188),
    [anon_sym_type] = ACTIONS(191),
    [anon_sym_class] = ACTIONS(194),
    [anon_sym_LBRACK] = ACTIONS(197),
    [anon_sym_AT] = ACTIONS(200),
    [anon_sym_DASH] = ACTIONS(203),
    [anon_sym_LBRACE] = ACTIONS(206),
    [anon_sym_PLUS] = ACTIONS(203),
    [anon_sym_not] = ACTIONS(209),
    [anon_sym_TILDE] = ACTIONS(203),
    [anon_sym_lambda] = ACTIONS(212),
    [anon_sym_yield] = ACTIONS(215),
    [sym_ellipsis] = ACTIONS(218),
    [sym_integer] = ACTIONS(221),
    [sym_float] = ACTIONS(218),
    [anon_sym_await] = ACTIONS(224),
    [sym_true] = ACTIONS(221),
    [sym_false] = ACTIONS(221),
    [sym_none] = ACTIONS(221),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(227),
    [sym_string_start] = ACTIONS(229),
  },
  [64] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2305),
    [sym_future_import_statement] = STATE(2305),
    [sym_import_from_statement] = STATE(2305),
    [sym_print_statement] = STATE(2305),
    [sym_assert_statement] = STATE(2305),
    [sym_expression_statement] = STATE(2305),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2305),
    [sym_delete_statement] = STATE(2305),
    [sym_raise_statement] = STATE(2305),
    [sym_pass_statement] = STATE(2305),
    [sym_break_statement] = STATE(2305),
    [sym_continue_statement] = STATE(2305),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2305),
    [sym_nonlocal_statement] = STATE(2305),
    [sym_exec_statement] = STATE(2305),
    [sym_type_alias_statement] = STATE(2305),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1798),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1798),
    [ts_builtin_sym_end] = ACTIONS(232),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_match] = ACTIONS(37),
    [anon_sym_async] = ACTIONS(39),
    [anon_sym_for] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_def] = ACTIONS(49),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(81),
  },
  [65] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1836),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(234),
    [sym_string_start] = ACTIONS(81),
  },
  [66] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1836),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(236),
    [sym_string_start] = ACTIONS(81),
  },
  [67] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2305),
    [sym_future_import_statement] = STATE(2305),
    [sym_import_from_statement] = STATE(2305),
    [sym_print_statement] = STATE(2305),
    [sym_assert_statement] = STATE(2305),
    [sym_expression_statement] = STATE(2305),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2305),
    [sym_delete_statement] = STATE(2305),
    [sym_raise_statement] = STATE(2305),
    [sym_pass_statement] = STATE(2305),
    [sym_break_statement] = STATE(2305),
    [sym_continue_statement] = STATE(2305),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2305),
    [sym_nonlocal_statement] = STATE(2305),
    [sym_exec_statement] = STATE(2305),
    [sym_type_alias_statement] = STATE(2305),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1798),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1798),
    [ts_builtin_sym_end] = ACTIONS(227),
    [sym_identifier] = ACTIONS(119),
    [anon_sym_import] = ACTIONS(122),
    [anon_sym_from] = ACTIONS(125),
    [anon_sym_LPAREN] = ACTIONS(128),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_print] = ACTIONS(134),
    [anon_sym_assert] = ACTIONS(137),
    [anon_sym_return] = ACTIONS(140),
    [anon_sym_del] = ACTIONS(143),
    [anon_sym_raise] = ACTIONS(146),
    [anon_sym_pass] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(152),
    [anon_sym_continue] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(238),
    [anon_sym_match] = ACTIONS(241),
    [anon_sym_async] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_while] = ACTIONS(250),
    [anon_sym_try] = ACTIONS(253),
    [anon_sym_with] = ACTIONS(256),
    [anon_sym_def] = ACTIONS(259),
    [anon_sym_global] = ACTIONS(182),
    [anon_sym_nonlocal] = ACTIONS(185),
    [anon_sym_exec] = ACTIONS(188),
    [anon_sym_type] = ACTIONS(191),
    [anon_sym_class] = ACTIONS(262),
    [anon_sym_LBRACK] = ACTIONS(197),
    [anon_sym_AT] = ACTIONS(200),
    [anon_sym_DASH] = ACTIONS(203),
    [anon_sym_LBRACE] = ACTIONS(206),
    [anon_sym_PLUS] = ACTIONS(203),
    [anon_sym_not] = ACTIONS(209),
    [anon_sym_TILDE] = ACTIONS(203),
    [anon_sym_lambda] = ACTIONS(212),
    [anon_sym_yield] = ACTIONS(215),
    [sym_ellipsis] = ACTIONS(218),
    [sym_integer] = ACTIONS(221),
    [sym_float] = ACTIONS(218),
    [anon_sym_await] = ACTIONS(224),
    [sym_true] = ACTIONS(221),
    [sym_false] = ACTIONS(221),
    [sym_none] = ACTIONS(221),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(229),
  },
  [68] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1836),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(265),
    [sym_string_start] = ACTIONS(81),
  },
  [69] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1836),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(267),
    [sym_string_start] = ACTIONS(81),
  },
  [70] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1836),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(269),
    [sym_string_start] = ACTIONS(81),
  },
  [71] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1836),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(271),
    [sym_string_start] = ACTIONS(81),
  },
  [72] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1836),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1836),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(273),
    [sym_string_start] = ACTIONS(81),
  },
  [73] = {
    [sym_named_expression] = STATE(1738),
    [sym__named_expression_lhs] = STATE(2678),
    [sym_type_parameter] = STATE(2062),
    [sym_list_splat_pattern] = STATE(1325),
    [sym_as_pattern] = STATE(1738),
    [sym_expression] = STATE(1781),
    [sym_primary_expression] = STATE(971),
    [sym_not_operator] = STATE(1738),
    [sym_boolean_operator] = STATE(1738),
    [sym_binary_operator] = STATE(1311),
    [sym_unary_operator] = STATE(1311),
    [sym_comparison_operator] = STATE(1738),
    [sym_lambda] = STATE(1738),
    [sym_attribute] = STATE(1311),
    [sym_subscript] = STATE(1311),
    [sym_call] = STATE(1311),
    [sym_type] = STATE(2248),
    [sym_splat_type] = STATE(2098),
    [sym_generic_type] = STATE(2098),
    [sym_union_type] = STATE(2098),
    [sym_constrained_type] = STATE(2098),
    [sym_member_type] = STATE(2098),
    [sym_list] = STATE(1311),
    [sym_set] = STATE(1311),
    [sym_tuple] = STATE(1311),
    [sym_dictionary] = STATE(1311),
    [sym_list_comprehension] = STATE(1311),
    [sym_dictionary_comprehension] = STATE(1311),
    [sym_set_comprehension] = STATE(1311),
    [sym_generator_expression] = STATE(1311),
    [sym_parenthesized_expression] = STATE(1311),
    [sym_conditional_expression] = STATE(1738),
    [sym_concatenated_string] = STATE(1311),
    [sym_string] = STATE(1025),
    [sym_await] = STATE(1311),
    [sym_identifier] = ACTIONS(275),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(281),
    [anon_sym_COMMA] = ACTIONS(284),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(287),
    [anon_sym_print] = ACTIONS(290),
    [anon_sym_GT_GT] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(294),
    [anon_sym_match] = ACTIONS(297),
    [anon_sym_async] = ACTIONS(290),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_exec] = ACTIONS(290),
    [anon_sym_type] = ACTIONS(302),
    [anon_sym_EQ] = ACTIONS(304),
    [anon_sym_LBRACK] = ACTIONS(306),
    [anon_sym_AT] = ACTIONS(279),
    [anon_sym_DASH] = ACTIONS(308),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_PLUS] = ACTIONS(308),
    [anon_sym_not] = ACTIONS(313),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(279),
    [anon_sym_SLASH_SLASH] = ACTIONS(279),
    [anon_sym_AMP] = ACTIONS(279),
    [anon_sym_CARET] = ACTIONS(279),
    [anon_sym_LT_LT] = ACTIONS(279),
    [anon_sym_TILDE] = ACTIONS(316),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [anon_sym_lambda] = ACTIONS(318),
    [anon_sym_PLUS_EQ] = ACTIONS(320),
    [anon_sym_DASH_EQ] = ACTIONS(320),
    [anon_sym_STAR_EQ] = ACTIONS(320),
    [anon_sym_SLASH_EQ] = ACTIONS(320),
    [anon_sym_AT_EQ] = ACTIONS(320),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(320),
    [anon_sym_PERCENT_EQ] = ACTIONS(320),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(320),
    [anon_sym_GT_GT_EQ] = ACTIONS(320),
    [anon_sym_LT_LT_EQ] = ACTIONS(320),
    [anon_sym_AMP_EQ] = ACTIONS(320),
    [anon_sym_CARET_EQ] = ACTIONS(320),
    [anon_sym_PIPE_EQ] = ACTIONS(320),
    [sym_ellipsis] = ACTIONS(322),
    [sym_integer] = ACTIONS(324),
    [sym_float] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(326),
    [sym_true] = ACTIONS(324),
    [sym_false] = ACTIONS(324),
    [sym_none] = ACTIONS(324),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym_string_start] = ACTIONS(328),
  },
  [74] = {
    [sym_named_expression] = STATE(1738),
    [sym__named_expression_lhs] = STATE(2678),
    [sym_list_splat_pattern] = STATE(1325),
    [sym_as_pattern] = STATE(1738),
    [sym_expression] = STATE(1781),
    [sym_primary_expression] = STATE(971),
    [sym_not_operator] = STATE(1738),
    [sym_boolean_operator] = STATE(1738),
    [sym_binary_operator] = STATE(1311),
    [sym_unary_operator] = STATE(1311),
    [sym_comparison_operator] = STATE(1738),
    [sym_lambda] = STATE(1738),
    [sym_attribute] = STATE(1311),
    [sym_subscript] = STATE(1311),
    [sym_call] = STATE(1311),
    [sym_type] = STATE(2248),
    [sym_splat_type] = STATE(2098),
    [sym_generic_type] = STATE(2098),
    [sym_union_type] = STATE(2098),
    [sym_constrained_type] = STATE(2098),
    [sym_member_type] = STATE(2098),
    [sym_list] = STATE(1311),
    [sym_set] = STATE(1311),
    [sym_tuple] = STATE(1311),
    [sym_dictionary] = STATE(1311),
    [sym_list_comprehension] = STATE(1311),
    [sym_dictionary_comprehension] = STATE(1311),
    [sym_set_comprehension] = STATE(1311),
    [sym_generator_expression] = STATE(1311),
    [sym_parenthesized_expression] = STATE(1311),
    [sym_conditional_expression] = STATE(1738),
    [sym_concatenated_string] = STATE(1311),
    [sym_string] = STATE(1025),
    [sym_await] = STATE(1311),
    [sym_identifier] = ACTIONS(275),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(281),
    [anon_sym_COMMA] = ACTIONS(284),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(287),
    [anon_sym_print] = ACTIONS(290),
    [anon_sym_GT_GT] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(304),
    [anon_sym_match] = ACTIONS(297),
    [anon_sym_async] = ACTIONS(290),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_exec] = ACTIONS(290),
    [anon_sym_type] = ACTIONS(302),
    [anon_sym_EQ] = ACTIONS(304),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_AT] = ACTIONS(279),
    [anon_sym_DASH] = ACTIONS(308),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_PLUS] = ACTIONS(308),
    [anon_sym_not] = ACTIONS(313),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(279),
    [anon_sym_SLASH_SLASH] = ACTIONS(279),
    [anon_sym_AMP] = ACTIONS(279),
    [anon_sym_CARET] = ACTIONS(279),
    [anon_sym_LT_LT] = ACTIONS(279),
    [anon_sym_TILDE] = ACTIONS(316),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [anon_sym_lambda] = ACTIONS(318),
    [anon_sym_PLUS_EQ] = ACTIONS(320),
    [anon_sym_DASH_EQ] = ACTIONS(320),
    [anon_sym_STAR_EQ] = ACTIONS(320),
    [anon_sym_SLASH_EQ] = ACTIONS(320),
    [anon_sym_AT_EQ] = ACTIONS(320),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(320),
    [anon_sym_PERCENT_EQ] = ACTIONS(320),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(320),
    [anon_sym_GT_GT_EQ] = ACTIONS(320),
    [anon_sym_LT_LT_EQ] = ACTIONS(320),
    [anon_sym_AMP_EQ] = ACTIONS(320),
    [anon_sym_CARET_EQ] = ACTIONS(320),
    [anon_sym_PIPE_EQ] = ACTIONS(320),
    [sym_ellipsis] = ACTIONS(322),
    [sym_integer] = ACTIONS(324),
    [sym_float] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(326),
    [sym_true] = ACTIONS(324),
    [sym_false] = ACTIONS(324),
    [sym_none] = ACTIONS(324),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym_string_start] = ACTIONS(328),
  },
  [75] = {
    [sym__simple_statements] = STATE(749),
    [sym_import_statement] = STATE(2305),
    [sym_future_import_statement] = STATE(2305),
    [sym_import_from_statement] = STATE(2305),
    [sym_print_statement] = STATE(2305),
    [sym_assert_statement] = STATE(2305),
    [sym_expression_statement] = STATE(2305),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2305),
    [sym_delete_statement] = STATE(2305),
    [sym_raise_statement] = STATE(2305),
    [sym_pass_statement] = STATE(2305),
    [sym_break_statement] = STATE(2305),
    [sym_continue_statement] = STATE(2305),
    [sym_global_statement] = STATE(2305),
    [sym_nonlocal_statement] = STATE(2305),
    [sym_exec_statement] = STATE(2305),
    [sym_type_alias_statement] = STATE(2305),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(640),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1689),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1081),
    [sym_type] = STATE(2109),
    [sym_splat_type] = STATE(2098),
    [sym_generic_type] = STATE(2098),
    [sym_union_type] = STATE(2098),
    [sym_constrained_type] = STATE(2098),
    [sym_member_type] = STATE(2098),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(333),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(335),
    [anon_sym_STAR] = ACTIONS(337),
    [anon_sym_print] = ACTIONS(339),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(341),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_STAR_STAR] = ACTIONS(345),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(347),
    [anon_sym_type] = ACTIONS(349),
    [anon_sym_LBRACK] = ACTIONS(351),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(353),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(355),
    [sym__indent] = ACTIONS(357),
    [sym_string_start] = ACTIONS(81),
  },
  [76] = {
    [sym__simple_statements] = STATE(767),
    [sym_import_statement] = STATE(2305),
    [sym_future_import_statement] = STATE(2305),
    [sym_import_from_statement] = STATE(2305),
    [sym_print_statement] = STATE(2305),
    [sym_assert_statement] = STATE(2305),
    [sym_expression_statement] = STATE(2305),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2305),
    [sym_delete_statement] = STATE(2305),
    [sym_raise_statement] = STATE(2305),
    [sym_pass_statement] = STATE(2305),
    [sym_break_statement] = STATE(2305),
    [sym_continue_statement] = STATE(2305),
    [sym_global_statement] = STATE(2305),
    [sym_nonlocal_statement] = STATE(2305),
    [sym_exec_statement] = STATE(2305),
    [sym_type_alias_statement] = STATE(2305),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(640),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1689),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1081),
    [sym_type] = STATE(2109),
    [sym_splat_type] = STATE(2098),
    [sym_generic_type] = STATE(2098),
    [sym_union_type] = STATE(2098),
    [sym_constrained_type] = STATE(2098),
    [sym_member_type] = STATE(2098),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(333),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(335),
    [anon_sym_STAR] = ACTIONS(337),
    [anon_sym_print] = ACTIONS(339),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(341),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_STAR_STAR] = ACTIONS(345),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(347),
    [anon_sym_type] = ACTIONS(349),
    [anon_sym_LBRACK] = ACTIONS(351),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(353),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(359),
    [sym__indent] = ACTIONS(361),
    [sym_string_start] = ACTIONS(81),
  },
  [77] = {
    [sym__simple_statements] = STATE(760),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(640),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1689),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1081),
    [sym_type] = STATE(2109),
    [sym_splat_type] = STATE(2098),
    [sym_generic_type] = STATE(2098),
    [sym_union_type] = STATE(2098),
    [sym_constrained_type] = STATE(2098),
    [sym_member_type] = STATE(2098),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(333),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(335),
    [anon_sym_STAR] = ACTIONS(337),
    [anon_sym_print] = ACTIONS(339),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(341),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_STAR_STAR] = ACTIONS(345),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(347),
    [anon_sym_type] = ACTIONS(349),
    [anon_sym_LBRACK] = ACTIONS(351),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(353),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(363),
    [sym__indent] = ACTIONS(365),
    [sym_string_start] = ACTIONS(81),
  },
  [78] = {
    [sym__simple_statements] = STATE(798),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(640),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1689),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1081),
    [sym_type] = STATE(2109),
    [sym_splat_type] = STATE(2098),
    [sym_generic_type] = STATE(2098),
    [sym_union_type] = STATE(2098),
    [sym_constrained_type] = STATE(2098),
    [sym_member_type] = STATE(2098),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(333),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(335),
    [anon_sym_STAR] = ACTIONS(337),
    [anon_sym_print] = ACTIONS(339),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(341),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_STAR_STAR] = ACTIONS(345),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(347),
    [anon_sym_type] = ACTIONS(349),
    [anon_sym_LBRACK] = ACTIONS(351),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(353),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(367),
    [sym__indent] = ACTIONS(369),
    [sym_string_start] = ACTIONS(81),
  },
  [79] = {
    [sym__simple_statements] = STATE(773),
    [sym_import_statement] = STATE(2305),
    [sym_future_import_statement] = STATE(2305),
    [sym_import_from_statement] = STATE(2305),
    [sym_print_statement] = STATE(2305),
    [sym_assert_statement] = STATE(2305),
    [sym_expression_statement] = STATE(2305),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2305),
    [sym_delete_statement] = STATE(2305),
    [sym_raise_statement] = STATE(2305),
    [sym_pass_statement] = STATE(2305),
    [sym_break_statement] = STATE(2305),
    [sym_continue_statement] = STATE(2305),
    [sym_global_statement] = STATE(2305),
    [sym_nonlocal_statement] = STATE(2305),
    [sym_exec_statement] = STATE(2305),
    [sym_type_alias_statement] = STATE(2305),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(640),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1689),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1081),
    [sym_type] = STATE(2109),
    [sym_splat_type] = STATE(2098),
    [sym_generic_type] = STATE(2098),
    [sym_union_type] = STATE(2098),
    [sym_constrained_type] = STATE(2098),
    [sym_member_type] = STATE(2098),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(333),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(335),
    [anon_sym_STAR] = ACTIONS(337),
    [anon_sym_print] = ACTIONS(339),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(341),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_STAR_STAR] = ACTIONS(345),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(347),
    [anon_sym_type] = ACTIONS(349),
    [anon_sym_LBRACK] = ACTIONS(351),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(353),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(371),
    [sym__indent] = ACTIONS(373),
    [sym_string_start] = ACTIONS(81),
  },
  [80] = {
    [sym__simple_statements] = STATE(779),
    [sym_import_statement] = STATE(2305),
    [sym_future_import_statement] = STATE(2305),
    [sym_import_from_statement] = STATE(2305),
    [sym_print_statement] = STATE(2305),
    [sym_assert_statement] = STATE(2305),
    [sym_expression_statement] = STATE(2305),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2305),
    [sym_delete_statement] = STATE(2305),
    [sym_raise_statement] = STATE(2305),
    [sym_pass_statement] = STATE(2305),
    [sym_break_statement] = STATE(2305),
    [sym_continue_statement] = STATE(2305),
    [sym_global_statement] = STATE(2305),
    [sym_nonlocal_statement] = STATE(2305),
    [sym_exec_statement] = STATE(2305),
    [sym_type_alias_statement] = STATE(2305),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(640),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1689),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1081),
    [sym_type] = STATE(2109),
    [sym_splat_type] = STATE(2098),
    [sym_generic_type] = STATE(2098),
    [sym_union_type] = STATE(2098),
    [sym_constrained_type] = STATE(2098),
    [sym_member_type] = STATE(2098),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(333),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(335),
    [anon_sym_STAR] = ACTIONS(337),
    [anon_sym_print] = ACTIONS(339),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(341),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_STAR_STAR] = ACTIONS(345),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(347),
    [anon_sym_type] = ACTIONS(349),
    [anon_sym_LBRACK] = ACTIONS(351),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(353),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(375),
    [sym__indent] = ACTIONS(377),
    [sym_string_start] = ACTIONS(81),
  },
  [81] = {
    [sym__simple_statements] = STATE(830),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(640),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1689),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1081),
    [sym_type] = STATE(2109),
    [sym_splat_type] = STATE(2098),
    [sym_generic_type] = STATE(2098),
    [sym_union_type] = STATE(2098),
    [sym_constrained_type] = STATE(2098),
    [sym_member_type] = STATE(2098),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(333),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(335),
    [anon_sym_STAR] = ACTIONS(337),
    [anon_sym_print] = ACTIONS(339),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(341),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_STAR_STAR] = ACTIONS(345),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(347),
    [anon_sym_type] = ACTIONS(349),
    [anon_sym_LBRACK] = ACTIONS(351),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(353),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(379),
    [sym__indent] = ACTIONS(381),
    [sym_string_start] = ACTIONS(81),
  },
  [82] = {
    [sym__simple_statements] = STATE(786),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(640),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1689),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1081),
    [sym_type] = STATE(2109),
    [sym_splat_type] = STATE(2098),
    [sym_generic_type] = STATE(2098),
    [sym_union_type] = STATE(2098),
    [sym_constrained_type] = STATE(2098),
    [sym_member_type] = STATE(2098),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(333),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(335),
    [anon_sym_STAR] = ACTIONS(337),
    [anon_sym_print] = ACTIONS(339),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(341),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_STAR_STAR] = ACTIONS(345),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(347),
    [anon_sym_type] = ACTIONS(349),
    [anon_sym_LBRACK] = ACTIONS(351),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(353),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__indent] = ACTIONS(385),
    [sym_string_start] = ACTIONS(81),
  },
  [83] = {
    [sym_chevron] = STATE(2156),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_list_splat_pattern] = STATE(1135),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1805),
    [sym_primary_expression] = STATE(870),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_attribute] = STATE(1081),
    [sym_subscript] = STATE(1081),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(387),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(389),
    [anon_sym_COMMA] = ACTIONS(284),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(392),
    [anon_sym_print] = ACTIONS(395),
    [anon_sym_GT_GT] = ACTIONS(397),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(294),
    [anon_sym_match] = ACTIONS(399),
    [anon_sym_async] = ACTIONS(395),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(279),
    [anon_sym_exec] = ACTIONS(395),
    [anon_sym_type] = ACTIONS(399),
    [anon_sym_EQ] = ACTIONS(304),
    [anon_sym_LBRACK] = ACTIONS(401),
    [anon_sym_AT] = ACTIONS(279),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(404),
    [anon_sym_not] = ACTIONS(407),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(279),
    [anon_sym_SLASH_SLASH] = ACTIONS(279),
    [anon_sym_AMP] = ACTIONS(279),
    [anon_sym_CARET] = ACTIONS(279),
    [anon_sym_LT_LT] = ACTIONS(279),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_PLUS_EQ] = ACTIONS(320),
    [anon_sym_DASH_EQ] = ACTIONS(320),
    [anon_sym_STAR_EQ] = ACTIONS(320),
    [anon_sym_SLASH_EQ] = ACTIONS(320),
    [anon_sym_AT_EQ] = ACTIONS(320),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(320),
    [anon_sym_PERCENT_EQ] = ACTIONS(320),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(320),
    [anon_sym_GT_GT_EQ] = ACTIONS(320),
    [anon_sym_LT_LT_EQ] = ACTIONS(320),
    [anon_sym_AMP_EQ] = ACTIONS(320),
    [anon_sym_CARET_EQ] = ACTIONS(320),
    [anon_sym_PIPE_EQ] = ACTIONS(320),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(410),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym_string_start] = ACTIONS(81),
  },
  [84] = {
    [sym_chevron] = STATE(2156),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_list_splat_pattern] = STATE(1135),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1805),
    [sym_primary_expression] = STATE(870),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_attribute] = STATE(1081),
    [sym_subscript] = STATE(1081),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(387),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(389),
    [anon_sym_COMMA] = ACTIONS(284),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(392),
    [anon_sym_print] = ACTIONS(395),
    [anon_sym_GT_GT] = ACTIONS(397),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(304),
    [anon_sym_match] = ACTIONS(399),
    [anon_sym_async] = ACTIONS(395),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(279),
    [anon_sym_exec] = ACTIONS(395),
    [anon_sym_type] = ACTIONS(399),
    [anon_sym_EQ] = ACTIONS(304),
    [anon_sym_LBRACK] = ACTIONS(401),
    [anon_sym_AT] = ACTIONS(279),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(404),
    [anon_sym_not] = ACTIONS(407),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(279),
    [anon_sym_SLASH_SLASH] = ACTIONS(279),
    [anon_sym_AMP] = ACTIONS(279),
    [anon_sym_CARET] = ACTIONS(279),
    [anon_sym_LT_LT] = ACTIONS(279),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_PLUS_EQ] = ACTIONS(320),
    [anon_sym_DASH_EQ] = ACTIONS(320),
    [anon_sym_STAR_EQ] = ACTIONS(320),
    [anon_sym_SLASH_EQ] = ACTIONS(320),
    [anon_sym_AT_EQ] = ACTIONS(320),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(320),
    [anon_sym_PERCENT_EQ] = ACTIONS(320),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(320),
    [anon_sym_GT_GT_EQ] = ACTIONS(320),
    [anon_sym_LT_LT_EQ] = ACTIONS(320),
    [anon_sym_AMP_EQ] = ACTIONS(320),
    [anon_sym_CARET_EQ] = ACTIONS(320),
    [anon_sym_PIPE_EQ] = ACTIONS(320),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(410),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym_string_start] = ACTIONS(81),
  },
  [85] = {
    [sym_named_expression] = STATE(1738),
    [sym__named_expression_lhs] = STATE(2678),
    [sym_list_splat_pattern] = STATE(1325),
    [sym_as_pattern] = STATE(1738),
    [sym_expression] = STATE(1888),
    [sym_primary_expression] = STATE(971),
    [sym_not_operator] = STATE(1738),
    [sym_boolean_operator] = STATE(1738),
    [sym_binary_operator] = STATE(1311),
    [sym_unary_operator] = STATE(1311),
    [sym_comparison_operator] = STATE(1738),
    [sym_lambda] = STATE(1738),
    [sym_attribute] = STATE(1311),
    [sym_subscript] = STATE(1311),
    [sym_call] = STATE(1311),
    [sym_list] = STATE(1311),
    [sym_set] = STATE(1311),
    [sym_tuple] = STATE(1311),
    [sym_dictionary] = STATE(1311),
    [sym_list_comprehension] = STATE(1311),
    [sym_dictionary_comprehension] = STATE(1311),
    [sym_set_comprehension] = STATE(1311),
    [sym_generator_expression] = STATE(1311),
    [sym_parenthesized_expression] = STATE(1311),
    [sym_conditional_expression] = STATE(1738),
    [sym_concatenated_string] = STATE(1311),
    [sym_string] = STATE(1025),
    [sym_await] = STATE(1311),
    [sym_identifier] = ACTIONS(412),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(281),
    [anon_sym_COMMA] = ACTIONS(284),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(414),
    [anon_sym_print] = ACTIONS(290),
    [anon_sym_GT_GT] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(304),
    [anon_sym_match] = ACTIONS(297),
    [anon_sym_async] = ACTIONS(290),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(279),
    [anon_sym_exec] = ACTIONS(290),
    [anon_sym_type] = ACTIONS(297),
    [anon_sym_EQ] = ACTIONS(304),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_AT] = ACTIONS(279),
    [anon_sym_DASH] = ACTIONS(308),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_PLUS] = ACTIONS(308),
    [anon_sym_not] = ACTIONS(313),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(279),
    [anon_sym_SLASH_SLASH] = ACTIONS(279),
    [anon_sym_AMP] = ACTIONS(279),
    [anon_sym_CARET] = ACTIONS(279),
    [anon_sym_LT_LT] = ACTIONS(279),
    [anon_sym_TILDE] = ACTIONS(316),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [anon_sym_lambda] = ACTIONS(318),
    [anon_sym_PLUS_EQ] = ACTIONS(320),
    [anon_sym_DASH_EQ] = ACTIONS(320),
    [anon_sym_STAR_EQ] = ACTIONS(320),
    [anon_sym_SLASH_EQ] = ACTIONS(320),
    [anon_sym_AT_EQ] = ACTIONS(320),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(320),
    [anon_sym_PERCENT_EQ] = ACTIONS(320),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(320),
    [anon_sym_GT_GT_EQ] = ACTIONS(320),
    [anon_sym_LT_LT_EQ] = ACTIONS(320),
    [anon_sym_AMP_EQ] = ACTIONS(320),
    [anon_sym_CARET_EQ] = ACTIONS(320),
    [anon_sym_PIPE_EQ] = ACTIONS(320),
    [sym_ellipsis] = ACTIONS(322),
    [sym_integer] = ACTIONS(324),
    [sym_float] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(326),
    [sym_true] = ACTIONS(324),
    [sym_false] = ACTIONS(324),
    [sym_none] = ACTIONS(324),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym_string_start] = ACTIONS(328),
  },
  [86] = {
    [sym_named_expression] = STATE(1738),
    [sym__named_expression_lhs] = STATE(2678),
    [sym_list_splat_pattern] = STATE(1325),
    [sym_as_pattern] = STATE(1738),
    [sym_expression] = STATE(1849),
    [sym_primary_expression] = STATE(971),
    [sym_not_operator] = STATE(1738),
    [sym_boolean_operator] = STATE(1738),
    [sym_binary_operator] = STATE(1311),
    [sym_unary_operator] = STATE(1311),
    [sym_comparison_operator] = STATE(1738),
    [sym_lambda] = STATE(1738),
    [sym_attribute] = STATE(1311),
    [sym_subscript] = STATE(1311),
    [sym_call] = STATE(1311),
    [sym_list] = STATE(1311),
    [sym_set] = STATE(1311),
    [sym_tuple] = STATE(1311),
    [sym_dictionary] = STATE(1311),
    [sym_list_comprehension] = STATE(1311),
    [sym_dictionary_comprehension] = STATE(1311),
    [sym_set_comprehension] = STATE(1311),
    [sym_generator_expression] = STATE(1311),
    [sym_parenthesized_expression] = STATE(1311),
    [sym_conditional_expression] = STATE(1738),
    [sym_concatenated_string] = STATE(1311),
    [sym_string] = STATE(1025),
    [sym_await] = STATE(1311),
    [sym_identifier] = ACTIONS(412),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(281),
    [anon_sym_COMMA] = ACTIONS(284),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(414),
    [anon_sym_print] = ACTIONS(290),
    [anon_sym_GT_GT] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(304),
    [anon_sym_match] = ACTIONS(297),
    [anon_sym_async] = ACTIONS(290),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(279),
    [anon_sym_exec] = ACTIONS(290),
    [anon_sym_type] = ACTIONS(297),
    [anon_sym_EQ] = ACTIONS(304),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_AT] = ACTIONS(279),
    [anon_sym_DASH] = ACTIONS(308),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_PLUS] = ACTIONS(308),
    [anon_sym_not] = ACTIONS(313),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(279),
    [anon_sym_SLASH_SLASH] = ACTIONS(279),
    [anon_sym_AMP] = ACTIONS(279),
    [anon_sym_CARET] = ACTIONS(279),
    [anon_sym_LT_LT] = ACTIONS(279),
    [anon_sym_TILDE] = ACTIONS(316),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [anon_sym_lambda] = ACTIONS(318),
    [anon_sym_PLUS_EQ] = ACTIONS(320),
    [anon_sym_DASH_EQ] = ACTIONS(320),
    [anon_sym_STAR_EQ] = ACTIONS(320),
    [anon_sym_SLASH_EQ] = ACTIONS(320),
    [anon_sym_AT_EQ] = ACTIONS(320),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(320),
    [anon_sym_PERCENT_EQ] = ACTIONS(320),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(320),
    [anon_sym_GT_GT_EQ] = ACTIONS(320),
    [anon_sym_LT_LT_EQ] = ACTIONS(320),
    [anon_sym_AMP_EQ] = ACTIONS(320),
    [anon_sym_CARET_EQ] = ACTIONS(320),
    [anon_sym_PIPE_EQ] = ACTIONS(320),
    [sym_ellipsis] = ACTIONS(322),
    [sym_integer] = ACTIONS(324),
    [sym_float] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(326),
    [sym_true] = ACTIONS(324),
    [sym_false] = ACTIONS(324),
    [sym_none] = ACTIONS(324),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym_string_start] = ACTIONS(328),
  },
  [87] = {
    [sym__simple_statements] = STATE(823),
    [sym_import_statement] = STATE(2305),
    [sym_future_import_statement] = STATE(2305),
    [sym_import_from_statement] = STATE(2305),
    [sym_print_statement] = STATE(2305),
    [sym_assert_statement] = STATE(2305),
    [sym_expression_statement] = STATE(2305),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2305),
    [sym_delete_statement] = STATE(2305),
    [sym_raise_statement] = STATE(2305),
    [sym_pass_statement] = STATE(2305),
    [sym_break_statement] = STATE(2305),
    [sym_continue_statement] = STATE(2305),
    [sym_global_statement] = STATE(2305),
    [sym_nonlocal_statement] = STATE(2305),
    [sym_exec_statement] = STATE(2305),
    [sym_type_alias_statement] = STATE(2305),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(421),
    [sym__indent] = ACTIONS(423),
    [sym_string_start] = ACTIONS(81),
  },
  [88] = {
    [sym__simple_statements] = STATE(832),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(425),
    [sym__indent] = ACTIONS(427),
    [sym_string_start] = ACTIONS(81),
  },
  [89] = {
    [sym__simple_statements] = STATE(703),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(429),
    [sym__indent] = ACTIONS(431),
    [sym_string_start] = ACTIONS(81),
  },
  [90] = {
    [sym__simple_statements] = STATE(684),
    [sym_import_statement] = STATE(2403),
    [sym_future_import_statement] = STATE(2403),
    [sym_import_from_statement] = STATE(2403),
    [sym_print_statement] = STATE(2403),
    [sym_assert_statement] = STATE(2403),
    [sym_expression_statement] = STATE(2403),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2403),
    [sym_delete_statement] = STATE(2403),
    [sym_raise_statement] = STATE(2403),
    [sym_pass_statement] = STATE(2403),
    [sym_break_statement] = STATE(2403),
    [sym_continue_statement] = STATE(2403),
    [sym_global_statement] = STATE(2403),
    [sym_nonlocal_statement] = STATE(2403),
    [sym_exec_statement] = STATE(2403),
    [sym_type_alias_statement] = STATE(2403),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(433),
    [sym__indent] = ACTIONS(435),
    [sym_string_start] = ACTIONS(81),
  },
  [91] = {
    [sym__simple_statements] = STATE(844),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(437),
    [sym__indent] = ACTIONS(439),
    [sym_string_start] = ACTIONS(81),
  },
  [92] = {
    [sym__simple_statements] = STATE(615),
    [sym_import_statement] = STATE(2305),
    [sym_future_import_statement] = STATE(2305),
    [sym_import_from_statement] = STATE(2305),
    [sym_print_statement] = STATE(2305),
    [sym_assert_statement] = STATE(2305),
    [sym_expression_statement] = STATE(2305),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2305),
    [sym_delete_statement] = STATE(2305),
    [sym_raise_statement] = STATE(2305),
    [sym_pass_statement] = STATE(2305),
    [sym_break_statement] = STATE(2305),
    [sym_continue_statement] = STATE(2305),
    [sym_global_statement] = STATE(2305),
    [sym_nonlocal_statement] = STATE(2305),
    [sym_exec_statement] = STATE(2305),
    [sym_type_alias_statement] = STATE(2305),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(441),
    [sym__indent] = ACTIONS(443),
    [sym_string_start] = ACTIONS(81),
  },
  [93] = {
    [sym__simple_statements] = STATE(763),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(445),
    [sym__indent] = ACTIONS(447),
    [sym_string_start] = ACTIONS(81),
  },
  [94] = {
    [sym__simple_statements] = STATE(809),
    [sym_import_statement] = STATE(2305),
    [sym_future_import_statement] = STATE(2305),
    [sym_import_from_statement] = STATE(2305),
    [sym_print_statement] = STATE(2305),
    [sym_assert_statement] = STATE(2305),
    [sym_expression_statement] = STATE(2305),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2305),
    [sym_delete_statement] = STATE(2305),
    [sym_raise_statement] = STATE(2305),
    [sym_pass_statement] = STATE(2305),
    [sym_break_statement] = STATE(2305),
    [sym_continue_statement] = STATE(2305),
    [sym_global_statement] = STATE(2305),
    [sym_nonlocal_statement] = STATE(2305),
    [sym_exec_statement] = STATE(2305),
    [sym_type_alias_statement] = STATE(2305),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(449),
    [sym__indent] = ACTIONS(451),
    [sym_string_start] = ACTIONS(81),
  },
  [95] = {
    [sym__simple_statements] = STATE(774),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(453),
    [sym__indent] = ACTIONS(455),
    [sym_string_start] = ACTIONS(81),
  },
  [96] = {
    [sym__simple_statements] = STATE(713),
    [sym_import_statement] = STATE(2305),
    [sym_future_import_statement] = STATE(2305),
    [sym_import_from_statement] = STATE(2305),
    [sym_print_statement] = STATE(2305),
    [sym_assert_statement] = STATE(2305),
    [sym_expression_statement] = STATE(2305),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2305),
    [sym_delete_statement] = STATE(2305),
    [sym_raise_statement] = STATE(2305),
    [sym_pass_statement] = STATE(2305),
    [sym_break_statement] = STATE(2305),
    [sym_continue_statement] = STATE(2305),
    [sym_global_statement] = STATE(2305),
    [sym_nonlocal_statement] = STATE(2305),
    [sym_exec_statement] = STATE(2305),
    [sym_type_alias_statement] = STATE(2305),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(457),
    [sym__indent] = ACTIONS(459),
    [sym_string_start] = ACTIONS(81),
  },
  [97] = {
    [sym__simple_statements] = STATE(725),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(461),
    [sym__indent] = ACTIONS(463),
    [sym_string_start] = ACTIONS(81),
  },
  [98] = {
    [sym__simple_statements] = STATE(709),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(465),
    [sym__indent] = ACTIONS(467),
    [sym_string_start] = ACTIONS(81),
  },
  [99] = {
    [sym__simple_statements] = STATE(721),
    [sym_import_statement] = STATE(2305),
    [sym_future_import_statement] = STATE(2305),
    [sym_import_from_statement] = STATE(2305),
    [sym_print_statement] = STATE(2305),
    [sym_assert_statement] = STATE(2305),
    [sym_expression_statement] = STATE(2305),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2305),
    [sym_delete_statement] = STATE(2305),
    [sym_raise_statement] = STATE(2305),
    [sym_pass_statement] = STATE(2305),
    [sym_break_statement] = STATE(2305),
    [sym_continue_statement] = STATE(2305),
    [sym_global_statement] = STATE(2305),
    [sym_nonlocal_statement] = STATE(2305),
    [sym_exec_statement] = STATE(2305),
    [sym_type_alias_statement] = STATE(2305),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(469),
    [sym__indent] = ACTIONS(471),
    [sym_string_start] = ACTIONS(81),
  },
  [100] = {
    [sym__simple_statements] = STATE(746),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(473),
    [sym__indent] = ACTIONS(475),
    [sym_string_start] = ACTIONS(81),
  },
  [101] = {
    [sym__simple_statements] = STATE(2540),
    [sym_import_statement] = STATE(2374),
    [sym_future_import_statement] = STATE(2374),
    [sym_import_from_statement] = STATE(2374),
    [sym_print_statement] = STATE(2374),
    [sym_assert_statement] = STATE(2374),
    [sym_expression_statement] = STATE(2374),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2374),
    [sym_delete_statement] = STATE(2374),
    [sym_raise_statement] = STATE(2374),
    [sym_pass_statement] = STATE(2374),
    [sym_break_statement] = STATE(2374),
    [sym_continue_statement] = STATE(2374),
    [sym_global_statement] = STATE(2374),
    [sym_nonlocal_statement] = STATE(2374),
    [sym_exec_statement] = STATE(2374),
    [sym_type_alias_statement] = STATE(2374),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(477),
    [sym__indent] = ACTIONS(479),
    [sym_string_start] = ACTIONS(81),
  },
  [102] = {
    [sym__simple_statements] = STATE(831),
    [sym_import_statement] = STATE(2305),
    [sym_future_import_statement] = STATE(2305),
    [sym_import_from_statement] = STATE(2305),
    [sym_print_statement] = STATE(2305),
    [sym_assert_statement] = STATE(2305),
    [sym_expression_statement] = STATE(2305),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2305),
    [sym_delete_statement] = STATE(2305),
    [sym_raise_statement] = STATE(2305),
    [sym_pass_statement] = STATE(2305),
    [sym_break_statement] = STATE(2305),
    [sym_continue_statement] = STATE(2305),
    [sym_global_statement] = STATE(2305),
    [sym_nonlocal_statement] = STATE(2305),
    [sym_exec_statement] = STATE(2305),
    [sym_type_alias_statement] = STATE(2305),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(481),
    [sym__indent] = ACTIONS(483),
    [sym_string_start] = ACTIONS(81),
  },
  [103] = {
    [sym__simple_statements] = STATE(699),
    [sym_import_statement] = STATE(2403),
    [sym_future_import_statement] = STATE(2403),
    [sym_import_from_statement] = STATE(2403),
    [sym_print_statement] = STATE(2403),
    [sym_assert_statement] = STATE(2403),
    [sym_expression_statement] = STATE(2403),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2403),
    [sym_delete_statement] = STATE(2403),
    [sym_raise_statement] = STATE(2403),
    [sym_pass_statement] = STATE(2403),
    [sym_break_statement] = STATE(2403),
    [sym_continue_statement] = STATE(2403),
    [sym_global_statement] = STATE(2403),
    [sym_nonlocal_statement] = STATE(2403),
    [sym_exec_statement] = STATE(2403),
    [sym_type_alias_statement] = STATE(2403),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(485),
    [sym__indent] = ACTIONS(487),
    [sym_string_start] = ACTIONS(81),
  },
  [104] = {
    [sym__simple_statements] = STATE(686),
    [sym_import_statement] = STATE(2429),
    [sym_future_import_statement] = STATE(2429),
    [sym_import_from_statement] = STATE(2429),
    [sym_print_statement] = STATE(2429),
    [sym_assert_statement] = STATE(2429),
    [sym_expression_statement] = STATE(2429),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2429),
    [sym_delete_statement] = STATE(2429),
    [sym_raise_statement] = STATE(2429),
    [sym_pass_statement] = STATE(2429),
    [sym_break_statement] = STATE(2429),
    [sym_continue_statement] = STATE(2429),
    [sym_global_statement] = STATE(2429),
    [sym_nonlocal_statement] = STATE(2429),
    [sym_exec_statement] = STATE(2429),
    [sym_type_alias_statement] = STATE(2429),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(489),
    [sym__indent] = ACTIONS(491),
    [sym_string_start] = ACTIONS(81),
  },
  [105] = {
    [sym__simple_statements] = STATE(2539),
    [sym_import_statement] = STATE(2374),
    [sym_future_import_statement] = STATE(2374),
    [sym_import_from_statement] = STATE(2374),
    [sym_print_statement] = STATE(2374),
    [sym_assert_statement] = STATE(2374),
    [sym_expression_statement] = STATE(2374),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2374),
    [sym_delete_statement] = STATE(2374),
    [sym_raise_statement] = STATE(2374),
    [sym_pass_statement] = STATE(2374),
    [sym_break_statement] = STATE(2374),
    [sym_continue_statement] = STATE(2374),
    [sym_global_statement] = STATE(2374),
    [sym_nonlocal_statement] = STATE(2374),
    [sym_exec_statement] = STATE(2374),
    [sym_type_alias_statement] = STATE(2374),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(493),
    [sym__indent] = ACTIONS(495),
    [sym_string_start] = ACTIONS(81),
  },
  [106] = {
    [sym__simple_statements] = STATE(724),
    [sym_import_statement] = STATE(2305),
    [sym_future_import_statement] = STATE(2305),
    [sym_import_from_statement] = STATE(2305),
    [sym_print_statement] = STATE(2305),
    [sym_assert_statement] = STATE(2305),
    [sym_expression_statement] = STATE(2305),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2305),
    [sym_delete_statement] = STATE(2305),
    [sym_raise_statement] = STATE(2305),
    [sym_pass_statement] = STATE(2305),
    [sym_break_statement] = STATE(2305),
    [sym_continue_statement] = STATE(2305),
    [sym_global_statement] = STATE(2305),
    [sym_nonlocal_statement] = STATE(2305),
    [sym_exec_statement] = STATE(2305),
    [sym_type_alias_statement] = STATE(2305),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(497),
    [sym__indent] = ACTIONS(499),
    [sym_string_start] = ACTIONS(81),
  },
  [107] = {
    [sym__simple_statements] = STATE(826),
    [sym_import_statement] = STATE(2305),
    [sym_future_import_statement] = STATE(2305),
    [sym_import_from_statement] = STATE(2305),
    [sym_print_statement] = STATE(2305),
    [sym_assert_statement] = STATE(2305),
    [sym_expression_statement] = STATE(2305),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2305),
    [sym_delete_statement] = STATE(2305),
    [sym_raise_statement] = STATE(2305),
    [sym_pass_statement] = STATE(2305),
    [sym_break_statement] = STATE(2305),
    [sym_continue_statement] = STATE(2305),
    [sym_global_statement] = STATE(2305),
    [sym_nonlocal_statement] = STATE(2305),
    [sym_exec_statement] = STATE(2305),
    [sym_type_alias_statement] = STATE(2305),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(501),
    [sym__indent] = ACTIONS(503),
    [sym_string_start] = ACTIONS(81),
  },
  [108] = {
    [sym__simple_statements] = STATE(618),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(505),
    [sym__indent] = ACTIONS(507),
    [sym_string_start] = ACTIONS(81),
  },
  [109] = {
    [sym__simple_statements] = STATE(717),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(509),
    [sym__indent] = ACTIONS(511),
    [sym_string_start] = ACTIONS(81),
  },
  [110] = {
    [sym__simple_statements] = STATE(737),
    [sym_import_statement] = STATE(2305),
    [sym_future_import_statement] = STATE(2305),
    [sym_import_from_statement] = STATE(2305),
    [sym_print_statement] = STATE(2305),
    [sym_assert_statement] = STATE(2305),
    [sym_expression_statement] = STATE(2305),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2305),
    [sym_delete_statement] = STATE(2305),
    [sym_raise_statement] = STATE(2305),
    [sym_pass_statement] = STATE(2305),
    [sym_break_statement] = STATE(2305),
    [sym_continue_statement] = STATE(2305),
    [sym_global_statement] = STATE(2305),
    [sym_nonlocal_statement] = STATE(2305),
    [sym_exec_statement] = STATE(2305),
    [sym_type_alias_statement] = STATE(2305),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(513),
    [sym__indent] = ACTIONS(515),
    [sym_string_start] = ACTIONS(81),
  },
  [111] = {
    [sym__simple_statements] = STATE(732),
    [sym_import_statement] = STATE(2305),
    [sym_future_import_statement] = STATE(2305),
    [sym_import_from_statement] = STATE(2305),
    [sym_print_statement] = STATE(2305),
    [sym_assert_statement] = STATE(2305),
    [sym_expression_statement] = STATE(2305),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2305),
    [sym_delete_statement] = STATE(2305),
    [sym_raise_statement] = STATE(2305),
    [sym_pass_statement] = STATE(2305),
    [sym_break_statement] = STATE(2305),
    [sym_continue_statement] = STATE(2305),
    [sym_global_statement] = STATE(2305),
    [sym_nonlocal_statement] = STATE(2305),
    [sym_exec_statement] = STATE(2305),
    [sym_type_alias_statement] = STATE(2305),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(517),
    [sym__indent] = ACTIONS(519),
    [sym_string_start] = ACTIONS(81),
  },
  [112] = {
    [sym__simple_statements] = STATE(720),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(521),
    [sym__indent] = ACTIONS(523),
    [sym_string_start] = ACTIONS(81),
  },
  [113] = {
    [sym__simple_statements] = STATE(815),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(525),
    [sym__indent] = ACTIONS(527),
    [sym_string_start] = ACTIONS(81),
  },
  [114] = {
    [sym__simple_statements] = STATE(816),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(529),
    [sym__indent] = ACTIONS(531),
    [sym_string_start] = ACTIONS(81),
  },
  [115] = {
    [sym__simple_statements] = STATE(651),
    [sym_import_statement] = STATE(2300),
    [sym_future_import_statement] = STATE(2300),
    [sym_import_from_statement] = STATE(2300),
    [sym_print_statement] = STATE(2300),
    [sym_assert_statement] = STATE(2300),
    [sym_expression_statement] = STATE(2300),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2300),
    [sym_delete_statement] = STATE(2300),
    [sym_raise_statement] = STATE(2300),
    [sym_pass_statement] = STATE(2300),
    [sym_break_statement] = STATE(2300),
    [sym_continue_statement] = STATE(2300),
    [sym_global_statement] = STATE(2300),
    [sym_nonlocal_statement] = STATE(2300),
    [sym_exec_statement] = STATE(2300),
    [sym_type_alias_statement] = STATE(2300),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(533),
    [sym__indent] = ACTIONS(535),
    [sym_string_start] = ACTIONS(81),
  },
  [116] = {
    [sym__simple_statements] = STATE(2521),
    [sym_import_statement] = STATE(2374),
    [sym_future_import_statement] = STATE(2374),
    [sym_import_from_statement] = STATE(2374),
    [sym_print_statement] = STATE(2374),
    [sym_assert_statement] = STATE(2374),
    [sym_expression_statement] = STATE(2374),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2374),
    [sym_delete_statement] = STATE(2374),
    [sym_raise_statement] = STATE(2374),
    [sym_pass_statement] = STATE(2374),
    [sym_break_statement] = STATE(2374),
    [sym_continue_statement] = STATE(2374),
    [sym_global_statement] = STATE(2374),
    [sym_nonlocal_statement] = STATE(2374),
    [sym_exec_statement] = STATE(2374),
    [sym_type_alias_statement] = STATE(2374),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(537),
    [sym__indent] = ACTIONS(539),
    [sym_string_start] = ACTIONS(81),
  },
  [117] = {
    [sym__simple_statements] = STATE(711),
    [sym_import_statement] = STATE(2305),
    [sym_future_import_statement] = STATE(2305),
    [sym_import_from_statement] = STATE(2305),
    [sym_print_statement] = STATE(2305),
    [sym_assert_statement] = STATE(2305),
    [sym_expression_statement] = STATE(2305),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2305),
    [sym_delete_statement] = STATE(2305),
    [sym_raise_statement] = STATE(2305),
    [sym_pass_statement] = STATE(2305),
    [sym_break_statement] = STATE(2305),
    [sym_continue_statement] = STATE(2305),
    [sym_global_statement] = STATE(2305),
    [sym_nonlocal_statement] = STATE(2305),
    [sym_exec_statement] = STATE(2305),
    [sym_type_alias_statement] = STATE(2305),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(541),
    [sym__indent] = ACTIONS(543),
    [sym_string_start] = ACTIONS(81),
  },
  [118] = {
    [sym__simple_statements] = STATE(783),
    [sym_import_statement] = STATE(2305),
    [sym_future_import_statement] = STATE(2305),
    [sym_import_from_statement] = STATE(2305),
    [sym_print_statement] = STATE(2305),
    [sym_assert_statement] = STATE(2305),
    [sym_expression_statement] = STATE(2305),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2305),
    [sym_delete_statement] = STATE(2305),
    [sym_raise_statement] = STATE(2305),
    [sym_pass_statement] = STATE(2305),
    [sym_break_statement] = STATE(2305),
    [sym_continue_statement] = STATE(2305),
    [sym_global_statement] = STATE(2305),
    [sym_nonlocal_statement] = STATE(2305),
    [sym_exec_statement] = STATE(2305),
    [sym_type_alias_statement] = STATE(2305),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(545),
    [sym__indent] = ACTIONS(547),
    [sym_string_start] = ACTIONS(81),
  },
  [119] = {
    [sym__simple_statements] = STATE(2554),
    [sym_import_statement] = STATE(2374),
    [sym_future_import_statement] = STATE(2374),
    [sym_import_from_statement] = STATE(2374),
    [sym_print_statement] = STATE(2374),
    [sym_assert_statement] = STATE(2374),
    [sym_expression_statement] = STATE(2374),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2374),
    [sym_delete_statement] = STATE(2374),
    [sym_raise_statement] = STATE(2374),
    [sym_pass_statement] = STATE(2374),
    [sym_break_statement] = STATE(2374),
    [sym_continue_statement] = STATE(2374),
    [sym_global_statement] = STATE(2374),
    [sym_nonlocal_statement] = STATE(2374),
    [sym_exec_statement] = STATE(2374),
    [sym_type_alias_statement] = STATE(2374),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(549),
    [sym__indent] = ACTIONS(551),
    [sym_string_start] = ACTIONS(81),
  },
  [120] = {
    [sym__simple_statements] = STATE(824),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(553),
    [sym__indent] = ACTIONS(555),
    [sym_string_start] = ACTIONS(81),
  },
  [121] = {
    [sym__simple_statements] = STATE(690),
    [sym_import_statement] = STATE(2403),
    [sym_future_import_statement] = STATE(2403),
    [sym_import_from_statement] = STATE(2403),
    [sym_print_statement] = STATE(2403),
    [sym_assert_statement] = STATE(2403),
    [sym_expression_statement] = STATE(2403),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2403),
    [sym_delete_statement] = STATE(2403),
    [sym_raise_statement] = STATE(2403),
    [sym_pass_statement] = STATE(2403),
    [sym_break_statement] = STATE(2403),
    [sym_continue_statement] = STATE(2403),
    [sym_global_statement] = STATE(2403),
    [sym_nonlocal_statement] = STATE(2403),
    [sym_exec_statement] = STATE(2403),
    [sym_type_alias_statement] = STATE(2403),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(557),
    [sym__indent] = ACTIONS(559),
    [sym_string_start] = ACTIONS(81),
  },
  [122] = {
    [sym__simple_statements] = STATE(800),
    [sym_import_statement] = STATE(2305),
    [sym_future_import_statement] = STATE(2305),
    [sym_import_from_statement] = STATE(2305),
    [sym_print_statement] = STATE(2305),
    [sym_assert_statement] = STATE(2305),
    [sym_expression_statement] = STATE(2305),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2305),
    [sym_delete_statement] = STATE(2305),
    [sym_raise_statement] = STATE(2305),
    [sym_pass_statement] = STATE(2305),
    [sym_break_statement] = STATE(2305),
    [sym_continue_statement] = STATE(2305),
    [sym_global_statement] = STATE(2305),
    [sym_nonlocal_statement] = STATE(2305),
    [sym_exec_statement] = STATE(2305),
    [sym_type_alias_statement] = STATE(2305),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(561),
    [sym__indent] = ACTIONS(563),
    [sym_string_start] = ACTIONS(81),
  },
  [123] = {
    [sym__simple_statements] = STATE(701),
    [sym_import_statement] = STATE(2300),
    [sym_future_import_statement] = STATE(2300),
    [sym_import_from_statement] = STATE(2300),
    [sym_print_statement] = STATE(2300),
    [sym_assert_statement] = STATE(2300),
    [sym_expression_statement] = STATE(2300),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2300),
    [sym_delete_statement] = STATE(2300),
    [sym_raise_statement] = STATE(2300),
    [sym_pass_statement] = STATE(2300),
    [sym_break_statement] = STATE(2300),
    [sym_continue_statement] = STATE(2300),
    [sym_global_statement] = STATE(2300),
    [sym_nonlocal_statement] = STATE(2300),
    [sym_exec_statement] = STATE(2300),
    [sym_type_alias_statement] = STATE(2300),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(565),
    [sym__indent] = ACTIONS(567),
    [sym_string_start] = ACTIONS(81),
  },
  [124] = {
    [sym__simple_statements] = STATE(665),
    [sym_import_statement] = STATE(2300),
    [sym_future_import_statement] = STATE(2300),
    [sym_import_from_statement] = STATE(2300),
    [sym_print_statement] = STATE(2300),
    [sym_assert_statement] = STATE(2300),
    [sym_expression_statement] = STATE(2300),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2300),
    [sym_delete_statement] = STATE(2300),
    [sym_raise_statement] = STATE(2300),
    [sym_pass_statement] = STATE(2300),
    [sym_break_statement] = STATE(2300),
    [sym_continue_statement] = STATE(2300),
    [sym_global_statement] = STATE(2300),
    [sym_nonlocal_statement] = STATE(2300),
    [sym_exec_statement] = STATE(2300),
    [sym_type_alias_statement] = STATE(2300),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(569),
    [sym__indent] = ACTIONS(571),
    [sym_string_start] = ACTIONS(81),
  },
  [125] = {
    [sym__simple_statements] = STATE(833),
    [sym_import_statement] = STATE(2305),
    [sym_future_import_statement] = STATE(2305),
    [sym_import_from_statement] = STATE(2305),
    [sym_print_statement] = STATE(2305),
    [sym_assert_statement] = STATE(2305),
    [sym_expression_statement] = STATE(2305),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2305),
    [sym_delete_statement] = STATE(2305),
    [sym_raise_statement] = STATE(2305),
    [sym_pass_statement] = STATE(2305),
    [sym_break_statement] = STATE(2305),
    [sym_continue_statement] = STATE(2305),
    [sym_global_statement] = STATE(2305),
    [sym_nonlocal_statement] = STATE(2305),
    [sym_exec_statement] = STATE(2305),
    [sym_type_alias_statement] = STATE(2305),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(573),
    [sym__indent] = ACTIONS(575),
    [sym_string_start] = ACTIONS(81),
  },
  [126] = {
    [sym__simple_statements] = STATE(1829),
    [sym_import_statement] = STATE(2463),
    [sym_future_import_statement] = STATE(2463),
    [sym_import_from_statement] = STATE(2463),
    [sym_print_statement] = STATE(2463),
    [sym_assert_statement] = STATE(2463),
    [sym_expression_statement] = STATE(2463),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2463),
    [sym_delete_statement] = STATE(2463),
    [sym_raise_statement] = STATE(2463),
    [sym_pass_statement] = STATE(2463),
    [sym_break_statement] = STATE(2463),
    [sym_continue_statement] = STATE(2463),
    [sym_global_statement] = STATE(2463),
    [sym_nonlocal_statement] = STATE(2463),
    [sym_exec_statement] = STATE(2463),
    [sym_type_alias_statement] = STATE(2463),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(577),
    [sym__indent] = ACTIONS(579),
    [sym_string_start] = ACTIONS(81),
  },
  [127] = {
    [sym__simple_statements] = STATE(676),
    [sym_import_statement] = STATE(2346),
    [sym_future_import_statement] = STATE(2346),
    [sym_import_from_statement] = STATE(2346),
    [sym_print_statement] = STATE(2346),
    [sym_assert_statement] = STATE(2346),
    [sym_expression_statement] = STATE(2346),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2346),
    [sym_delete_statement] = STATE(2346),
    [sym_raise_statement] = STATE(2346),
    [sym_pass_statement] = STATE(2346),
    [sym_break_statement] = STATE(2346),
    [sym_continue_statement] = STATE(2346),
    [sym_global_statement] = STATE(2346),
    [sym_nonlocal_statement] = STATE(2346),
    [sym_exec_statement] = STATE(2346),
    [sym_type_alias_statement] = STATE(2346),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(581),
    [sym__indent] = ACTIONS(583),
    [sym_string_start] = ACTIONS(81),
  },
  [128] = {
    [sym__simple_statements] = STATE(756),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(585),
    [sym__indent] = ACTIONS(587),
    [sym_string_start] = ACTIONS(81),
  },
  [129] = {
    [sym__simple_statements] = STATE(743),
    [sym_import_statement] = STATE(2305),
    [sym_future_import_statement] = STATE(2305),
    [sym_import_from_statement] = STATE(2305),
    [sym_print_statement] = STATE(2305),
    [sym_assert_statement] = STATE(2305),
    [sym_expression_statement] = STATE(2305),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2305),
    [sym_delete_statement] = STATE(2305),
    [sym_raise_statement] = STATE(2305),
    [sym_pass_statement] = STATE(2305),
    [sym_break_statement] = STATE(2305),
    [sym_continue_statement] = STATE(2305),
    [sym_global_statement] = STATE(2305),
    [sym_nonlocal_statement] = STATE(2305),
    [sym_exec_statement] = STATE(2305),
    [sym_type_alias_statement] = STATE(2305),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(589),
    [sym__indent] = ACTIONS(591),
    [sym_string_start] = ACTIONS(81),
  },
  [130] = {
    [sym__simple_statements] = STATE(839),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(593),
    [sym__indent] = ACTIONS(595),
    [sym_string_start] = ACTIONS(81),
  },
  [131] = {
    [sym__simple_statements] = STATE(734),
    [sym_import_statement] = STATE(2457),
    [sym_future_import_statement] = STATE(2457),
    [sym_import_from_statement] = STATE(2457),
    [sym_print_statement] = STATE(2457),
    [sym_assert_statement] = STATE(2457),
    [sym_expression_statement] = STATE(2457),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2457),
    [sym_delete_statement] = STATE(2457),
    [sym_raise_statement] = STATE(2457),
    [sym_pass_statement] = STATE(2457),
    [sym_break_statement] = STATE(2457),
    [sym_continue_statement] = STATE(2457),
    [sym_global_statement] = STATE(2457),
    [sym_nonlocal_statement] = STATE(2457),
    [sym_exec_statement] = STATE(2457),
    [sym_type_alias_statement] = STATE(2457),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(597),
    [sym__indent] = ACTIONS(599),
    [sym_string_start] = ACTIONS(81),
  },
  [132] = {
    [sym__simple_statements] = STATE(1807),
    [sym_import_statement] = STATE(2463),
    [sym_future_import_statement] = STATE(2463),
    [sym_import_from_statement] = STATE(2463),
    [sym_print_statement] = STATE(2463),
    [sym_assert_statement] = STATE(2463),
    [sym_expression_statement] = STATE(2463),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2463),
    [sym_delete_statement] = STATE(2463),
    [sym_raise_statement] = STATE(2463),
    [sym_pass_statement] = STATE(2463),
    [sym_break_statement] = STATE(2463),
    [sym_continue_statement] = STATE(2463),
    [sym_global_statement] = STATE(2463),
    [sym_nonlocal_statement] = STATE(2463),
    [sym_exec_statement] = STATE(2463),
    [sym_type_alias_statement] = STATE(2463),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(601),
    [sym__indent] = ACTIONS(603),
    [sym_string_start] = ACTIONS(81),
  },
  [133] = {
    [sym__simple_statements] = STATE(807),
    [sym_import_statement] = STATE(2305),
    [sym_future_import_statement] = STATE(2305),
    [sym_import_from_statement] = STATE(2305),
    [sym_print_statement] = STATE(2305),
    [sym_assert_statement] = STATE(2305),
    [sym_expression_statement] = STATE(2305),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2305),
    [sym_delete_statement] = STATE(2305),
    [sym_raise_statement] = STATE(2305),
    [sym_pass_statement] = STATE(2305),
    [sym_break_statement] = STATE(2305),
    [sym_continue_statement] = STATE(2305),
    [sym_global_statement] = STATE(2305),
    [sym_nonlocal_statement] = STATE(2305),
    [sym_exec_statement] = STATE(2305),
    [sym_type_alias_statement] = STATE(2305),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(605),
    [sym__indent] = ACTIONS(607),
    [sym_string_start] = ACTIONS(81),
  },
  [134] = {
    [sym__simple_statements] = STATE(2576),
    [sym_import_statement] = STATE(2374),
    [sym_future_import_statement] = STATE(2374),
    [sym_import_from_statement] = STATE(2374),
    [sym_print_statement] = STATE(2374),
    [sym_assert_statement] = STATE(2374),
    [sym_expression_statement] = STATE(2374),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2374),
    [sym_delete_statement] = STATE(2374),
    [sym_raise_statement] = STATE(2374),
    [sym_pass_statement] = STATE(2374),
    [sym_break_statement] = STATE(2374),
    [sym_continue_statement] = STATE(2374),
    [sym_global_statement] = STATE(2374),
    [sym_nonlocal_statement] = STATE(2374),
    [sym_exec_statement] = STATE(2374),
    [sym_type_alias_statement] = STATE(2374),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(609),
    [sym__indent] = ACTIONS(611),
    [sym_string_start] = ACTIONS(81),
  },
  [135] = {
    [sym__simple_statements] = STATE(2529),
    [sym_import_statement] = STATE(2374),
    [sym_future_import_statement] = STATE(2374),
    [sym_import_from_statement] = STATE(2374),
    [sym_print_statement] = STATE(2374),
    [sym_assert_statement] = STATE(2374),
    [sym_expression_statement] = STATE(2374),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2374),
    [sym_delete_statement] = STATE(2374),
    [sym_raise_statement] = STATE(2374),
    [sym_pass_statement] = STATE(2374),
    [sym_break_statement] = STATE(2374),
    [sym_continue_statement] = STATE(2374),
    [sym_global_statement] = STATE(2374),
    [sym_nonlocal_statement] = STATE(2374),
    [sym_exec_statement] = STATE(2374),
    [sym_type_alias_statement] = STATE(2374),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(613),
    [sym__indent] = ACTIONS(615),
    [sym_string_start] = ACTIONS(81),
  },
  [136] = {
    [sym__simple_statements] = STATE(705),
    [sym_import_statement] = STATE(2305),
    [sym_future_import_statement] = STATE(2305),
    [sym_import_from_statement] = STATE(2305),
    [sym_print_statement] = STATE(2305),
    [sym_assert_statement] = STATE(2305),
    [sym_expression_statement] = STATE(2305),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2305),
    [sym_delete_statement] = STATE(2305),
    [sym_raise_statement] = STATE(2305),
    [sym_pass_statement] = STATE(2305),
    [sym_break_statement] = STATE(2305),
    [sym_continue_statement] = STATE(2305),
    [sym_global_statement] = STATE(2305),
    [sym_nonlocal_statement] = STATE(2305),
    [sym_exec_statement] = STATE(2305),
    [sym_type_alias_statement] = STATE(2305),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(617),
    [sym__indent] = ACTIONS(619),
    [sym_string_start] = ACTIONS(81),
  },
  [137] = {
    [sym_import_statement] = STATE(2557),
    [sym_future_import_statement] = STATE(2557),
    [sym_import_from_statement] = STATE(2557),
    [sym_print_statement] = STATE(2557),
    [sym_assert_statement] = STATE(2557),
    [sym_expression_statement] = STATE(2557),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2557),
    [sym_delete_statement] = STATE(2557),
    [sym_raise_statement] = STATE(2557),
    [sym_pass_statement] = STATE(2557),
    [sym_break_statement] = STATE(2557),
    [sym_continue_statement] = STATE(2557),
    [sym_global_statement] = STATE(2557),
    [sym_nonlocal_statement] = STATE(2557),
    [sym_exec_statement] = STATE(2557),
    [sym_type_alias_statement] = STATE(2557),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(621),
    [sym_string_start] = ACTIONS(81),
  },
  [138] = {
    [sym_import_statement] = STATE(2557),
    [sym_future_import_statement] = STATE(2557),
    [sym_import_from_statement] = STATE(2557),
    [sym_print_statement] = STATE(2557),
    [sym_assert_statement] = STATE(2557),
    [sym_expression_statement] = STATE(2557),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2557),
    [sym_delete_statement] = STATE(2557),
    [sym_raise_statement] = STATE(2557),
    [sym_pass_statement] = STATE(2557),
    [sym_break_statement] = STATE(2557),
    [sym_continue_statement] = STATE(2557),
    [sym_global_statement] = STATE(2557),
    [sym_nonlocal_statement] = STATE(2557),
    [sym_exec_statement] = STATE(2557),
    [sym_type_alias_statement] = STATE(2557),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(623),
    [sym_string_start] = ACTIONS(81),
  },
  [139] = {
    [sym_import_statement] = STATE(2557),
    [sym_future_import_statement] = STATE(2557),
    [sym_import_from_statement] = STATE(2557),
    [sym_print_statement] = STATE(2557),
    [sym_assert_statement] = STATE(2557),
    [sym_expression_statement] = STATE(2557),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2557),
    [sym_delete_statement] = STATE(2557),
    [sym_raise_statement] = STATE(2557),
    [sym_pass_statement] = STATE(2557),
    [sym_break_statement] = STATE(2557),
    [sym_continue_statement] = STATE(2557),
    [sym_global_statement] = STATE(2557),
    [sym_nonlocal_statement] = STATE(2557),
    [sym_exec_statement] = STATE(2557),
    [sym_type_alias_statement] = STATE(2557),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(625),
    [sym_string_start] = ACTIONS(81),
  },
  [140] = {
    [sym_import_statement] = STATE(2557),
    [sym_future_import_statement] = STATE(2557),
    [sym_import_from_statement] = STATE(2557),
    [sym_print_statement] = STATE(2557),
    [sym_assert_statement] = STATE(2557),
    [sym_expression_statement] = STATE(2557),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2557),
    [sym_delete_statement] = STATE(2557),
    [sym_raise_statement] = STATE(2557),
    [sym_pass_statement] = STATE(2557),
    [sym_break_statement] = STATE(2557),
    [sym_continue_statement] = STATE(2557),
    [sym_global_statement] = STATE(2557),
    [sym_nonlocal_statement] = STATE(2557),
    [sym_exec_statement] = STATE(2557),
    [sym_type_alias_statement] = STATE(2557),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(627),
    [sym_string_start] = ACTIONS(81),
  },
  [141] = {
    [sym_import_statement] = STATE(2557),
    [sym_future_import_statement] = STATE(2557),
    [sym_import_from_statement] = STATE(2557),
    [sym_print_statement] = STATE(2557),
    [sym_assert_statement] = STATE(2557),
    [sym_expression_statement] = STATE(2557),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2557),
    [sym_delete_statement] = STATE(2557),
    [sym_raise_statement] = STATE(2557),
    [sym_pass_statement] = STATE(2557),
    [sym_break_statement] = STATE(2557),
    [sym_continue_statement] = STATE(2557),
    [sym_global_statement] = STATE(2557),
    [sym_nonlocal_statement] = STATE(2557),
    [sym_exec_statement] = STATE(2557),
    [sym_type_alias_statement] = STATE(2557),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(629),
    [sym_string_start] = ACTIONS(81),
  },
  [142] = {
    [sym_import_statement] = STATE(2557),
    [sym_future_import_statement] = STATE(2557),
    [sym_import_from_statement] = STATE(2557),
    [sym_print_statement] = STATE(2557),
    [sym_assert_statement] = STATE(2557),
    [sym_expression_statement] = STATE(2557),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2557),
    [sym_delete_statement] = STATE(2557),
    [sym_raise_statement] = STATE(2557),
    [sym_pass_statement] = STATE(2557),
    [sym_break_statement] = STATE(2557),
    [sym_continue_statement] = STATE(2557),
    [sym_global_statement] = STATE(2557),
    [sym_nonlocal_statement] = STATE(2557),
    [sym_exec_statement] = STATE(2557),
    [sym_type_alias_statement] = STATE(2557),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(631),
    [sym_string_start] = ACTIONS(81),
  },
  [143] = {
    [sym_import_statement] = STATE(2557),
    [sym_future_import_statement] = STATE(2557),
    [sym_import_from_statement] = STATE(2557),
    [sym_print_statement] = STATE(2557),
    [sym_assert_statement] = STATE(2557),
    [sym_expression_statement] = STATE(2557),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2557),
    [sym_delete_statement] = STATE(2557),
    [sym_raise_statement] = STATE(2557),
    [sym_pass_statement] = STATE(2557),
    [sym_break_statement] = STATE(2557),
    [sym_continue_statement] = STATE(2557),
    [sym_global_statement] = STATE(2557),
    [sym_nonlocal_statement] = STATE(2557),
    [sym_exec_statement] = STATE(2557),
    [sym_type_alias_statement] = STATE(2557),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(633),
    [sym_string_start] = ACTIONS(81),
  },
  [144] = {
    [sym_import_statement] = STATE(2557),
    [sym_future_import_statement] = STATE(2557),
    [sym_import_from_statement] = STATE(2557),
    [sym_print_statement] = STATE(2557),
    [sym_assert_statement] = STATE(2557),
    [sym_expression_statement] = STATE(2557),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2557),
    [sym_delete_statement] = STATE(2557),
    [sym_raise_statement] = STATE(2557),
    [sym_pass_statement] = STATE(2557),
    [sym_break_statement] = STATE(2557),
    [sym_continue_statement] = STATE(2557),
    [sym_global_statement] = STATE(2557),
    [sym_nonlocal_statement] = STATE(2557),
    [sym_exec_statement] = STATE(2557),
    [sym_type_alias_statement] = STATE(2557),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(635),
    [sym_string_start] = ACTIONS(81),
  },
  [145] = {
    [sym_import_statement] = STATE(2557),
    [sym_future_import_statement] = STATE(2557),
    [sym_import_from_statement] = STATE(2557),
    [sym_print_statement] = STATE(2557),
    [sym_assert_statement] = STATE(2557),
    [sym_expression_statement] = STATE(2557),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2557),
    [sym_delete_statement] = STATE(2557),
    [sym_raise_statement] = STATE(2557),
    [sym_pass_statement] = STATE(2557),
    [sym_break_statement] = STATE(2557),
    [sym_continue_statement] = STATE(2557),
    [sym_global_statement] = STATE(2557),
    [sym_nonlocal_statement] = STATE(2557),
    [sym_exec_statement] = STATE(2557),
    [sym_type_alias_statement] = STATE(2557),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(637),
    [sym_string_start] = ACTIONS(81),
  },
  [146] = {
    [sym_import_statement] = STATE(2557),
    [sym_future_import_statement] = STATE(2557),
    [sym_import_from_statement] = STATE(2557),
    [sym_print_statement] = STATE(2557),
    [sym_assert_statement] = STATE(2557),
    [sym_expression_statement] = STATE(2557),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2557),
    [sym_delete_statement] = STATE(2557),
    [sym_raise_statement] = STATE(2557),
    [sym_pass_statement] = STATE(2557),
    [sym_break_statement] = STATE(2557),
    [sym_continue_statement] = STATE(2557),
    [sym_global_statement] = STATE(2557),
    [sym_nonlocal_statement] = STATE(2557),
    [sym_exec_statement] = STATE(2557),
    [sym_type_alias_statement] = STATE(2557),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(639),
    [sym_string_start] = ACTIONS(81),
  },
  [147] = {
    [sym_import_statement] = STATE(2557),
    [sym_future_import_statement] = STATE(2557),
    [sym_import_from_statement] = STATE(2557),
    [sym_print_statement] = STATE(2557),
    [sym_assert_statement] = STATE(2557),
    [sym_expression_statement] = STATE(2557),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2557),
    [sym_delete_statement] = STATE(2557),
    [sym_raise_statement] = STATE(2557),
    [sym_pass_statement] = STATE(2557),
    [sym_break_statement] = STATE(2557),
    [sym_continue_statement] = STATE(2557),
    [sym_global_statement] = STATE(2557),
    [sym_nonlocal_statement] = STATE(2557),
    [sym_exec_statement] = STATE(2557),
    [sym_type_alias_statement] = STATE(2557),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(641),
    [sym_string_start] = ACTIONS(81),
  },
  [148] = {
    [sym_import_statement] = STATE(2557),
    [sym_future_import_statement] = STATE(2557),
    [sym_import_from_statement] = STATE(2557),
    [sym_print_statement] = STATE(2557),
    [sym_assert_statement] = STATE(2557),
    [sym_expression_statement] = STATE(2557),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2557),
    [sym_delete_statement] = STATE(2557),
    [sym_raise_statement] = STATE(2557),
    [sym_pass_statement] = STATE(2557),
    [sym_break_statement] = STATE(2557),
    [sym_continue_statement] = STATE(2557),
    [sym_global_statement] = STATE(2557),
    [sym_nonlocal_statement] = STATE(2557),
    [sym_exec_statement] = STATE(2557),
    [sym_type_alias_statement] = STATE(2557),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(643),
    [sym_string_start] = ACTIONS(81),
  },
  [149] = {
    [sym_import_statement] = STATE(2557),
    [sym_future_import_statement] = STATE(2557),
    [sym_import_from_statement] = STATE(2557),
    [sym_print_statement] = STATE(2557),
    [sym_assert_statement] = STATE(2557),
    [sym_expression_statement] = STATE(2557),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2557),
    [sym_delete_statement] = STATE(2557),
    [sym_raise_statement] = STATE(2557),
    [sym_pass_statement] = STATE(2557),
    [sym_break_statement] = STATE(2557),
    [sym_continue_statement] = STATE(2557),
    [sym_global_statement] = STATE(2557),
    [sym_nonlocal_statement] = STATE(2557),
    [sym_exec_statement] = STATE(2557),
    [sym_type_alias_statement] = STATE(2557),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(645),
    [sym_string_start] = ACTIONS(81),
  },
  [150] = {
    [sym_import_statement] = STATE(2557),
    [sym_future_import_statement] = STATE(2557),
    [sym_import_from_statement] = STATE(2557),
    [sym_print_statement] = STATE(2557),
    [sym_assert_statement] = STATE(2557),
    [sym_expression_statement] = STATE(2557),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2557),
    [sym_delete_statement] = STATE(2557),
    [sym_raise_statement] = STATE(2557),
    [sym_pass_statement] = STATE(2557),
    [sym_break_statement] = STATE(2557),
    [sym_continue_statement] = STATE(2557),
    [sym_global_statement] = STATE(2557),
    [sym_nonlocal_statement] = STATE(2557),
    [sym_exec_statement] = STATE(2557),
    [sym_type_alias_statement] = STATE(2557),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(647),
    [sym_string_start] = ACTIONS(81),
  },
  [151] = {
    [sym_import_statement] = STATE(2557),
    [sym_future_import_statement] = STATE(2557),
    [sym_import_from_statement] = STATE(2557),
    [sym_print_statement] = STATE(2557),
    [sym_assert_statement] = STATE(2557),
    [sym_expression_statement] = STATE(2557),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2557),
    [sym_delete_statement] = STATE(2557),
    [sym_raise_statement] = STATE(2557),
    [sym_pass_statement] = STATE(2557),
    [sym_break_statement] = STATE(2557),
    [sym_continue_statement] = STATE(2557),
    [sym_global_statement] = STATE(2557),
    [sym_nonlocal_statement] = STATE(2557),
    [sym_exec_statement] = STATE(2557),
    [sym_type_alias_statement] = STATE(2557),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(649),
    [sym_string_start] = ACTIONS(81),
  },
  [152] = {
    [sym_import_statement] = STATE(2557),
    [sym_future_import_statement] = STATE(2557),
    [sym_import_from_statement] = STATE(2557),
    [sym_print_statement] = STATE(2557),
    [sym_assert_statement] = STATE(2557),
    [sym_expression_statement] = STATE(2557),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2557),
    [sym_delete_statement] = STATE(2557),
    [sym_raise_statement] = STATE(2557),
    [sym_pass_statement] = STATE(2557),
    [sym_break_statement] = STATE(2557),
    [sym_continue_statement] = STATE(2557),
    [sym_global_statement] = STATE(2557),
    [sym_nonlocal_statement] = STATE(2557),
    [sym_exec_statement] = STATE(2557),
    [sym_type_alias_statement] = STATE(2557),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(651),
    [sym_string_start] = ACTIONS(81),
  },
  [153] = {
    [sym_import_statement] = STATE(2557),
    [sym_future_import_statement] = STATE(2557),
    [sym_import_from_statement] = STATE(2557),
    [sym_print_statement] = STATE(2557),
    [sym_assert_statement] = STATE(2557),
    [sym_expression_statement] = STATE(2557),
    [sym_named_expression] = STATE(1679),
    [sym__named_expression_lhs] = STATE(2672),
    [sym_return_statement] = STATE(2557),
    [sym_delete_statement] = STATE(2557),
    [sym_raise_statement] = STATE(2557),
    [sym_pass_statement] = STATE(2557),
    [sym_break_statement] = STATE(2557),
    [sym_continue_statement] = STATE(2557),
    [sym_global_statement] = STATE(2557),
    [sym_nonlocal_statement] = STATE(2557),
    [sym_exec_statement] = STATE(2557),
    [sym_type_alias_statement] = STATE(2557),
    [sym_pattern] = STATE(1652),
    [sym_tuple_pattern] = STATE(1650),
    [sym_list_pattern] = STATE(1650),
    [sym_list_splat_pattern] = STATE(645),
    [sym_as_pattern] = STATE(1679),
    [sym_expression] = STATE(1824),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1679),
    [sym_boolean_operator] = STATE(1679),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_comparison_operator] = STATE(1679),
    [sym_lambda] = STATE(1679),
    [sym_assignment] = STATE(2604),
    [sym_augmented_assignment] = STATE(2604),
    [sym_pattern_list] = STATE(1660),
    [sym_yield] = STATE(2604),
    [sym_attribute] = STATE(646),
    [sym_subscript] = STATE(646),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_conditional_expression] = STATE(1679),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(417),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(81),
  },
  [154] = {
    [sym_list_splat_pattern] = STATE(1135),
    [sym_primary_expression] = STATE(976),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_attribute] = STATE(1081),
    [sym_subscript] = STATE(1081),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(653),
    [anon_sym_COMMA] = ACTIONS(284),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(655),
    [anon_sym_print] = ACTIONS(657),
    [anon_sym_GT_GT] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(304),
    [anon_sym_match] = ACTIONS(659),
    [anon_sym_async] = ACTIONS(657),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(279),
    [anon_sym_exec] = ACTIONS(657),
    [anon_sym_type] = ACTIONS(659),
    [anon_sym_EQ] = ACTIONS(304),
    [anon_sym_LBRACK] = ACTIONS(661),
    [anon_sym_AT] = ACTIONS(279),
    [anon_sym_DASH] = ACTIONS(663),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(663),
    [anon_sym_not] = ACTIONS(279),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(279),
    [anon_sym_SLASH_SLASH] = ACTIONS(279),
    [anon_sym_AMP] = ACTIONS(279),
    [anon_sym_CARET] = ACTIONS(279),
    [anon_sym_LT_LT] = ACTIONS(279),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [anon_sym_PLUS_EQ] = ACTIONS(320),
    [anon_sym_DASH_EQ] = ACTIONS(320),
    [anon_sym_STAR_EQ] = ACTIONS(320),
    [anon_sym_SLASH_EQ] = ACTIONS(320),
    [anon_sym_AT_EQ] = ACTIONS(320),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(320),
    [anon_sym_PERCENT_EQ] = ACTIONS(320),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(320),
    [anon_sym_GT_GT_EQ] = ACTIONS(320),
    [anon_sym_LT_LT_EQ] = ACTIONS(320),
    [anon_sym_AMP_EQ] = ACTIONS(320),
    [anon_sym_CARET_EQ] = ACTIONS(320),
    [anon_sym_PIPE_EQ] = ACTIONS(320),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(665),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym_string_start] = ACTIONS(81),
  },
  [155] = {
    [sym_list_splat_pattern] = STATE(1135),
    [sym_primary_expression] = STATE(976),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_attribute] = STATE(1081),
    [sym_subscript] = STATE(1081),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(653),
    [anon_sym_COMMA] = ACTIONS(284),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(655),
    [anon_sym_print] = ACTIONS(657),
    [anon_sym_GT_GT] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(294),
    [anon_sym_match] = ACTIONS(659),
    [anon_sym_async] = ACTIONS(657),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(279),
    [anon_sym_exec] = ACTIONS(657),
    [anon_sym_type] = ACTIONS(659),
    [anon_sym_EQ] = ACTIONS(304),
    [anon_sym_LBRACK] = ACTIONS(661),
    [anon_sym_AT] = ACTIONS(279),
    [anon_sym_DASH] = ACTIONS(663),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(663),
    [anon_sym_not] = ACTIONS(279),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(279),
    [anon_sym_SLASH_SLASH] = ACTIONS(279),
    [anon_sym_AMP] = ACTIONS(279),
    [anon_sym_CARET] = ACTIONS(279),
    [anon_sym_LT_LT] = ACTIONS(279),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [anon_sym_PLUS_EQ] = ACTIONS(320),
    [anon_sym_DASH_EQ] = ACTIONS(320),
    [anon_sym_STAR_EQ] = ACTIONS(320),
    [anon_sym_SLASH_EQ] = ACTIONS(320),
    [anon_sym_AT_EQ] = ACTIONS(320),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(320),
    [anon_sym_PERCENT_EQ] = ACTIONS(320),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(320),
    [anon_sym_GT_GT_EQ] = ACTIONS(320),
    [anon_sym_LT_LT_EQ] = ACTIONS(320),
    [anon_sym_AMP_EQ] = ACTIONS(320),
    [anon_sym_CARET_EQ] = ACTIONS(320),
    [anon_sym_PIPE_EQ] = ACTIONS(320),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(665),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym_string_start] = ACTIONS(81),
  },
  [156] = {
    [sym_list_splat_pattern] = STATE(1325),
    [sym_primary_expression] = STATE(1053),
    [sym_binary_operator] = STATE(1311),
    [sym_unary_operator] = STATE(1311),
    [sym_attribute] = STATE(1311),
    [sym_subscript] = STATE(1311),
    [sym_call] = STATE(1311),
    [sym_list] = STATE(1311),
    [sym_set] = STATE(1311),
    [sym_tuple] = STATE(1311),
    [sym_dictionary] = STATE(1311),
    [sym_list_comprehension] = STATE(1311),
    [sym_dictionary_comprehension] = STATE(1311),
    [sym_set_comprehension] = STATE(1311),
    [sym_generator_expression] = STATE(1311),
    [sym_parenthesized_expression] = STATE(1311),
    [sym_concatenated_string] = STATE(1311),
    [sym_string] = STATE(1025),
    [sym_await] = STATE(1311),
    [sym_identifier] = ACTIONS(324),
    [anon_sym_SEMI] = ACTIONS(667),
    [anon_sym_DOT] = ACTIONS(669),
    [anon_sym_LPAREN] = ACTIONS(672),
    [anon_sym_COMMA] = ACTIONS(667),
    [anon_sym_as] = ACTIONS(674),
    [anon_sym_STAR] = ACTIONS(676),
    [anon_sym_print] = ACTIONS(678),
    [anon_sym_GT_GT] = ACTIONS(669),
    [anon_sym_if] = ACTIONS(674),
    [anon_sym_COLON] = ACTIONS(667),
    [anon_sym_match] = ACTIONS(680),
    [anon_sym_async] = ACTIONS(678),
    [anon_sym_in] = ACTIONS(674),
    [anon_sym_STAR_STAR] = ACTIONS(669),
    [anon_sym_exec] = ACTIONS(678),
    [anon_sym_type] = ACTIONS(680),
    [anon_sym_EQ] = ACTIONS(674),
    [anon_sym_LBRACK] = ACTIONS(682),
    [anon_sym_AT] = ACTIONS(669),
    [anon_sym_DASH] = ACTIONS(684),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_PLUS] = ACTIONS(684),
    [anon_sym_not] = ACTIONS(674),
    [anon_sym_and] = ACTIONS(674),
    [anon_sym_or] = ACTIONS(674),
    [anon_sym_SLASH] = ACTIONS(669),
    [anon_sym_PERCENT] = ACTIONS(669),
    [anon_sym_SLASH_SLASH] = ACTIONS(669),
    [anon_sym_AMP] = ACTIONS(669),
    [anon_sym_CARET] = ACTIONS(669),
    [anon_sym_LT_LT] = ACTIONS(669),
    [anon_sym_TILDE] = ACTIONS(316),
    [anon_sym_is] = ACTIONS(674),
    [anon_sym_LT] = ACTIONS(674),
    [anon_sym_LT_EQ] = ACTIONS(667),
    [anon_sym_EQ_EQ] = ACTIONS(667),
    [anon_sym_BANG_EQ] = ACTIONS(667),
    [anon_sym_GT_EQ] = ACTIONS(667),
    [anon_sym_GT] = ACTIONS(674),
    [anon_sym_LT_GT] = ACTIONS(667),
    [anon_sym_PLUS_EQ] = ACTIONS(667),
    [anon_sym_DASH_EQ] = ACTIONS(667),
    [anon_sym_STAR_EQ] = ACTIONS(667),
    [anon_sym_SLASH_EQ] = ACTIONS(667),
    [anon_sym_AT_EQ] = ACTIONS(667),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(667),
    [anon_sym_PERCENT_EQ] = ACTIONS(667),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_LT_LT_EQ] = ACTIONS(667),
    [anon_sym_AMP_EQ] = ACTIONS(667),
    [anon_sym_CARET_EQ] = ACTIONS(667),
    [anon_sym_PIPE_EQ] = ACTIONS(667),
    [sym_ellipsis] = ACTIONS(322),
    [sym_integer] = ACTIONS(324),
    [sym_float] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(686),
    [sym_true] = ACTIONS(324),
    [sym_false] = ACTIONS(324),
    [sym_none] = ACTIONS(324),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(667),
    [sym_string_start] = ACTIONS(328),
  },
  [157] = {
    [sym_list_splat_pattern] = STATE(1135),
    [sym_primary_expression] = STATE(976),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_attribute] = STATE(1081),
    [sym_subscript] = STATE(1081),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_from] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(653),
    [anon_sym_COMMA] = ACTIONS(277),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(655),
    [anon_sym_print] = ACTIONS(657),
    [anon_sym_GT_GT] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(279),
    [anon_sym_match] = ACTIONS(659),
    [anon_sym_async] = ACTIONS(657),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(277),
    [anon_sym_exec] = ACTIONS(657),
    [anon_sym_type] = ACTIONS(659),
    [anon_sym_EQ] = ACTIONS(279),
    [anon_sym_LBRACK] = ACTIONS(661),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(279),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(277),
    [anon_sym_SLASH_SLASH] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(277),
    [anon_sym_CARET] = ACTIONS(277),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(665),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym_string_start] = ACTIONS(81),
  },
  [158] = {
    [sym_list_splat_pattern] = STATE(1249),
    [sym_primary_expression] = STATE(1014),
    [sym_binary_operator] = STATE(1198),
    [sym_unary_operator] = STATE(1198),
    [sym_attribute] = STATE(1198),
    [sym_subscript] = STATE(1198),
    [sym_call] = STATE(1198),
    [sym_list] = STATE(1198),
    [sym_set] = STATE(1198),
    [sym_tuple] = STATE(1198),
    [sym_dictionary] = STATE(1198),
    [sym_list_comprehension] = STATE(1198),
    [sym_dictionary_comprehension] = STATE(1198),
    [sym_set_comprehension] = STATE(1198),
    [sym_generator_expression] = STATE(1198),
    [sym_parenthesized_expression] = STATE(1198),
    [sym_concatenated_string] = STATE(1198),
    [sym_string] = STATE(983),
    [sym_await] = STATE(1198),
    [sym_identifier] = ACTIONS(688),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(690),
    [anon_sym_COMMA] = ACTIONS(284),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(692),
    [anon_sym_print] = ACTIONS(694),
    [anon_sym_GT_GT] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(279),
    [anon_sym_match] = ACTIONS(696),
    [anon_sym_async] = ACTIONS(694),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(277),
    [anon_sym_exec] = ACTIONS(694),
    [anon_sym_type] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(279),
    [anon_sym_LBRACK] = ACTIONS(698),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(700),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_LBRACE] = ACTIONS(702),
    [anon_sym_RBRACE] = ACTIONS(277),
    [anon_sym_PLUS] = ACTIONS(700),
    [anon_sym_not] = ACTIONS(279),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(277),
    [anon_sym_SLASH_SLASH] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(277),
    [anon_sym_CARET] = ACTIONS(277),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_TILDE] = ACTIONS(700),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [sym_ellipsis] = ACTIONS(704),
    [sym_type_conversion] = ACTIONS(277),
    [sym_integer] = ACTIONS(688),
    [sym_float] = ACTIONS(704),
    [anon_sym_await] = ACTIONS(706),
    [sym_true] = ACTIONS(688),
    [sym_false] = ACTIONS(688),
    [sym_none] = ACTIONS(688),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(708),
  },
  [159] = {
    [sym_list_splat_pattern] = STATE(1325),
    [sym_primary_expression] = STATE(1053),
    [sym_binary_operator] = STATE(1311),
    [sym_unary_operator] = STATE(1311),
    [sym_attribute] = STATE(1311),
    [sym_subscript] = STATE(1311),
    [sym_call] = STATE(1311),
    [sym_list] = STATE(1311),
    [sym_set] = STATE(1311),
    [sym_tuple] = STATE(1311),
    [sym_dictionary] = STATE(1311),
    [sym_list_comprehension] = STATE(1311),
    [sym_dictionary_comprehension] = STATE(1311),
    [sym_set_comprehension] = STATE(1311),
    [sym_generator_expression] = STATE(1311),
    [sym_parenthesized_expression] = STATE(1311),
    [sym_concatenated_string] = STATE(1311),
    [sym_string] = STATE(1025),
    [sym_await] = STATE(1311),
    [sym_identifier] = ACTIONS(324),
    [anon_sym_SEMI] = ACTIONS(667),
    [anon_sym_DOT] = ACTIONS(669),
    [anon_sym_from] = ACTIONS(674),
    [anon_sym_LPAREN] = ACTIONS(672),
    [anon_sym_COMMA] = ACTIONS(667),
    [anon_sym_as] = ACTIONS(674),
    [anon_sym_STAR] = ACTIONS(676),
    [anon_sym_print] = ACTIONS(678),
    [anon_sym_GT_GT] = ACTIONS(710),
    [anon_sym_if] = ACTIONS(674),
    [anon_sym_COLON] = ACTIONS(667),
    [anon_sym_match] = ACTIONS(680),
    [anon_sym_async] = ACTIONS(678),
    [anon_sym_in] = ACTIONS(674),
    [anon_sym_STAR_STAR] = ACTIONS(710),
    [anon_sym_exec] = ACTIONS(678),
    [anon_sym_type] = ACTIONS(680),
    [anon_sym_EQ] = ACTIONS(674),
    [anon_sym_LBRACK] = ACTIONS(682),
    [anon_sym_AT] = ACTIONS(710),
    [anon_sym_DASH] = ACTIONS(316),
    [anon_sym_PIPE] = ACTIONS(710),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_PLUS] = ACTIONS(316),
    [anon_sym_not] = ACTIONS(674),
    [anon_sym_and] = ACTIONS(674),
    [anon_sym_or] = ACTIONS(674),
    [anon_sym_SLASH] = ACTIONS(669),
    [anon_sym_PERCENT] = ACTIONS(710),
    [anon_sym_SLASH_SLASH] = ACTIONS(710),
    [anon_sym_AMP] = ACTIONS(710),
    [anon_sym_CARET] = ACTIONS(710),
    [anon_sym_LT_LT] = ACTIONS(710),
    [anon_sym_TILDE] = ACTIONS(316),
    [anon_sym_is] = ACTIONS(674),
    [anon_sym_LT] = ACTIONS(674),
    [anon_sym_LT_EQ] = ACTIONS(667),
    [anon_sym_EQ_EQ] = ACTIONS(667),
    [anon_sym_BANG_EQ] = ACTIONS(667),
    [anon_sym_GT_EQ] = ACTIONS(667),
    [anon_sym_GT] = ACTIONS(674),
    [anon_sym_LT_GT] = ACTIONS(667),
    [sym_ellipsis] = ACTIONS(322),
    [sym_integer] = ACTIONS(324),
    [sym_float] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(686),
    [sym_true] = ACTIONS(324),
    [sym_false] = ACTIONS(324),
    [sym_none] = ACTIONS(324),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(667),
    [sym_string_start] = ACTIONS(328),
  },
  [160] = {
    [sym_list_splat_pattern] = STATE(1325),
    [sym_primary_expression] = STATE(1053),
    [sym_binary_operator] = STATE(1311),
    [sym_unary_operator] = STATE(1311),
    [sym_attribute] = STATE(1311),
    [sym_subscript] = STATE(1311),
    [sym_call] = STATE(1311),
    [sym_list] = STATE(1311),
    [sym_set] = STATE(1311),
    [sym_tuple] = STATE(1311),
    [sym_dictionary] = STATE(1311),
    [sym_list_comprehension] = STATE(1311),
    [sym_dictionary_comprehension] = STATE(1311),
    [sym_set_comprehension] = STATE(1311),
    [sym_generator_expression] = STATE(1311),
    [sym_parenthesized_expression] = STATE(1311),
    [sym_concatenated_string] = STATE(1311),
    [sym_string] = STATE(1025),
    [sym_await] = STATE(1311),
    [sym_identifier] = ACTIONS(324),
    [anon_sym_DOT] = ACTIONS(669),
    [anon_sym_LPAREN] = ACTIONS(672),
    [anon_sym_COMMA] = ACTIONS(667),
    [anon_sym_as] = ACTIONS(674),
    [anon_sym_STAR] = ACTIONS(676),
    [anon_sym_print] = ACTIONS(678),
    [anon_sym_GT_GT] = ACTIONS(710),
    [anon_sym_if] = ACTIONS(674),
    [anon_sym_COLON] = ACTIONS(667),
    [anon_sym_match] = ACTIONS(680),
    [anon_sym_async] = ACTIONS(678),
    [anon_sym_for] = ACTIONS(674),
    [anon_sym_in] = ACTIONS(674),
    [anon_sym_STAR_STAR] = ACTIONS(710),
    [anon_sym_exec] = ACTIONS(678),
    [anon_sym_type] = ACTIONS(680),
    [anon_sym_EQ] = ACTIONS(674),
    [anon_sym_LBRACK] = ACTIONS(682),
    [anon_sym_AT] = ACTIONS(710),
    [anon_sym_DASH] = ACTIONS(316),
    [anon_sym_PIPE] = ACTIONS(710),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_RBRACE] = ACTIONS(667),
    [anon_sym_PLUS] = ACTIONS(316),
    [anon_sym_not] = ACTIONS(674),
    [anon_sym_and] = ACTIONS(674),
    [anon_sym_or] = ACTIONS(674),
    [anon_sym_SLASH] = ACTIONS(669),
    [anon_sym_PERCENT] = ACTIONS(710),
    [anon_sym_SLASH_SLASH] = ACTIONS(710),
    [anon_sym_AMP] = ACTIONS(710),
    [anon_sym_CARET] = ACTIONS(710),
    [anon_sym_LT_LT] = ACTIONS(710),
    [anon_sym_TILDE] = ACTIONS(316),
    [anon_sym_is] = ACTIONS(674),
    [anon_sym_LT] = ACTIONS(674),
    [anon_sym_LT_EQ] = ACTIONS(667),
    [anon_sym_EQ_EQ] = ACTIONS(667),
    [anon_sym_BANG_EQ] = ACTIONS(667),
    [anon_sym_GT_EQ] = ACTIONS(667),
    [anon_sym_GT] = ACTIONS(674),
    [anon_sym_LT_GT] = ACTIONS(667),
    [sym_ellipsis] = ACTIONS(322),
    [sym_type_conversion] = ACTIONS(667),
    [sym_integer] = ACTIONS(324),
    [sym_float] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(686),
    [sym_true] = ACTIONS(324),
    [sym_false] = ACTIONS(324),
    [sym_none] = ACTIONS(324),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(328),
  },
  [161] = {
    [sym_list_splat_pattern] = STATE(1135),
    [sym_primary_expression] = STATE(976),
    [sym_binary_operator] = STATE(1081),
    [sym_unary_operator] = STATE(1081),
    [sym_attribute] = STATE(1081),
    [sym_subscript] = STATE(1081),
    [sym_call] = STATE(1081),
    [sym_list] = STATE(1081),
    [sym_set] = STATE(1081),
    [sym_tuple] = STATE(1081),
    [sym_dictionary] = STATE(1081),
    [sym_list_comprehension] = STATE(1081),
    [sym_dictionary_comprehension] = STATE(1081),
    [sym_set_comprehension] = STATE(1081),
    [sym_generator_expression] = STATE(1081),
    [sym_parenthesized_expression] = STATE(1081),
    [sym_concatenated_string] = STATE(1081),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1081),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_from] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(653),
    [anon_sym_COMMA] = ACTIONS(277),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(655),
    [anon_sym_print] = ACTIONS(657),
    [anon_sym_GT_GT] = ACTIONS(277),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(277),
    [anon_sym_match] = ACTIONS(659),
    [anon_sym_async] = ACTIONS(657),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(277),
    [anon_sym_exec] = ACTIONS(657),
    [anon_sym_type] = ACTIONS(659),
    [anon_sym_EQ] = ACTIONS(279),
    [anon_sym_LBRACK] = ACTIONS(661),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(279),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(277),
    [anon_sym_SLASH_SLASH] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(277),
    [anon_sym_CARET] = ACTIONS(277),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(665),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym_string_start] = ACTIONS(81),
  },
  [162] = {
    [sym_list_splat_pattern] = STATE(1249),
    [sym_primary_expression] = STATE(1014),
    [sym_binary_operator] = STATE(1198),
    [sym_unary_operator] = STATE(1198),
    [sym_attribute] = STATE(1198),
    [sym_subscript] = STATE(1198),
    [sym_call] = STATE(1198),
    [sym_list] = STATE(1198),
    [sym_set] = STATE(1198),
    [sym_tuple] = STATE(1198),
    [sym_dictionary] = STATE(1198),
    [sym_list_comprehension] = STATE(1198),
    [sym_dictionary_comprehension] = STATE(1198),
    [sym_set_comprehension] = STATE(1198),
    [sym_generator_expression] = STATE(1198),
    [sym_parenthesized_expression] = STATE(1198),
    [sym_concatenated_string] = STATE(1198),
    [sym_string] = STATE(983),
    [sym_await] = STATE(1198),
    [sym_identifier] = ACTIONS(688),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(690),
    [anon_sym_COMMA] = ACTIONS(277),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(692),
    [anon_sym_print] = ACTIONS(694),
    [anon_sym_GT_GT] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(279),
    [anon_sym_match] = ACTIONS(696),
    [anon_sym_async] = ACTIONS(694),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(277),
    [anon_sym_exec] = ACTIONS(694),
    [anon_sym_type] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(279),
    [anon_sym_LBRACK] = ACTIONS(698),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(700),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_LBRACE] = ACTIONS(702),
    [anon_sym_RBRACE] = ACTIONS(277),
    [anon_sym_PLUS] = ACTIONS(700),
    [anon_sym_not] = ACTIONS(279),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(277),
    [anon_sym_SLASH_SLASH] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(277),
    [anon_sym_CARET] = ACTIONS(277),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_TILDE] = ACTIONS(700),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [sym_ellipsis] = ACTIONS(704),
    [sym_type_conversion] = ACTIONS(277),
    [sym_integer] = ACTIONS(688),
    [sym_float] = ACTIONS(704),
    [anon_sym_await] = ACTIONS(706),
    [sym_true] = ACTIONS(688),
    [sym_false] = ACTIONS(688),
    [sym_none] = ACTIONS(688),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(708),
  },
  [163] = {
    [sym_list_splat_pattern] = STATE(1325),
    [sym_primary_expression] = STATE(1053),
    [sym_binary_operator] = STATE(1311),
    [sym_unary_operator] = STATE(1311),
    [sym_attribute] = STATE(1311),
    [sym_subscript] = STATE(1311),
    [sym_call] = STATE(1311),
    [sym_list] = STATE(1311),
    [sym_set] = STATE(1311),
    [sym_tuple] = STATE(1311),
    [sym_dictionary] = STATE(1311),
    [sym_list_comprehension] = STATE(1311),
    [sym_dictionary_comprehension] = STATE(1311),
    [sym_set_comprehension] = STATE(1311),
    [sym_generator_expression] = STATE(1311),
    [sym_parenthesized_expression] = STATE(1311),
    [sym_concatenated_string] = STATE(1311),
    [sym_string] = STATE(1025),
    [sym_await] = STATE(1311),
    [sym_identifier] = ACTIONS(324),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(672),
    [anon_sym_COMMA] = ACTIONS(277),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(676),
    [anon_sym_print] = ACTIONS(678),
    [anon_sym_GT_GT] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(279),
    [anon_sym_else] = ACTIONS(279),
    [anon_sym_match] = ACTIONS(680),
    [anon_sym_async] = ACTIONS(678),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(277),
    [anon_sym_exec] = ACTIONS(678),
    [anon_sym_type] = ACTIONS(680),
    [anon_sym_EQ] = ACTIONS(279),
    [anon_sym_LBRACK] = ACTIONS(682),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(316),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_PLUS] = ACTIONS(316),
    [anon_sym_not] = ACTIONS(279),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(277),
    [anon_sym_SLASH_SLASH] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(277),
    [anon_sym_CARET] = ACTIONS(277),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_TILDE] = ACTIONS(316),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [sym_ellipsis] = ACTIONS(322),
    [sym_integer] = ACTIONS(324),
    [sym_float] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(686),
    [sym_true] = ACTIONS(324),
    [sym_false] = ACTIONS(324),
    [sym_none] = ACTIONS(324),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(328),
  },
  [164] = {
    [sym_list_splat_pattern] = STATE(1249),
    [sym_primary_expression] = STATE(1014),
    [sym_binary_operator] = STATE(1198),
    [sym_unary_operator] = STATE(1198),
    [sym_attribute] = STATE(1198),
    [sym_subscript] = STATE(1198),
    [sym_call] = STATE(1198),
    [sym_list] = STATE(1198),
    [sym_set] = STATE(1198),
    [sym_tuple] = STATE(1198),
    [sym_dictionary] = STATE(1198),
    [sym_list_comprehension] = STATE(1198),
    [sym_dictionary_comprehension] = STATE(1198),
    [sym_set_comprehension] = STATE(1198),
    [sym_generator_expression] = STATE(1198),
    [sym_parenthesized_expression] = STATE(1198),
    [sym_concatenated_string] = STATE(1198),
    [sym_string] = STATE(983),
    [sym_await] = STATE(1198),
    [sym_identifier] = ACTIONS(688),
    [anon_sym_DOT] = ACTIONS(669),
    [anon_sym_LPAREN] = ACTIONS(690),
    [anon_sym_COMMA] = ACTIONS(710),
    [anon_sym_as] = ACTIONS(669),
    [anon_sym_STAR] = ACTIONS(692),
    [anon_sym_print] = ACTIONS(694),
    [anon_sym_GT_GT] = ACTIONS(710),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(669),
    [anon_sym_COLON] = ACTIONS(674),
    [anon_sym_match] = ACTIONS(696),
    [anon_sym_async] = ACTIONS(694),
    [anon_sym_for] = ACTIONS(674),
    [anon_sym_in] = ACTIONS(669),
    [anon_sym_STAR_STAR] = ACTIONS(710),
    [anon_sym_exec] = ACTIONS(694),
    [anon_sym_type] = ACTIONS(696),
    [anon_sym_LBRACK] = ACTIONS(698),
    [anon_sym_AT] = ACTIONS(710),
    [anon_sym_DASH] = ACTIONS(700),
    [anon_sym_PIPE] = ACTIONS(710),
    [anon_sym_LBRACE] = ACTIONS(702),
    [anon_sym_RBRACE] = ACTIONS(710),
    [anon_sym_PLUS] = ACTIONS(700),
    [anon_sym_not] = ACTIONS(669),
    [anon_sym_and] = ACTIONS(669),
    [anon_sym_or] = ACTIONS(669),
    [anon_sym_SLASH] = ACTIONS(669),
    [anon_sym_PERCENT] = ACTIONS(710),
    [anon_sym_SLASH_SLASH] = ACTIONS(710),
    [anon_sym_AMP] = ACTIONS(710),
    [anon_sym_CARET] = ACTIONS(710),
    [anon_sym_LT_LT] = ACTIONS(710),
    [anon_sym_TILDE] = ACTIONS(700),
    [anon_sym_is] = ACTIONS(669),
    [anon_sym_LT] = ACTIONS(669),
    [anon_sym_LT_EQ] = ACTIONS(710),
    [anon_sym_EQ_EQ] = ACTIONS(710),
    [anon_sym_BANG_EQ] = ACTIONS(710),
    [anon_sym_GT_EQ] = ACTIONS(710),
    [anon_sym_GT] = ACTIONS(669),
    [anon_sym_LT_GT] = ACTIONS(710),
    [sym_ellipsis] = ACTIONS(704),
    [sym_integer] = ACTIONS(688),
    [sym_float] = ACTIONS(704),
    [anon_sym_await] = ACTIONS(706),
    [sym_true] = ACTIONS(688),
    [sym_false] = ACTIONS(688),
    [sym_none] = ACTIONS(688),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(708),
  },
  [165] = {
    [sym_list_splat_pattern] = STATE(1229),
    [sym_primary_expression] = STATE(999),
    [sym_binary_operator] = STATE(1152),
    [sym_unary_operator] = STATE(1152),
    [sym_attribute] = STATE(1152),
    [sym_subscript] = STATE(1152),
    [sym_call] = STATE(1152),
    [sym_list] = STATE(1152),
    [sym_set] = STATE(1152),
    [sym_tuple] = STATE(1152),
    [sym_dictionary] = STATE(1152),
    [sym_list_comprehension] = STATE(1152),
    [sym_dictionary_comprehension] = STATE(1152),
    [sym_set_comprehension] = STATE(1152),
    [sym_generator_expression] = STATE(1152),
    [sym_parenthesized_expression] = STATE(1152),
    [sym_concatenated_string] = STATE(1152),
    [sym_string] = STATE(980),
    [sym_await] = STATE(1152),
    [sym_identifier] = ACTIONS(713),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(715),
    [anon_sym_COMMA] = ACTIONS(277),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(717),
    [anon_sym_print] = ACTIONS(719),
    [anon_sym_GT_GT] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(279),
    [anon_sym_match] = ACTIONS(721),
    [anon_sym_async] = ACTIONS(719),
    [anon_sym_for] = ACTIONS(279),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(277),
    [anon_sym_exec] = ACTIONS(719),
    [anon_sym_type] = ACTIONS(721),
    [anon_sym_LBRACK] = ACTIONS(723),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(725),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_LBRACE] = ACTIONS(727),
    [anon_sym_RBRACE] = ACTIONS(277),
    [anon_sym_PLUS] = ACTIONS(725),
    [anon_sym_not] = ACTIONS(279),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(277),
    [anon_sym_SLASH_SLASH] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(277),
    [anon_sym_CARET] = ACTIONS(277),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_TILDE] = ACTIONS(725),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [sym_ellipsis] = ACTIONS(729),
    [sym_integer] = ACTIONS(713),
    [sym_float] = ACTIONS(729),
    [anon_sym_await] = ACTIONS(731),
    [sym_true] = ACTIONS(713),
    [sym_false] = ACTIONS(713),
    [sym_none] = ACTIONS(713),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(733),
  },
  [166] = {
    [sym_list_splat_pattern] = STATE(1451),
    [sym_primary_expression] = STATE(1252),
    [sym_binary_operator] = STATE(1462),
    [sym_unary_operator] = STATE(1462),
    [sym_attribute] = STATE(1462),
    [sym_subscript] = STATE(1462),
    [sym_call] = STATE(1462),
    [sym_list] = STATE(1462),
    [sym_set] = STATE(1462),
    [sym_tuple] = STATE(1462),
    [sym_dictionary] = STATE(1462),
    [sym_list_comprehension] = STATE(1462),
    [sym_dictionary_comprehension] = STATE(1462),
    [sym_set_comprehension] = STATE(1462),
    [sym_generator_expression] = STATE(1462),
    [sym_parenthesized_expression] = STATE(1462),
    [sym_concatenated_string] = STATE(1462),
    [sym_string] = STATE(1110),
    [sym_await] = STATE(1462),
    [sym_identifier] = ACTIONS(735),
    [anon_sym_DOT] = ACTIONS(669),
    [anon_sym_LPAREN] = ACTIONS(737),
    [anon_sym_COMMA] = ACTIONS(710),
    [anon_sym_as] = ACTIONS(669),
    [anon_sym_STAR] = ACTIONS(739),
    [anon_sym_print] = ACTIONS(741),
    [anon_sym_GT_GT] = ACTIONS(710),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(669),
    [anon_sym_COLON] = ACTIONS(674),
    [anon_sym_match] = ACTIONS(743),
    [anon_sym_async] = ACTIONS(741),
    [anon_sym_for] = ACTIONS(674),
    [anon_sym_in] = ACTIONS(669),
    [anon_sym_STAR_STAR] = ACTIONS(710),
    [anon_sym_exec] = ACTIONS(741),
    [anon_sym_type] = ACTIONS(743),
    [anon_sym_LBRACK] = ACTIONS(745),
    [anon_sym_RBRACK] = ACTIONS(710),
    [anon_sym_AT] = ACTIONS(710),
    [anon_sym_DASH] = ACTIONS(747),
    [anon_sym_PIPE] = ACTIONS(710),
    [anon_sym_LBRACE] = ACTIONS(749),
    [anon_sym_PLUS] = ACTIONS(747),
    [anon_sym_not] = ACTIONS(669),
    [anon_sym_and] = ACTIONS(669),
    [anon_sym_or] = ACTIONS(669),
    [anon_sym_SLASH] = ACTIONS(669),
    [anon_sym_PERCENT] = ACTIONS(710),
    [anon_sym_SLASH_SLASH] = ACTIONS(710),
    [anon_sym_AMP] = ACTIONS(710),
    [anon_sym_CARET] = ACTIONS(710),
    [anon_sym_LT_LT] = ACTIONS(710),
    [anon_sym_TILDE] = ACTIONS(747),
    [anon_sym_is] = ACTIONS(669),
    [anon_sym_LT] = ACTIONS(669),
    [anon_sym_LT_EQ] = ACTIONS(710),
    [anon_sym_EQ_EQ] = ACTIONS(710),
    [anon_sym_BANG_EQ] = ACTIONS(710),
    [anon_sym_GT_EQ] = ACTIONS(710),
    [anon_sym_GT] = ACTIONS(669),
    [anon_sym_LT_GT] = ACTIONS(710),
    [sym_ellipsis] = ACTIONS(751),
    [sym_integer] = ACTIONS(735),
    [sym_float] = ACTIONS(751),
    [anon_sym_await] = ACTIONS(753),
    [sym_true] = ACTIONS(735),
    [sym_false] = ACTIONS(735),
    [sym_none] = ACTIONS(735),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(755),
  },
  [167] = {
    [sym_list_splat_pattern] = STATE(1390),
    [sym_primary_expression] = STATE(1139),
    [sym_binary_operator] = STATE(1389),
    [sym_unary_operator] = STATE(1389),
    [sym_attribute] = STATE(1389),
    [sym_subscript] = STATE(1389),
    [sym_call] = STATE(1389),
    [sym_list] = STATE(1389),
    [sym_set] = STATE(1389),
    [sym_tuple] = STATE(1389),
    [sym_dictionary] = STATE(1389),
    [sym_list_comprehension] = STATE(1389),
    [sym_dictionary_comprehension] = STATE(1389),
    [sym_set_comprehension] = STATE(1389),
    [sym_generator_expression] = STATE(1389),
    [sym_parenthesized_expression] = STATE(1389),
    [sym_concatenated_string] = STATE(1389),
    [sym_string] = STATE(1044),
    [sym_await] = STATE(1389),
    [sym_identifier] = ACTIONS(757),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(759),
    [anon_sym_RPAREN] = ACTIONS(277),
    [anon_sym_COMMA] = ACTIONS(277),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(761),
    [anon_sym_print] = ACTIONS(763),
    [anon_sym_GT_GT] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_match] = ACTIONS(765),
    [anon_sym_async] = ACTIONS(763),
    [anon_sym_for] = ACTIONS(279),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(277),
    [anon_sym_exec] = ACTIONS(763),
    [anon_sym_type] = ACTIONS(765),
    [anon_sym_EQ] = ACTIONS(767),
    [anon_sym_LBRACK] = ACTIONS(769),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(771),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_LBRACE] = ACTIONS(773),
    [anon_sym_PLUS] = ACTIONS(771),
    [anon_sym_not] = ACTIONS(279),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(277),
    [anon_sym_SLASH_SLASH] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(277),
    [anon_sym_CARET] = ACTIONS(277),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_TILDE] = ACTIONS(771),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [sym_ellipsis] = ACTIONS(775),
    [sym_integer] = ACTIONS(757),
    [sym_float] = ACTIONS(775),
    [anon_sym_await] = ACTIONS(777),
    [sym_true] = ACTIONS(757),
    [sym_false] = ACTIONS(757),
    [sym_none] = ACTIONS(757),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(779),
  },
  [168] = {
    [sym_list_splat_pattern] = STATE(1325),
    [sym_primary_expression] = STATE(1053),
    [sym_binary_operator] = STATE(1311),
    [sym_unary_operator] = STATE(1311),
    [sym_attribute] = STATE(1311),
    [sym_subscript] = STATE(1311),
    [sym_call] = STATE(1311),
    [sym_list] = STATE(1311),
    [sym_set] = STATE(1311),
    [sym_tuple] = STATE(1311),
    [sym_dictionary] = STATE(1311),
    [sym_list_comprehension] = STATE(1311),
    [sym_dictionary_comprehension] = STATE(1311),
    [sym_set_comprehension] = STATE(1311),
    [sym_generator_expression] = STATE(1311),
    [sym_parenthesized_expression] = STATE(1311),
    [sym_concatenated_string] = STATE(1311),
    [sym_string] = STATE(1025),
    [sym_await] = STATE(1311),
    [sym_identifier] = ACTIONS(324),
    [anon_sym_DOT] = ACTIONS(669),
    [anon_sym_LPAREN] = ACTIONS(672),
    [anon_sym_RPAREN] = ACTIONS(667),
    [anon_sym_COMMA] = ACTIONS(667),
    [anon_sym_as] = ACTIONS(674),
    [anon_sym_STAR] = ACTIONS(676),
    [anon_sym_print] = ACTIONS(678),
    [anon_sym_GT_GT] = ACTIONS(710),
    [anon_sym_if] = ACTIONS(674),
    [anon_sym_COLON] = ACTIONS(667),
    [anon_sym_match] = ACTIONS(680),
    [anon_sym_async] = ACTIONS(678),
    [anon_sym_for] = ACTIONS(674),
    [anon_sym_in] = ACTIONS(674),
    [anon_sym_STAR_STAR] = ACTIONS(710),
    [anon_sym_exec] = ACTIONS(678),
    [anon_sym_type] = ACTIONS(680),
    [anon_sym_EQ] = ACTIONS(674),
    [anon_sym_LBRACK] = ACTIONS(682),
    [anon_sym_AT] = ACTIONS(710),
    [anon_sym_DASH] = ACTIONS(316),
    [anon_sym_PIPE] = ACTIONS(710),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_PLUS] = ACTIONS(316),
    [anon_sym_not] = ACTIONS(674),
    [anon_sym_and] = ACTIONS(674),
    [anon_sym_or] = ACTIONS(674),
    [anon_sym_SLASH] = ACTIONS(669),
    [anon_sym_PERCENT] = ACTIONS(710),
    [anon_sym_SLASH_SLASH] = ACTIONS(710),
    [anon_sym_AMP] = ACTIONS(710),
    [anon_sym_CARET] = ACTIONS(710),
    [anon_sym_LT_LT] = ACTIONS(710),
    [anon_sym_TILDE] = ACTIONS(316),
    [anon_sym_is] = ACTIONS(674),
    [anon_sym_LT] = ACTIONS(674),
    [anon_sym_LT_EQ] = ACTIONS(667),
    [anon_sym_EQ_EQ] = ACTIONS(667),
    [anon_sym_BANG_EQ] = ACTIONS(667),
    [anon_sym_GT_EQ] = ACTIONS(667),
    [anon_sym_GT] = ACTIONS(674),
    [anon_sym_LT_GT] = ACTIONS(667),
    [sym_ellipsis] = ACTIONS(322),
    [sym_integer] = ACTIONS(324),
    [sym_float] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(686),
    [sym_true] = ACTIONS(324),
    [sym_false] = ACTIONS(324),
    [sym_none] = ACTIONS(324),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(328),
  },
  [169] = {
    [sym_list_splat_pattern] = STATE(1316),
    [sym_primary_expression] = STATE(1097),
    [sym_binary_operator] = STATE(1418),
    [sym_unary_operator] = STATE(1418),
    [sym_attribute] = STATE(1418),
    [sym_subscript] = STATE(1418),
    [sym_call] = STATE(1418),
    [sym_list] = STATE(1418),
    [sym_set] = STATE(1418),
    [sym_tuple] = STATE(1418),
    [sym_dictionary] = STATE(1418),
    [sym_list_comprehension] = STATE(1418),
    [sym_dictionary_comprehension] = STATE(1418),
    [sym_set_comprehension] = STATE(1418),
    [sym_generator_expression] = STATE(1418),
    [sym_parenthesized_expression] = STATE(1418),
    [sym_concatenated_string] = STATE(1418),
    [sym_string] = STATE(1034),
    [sym_await] = STATE(1418),
    [sym_identifier] = ACTIONS(781),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(783),
    [anon_sym_RPAREN] = ACTIONS(277),
    [anon_sym_COMMA] = ACTIONS(277),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(785),
    [anon_sym_print] = ACTIONS(787),
    [anon_sym_GT_GT] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(279),
    [anon_sym_match] = ACTIONS(789),
    [anon_sym_async] = ACTIONS(787),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(277),
    [anon_sym_exec] = ACTIONS(787),
    [anon_sym_type] = ACTIONS(789),
    [anon_sym_EQ] = ACTIONS(279),
    [anon_sym_LBRACK] = ACTIONS(791),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(793),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_LBRACE] = ACTIONS(795),
    [anon_sym_PLUS] = ACTIONS(793),
    [anon_sym_not] = ACTIONS(279),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(277),
    [anon_sym_SLASH_SLASH] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(277),
    [anon_sym_CARET] = ACTIONS(277),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_TILDE] = ACTIONS(793),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [sym_ellipsis] = ACTIONS(797),
    [sym_integer] = ACTIONS(781),
    [sym_float] = ACTIONS(797),
    [anon_sym_await] = ACTIONS(799),
    [sym_true] = ACTIONS(781),
    [sym_false] = ACTIONS(781),
    [sym_none] = ACTIONS(781),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(801),
  },
  [170] = {
    [sym_list_splat_pattern] = STATE(1200),
    [sym_primary_expression] = STATE(1011),
    [sym_binary_operator] = STATE(1226),
    [sym_unary_operator] = STATE(1226),
    [sym_attribute] = STATE(1226),
    [sym_subscript] = STATE(1226),
    [sym_call] = STATE(1226),
    [sym_list] = STATE(1226),
    [sym_set] = STATE(1226),
    [sym_tuple] = STATE(1226),
    [sym_dictionary] = STATE(1226),
    [sym_list_comprehension] = STATE(1226),
    [sym_dictionary_comprehension] = STATE(1226),
    [sym_set_comprehension] = STATE(1226),
    [sym_generator_expression] = STATE(1226),
    [sym_parenthesized_expression] = STATE(1226),
    [sym_concatenated_string] = STATE(1226),
    [sym_string] = STATE(977),
    [sym_await] = STATE(1226),
    [sym_identifier] = ACTIONS(803),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(805),
    [anon_sym_COMMA] = ACTIONS(277),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(807),
    [anon_sym_print] = ACTIONS(809),
    [anon_sym_GT_GT] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(279),
    [anon_sym_match] = ACTIONS(811),
    [anon_sym_async] = ACTIONS(809),
    [anon_sym_for] = ACTIONS(279),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(277),
    [anon_sym_exec] = ACTIONS(809),
    [anon_sym_type] = ACTIONS(811),
    [anon_sym_LBRACK] = ACTIONS(813),
    [anon_sym_RBRACK] = ACTIONS(277),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(815),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_LBRACE] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(815),
    [anon_sym_not] = ACTIONS(279),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(277),
    [anon_sym_SLASH_SLASH] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(277),
    [anon_sym_CARET] = ACTIONS(277),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_TILDE] = ACTIONS(815),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [sym_ellipsis] = ACTIONS(819),
    [sym_integer] = ACTIONS(803),
    [sym_float] = ACTIONS(819),
    [anon_sym_await] = ACTIONS(821),
    [sym_true] = ACTIONS(803),
    [sym_false] = ACTIONS(803),
    [sym_none] = ACTIONS(803),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(823),
  },
  [171] = {
    [sym_list_splat_pattern] = STATE(1249),
    [sym_primary_expression] = STATE(1014),
    [sym_binary_operator] = STATE(1198),
    [sym_unary_operator] = STATE(1198),
    [sym_attribute] = STATE(1198),
    [sym_subscript] = STATE(1198),
    [sym_call] = STATE(1198),
    [sym_list] = STATE(1198),
    [sym_set] = STATE(1198),
    [sym_tuple] = STATE(1198),
    [sym_dictionary] = STATE(1198),
    [sym_list_comprehension] = STATE(1198),
    [sym_dictionary_comprehension] = STATE(1198),
    [sym_set_comprehension] = STATE(1198),
    [sym_generator_expression] = STATE(1198),
    [sym_parenthesized_expression] = STATE(1198),
    [sym_concatenated_string] = STATE(1198),
    [sym_string] = STATE(983),
    [sym_await] = STATE(1198),
    [sym_identifier] = ACTIONS(688),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(690),
    [anon_sym_COMMA] = ACTIONS(277),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(692),
    [anon_sym_print] = ACTIONS(694),
    [anon_sym_GT_GT] = ACTIONS(277),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(277),
    [anon_sym_match] = ACTIONS(696),
    [anon_sym_async] = ACTIONS(694),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(277),
    [anon_sym_exec] = ACTIONS(694),
    [anon_sym_type] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(279),
    [anon_sym_LBRACK] = ACTIONS(698),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(700),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_LBRACE] = ACTIONS(702),
    [anon_sym_RBRACE] = ACTIONS(277),
    [anon_sym_PLUS] = ACTIONS(700),
    [anon_sym_not] = ACTIONS(279),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(277),
    [anon_sym_SLASH_SLASH] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(277),
    [anon_sym_CARET] = ACTIONS(277),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_TILDE] = ACTIONS(700),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [sym_ellipsis] = ACTIONS(704),
    [sym_type_conversion] = ACTIONS(277),
    [sym_integer] = ACTIONS(688),
    [sym_float] = ACTIONS(704),
    [anon_sym_await] = ACTIONS(706),
    [sym_true] = ACTIONS(688),
    [sym_false] = ACTIONS(688),
    [sym_none] = ACTIONS(688),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(708),
  },
  [172] = {
    [sym_list_splat_pattern] = STATE(1316),
    [sym_primary_expression] = STATE(1097),
    [sym_binary_operator] = STATE(1418),
    [sym_unary_operator] = STATE(1418),
    [sym_attribute] = STATE(1418),
    [sym_subscript] = STATE(1418),
    [sym_call] = STATE(1418),
    [sym_list] = STATE(1418),
    [sym_set] = STATE(1418),
    [sym_tuple] = STATE(1418),
    [sym_dictionary] = STATE(1418),
    [sym_list_comprehension] = STATE(1418),
    [sym_dictionary_comprehension] = STATE(1418),
    [sym_set_comprehension] = STATE(1418),
    [sym_generator_expression] = STATE(1418),
    [sym_parenthesized_expression] = STATE(1418),
    [sym_concatenated_string] = STATE(1418),
    [sym_string] = STATE(1034),
    [sym_await] = STATE(1418),
    [sym_identifier] = ACTIONS(781),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(783),
    [anon_sym_RPAREN] = ACTIONS(277),
    [anon_sym_COMMA] = ACTIONS(277),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(785),
    [anon_sym_print] = ACTIONS(787),
    [anon_sym_GT_GT] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_match] = ACTIONS(789),
    [anon_sym_async] = ACTIONS(787),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(277),
    [anon_sym_exec] = ACTIONS(787),
    [anon_sym_type] = ACTIONS(789),
    [anon_sym_EQ] = ACTIONS(767),
    [anon_sym_LBRACK] = ACTIONS(791),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(793),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_LBRACE] = ACTIONS(795),
    [anon_sym_PLUS] = ACTIONS(793),
    [anon_sym_not] = ACTIONS(279),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(277),
    [anon_sym_SLASH_SLASH] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(277),
    [anon_sym_CARET] = ACTIONS(277),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_TILDE] = ACTIONS(793),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
  