/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.LongAddable;
import com.google.common.hash.Striped64;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

@ElementTypesAreNonnullByDefault
final class LongAdder
extends Striped64
implements Serializable,
LongAddable {
    private static final long serialVersionUID = 7249069246863182397L;

    @Override
    final long fn(long v11, long x11) {
        return v11 + x11;
    }

    @Override
    public void add(long x11) {
        long b11;
        Striped64.Cell[] as2 = this.cells;
        if (this.cells != null || !this.casBase(b11 = this.base, b11 + x11)) {
            long v11;
            Striped64.Cell a11;
            int n11;
            boolean uncontended = true;
            int[] hc2 = (int[])threadHashCode.get();
            if (hc2 == null || as2 == null || (n11 = as2.length) < 1 || (a11 = as2[n11 - 1 & hc2[0]]) == null || !(uncontended = a11.cas(v11 = a11.value, v11 + x11))) {
                this.retryUpdate(x11, hc2, uncontended);
            }
        }
    }

    @Override
    public void increment() {
        this.add(1L);
    }

    public void decrement() {
        this.add(-1L);
    }

    @Override
    public long sum() {
        long sum = this.base;
        Striped64.Cell[] as2 = this.cells;
        if (as2 != null) {
            for (Striped64.Cell a11 : as2) {
                if (a11 == null) continue;
                sum += a11.value;
            }
        }
        return sum;
    }

    public void reset() {
        this.internalReset(0L);
    }

    public long sumThenReset() {
        long sum = this.base;
        Striped64.Cell[] as2 = this.cells;
        this.base = 0L;
        if (as2 != null) {
            for (Striped64.Cell a11 : as2) {
                if (a11 == null) continue;
                sum += a11.value;
                a11.value = 0L;
            }
        }
        return sum;
    }

    public String toString() {
        return Long.toString(this.sum());
    }

    @Override
    public long longValue() {
        return this.sum();
    }

    @Override
    public int intValue() {
        return (int)this.sum();
    }

    @Override
    public float floatValue() {
        return this.sum();
    }

    @Override
    public double doubleValue() {
        return this.sum();
    }

    private void writeObject(ObjectOutputStream s11) throws IOException {
        s11.defaultWriteObject();
        s11.writeLong(this.sum());
    }

    private void readObject(ObjectInputStream s11) throws IOException, ClassNotFoundException {
        s11.defaultReadObject();
        this.busy = 0;
        this.cells = null;
        this.base = s11.readLong();
    }
}

