// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vmwareengine/v1/vmwareengine.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VMWAREENGINE_V1_VMWARE_ENGINE_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VMWAREENGINE_V1_VMWARE_ENGINE_CLIENT_H

#include "google/cloud/vmwareengine/v1/vmware_engine_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace vmwareengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// VMwareEngine manages VMware's private clusters in the Cloud.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class VmwareEngineClient {
 public:
  explicit VmwareEngineClient(
      std::shared_ptr<VmwareEngineConnection> connection, Options opts = {});
  ~VmwareEngineClient();

  ///@{
  /// @name Copy and move support
  VmwareEngineClient(VmwareEngineClient const&) = default;
  VmwareEngineClient& operator=(VmwareEngineClient const&) = default;
  VmwareEngineClient(VmwareEngineClient&&) = default;
  VmwareEngineClient& operator=(VmwareEngineClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(VmwareEngineClient const& a,
                         VmwareEngineClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(VmwareEngineClient const& a,
                         VmwareEngineClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists `PrivateCloud` resources in a given project and location.
  ///
  /// @param parent  Required. The resource name of the private cloud to be queried for
  ///  clusters. Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.PrivateCloud], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListPrivateCloudsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1021}
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L119}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::PrivateCloud> ListPrivateClouds(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists `PrivateCloud` resources in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ListPrivateCloudsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.PrivateCloud], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListPrivateCloudsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1021}
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L119}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::PrivateCloud> ListPrivateClouds(
      google::cloud::vmwareengine::v1::ListPrivateCloudsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves a `PrivateCloud` resource by its resource name.
  ///
  /// @param name  Required. The resource name of the private cloud to retrieve.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.PrivateCloud])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetPrivateCloudRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1100}
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L119}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::PrivateCloud> GetPrivateCloud(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves a `PrivateCloud` resource by its resource name.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.GetPrivateCloudRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.PrivateCloud])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetPrivateCloudRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1100}
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L119}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::PrivateCloud> GetPrivateCloud(
      google::cloud::vmwareengine::v1::GetPrivateCloudRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new `PrivateCloud` resource in a given project and location.
  /// Private clouds of type `STANDARD` and
  /// `TIME_LIMITED` are zonal resources, `STRETCHED` private clouds are
  /// regional.
  /// Creating a private cloud also creates a [management
  /// cluster](https://cloud.google.com/vmware-engine/docs/concepts-vmware-components)
  /// for that private cloud.
  ///
  /// @param parent  Required. The resource name of the location to create the new
  ///  private cloud in. Resource names are schemeless URIs that follow the
  ///  conventions in https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a`
  /// @param private_cloud  Required. The initial description of the new private cloud.
  /// @param private_cloud_id  Required. The user-provided identifier of the private cloud to be created.
  ///  This identifier must be unique among each `PrivateCloud` within the parent
  ///  and becomes the final token in the name URI.
  ///  The identifier must meet the following requirements:
  ///  @n
  ///  * Only contains 1-63 alphanumeric characters and hyphens
  ///  * Begins with an alphabetical character
  ///  * Ends with a non-hyphen character
  ///  * Not formatted as a UUID
  ///  * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
  ///  (section 3.5)
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateCloud] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreatePrivateCloudRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1116}
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L119}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  CreatePrivateCloud(
      std::string const& parent,
      google::cloud::vmwareengine::v1::PrivateCloud const& private_cloud,
      std::string const& private_cloud_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreatePrivateCloud
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreatePrivateCloud(
      NoAwaitTag, std::string const& parent,
      google::cloud::vmwareengine::v1::PrivateCloud const& private_cloud,
      std::string const& private_cloud_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new `PrivateCloud` resource in a given project and location.
  /// Private clouds of type `STANDARD` and
  /// `TIME_LIMITED` are zonal resources, `STRETCHED` private clouds are
  /// regional.
  /// Creating a private cloud also creates a [management
  /// cluster](https://cloud.google.com/vmware-engine/docs/concepts-vmware-components)
  /// for that private cloud.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.CreatePrivateCloudRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateCloud] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreatePrivateCloudRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1116}
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L119}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  CreatePrivateCloud(
      google::cloud::vmwareengine::v1::CreatePrivateCloudRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreatePrivateCloud
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreatePrivateCloud(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::CreatePrivateCloudRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreatePrivateCloud
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  CreatePrivateCloud(google::longrunning::Operation const& operation,
                     Options opts = {});

  // clang-format off
  ///
  /// Modifies a `PrivateCloud` resource. Only the following fields can be
  /// updated: `description`.
  /// Only fields specified in `updateMask` are applied.
  ///
  /// During operation processing, the resource is temporarily in the `ACTIVE`
  /// state before the operation fully completes. For that period of time, you
  /// can't update the resource. Use the operation status to determine when the
  /// processing fully completes.
  ///
  /// @param private_cloud  Required. Private cloud description.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  `PrivateCloud` resource by the update. The fields specified in `updateMask`
  ///  are relative to the resource, not the full request. A field will be
  ///  overwritten if it is in the mask. If the user does not provide a mask then
  ///  all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateCloud] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L119}
  /// [google.cloud.vmwareengine.v1.UpdatePrivateCloudRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1156}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  UpdatePrivateCloud(
      google::cloud::vmwareengine::v1::PrivateCloud const& private_cloud,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdatePrivateCloud
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdatePrivateCloud(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::PrivateCloud const& private_cloud,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Modifies a `PrivateCloud` resource. Only the following fields can be
  /// updated: `description`.
  /// Only fields specified in `updateMask` are applied.
  ///
  /// During operation processing, the resource is temporarily in the `ACTIVE`
  /// state before the operation fully completes. For that period of time, you
  /// can't update the resource. Use the operation status to determine when the
  /// processing fully completes.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.UpdatePrivateCloudRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateCloud] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L119}
  /// [google.cloud.vmwareengine.v1.UpdatePrivateCloudRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1156}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  UpdatePrivateCloud(
      google::cloud::vmwareengine::v1::UpdatePrivateCloudRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdatePrivateCloud
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdatePrivateCloud(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::UpdatePrivateCloudRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdatePrivateCloud
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  UpdatePrivateCloud(google::longrunning::Operation const& operation,
                     Options opts = {});

  // clang-format off
  ///
  /// Schedules a `PrivateCloud` resource for deletion.
  ///
  /// A `PrivateCloud` resource scheduled for deletion has `PrivateCloud.state`
  /// set to `DELETED` and `expireTime` set to the time when deletion is final
  /// and can no longer be reversed. The delete operation is marked as done
  /// as soon as the `PrivateCloud` is successfully scheduled for deletion
  /// (this also applies when `delayHours` is set to zero), and the operation is
  /// not kept in pending state until `PrivateCloud` is purged.
  /// `PrivateCloud` can be restored using `UndeletePrivateCloud` method before
  /// the `expireTime` elapses. When `expireTime` is reached, deletion is final
  /// and all private cloud resources are irreversibly removed and billing stops.
  /// During the final removal process, `PrivateCloud.state` is set to `PURGING`.
  /// `PrivateCloud` can be polled using standard `GET` method for the whole
  /// period of deletion and purging. It will not be returned only
  /// when it is completely purged.
  ///
  /// @param name  Required. The resource name of the private cloud to delete.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateCloud] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeletePrivateCloudRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1175}
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L119}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  DeletePrivateCloud(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeletePrivateCloud
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeletePrivateCloud(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Schedules a `PrivateCloud` resource for deletion.
  ///
  /// A `PrivateCloud` resource scheduled for deletion has `PrivateCloud.state`
  /// set to `DELETED` and `expireTime` set to the time when deletion is final
  /// and can no longer be reversed. The delete operation is marked as done
  /// as soon as the `PrivateCloud` is successfully scheduled for deletion
  /// (this also applies when `delayHours` is set to zero), and the operation is
  /// not kept in pending state until `PrivateCloud` is purged.
  /// `PrivateCloud` can be restored using `UndeletePrivateCloud` method before
  /// the `expireTime` elapses. When `expireTime` is reached, deletion is final
  /// and all private cloud resources are irreversibly removed and billing stops.
  /// During the final removal process, `PrivateCloud.state` is set to `PURGING`.
  /// `PrivateCloud` can be polled using standard `GET` method for the whole
  /// period of deletion and purging. It will not be returned only
  /// when it is completely purged.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.DeletePrivateCloudRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateCloud] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeletePrivateCloudRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1175}
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L119}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  DeletePrivateCloud(
      google::cloud::vmwareengine::v1::DeletePrivateCloudRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeletePrivateCloud
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeletePrivateCloud(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::DeletePrivateCloudRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeletePrivateCloud
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  DeletePrivateCloud(google::longrunning::Operation const& operation,
                     Options opts = {});

  // clang-format off
  ///
  /// Restores a private cloud that was previously scheduled for deletion by
  /// `DeletePrivateCloud`. A `PrivateCloud` resource scheduled for deletion has
  /// `PrivateCloud.state` set to `DELETED` and `PrivateCloud.expireTime` set to
  /// the time when deletion can no longer be reversed.
  ///
  /// @param name  Required. The resource name of the private cloud scheduled for deletion.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateCloud] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L119}
  /// [google.cloud.vmwareengine.v1.UndeletePrivateCloudRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1212}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  UndeletePrivateCloud(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UndeletePrivateCloud
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UndeletePrivateCloud(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Restores a private cloud that was previously scheduled for deletion by
  /// `DeletePrivateCloud`. A `PrivateCloud` resource scheduled for deletion has
  /// `PrivateCloud.state` set to `DELETED` and `PrivateCloud.expireTime` set to
  /// the time when deletion can no longer be reversed.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.UndeletePrivateCloudRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateCloud] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L119}
  /// [google.cloud.vmwareengine.v1.UndeletePrivateCloudRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1212}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  UndeletePrivateCloud(
      google::cloud::vmwareengine::v1::UndeletePrivateCloudRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UndeletePrivateCloud
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UndeletePrivateCloud(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::UndeletePrivateCloudRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UndeletePrivateCloud
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  UndeletePrivateCloud(google::longrunning::Operation const& operation,
                       Options opts = {});

  // clang-format off
  ///
  /// Lists `Cluster` resources in a given private cloud.
  ///
  /// @param parent  Required. The resource name of the private cloud to query for clusters.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.Cluster], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Cluster]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L252}
  /// [google.cloud.vmwareengine.v1.ListClustersRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1232}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::Cluster> ListClusters(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists `Cluster` resources in a given private cloud.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ListClustersRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.Cluster], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Cluster]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L252}
  /// [google.cloud.vmwareengine.v1.ListClustersRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1232}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::Cluster> ListClusters(
      google::cloud::vmwareengine::v1::ListClustersRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves a `Cluster` resource by its resource name.
  ///
  /// @param name  Required. The cluster resource name to retrieve.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/clusters/my-cluster`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.Cluster])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Cluster]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L252}
  /// [google.cloud.vmwareengine.v1.GetClusterRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1299}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::Cluster> GetCluster(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves a `Cluster` resource by its resource name.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.GetClusterRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.Cluster])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Cluster]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L252}
  /// [google.cloud.vmwareengine.v1.GetClusterRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1299}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::Cluster> GetCluster(
      google::cloud::vmwareengine::v1::GetClusterRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new cluster in a given private cloud.
  /// Creating a new cluster provides additional nodes for
  /// use in the parent private cloud and requires sufficient [node
  /// quota](https://cloud.google.com/vmware-engine/quotas).
  ///
  /// @param parent  Required. The resource name of the private cloud to create a new cluster
  ///  in. Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
  /// @param cluster  Required. The initial description of the new cluster.
  /// @param cluster_id  Required. The user-provided identifier of the new `Cluster`.
  ///  This identifier must be unique among clusters within the parent and becomes
  ///  the final token in the name URI.
  ///  The identifier must meet the following requirements:
  ///  @n
  ///  * Only contains 1-63 alphanumeric characters and hyphens
  ///  * Begins with an alphabetical character
  ///  * Ends with a non-hyphen character
  ///  * Not formatted as a UUID
  ///  * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
  ///  (section 3.5)
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.Cluster] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Cluster]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L252}
  /// [google.cloud.vmwareengine.v1.CreateClusterRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1315}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::Cluster>> CreateCluster(
      std::string const& parent,
      google::cloud::vmwareengine::v1::Cluster const& cluster,
      std::string const& cluster_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateCluster
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateCluster(
      NoAwaitTag, std::string const& parent,
      google::cloud::vmwareengine::v1::Cluster const& cluster,
      std::string const& cluster_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new cluster in a given private cloud.
  /// Creating a new cluster provides additional nodes for
  /// use in the parent private cloud and requires sufficient [node
  /// quota](https://cloud.google.com/vmware-engine/quotas).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.CreateClusterRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.Cluster] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Cluster]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L252}
  /// [google.cloud.vmwareengine.v1.CreateClusterRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1315}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::Cluster>> CreateCluster(
      google::cloud::vmwareengine::v1::CreateClusterRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateCluster
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateCluster(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::CreateClusterRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateCluster
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::Cluster>> CreateCluster(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Modifies a `Cluster` resource. Only fields specified in `updateMask` are
  /// applied.
  ///
  /// During operation processing, the resource is temporarily in the `ACTIVE`
  /// state before the operation fully completes. For that period of time, you
  /// can't update the resource. Use the operation status to determine when the
  /// processing fully completes.
  ///
  /// @param cluster  Required. The description of the cluster.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  `Cluster` resource by the update. The fields specified in the `updateMask`
  ///  are relative to the resource, not the full request. A field will be
  ///  overwritten if it is in the mask. If the user does not provide a mask then
  ///  all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.Cluster] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Cluster]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L252}
  /// [google.cloud.vmwareengine.v1.UpdateClusterRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1355}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::Cluster>> UpdateCluster(
      google::cloud::vmwareengine::v1::Cluster const& cluster,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateCluster
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateCluster(
      NoAwaitTag, google::cloud::vmwareengine::v1::Cluster const& cluster,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Modifies a `Cluster` resource. Only fields specified in `updateMask` are
  /// applied.
  ///
  /// During operation processing, the resource is temporarily in the `ACTIVE`
  /// state before the operation fully completes. For that period of time, you
  /// can't update the resource. Use the operation status to determine when the
  /// processing fully completes.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.UpdateClusterRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.Cluster] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Cluster]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L252}
  /// [google.cloud.vmwareengine.v1.UpdateClusterRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1355}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::Cluster>> UpdateCluster(
      google::cloud::vmwareengine::v1::UpdateClusterRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateCluster
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateCluster(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::UpdateClusterRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateCluster
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::Cluster>> UpdateCluster(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Deletes a `Cluster` resource. To avoid unintended data loss, migrate or
  /// gracefully shut down any workloads running on the cluster before deletion.
  /// You cannot delete the management cluster of a private cloud using this
  /// method.
  ///
  /// @param name  Required. The resource name of the cluster to delete.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/clusters/my-cluster`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeleteClusterRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1378}
  /// [google.cloud.vmwareengine.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2195}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteCluster(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteCluster
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteCluster(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a `Cluster` resource. To avoid unintended data loss, migrate or
  /// gracefully shut down any workloads running on the cluster before deletion.
  /// You cannot delete the management cluster of a private cloud using this
  /// method.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.DeleteClusterRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeleteClusterRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1378}
  /// [google.cloud.vmwareengine.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2195}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteCluster(
      google::cloud::vmwareengine::v1::DeleteClusterRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteCluster
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteCluster(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::DeleteClusterRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteCluster
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteCluster(google::longrunning::Operation const& operation,
                Options opts = {});

  // clang-format off
  ///
  /// Lists nodes in a given cluster.
  ///
  /// @param parent  Required. The resource name of the cluster to be queried for nodes.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/clusters/my-cluster`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.Node], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListNodesRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1398}
  /// [google.cloud.vmwareengine.v1.Node]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L323}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::Node> ListNodes(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists nodes in a given cluster.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ListNodesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.Node], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListNodesRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1398}
  /// [google.cloud.vmwareengine.v1.Node]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L323}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::Node> ListNodes(
      google::cloud::vmwareengine::v1::ListNodesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single node.
  ///
  /// @param name  Required. The resource name of the node to retrieve.
  ///  For example:
  ///  `projects/{project}/locations/{location}/privateClouds/{private_cloud}/clusters/{cluster}/nodes/{node}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.Node])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetNodeRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1439}
  /// [google.cloud.vmwareengine.v1.Node]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L323}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::Node> GetNode(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single node.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.GetNodeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.Node])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetNodeRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1439}
  /// [google.cloud.vmwareengine.v1.Node]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L323}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::Node> GetNode(
      google::cloud::vmwareengine::v1::GetNodeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists external IP addresses assigned to VMware workload VMs in a given
  /// private cloud.
  ///
  /// @param parent  Required. The resource name of the private cloud to be queried for
  ///  external IP addresses.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.ExternalAddress], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ExternalAddress]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L378}
  /// [google.cloud.vmwareengine.v1.ListExternalAddressesRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1453}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::ExternalAddress>
  ListExternalAddresses(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists external IP addresses assigned to VMware workload VMs in a given
  /// private cloud.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ListExternalAddressesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.ExternalAddress], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ExternalAddress]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L378}
  /// [google.cloud.vmwareengine.v1.ListExternalAddressesRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1453}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::ExternalAddress>
  ListExternalAddresses(
      google::cloud::vmwareengine::v1::ListExternalAddressesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists external IP addresses assigned to VMware workload VMs within the
  /// scope of the given network policy.
  ///
  /// @param network_policy  Required. The resource name of the network policy to query for assigned
  ///  external IP addresses. Resource names are schemeless URIs that follow the
  ///  conventions in https://cloud.google.com/apis/design/resource_names. For
  ///  example:
  ///  `projects/my-project/locations/us-central1/networkPolicies/my-policy`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.ExternalAddress], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ExternalAddress]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L378}
  /// [google.cloud.vmwareengine.v1.FetchNetworkPolicyExternalAddressesRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1532}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::ExternalAddress>
  FetchNetworkPolicyExternalAddresses(std::string const& network_policy,
                                      Options opts = {});

  // clang-format off
  ///
  /// Lists external IP addresses assigned to VMware workload VMs within the
  /// scope of the given network policy.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.FetchNetworkPolicyExternalAddressesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.ExternalAddress], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ExternalAddress]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L378}
  /// [google.cloud.vmwareengine.v1.FetchNetworkPolicyExternalAddressesRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1532}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::ExternalAddress>
  FetchNetworkPolicyExternalAddresses(
      google::cloud::vmwareengine::v1::
          FetchNetworkPolicyExternalAddressesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single external IP address.
  ///
  /// @param name  Required. The resource name of the external IP address to retrieve.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/externalAddresses/my-ip`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.ExternalAddress])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ExternalAddress]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L378}
  /// [google.cloud.vmwareengine.v1.GetExternalAddressRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1575}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::ExternalAddress> GetExternalAddress(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single external IP address.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.GetExternalAddressRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.ExternalAddress])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ExternalAddress]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L378}
  /// [google.cloud.vmwareengine.v1.GetExternalAddressRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1575}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::ExternalAddress> GetExternalAddress(
      google::cloud::vmwareengine::v1::GetExternalAddressRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new `ExternalAddress` resource in a given private cloud. The
  /// network policy that corresponds to the private cloud must have the external
  /// IP address network service enabled (`NetworkPolicy.external_ip`).
  ///
  /// @param parent  Required. The resource name of the private cloud
  ///  to create a new external IP address in.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
  /// @param external_address  Required. The initial description of a new external IP address.
  /// @param external_address_id  Required. The user-provided identifier of the `ExternalAddress` to be
  ///  created. This identifier must be unique among `ExternalAddress` resources
  ///  within the parent and becomes the final token in the name URI. The
  ///  identifier must meet the following requirements:
  ///  @n
  ///  * Only contains 1-63 alphanumeric characters and hyphens
  ///  * Begins with an alphabetical character
  ///  * Ends with a non-hyphen character
  ///  * Not formatted as a UUID
  ///  * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
  ///  (section 3.5)
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.ExternalAddress] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreateExternalAddressRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1591}
  /// [google.cloud.vmwareengine.v1.ExternalAddress]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L378}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::ExternalAddress>>
  CreateExternalAddress(
      std::string const& parent,
      google::cloud::vmwareengine::v1::ExternalAddress const& external_address,
      std::string const& external_address_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateExternalAddress
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateExternalAddress(
      NoAwaitTag, std::string const& parent,
      google::cloud::vmwareengine::v1::ExternalAddress const& external_address,
      std::string const& external_address_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new `ExternalAddress` resource in a given private cloud. The
  /// network policy that corresponds to the private cloud must have the external
  /// IP address network service enabled (`NetworkPolicy.external_ip`).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.CreateExternalAddressRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.ExternalAddress] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreateExternalAddressRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1591}
  /// [google.cloud.vmwareengine.v1.ExternalAddress]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L378}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::ExternalAddress>>
  CreateExternalAddress(
      google::cloud::vmwareengine::v1::CreateExternalAddressRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateExternalAddress
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateExternalAddress(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::CreateExternalAddressRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateExternalAddress
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::ExternalAddress>>
  CreateExternalAddress(google::longrunning::Operation const& operation,
                        Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single external IP address.
  /// Only fields specified in `update_mask` are applied.
  ///
  /// During operation processing, the resource is temporarily in the `ACTIVE`
  /// state before the operation fully completes. For that period of time, you
  /// can't update the resource. Use the operation status to determine when the
  /// processing fully completes.
  ///
  /// @param external_address  Required. External IP address description.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  `ExternalAddress` resource by the update.
  ///  The fields specified in the `update_mask` are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.ExternalAddress] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ExternalAddress]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L378}
  /// [google.cloud.vmwareengine.v1.UpdateExternalAddressRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1640}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::ExternalAddress>>
  UpdateExternalAddress(
      google::cloud::vmwareengine::v1::ExternalAddress const& external_address,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateExternalAddress
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateExternalAddress(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::ExternalAddress const& external_address,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single external IP address.
  /// Only fields specified in `update_mask` are applied.
  ///
  /// During operation processing, the resource is temporarily in the `ACTIVE`
  /// state before the operation fully completes. For that period of time, you
  /// can't update the resource. Use the operation status to determine when the
  /// processing fully completes.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.UpdateExternalAddressRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.ExternalAddress] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ExternalAddress]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L378}
  /// [google.cloud.vmwareengine.v1.UpdateExternalAddressRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1640}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::ExternalAddress>>
  UpdateExternalAddress(
      google::cloud::vmwareengine::v1::UpdateExternalAddressRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateExternalAddress
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateExternalAddress(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::UpdateExternalAddressRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateExternalAddress
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::ExternalAddress>>
  UpdateExternalAddress(google::longrunning::Operation const& operation,
                        Options opts = {});

  // clang-format off
  ///
  /// Deletes a single external IP address. When you delete an external IP
  /// address, connectivity between the external IP address and the corresponding
  /// internal IP address is lost.
  ///
  /// @param name  Required. The resource name of the external IP address to delete.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/externalAddresses/my-ip`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeleteExternalAddressRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1671}
  /// [google.cloud.vmwareengine.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2195}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteExternalAddress(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteExternalAddress
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteExternalAddress(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single external IP address. When you delete an external IP
  /// address, connectivity between the external IP address and the corresponding
  /// internal IP address is lost.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.DeleteExternalAddressRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeleteExternalAddressRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1671}
  /// [google.cloud.vmwareengine.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2195}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteExternalAddress(
      google::cloud::vmwareengine::v1::DeleteExternalAddressRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteExternalAddress
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteExternalAddress(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::DeleteExternalAddressRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteExternalAddress
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteExternalAddress(google::longrunning::Operation const& operation,
                        Options opts = {});

  // clang-format off
  ///
  /// Lists subnets in a given private cloud.
  ///
  /// @param parent  Required. The resource name of the private cloud to be queried for
  ///  subnets.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.Subnet], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListSubnetsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1703}
  /// [google.cloud.vmwareengine.v1.Subnet]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L435}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::Subnet> ListSubnets(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists subnets in a given private cloud.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ListSubnetsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.Subnet], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListSubnetsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1703}
  /// [google.cloud.vmwareengine.v1.Subnet]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L435}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::Subnet> ListSubnets(
      google::cloud::vmwareengine::v1::ListSubnetsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single subnet.
  ///
  /// @param name  Required. The resource name of the subnet to retrieve.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/subnets/my-subnet`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.Subnet])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetSubnetRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1748}
  /// [google.cloud.vmwareengine.v1.Subnet]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L435}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::Subnet> GetSubnet(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single subnet.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.GetSubnetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.Subnet])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetSubnetRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1748}
  /// [google.cloud.vmwareengine.v1.Subnet]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L435}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::Subnet> GetSubnet(
      google::cloud::vmwareengine::v1::GetSubnetRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single subnet. Only fields specified in
  /// `update_mask` are applied.
  ///
  /// *Note*: This API is synchronous and always returns a successful
  /// `google.longrunning.Operation` (LRO). The returned LRO will only have
  /// `done` and `response` fields.
  ///
  /// @param subnet  Required. Subnet description.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  `Subnet` resource by the update.
  ///  The fields specified in the `update_mask` are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.Subnet] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Subnet]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L435}
  /// [google.cloud.vmwareengine.v1.UpdateSubnetRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1764}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::Subnet>> UpdateSubnet(
      google::cloud::vmwareengine::v1::Subnet const& subnet,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateSubnet
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateSubnet(
      NoAwaitTag, google::cloud::vmwareengine::v1::Subnet const& subnet,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single subnet. Only fields specified in
  /// `update_mask` are applied.
  ///
  /// *Note*: This API is synchronous and always returns a successful
  /// `google.longrunning.Operation` (LRO). The returned LRO will only have
  /// `done` and `response` fields.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.UpdateSubnetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.Subnet] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Subnet]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L435}
  /// [google.cloud.vmwareengine.v1.UpdateSubnetRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1764}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::Subnet>> UpdateSubnet(
      google::cloud::vmwareengine::v1::UpdateSubnetRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateSubnet
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateSubnet(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::UpdateSubnetRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateSubnet
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::Subnet>> UpdateSubnet(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Lists `ExternalAccessRule` resources in the specified network policy.
  ///
  /// @param parent  Required. The resource name of the network policy to query for external
  ///  access firewall rules. Resource names are schemeless URIs that follow the
  ///  conventions in https://cloud.google.com/apis/design/resource_names. For
  ///  example:
  ///  `projects/my-project/locations/us-central1/networkPolicies/my-policy`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.ExternalAccessRule], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ExternalAccessRule]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L493}
  /// [google.cloud.vmwareengine.v1.ListExternalAccessRulesRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1779}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::ExternalAccessRule>
  ListExternalAccessRules(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists `ExternalAccessRule` resources in the specified network policy.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ListExternalAccessRulesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.ExternalAccessRule], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ExternalAccessRule]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L493}
  /// [google.cloud.vmwareengine.v1.ListExternalAccessRulesRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1779}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::ExternalAccessRule>
  ListExternalAccessRules(
      google::cloud::vmwareengine::v1::ListExternalAccessRulesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single external access rule.
  ///
  /// @param name  Required. The resource name of the external access firewall rule to
  ///  retrieve. Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1/networkPolicies/my-policy/externalAccessRules/my-rule`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.ExternalAccessRule])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ExternalAccessRule]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L493}
  /// [google.cloud.vmwareengine.v1.GetExternalAccessRuleRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1858}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::ExternalAccessRule>
  GetExternalAccessRule(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single external access rule.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.GetExternalAccessRuleRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.ExternalAccessRule])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ExternalAccessRule]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L493}
  /// [google.cloud.vmwareengine.v1.GetExternalAccessRuleRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1858}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::ExternalAccessRule>
  GetExternalAccessRule(
      google::cloud::vmwareengine::v1::GetExternalAccessRuleRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new external access rule in a given network policy.
  ///
  /// @param parent  Required. The resource name of the network policy
  ///  to create a new external access firewall rule in.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1/networkPolicies/my-policy`
  /// @param external_access_rule  Required. The initial description of a new external access rule.
  /// @param external_access_rule_id  Required. The user-provided identifier of the `ExternalAccessRule` to be
  ///  created. This identifier must be unique among `ExternalAccessRule`
  ///  resources within the parent and becomes the final token in the name URI.
  ///  The identifier must meet the following requirements:
  ///  @n
  ///  * Only contains 1-63 alphanumeric characters and hyphens
  ///  * Begins with an alphabetical character
  ///  * Ends with a non-hyphen character
  ///  * Not formatted as a UUID
  ///  * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
  ///  (section 3.5)
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.ExternalAccessRule] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreateExternalAccessRuleRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1874}
  /// [google.cloud.vmwareengine.v1.ExternalAccessRule]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L493}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::ExternalAccessRule>>
  CreateExternalAccessRule(
      std::string const& parent,
      google::cloud::vmwareengine::v1::ExternalAccessRule const&
          external_access_rule,
      std::string const& external_access_rule_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateExternalAccessRule
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateExternalAccessRule(
      NoAwaitTag, std::string const& parent,
      google::cloud::vmwareengine::v1::ExternalAccessRule const&
          external_access_rule,
      std::string const& external_access_rule_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new external access rule in a given network policy.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.CreateExternalAccessRuleRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.ExternalAccessRule] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreateExternalAccessRuleRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1874}
  /// [google.cloud.vmwareengine.v1.ExternalAccessRule]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L493}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::ExternalAccessRule>>
  CreateExternalAccessRule(
      google::cloud::vmwareengine::v1::CreateExternalAccessRuleRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateExternalAccessRule
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateExternalAccessRule(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::CreateExternalAccessRuleRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateExternalAccessRule
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::ExternalAccessRule>>
  CreateExternalAccessRule(google::longrunning::Operation const& operation,
                           Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single external access rule.
  /// Only fields specified in `update_mask` are applied.
  ///
  /// @param external_access_rule  Required. Description of the external access rule.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  `ExternalAccessRule` resource by the update.
  ///  The fields specified in the `update_mask` are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.ExternalAccessRule] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ExternalAccessRule]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L493}
  /// [google.cloud.vmwareengine.v1.UpdateExternalAccessRuleRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1924}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::ExternalAccessRule>>
  UpdateExternalAccessRule(
      google::cloud::vmwareengine::v1::ExternalAccessRule const&
          external_access_rule,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateExternalAccessRule
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateExternalAccessRule(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::ExternalAccessRule const&
          external_access_rule,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single external access rule.
  /// Only fields specified in `update_mask` are applied.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.UpdateExternalAccessRuleRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.ExternalAccessRule] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ExternalAccessRule]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L493}
  /// [google.cloud.vmwareengine.v1.UpdateExternalAccessRuleRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1924}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::ExternalAccessRule>>
  UpdateExternalAccessRule(
      google::cloud::vmwareengine::v1::UpdateExternalAccessRuleRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateExternalAccessRule
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateExternalAccessRule(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::UpdateExternalAccessRuleRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateExternalAccessRule
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::ExternalAccessRule>>
  UpdateExternalAccessRule(google::longrunning::Operation const& operation,
                           Options opts = {});

  // clang-format off
  ///
  /// Deletes a single external access rule.
  ///
  /// @param name  Required. The resource name of the external access firewall rule to delete.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1/networkPolicies/my-policy/externalAccessRules/my-rule`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeleteExternalAccessRuleRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1956}
  /// [google.cloud.vmwareengine.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2195}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteExternalAccessRule(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteExternalAccessRule
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteExternalAccessRule(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single external access rule.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.DeleteExternalAccessRuleRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeleteExternalAccessRuleRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1956}
  /// [google.cloud.vmwareengine.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2195}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteExternalAccessRule(
      google::cloud::vmwareengine::v1::DeleteExternalAccessRuleRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteExternalAccessRule
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteExternalAccessRule(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::DeleteExternalAccessRuleRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteExternalAccessRule
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteExternalAccessRule(google::longrunning::Operation const& operation,
                           Options opts = {});

  // clang-format off
  ///
  /// Lists logging servers configured for a given private
  /// cloud.
  ///
  /// @param parent  Required. The resource name of the private cloud to be queried for
  ///  logging servers.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.LoggingServer], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListLoggingServersRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1988}
  /// [google.cloud.vmwareengine.v1.LoggingServer]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L625}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::LoggingServer>
  ListLoggingServers(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists logging servers configured for a given private
  /// cloud.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ListLoggingServersRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.LoggingServer], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListLoggingServersRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1988}
  /// [google.cloud.vmwareengine.v1.LoggingServer]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L625}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::LoggingServer>
  ListLoggingServers(
      google::cloud::vmwareengine::v1::ListLoggingServersRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a logging server.
  ///
  /// @param name  Required. The resource name of the Logging Server to retrieve.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/loggingServers/my-logging-server`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.LoggingServer])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetLoggingServerRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2068}
  /// [google.cloud.vmwareengine.v1.LoggingServer]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L625}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::LoggingServer> GetLoggingServer(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a logging server.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.GetLoggingServerRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.LoggingServer])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetLoggingServerRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2068}
  /// [google.cloud.vmwareengine.v1.LoggingServer]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L625}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::LoggingServer> GetLoggingServer(
      google::cloud::vmwareengine::v1::GetLoggingServerRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Create a new logging server for a given private cloud.
  ///
  /// @param parent  Required. The resource name of the private cloud
  ///  to create a new Logging Server in.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
  /// @param logging_server  Required. The initial description of a new logging server.
  /// @param logging_server_id  Required. The user-provided identifier of the `LoggingServer` to be
  ///  created. This identifier must be unique among `LoggingServer` resources
  ///  within the parent and becomes the final token in the name URI.
  ///  The identifier must meet the following requirements:
  ///  @n
  ///  * Only contains 1-63 alphanumeric characters and hyphens
  ///  * Begins with an alphabetical character
  ///  * Ends with a non-hyphen character
  ///  * Not formatted as a UUID
  ///  * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
  ///  (section 3.5)
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.LoggingServer] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreateLoggingServerRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2084}
  /// [google.cloud.vmwareengine.v1.LoggingServer]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L625}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::LoggingServer>>
  CreateLoggingServer(
      std::string const& parent,
      google::cloud::vmwareengine::v1::LoggingServer const& logging_server,
      std::string const& logging_server_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateLoggingServer
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateLoggingServer(
      NoAwaitTag, std::string const& parent,
      google::cloud::vmwareengine::v1::LoggingServer const& logging_server,
      std::string const& logging_server_id, Options opts = {});

  // clang-format off
  ///
  /// Create a new logging server for a given private cloud.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.CreateLoggingServerRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.LoggingServer] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreateLoggingServerRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2084}
  /// [google.cloud.vmwareengine.v1.LoggingServer]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L625}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::LoggingServer>>
  CreateLoggingServer(
      google::cloud::vmwareengine::v1::CreateLoggingServerRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateLoggingServer
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateLoggingServer(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::CreateLoggingServerRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateLoggingServer
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::LoggingServer>>
  CreateLoggingServer(google::longrunning::Operation const& operation,
                      Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single logging server.
  /// Only fields specified in `update_mask` are applied.
  ///
  /// @param logging_server  Required. Logging server description.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  `LoggingServer` resource by the update.
  ///  The fields specified in the `update_mask` are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.LoggingServer] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.LoggingServer]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L625}
  /// [google.cloud.vmwareengine.v1.UpdateLoggingServerRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2133}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::LoggingServer>>
  UpdateLoggingServer(
      google::cloud::vmwareengine::v1::LoggingServer const& logging_server,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateLoggingServer
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateLoggingServer(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::LoggingServer const& logging_server,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single logging server.
  /// Only fields specified in `update_mask` are applied.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.UpdateLoggingServerRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.LoggingServer] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.LoggingServer]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L625}
  /// [google.cloud.vmwareengine.v1.UpdateLoggingServerRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2133}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::LoggingServer>>
  UpdateLoggingServer(
      google::cloud::vmwareengine::v1::UpdateLoggingServerRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateLoggingServer
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateLoggingServer(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::UpdateLoggingServerRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateLoggingServer
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::LoggingServer>>
  UpdateLoggingServer(google::longrunning::Operation const& operation,
                      Options opts = {});

  // clang-format off
  ///
  /// Deletes a single logging server.
  ///
  /// @param name  Required. The resource name of the logging server to delete.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/loggingServers/my-logging-server`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeleteLoggingServerRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2164}
  /// [google.cloud.vmwareengine.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2195}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteLoggingServer(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteLoggingServer
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteLoggingServer(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single logging server.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.DeleteLoggingServerRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeleteLoggingServerRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2164}
  /// [google.cloud.vmwareengine.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2195}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteLoggingServer(
      google::cloud::vmwareengine::v1::DeleteLoggingServerRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteLoggingServer
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteLoggingServer(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::DeleteLoggingServerRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteLoggingServer
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteLoggingServer(google::longrunning::Operation const& operation,
                      Options opts = {});

  // clang-format off
  ///
  /// Lists node types
  ///
  /// @param parent  Required. The resource name of the location to be queried for node types.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.NodeType], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListNodeTypesRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2227}
  /// [google.cloud.vmwareengine.v1.NodeType]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L699}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::NodeType> ListNodeTypes(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists node types
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ListNodeTypesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.NodeType], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListNodeTypesRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2227}
  /// [google.cloud.vmwareengine.v1.NodeType]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L699}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::NodeType> ListNodeTypes(
      google::cloud::vmwareengine::v1::ListNodeTypesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single `NodeType`.
  ///
  /// @param name  Required. The resource name of the node type to retrieve.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-proj/locations/us-central1-a/nodeTypes/standard-72`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.NodeType])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetNodeTypeRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2298}
  /// [google.cloud.vmwareengine.v1.NodeType]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L699}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::NodeType> GetNodeType(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single `NodeType`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.GetNodeTypeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.NodeType])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetNodeTypeRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2298}
  /// [google.cloud.vmwareengine.v1.NodeType]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L699}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::NodeType> GetNodeType(
      google::cloud::vmwareengine::v1::GetNodeTypeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of credentials for NSX appliance.
  ///
  /// @param private_cloud  Required. The resource name of the private cloud
  ///  to be queried for credentials.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.Credentials])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Credentials]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L772}
  /// [google.cloud.vmwareengine.v1.ShowNsxCredentialsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2314}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::Credentials> ShowNsxCredentials(
      std::string const& private_cloud, Options opts = {});

  // clang-format off
  ///
  /// Gets details of credentials for NSX appliance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ShowNsxCredentialsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.Credentials])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Credentials]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L772}
  /// [google.cloud.vmwareengine.v1.ShowNsxCredentialsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2314}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::Credentials> ShowNsxCredentials(
      google::cloud::vmwareengine::v1::ShowNsxCredentialsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of credentials for Vcenter appliance.
  ///
  /// @param private_cloud  Required. The resource name of the private cloud
  ///  to be queried for credentials.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.Credentials])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Credentials]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L772}
  /// [google.cloud.vmwareengine.v1.ShowVcenterCredentialsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2331}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::Credentials> ShowVcenterCredentials(
      std::string const& private_cloud, Options opts = {});

  // clang-format off
  ///
  /// Gets details of credentials for Vcenter appliance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ShowVcenterCredentialsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.Credentials])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Credentials]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L772}
  /// [google.cloud.vmwareengine.v1.ShowVcenterCredentialsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2331}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::Credentials> ShowVcenterCredentials(
      google::cloud::vmwareengine::v1::ShowVcenterCredentialsRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Resets credentials of the NSX appliance.
  ///
  /// @param private_cloud  Required. The resource name of the private cloud
  ///  to reset credentials for.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateCloud] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L119}
  /// [google.cloud.vmwareengine.v1.ResetNsxCredentialsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2360}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  ResetNsxCredentials(std::string const& private_cloud, Options opts = {});

  // clang-format off
  ///
  /// @copybrief ResetNsxCredentials
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ResetNsxCredentials(
      NoAwaitTag, std::string const& private_cloud, Options opts = {});

  // clang-format off
  ///
  /// Resets credentials of the NSX appliance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ResetNsxCredentialsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateCloud] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L119}
  /// [google.cloud.vmwareengine.v1.ResetNsxCredentialsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2360}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  ResetNsxCredentials(
      google::cloud::vmwareengine::v1::ResetNsxCredentialsRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ResetNsxCredentials
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ResetNsxCredentials(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::ResetNsxCredentialsRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ResetNsxCredentials
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  ResetNsxCredentials(google::longrunning::Operation const& operation,
                      Options opts = {});

  // clang-format off
  ///
  /// Resets credentials of the Vcenter appliance.
  ///
  /// @param private_cloud  Required. The resource name of the private cloud
  ///  to reset credentials for.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateCloud] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L119}
  /// [google.cloud.vmwareengine.v1.ResetVcenterCredentialsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2393}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  ResetVcenterCredentials(std::string const& private_cloud, Options opts = {});

  // clang-format off
  ///
  /// @copybrief ResetVcenterCredentials
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ResetVcenterCredentials(
      NoAwaitTag, std::string const& private_cloud, Options opts = {});

  // clang-format off
  ///
  /// Resets credentials of the Vcenter appliance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ResetVcenterCredentialsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateCloud] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L119}
  /// [google.cloud.vmwareengine.v1.ResetVcenterCredentialsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2393}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  ResetVcenterCredentials(
      google::cloud::vmwareengine::v1::ResetVcenterCredentialsRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ResetVcenterCredentials
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ResetVcenterCredentials(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::ResetVcenterCredentialsRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ResetVcenterCredentials
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  ResetVcenterCredentials(google::longrunning::Operation const& operation,
                          Options opts = {});

  // clang-format off
  ///
  /// Gets details of the `DnsForwarding` config.
  ///
  /// @param name  Required. The resource name of a `DnsForwarding` to retrieve.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/dnsForwarding`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.DnsForwarding])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DnsForwarding]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L995}
  /// [google.cloud.vmwareengine.v1.GetDnsForwardingRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2548}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::DnsForwarding> GetDnsForwarding(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of the `DnsForwarding` config.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.GetDnsForwardingRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.DnsForwarding])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DnsForwarding]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L995}
  /// [google.cloud.vmwareengine.v1.GetDnsForwardingRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2548}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::DnsForwarding> GetDnsForwarding(
      google::cloud::vmwareengine::v1::GetDnsForwardingRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of the `DnsForwarding` config, like associated
  /// domains. Only fields specified in `update_mask` are applied.
  ///
  /// @param dns_forwarding  Required. DnsForwarding config details.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  `DnsForwarding` resource by the update.
  ///  The fields specified in the `update_mask` are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.DnsForwarding] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DnsForwarding]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L995}
  /// [google.cloud.vmwareengine.v1.UpdateDnsForwardingRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2564}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::DnsForwarding>>
  UpdateDnsForwarding(
      google::cloud::vmwareengine::v1::DnsForwarding const& dns_forwarding,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateDnsForwarding
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateDnsForwarding(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::DnsForwarding const& dns_forwarding,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of the `DnsForwarding` config, like associated
  /// domains. Only fields specified in `update_mask` are applied.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.UpdateDnsForwardingRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.DnsForwarding] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DnsForwarding]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L995}
  /// [google.cloud.vmwareengine.v1.UpdateDnsForwardingRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2564}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::DnsForwarding>>
  UpdateDnsForwarding(
      google::cloud::vmwareengine::v1::UpdateDnsForwardingRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateDnsForwarding
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateDnsForwarding(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::UpdateDnsForwardingRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateDnsForwarding
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::DnsForwarding>>
  UpdateDnsForwarding(google::longrunning::Operation const& operation,
                      Options opts = {});

  // clang-format off
  ///
  /// Retrieves a `NetworkPeering` resource by its resource name. The resource
  /// contains details of the network peering, such as peered
  /// networks, import and export custom route configurations, and peering state.
  /// NetworkPeering is a global resource and location can only be global.
  ///
  /// @param name  Required. The resource name of the network peering to retrieve.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/global/networkPeerings/my-peering`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.NetworkPeering])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetNetworkPeeringRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2675}
  /// [google.cloud.vmwareengine.v1.NetworkPeering]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1034}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::NetworkPeering> GetNetworkPeering(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves a `NetworkPeering` resource by its resource name. The resource
  /// contains details of the network peering, such as peered
  /// networks, import and export custom route configurations, and peering state.
  /// NetworkPeering is a global resource and location can only be global.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.GetNetworkPeeringRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.NetworkPeering])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetNetworkPeeringRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2675}
  /// [google.cloud.vmwareengine.v1.NetworkPeering]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1034}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::NetworkPeering> GetNetworkPeering(
      google::cloud::vmwareengine::v1::GetNetworkPeeringRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists `NetworkPeering` resources in a given project. NetworkPeering is a
  /// global resource and location can only be global.
  ///
  /// @param parent  Required. The resource name of the location (global) to query for
  ///  network peerings. Resource names are schemeless URIs that follow the
  ///  conventions in https://cloud.google.com/apis/design/resource_names. For
  ///  example: `projects/my-project/locations/global`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.NetworkPeering], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListNetworkPeeringsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2691}
  /// [google.cloud.vmwareengine.v1.NetworkPeering]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1034}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::NetworkPeering>
  ListNetworkPeerings(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists `NetworkPeering` resources in a given project. NetworkPeering is a
  /// global resource and location can only be global.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ListNetworkPeeringsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.NetworkPeering], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListNetworkPeeringsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2691}
  /// [google.cloud.vmwareengine.v1.NetworkPeering]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1034}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::NetworkPeering>
  ListNetworkPeerings(
      google::cloud::vmwareengine::v1::ListNetworkPeeringsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new network peering between the peer network and VMware Engine
  /// network provided in a `NetworkPeering` resource. NetworkPeering is a
  /// global resource and location can only be global.
  ///
  /// @param parent  Required. The resource name of the location to create the new network
  ///  peering in. This value is always `global`, because `NetworkPeering` is a
  ///  global resource. Resource names are schemeless URIs that follow the
  ///  conventions in https://cloud.google.com/apis/design/resource_names. For
  ///  example: `projects/my-project/locations/global`
  /// @param network_peering  Required. The initial description of the new network peering.
  /// @param network_peering_id  Required. The user-provided identifier of the new `NetworkPeering`.
  ///  This identifier must be unique among `NetworkPeering` resources within the
  ///  parent and becomes the final token in the name URI.
  ///  The identifier must meet the following requirements:
  ///  @n
  ///  * Only contains 1-63 alphanumeric characters and hyphens
  ///  * Begins with an alphabetical character
  ///  * Ends with a non-hyphen character
  ///  * Not formatted as a UUID
  ///  * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
  ///  (section 3.5)
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.NetworkPeering] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreateNetworkPeeringRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2595}
  /// [google.cloud.vmwareengine.v1.NetworkPeering]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1034}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::NetworkPeering>>
  CreateNetworkPeering(
      std::string const& parent,
      google::cloud::vmwareengine::v1::NetworkPeering const& network_peering,
      std::string const& network_peering_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateNetworkPeering
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateNetworkPeering(
      NoAwaitTag, std::string const& parent,
      google::cloud::vmwareengine::v1::NetworkPeering const& network_peering,
      std::string const& network_peering_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new network peering between the peer network and VMware Engine
  /// network provided in a `NetworkPeering` resource. NetworkPeering is a
  /// global resource and location can only be global.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.CreateNetworkPeeringRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.NetworkPeering] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreateNetworkPeeringRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2595}
  /// [google.cloud.vmwareengine.v1.NetworkPeering]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1034}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::NetworkPeering>>
  CreateNetworkPeering(
      google::cloud::vmwareengine::v1::CreateNetworkPeeringRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateNetworkPeering
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateNetworkPeering(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::CreateNetworkPeeringRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateNetworkPeering
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::NetworkPeering>>
  CreateNetworkPeering(google::longrunning::Operation const& operation,
                       Options opts = {});

  // clang-format off
  ///
  /// Deletes a `NetworkPeering` resource. When a network peering is deleted for
  /// a VMware Engine network, the peer network becomes inaccessible to that
  /// VMware Engine network. NetworkPeering is a global resource and location can
  /// only be global.
  ///
  /// @param name  Required. The resource name of the network peering to be deleted.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/global/networkPeerings/my-peering`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeleteNetworkPeeringRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2643}
  /// [google.cloud.vmwareengine.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2195}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteNetworkPeering(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteNetworkPeering
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteNetworkPeering(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a `NetworkPeering` resource. When a network peering is deleted for
  /// a VMware Engine network, the peer network becomes inaccessible to that
  /// VMware Engine network. NetworkPeering is a global resource and location can
  /// only be global.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.DeleteNetworkPeeringRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeleteNetworkPeeringRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2643}
  /// [google.cloud.vmwareengine.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2195}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteNetworkPeering(
      google::cloud::vmwareengine::v1::DeleteNetworkPeeringRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteNetworkPeering
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteNetworkPeering(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::DeleteNetworkPeeringRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteNetworkPeering
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteNetworkPeering(google::longrunning::Operation const& operation,
                       Options opts = {});

  // clang-format off
  ///
  /// Modifies a `NetworkPeering` resource. Only the `description` field can be
  /// updated. Only fields specified in `updateMask` are applied. NetworkPeering
  /// is a global resource and location can only be global.
  ///
  /// @param network_peering  Required. Network peering description.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  `NetworkPeering` resource by the update.
  ///  The fields specified in the `update_mask` are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.NetworkPeering] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.NetworkPeering]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1034}
  /// [google.cloud.vmwareengine.v1.UpdateNetworkPeeringRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2753}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::NetworkPeering>>
  UpdateNetworkPeering(
      google::cloud::vmwareengine::v1::NetworkPeering const& network_peering,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateNetworkPeering
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateNetworkPeering(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::NetworkPeering const& network_peering,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Modifies a `NetworkPeering` resource. Only the `description` field can be
  /// updated. Only fields specified in `updateMask` are applied. NetworkPeering
  /// is a global resource and location can only be global.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.UpdateNetworkPeeringRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.NetworkPeering] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.NetworkPeering]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1034}
  /// [google.cloud.vmwareengine.v1.UpdateNetworkPeeringRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2753}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::NetworkPeering>>
  UpdateNetworkPeering(
      google::cloud::vmwareengine::v1::UpdateNetworkPeeringRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateNetworkPeering
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateNetworkPeering(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::UpdateNetworkPeeringRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateNetworkPeering
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::NetworkPeering>>
  UpdateNetworkPeering(google::longrunning::Operation const& operation,
                       Options opts = {});

  // clang-format off
  ///
  /// Lists the network peering routes exchanged over a peering connection.
  /// NetworkPeering is a global resource and location can only be global.
  ///
  /// @param parent  Required. The resource name of the network peering to retrieve peering
  ///  routes from. Resource names are schemeless URIs that follow the conventions
  ///  in https://cloud.google.com/apis/design/resource_names. For example:
  ///  `projects/my-project/locations/global/networkPeerings/my-peering`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.PeeringRoute], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListPeeringRoutesRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2798}
  /// [google.cloud.vmwareengine.v1.PeeringRoute]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1185}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::PeeringRoute> ListPeeringRoutes(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists the network peering routes exchanged over a peering connection.
  /// NetworkPeering is a global resource and location can only be global.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ListPeeringRoutesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.PeeringRoute], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListPeeringRoutesRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2798}
  /// [google.cloud.vmwareengine.v1.PeeringRoute]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1185}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::PeeringRoute> ListPeeringRoutes(
      google::cloud::vmwareengine::v1::ListPeeringRoutesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new HCX activation key in a given private cloud.
  ///
  /// @param parent  Required. The resource name of the private cloud to create the key for.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1/privateClouds/my-cloud`
  /// @param hcx_activation_key  Required. The initial description of a new HCX activation key. When
  ///  creating a new key, this field must be an empty object.
  /// @param hcx_activation_key_id  Required. The user-provided identifier of the `HcxActivationKey` to be
  ///  created. This identifier must be unique among `HcxActivationKey` resources
  ///  within the parent and becomes the final token in the name URI.
  ///  The identifier must meet the following requirements:
  ///  @n
  ///  * Only contains 1-63 alphanumeric characters and hyphens
  ///  * Begins with an alphabetical character
  ///  * Ends with a non-hyphen character
  ///  * Not formatted as a UUID
  ///  * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
  ///  (section 3.5)
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.HcxActivationKey] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreateHcxActivationKeyRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2498}
  /// [google.cloud.vmwareengine.v1.HcxActivationKey]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L788}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>>
  CreateHcxActivationKey(
      std::string const& parent,
      google::cloud::vmwareengine::v1::HcxActivationKey const&
          hcx_activation_key,
      std::string const& hcx_activation_key_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateHcxActivationKey
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateHcxActivationKey(
      NoAwaitTag, std::string const& parent,
      google::cloud::vmwareengine::v1::HcxActivationKey const&
          hcx_activation_key,
      std::string const& hcx_activation_key_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new HCX activation key in a given private cloud.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.CreateHcxActivationKeyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.HcxActivationKey] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreateHcxActivationKeyRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2498}
  /// [google.cloud.vmwareengine.v1.HcxActivationKey]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L788}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>>
  CreateHcxActivationKey(
      google::cloud::vmwareengine::v1::CreateHcxActivationKeyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateHcxActivationKey
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateHcxActivationKey(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::CreateHcxActivationKeyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateHcxActivationKey
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>>
  CreateHcxActivationKey(google::longrunning::Operation const& operation,
                         Options opts = {});

  // clang-format off
  ///
  /// Lists `HcxActivationKey` resources in a given private cloud.
  ///
  /// @param parent  Required. The resource name of the private cloud
  ///  to be queried for HCX activation keys.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1/privateClouds/my-cloud`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.HcxActivationKey], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.HcxActivationKey]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L788}
  /// [google.cloud.vmwareengine.v1.ListHcxActivationKeysRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2452}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::HcxActivationKey>
  ListHcxActivationKeys(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists `HcxActivationKey` resources in a given private cloud.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ListHcxActivationKeysRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.HcxActivationKey], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.HcxActivationKey]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L788}
  /// [google.cloud.vmwareengine.v1.ListHcxActivationKeysRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2452}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::HcxActivationKey>
  ListHcxActivationKeys(
      google::cloud::vmwareengine::v1::ListHcxActivationKeysRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves a `HcxActivationKey` resource by its resource name.
  ///
  /// @param name  Required. The resource name of the HCX activation key to retrieve.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1/privateClouds/my-cloud/hcxActivationKeys/my-key`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.HcxActivationKey])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetHcxActivationKeyRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2482}
  /// [google.cloud.vmwareengine.v1.HcxActivationKey]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L788}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>
  GetHcxActivationKey(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves a `HcxActivationKey` resource by its resource name.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.GetHcxActivationKeyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.HcxActivationKey])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetHcxActivationKeyRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2482}
  /// [google.cloud.vmwareengine.v1.HcxActivationKey]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L788}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>
  GetHcxActivationKey(
      google::cloud::vmwareengine::v1::GetHcxActivationKeyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves a `NetworkPolicy` resource by its resource name.
  ///
  /// @param name  Required. The resource name of the network policy to retrieve.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1/networkPolicies/my-network-policy`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.NetworkPolicy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetNetworkPolicyRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2921}
  /// [google.cloud.vmwareengine.v1.NetworkPolicy]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1249}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy> GetNetworkPolicy(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves a `NetworkPolicy` resource by its resource name.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.GetNetworkPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.NetworkPolicy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetNetworkPolicyRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2921}
  /// [google.cloud.vmwareengine.v1.NetworkPolicy]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1249}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy> GetNetworkPolicy(
      google::cloud::vmwareengine::v1::GetNetworkPolicyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists `NetworkPolicy` resources in a specified project and location.
  ///
  /// @param parent  Required. The resource name of the location (region) to query for
  ///  network policies. Resource names are schemeless URIs that follow the
  ///  conventions in https://cloud.google.com/apis/design/resource_names. For
  ///  example: `projects/my-project/locations/us-central1`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.NetworkPolicy], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListNetworkPoliciesRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2843}
  /// [google.cloud.vmwareengine.v1.NetworkPolicy]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1249}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::NetworkPolicy>
  ListNetworkPolicies(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists `NetworkPolicy` resources in a specified project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ListNetworkPoliciesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.NetworkPolicy], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListNetworkPoliciesRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2843}
  /// [google.cloud.vmwareengine.v1.NetworkPolicy]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1249}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::NetworkPolicy>
  ListNetworkPolicies(
      google::cloud::vmwareengine::v1::ListNetworkPoliciesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new network policy in a given VMware Engine network of a
  /// project and location (region). A new network policy cannot be created if
  /// another network policy already exists in the same scope.
  ///
  /// @param parent  Required. The resource name of the location (region)
  ///  to create the new network policy in.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///   `projects/my-project/locations/us-central1`
  /// @param network_policy  Required. The network policy configuration to use in the request.
  /// @param network_policy_id  Required. The user-provided identifier of the network policy to be created.
  ///  This identifier must be unique within parent
  ///  `projects/{my-project}/locations/{us-central1}/networkPolicies` and becomes
  ///  the final token in the name URI.
  ///  The identifier must meet the following requirements:
  ///  @n
  ///  * Only contains 1-63 alphanumeric characters and hyphens
  ///  * Begins with an alphabetical character
  ///  * Ends with a non-hyphen character
  ///  * Not formatted as a UUID
  ///  * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
  ///  (section 3.5)
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.NetworkPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreateNetworkPolicyRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2968}
  /// [google.cloud.vmwareengine.v1.NetworkPolicy]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1249}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>
  CreateNetworkPolicy(
      std::string const& parent,
      google::cloud::vmwareengine::v1::NetworkPolicy const& network_policy,
      std::string const& network_policy_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateNetworkPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateNetworkPolicy(
      NoAwaitTag, std::string const& parent,
      google::cloud::vmwareengine::v1::NetworkPolicy const& network_policy,
      std::string const& network_policy_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new network policy in a given VMware Engine network of a
  /// project and location (region). A new network policy cannot be created if
  /// another network policy already exists in the same scope.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.CreateNetworkPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.NetworkPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreateNetworkPolicyRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2968}
  /// [google.cloud.vmwareengine.v1.NetworkPolicy]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1249}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>
  CreateNetworkPolicy(
      google::cloud::vmwareengine::v1::CreateNetworkPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateNetworkPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateNetworkPolicy(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::CreateNetworkPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateNetworkPolicy
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>
  CreateNetworkPolicy(google::longrunning::Operation const& operation,
                      Options opts = {});

  // clang-format off
  ///
  /// Modifies a `NetworkPolicy` resource. Only the following fields can be
  /// updated: `internet_access`, `external_ip`, `edge_services_cidr`.
  /// Only fields specified in `updateMask` are applied. When updating a network
  /// policy, the external IP network service can only be disabled if there are
  /// no external IP addresses present in the scope of the policy. Also, a
  /// `NetworkService` cannot be updated when `NetworkService.state` is set
  /// to `RECONCILING`.
  ///
  /// During operation processing, the resource is temporarily in the `ACTIVE`
  /// state before the operation fully completes. For that period of time, you
  /// can't update the resource. Use the operation status to determine when the
  /// processing fully completes.
  ///
  /// @param network_policy  Required. Network policy description.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  `NetworkPolicy` resource by the update.
  ///  The fields specified in the `update_mask` are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.NetworkPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.NetworkPolicy]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1249}
  /// [google.cloud.vmwareengine.v1.UpdateNetworkPolicyRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2937}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>
  UpdateNetworkPolicy(
      google::cloud::vmwareengine::v1::NetworkPolicy const& network_policy,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateNetworkPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateNetworkPolicy(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::NetworkPolicy const& network_policy,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Modifies a `NetworkPolicy` resource. Only the following fields can be
  /// updated: `internet_access`, `external_ip`, `edge_services_cidr`.
  /// Only fields specified in `updateMask` are applied. When updating a network
  /// policy, the external IP network service can only be disabled if there are
  /// no external IP addresses present in the scope of the policy. Also, a
  /// `NetworkService` cannot be updated when `NetworkService.state` is set
  /// to `RECONCILING`.
  ///
  /// During operation processing, the resource is temporarily in the `ACTIVE`
  /// state before the operation fully completes. For that period of time, you
  /// can't update the resource. Use the operation status to determine when the
  /// processing fully completes.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.UpdateNetworkPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.NetworkPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.NetworkPolicy]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1249}
  /// [google.cloud.vmwareengine.v1.UpdateNetworkPolicyRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2937}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>
  UpdateNetworkPolicy(
      google::cloud::vmwareengine::v1::UpdateNetworkPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateNetworkPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateNetworkPolicy(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::UpdateNetworkPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateNetworkPolicy
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>
  UpdateNetworkPolicy(google::longrunning::Operation const& operation,
                      Options opts = {});

  // clang-format off
  ///
  /// Deletes a `NetworkPolicy` resource. A network policy cannot be deleted
  /// when `NetworkService.state` is set to `RECONCILING` for either its external
  /// IP or internet access service.
  ///
  /// @param name  Required. The resource name of the network policy to delete.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1/networkPolicies/my-network-policy`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeleteNetworkPolicyRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3018}
  /// [google.cloud.vmwareengine.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2195}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteNetworkPolicy(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteNetworkPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteNetworkPolicy(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a `NetworkPolicy` resource. A network policy cannot be deleted
  /// when `NetworkService.state` is set to `RECONCILING` for either its external
  /// IP or internet access service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.DeleteNetworkPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeleteNetworkPolicyRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3018}
  /// [google.cloud.vmwareengine.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2195}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteNetworkPolicy(
      google::cloud::vmwareengine::v1::DeleteNetworkPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteNetworkPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteNetworkPolicy(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::DeleteNetworkPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteNetworkPolicy
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteNetworkPolicy(google::longrunning::Operation const& operation,
                      Options opts = {});

  // clang-format off
  ///
  /// Lists Consumer VPCs bound to Management DNS Zone of a given private cloud.
  ///
  /// @param parent  Required. The resource name of the private cloud to be queried for
  ///  management DNS zone bindings.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.ManagementDnsZoneBinding], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListManagementDnsZoneBindingsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3050}
  /// [google.cloud.vmwareengine.v1.ManagementDnsZoneBinding]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1346}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>
  ListManagementDnsZoneBindings(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists Consumer VPCs bound to Management DNS Zone of a given private cloud.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ListManagementDnsZoneBindingsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.ManagementDnsZoneBinding], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListManagementDnsZoneBindingsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3050}
  /// [google.cloud.vmwareengine.v1.ManagementDnsZoneBinding]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1346}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>
  ListManagementDnsZoneBindings(
      google::cloud::vmwareengine::v1::ListManagementDnsZoneBindingsRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves a 'ManagementDnsZoneBinding' resource by its resource name.
  ///
  /// @param name  Required. The resource name of the management DNS zone binding to
  ///  retrieve. Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/managementDnsZoneBindings/my-management-dns-zone-binding`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.ManagementDnsZoneBinding])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetManagementDnsZoneBindingRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3130}
  /// [google.cloud.vmwareengine.v1.ManagementDnsZoneBinding]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1346}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>
  GetManagementDnsZoneBinding(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves a 'ManagementDnsZoneBinding' resource by its resource name.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.GetManagementDnsZoneBindingRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.ManagementDnsZoneBinding])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetManagementDnsZoneBindingRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3130}
  /// [google.cloud.vmwareengine.v1.ManagementDnsZoneBinding]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1346}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>
  GetManagementDnsZoneBinding(
      google::cloud::vmwareengine::v1::GetManagementDnsZoneBindingRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new `ManagementDnsZoneBinding` resource in a private cloud.
  /// This RPC creates the DNS binding and the resource that represents the
  /// DNS binding of the consumer VPC network to the management DNS zone. A
  /// management DNS zone is the Cloud DNS cross-project binding zone that
  /// VMware Engine creates for each private cloud. It contains FQDNs and
  /// corresponding IP addresses for the private cloud's ESXi hosts and
  /// management VM appliances like vCenter and NSX Manager.
  ///
  /// @param parent  Required. The resource name of the private cloud
  ///  to create a new management DNS zone binding for.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
  /// @param management_dns_zone_binding  Required. The initial values for a new management DNS zone binding.
  /// @param management_dns_zone_binding_id  Required. The user-provided identifier of the `ManagementDnsZoneBinding`
  ///  resource to be created. This identifier must be unique among
  ///  `ManagementDnsZoneBinding` resources within the parent and becomes the
  ///  final token in the name URI. The identifier must meet the following
  ///  requirements:
  ///  @n
  ///  * Only contains 1-63 alphanumeric characters and hyphens
  ///  * Begins with an alphabetical character
  ///  * Ends with a non-hyphen character
  ///  * Not formatted as a UUID
  ///  * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
  ///  (section 3.5)
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.ManagementDnsZoneBinding] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreateManagementDnsZoneBindingRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3145}
  /// [google.cloud.vmwareengine.v1.ManagementDnsZoneBinding]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1346}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>>
  CreateManagementDnsZoneBinding(
      std::string const& parent,
      google::cloud::vmwareengine::v1::ManagementDnsZoneBinding const&
          management_dns_zone_binding,
      std::string const& management_dns_zone_binding_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateManagementDnsZoneBinding
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateManagementDnsZoneBinding(
      NoAwaitTag, std::string const& parent,
      google::cloud::vmwareengine::v1::ManagementDnsZoneBinding const&
          management_dns_zone_binding,
      std::string const& management_dns_zone_binding_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new `ManagementDnsZoneBinding` resource in a private cloud.
  /// This RPC creates the DNS binding and the resource that represents the
  /// DNS binding of the consumer VPC network to the management DNS zone. A
  /// management DNS zone is the Cloud DNS cross-project binding zone that
  /// VMware Engine creates for each private cloud. It contains FQDNs and
  /// corresponding IP addresses for the private cloud's ESXi hosts and
  /// management VM appliances like vCenter and NSX Manager.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.CreateManagementDnsZoneBindingRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.ManagementDnsZoneBinding] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreateManagementDnsZoneBindingRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3145}
  /// [google.cloud.vmwareengine.v1.ManagementDnsZoneBinding]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1346}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>>
  CreateManagementDnsZoneBinding(
      google::cloud::vmwareengine::v1::
          CreateManagementDnsZoneBindingRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateManagementDnsZoneBinding
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateManagementDnsZoneBinding(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::
          CreateManagementDnsZoneBindingRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateManagementDnsZoneBinding
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>>
  CreateManagementDnsZoneBinding(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Updates a `ManagementDnsZoneBinding` resource.
  /// Only fields specified in `update_mask` are applied.
  ///
  /// @param management_dns_zone_binding  Required. New values to update the management DNS zone binding with.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  `ManagementDnsZoneBinding` resource by the update.
  ///  The fields specified in the `update_mask` are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.ManagementDnsZoneBinding] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ManagementDnsZoneBinding]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1346}
  /// [google.cloud.vmwareengine.v1.UpdateManagementDnsZoneBindingRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3197}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>>
  UpdateManagementDnsZoneBinding(
      google::cloud::vmwareengine::v1::ManagementDnsZoneBinding const&
          management_dns_zone_binding,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateManagementDnsZoneBinding
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateManagementDnsZoneBinding(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::ManagementDnsZoneBinding const&
          management_dns_zone_binding,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a `ManagementDnsZoneBinding` resource.
  /// Only fields specified in `update_mask` are applied.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.UpdateManagementDnsZoneBindingRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.ManagementDnsZoneBinding] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ManagementDnsZoneBinding]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1346}
  /// [google.cloud.vmwareengine.v1.UpdateManagementDnsZoneBindingRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3197}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>>
  UpdateManagementDnsZoneBinding(
      google::cloud::vmwareengine::v1::
          UpdateManagementDnsZoneBindingRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateManagementDnsZoneBinding
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateManagementDnsZoneBinding(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::
          UpdateManagementDnsZoneBindingRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateManagementDnsZoneBinding
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>>
  UpdateManagementDnsZoneBinding(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Deletes a `ManagementDnsZoneBinding` resource. When a management DNS zone
  /// binding is deleted, the corresponding consumer VPC network is no longer
  /// bound to the management DNS zone.
  ///
  /// @param name  Required. The resource name of the management DNS zone binding to delete.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/managementDnsZoneBindings/my-management-dns-zone-binding`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeleteManagementDnsZoneBindingRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3229}
  /// [google.cloud.vmwareengine.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2195}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteManagementDnsZoneBinding(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteManagementDnsZoneBinding
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteManagementDnsZoneBinding(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a `ManagementDnsZoneBinding` resource. When a management DNS zone
  /// binding is deleted, the corresponding consumer VPC network is no longer
  /// bound to the management DNS zone.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.DeleteManagementDnsZoneBindingRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeleteManagementDnsZoneBindingRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3229}
  /// [google.cloud.vmwareengine.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2195}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteManagementDnsZoneBinding(
      google::cloud::vmwareengine::v1::
          DeleteManagementDnsZoneBindingRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteManagementDnsZoneBinding
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteManagementDnsZoneBinding(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::
          DeleteManagementDnsZoneBindingRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteManagementDnsZoneBinding
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteManagementDnsZoneBinding(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Retries to create a `ManagementDnsZoneBinding` resource that is
  /// in failed state.
  ///
  /// @param name  Required. The resource name of the management DNS zone binding to repair.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/managementDnsZoneBindings/my-management-dns-zone-binding`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.ManagementDnsZoneBinding] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ManagementDnsZoneBinding]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1346}
  /// [google.cloud.vmwareengine.v1.RepairManagementDnsZoneBindingRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3260}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>>
  RepairManagementDnsZoneBinding(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief RepairManagementDnsZoneBinding
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RepairManagementDnsZoneBinding(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retries to create a `ManagementDnsZoneBinding` resource that is
  /// in failed state.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.RepairManagementDnsZoneBindingRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.ManagementDnsZoneBinding] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ManagementDnsZoneBinding]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1346}
  /// [google.cloud.vmwareengine.v1.RepairManagementDnsZoneBindingRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3260}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>>
  RepairManagementDnsZoneBinding(
      google::cloud::vmwareengine::v1::
          RepairManagementDnsZoneBindingRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RepairManagementDnsZoneBinding
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RepairManagementDnsZoneBinding(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::
          RepairManagementDnsZoneBindingRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RepairManagementDnsZoneBinding
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>>
  RepairManagementDnsZoneBinding(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Creates a new VMware Engine network that can be used by a private cloud.
  ///
  /// @param parent  Required. The resource name of the location to create the new VMware Engine
  ///  network in. A VMware Engine network of type
  ///  `LEGACY` is a regional resource, and a VMware
  ///  Engine network of type `STANDARD` is a global resource.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names. For example:
  ///  `projects/my-project/locations/global`
  /// @param vmware_engine_network  Required. The initial description of the new VMware Engine network.
  /// @param vmware_engine_network_id  Required. The user-provided identifier of the new VMware Engine network.
  ///  This identifier must be unique among VMware Engine network resources
  ///  within the parent and becomes the final token in the name URI. The
  ///  identifier must meet the following requirements:
  ///  @n
  ///  * For networks of type LEGACY, adheres to the format:
  ///  `{region-id}-default`. Replace `{region-id}` with the region where you want
  ///  to create the VMware Engine network. For example, "us-central1-default".
  ///  * Only contains 1-63 alphanumeric characters and hyphens
  ///  * Begins with an alphabetical character
  ///  * Ends with a non-hyphen character
  ///  * Not formatted as a UUID
  ///  * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
  ///  (section 3.5)
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.VmwareEngineNetwork] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreateVmwareEngineNetworkRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3292}
  /// [google.cloud.vmwareengine.v1.VmwareEngineNetwork]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1422}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>
  CreateVmwareEngineNetwork(
      std::string const& parent,
      google::cloud::vmwareengine::v1::VmwareEngineNetwork const&
          vmware_engine_network,
      std::string const& vmware_engine_network_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateVmwareEngineNetwork
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateVmwareEngineNetwork(
      NoAwaitTag, std::string const& parent,
      google::cloud::vmwareengine::v1::VmwareEngineNetwork const&
          vmware_engine_network,
      std::string const& vmware_engine_network_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new VMware Engine network that can be used by a private cloud.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.CreateVmwareEngineNetworkRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.VmwareEngineNetwork] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreateVmwareEngineNetworkRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3292}
  /// [google.cloud.vmwareengine.v1.VmwareEngineNetwork]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1422}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>
  CreateVmwareEngineNetwork(
      google::cloud::vmwareengine::v1::CreateVmwareEngineNetworkRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateVmwareEngineNetwork
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateVmwareEngineNetwork(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::CreateVmwareEngineNetworkRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateVmwareEngineNetwork
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>
  CreateVmwareEngineNetwork(google::longrunning::Operation const& operation,
                            Options opts = {});

  // clang-format off
  ///
  /// Modifies a VMware Engine network resource. Only the following fields can be
  /// updated: `description`. Only fields specified in `updateMask` are
  /// applied.
  ///
  /// @param vmware_engine_network  Required. VMware Engine network description.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  VMware Engine network resource by the update.
  ///  The fields specified in the `update_mask` are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten. Only the
  ///  following fields can be updated: `description`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.VmwareEngineNetwork] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.UpdateVmwareEngineNetworkRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3346}
  /// [google.cloud.vmwareengine.v1.VmwareEngineNetwork]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1422}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>
  UpdateVmwareEngineNetwork(
      google::cloud::vmwareengine::v1::VmwareEngineNetwork const&
          vmware_engine_network,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateVmwareEngineNetwork
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateVmwareEngineNetwork(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::VmwareEngineNetwork const&
          vmware_engine_network,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Modifies a VMware Engine network resource. Only the following fields can be
  /// updated: `description`. Only fields specified in `updateMask` are
  /// applied.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.UpdateVmwareEngineNetworkRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.VmwareEngineNetwork] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.UpdateVmwareEngineNetworkRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3346}
  /// [google.cloud.vmwareengine.v1.VmwareEngineNetwork]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1422}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>
  UpdateVmwareEngineNetwork(
      google::cloud::vmwareengine::v1::UpdateVmwareEngineNetworkRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateVmwareEngineNetwork
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateVmwareEngineNetwork(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::UpdateVmwareEngineNetworkRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateVmwareEngineNetwork
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>
  UpdateVmwareEngineNetwork(google::longrunning::Operation const& operation,
                            Options opts = {});

  // clang-format off
  ///
  /// Deletes a `VmwareEngineNetwork` resource. You can only delete a VMware
  /// Engine network after all resources that refer to it are deleted. For
  /// example, a private cloud, a network peering, and a network policy can all
  /// refer to the same VMware Engine network.
  ///
  /// @param name  Required. The resource name of the VMware Engine network to be deleted.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/global/vmwareEngineNetworks/my-network`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeleteVmwareEngineNetworkRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3379}
  /// [google.cloud.vmwareengine.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2195}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteVmwareEngineNetwork(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteVmwareEngineNetwork
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteVmwareEngineNetwork(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a `VmwareEngineNetwork` resource. You can only delete a VMware
  /// Engine network after all resources that refer to it are deleted. For
  /// example, a private cloud, a network peering, and a network policy can all
  /// refer to the same VMware Engine network.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.DeleteVmwareEngineNetworkRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeleteVmwareEngineNetworkRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3379}
  /// [google.cloud.vmwareengine.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2195}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteVmwareEngineNetwork(
      google::cloud::vmwareengine::v1::DeleteVmwareEngineNetworkRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteVmwareEngineNetwork
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteVmwareEngineNetwork(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::DeleteVmwareEngineNetworkRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteVmwareEngineNetwork
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteVmwareEngineNetwork(google::longrunning::Operation const& operation,
                            Options opts = {});

  // clang-format off
  ///
  /// Retrieves a `VmwareEngineNetwork` resource by its resource name. The
  /// resource contains details of the VMware Engine network, such as its VMware
  /// Engine network type, peered networks in a service project, and state
  /// (for example, `CREATING`, `ACTIVE`, `DELETING`).
  ///
  /// @param name  Required. The resource name of the VMware Engine network to retrieve.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/global/vmwareEngineNetworks/my-network`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.VmwareEngineNetwork])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetVmwareEngineNetworkRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3417}
  /// [google.cloud.vmwareengine.v1.VmwareEngineNetwork]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1422}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>
  GetVmwareEngineNetwork(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves a `VmwareEngineNetwork` resource by its resource name. The
  /// resource contains details of the VMware Engine network, such as its VMware
  /// Engine network type, peered networks in a service project, and state
  /// (for example, `CREATING`, `ACTIVE`, `DELETING`).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.GetVmwareEngineNetworkRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.VmwareEngineNetwork])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetVmwareEngineNetworkRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3417}
  /// [google.cloud.vmwareengine.v1.VmwareEngineNetwork]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1422}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>
  GetVmwareEngineNetwork(
      google::cloud::vmwareengine::v1::GetVmwareEngineNetworkRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists `VmwareEngineNetwork` resources in a given project and location.
  ///
  /// @param parent  Required. The resource name of the location to query for
  ///  VMware Engine networks. Resource names are schemeless URIs that follow the
  ///  conventions in https://cloud.google.com/apis/design/resource_names. For
  ///  example: `projects/my-project/locations/global`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.VmwareEngineNetwork], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListVmwareEngineNetworksRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3433}
  /// [google.cloud.vmwareengine.v1.VmwareEngineNetwork]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1422}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::VmwareEngineNetwork>
  ListVmwareEngineNetworks(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists `VmwareEngineNetwork` resources in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ListVmwareEngineNetworksRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.VmwareEngineNetwork], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListVmwareEngineNetworksRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3433}
  /// [google.cloud.vmwareengine.v1.VmwareEngineNetwork]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1422}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::VmwareEngineNetwork>
  ListVmwareEngineNetworks(
      google::cloud::vmwareengine::v1::ListVmwareEngineNetworksRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new private connection that can be used for accessing private
  /// Clouds.
  ///
  /// @param parent  Required. The resource name of the location to create the new private
  ///  connection in. Private connection is a regional resource.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names. For example:
  ///  `projects/my-project/locations/us-central1`
  /// @param private_connection  Required. The initial description of the new private connection.
  /// @param private_connection_id  Required. The user-provided identifier of the new private connection.
  ///  This identifier must be unique among private connection resources
  ///  within the parent and becomes the final token in the name URI. The
  ///  identifier must meet the following requirements:
  ///  @n
  ///  * Only contains 1-63 alphanumeric characters and hyphens
  ///  * Begins with an alphabetical character
  ///  * Ends with a non-hyphen character
  ///  * Not formatted as a UUID
  ///  * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
  ///  (section 3.5)
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateConnection] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreatePrivateConnectionRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3509}
  /// [google.cloud.vmwareengine.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1540}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>
  CreatePrivateConnection(
      std::string const& parent,
      google::cloud::vmwareengine::v1::PrivateConnection const&
          private_connection,
      std::string const& private_connection_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreatePrivateConnection
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreatePrivateConnection(
      NoAwaitTag, std::string const& parent,
      google::cloud::vmwareengine::v1::PrivateConnection const&
          private_connection,
      std::string const& private_connection_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new private connection that can be used for accessing private
  /// Clouds.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.CreatePrivateConnectionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateConnection] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreatePrivateConnectionRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3509}
  /// [google.cloud.vmwareengine.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1540}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>
  CreatePrivateConnection(
      google::cloud::vmwareengine::v1::CreatePrivateConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreatePrivateConnection
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreatePrivateConnection(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::CreatePrivateConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreatePrivateConnection
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>
  CreatePrivateConnection(google::longrunning::Operation const& operation,
                          Options opts = {});

  // clang-format off
  ///
  /// Retrieves a `PrivateConnection` resource by its resource name. The resource
  /// contains details of the private connection, such as connected
  /// network, routing mode and state.
  ///
  /// @param name  Required. The resource name of the private connection to retrieve.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1/privateConnections/my-connection`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.PrivateConnection])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetPrivateConnectionRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3558}
  /// [google.cloud.vmwareengine.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1540}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>
  GetPrivateConnection(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves a `PrivateConnection` resource by its resource name. The resource
  /// contains details of the private connection, such as connected
  /// network, routing mode and state.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.GetPrivateConnectionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.PrivateConnection])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetPrivateConnectionRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3558}
  /// [google.cloud.vmwareengine.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1540}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>
  GetPrivateConnection(
      google::cloud::vmwareengine::v1::GetPrivateConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists `PrivateConnection` resources in a given project and location.
  ///
  /// @param parent  Required. The resource name of the location to query for
  ///  private connections. Resource names are schemeless URIs that follow the
  ///  conventions in https://cloud.google.com/apis/design/resource_names. For
  ///  example: `projects/my-project/locations/us-central1`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.PrivateConnection], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListPrivateConnectionsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3574}
  /// [google.cloud.vmwareengine.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1540}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::PrivateConnection>
  ListPrivateConnections(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists `PrivateConnection` resources in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ListPrivateConnectionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.PrivateConnection], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListPrivateConnectionsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3574}
  /// [google.cloud.vmwareengine.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1540}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::PrivateConnection>
  ListPrivateConnections(
      google::cloud::vmwareengine::v1::ListPrivateConnectionsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Modifies a `PrivateConnection` resource. Only `description` and
  /// `routing_mode` fields can be updated. Only fields specified in `updateMask`
  /// are applied.
  ///
  /// @param private_connection  Required. Private connection description.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  `PrivateConnection` resource by the update.
  ///  The fields specified in the `update_mask` are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateConnection] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1540}
  /// [google.cloud.vmwareengine.v1.UpdatePrivateConnectionRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3650}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>
  UpdatePrivateConnection(
      google::cloud::vmwareengine::v1::PrivateConnection const&
          private_connection,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdatePrivateConnection
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdatePrivateConnection(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::PrivateConnection const&
          private_connection,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Modifies a `PrivateConnection` resource. Only `description` and
  /// `routing_mode` fields can be updated. Only fields specified in `updateMask`
  /// are applied.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.UpdatePrivateConnectionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateConnection] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1540}
  /// [google.cloud.vmwareengine.v1.UpdatePrivateConnectionRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3650}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>
  UpdatePrivateConnection(
      google::cloud::vmwareengine::v1::UpdatePrivateConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdatePrivateConnection
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdatePrivateConnection(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::UpdatePrivateConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdatePrivateConnection
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>
  UpdatePrivateConnection(google::longrunning::Operation const& operation,
                          Options opts = {});

  // clang-format off
  ///
  /// Deletes a `PrivateConnection` resource. When a private connection is
  /// deleted for a VMware Engine network, the connected network becomes
  /// inaccessible to that VMware Engine network.
  ///
  /// @param name  Required. The resource name of the private connection to be deleted.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1/privateConnections/my-connection`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeletePrivateConnectionRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3682}
  /// [google.cloud.vmwareengine.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2195}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeletePrivateConnection(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeletePrivateConnection
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeletePrivateConnection(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a `PrivateConnection` resource. When a private connection is
  /// deleted for a VMware Engine network, the connected network becomes
  /// inaccessible to that VMware Engine network.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.DeletePrivateConnectionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeletePrivateConnectionRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3682}
  /// [google.cloud.vmwareengine.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L2195}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeletePrivateConnection(
      google::cloud::vmwareengine::v1::DeletePrivateConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeletePrivateConnection
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeletePrivateConnection(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::DeletePrivateConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeletePrivateConnection
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeletePrivateConnection(google::longrunning::Operation const& operation,
                          Options opts = {});

  // clang-format off
  ///
  /// Lists the private connection routes exchanged over a peering connection.
  ///
  /// @param parent  Required. The resource name of the private connection to retrieve peering
  ///  routes from. Resource names are schemeless URIs that follow the conventions
  ///  in https://cloud.google.com/apis/design/resource_names. For example:
  ///  `projects/my-project/locations/us-west1/privateConnections/my-connection`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.PeeringRoute], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListPrivateConnectionPeeringRoutesRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3714}
  /// [google.cloud.vmwareengine.v1.PeeringRoute]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1185}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::PeeringRoute>
  ListPrivateConnectionPeeringRoutes(std::string const& parent,
                                     Options opts = {});

  // clang-format off
  ///
  /// Lists the private connection routes exchanged over a peering connection.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ListPrivateConnectionPeeringRoutesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.PeeringRoute], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListPrivateConnectionPeeringRoutesRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3714}
  /// [google.cloud.vmwareengine.v1.PeeringRoute]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1185}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::PeeringRoute>
  ListPrivateConnectionPeeringRoutes(
      google::cloud::vmwareengine::v1::ListPrivateConnectionPeeringRoutesRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Grants the bind permission to the customer provided principal(user /
  /// service account) to bind their DNS zone with the intranet VPC associated
  /// with the project. DnsBindPermission is a global resource and location can
  /// only be global.
  ///
  /// @param name  Required. The name of the resource which stores the users/service accounts
  ///  having the permission to bind to the corresponding intranet VPC of the
  ///  consumer project. DnsBindPermission is a global resource. Resource names
  ///  are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names. For example:
  ///  `projects/my-project/locations/global/dnsBindPermission`
  /// @param principal  Required. The consumer provided user/service account which needs to be
  ///  granted permission to bind with the intranet VPC corresponding to the
  ///  consumer project.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.DnsBindPermission] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DnsBindPermission]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1719}
  /// [google.cloud.vmwareengine.v1.GrantDnsBindPermissionRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3752}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::DnsBindPermission>>
  GrantDnsBindPermission(
      std::string const& name,
      google::cloud::vmwareengine::v1::Principal const& principal,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief GrantDnsBindPermission
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> GrantDnsBindPermission(
      NoAwaitTag, std::string const& name,
      google::cloud::vmwareengine::v1::Principal const& principal,
      Options opts = {});

  // clang-format off
  ///
  /// Grants the bind permission to the customer provided principal(user /
  /// service account) to bind their DNS zone with the intranet VPC associated
  /// with the project. DnsBindPermission is a global resource and location can
  /// only be global.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.GrantDnsBindPermissionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.DnsBindPermission] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DnsBindPermission]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1719}
  /// [google.cloud.vmwareengine.v1.GrantDnsBindPermissionRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3752}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::DnsBindPermission>>
  GrantDnsBindPermission(
      google::cloud::vmwareengine::v1::GrantDnsBindPermissionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief GrantDnsBindPermission
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> GrantDnsBindPermission(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::GrantDnsBindPermissionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief GrantDnsBindPermission
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::DnsBindPermission>>
  GrantDnsBindPermission(google::longrunning::Operation const& operation,
                         Options opts = {});

  // clang-format off
  ///
  /// Gets all the principals having bind permission on the intranet VPC
  /// associated with the consumer project granted by the Grant API.
  /// DnsBindPermission is a global resource and location can only be global.
  ///
  /// @param name  Required. The name of the resource which stores the users/service accounts
  ///  having the permission to bind to the corresponding intranet VPC of the
  ///  consumer project. DnsBindPermission is a global resource. Resource names
  ///  are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names. For example:
  ///  `projects/my-project/locations/global/dnsBindPermission`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.DnsBindPermission])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DnsBindPermission]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1719}
  /// [google.cloud.vmwareengine.v1.GetDnsBindPermissionRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3828}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::DnsBindPermission>
  GetDnsBindPermission(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets all the principals having bind permission on the intranet VPC
  /// associated with the consumer project granted by the Grant API.
  /// DnsBindPermission is a global resource and location can only be global.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.GetDnsBindPermissionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.DnsBindPermission])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DnsBindPermission]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1719}
  /// [google.cloud.vmwareengine.v1.GetDnsBindPermissionRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3828}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::DnsBindPermission>
  GetDnsBindPermission(
      google::cloud::vmwareengine::v1::GetDnsBindPermissionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Revokes the bind permission from the customer provided principal(user /
  /// service account) on the intranet VPC associated with the consumer project.
  /// DnsBindPermission is a global resource and location can only be global.
  ///
  /// @param name  Required. The name of the resource which stores the users/service accounts
  ///  having the permission to bind to the corresponding intranet VPC of the
  ///  consumer project. DnsBindPermission is a global resource. Resource names
  ///  are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names. For example:
  ///  `projects/my-project/locations/global/dnsBindPermission`
  /// @param principal  Required. The consumer provided user/service account which needs to be
  ///  granted permission to bind with the intranet VPC corresponding to the
  ///  consumer project.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.DnsBindPermission] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DnsBindPermission]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1719}
  /// [google.cloud.vmwareengine.v1.RevokeDnsBindPermissionRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3790}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::DnsBindPermission>>
  RevokeDnsBindPermission(
      std::string const& name,
      google::cloud::vmwareengine::v1::Principal const& principal,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RevokeDnsBindPermission
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RevokeDnsBindPermission(
      NoAwaitTag, std::string const& name,
      google::cloud::vmwareengine::v1::Principal const& principal,
      Options opts = {});

  // clang-format off
  ///
  /// Revokes the bind permission from the customer provided principal(user /
  /// service account) on the intranet VPC associated with the consumer project.
  /// DnsBindPermission is a global resource and location can only be global.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.RevokeDnsBindPermissionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.DnsBindPermission] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DnsBindPermission]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L1719}
  /// [google.cloud.vmwareengine.v1.RevokeDnsBindPermissionRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L3790}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::DnsBindPermission>>
  RevokeDnsBindPermission(
      google::cloud::vmwareengine::v1::RevokeDnsBindPermissionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RevokeDnsBindPermission
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RevokeDnsBindPermission(
      NoAwaitTag,
      google::cloud::vmwareengine::v1::RevokeDnsBindPermissionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RevokeDnsBindPermission
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::DnsBindPermission>>
  RevokeDnsBindPermission(google::longrunning::Operation const& operation,
                          Options opts = {});

 private:
  std::shared_ptr<VmwareEngineConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vmwareengine_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VMWAREENGINE_V1_VMWARE_ENGINE_CLIENT_H
