// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/video/transcoder/v1/services.proto

#include "google/cloud/video/transcoder/v1/internal/transcoder_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace video_transcoder_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

TranscoderServiceTracingConnection::TranscoderServiceTracingConnection(
    std::shared_ptr<video_transcoder_v1::TranscoderServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::video::transcoder::v1::Job>
TranscoderServiceTracingConnection::CreateJob(
    google::cloud::video::transcoder::v1::CreateJobRequest const& request) {
  auto span = internal::MakeSpan(
      "video_transcoder_v1::TranscoderServiceConnection::CreateJob");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateJob(request));
}

StreamRange<google::cloud::video::transcoder::v1::Job>
TranscoderServiceTracingConnection::ListJobs(
    google::cloud::video::transcoder::v1::ListJobsRequest request) {
  auto span = internal::MakeSpan(
      "video_transcoder_v1::TranscoderServiceConnection::ListJobs");
  internal::OTelScope scope(span);
  auto sr = child_->ListJobs(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::video::transcoder::v1::Job>(std::move(span),
                                                 std::move(sr));
}

StatusOr<google::cloud::video::transcoder::v1::Job>
TranscoderServiceTracingConnection::GetJob(
    google::cloud::video::transcoder::v1::GetJobRequest const& request) {
  auto span = internal::MakeSpan(
      "video_transcoder_v1::TranscoderServiceConnection::GetJob");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetJob(request));
}

Status TranscoderServiceTracingConnection::DeleteJob(
    google::cloud::video::transcoder::v1::DeleteJobRequest const& request) {
  auto span = internal::MakeSpan(
      "video_transcoder_v1::TranscoderServiceConnection::DeleteJob");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteJob(request));
}

StatusOr<google::cloud::video::transcoder::v1::JobTemplate>
TranscoderServiceTracingConnection::CreateJobTemplate(
    google::cloud::video::transcoder::v1::CreateJobTemplateRequest const&
        request) {
  auto span = internal::MakeSpan(
      "video_transcoder_v1::TranscoderServiceConnection::CreateJobTemplate");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateJobTemplate(request));
}

StreamRange<google::cloud::video::transcoder::v1::JobTemplate>
TranscoderServiceTracingConnection::ListJobTemplates(
    google::cloud::video::transcoder::v1::ListJobTemplatesRequest request) {
  auto span = internal::MakeSpan(
      "video_transcoder_v1::TranscoderServiceConnection::ListJobTemplates");
  internal::OTelScope scope(span);
  auto sr = child_->ListJobTemplates(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::video::transcoder::v1::JobTemplate>(std::move(span),
                                                         std::move(sr));
}

StatusOr<google::cloud::video::transcoder::v1::JobTemplate>
TranscoderServiceTracingConnection::GetJobTemplate(
    google::cloud::video::transcoder::v1::GetJobTemplateRequest const&
        request) {
  auto span = internal::MakeSpan(
      "video_transcoder_v1::TranscoderServiceConnection::GetJobTemplate");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetJobTemplate(request));
}

Status TranscoderServiceTracingConnection::DeleteJobTemplate(
    google::cloud::video::transcoder::v1::DeleteJobTemplateRequest const&
        request) {
  auto span = internal::MakeSpan(
      "video_transcoder_v1::TranscoderServiceConnection::DeleteJobTemplate");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteJobTemplate(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<video_transcoder_v1::TranscoderServiceConnection>
MakeTranscoderServiceTracingConnection(
    std::shared_ptr<video_transcoder_v1::TranscoderServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn =
        std::make_shared<TranscoderServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace video_transcoder_v1_internal
}  // namespace cloud
}  // namespace google
