// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/video/transcoder/v1/services.proto

#include "google/cloud/video/transcoder/v1/internal/transcoder_connection_impl.h"
#include "google/cloud/video/transcoder/v1/internal/transcoder_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace video_transcoder_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<video_transcoder_v1::TranscoderServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<video_transcoder_v1::TranscoderServiceRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options
      .get<video_transcoder_v1::TranscoderServiceBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<
    video_transcoder_v1::TranscoderServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<video_transcoder_v1::
               TranscoderServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

TranscoderServiceConnectionImpl::TranscoderServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<video_transcoder_v1_internal::TranscoderServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), TranscoderServiceConnection::options())) {}

StatusOr<google::cloud::video::transcoder::v1::Job>
TranscoderServiceConnectionImpl::CreateJob(
    google::cloud::video::transcoder::v1::CreateJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateJob(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::video::transcoder::v1::CreateJobRequest const&
                 request) {
        return stub_->CreateJob(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::video::transcoder::v1::Job>
TranscoderServiceConnectionImpl::ListJobs(
    google::cloud::video::transcoder::v1::ListJobsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListJobs(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::video::transcoder::v1::Job>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry =
           std::shared_ptr<video_transcoder_v1::TranscoderServiceRetryPolicy>(
               retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::video::transcoder::v1::ListJobsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::video::transcoder::v1::ListJobsRequest const&
                       request) {
              return stub->ListJobs(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::video::transcoder::v1::ListJobsResponse r) {
        std::vector<google::cloud::video::transcoder::v1::Job> result(
            r.jobs().size());
        auto& messages = *r.mutable_jobs();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::video::transcoder::v1::Job>
TranscoderServiceConnectionImpl::GetJob(
    google::cloud::video::transcoder::v1::GetJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetJob(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::video::transcoder::v1::GetJobRequest const& request) {
        return stub_->GetJob(context, options, request);
      },
      *current, request, __func__);
}

Status TranscoderServiceConnectionImpl::DeleteJob(
    google::cloud::video::transcoder::v1::DeleteJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteJob(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::video::transcoder::v1::DeleteJobRequest const&
                 request) {
        return stub_->DeleteJob(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::video::transcoder::v1::JobTemplate>
TranscoderServiceConnectionImpl::CreateJobTemplate(
    google::cloud::video::transcoder::v1::CreateJobTemplateRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateJobTemplate(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::video::transcoder::v1::CreateJobTemplateRequest const&
              request) {
        return stub_->CreateJobTemplate(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::video::transcoder::v1::JobTemplate>
TranscoderServiceConnectionImpl::ListJobTemplates(
    google::cloud::video::transcoder::v1::ListJobTemplatesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListJobTemplates(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::video::transcoder::v1::JobTemplate>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry =
           std::shared_ptr<video_transcoder_v1::TranscoderServiceRetryPolicy>(
               retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::video::transcoder::v1::ListJobTemplatesRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::video::transcoder::v1::
                       ListJobTemplatesRequest const& request) {
              return stub->ListJobTemplates(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::video::transcoder::v1::ListJobTemplatesResponse r) {
        std::vector<google::cloud::video::transcoder::v1::JobTemplate> result(
            r.job_templates().size());
        auto& messages = *r.mutable_job_templates();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::video::transcoder::v1::JobTemplate>
TranscoderServiceConnectionImpl::GetJobTemplate(
    google::cloud::video::transcoder::v1::GetJobTemplateRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetJobTemplate(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::video::transcoder::v1::GetJobTemplateRequest const&
                 request) {
        return stub_->GetJobTemplate(context, options, request);
      },
      *current, request, __func__);
}

Status TranscoderServiceConnectionImpl::DeleteJobTemplate(
    google::cloud::video::transcoder::v1::DeleteJobTemplateRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteJobTemplate(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::video::transcoder::v1::DeleteJobTemplateRequest const&
              request) {
        return stub_->DeleteJobTemplate(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace video_transcoder_v1_internal
}  // namespace cloud
}  // namespace google
