// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/video/stitcher/v1/video_stitcher_service.proto

#include "google/cloud/video/stitcher/v1/internal/video_stitcher_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace video_stitcher_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

VideoStitcherServiceTracingConnection::VideoStitcherServiceTracingConnection(
    std::shared_ptr<video_stitcher_v1::VideoStitcherServiceConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::video::stitcher::v1::CdnKey>>
VideoStitcherServiceTracingConnection::CreateCdnKey(
    google::cloud::video::stitcher::v1::CreateCdnKeyRequest const& request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::CreateCdnKey");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateCdnKey(request));
}

StatusOr<google::longrunning::Operation>
VideoStitcherServiceTracingConnection::CreateCdnKey(
    NoAwaitTag,
    google::cloud::video::stitcher::v1::CreateCdnKeyRequest const& request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::CreateCdnKey");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateCdnKey(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::video::stitcher::v1::CdnKey>>
VideoStitcherServiceTracingConnection::CreateCdnKey(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::CreateCdnKey");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateCdnKey(operation));
}

StreamRange<google::cloud::video::stitcher::v1::CdnKey>
VideoStitcherServiceTracingConnection::ListCdnKeys(
    google::cloud::video::stitcher::v1::ListCdnKeysRequest request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::ListCdnKeys");
  internal::OTelScope scope(span);
  auto sr = child_->ListCdnKeys(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::video::stitcher::v1::CdnKey>(std::move(span),
                                                  std::move(sr));
}

StatusOr<google::cloud::video::stitcher::v1::CdnKey>
VideoStitcherServiceTracingConnection::GetCdnKey(
    google::cloud::video::stitcher::v1::GetCdnKeyRequest const& request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::GetCdnKey");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetCdnKey(request));
}

future<StatusOr<google::cloud::video::stitcher::v1::OperationMetadata>>
VideoStitcherServiceTracingConnection::DeleteCdnKey(
    google::cloud::video::stitcher::v1::DeleteCdnKeyRequest const& request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::DeleteCdnKey");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteCdnKey(request));
}

StatusOr<google::longrunning::Operation>
VideoStitcherServiceTracingConnection::DeleteCdnKey(
    NoAwaitTag,
    google::cloud::video::stitcher::v1::DeleteCdnKeyRequest const& request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::DeleteCdnKey");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteCdnKey(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::video::stitcher::v1::OperationMetadata>>
VideoStitcherServiceTracingConnection::DeleteCdnKey(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::DeleteCdnKey");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteCdnKey(operation));
}

future<StatusOr<google::cloud::video::stitcher::v1::CdnKey>>
VideoStitcherServiceTracingConnection::UpdateCdnKey(
    google::cloud::video::stitcher::v1::UpdateCdnKeyRequest const& request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::UpdateCdnKey");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateCdnKey(request));
}

StatusOr<google::longrunning::Operation>
VideoStitcherServiceTracingConnection::UpdateCdnKey(
    NoAwaitTag,
    google::cloud::video::stitcher::v1::UpdateCdnKeyRequest const& request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::UpdateCdnKey");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->UpdateCdnKey(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::video::stitcher::v1::CdnKey>>
VideoStitcherServiceTracingConnection::UpdateCdnKey(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::UpdateCdnKey");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateCdnKey(operation));
}

StatusOr<google::cloud::video::stitcher::v1::VodSession>
VideoStitcherServiceTracingConnection::CreateVodSession(
    google::cloud::video::stitcher::v1::CreateVodSessionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::CreateVodSession");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateVodSession(request));
}

StatusOr<google::cloud::video::stitcher::v1::VodSession>
VideoStitcherServiceTracingConnection::GetVodSession(
    google::cloud::video::stitcher::v1::GetVodSessionRequest const& request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::GetVodSession");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetVodSession(request));
}

StreamRange<google::cloud::video::stitcher::v1::VodStitchDetail>
VideoStitcherServiceTracingConnection::ListVodStitchDetails(
    google::cloud::video::stitcher::v1::ListVodStitchDetailsRequest request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::"
      "ListVodStitchDetails");
  internal::OTelScope scope(span);
  auto sr = child_->ListVodStitchDetails(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::video::stitcher::v1::VodStitchDetail>(std::move(span),
                                                           std::move(sr));
}

StatusOr<google::cloud::video::stitcher::v1::VodStitchDetail>
VideoStitcherServiceTracingConnection::GetVodStitchDetail(
    google::cloud::video::stitcher::v1::GetVodStitchDetailRequest const&
        request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::GetVodStitchDetail");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetVodStitchDetail(request));
}

StreamRange<google::cloud::video::stitcher::v1::VodAdTagDetail>
VideoStitcherServiceTracingConnection::ListVodAdTagDetails(
    google::cloud::video::stitcher::v1::ListVodAdTagDetailsRequest request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::ListVodAdTagDetails");
  internal::OTelScope scope(span);
  auto sr = child_->ListVodAdTagDetails(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::video::stitcher::v1::VodAdTagDetail>(std::move(span),
                                                          std::move(sr));
}

StatusOr<google::cloud::video::stitcher::v1::VodAdTagDetail>
VideoStitcherServiceTracingConnection::GetVodAdTagDetail(
    google::cloud::video::stitcher::v1::GetVodAdTagDetailRequest const&
        request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::GetVodAdTagDetail");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetVodAdTagDetail(request));
}

StreamRange<google::cloud::video::stitcher::v1::LiveAdTagDetail>
VideoStitcherServiceTracingConnection::ListLiveAdTagDetails(
    google::cloud::video::stitcher::v1::ListLiveAdTagDetailsRequest request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::"
      "ListLiveAdTagDetails");
  internal::OTelScope scope(span);
  auto sr = child_->ListLiveAdTagDetails(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::video::stitcher::v1::LiveAdTagDetail>(std::move(span),
                                                           std::move(sr));
}

StatusOr<google::cloud::video::stitcher::v1::LiveAdTagDetail>
VideoStitcherServiceTracingConnection::GetLiveAdTagDetail(
    google::cloud::video::stitcher::v1::GetLiveAdTagDetailRequest const&
        request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::GetLiveAdTagDetail");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetLiveAdTagDetail(request));
}

future<StatusOr<google::cloud::video::stitcher::v1::Slate>>
VideoStitcherServiceTracingConnection::CreateSlate(
    google::cloud::video::stitcher::v1::CreateSlateRequest const& request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::CreateSlate");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateSlate(request));
}

StatusOr<google::longrunning::Operation>
VideoStitcherServiceTracingConnection::CreateSlate(
    NoAwaitTag,
    google::cloud::video::stitcher::v1::CreateSlateRequest const& request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::CreateSlate");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateSlate(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::video::stitcher::v1::Slate>>
VideoStitcherServiceTracingConnection::CreateSlate(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::CreateSlate");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateSlate(operation));
}

StreamRange<google::cloud::video::stitcher::v1::Slate>
VideoStitcherServiceTracingConnection::ListSlates(
    google::cloud::video::stitcher::v1::ListSlatesRequest request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::ListSlates");
  internal::OTelScope scope(span);
  auto sr = child_->ListSlates(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::video::stitcher::v1::Slate>(std::move(span),
                                                 std::move(sr));
}

StatusOr<google::cloud::video::stitcher::v1::Slate>
VideoStitcherServiceTracingConnection::GetSlate(
    google::cloud::video::stitcher::v1::GetSlateRequest const& request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::GetSlate");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetSlate(request));
}

future<StatusOr<google::cloud::video::stitcher::v1::Slate>>
VideoStitcherServiceTracingConnection::UpdateSlate(
    google::cloud::video::stitcher::v1::UpdateSlateRequest const& request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::UpdateSlate");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateSlate(request));
}

StatusOr<google::longrunning::Operation>
VideoStitcherServiceTracingConnection::UpdateSlate(
    NoAwaitTag,
    google::cloud::video::stitcher::v1::UpdateSlateRequest const& request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::UpdateSlate");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->UpdateSlate(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::video::stitcher::v1::Slate>>
VideoStitcherServiceTracingConnection::UpdateSlate(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::UpdateSlate");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateSlate(operation));
}

future<StatusOr<google::cloud::video::stitcher::v1::OperationMetadata>>
VideoStitcherServiceTracingConnection::DeleteSlate(
    google::cloud::video::stitcher::v1::DeleteSlateRequest const& request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::DeleteSlate");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteSlate(request));
}

StatusOr<google::longrunning::Operation>
VideoStitcherServiceTracingConnection::DeleteSlate(
    NoAwaitTag,
    google::cloud::video::stitcher::v1::DeleteSlateRequest const& request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::DeleteSlate");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteSlate(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::video::stitcher::v1::OperationMetadata>>
VideoStitcherServiceTracingConnection::DeleteSlate(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::DeleteSlate");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteSlate(operation));
}

StatusOr<google::cloud::video::stitcher::v1::LiveSession>
VideoStitcherServiceTracingConnection::CreateLiveSession(
    google::cloud::video::stitcher::v1::CreateLiveSessionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::CreateLiveSession");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateLiveSession(request));
}

StatusOr<google::cloud::video::stitcher::v1::LiveSession>
VideoStitcherServiceTracingConnection::GetLiveSession(
    google::cloud::video::stitcher::v1::GetLiveSessionRequest const& request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::GetLiveSession");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetLiveSession(request));
}

future<StatusOr<google::cloud::video::stitcher::v1::LiveConfig>>
VideoStitcherServiceTracingConnection::CreateLiveConfig(
    google::cloud::video::stitcher::v1::CreateLiveConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::CreateLiveConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateLiveConfig(request));
}

StatusOr<google::longrunning::Operation>
VideoStitcherServiceTracingConnection::CreateLiveConfig(
    NoAwaitTag,
    google::cloud::video::stitcher::v1::CreateLiveConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::CreateLiveConfig");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateLiveConfig(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::video::stitcher::v1::LiveConfig>>
VideoStitcherServiceTracingConnection::CreateLiveConfig(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::CreateLiveConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateLiveConfig(operation));
}

StreamRange<google::cloud::video::stitcher::v1::LiveConfig>
VideoStitcherServiceTracingConnection::ListLiveConfigs(
    google::cloud::video::stitcher::v1::ListLiveConfigsRequest request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::ListLiveConfigs");
  internal::OTelScope scope(span);
  auto sr = child_->ListLiveConfigs(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::video::stitcher::v1::LiveConfig>(std::move(span),
                                                      std::move(sr));
}

StatusOr<google::cloud::video::stitcher::v1::LiveConfig>
VideoStitcherServiceTracingConnection::GetLiveConfig(
    google::cloud::video::stitcher::v1::GetLiveConfigRequest const& request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::GetLiveConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetLiveConfig(request));
}

future<StatusOr<google::cloud::video::stitcher::v1::OperationMetadata>>
VideoStitcherServiceTracingConnection::DeleteLiveConfig(
    google::cloud::video::stitcher::v1::DeleteLiveConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::DeleteLiveConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteLiveConfig(request));
}

StatusOr<google::longrunning::Operation>
VideoStitcherServiceTracingConnection::DeleteLiveConfig(
    NoAwaitTag,
    google::cloud::video::stitcher::v1::DeleteLiveConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::DeleteLiveConfig");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteLiveConfig(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::video::stitcher::v1::OperationMetadata>>
VideoStitcherServiceTracingConnection::DeleteLiveConfig(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::DeleteLiveConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteLiveConfig(operation));
}

future<StatusOr<google::cloud::video::stitcher::v1::LiveConfig>>
VideoStitcherServiceTracingConnection::UpdateLiveConfig(
    google::cloud::video::stitcher::v1::UpdateLiveConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::UpdateLiveConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateLiveConfig(request));
}

StatusOr<google::longrunning::Operation>
VideoStitcherServiceTracingConnection::UpdateLiveConfig(
    NoAwaitTag,
    google::cloud::video::stitcher::v1::UpdateLiveConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::UpdateLiveConfig");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateLiveConfig(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::video::stitcher::v1::LiveConfig>>
VideoStitcherServiceTracingConnection::UpdateLiveConfig(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::UpdateLiveConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateLiveConfig(operation));
}

future<StatusOr<google::cloud::video::stitcher::v1::VodConfig>>
VideoStitcherServiceTracingConnection::CreateVodConfig(
    google::cloud::video::stitcher::v1::CreateVodConfigRequest const& request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::CreateVodConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateVodConfig(request));
}

StatusOr<google::longrunning::Operation>
VideoStitcherServiceTracingConnection::CreateVodConfig(
    NoAwaitTag,
    google::cloud::video::stitcher::v1::CreateVodConfigRequest const& request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::CreateVodConfig");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateVodConfig(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::video::stitcher::v1::VodConfig>>
VideoStitcherServiceTracingConnection::CreateVodConfig(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::CreateVodConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateVodConfig(operation));
}

StreamRange<google::cloud::video::stitcher::v1::VodConfig>
VideoStitcherServiceTracingConnection::ListVodConfigs(
    google::cloud::video::stitcher::v1::ListVodConfigsRequest request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::ListVodConfigs");
  internal::OTelScope scope(span);
  auto sr = child_->ListVodConfigs(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::video::stitcher::v1::VodConfig>(std::move(span),
                                                     std::move(sr));
}

StatusOr<google::cloud::video::stitcher::v1::VodConfig>
VideoStitcherServiceTracingConnection::GetVodConfig(
    google::cloud::video::stitcher::v1::GetVodConfigRequest const& request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::GetVodConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetVodConfig(request));
}

future<StatusOr<google::cloud::video::stitcher::v1::OperationMetadata>>
VideoStitcherServiceTracingConnection::DeleteVodConfig(
    google::cloud::video::stitcher::v1::DeleteVodConfigRequest const& request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::DeleteVodConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteVodConfig(request));
}

StatusOr<google::longrunning::Operation>
VideoStitcherServiceTracingConnection::DeleteVodConfig(
    NoAwaitTag,
    google::cloud::video::stitcher::v1::DeleteVodConfigRequest const& request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::DeleteVodConfig");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteVodConfig(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::video::stitcher::v1::OperationMetadata>>
VideoStitcherServiceTracingConnection::DeleteVodConfig(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::DeleteVodConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteVodConfig(operation));
}

future<StatusOr<google::cloud::video::stitcher::v1::VodConfig>>
VideoStitcherServiceTracingConnection::UpdateVodConfig(
    google::cloud::video::stitcher::v1::UpdateVodConfigRequest const& request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::UpdateVodConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateVodConfig(request));
}

StatusOr<google::longrunning::Operation>
VideoStitcherServiceTracingConnection::UpdateVodConfig(
    NoAwaitTag,
    google::cloud::video::stitcher::v1::UpdateVodConfigRequest const& request) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::UpdateVodConfig");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateVodConfig(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::video::stitcher::v1::VodConfig>>
VideoStitcherServiceTracingConnection::UpdateVodConfig(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "video_stitcher_v1::VideoStitcherServiceConnection::UpdateVodConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateVodConfig(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<video_stitcher_v1::VideoStitcherServiceConnection>
MakeVideoStitcherServiceTracingConnection(
    std::shared_ptr<video_stitcher_v1::VideoStitcherServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<VideoStitcherServiceTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace video_stitcher_v1_internal
}  // namespace cloud
}  // namespace google
