// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/translate/v3/translation_service.proto

#include "google/cloud/translate/v3/internal/translation_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace translate_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

TranslationServiceTracingStub::TranslationServiceTracingStub(
    std::shared_ptr<TranslationServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::translation::v3::TranslateTextResponse>
TranslationServiceTracingStub::TranslateText(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::TranslateTextRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "TranslateText");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->TranslateText(context, options, request));
}

StatusOr<google::cloud::translation::v3::RomanizeTextResponse>
TranslationServiceTracingStub::RomanizeText(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::RomanizeTextRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "RomanizeText");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->RomanizeText(context, options, request));
}

StatusOr<google::cloud::translation::v3::DetectLanguageResponse>
TranslationServiceTracingStub::DetectLanguage(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::DetectLanguageRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "DetectLanguage");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DetectLanguage(context, options, request));
}

StatusOr<google::cloud::translation::v3::SupportedLanguages>
TranslationServiceTracingStub::GetSupportedLanguages(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::GetSupportedLanguagesRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.translation.v3.TranslationService",
                             "GetSupportedLanguages");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->GetSupportedLanguages(context, options, request));
}

StatusOr<google::cloud::translation::v3::TranslateDocumentResponse>
TranslationServiceTracingStub::TranslateDocument(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::TranslateDocumentRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "TranslateDocument");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->TranslateDocument(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
TranslationServiceTracingStub::AsyncBatchTranslateText(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::translation::v3::BatchTranslateTextRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "BatchTranslateText");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncBatchTranslateText(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
TranslationServiceTracingStub::BatchTranslateText(
    grpc::ClientContext& context, Options options,
    google::cloud::translation::v3::BatchTranslateTextRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "BatchTranslateText");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->BatchTranslateText(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
TranslationServiceTracingStub::AsyncBatchTranslateDocument(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::translation::v3::BatchTranslateDocumentRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.translation.v3.TranslationService",
                             "BatchTranslateDocument");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncBatchTranslateDocument(cq, context, std::move(options),
                                               request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
TranslationServiceTracingStub::BatchTranslateDocument(
    grpc::ClientContext& context, Options options,
    google::cloud::translation::v3::BatchTranslateDocumentRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.translation.v3.TranslationService",
                             "BatchTranslateDocument");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->BatchTranslateDocument(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
TranslationServiceTracingStub::AsyncCreateGlossary(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::translation::v3::CreateGlossaryRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "CreateGlossary");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateGlossary(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
TranslationServiceTracingStub::CreateGlossary(
    grpc::ClientContext& context, Options options,
    google::cloud::translation::v3::CreateGlossaryRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "CreateGlossary");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateGlossary(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
TranslationServiceTracingStub::AsyncUpdateGlossary(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::translation::v3::UpdateGlossaryRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "UpdateGlossary");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpdateGlossary(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
TranslationServiceTracingStub::UpdateGlossary(
    grpc::ClientContext& context, Options options,
    google::cloud::translation::v3::UpdateGlossaryRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "UpdateGlossary");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateGlossary(context, options, request));
}

StatusOr<google::cloud::translation::v3::ListGlossariesResponse>
TranslationServiceTracingStub::ListGlossaries(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::ListGlossariesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "ListGlossaries");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListGlossaries(context, options, request));
}

StatusOr<google::cloud::translation::v3::Glossary>
TranslationServiceTracingStub::GetGlossary(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::GetGlossaryRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "GetGlossary");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetGlossary(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
TranslationServiceTracingStub::AsyncDeleteGlossary(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::translation::v3::DeleteGlossaryRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "DeleteGlossary");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteGlossary(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
TranslationServiceTracingStub::DeleteGlossary(
    grpc::ClientContext& context, Options options,
    google::cloud::translation::v3::DeleteGlossaryRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "DeleteGlossary");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteGlossary(context, options, request));
}

StatusOr<google::cloud::translation::v3::GlossaryEntry>
TranslationServiceTracingStub::GetGlossaryEntry(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::GetGlossaryEntryRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "GetGlossaryEntry");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetGlossaryEntry(context, options, request));
}

StatusOr<google::cloud::translation::v3::ListGlossaryEntriesResponse>
TranslationServiceTracingStub::ListGlossaryEntries(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::ListGlossaryEntriesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "ListGlossaryEntries");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ListGlossaryEntries(context, options, request));
}

StatusOr<google::cloud::translation::v3::GlossaryEntry>
TranslationServiceTracingStub::CreateGlossaryEntry(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::CreateGlossaryEntryRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "CreateGlossaryEntry");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->CreateGlossaryEntry(context, options, request));
}

StatusOr<google::cloud::translation::v3::GlossaryEntry>
TranslationServiceTracingStub::UpdateGlossaryEntry(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::UpdateGlossaryEntryRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "UpdateGlossaryEntry");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->UpdateGlossaryEntry(context, options, request));
}

Status TranslationServiceTracingStub::DeleteGlossaryEntry(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::DeleteGlossaryEntryRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "DeleteGlossaryEntry");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->DeleteGlossaryEntry(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
TranslationServiceTracingStub::AsyncCreateDataset(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::translation::v3::CreateDatasetRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "CreateDataset");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateDataset(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
TranslationServiceTracingStub::CreateDataset(
    grpc::ClientContext& context, Options options,
    google::cloud::translation::v3::CreateDatasetRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "CreateDataset");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateDataset(context, options, request));
}

StatusOr<google::cloud::translation::v3::Dataset>
TranslationServiceTracingStub::GetDataset(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::GetDatasetRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "GetDataset");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetDataset(context, options, request));
}

StatusOr<google::cloud::translation::v3::ListDatasetsResponse>
TranslationServiceTracingStub::ListDatasets(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::ListDatasetsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "ListDatasets");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListDatasets(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
TranslationServiceTracingStub::AsyncDeleteDataset(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::translation::v3::DeleteDatasetRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "DeleteDataset");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteDataset(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
TranslationServiceTracingStub::DeleteDataset(
    grpc::ClientContext& context, Options options,
    google::cloud::translation::v3::DeleteDatasetRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "DeleteDataset");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteDataset(context, options, request));
}

StatusOr<google::cloud::translation::v3::AdaptiveMtDataset>
TranslationServiceTracingStub::CreateAdaptiveMtDataset(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::CreateAdaptiveMtDatasetRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.translation.v3.TranslationService",
                             "CreateAdaptiveMtDataset");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->CreateAdaptiveMtDataset(context, options, request));
}

Status TranslationServiceTracingStub::DeleteAdaptiveMtDataset(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::DeleteAdaptiveMtDatasetRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.translation.v3.TranslationService",
                             "DeleteAdaptiveMtDataset");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->DeleteAdaptiveMtDataset(context, options, request));
}

StatusOr<google::cloud::translation::v3::AdaptiveMtDataset>
TranslationServiceTracingStub::GetAdaptiveMtDataset(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::GetAdaptiveMtDatasetRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "GetAdaptiveMtDataset");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->GetAdaptiveMtDataset(context, options, request));
}

StatusOr<google::cloud::translation::v3::ListAdaptiveMtDatasetsResponse>
TranslationServiceTracingStub::ListAdaptiveMtDatasets(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::ListAdaptiveMtDatasetsRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.translation.v3.TranslationService",
                             "ListAdaptiveMtDatasets");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->ListAdaptiveMtDatasets(context, options, request));
}

StatusOr<google::cloud::translation::v3::AdaptiveMtTranslateResponse>
TranslationServiceTracingStub::AdaptiveMtTranslate(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::AdaptiveMtTranslateRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "AdaptiveMtTranslate");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->AdaptiveMtTranslate(context, options, request));
}

StatusOr<google::cloud::translation::v3::AdaptiveMtFile>
TranslationServiceTracingStub::GetAdaptiveMtFile(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::GetAdaptiveMtFileRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "GetAdaptiveMtFile");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->GetAdaptiveMtFile(context, options, request));
}

Status TranslationServiceTracingStub::DeleteAdaptiveMtFile(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::DeleteAdaptiveMtFileRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "DeleteAdaptiveMtFile");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->DeleteAdaptiveMtFile(context, options, request));
}

StatusOr<google::cloud::translation::v3::ImportAdaptiveMtFileResponse>
TranslationServiceTracingStub::ImportAdaptiveMtFile(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::ImportAdaptiveMtFileRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "ImportAdaptiveMtFile");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ImportAdaptiveMtFile(context, options, request));
}

StatusOr<google::cloud::translation::v3::ListAdaptiveMtFilesResponse>
TranslationServiceTracingStub::ListAdaptiveMtFiles(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::ListAdaptiveMtFilesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "ListAdaptiveMtFiles");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ListAdaptiveMtFiles(context, options, request));
}

StatusOr<google::cloud::translation::v3::ListAdaptiveMtSentencesResponse>
TranslationServiceTracingStub::ListAdaptiveMtSentences(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::ListAdaptiveMtSentencesRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.translation.v3.TranslationService",
                             "ListAdaptiveMtSentences");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->ListAdaptiveMtSentences(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
TranslationServiceTracingStub::AsyncImportData(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::translation::v3::ImportDataRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "ImportData");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncImportData(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
TranslationServiceTracingStub::ImportData(
    grpc::ClientContext& context, Options options,
    google::cloud::translation::v3::ImportDataRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "ImportData");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ImportData(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
TranslationServiceTracingStub::AsyncExportData(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::translation::v3::ExportDataRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "ExportData");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncExportData(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
TranslationServiceTracingStub::ExportData(
    grpc::ClientContext& context, Options options,
    google::cloud::translation::v3::ExportDataRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "ExportData");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ExportData(context, options, request));
}

StatusOr<google::cloud::translation::v3::ListExamplesResponse>
TranslationServiceTracingStub::ListExamples(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::ListExamplesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "ListExamples");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListExamples(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
TranslationServiceTracingStub::AsyncCreateModel(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::translation::v3::CreateModelRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "CreateModel");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateModel(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
TranslationServiceTracingStub::CreateModel(
    grpc::ClientContext& context, Options options,
    google::cloud::translation::v3::CreateModelRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "CreateModel");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateModel(context, options, request));
}

StatusOr<google::cloud::translation::v3::ListModelsResponse>
TranslationServiceTracingStub::ListModels(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::ListModelsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "ListModels");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListModels(context, options, request));
}

StatusOr<google::cloud::translation::v3::Model>
TranslationServiceTracingStub::GetModel(
    grpc::ClientContext& context, Options const& options,
    google::cloud::translation::v3::GetModelRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "GetModel");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetModel(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
TranslationServiceTracingStub::AsyncDeleteModel(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::translation::v3::DeleteModelRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "DeleteModel");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteModel(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
TranslationServiceTracingStub::DeleteModel(
    grpc::ClientContext& context, Options options,
    google::cloud::translation::v3::DeleteModelRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.translation.v3.TranslationService", "DeleteModel");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteModel(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
TranslationServiceTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> TranslationServiceTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<TranslationServiceStub> MakeTranslationServiceTracingStub(
    std::shared_ptr<TranslationServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<TranslationServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace translate_v3_internal
}  // namespace cloud
}  // namespace google
