// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/texttospeech/v1/cloud_tts.proto

#include "google/cloud/texttospeech/v1/internal/text_to_speech_connection_impl.h"
#include "google/cloud/texttospeech/v1/internal/text_to_speech_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace texttospeech_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<texttospeech_v1::TextToSpeechRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<texttospeech_v1::TextToSpeechRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<texttospeech_v1::TextToSpeechBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<texttospeech_v1::TextToSpeechConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<texttospeech_v1::TextToSpeechConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

TextToSpeechConnectionImpl::TextToSpeechConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<texttospeech_v1_internal::TextToSpeechStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      TextToSpeechConnection::options())) {}

StatusOr<google::cloud::texttospeech::v1::ListVoicesResponse>
TextToSpeechConnectionImpl::ListVoices(
    google::cloud::texttospeech::v1::ListVoicesRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ListVoices(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::texttospeech::v1::ListVoicesRequest const& request) {
        return stub_->ListVoices(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::texttospeech::v1::SynthesizeSpeechResponse>
TextToSpeechConnectionImpl::SynthesizeSpeech(
    google::cloud::texttospeech::v1::SynthesizeSpeechRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->SynthesizeSpeech(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::texttospeech::v1::SynthesizeSpeechRequest const&
                 request) {
        return stub_->SynthesizeSpeech(context, options, request);
      },
      *current, request, __func__);
}

std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::cloud::texttospeech::v1::StreamingSynthesizeRequest,
    google::cloud::texttospeech::v1::StreamingSynthesizeResponse>>
TextToSpeechConnectionImpl::AsyncStreamingSynthesize() {
  return stub_->AsyncStreamingSynthesize(
      background_->cq(), std::make_shared<grpc::ClientContext>(),
      internal::SaveCurrentOptions());
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace texttospeech_v1_internal
}  // namespace cloud
}  // namespace google
