// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/support/v2/case_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SUPPORT_V2_MOCKS_MOCK_CASE_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SUPPORT_V2_MOCKS_MOCK_CASE_CONNECTION_H

#include "google/cloud/support/v2/case_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace support_v2_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `CaseServiceConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `CaseServiceClient`. To do so,
 * construct an object of type `CaseServiceClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockCaseServiceConnection : public support_v2::CaseServiceConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(StatusOr<google::cloud::support::v2::Case>, GetCase,
              (google::cloud::support::v2::GetCaseRequest const& request),
              (override));

  MOCK_METHOD((StreamRange<google::cloud::support::v2::Case>), ListCases,
              (google::cloud::support::v2::ListCasesRequest request),
              (override));

  MOCK_METHOD((StreamRange<google::cloud::support::v2::Case>), SearchCases,
              (google::cloud::support::v2::SearchCasesRequest request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::support::v2::Case>, CreateCase,
              (google::cloud::support::v2::CreateCaseRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::support::v2::Case>, UpdateCase,
              (google::cloud::support::v2::UpdateCaseRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::support::v2::Case>, EscalateCase,
              (google::cloud::support::v2::EscalateCaseRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::support::v2::Case>, CloseCase,
              (google::cloud::support::v2::CloseCaseRequest const& request),
              (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::support::v2::CaseClassification>),
      SearchCaseClassifications,
      (google::cloud::support::v2::SearchCaseClassificationsRequest request),
      (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace support_v2_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SUPPORT_V2_MOCKS_MOCK_CASE_CONNECTION_H
