// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/storage/control/v2/storage_control.proto

#include "google/cloud/storagecontrol/v2/storage_control_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace storagecontrol_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

StorageControlConnectionIdempotencyPolicy::
    ~StorageControlConnectionIdempotencyPolicy() = default;

std::unique_ptr<StorageControlConnectionIdempotencyPolicy>
StorageControlConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<StorageControlConnectionIdempotencyPolicy>(*this);
}

Idempotency StorageControlConnectionIdempotencyPolicy::CreateFolder(
    google::storage::control::v2::CreateFolderRequest const& request) {
  if (!request.request_id().empty()) return Idempotency::kIdempotent;
  return Idempotency::kNonIdempotent;
}

Idempotency StorageControlConnectionIdempotencyPolicy::DeleteFolder(
    google::storage::control::v2::DeleteFolderRequest const& request) {
  if (!request.request_id().empty()) return Idempotency::kIdempotent;
  return Idempotency::kNonIdempotent;
}

Idempotency StorageControlConnectionIdempotencyPolicy::GetFolder(
    google::storage::control::v2::GetFolderRequest const& request) {
  if (!request.request_id().empty()) return Idempotency::kIdempotent;
  return Idempotency::kIdempotent;
}

Idempotency StorageControlConnectionIdempotencyPolicy::ListFolders(
    google::storage::control::v2::ListFoldersRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency StorageControlConnectionIdempotencyPolicy::RenameFolder(
    google::storage::control::v2::RenameFolderRequest const& request) {
  if (!request.request_id().empty()) return Idempotency::kIdempotent;
  return Idempotency::kNonIdempotent;
}

Idempotency StorageControlConnectionIdempotencyPolicy::GetStorageLayout(
    google::storage::control::v2::GetStorageLayoutRequest const& request) {
  if (!request.request_id().empty()) return Idempotency::kIdempotent;
  return Idempotency::kIdempotent;
}

Idempotency StorageControlConnectionIdempotencyPolicy::CreateManagedFolder(
    google::storage::control::v2::CreateManagedFolderRequest const& request) {
  if (!request.request_id().empty()) return Idempotency::kIdempotent;
  return Idempotency::kNonIdempotent;
}

Idempotency StorageControlConnectionIdempotencyPolicy::DeleteManagedFolder(
    google::storage::control::v2::DeleteManagedFolderRequest const& request) {
  if (!request.request_id().empty()) return Idempotency::kIdempotent;
  return Idempotency::kNonIdempotent;
}

Idempotency StorageControlConnectionIdempotencyPolicy::GetManagedFolder(
    google::storage::control::v2::GetManagedFolderRequest const& request) {
  if (!request.request_id().empty()) return Idempotency::kIdempotent;
  return Idempotency::kNonIdempotent;
}

Idempotency StorageControlConnectionIdempotencyPolicy::ListManagedFolders(
    google::storage::control::v2::ListManagedFoldersRequest
        request) {  // NOLINT
  if (!request.request_id().empty()) return Idempotency::kIdempotent;
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<StorageControlConnectionIdempotencyPolicy>
MakeDefaultStorageControlConnectionIdempotencyPolicy() {
  return std::make_unique<StorageControlConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace storagecontrol_v2
}  // namespace cloud
}  // namespace google
