// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/servicemanagement/v1/servicemanager.proto

#include "google/cloud/servicemanagement/v1/service_manager_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace servicemanagement_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ServiceManagerConnectionIdempotencyPolicy::
    ~ServiceManagerConnectionIdempotencyPolicy() = default;

std::unique_ptr<ServiceManagerConnectionIdempotencyPolicy>
ServiceManagerConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<ServiceManagerConnectionIdempotencyPolicy>(*this);
}

Idempotency ServiceManagerConnectionIdempotencyPolicy::ListServices(
    google::api::servicemanagement::v1::ListServicesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ServiceManagerConnectionIdempotencyPolicy::GetService(
    google::api::servicemanagement::v1::GetServiceRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ServiceManagerConnectionIdempotencyPolicy::CreateService(
    google::api::servicemanagement::v1::CreateServiceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ServiceManagerConnectionIdempotencyPolicy::DeleteService(
    google::api::servicemanagement::v1::DeleteServiceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ServiceManagerConnectionIdempotencyPolicy::UndeleteService(
    google::api::servicemanagement::v1::UndeleteServiceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ServiceManagerConnectionIdempotencyPolicy::ListServiceConfigs(
    google::api::servicemanagement::v1::ListServiceConfigsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ServiceManagerConnectionIdempotencyPolicy::GetServiceConfig(
    google::api::servicemanagement::v1::GetServiceConfigRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ServiceManagerConnectionIdempotencyPolicy::CreateServiceConfig(
    google::api::servicemanagement::v1::CreateServiceConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ServiceManagerConnectionIdempotencyPolicy::SubmitConfigSource(
    google::api::servicemanagement::v1::SubmitConfigSourceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ServiceManagerConnectionIdempotencyPolicy::ListServiceRollouts(
    google::api::servicemanagement::v1::ListServiceRolloutsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ServiceManagerConnectionIdempotencyPolicy::GetServiceRollout(
    google::api::servicemanagement::v1::GetServiceRolloutRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ServiceManagerConnectionIdempotencyPolicy::CreateServiceRollout(
    google::api::servicemanagement::v1::CreateServiceRolloutRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ServiceManagerConnectionIdempotencyPolicy::GenerateConfigReport(
    google::api::servicemanagement::v1::GenerateConfigReportRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<ServiceManagerConnectionIdempotencyPolicy>
MakeDefaultServiceManagerConnectionIdempotencyPolicy() {
  return std::make_unique<ServiceManagerConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicemanagement_v1
}  // namespace cloud
}  // namespace google
