// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/user_event_service.proto

#include "google/cloud/retail/v2/user_event_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace retail_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

UserEventServiceClient::UserEventServiceClient(
    std::shared_ptr<UserEventServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
UserEventServiceClient::~UserEventServiceClient() = default;

StatusOr<google::cloud::retail::v2::UserEvent>
UserEventServiceClient::WriteUserEvent(
    google::cloud::retail::v2::WriteUserEventRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->WriteUserEvent(request);
}

StatusOr<google::api::HttpBody> UserEventServiceClient::CollectUserEvent(
    google::cloud::retail::v2::CollectUserEventRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CollectUserEvent(request);
}

future<StatusOr<google::cloud::retail::v2::PurgeUserEventsResponse>>
UserEventServiceClient::PurgeUserEvents(
    google::cloud::retail::v2::PurgeUserEventsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PurgeUserEvents(request);
}

StatusOr<google::longrunning::Operation>
UserEventServiceClient::PurgeUserEvents(
    NoAwaitTag,
    google::cloud::retail::v2::PurgeUserEventsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PurgeUserEvents(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::retail::v2::PurgeUserEventsResponse>>
UserEventServiceClient::PurgeUserEvents(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PurgeUserEvents(operation);
}

future<StatusOr<google::cloud::retail::v2::ImportUserEventsResponse>>
UserEventServiceClient::ImportUserEvents(
    google::cloud::retail::v2::ImportUserEventsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportUserEvents(request);
}

StatusOr<google::longrunning::Operation>
UserEventServiceClient::ImportUserEvents(
    NoAwaitTag,
    google::cloud::retail::v2::ImportUserEventsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportUserEvents(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::retail::v2::ImportUserEventsResponse>>
UserEventServiceClient::ImportUserEvents(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportUserEvents(operation);
}

future<StatusOr<google::cloud::retail::v2::RejoinUserEventsResponse>>
UserEventServiceClient::RejoinUserEvents(
    google::cloud::retail::v2::RejoinUserEventsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RejoinUserEvents(request);
}

StatusOr<google::longrunning::Operation>
UserEventServiceClient::RejoinUserEvents(
    NoAwaitTag,
    google::cloud::retail::v2::RejoinUserEventsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RejoinUserEvents(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::retail::v2::RejoinUserEventsResponse>>
UserEventServiceClient::RejoinUserEvents(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RejoinUserEvents(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail_v2
}  // namespace cloud
}  // namespace google
