// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/notebooks/v1/managed_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_V1_MANAGED_NOTEBOOK_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_V1_MANAGED_NOTEBOOK_CONNECTION_H

#include "google/cloud/notebooks/v1/internal/managed_notebook_retry_traits.h"
#include "google/cloud/notebooks/v1/managed_notebook_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/notebooks/v1/managed_service.pb.h>
#include <google/cloud/notebooks/v1/service.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace notebooks_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `ManagedNotebookServiceConnection`.
class ManagedNotebookServiceRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<ManagedNotebookServiceRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `ManagedNotebookServiceConnection` based on counting
 * errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class ManagedNotebookServiceLimitedErrorCountRetryPolicy
    : public ManagedNotebookServiceRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit ManagedNotebookServiceLimitedErrorCountRetryPolicy(
      int maximum_failures)
      : impl_(maximum_failures) {}

  ManagedNotebookServiceLimitedErrorCountRetryPolicy(
      ManagedNotebookServiceLimitedErrorCountRetryPolicy&& rhs) noexcept
      : ManagedNotebookServiceLimitedErrorCountRetryPolicy(
            rhs.maximum_failures()) {}
  ManagedNotebookServiceLimitedErrorCountRetryPolicy(
      ManagedNotebookServiceLimitedErrorCountRetryPolicy const& rhs) noexcept
      : ManagedNotebookServiceLimitedErrorCountRetryPolicy(
            rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<ManagedNotebookServiceRetryPolicy> clone() const override {
    return std::make_unique<ManagedNotebookServiceLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = ManagedNotebookServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      notebooks_v1_internal::ManagedNotebookServiceRetryTraits>
      impl_;
};

/**
 * A retry policy for `ManagedNotebookServiceConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class ManagedNotebookServiceLimitedTimeRetryPolicy
    : public ManagedNotebookServiceRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit ManagedNotebookServiceLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  ManagedNotebookServiceLimitedTimeRetryPolicy(
      ManagedNotebookServiceLimitedTimeRetryPolicy&& rhs) noexcept
      : ManagedNotebookServiceLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  ManagedNotebookServiceLimitedTimeRetryPolicy(
      ManagedNotebookServiceLimitedTimeRetryPolicy const& rhs) noexcept
      : ManagedNotebookServiceLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<ManagedNotebookServiceRetryPolicy> clone() const override {
    return std::make_unique<ManagedNotebookServiceLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = ManagedNotebookServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      notebooks_v1_internal::ManagedNotebookServiceRetryTraits>
      impl_;
};

/**
 * The `ManagedNotebookServiceConnection` object for
 * `ManagedNotebookServiceClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `ManagedNotebookServiceClient`. This allows users to inject custom
 * behavior (e.g., with a Google Mock object) when writing tests that use
 * objects of type `ManagedNotebookServiceClient`.
 *
 * To create a concrete instance, see `MakeManagedNotebookServiceConnection()`.
 *
 * For mocking, see `notebooks_v1_mocks::MockManagedNotebookServiceConnection`.
 */
class ManagedNotebookServiceConnection {
 public:
  virtual ~ManagedNotebookServiceConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StreamRange<google::cloud::notebooks::v1::Runtime> ListRuntimes(
      google::cloud::notebooks::v1::ListRuntimesRequest request);

  virtual StatusOr<google::cloud::notebooks::v1::Runtime> GetRuntime(
      google::cloud::notebooks::v1::GetRuntimeRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Runtime>> CreateRuntime(
      google::cloud::notebooks::v1::CreateRuntimeRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateRuntime(
      NoAwaitTag,
      google::cloud::notebooks::v1::CreateRuntimeRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Runtime>> CreateRuntime(
      google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::notebooks::v1::Runtime>> UpdateRuntime(
      google::cloud::notebooks::v1::UpdateRuntimeRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateRuntime(
      NoAwaitTag,
      google::cloud::notebooks::v1::UpdateRuntimeRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Runtime>> UpdateRuntime(
      google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteRuntime(
      google::cloud::notebooks::v1::DeleteRuntimeRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteRuntime(
      NoAwaitTag,
      google::cloud::notebooks::v1::DeleteRuntimeRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteRuntime(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::notebooks::v1::Runtime>> StartRuntime(
      google::cloud::notebooks::v1::StartRuntimeRequest const& request);

  virtual StatusOr<google::longrunning::Operation> StartRuntime(
      NoAwaitTag,
      google::cloud::notebooks::v1::StartRuntimeRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Runtime>> StartRuntime(
      google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::notebooks::v1::Runtime>> StopRuntime(
      google::cloud::notebooks::v1::StopRuntimeRequest const& request);

  virtual StatusOr<google::longrunning::Operation> StopRuntime(
      NoAwaitTag,
      google::cloud::notebooks::v1::StopRuntimeRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Runtime>> StopRuntime(
      google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::notebooks::v1::Runtime>> SwitchRuntime(
      google::cloud::notebooks::v1::SwitchRuntimeRequest const& request);

  virtual StatusOr<google::longrunning::Operation> SwitchRuntime(
      NoAwaitTag,
      google::cloud::notebooks::v1::SwitchRuntimeRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Runtime>> SwitchRuntime(
      google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::notebooks::v1::Runtime>> ResetRuntime(
      google::cloud::notebooks::v1::ResetRuntimeRequest const& request);

  virtual StatusOr<google::longrunning::Operation> ResetRuntime(
      NoAwaitTag,
      google::cloud::notebooks::v1::ResetRuntimeRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Runtime>> ResetRuntime(
      google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::notebooks::v1::Runtime>>
  UpgradeRuntime(
      google::cloud::notebooks::v1::UpgradeRuntimeRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpgradeRuntime(
      NoAwaitTag,
      google::cloud::notebooks::v1::UpgradeRuntimeRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Runtime>>
  UpgradeRuntime(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::notebooks::v1::Runtime>>
  ReportRuntimeEvent(
      google::cloud::notebooks::v1::ReportRuntimeEventRequest const& request);

  virtual StatusOr<google::longrunning::Operation> ReportRuntimeEvent(
      NoAwaitTag,
      google::cloud::notebooks::v1::ReportRuntimeEventRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Runtime>>
  ReportRuntimeEvent(google::longrunning::Operation const& operation);

  virtual StatusOr<
      google::cloud::notebooks::v1::RefreshRuntimeTokenInternalResponse>
  RefreshRuntimeTokenInternal(
      google::cloud::notebooks::v1::RefreshRuntimeTokenInternalRequest const&
          request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Runtime>>
  DiagnoseRuntime(
      google::cloud::notebooks::v1::DiagnoseRuntimeRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DiagnoseRuntime(
      NoAwaitTag,
      google::cloud::notebooks::v1::DiagnoseRuntimeRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Runtime>>
  DiagnoseRuntime(google::longrunning::Operation const& operation);
};

/**
 * A factory function to construct an object of type
 * `ManagedNotebookServiceConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of
 * ManagedNotebookServiceClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `ManagedNotebookServiceConnection`. Expected options are any of the
 * types in the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::notebooks_v1::ManagedNotebookServicePolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `ManagedNotebookServiceConnection`
 * created by this function.
 */
std::shared_ptr<ManagedNotebookServiceConnection>
MakeManagedNotebookServiceConnection(Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace notebooks_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_V1_MANAGED_NOTEBOOK_CONNECTION_H
