// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/notebooks/v1/managed_service.proto

#include "google/cloud/notebooks/v1/managed_notebook_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace notebooks_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ManagedNotebookServiceClient::ManagedNotebookServiceClient(
    std::shared_ptr<ManagedNotebookServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
ManagedNotebookServiceClient::~ManagedNotebookServiceClient() = default;

StreamRange<google::cloud::notebooks::v1::Runtime>
ManagedNotebookServiceClient::ListRuntimes(std::string const& parent,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::ListRuntimesRequest request;
  request.set_parent(parent);
  return connection_->ListRuntimes(request);
}

StreamRange<google::cloud::notebooks::v1::Runtime>
ManagedNotebookServiceClient::ListRuntimes(
    google::cloud::notebooks::v1::ListRuntimesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListRuntimes(std::move(request));
}

StatusOr<google::cloud::notebooks::v1::Runtime>
ManagedNotebookServiceClient::GetRuntime(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::GetRuntimeRequest request;
  request.set_name(name);
  return connection_->GetRuntime(request);
}

StatusOr<google::cloud::notebooks::v1::Runtime>
ManagedNotebookServiceClient::GetRuntime(
    google::cloud::notebooks::v1::GetRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetRuntime(request);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::CreateRuntime(
    std::string const& parent, std::string const& runtime_id,
    google::cloud::notebooks::v1::Runtime const& runtime, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::CreateRuntimeRequest request;
  request.set_parent(parent);
  request.set_runtime_id(runtime_id);
  *request.mutable_runtime() = runtime;
  return connection_->CreateRuntime(request);
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceClient::CreateRuntime(
    NoAwaitTag, std::string const& parent, std::string const& runtime_id,
    google::cloud::notebooks::v1::Runtime const& runtime, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::CreateRuntimeRequest request;
  request.set_parent(parent);
  request.set_runtime_id(runtime_id);
  *request.mutable_runtime() = runtime;
  return connection_->CreateRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::CreateRuntime(
    google::cloud::notebooks::v1::CreateRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateRuntime(request);
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceClient::CreateRuntime(
    NoAwaitTag,
    google::cloud::notebooks::v1::CreateRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::CreateRuntime(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateRuntime(operation);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::UpdateRuntime(
    google::cloud::notebooks::v1::Runtime const& runtime,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::UpdateRuntimeRequest request;
  *request.mutable_runtime() = runtime;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateRuntime(request);
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceClient::UpdateRuntime(
    NoAwaitTag, google::cloud::notebooks::v1::Runtime const& runtime,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::UpdateRuntimeRequest request;
  *request.mutable_runtime() = runtime;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::UpdateRuntime(
    google::cloud::notebooks::v1::UpdateRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateRuntime(request);
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceClient::UpdateRuntime(
    NoAwaitTag,
    google::cloud::notebooks::v1::UpdateRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::UpdateRuntime(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateRuntime(operation);
}

future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
ManagedNotebookServiceClient::DeleteRuntime(std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::DeleteRuntimeRequest request;
  request.set_name(name);
  return connection_->DeleteRuntime(request);
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceClient::DeleteRuntime(NoAwaitTag, std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::DeleteRuntimeRequest request;
  request.set_name(name);
  return connection_->DeleteRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
ManagedNotebookServiceClient::DeleteRuntime(
    google::cloud::notebooks::v1::DeleteRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteRuntime(request);
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceClient::DeleteRuntime(
    NoAwaitTag,
    google::cloud::notebooks::v1::DeleteRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
ManagedNotebookServiceClient::DeleteRuntime(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteRuntime(operation);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::StartRuntime(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::StartRuntimeRequest request;
  request.set_name(name);
  return connection_->StartRuntime(request);
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceClient::StartRuntime(NoAwaitTag, std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::StartRuntimeRequest request;
  request.set_name(name);
  return connection_->StartRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::StartRuntime(
    google::cloud::notebooks::v1::StartRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StartRuntime(request);
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceClient::StartRuntime(
    NoAwaitTag,
    google::cloud::notebooks::v1::StartRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StartRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::StartRuntime(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StartRuntime(operation);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::StopRuntime(std::string const& name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::StopRuntimeRequest request;
  request.set_name(name);
  return connection_->StopRuntime(request);
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceClient::StopRuntime(NoAwaitTag, std::string const& name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::StopRuntimeRequest request;
  request.set_name(name);
  return connection_->StopRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::StopRuntime(
    google::cloud::notebooks::v1::StopRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StopRuntime(request);
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceClient::StopRuntime(
    NoAwaitTag, google::cloud::notebooks::v1::StopRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StopRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::StopRuntime(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StopRuntime(operation);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::SwitchRuntime(std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::SwitchRuntimeRequest request;
  request.set_name(name);
  return connection_->SwitchRuntime(request);
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceClient::SwitchRuntime(NoAwaitTag, std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::SwitchRuntimeRequest request;
  request.set_name(name);
  return connection_->SwitchRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::SwitchRuntime(
    google::cloud::notebooks::v1::SwitchRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SwitchRuntime(request);
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceClient::SwitchRuntime(
    NoAwaitTag,
    google::cloud::notebooks::v1::SwitchRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SwitchRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::SwitchRuntime(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SwitchRuntime(operation);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::ResetRuntime(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::ResetRuntimeRequest request;
  request.set_name(name);
  return connection_->ResetRuntime(request);
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceClient::ResetRuntime(NoAwaitTag, std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::ResetRuntimeRequest request;
  request.set_name(name);
  return connection_->ResetRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::ResetRuntime(
    google::cloud::notebooks::v1::ResetRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ResetRuntime(request);
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceClient::ResetRuntime(
    NoAwaitTag,
    google::cloud::notebooks::v1::ResetRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ResetRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::ResetRuntime(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ResetRuntime(operation);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::UpgradeRuntime(std::string const& name,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::UpgradeRuntimeRequest request;
  request.set_name(name);
  return connection_->UpgradeRuntime(request);
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceClient::UpgradeRuntime(NoAwaitTag,
                                             std::string const& name,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::UpgradeRuntimeRequest request;
  request.set_name(name);
  return connection_->UpgradeRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::UpgradeRuntime(
    google::cloud::notebooks::v1::UpgradeRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpgradeRuntime(request);
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceClient::UpgradeRuntime(
    NoAwaitTag,
    google::cloud::notebooks::v1::UpgradeRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpgradeRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::UpgradeRuntime(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpgradeRuntime(operation);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::ReportRuntimeEvent(std::string const& name,
                                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::ReportRuntimeEventRequest request;
  request.set_name(name);
  return connection_->ReportRuntimeEvent(request);
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceClient::ReportRuntimeEvent(NoAwaitTag,
                                                 std::string const& name,
                                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::ReportRuntimeEventRequest request;
  request.set_name(name);
  return connection_->ReportRuntimeEvent(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::ReportRuntimeEvent(
    google::cloud::notebooks::v1::ReportRuntimeEventRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ReportRuntimeEvent(request);
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceClient::ReportRuntimeEvent(
    NoAwaitTag,
    google::cloud::notebooks::v1::ReportRuntimeEventRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ReportRuntimeEvent(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::ReportRuntimeEvent(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ReportRuntimeEvent(operation);
}

StatusOr<google::cloud::notebooks::v1::RefreshRuntimeTokenInternalResponse>
ManagedNotebookServiceClient::RefreshRuntimeTokenInternal(
    std::string const& name, std::string const& vm_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::RefreshRuntimeTokenInternalRequest request;
  request.set_name(name);
  request.set_vm_id(vm_id);
  return connection_->RefreshRuntimeTokenInternal(request);
}

StatusOr<google::cloud::notebooks::v1::RefreshRuntimeTokenInternalResponse>
ManagedNotebookServiceClient::RefreshRuntimeTokenInternal(
    google::cloud::notebooks::v1::RefreshRuntimeTokenInternalRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RefreshRuntimeTokenInternal(request);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::DiagnoseRuntime(
    std::string const& name,
    google::cloud::notebooks::v1::DiagnosticConfig const& diagnostic_config,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::DiagnoseRuntimeRequest request;
  request.set_name(name);
  *request.mutable_diagnostic_config() = diagnostic_config;
  return connection_->DiagnoseRuntime(request);
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceClient::DiagnoseRuntime(
    NoAwaitTag, std::string const& name,
    google::cloud::notebooks::v1::DiagnosticConfig const& diagnostic_config,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::DiagnoseRuntimeRequest request;
  request.set_name(name);
  *request.mutable_diagnostic_config() = diagnostic_config;
  return connection_->DiagnoseRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::DiagnoseRuntime(
    google::cloud::notebooks::v1::DiagnoseRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DiagnoseRuntime(request);
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceClient::DiagnoseRuntime(
    NoAwaitTag,
    google::cloud::notebooks::v1::DiagnoseRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DiagnoseRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceClient::DiagnoseRuntime(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DiagnoseRuntime(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace notebooks_v1
}  // namespace cloud
}  // namespace google
