// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkservices/v1/dep.proto

#include "google/cloud/networkservices/v1/internal/dep_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/networkservices/v1/dep.grpc.pb.h>
#include <memory>
#include <set>
#include <string>
#include <utility>

namespace google {
namespace cloud {
namespace networkservices_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DepServiceLogging::DepServiceLogging(std::shared_ptr<DepServiceStub> child,
                                     TracingOptions tracing_options,
                                     std::set<std::string> const&)
    : child_(std::move(child)), tracing_options_(std::move(tracing_options)) {}

StatusOr<google::cloud::networkservices::v1::ListLbTrafficExtensionsResponse>
DepServiceLogging::ListLbTrafficExtensions(
    grpc::ClientContext& context, Options const& options,
    google::cloud::networkservices::v1::ListLbTrafficExtensionsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::networkservices::v1::
                 ListLbTrafficExtensionsRequest const& request) {
        return child_->ListLbTrafficExtensions(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>
DepServiceLogging::GetLbTrafficExtension(
    grpc::ClientContext& context, Options const& options,
    google::cloud::networkservices::v1::GetLbTrafficExtensionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::networkservices::v1::
                 GetLbTrafficExtensionRequest const& request) {
        return child_->GetLbTrafficExtension(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
DepServiceLogging::AsyncCreateLbTrafficExtension(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::CreateLbTrafficExtensionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::networkservices::v1::
                 CreateLbTrafficExtensionRequest const& request) {
        return child_->AsyncCreateLbTrafficExtension(
            cq, std::move(context), std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
DepServiceLogging::CreateLbTrafficExtension(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::CreateLbTrafficExtensionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::networkservices::v1::
                 CreateLbTrafficExtensionRequest const& request) {
        return child_->CreateLbTrafficExtension(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
DepServiceLogging::AsyncUpdateLbTrafficExtension(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::UpdateLbTrafficExtensionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::networkservices::v1::
                 UpdateLbTrafficExtensionRequest const& request) {
        return child_->AsyncUpdateLbTrafficExtension(
            cq, std::move(context), std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
DepServiceLogging::UpdateLbTrafficExtension(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::UpdateLbTrafficExtensionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::networkservices::v1::
                 UpdateLbTrafficExtensionRequest const& request) {
        return child_->UpdateLbTrafficExtension(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
DepServiceLogging::AsyncDeleteLbTrafficExtension(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::DeleteLbTrafficExtensionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::networkservices::v1::
                 DeleteLbTrafficExtensionRequest const& request) {
        return child_->AsyncDeleteLbTrafficExtension(
            cq, std::move(context), std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
DepServiceLogging::DeleteLbTrafficExtension(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::DeleteLbTrafficExtensionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::networkservices::v1::
                 DeleteLbTrafficExtensionRequest const& request) {
        return child_->DeleteLbTrafficExtension(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::networkservices::v1::ListLbRouteExtensionsResponse>
DepServiceLogging::ListLbRouteExtensions(
    grpc::ClientContext& context, Options const& options,
    google::cloud::networkservices::v1::ListLbRouteExtensionsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::networkservices::v1::
                 ListLbRouteExtensionsRequest const& request) {
        return child_->ListLbRouteExtensions(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::networkservices::v1::LbRouteExtension>
DepServiceLogging::GetLbRouteExtension(
    grpc::ClientContext& context, Options const& options,
    google::cloud::networkservices::v1::GetLbRouteExtensionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::networkservices::v1::GetLbRouteExtensionRequest const&
              request) {
        return child_->GetLbRouteExtension(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
DepServiceLogging::AsyncCreateLbRouteExtension(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::CreateLbRouteExtensionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::networkservices::v1::
                 CreateLbRouteExtensionRequest const& request) {
        return child_->AsyncCreateLbRouteExtension(cq, std::move(context),
                                                   std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
DepServiceLogging::CreateLbRouteExtension(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::CreateLbRouteExtensionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::networkservices::v1::
                 CreateLbRouteExtensionRequest const& request) {
        return child_->CreateLbRouteExtension(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
DepServiceLogging::AsyncUpdateLbRouteExtension(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::UpdateLbRouteExtensionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::networkservices::v1::
                 UpdateLbRouteExtensionRequest const& request) {
        return child_->AsyncUpdateLbRouteExtension(cq, std::move(context),
                                                   std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
DepServiceLogging::UpdateLbRouteExtension(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::UpdateLbRouteExtensionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::networkservices::v1::
                 UpdateLbRouteExtensionRequest const& request) {
        return child_->UpdateLbRouteExtension(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
DepServiceLogging::AsyncDeleteLbRouteExtension(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::DeleteLbRouteExtensionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::networkservices::v1::
                 DeleteLbRouteExtensionRequest const& request) {
        return child_->AsyncDeleteLbRouteExtension(cq, std::move(context),
                                                   std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
DepServiceLogging::DeleteLbRouteExtension(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::DeleteLbRouteExtensionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::networkservices::v1::
                 DeleteLbRouteExtensionRequest const& request) {
        return child_->DeleteLbRouteExtension(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
DepServiceLogging::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::longrunning::GetOperationRequest const& request) {
        return child_->AsyncGetOperation(cq, std::move(context),
                                         std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

future<Status> DepServiceLogging::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::longrunning::CancelOperationRequest const& request) {
        return child_->AsyncCancelOperation(cq, std::move(context),
                                            std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkservices_v1_internal
}  // namespace cloud
}  // namespace google
