// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkehub/v1/service.proto

#include "google/cloud/gkehub/v1/internal/gke_hub_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace gkehub_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

GkeHubTracingStub::GkeHubTracingStub(std::shared_ptr<GkeHubStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::gkehub::v1::ListMembershipsResponse>
GkeHubTracingStub::ListMemberships(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkehub::v1::ListMembershipsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkehub.v1.GkeHub",
                                     "ListMemberships");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListMemberships(context, options, request));
}

StatusOr<google::cloud::gkehub::v1::ListFeaturesResponse>
GkeHubTracingStub::ListFeatures(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkehub::v1::ListFeaturesRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.gkehub.v1.GkeHub", "ListFeatures");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListFeatures(context, options, request));
}

StatusOr<google::cloud::gkehub::v1::Membership>
GkeHubTracingStub::GetMembership(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkehub::v1::GetMembershipRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.gkehub.v1.GkeHub", "GetMembership");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetMembership(context, options, request));
}

StatusOr<google::cloud::gkehub::v1::Feature> GkeHubTracingStub::GetFeature(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkehub::v1::GetFeatureRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.gkehub.v1.GkeHub", "GetFeature");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetFeature(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
GkeHubTracingStub::AsyncCreateMembership(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkehub::v1::CreateMembershipRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkehub.v1.GkeHub",
                                     "CreateMembership");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateMembership(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> GkeHubTracingStub::CreateMembership(
    grpc::ClientContext& context, Options options,
    google::cloud::gkehub::v1::CreateMembershipRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkehub.v1.GkeHub",
                                     "CreateMembership");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateMembership(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
GkeHubTracingStub::AsyncCreateFeature(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkehub::v1::CreateFeatureRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.gkehub.v1.GkeHub", "CreateFeature");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateFeature(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> GkeHubTracingStub::CreateFeature(
    grpc::ClientContext& context, Options options,
    google::cloud::gkehub::v1::CreateFeatureRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.gkehub.v1.GkeHub", "CreateFeature");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateFeature(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
GkeHubTracingStub::AsyncDeleteMembership(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkehub::v1::DeleteMembershipRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkehub.v1.GkeHub",
                                     "DeleteMembership");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteMembership(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> GkeHubTracingStub::DeleteMembership(
    grpc::ClientContext& context, Options options,
    google::cloud::gkehub::v1::DeleteMembershipRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkehub.v1.GkeHub",
                                     "DeleteMembership");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteMembership(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
GkeHubTracingStub::AsyncDeleteFeature(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkehub::v1::DeleteFeatureRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.gkehub.v1.GkeHub", "DeleteFeature");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteFeature(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> GkeHubTracingStub::DeleteFeature(
    grpc::ClientContext& context, Options options,
    google::cloud::gkehub::v1::DeleteFeatureRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.gkehub.v1.GkeHub", "DeleteFeature");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteFeature(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
GkeHubTracingStub::AsyncUpdateMembership(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkehub::v1::UpdateMembershipRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkehub.v1.GkeHub",
                                     "UpdateMembership");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpdateMembership(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> GkeHubTracingStub::UpdateMembership(
    grpc::ClientContext& context, Options options,
    google::cloud::gkehub::v1::UpdateMembershipRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkehub.v1.GkeHub",
                                     "UpdateMembership");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateMembership(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
GkeHubTracingStub::AsyncUpdateFeature(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkehub::v1::UpdateFeatureRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.gkehub.v1.GkeHub", "UpdateFeature");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateFeature(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> GkeHubTracingStub::UpdateFeature(
    grpc::ClientContext& context, Options options,
    google::cloud::gkehub::v1::UpdateFeatureRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.gkehub.v1.GkeHub", "UpdateFeature");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateFeature(context, options, request));
}

StatusOr<google::cloud::gkehub::v1::GenerateConnectManifestResponse>
GkeHubTracingStub::GenerateConnectManifest(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkehub::v1::GenerateConnectManifestRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkehub.v1.GkeHub",
                                     "GenerateConnectManifest");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->GenerateConnectManifest(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
GkeHubTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> GkeHubTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<GkeHubStub> MakeGkeHubTracingStub(
    std::shared_ptr<GkeHubStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<GkeHubTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkehub_v1_internal
}  // namespace cloud
}  // namespace google
