// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/functions/v2/functions.proto

#include "google/cloud/functions/v2/internal/function_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace functions_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

FunctionServiceTracingStub::FunctionServiceTracingStub(
    std::shared_ptr<FunctionServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::functions::v2::Function>
FunctionServiceTracingStub::GetFunction(
    grpc::ClientContext& context, Options const& options,
    google::cloud::functions::v2::GetFunctionRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.functions.v2.FunctionService", "GetFunction");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetFunction(context, options, request));
}

StatusOr<google::cloud::functions::v2::ListFunctionsResponse>
FunctionServiceTracingStub::ListFunctions(
    grpc::ClientContext& context, Options const& options,
    google::cloud::functions::v2::ListFunctionsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.functions.v2.FunctionService", "ListFunctions");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListFunctions(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
FunctionServiceTracingStub::AsyncCreateFunction(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::functions::v2::CreateFunctionRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.functions.v2.FunctionService", "CreateFunction");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateFunction(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
FunctionServiceTracingStub::CreateFunction(
    grpc::ClientContext& context, Options options,
    google::cloud::functions::v2::CreateFunctionRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.functions.v2.FunctionService", "CreateFunction");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateFunction(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
FunctionServiceTracingStub::AsyncUpdateFunction(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::functions::v2::UpdateFunctionRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.functions.v2.FunctionService", "UpdateFunction");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpdateFunction(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
FunctionServiceTracingStub::UpdateFunction(
    grpc::ClientContext& context, Options options,
    google::cloud::functions::v2::UpdateFunctionRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.functions.v2.FunctionService", "UpdateFunction");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateFunction(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
FunctionServiceTracingStub::AsyncDeleteFunction(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::functions::v2::DeleteFunctionRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.functions.v2.FunctionService", "DeleteFunction");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteFunction(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
FunctionServiceTracingStub::DeleteFunction(
    grpc::ClientContext& context, Options options,
    google::cloud::functions::v2::DeleteFunctionRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.functions.v2.FunctionService", "DeleteFunction");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteFunction(context, options, request));
}

StatusOr<google::cloud::functions::v2::GenerateUploadUrlResponse>
FunctionServiceTracingStub::GenerateUploadUrl(
    grpc::ClientContext& context, Options const& options,
    google::cloud::functions::v2::GenerateUploadUrlRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.functions.v2.FunctionService", "GenerateUploadUrl");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->GenerateUploadUrl(context, options, request));
}

StatusOr<google::cloud::functions::v2::GenerateDownloadUrlResponse>
FunctionServiceTracingStub::GenerateDownloadUrl(
    grpc::ClientContext& context, Options const& options,
    google::cloud::functions::v2::GenerateDownloadUrlRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.functions.v2.FunctionService", "GenerateDownloadUrl");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->GenerateDownloadUrl(context, options, request));
}

StatusOr<google::cloud::functions::v2::ListRuntimesResponse>
FunctionServiceTracingStub::ListRuntimes(
    grpc::ClientContext& context, Options const& options,
    google::cloud::functions::v2::ListRuntimesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.functions.v2.FunctionService", "ListRuntimes");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListRuntimes(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
FunctionServiceTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> FunctionServiceTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<FunctionServiceStub> MakeFunctionServiceTracingStub(
    std::shared_ptr<FunctionServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<FunctionServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace functions_v2_internal
}  // namespace cloud
}  // namespace google
