// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/site_search_engine_service.proto

#include "google/cloud/discoveryengine/v1/internal/site_search_engine_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/discoveryengine/v1/site_search_engine_service.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace discoveryengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SiteSearchEngineServiceMetadata::SiteSearchEngineServiceMetadata(
    std::shared_ptr<SiteSearchEngineServiceStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::discoveryengine::v1::SiteSearchEngine>
SiteSearchEngineServiceMetadata::GetSiteSearchEngine(
    grpc::ClientContext& context, Options const& options,
    google::cloud::discoveryengine::v1::GetSiteSearchEngineRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetSiteSearchEngine(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
SiteSearchEngineServiceMetadata::AsyncCreateTargetSite(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::discoveryengine::v1::CreateTargetSiteRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateTargetSite(cq, std::move(context),
                                       std::move(options), request);
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceMetadata::CreateTargetSite(
    grpc::ClientContext& context, Options options,
    google::cloud::discoveryengine::v1::CreateTargetSiteRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateTargetSite(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
SiteSearchEngineServiceMetadata::AsyncBatchCreateTargetSites(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::discoveryengine::v1::BatchCreateTargetSitesRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncBatchCreateTargetSites(cq, std::move(context),
                                             std::move(options), request);
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceMetadata::BatchCreateTargetSites(
    grpc::ClientContext& context, Options options,
    google::cloud::discoveryengine::v1::BatchCreateTargetSitesRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->BatchCreateTargetSites(context, options, request);
}

StatusOr<google::cloud::discoveryengine::v1::TargetSite>
SiteSearchEngineServiceMetadata::GetTargetSite(
    grpc::ClientContext& context, Options const& options,
    google::cloud::discoveryengine::v1::GetTargetSiteRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetTargetSite(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
SiteSearchEngineServiceMetadata::AsyncUpdateTargetSite(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::discoveryengine::v1::UpdateTargetSiteRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("target_site.name=",
                           internal::UrlEncode(request.target_site().name())));
  return child_->AsyncUpdateTargetSite(cq, std::move(context),
                                       std::move(options), request);
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceMetadata::UpdateTargetSite(
    grpc::ClientContext& context, Options options,
    google::cloud::discoveryengine::v1::UpdateTargetSiteRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("target_site.name=",
                           internal::UrlEncode(request.target_site().name())));
  return child_->UpdateTargetSite(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
SiteSearchEngineServiceMetadata::AsyncDeleteTargetSite(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::discoveryengine::v1::DeleteTargetSiteRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteTargetSite(cq, std::move(context),
                                       std::move(options), request);
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceMetadata::DeleteTargetSite(
    grpc::ClientContext& context, Options options,
    google::cloud::discoveryengine::v1::DeleteTargetSiteRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteTargetSite(context, options, request);
}

StatusOr<google::cloud::discoveryengine::v1::ListTargetSitesResponse>
SiteSearchEngineServiceMetadata::ListTargetSites(
    grpc::ClientContext& context, Options const& options,
    google::cloud::discoveryengine::v1::ListTargetSitesRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListTargetSites(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
SiteSearchEngineServiceMetadata::AsyncEnableAdvancedSiteSearch(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::discoveryengine::v1::EnableAdvancedSiteSearchRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("site_search_engine=",
                           internal::UrlEncode(request.site_search_engine())));
  return child_->AsyncEnableAdvancedSiteSearch(cq, std::move(context),
                                               std::move(options), request);
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceMetadata::EnableAdvancedSiteSearch(
    grpc::ClientContext& context, Options options,
    google::cloud::discoveryengine::v1::EnableAdvancedSiteSearchRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("site_search_engine=",
                           internal::UrlEncode(request.site_search_engine())));
  return child_->EnableAdvancedSiteSearch(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
SiteSearchEngineServiceMetadata::AsyncDisableAdvancedSiteSearch(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::discoveryengine::v1::DisableAdvancedSiteSearchRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("site_search_engine=",
                           internal::UrlEncode(request.site_search_engine())));
  return child_->AsyncDisableAdvancedSiteSearch(cq, std::move(context),
                                                std::move(options), request);
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceMetadata::DisableAdvancedSiteSearch(
    grpc::ClientContext& context, Options options,
    google::cloud::discoveryengine::v1::DisableAdvancedSiteSearchRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("site_search_engine=",
                           internal::UrlEncode(request.site_search_engine())));
  return child_->DisableAdvancedSiteSearch(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
SiteSearchEngineServiceMetadata::AsyncRecrawlUris(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::discoveryengine::v1::RecrawlUrisRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("site_search_engine=",
                           internal::UrlEncode(request.site_search_engine())));
  return child_->AsyncRecrawlUris(cq, std::move(context), std::move(options),
                                  request);
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceMetadata::RecrawlUris(
    grpc::ClientContext& context, Options options,
    google::cloud::discoveryengine::v1::RecrawlUrisRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("site_search_engine=",
                           internal::UrlEncode(request.site_search_engine())));
  return child_->RecrawlUris(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
SiteSearchEngineServiceMetadata::AsyncBatchVerifyTargetSites(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::discoveryengine::v1::BatchVerifyTargetSitesRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncBatchVerifyTargetSites(cq, std::move(context),
                                             std::move(options), request);
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceMetadata::BatchVerifyTargetSites(
    grpc::ClientContext& context, Options options,
    google::cloud::discoveryengine::v1::BatchVerifyTargetSitesRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->BatchVerifyTargetSites(context, options, request);
}

StatusOr<
    google::cloud::discoveryengine::v1::FetchDomainVerificationStatusResponse>
SiteSearchEngineServiceMetadata::FetchDomainVerificationStatus(
    grpc::ClientContext& context, Options const& options,
    google::cloud::discoveryengine::v1::
        FetchDomainVerificationStatusRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("site_search_engine=",
                           internal::UrlEncode(request.site_search_engine())));
  return child_->FetchDomainVerificationStatus(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
SiteSearchEngineServiceMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetOperation(cq, std::move(context), std::move(options),
                                   request);
}

future<Status> SiteSearchEngineServiceMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCancelOperation(cq, std::move(context),
                                      std::move(options), request);
}

void SiteSearchEngineServiceMetadata::SetMetadata(
    grpc::ClientContext& context, Options const& options,
    std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void SiteSearchEngineServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                                  Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1_internal
}  // namespace cloud
}  // namespace google
