// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/datastore/v1/datastore.proto

#include "google/cloud/datastore/v1/internal/datastore_auth_decorator.h"
#include <google/datastore/v1/datastore.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace datastore_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DatastoreAuth::DatastoreAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<DatastoreStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::datastore::v1::LookupResponse> DatastoreAuth::Lookup(
    grpc::ClientContext& context, Options const& options,
    google::datastore::v1::LookupRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->Lookup(context, options, request);
}

StatusOr<google::datastore::v1::RunQueryResponse> DatastoreAuth::RunQuery(
    grpc::ClientContext& context, Options const& options,
    google::datastore::v1::RunQueryRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->RunQuery(context, options, request);
}

StatusOr<google::datastore::v1::RunAggregationQueryResponse>
DatastoreAuth::RunAggregationQuery(
    grpc::ClientContext& context, Options const& options,
    google::datastore::v1::RunAggregationQueryRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->RunAggregationQuery(context, options, request);
}

StatusOr<google::datastore::v1::BeginTransactionResponse>
DatastoreAuth::BeginTransaction(
    grpc::ClientContext& context, Options const& options,
    google::datastore::v1::BeginTransactionRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->BeginTransaction(context, options, request);
}

StatusOr<google::datastore::v1::CommitResponse> DatastoreAuth::Commit(
    grpc::ClientContext& context, Options const& options,
    google::datastore::v1::CommitRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->Commit(context, options, request);
}

StatusOr<google::datastore::v1::RollbackResponse> DatastoreAuth::Rollback(
    grpc::ClientContext& context, Options const& options,
    google::datastore::v1::RollbackRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->Rollback(context, options, request);
}

StatusOr<google::datastore::v1::AllocateIdsResponse> DatastoreAuth::AllocateIds(
    grpc::ClientContext& context, Options const& options,
    google::datastore::v1::AllocateIdsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->AllocateIds(context, options, request);
}

StatusOr<google::datastore::v1::ReserveIdsResponse> DatastoreAuth::ReserveIds(
    grpc::ClientContext& context, Options const& options,
    google::datastore::v1::ReserveIdsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ReserveIds(context, options, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datastore_v1_internal
}  // namespace cloud
}  // namespace google
