// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/datastore/admin/v1/datastore_admin.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATASTORE_ADMIN_V1_INTERNAL_DATASTORE_ADMIN_METADATA_DECORATOR_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATASTORE_ADMIN_V1_INTERNAL_DATASTORE_ADMIN_METADATA_DECORATOR_H

#include "google/cloud/datastore/admin/v1/internal/datastore_admin_stub.h"
#include "google/cloud/options.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace datastore_admin_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class DatastoreAdminMetadata : public DatastoreAdminStub {
 public:
  ~DatastoreAdminMetadata() override = default;
  DatastoreAdminMetadata(std::shared_ptr<DatastoreAdminStub> child,
                         std::multimap<std::string, std::string> fixed_metadata,
                         std::string api_client_header = "");

  future<StatusOr<google::longrunning::Operation>> AsyncExportEntities(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::datastore::admin::v1::ExportEntitiesRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> ExportEntities(
      grpc::ClientContext& context, Options options,
      google::datastore::admin::v1::ExportEntitiesRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncImportEntities(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::datastore::admin::v1::ImportEntitiesRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> ImportEntities(
      grpc::ClientContext& context, Options options,
      google::datastore::admin::v1::ImportEntitiesRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateIndex(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::datastore::admin::v1::CreateIndexRequest const& request) override;

  StatusOr<google::longrunning::Operation> CreateIndex(
      grpc::ClientContext& context, Options options,
      google::datastore::admin::v1::CreateIndexRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteIndex(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::datastore::admin::v1::DeleteIndexRequest const& request) override;

  StatusOr<google::longrunning::Operation> DeleteIndex(
      grpc::ClientContext& context, Options options,
      google::datastore::admin::v1::DeleteIndexRequest const& request) override;

  StatusOr<google::datastore::admin::v1::Index> GetIndex(
      grpc::ClientContext& context, Options const& options,
      google::datastore::admin::v1::GetIndexRequest const& request) override;

  StatusOr<google::datastore::admin::v1::ListIndexesResponse> ListIndexes(
      grpc::ClientContext& context, Options const& options,
      google::datastore::admin::v1::ListIndexesRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::GetOperationRequest const& request) override;

  future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  void SetMetadata(grpc::ClientContext& context, Options const& options,
                   std::string const& request_params);
  void SetMetadata(grpc::ClientContext& context, Options const& options);

  std::shared_ptr<DatastoreAdminStub> child_;
  std::multimap<std::string, std::string> fixed_metadata_;
  std::string api_client_header_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datastore_admin_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATASTORE_ADMIN_V1_INTERNAL_DATASTORE_ADMIN_METADATA_DECORATOR_H
