// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/data_taxonomy.proto

#include "google/cloud/dataplex/v1/data_taxonomy_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace dataplex_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

DataTaxonomyServiceConnectionIdempotencyPolicy::
    ~DataTaxonomyServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<DataTaxonomyServiceConnectionIdempotencyPolicy>
DataTaxonomyServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<DataTaxonomyServiceConnectionIdempotencyPolicy>(
      *this);
}

Idempotency DataTaxonomyServiceConnectionIdempotencyPolicy::CreateDataTaxonomy(
    google::cloud::dataplex::v1::CreateDataTaxonomyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataTaxonomyServiceConnectionIdempotencyPolicy::UpdateDataTaxonomy(
    google::cloud::dataplex::v1::UpdateDataTaxonomyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataTaxonomyServiceConnectionIdempotencyPolicy::DeleteDataTaxonomy(
    google::cloud::dataplex::v1::DeleteDataTaxonomyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataTaxonomyServiceConnectionIdempotencyPolicy::ListDataTaxonomies(
    google::cloud::dataplex::v1::ListDataTaxonomiesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency DataTaxonomyServiceConnectionIdempotencyPolicy::GetDataTaxonomy(
    google::cloud::dataplex::v1::GetDataTaxonomyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
DataTaxonomyServiceConnectionIdempotencyPolicy::CreateDataAttributeBinding(
    google::cloud::dataplex::v1::CreateDataAttributeBindingRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
DataTaxonomyServiceConnectionIdempotencyPolicy::UpdateDataAttributeBinding(
    google::cloud::dataplex::v1::UpdateDataAttributeBindingRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
DataTaxonomyServiceConnectionIdempotencyPolicy::DeleteDataAttributeBinding(
    google::cloud::dataplex::v1::DeleteDataAttributeBindingRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
DataTaxonomyServiceConnectionIdempotencyPolicy::ListDataAttributeBindings(
    google::cloud::dataplex::v1::ListDataAttributeBindingsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
DataTaxonomyServiceConnectionIdempotencyPolicy::GetDataAttributeBinding(
    google::cloud::dataplex::v1::GetDataAttributeBindingRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DataTaxonomyServiceConnectionIdempotencyPolicy::CreateDataAttribute(
    google::cloud::dataplex::v1::CreateDataAttributeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataTaxonomyServiceConnectionIdempotencyPolicy::UpdateDataAttribute(
    google::cloud::dataplex::v1::UpdateDataAttributeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataTaxonomyServiceConnectionIdempotencyPolicy::DeleteDataAttribute(
    google::cloud::dataplex::v1::DeleteDataAttributeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataTaxonomyServiceConnectionIdempotencyPolicy::ListDataAttributes(
    google::cloud::dataplex::v1::ListDataAttributesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency DataTaxonomyServiceConnectionIdempotencyPolicy::GetDataAttribute(
    google::cloud::dataplex::v1::GetDataAttributeRequest const&) {
  return Idempotency::kIdempotent;
}

std::unique_ptr<DataTaxonomyServiceConnectionIdempotencyPolicy>
MakeDefaultDataTaxonomyServiceConnectionIdempotencyPolicy() {
  return std::make_unique<DataTaxonomyServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1
}  // namespace cloud
}  // namespace google
