// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/clouddms/v1/clouddms.proto

#include "google/cloud/datamigration/v1/internal/data_migration_option_defaults.h"
#include "google/cloud/datamigration/v1/data_migration_connection.h"
#include "google/cloud/datamigration/v1/data_migration_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace datamigration_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options DataMigrationServiceDefaultOptions(Options options) {
  options = internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_DATA_MIGRATION_SERVICE_ENDPOINT",
      "", "GOOGLE_CLOUD_CPP_DATA_MIGRATION_SERVICE_AUTHORITY",
      "datamigration.googleapis.com");
  options = internal::PopulateGrpcOptions(std::move(options));
  if (!options.has<datamigration_v1::DataMigrationServiceRetryPolicyOption>()) {
    options.set<datamigration_v1::DataMigrationServiceRetryPolicyOption>(
        datamigration_v1::DataMigrationServiceLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options
           .has<datamigration_v1::DataMigrationServiceBackoffPolicyOption>()) {
    options.set<datamigration_v1::DataMigrationServiceBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options
           .has<datamigration_v1::DataMigrationServicePollingPolicyOption>()) {
    options.set<datamigration_v1::DataMigrationServicePollingPolicyOption>(
        GenericPollingPolicy<
            datamigration_v1::DataMigrationServiceRetryPolicyOption::Type,
            datamigration_v1::DataMigrationServiceBackoffPolicyOption::Type>(
            options
                .get<datamigration_v1::DataMigrationServiceRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options
           .has<datamigration_v1::
                    DataMigrationServiceConnectionIdempotencyPolicyOption>()) {
    options.set<datamigration_v1::
                    DataMigrationServiceConnectionIdempotencyPolicyOption>(
        datamigration_v1::
            MakeDefaultDataMigrationServiceConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datamigration_v1_internal
}  // namespace cloud
}  // namespace google
