// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contactcenterinsights/v1/contact_center_insights.proto

#include "google/cloud/contactcenterinsights/v1/internal/contact_center_insights_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace contactcenterinsights_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ContactCenterInsightsTracingConnection::ContactCenterInsightsTracingConnection(
    std::shared_ptr<contactcenterinsights_v1::ContactCenterInsightsConnection>
        child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::contactcenterinsights::v1::Conversation>
ContactCenterInsightsTracingConnection::CreateConversation(
    google::cloud::contactcenterinsights::v1::CreateConversationRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "CreateConversation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateConversation(request));
}

future<StatusOr<google::cloud::contactcenterinsights::v1::Conversation>>
ContactCenterInsightsTracingConnection::UploadConversation(
    google::cloud::contactcenterinsights::v1::UploadConversationRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "UploadConversation");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UploadConversation(request));
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsTracingConnection::UploadConversation(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::UploadConversationRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "UploadConversation");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UploadConversation(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::contactcenterinsights::v1::Conversation>>
ContactCenterInsightsTracingConnection::UploadConversation(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "UploadConversation");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UploadConversation(operation));
}

StatusOr<google::cloud::contactcenterinsights::v1::Conversation>
ContactCenterInsightsTracingConnection::UpdateConversation(
    google::cloud::contactcenterinsights::v1::UpdateConversationRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "UpdateConversation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateConversation(request));
}

StatusOr<google::cloud::contactcenterinsights::v1::Conversation>
ContactCenterInsightsTracingConnection::GetConversation(
    google::cloud::contactcenterinsights::v1::GetConversationRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "GetConversation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetConversation(request));
}

StreamRange<google::cloud::contactcenterinsights::v1::Conversation>
ContactCenterInsightsTracingConnection::ListConversations(
    google::cloud::contactcenterinsights::v1::ListConversationsRequest
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "ListConversations");
  internal::OTelScope scope(span);
  auto sr = child_->ListConversations(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::contactcenterinsights::v1::Conversation>(std::move(span),
                                                              std::move(sr));
}

Status ContactCenterInsightsTracingConnection::DeleteConversation(
    google::cloud::contactcenterinsights::v1::DeleteConversationRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "DeleteConversation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteConversation(request));
}

future<StatusOr<google::cloud::contactcenterinsights::v1::Analysis>>
ContactCenterInsightsTracingConnection::CreateAnalysis(
    google::cloud::contactcenterinsights::v1::CreateAnalysisRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "CreateAnalysis");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateAnalysis(request));
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsTracingConnection::CreateAnalysis(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::CreateAnalysisRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "CreateAnalysis");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateAnalysis(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::contactcenterinsights::v1::Analysis>>
ContactCenterInsightsTracingConnection::CreateAnalysis(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "CreateAnalysis");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateAnalysis(operation));
}

StatusOr<google::cloud::contactcenterinsights::v1::Analysis>
ContactCenterInsightsTracingConnection::GetAnalysis(
    google::cloud::contactcenterinsights::v1::GetAnalysisRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::GetAnalysis");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetAnalysis(request));
}

StreamRange<google::cloud::contactcenterinsights::v1::Analysis>
ContactCenterInsightsTracingConnection::ListAnalyses(
    google::cloud::contactcenterinsights::v1::ListAnalysesRequest request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "ListAnalyses");
  internal::OTelScope scope(span);
  auto sr = child_->ListAnalyses(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::contactcenterinsights::v1::Analysis>(std::move(span),
                                                          std::move(sr));
}

Status ContactCenterInsightsTracingConnection::DeleteAnalysis(
    google::cloud::contactcenterinsights::v1::DeleteAnalysisRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "DeleteAnalysis");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteAnalysis(request));
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::BulkAnalyzeConversationsResponse>>
ContactCenterInsightsTracingConnection::BulkAnalyzeConversations(
    google::cloud::contactcenterinsights::v1::
        BulkAnalyzeConversationsRequest const& request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "BulkAnalyzeConversations");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->BulkAnalyzeConversations(request));
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsTracingConnection::BulkAnalyzeConversations(
    NoAwaitTag, google::cloud::contactcenterinsights::v1::
                    BulkAnalyzeConversationsRequest const& request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "BulkAnalyzeConversations");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->BulkAnalyzeConversations(NoAwaitTag{}, request));
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::BulkAnalyzeConversationsResponse>>
ContactCenterInsightsTracingConnection::BulkAnalyzeConversations(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "BulkAnalyzeConversations");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->BulkAnalyzeConversations(operation));
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::BulkDeleteConversationsResponse>>
ContactCenterInsightsTracingConnection::BulkDeleteConversations(
    google::cloud::contactcenterinsights::v1::
        BulkDeleteConversationsRequest const& request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "BulkDeleteConversations");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->BulkDeleteConversations(request));
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsTracingConnection::BulkDeleteConversations(
    NoAwaitTag, google::cloud::contactcenterinsights::v1::
                    BulkDeleteConversationsRequest const& request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "BulkDeleteConversations");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->BulkDeleteConversations(NoAwaitTag{}, request));
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::BulkDeleteConversationsResponse>>
ContactCenterInsightsTracingConnection::BulkDeleteConversations(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "BulkDeleteConversations");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->BulkDeleteConversations(operation));
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::IngestConversationsResponse>>
ContactCenterInsightsTracingConnection::IngestConversations(
    google::cloud::contactcenterinsights::v1::IngestConversationsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "IngestConversations");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->IngestConversations(request));
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsTracingConnection::IngestConversations(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::IngestConversationsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "IngestConversations");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->IngestConversations(NoAwaitTag{}, request));
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::IngestConversationsResponse>>
ContactCenterInsightsTracingConnection::IngestConversations(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "IngestConversations");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->IngestConversations(operation));
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::ExportInsightsDataResponse>>
ContactCenterInsightsTracingConnection::ExportInsightsData(
    google::cloud::contactcenterinsights::v1::ExportInsightsDataRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "ExportInsightsData");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->ExportInsightsData(request));
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsTracingConnection::ExportInsightsData(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::ExportInsightsDataRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "ExportInsightsData");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->ExportInsightsData(NoAwaitTag{}, request));
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::ExportInsightsDataResponse>>
ContactCenterInsightsTracingConnection::ExportInsightsData(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "ExportInsightsData");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->ExportInsightsData(operation));
}

future<StatusOr<google::cloud::contactcenterinsights::v1::IssueModel>>
ContactCenterInsightsTracingConnection::CreateIssueModel(
    google::cloud::contactcenterinsights::v1::CreateIssueModelRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "CreateIssueModel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateIssueModel(request));
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsTracingConnection::CreateIssueModel(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::CreateIssueModelRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "CreateIssueModel");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateIssueModel(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::contactcenterinsights::v1::IssueModel>>
ContactCenterInsightsTracingConnection::CreateIssueModel(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "CreateIssueModel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateIssueModel(operation));
}

StatusOr<google::cloud::contactcenterinsights::v1::IssueModel>
ContactCenterInsightsTracingConnection::UpdateIssueModel(
    google::cloud::contactcenterinsights::v1::UpdateIssueModelRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "UpdateIssueModel");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateIssueModel(request));
}

StatusOr<google::cloud::contactcenterinsights::v1::IssueModel>
ContactCenterInsightsTracingConnection::GetIssueModel(
    google::cloud::contactcenterinsights::v1::GetIssueModelRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "GetIssueModel");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIssueModel(request));
}

StatusOr<google::cloud::contactcenterinsights::v1::ListIssueModelsResponse>
ContactCenterInsightsTracingConnection::ListIssueModels(
    google::cloud::contactcenterinsights::v1::ListIssueModelsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "ListIssueModels");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ListIssueModels(request));
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::DeleteIssueModelMetadata>>
ContactCenterInsightsTracingConnection::DeleteIssueModel(
    google::cloud::contactcenterinsights::v1::DeleteIssueModelRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "DeleteIssueModel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteIssueModel(request));
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsTracingConnection::DeleteIssueModel(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::DeleteIssueModelRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "DeleteIssueModel");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteIssueModel(NoAwaitTag{}, request));
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::DeleteIssueModelMetadata>>
ContactCenterInsightsTracingConnection::DeleteIssueModel(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "DeleteIssueModel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteIssueModel(operation));
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::DeployIssueModelResponse>>
ContactCenterInsightsTracingConnection::DeployIssueModel(
    google::cloud::contactcenterinsights::v1::DeployIssueModelRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "DeployIssueModel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeployIssueModel(request));
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsTracingConnection::DeployIssueModel(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::DeployIssueModelRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "DeployIssueModel");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeployIssueModel(NoAwaitTag{}, request));
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::DeployIssueModelResponse>>
ContactCenterInsightsTracingConnection::DeployIssueModel(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "DeployIssueModel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeployIssueModel(operation));
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::UndeployIssueModelResponse>>
ContactCenterInsightsTracingConnection::UndeployIssueModel(
    google::cloud::contactcenterinsights::v1::UndeployIssueModelRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "UndeployIssueModel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UndeployIssueModel(request));
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsTracingConnection::UndeployIssueModel(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::UndeployIssueModelRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "UndeployIssueModel");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UndeployIssueModel(NoAwaitTag{}, request));
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::UndeployIssueModelResponse>>
ContactCenterInsightsTracingConnection::UndeployIssueModel(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "UndeployIssueModel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UndeployIssueModel(operation));
}

StatusOr<google::cloud::contactcenterinsights::v1::Issue>
ContactCenterInsightsTracingConnection::GetIssue(
    google::cloud::contactcenterinsights::v1::GetIssueRequest const& request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::GetIssue");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIssue(request));
}

StatusOr<google::cloud::contactcenterinsights::v1::ListIssuesResponse>
ContactCenterInsightsTracingConnection::ListIssues(
    google::cloud::contactcenterinsights::v1::ListIssuesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::ListIssues");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ListIssues(request));
}

StatusOr<google::cloud::contactcenterinsights::v1::Issue>
ContactCenterInsightsTracingConnection::UpdateIssue(
    google::cloud::contactcenterinsights::v1::UpdateIssueRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::UpdateIssue");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateIssue(request));
}

Status ContactCenterInsightsTracingConnection::DeleteIssue(
    google::cloud::contactcenterinsights::v1::DeleteIssueRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::DeleteIssue");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteIssue(request));
}

StatusOr<
    google::cloud::contactcenterinsights::v1::CalculateIssueModelStatsResponse>
ContactCenterInsightsTracingConnection::CalculateIssueModelStats(
    google::cloud::contactcenterinsights::v1::
        CalculateIssueModelStatsRequest const& request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "CalculateIssueModelStats");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CalculateIssueModelStats(request));
}

StatusOr<google::cloud::contactcenterinsights::v1::PhraseMatcher>
ContactCenterInsightsTracingConnection::CreatePhraseMatcher(
    google::cloud::contactcenterinsights::v1::CreatePhraseMatcherRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "CreatePhraseMatcher");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreatePhraseMatcher(request));
}

StatusOr<google::cloud::contactcenterinsights::v1::PhraseMatcher>
ContactCenterInsightsTracingConnection::GetPhraseMatcher(
    google::cloud::contactcenterinsights::v1::GetPhraseMatcherRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "GetPhraseMatcher");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetPhraseMatcher(request));
}

StreamRange<google::cloud::contactcenterinsights::v1::PhraseMatcher>
ContactCenterInsightsTracingConnection::ListPhraseMatchers(
    google::cloud::contactcenterinsights::v1::ListPhraseMatchersRequest
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "ListPhraseMatchers");
  internal::OTelScope scope(span);
  auto sr = child_->ListPhraseMatchers(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::contactcenterinsights::v1::PhraseMatcher>(std::move(span),
                                                               std::move(sr));
}

Status ContactCenterInsightsTracingConnection::DeletePhraseMatcher(
    google::cloud::contactcenterinsights::v1::DeletePhraseMatcherRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "DeletePhraseMatcher");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeletePhraseMatcher(request));
}

StatusOr<google::cloud::contactcenterinsights::v1::PhraseMatcher>
ContactCenterInsightsTracingConnection::UpdatePhraseMatcher(
    google::cloud::contactcenterinsights::v1::UpdatePhraseMatcherRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "UpdatePhraseMatcher");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdatePhraseMatcher(request));
}

StatusOr<google::cloud::contactcenterinsights::v1::CalculateStatsResponse>
ContactCenterInsightsTracingConnection::CalculateStats(
    google::cloud::contactcenterinsights::v1::CalculateStatsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "CalculateStats");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CalculateStats(request));
}

StatusOr<google::cloud::contactcenterinsights::v1::Settings>
ContactCenterInsightsTracingConnection::GetSettings(
    google::cloud::contactcenterinsights::v1::GetSettingsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::GetSettings");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetSettings(request));
}

StatusOr<google::cloud::contactcenterinsights::v1::Settings>
ContactCenterInsightsTracingConnection::UpdateSettings(
    google::cloud::contactcenterinsights::v1::UpdateSettingsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::"
      "UpdateSettings");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateSettings(request));
}

StatusOr<google::cloud::contactcenterinsights::v1::View>
ContactCenterInsightsTracingConnection::CreateView(
    google::cloud::contactcenterinsights::v1::CreateViewRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::CreateView");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateView(request));
}

StatusOr<google::cloud::contactcenterinsights::v1::View>
ContactCenterInsightsTracingConnection::GetView(
    google::cloud::contactcenterinsights::v1::GetViewRequest const& request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::GetView");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetView(request));
}

StreamRange<google::cloud::contactcenterinsights::v1::View>
ContactCenterInsightsTracingConnection::ListViews(
    google::cloud::contactcenterinsights::v1::ListViewsRequest request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::ListViews");
  internal::OTelScope scope(span);
  auto sr = child_->ListViews(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::contactcenterinsights::v1::View>(std::move(span),
                                                      std::move(sr));
}

StatusOr<google::cloud::contactcenterinsights::v1::View>
ContactCenterInsightsTracingConnection::UpdateView(
    google::cloud::contactcenterinsights::v1::UpdateViewRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::UpdateView");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateView(request));
}

Status ContactCenterInsightsTracingConnection::DeleteView(
    google::cloud::contactcenterinsights::v1::DeleteViewRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contactcenterinsights_v1::ContactCenterInsightsConnection::DeleteView");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteView(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<contactcenterinsights_v1::ContactCenterInsightsConnection>
MakeContactCenterInsightsTracingConnection(
    std::shared_ptr<contactcenterinsights_v1::ContactCenterInsightsConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<ContactCenterInsightsTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contactcenterinsights_v1_internal
}  // namespace cloud
}  // namespace google
