// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/url_maps/v1/url_maps.proto

#include "google/cloud/compute/url_maps/v1/internal/url_maps_rest_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_url_maps_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

UrlMapsRestLogging::UrlMapsRestLogging(std::shared_ptr<UrlMapsRestStub> child,
                                       TracingOptions tracing_options,
                                       std::set<std::string> components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      components_(std::move(components)) {}

StatusOr<google::cloud::cpp::compute::v1::UrlMapsAggregatedList>
UrlMapsRestLogging::AggregatedListUrlMaps(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::url_maps::v1::
        AggregatedListUrlMapsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::cpp::compute::url_maps::v1::
                 AggregatedListUrlMapsRequest const& request) {
        return child_->AggregatedListUrlMaps(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
UrlMapsRestLogging::AsyncDeleteUrlMap(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::url_maps::v1::DeleteUrlMapRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          CompletionQueue& cq,
          std::unique_ptr<rest_internal::RestContext> rest_context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::cpp::compute::url_maps::v1::DeleteUrlMapRequest const&
              request) {
        return child_->AsyncDeleteUrlMap(cq, std::move(rest_context),
                                         std::move(options), request);
      },
      cq, std::move(rest_context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
UrlMapsRestLogging::DeleteUrlMap(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::url_maps::v1::DeleteUrlMapRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          rest_internal::RestContext& rest_context, Options const& options,
          google::cloud::cpp::compute::url_maps::v1::DeleteUrlMapRequest const&
              request) {
        return child_->DeleteUrlMap(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::cpp::compute::v1::UrlMap> UrlMapsRestLogging::GetUrlMap(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::url_maps::v1::GetUrlMapRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::cpp::compute::url_maps::v1::GetUrlMapRequest const&
                 request) {
        return child_->GetUrlMap(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
UrlMapsRestLogging::AsyncInsertUrlMap(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::url_maps::v1::InsertUrlMapRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          CompletionQueue& cq,
          std::unique_ptr<rest_internal::RestContext> rest_context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::cpp::compute::url_maps::v1::InsertUrlMapRequest const&
              request) {
        return child_->AsyncInsertUrlMap(cq, std::move(rest_context),
                                         std::move(options), request);
      },
      cq, std::move(rest_context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
UrlMapsRestLogging::InsertUrlMap(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::url_maps::v1::InsertUrlMapRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          rest_internal::RestContext& rest_context, Options const& options,
          google::cloud::cpp::compute::url_maps::v1::InsertUrlMapRequest const&
              request) {
        return child_->InsertUrlMap(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
UrlMapsRestLogging::AsyncInvalidateCache(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::url_maps::v1::InvalidateCacheRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](CompletionQueue& cq,
             std::unique_ptr<rest_internal::RestContext> rest_context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::cpp::compute::url_maps::v1::
                 InvalidateCacheRequest const& request) {
        return child_->AsyncInvalidateCache(cq, std::move(rest_context),
                                            std::move(options), request);
      },
      cq, std::move(rest_context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
UrlMapsRestLogging::InvalidateCache(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::url_maps::v1::InvalidateCacheRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::cpp::compute::url_maps::v1::
                 InvalidateCacheRequest const& request) {
        return child_->InvalidateCache(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::cpp::compute::v1::UrlMapList>
UrlMapsRestLogging::ListUrlMaps(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::url_maps::v1::ListUrlMapsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          rest_internal::RestContext& rest_context, Options const& options,
          google::cloud::cpp::compute::url_maps::v1::ListUrlMapsRequest const&
              request) {
        return child_->ListUrlMaps(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
UrlMapsRestLogging::AsyncPatchUrlMap(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::url_maps::v1::PatchUrlMapRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          CompletionQueue& cq,
          std::unique_ptr<rest_internal::RestContext> rest_context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::cpp::compute::url_maps::v1::PatchUrlMapRequest const&
              request) {
        return child_->AsyncPatchUrlMap(cq, std::move(rest_context),
                                        std::move(options), request);
      },
      cq, std::move(rest_context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
UrlMapsRestLogging::PatchUrlMap(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::url_maps::v1::PatchUrlMapRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          rest_internal::RestContext& rest_context, Options const& options,
          google::cloud::cpp::compute::url_maps::v1::PatchUrlMapRequest const&
              request) {
        return child_->PatchUrlMap(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
UrlMapsRestLogging::AsyncUpdateUrlMap(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::url_maps::v1::UpdateUrlMapRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          CompletionQueue& cq,
          std::unique_ptr<rest_internal::RestContext> rest_context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::cpp::compute::url_maps::v1::UpdateUrlMapRequest const&
              request) {
        return child_->AsyncUpdateUrlMap(cq, std::move(rest_context),
                                         std::move(options), request);
      },
      cq, std::move(rest_context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
UrlMapsRestLogging::UpdateUrlMap(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::url_maps::v1::UpdateUrlMapRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          rest_internal::RestContext& rest_context, Options const& options,
          google::cloud::cpp::compute::url_maps::v1::UpdateUrlMapRequest const&
              request) {
        return child_->UpdateUrlMap(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::cpp::compute::v1::UrlMapsValidateResponse>
UrlMapsRestLogging::Validate(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::url_maps::v1::ValidateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::cpp::compute::url_maps::v1::ValidateRequest const&
                 request) {
        return child_->Validate(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
UrlMapsRestLogging::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::global_operations::v1::
        GetOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](CompletionQueue& cq,
             std::unique_ptr<rest_internal::RestContext> rest_context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::cpp::compute::global_operations::v1::
                 GetOperationRequest const& request) {
        return child_->AsyncGetOperation(cq, std::move(rest_context),
                                         std::move(options), request);
      },
      cq, std::move(rest_context), std::move(options), request, __func__,
      tracing_options_);
}

future<Status> UrlMapsRestLogging::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::global_operations::v1::
        DeleteOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](CompletionQueue& cq,
             std::unique_ptr<rest_internal::RestContext> rest_context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::cpp::compute::global_operations::v1::
                 DeleteOperationRequest const& request) {
        return child_->AsyncCancelOperation(cq, std::move(rest_context),
                                            std::move(options), request);
      },
      cq, std::move(rest_context), std::move(options), request, __func__,
      tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_url_maps_v1_internal
}  // namespace cloud
}  // namespace google
