// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/routes/v1/routes.proto

#include "google/cloud/compute/routes/v1/routes_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_routes_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RoutesClient::RoutesClient(std::shared_ptr<RoutesConnection> connection,
                           Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
RoutesClient::~RoutesClient() = default;

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RoutesClient::DeleteRoute(std::string const& project, std::string const& route,
                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::routes::v1::DeleteRouteRequest request;
  request.set_project(project);
  request.set_route(route);
  return connection_->DeleteRoute(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation> RoutesClient::DeleteRoute(
    NoAwaitTag, std::string const& project, std::string const& route,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::routes::v1::DeleteRouteRequest request;
  request.set_project(project);
  request.set_route(route);
  return connection_->DeleteRoute(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RoutesClient::DeleteRoute(
    google::cloud::cpp::compute::routes::v1::DeleteRouteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteRoute(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation> RoutesClient::DeleteRoute(
    NoAwaitTag,
    google::cloud::cpp::compute::routes::v1::DeleteRouteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteRoute(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RoutesClient::DeleteRoute(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteRoute(operation);
}

StatusOr<google::cloud::cpp::compute::v1::Route> RoutesClient::GetRoute(
    std::string const& project, std::string const& route, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::routes::v1::GetRouteRequest request;
  request.set_project(project);
  request.set_route(route);
  return connection_->GetRoute(request);
}

StatusOr<google::cloud::cpp::compute::v1::Route> RoutesClient::GetRoute(
    google::cloud::cpp::compute::routes::v1::GetRouteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetRoute(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RoutesClient::InsertRoute(
    std::string const& project,
    google::cloud::cpp::compute::v1::Route const& route_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::routes::v1::InsertRouteRequest request;
  request.set_project(project);
  *request.mutable_route_resource() = route_resource;
  return connection_->InsertRoute(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation> RoutesClient::InsertRoute(
    NoAwaitTag, std::string const& project,
    google::cloud::cpp::compute::v1::Route const& route_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::routes::v1::InsertRouteRequest request;
  request.set_project(project);
  *request.mutable_route_resource() = route_resource;
  return connection_->InsertRoute(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RoutesClient::InsertRoute(
    google::cloud::cpp::compute::routes::v1::InsertRouteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertRoute(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation> RoutesClient::InsertRoute(
    NoAwaitTag,
    google::cloud::cpp::compute::routes::v1::InsertRouteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertRoute(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RoutesClient::InsertRoute(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertRoute(operation);
}

StreamRange<google::cloud::cpp::compute::v1::Route> RoutesClient::ListRoutes(
    std::string const& project, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::routes::v1::ListRoutesRequest request;
  request.set_project(project);
  return connection_->ListRoutes(request);
}

StreamRange<google::cloud::cpp::compute::v1::Route> RoutesClient::ListRoutes(
    google::cloud::cpp::compute::routes::v1::ListRoutesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListRoutes(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_routes_v1
}  // namespace cloud
}  // namespace google
